/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.monitor;

import org.apache.log4j.Logger;
import org.openspcoop.pdd.config.ClassNameProperties;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.monitor.INotificaTempiAttraversamentoPdD;
import org.openspcoop.pdd.monitor.InfoAttraversamentoPdD;

public class NotificaTempiAttraversamentoPdDUtility {
    private static INotificaTempiAttraversamentoPdD[] classAttraversamentoPdD = null;
    private static String[] tipiAttraversamentoPdD = null;
    private static boolean initializeNotificaTempiAttraversamentoPdD = false;
    private static Logger log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();

    private static synchronized void initialize(MsgDiagnostico msgDiag) {
        if (!initializeNotificaTempiAttraversamentoPdD && (tipiAttraversamentoPdD = OpenSPCoopProperties.getInstance().getTipiMisurazioneTempiAttraversamentoPdD()) != null) {
            classAttraversamentoPdD = new INotificaTempiAttraversamentoPdD[tipiAttraversamentoPdD.length];
            for (int i = 0; i < tipiAttraversamentoPdD.length; ++i) {
                try {
                    String tipo = tipiAttraversamentoPdD[i];
                    String classe = ClassNameProperties.getInstance().getNotificaTempiAttraversamentoPdD(tipo);
                    Class<?> c = Class.forName(classe);
                    NotificaTempiAttraversamentoPdDUtility.classAttraversamentoPdD[i] = (INotificaTempiAttraversamentoPdD)c.newInstance();
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)("Inizializzazione classe Notifica tempi attraversamento PdD con tipo [" + tipiAttraversamentoPdD[i] + "] non riuscita"), (Throwable)e);
                    msgDiag.errorOpenSPCoop("Inizializzazione classe Notifica tempi attraversamento PdD con tipo [" + tipiAttraversamentoPdD[i] + "] non riuscita: " + e.getMessage());
                }
            }
        }
        initializeNotificaTempiAttraversamentoPdD = true;
    }

    public static void notifica(InfoAttraversamentoPdD info, MsgDiagnostico msgDiag) {
        if (!initializeNotificaTempiAttraversamentoPdD) {
            NotificaTempiAttraversamentoPdDUtility.initialize(msgDiag);
        }
        if (classAttraversamentoPdD != null) {
            for (int i = 0; i < classAttraversamentoPdD.length; ++i) {
                try {
                    classAttraversamentoPdD[i].notifica(info);
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)("Notifica tempi attraversamento PdD con tipo [" + tipiAttraversamentoPdD[i] + "] non riuscita"), (Throwable)e);
                    msgDiag.errorOpenSPCoop("Notifica tempi attraversamento PdD con tipo [" + tipiAttraversamentoPdD[i] + "] non riuscita: " + e.getMessage());
                }
            }
        }
    }
}

