/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.monitor;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.monitor.INotificaTempiAttraversamentoPdD;
import org.openspcoop.pdd.monitor.InfoAttraversamentoPdD;
import org.openspcoop.pdd.monitor.NotificaTempiAttraversamentoPdDException;
import org.openspcoop.pdd.monitor.TipoPdD;
import org.openspcoop.utils.Utilities;

public class NotificaTempiAttraversamentoPdD
implements INotificaTempiAttraversamentoPdD {
    public void notifica(InfoAttraversamentoPdD info) throws NotificaTempiAttraversamentoPdDException {
        long latenzaPercorrenzaIngressoMessaggio;
        long spedizioneIngressoMessaggio;
        long ricezioneIngressoMessaggio;
        Logger log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        StringBuffer bf = new StringBuffer();
        if (info == null) {
            throw new NotificaTempiAttraversamentoPdDException("InfoAttraversamentoPdD is null");
        }
        if (info.getTipoPorta().equals((Object)TipoPdD.DELEGATA)) {
            bf.append("PdD[Delegata] ");
        } else if (info.getTipoPorta().equals((Object)TipoPdD.APPLICATIVA)) {
            bf.append("PdD[Applicativa] ");
        } else {
            bf.append("PdD[Router] ");
        }
        if (info.isStato()) {
            bf.append(" OK ");
        } else {
            bf.append(" ERROR ");
        }
        bf.append(info.getSoggettoFruitore().toString());
        bf.append(" -> ");
        bf.append(info.getSoggettoErogatore().toString() + "-" + info.getTipoServizio() + info.getServizio());
        if (info.getAzione() != null) {
            bf.append("-" + info.getAzione());
        }
        if (info.getProfiloCollaborazione() != null) {
            bf.append(" (" + info.getProfiloCollaborazione() + ")");
        }
        bf.append(" IDEGovRichiesta[" + info.getIdMessaggioIniziale() + "]");
        if (info.getIdMessaggioRitorno() != null) {
            bf.append(" IDEGovRisposta[" + info.getIdMessaggioRitorno() + "]");
        }
        if (info.getIdCorrelazione() != null) {
            bf.append(" Correlazione[" + info.getIdCorrelazione() + "]");
        }
        if (info.getTimeStamp1() != null) {
            bf.append(" Tempo Ricezione Richiesta [" + this.convertToString(info.getTimeStamp1()) + "]");
        }
        if (info.getTimeStamp2() != null) {
            bf.append(" Tempo Invio Richiesta [" + this.convertToString(info.getTimeStamp2()) + "]");
        }
        if (info.getTimeStamp1() != null && info.getTimeStamp2() != null) {
            ricezioneIngressoMessaggio = info.getTimeStamp1().getTime();
            spedizioneIngressoMessaggio = info.getTimeStamp2().getTime();
            latenzaPercorrenzaIngressoMessaggio = spedizioneIngressoMessaggio - ricezioneIngressoMessaggio;
            bf.append(" LatenzaMessaggioIngresso[ " + Utilities.convertSystemTimeIntoString_millisecondi((long)latenzaPercorrenzaIngressoMessaggio, (boolean)true) + " ]");
        }
        if (info.getTimeStamp3() != null) {
            bf.append(" Tempo Ricezione Risposta [" + this.convertToString(info.getTimeStamp3()) + "]");
        }
        if (info.getTimeStamp4() != null) {
            bf.append(" Tempo Invio Risposta [" + this.convertToString(info.getTimeStamp4()) + "]");
        }
        if (info.getTimeStamp3() != null && info.getTimeStamp4() != null) {
            ricezioneIngressoMessaggio = info.getTimeStamp3().getTime();
            spedizioneIngressoMessaggio = info.getTimeStamp4().getTime();
            latenzaPercorrenzaIngressoMessaggio = spedizioneIngressoMessaggio - ricezioneIngressoMessaggio;
            bf.append(" LatenzaMessaggioRisposta[ " + Utilities.convertSystemTimeIntoString_millisecondi((long)latenzaPercorrenzaIngressoMessaggio, (boolean)true) + " ]");
        }
        log.info((Object)("NotificaTempiAttraversamentoPdD: " + bf.toString()));
    }

    public String convertToString(Date d) {
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return dateformat.format(d);
    }
}

