/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.monitor;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.openspcoop.pdd.monitor.DriverMonitoraggioException;
import org.openspcoop.pdd.monitor.IDriverMonitoraggio;
import org.openspcoop.pdd.monitor.dto.Dettaglio;
import org.openspcoop.pdd.monitor.dto.Egov;
import org.openspcoop.pdd.monitor.dto.FilterSearch;
import org.openspcoop.pdd.monitor.dto.ListaMessaggi;
import org.openspcoop.pdd.monitor.dto.Messaggio;
import org.openspcoop.pdd.monitor.dto.Servizio;
import org.openspcoop.pdd.monitor.dto.ServizioApplicativoConsegna;
import org.openspcoop.pdd.monitor.dto.Soggetto;
import org.openspcoop.pdd.monitor.dto.StatoMessaggio;
import org.openspcoop.pdd.monitor.dto.StatoPdD;
import org.openspcoop.utils.date.DateManager;
import org.openspcoop.utils.sql.ISQLQueryObject;
import org.openspcoop.utils.sql.SQLObjectFactory;
import org.openspcoop.utils.sql.SQLQueryObjectException;

public class DriverMonitoraggio
implements IDriverMonitoraggio {
    DataSource datasource = null;
    String tipoDatabase = null;
    private Logger log = null;

    public DriverMonitoraggio(String nomeDataSource, String tipoDatabase, Properties prop) throws DriverMonitoraggioException {
        this(nomeDataSource, tipoDatabase, prop, null);
    }

    public DriverMonitoraggio(String nomeDataSource, String tipoDatabase, Properties prop, Logger log) throws DriverMonitoraggioException {
        try {
            this.log = log == null ? Logger.getLogger((String)"DRIVER_DB_MONITORAGGIO") : log;
        }
        catch (Exception e) {
            throw new DriverMonitoraggioException("Errore durante l'inizializzazione del logger...", e);
        }
        try {
            this.log.info((Object)"Inizializzo DriverMonitoraggioDB...");
            InitialContext initCtx = new InitialContext(prop);
            this.datasource = (DataSource)initCtx.lookup(nomeDataSource);
            if (this.datasource == null) {
                throw new Exception("datasource is null");
            }
            initCtx.close();
            this.log.info((Object)"Inizializzo DriverMonitoraggioDB terminata.");
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante la ricerca del datasource...", (Throwable)e);
            throw new DriverMonitoraggioException("Errore durante la ricerca del datasource...", e);
        }
        try {
            this.log.info((Object)"Inizializzo ISQLQueryObject ...");
            if (!("postgresql".equals(tipoDatabase) || "mysql".equals(tipoDatabase) || "oracle".equals(tipoDatabase))) {
                throw new Exception("Tipo database non gestito");
            }
            this.tipoDatabase = tipoDatabase;
            this.log.info((Object)"Inizializzo ISQLQueryObject terminata.");
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante la ricerca del SQLQueryObject...", (Throwable)e);
            throw new DriverMonitoraggioException("Errore durante la ricerca del SQLQueryObject...", e);
        }
    }

    /*
     * Loose catch block
     */
    public StatoPdD getStatoRichiestePendenti(FilterSearch search) throws DriverMonitoraggioException {
        Connection con = null;
        Statement pstmt = null;
        ResultSet rs = null;
        Object sqlQueryObject = null;
        con = this.datasource.getConnection();
        if (con == null) {
            throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
        }
        StatoPdD statoPdD = new StatoPdD();
        Timestamp now = DateManager.getTimestamp();
        Timestamp data_registrazione_limite = null;
        if (search.getSoglia() != -1L) {
            data_registrazione_limite = new Timestamp(DateManager.getTimeMillis() - search.getSoglia() * 1000L * 60L);
        }
        long totaleMessaggi = 0L;
        long totaleMessaggiDuplicati = -1L;
        sqlQueryObject = this.newSQLQueryObjectStatoRichiestePendenti(search);
        pstmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
        if (search.getSoglia() != -1L) {
            pstmt.setTimestamp(1, data_registrazione_limite);
        }
        if ((rs = pstmt.executeQuery()).next() && (totaleMessaggi = rs.getLong("totMessaggi")) > 0L) {
            statoPdD.setTotMessaggi(totaleMessaggi);
            statoPdD.setTempoMedioAttesa((now.getTime() - rs.getLong("ora_registrazione_media")) / 1000L);
            statoPdD.setTempoMaxAttesa((now.getTime() - rs.getLong("ora_registrazione_old")) / 1000L);
        }
        rs.close();
        pstmt.close();
        this.log.debug((Object)("query[" + sqlQueryObject + "] totaleMessaggi:" + totaleMessaggi));
        if (totaleMessaggi > 0L) {
            long tot;
            if (search.getStato() == null || "".equals(search.getStato()) || StatoMessaggio.CONSEGNA.getNomeStato().equals(search.getStato())) {
                sqlQueryObject = this.newSQLQueryObjectStatoRichiestePendenti(search);
                if (search.getStato() == null || "".equals(search.getStato())) {
                    sqlQueryObject.addWhereCondition("MESSAGGI.proprietario='ConsegnaContenutiApplicativi'");
                }
                pstmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
                if (search.getSoglia() != -1L) {
                    pstmt.setTimestamp(1, data_registrazione_limite);
                }
                if ((rs = pstmt.executeQuery()).next() && (tot = rs.getLong("totMessaggi")) > 0L) {
                    statoPdD.setNumMsgInConsegna(tot);
                    statoPdD.setTempoMedioAttesaInConsegna((now.getTime() - rs.getLong("ora_registrazione_media")) / 1000L);
                    statoPdD.setTempoMaxAttesaInConsegna((now.getTime() - rs.getLong("ora_registrazione_old")) / 1000L);
                }
                rs.close();
                pstmt.close();
                this.log.debug((Object)("query[" + sqlQueryObject + "] totaleMessaggiInConsegna:" + statoPdD.getNumMsgInConsegna()));
            }
            if (search.getStato() == null || "".equals(search.getStato()) || StatoMessaggio.SPEDIZIONE.getNomeStato().equals(search.getStato())) {
                sqlQueryObject = this.newSQLQueryObjectStatoRichiestePendenti(search);
                if (search.getStato() == null || "".equals(search.getStato())) {
                    sqlQueryObject.addWhereCondition(false, new String[]{"MESSAGGI.proprietario='InoltroBusteEGov'", "MESSAGGI.proprietario='InoltroRisposteEGov'"});
                }
                pstmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
                if (search.getSoglia() != -1L) {
                    pstmt.setTimestamp(1, data_registrazione_limite);
                }
                if ((rs = pstmt.executeQuery()).next() && (tot = rs.getLong("totMessaggi")) > 0L) {
                    statoPdD.setNumMsgInSpedizione(tot);
                    statoPdD.setTempoMedioAttesaInSpedizione((now.getTime() - rs.getLong("ora_registrazione_media")) / 1000L);
                    statoPdD.setTempoMaxAttesaInSpedizione((now.getTime() - rs.getLong("ora_registrazione_old")) / 1000L);
                }
                rs.close();
                pstmt.close();
                this.log.debug((Object)("query[" + sqlQueryObject + "] totaleMessaggiInSpedizione:" + statoPdD.getNumMsgInSpedizione()));
            }
            if (search.getStato() == null || "".equals(search.getStato()) || StatoMessaggio.PROCESSAMENTO.getNomeStato().equals(search.getStato())) {
                sqlQueryObject = this.newSQLQueryObjectStatoRichiestePendenti(search);
                if (search.getStato() == null || "".equals(search.getStato())) {
                    sqlQueryObject.addWhereCondition(true, new String[]{"MESSAGGI.proprietario<>'InoltroBusteEGov'", "MESSAGGI.proprietario<>'InoltroRisposteEGov'", "MESSAGGI.proprietario<>'ConsegnaContenutiApplicativi'"});
                }
                pstmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
                if (search.getSoglia() != -1L) {
                    pstmt.setTimestamp(1, data_registrazione_limite);
                }
                if ((rs = pstmt.executeQuery()).next() && (tot = rs.getLong("totMessaggi")) > 0L) {
                    statoPdD.setNumMsgInProcessamento(tot);
                    statoPdD.setTempoMedioAttesaInProcessamento((now.getTime() - rs.getLong("ora_registrazione_media")) / 1000L);
                    statoPdD.setTempoMaxAttesaInProcessamento((now.getTime() - rs.getLong("ora_registrazione_old")) / 1000L);
                }
                rs.close();
                pstmt.close();
                this.log.debug((Object)("query[" + sqlQueryObject + "] totaleMessaggiInProcessamento:" + statoPdD.getNumMsgInProcessamento()));
            }
        }
        this.log.debug((Object)"Calcolo numero pacchetti duplicati...");
        sqlQueryObject = this.newSQLQueryPacchettiDuplicati(search);
        pstmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
        if (search.getSoglia() != -1L) {
            pstmt.setTimestamp(1, data_registrazione_limite);
        }
        if ((rs = pstmt.executeQuery()).next()) {
            totaleMessaggiDuplicati = rs.getLong("numduplicati");
            statoPdD.setTotMessaggiDuplicati(totaleMessaggiDuplicati);
        }
        rs.close();
        pstmt.close();
        this.log.debug((Object)("query[" + sqlQueryObject.toString() + "] totaleMessaggiDuplicati:" + totaleMessaggiDuplicati));
        StatoPdD statoPdD2 = statoPdD;
        Object var16_14 = null;
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        return statoPdD2;
        catch (Exception e) {
            try {
                if (sqlQueryObject != null) {
                    this.log.error((Object)("getStatoRichiestePendenti error SQL[" + sqlQueryObject.toString() + "]"), (Throwable)e);
                    throw new DriverMonitoraggioException("getStatoRichiestePendenti error SQL[" + sqlQueryObject.toString() + "]: " + e.getMessage(), e);
                }
                this.log.error((Object)"getStatoRichiestePendenti error", (Throwable)e);
                throw new DriverMonitoraggioException("getStatoRichiestePendenti error: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                Object var16_15 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (Exception e2) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public long getTotaleMessaggiInGestione() throws DriverMonitoraggioException {
        Connection con = null;
        Statement pstmt = null;
        ResultSet rs = null;
        con = this.datasource.getConnection();
        if (con == null) {
            throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
        }
        long totaleMessaggi = 0L;
        String query = "SELECT count(*) as totMessaggi FROM MESSAGGI WHERE MESSAGGI.proprietario<>'GestoreMessaggi'";
        pstmt = con.prepareStatement(query);
        rs = pstmt.executeQuery();
        if (rs.next()) {
            totaleMessaggi = rs.getLong("totMessaggi");
        }
        rs.close();
        pstmt.close();
        this.log.debug((Object)("query[" + query + "] totaleMessaggi:" + totaleMessaggi));
        long l = totaleMessaggi;
        Object var10_8 = null;
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        return l;
        catch (Exception e) {
            try {
                this.log.error((Object)"getTotaleMessaggiInGestione error", (Throwable)e);
                throw new DriverMonitoraggioException("getStatoRichiestePendenti error: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (Exception e2) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public ListaMessaggi getListaRichiestePendenti(FilterSearch search) throws DriverMonitoraggioException {
        Connection con = null;
        Statement pstmt = null;
        ResultSet rs = null;
        Object sqlQueryObject = null;
        con = this.datasource.getConnection();
        if (con == null) {
            throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
        }
        ListaMessaggi listaMessaggi = new ListaMessaggi();
        Timestamp data_registrazione_limite = null;
        if (search.getSoglia() != -1L) {
            data_registrazione_limite = new Timestamp(DateManager.getTimeMillis() - search.getSoglia() * 1000L * 60L);
        }
        long totaleMessaggi = 0L;
        long oldLimit = search.getLimit();
        long oldOffset = search.getOffset();
        search.setLimit(-1L);
        search.setOffset(-1L);
        sqlQueryObject = this.newSQLQueryObjectStatoRichiestePendenti(search);
        pstmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
        if (search.getSoglia() != -1L) {
            pstmt.setTimestamp(1, data_registrazione_limite);
        }
        if ((rs = pstmt.executeQuery()).next()) {
            totaleMessaggi = rs.getLong("totMessaggi");
        }
        rs.close();
        pstmt.close();
        this.log.debug((Object)("query[" + sqlQueryObject + "] totaleMessaggi:" + totaleMessaggi));
        listaMessaggi.setTotMessaggi(totaleMessaggi);
        if (totaleMessaggi > 0L) {
            search.setLimit(oldLimit);
            search.setOffset(oldOffset);
            sqlQueryObject = this.newSQLQueryObjectListaRichiestePendenti(search);
            pstmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
            if (search.getSoglia() != -1L) {
                pstmt.setTimestamp(1, data_registrazione_limite);
            }
            rs = pstmt.executeQuery();
            Vector<Messaggio> msgs = new Vector<Messaggio>();
            this.log.debug((Object)("query[" + sqlQueryObject + "] listaMessaggi"));
            while (rs.next()) {
                Messaggio m = new Messaggio();
                m.setId(rs.getString("id_egov"));
                Dettaglio dettaglio = new Dettaglio();
                dettaglio.setIdModulo(rs.getString("proprietario"));
                dettaglio.setTipo(rs.getString("tipo"));
                dettaglio.setErroreProcessamento(rs.getString("ERRORE_PROCESSAMENTO"));
                m.setDettaglio(dettaglio);
                if (rs.getTimestamp("ORA_REGISTRAZIONE") != null) {
                    Calendar cOraRegistrazione = Calendar.getInstance();
                    cOraRegistrazione.setTime(new Date(rs.getTimestamp("ORA_REGISTRAZIONE").getTime()));
                    m.setOraRegistrazione(cOraRegistrazione);
                }
                m.setOraAttuale(Calendar.getInstance());
                if ("ConsegnaContenutiApplicativi".equals(rs.getString("proprietario"))) {
                    m.setStato(StatoMessaggio.CONSEGNA.getNomeStato());
                } else if ("InoltroBusteEGov".equals(rs.getString("proprietario"))) {
                    m.setStato(StatoMessaggio.SPEDIZIONE.getNomeStato());
                } else if ("InoltroRisposteEGov".equals(rs.getString("proprietario"))) {
                    m.setStato(StatoMessaggio.SPEDIZIONE.getNomeStato());
                } else {
                    m.setStato(StatoMessaggio.PROCESSAMENTO.getNomeStato());
                }
                if (search.getEgov() != null) {
                    Egov egovInfo = new Egov();
                    Soggetto mittente = new Soggetto();
                    mittente.setNomeSoggetto(rs.getString("MITTENTE"));
                    mittente.setTipoSoggetto(rs.getString("TIPO_MITTENTE"));
                    egovInfo.setMittente(mittente);
                    Soggetto destinatario = new Soggetto();
                    destinatario.setNomeSoggetto(rs.getString("DESTINATARIO"));
                    destinatario.setTipoSoggetto(rs.getString("TIPO_DESTINATARIO"));
                    egovInfo.setDestinatario(destinatario);
                    Servizio servizio = new Servizio();
                    servizio.setTipo(rs.getString("TIPO_SERVIZIO"));
                    servizio.setNome(rs.getString("SERVIZIO"));
                    egovInfo.setServizio(servizio);
                    egovInfo.setAzione(rs.getString("AZIONE"));
                    egovInfo.setProfiloCollaborazione(rs.getString("PROFILO_DI_COLLABORAZIONE"));
                    egovInfo.setRiferimentoMessaggio(rs.getString("RIFERIMENTO_MESSAGGIO"));
                    egovInfo.setCollaborazione(rs.getString("COLLABORAZIONE"));
                    m.setEgovInfo(egovInfo);
                }
                msgs.add(m);
            }
            rs.close();
            pstmt.close();
            for (int i = 0; i < msgs.size(); ++i) {
                boolean checkSA = false;
                if (msgs.get(i) != null && StatoMessaggio.CONSEGNA.getNomeStato().equals(((Messaggio)msgs.get(i)).getStato()) && ((Messaggio)msgs.get(i)).getDettaglio() != null) {
                    checkSA = true;
                } else if (msgs.get(i) != null && ((Messaggio)msgs.get(i)).getDettaglio() != null && ((Messaggio)msgs.get(i)).getDettaglio().getIdModulo() != null && ((Messaggio)msgs.get(i)).getDettaglio().getIdModulo().startsWith("RicezioneContenutiApplicativi")) {
                    checkSA = true;
                }
                if (checkSA) {
                    this.log.debug((Object)"Raccolgo informazioni dei servizi applicativi...");
                    String sqlQuerySA = "SELECT * FROM MSG_SERVIZI_APPLICATIVI WHERE ID_EGOV=?";
                    pstmt = con.prepareStatement(sqlQuerySA);
                    pstmt.setString(1, ((Messaggio)msgs.get(i)).getId());
                    rs = pstmt.executeQuery();
                    Vector<ServizioApplicativoConsegna> sconsegna = new Vector<ServizioApplicativoConsegna>();
                    while (rs.next()) {
                        ServizioApplicativoConsegna datiConsegna = new ServizioApplicativoConsegna();
                        if (rs.getInt("SBUSTAMENTO_SOAP") == 1) {
                            datiConsegna.setSbustamentoSoap(true);
                        } else {
                            datiConsegna.setSbustamentoSoap(false);
                        }
                        if (rs.getInt("INTEGRATION_MANAGER") == 1) {
                            datiConsegna.setAutorizzazioneIntegrationManager(true);
                        } else {
                            datiConsegna.setAutorizzazioneIntegrationManager(false);
                        }
                        datiConsegna.setNome(rs.getString("SERVIZIO_APPLICATIVO"));
                        datiConsegna.setTipoConsegna(rs.getString("TIPO_CONSEGNA"));
                        datiConsegna.setErroreProcessamento(rs.getString("ERRORE_PROCESSAMENTO"));
                        sconsegna.add(datiConsegna);
                    }
                    rs.close();
                    pstmt.close();
                    if (sconsegna.size() > 0) {
                        ((Messaggio)msgs.get(i)).getDettaglio().setServiziApplicativiConsegna(sconsegna.toArray(new ServizioApplicativoConsegna[sconsegna.size()]));
                    }
                }
                if (msgs.get(i) == null || ((Messaggio)msgs.get(i)).getEgovInfo() == null || !StatoMessaggio.SPEDIZIONE.getNomeStato().equals(((Messaggio)msgs.get(i)).getStato())) continue;
                if (search.getEgov() != null && search.getEgov().isAttesaRiscontro()) {
                    ((Messaggio)msgs.get(i)).getEgovInfo().setAttesaRiscontro(true);
                    continue;
                }
                this.log.debug((Object)"Raccolgo informazioni per attesa riscontro...");
                String sqlQueryRiscontro = "SELECT * FROM RISCONTRI_DA_RICEVERE WHERE ID_EGOV=?";
                pstmt = con.prepareStatement(sqlQueryRiscontro);
                pstmt.setString(1, ((Messaggio)msgs.get(i)).getId());
                rs = pstmt.executeQuery();
                ((Messaggio)msgs.get(i)).getEgovInfo().setAttesaRiscontro(rs.next());
                rs.close();
                pstmt.close();
            }
            if (msgs.size() > 0) {
                Messaggio[] messaggi = new Messaggio[1];
                messaggi = msgs.toArray(messaggi);
                listaMessaggi.setMessaggi(messaggi);
            }
        }
        ListaMessaggi listaMessaggi2 = listaMessaggi;
        Object var22_22 = null;
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        return listaMessaggi2;
        catch (Exception e) {
            try {
                if (sqlQueryObject != null) {
                    this.log.error((Object)("getListaRichiestePendenti error SQL[" + sqlQueryObject.toString() + "]"), (Throwable)e);
                    throw new DriverMonitoraggioException("getListaRichiestePendenti error SQL[" + sqlQueryObject.toString() + "]: " + e.getMessage(), e);
                }
                this.log.error((Object)"getListaRichiestePendenti error", (Throwable)e);
                throw new DriverMonitoraggioException("getListaRichiestePendenti error: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                Object var22_23 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (Exception e2) {}
                throw throwable;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean deleteMessaggio(String idMessaggio, String tipo) throws DriverMonitoraggioException {
        block28: {
            con = null;
            pstmt = null;
            con = this.datasource.getConnection();
            if (con == null) {
                throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
            }
            tipoMessaggio = tipo;
            if (tipoMessaggio != null) ** GOTO lbl37
            this.log.debug((Object)"Ricerco tipo messaggio...");
            filtro = new FilterSearch();
            filtro.setIdMessaggio(idMessaggio);
            lista = this.getListaRichiestePendenti(filtro);
            if (lista != null && lista.getMessaggi() != null) break block28;
            var8_11 = false;
            var11_13 = null;
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return var8_11;
        }
        if (lista.getMessaggi()[0].getDettaglio() == null || lista.getMessaggi()[0].getDettaglio().getTipo() == null) {
            throw new Exception("Tipo messaggio non identificato per l'id: " + idMessaggio);
        }
        tipoMessaggio = lista.getMessaggi()[0].getDettaglio().getTipo();
lbl37:
        // 2 sources

        this.log.debug((Object)("Messaggio con id(" + idMessaggio + ") da eliminare possiede tipo: " + tipoMessaggio));
        if ("OUTBOX".equals(tipoMessaggio)) {
            sqlQuery = "DELETE FROM RISCONTRI_DA_RICEVERE WHERE ID_EGOV=?";
            pstmt = con.prepareStatement(sqlQuery);
            pstmt.setString(1, idMessaggio);
            operation = pstmt.executeUpdate();
            if (operation > 0) {
                this.log.debug((Object)("Attesa riscontro per " + idMessaggio + " eliminato"));
            } else {
                this.log.debug((Object)("Attesa riscontro per " + idMessaggio + " non esistente"));
            }
            pstmt.close();
            sqlQuery = "DELETE FROM ASINCRONO WHERE ID_EGOV=? AND TIPO=?";
            pstmt = con.prepareStatement(sqlQuery);
            pstmt.setString(1, idMessaggio);
            pstmt.setString(2, tipoMessaggio);
            operation = pstmt.executeUpdate();
            if (operation > 0) {
                this.log.debug((Object)("ProfiloAsincrono per " + idMessaggio + " eliminato"));
            } else {
                this.log.debug((Object)("ProfiloAsincrono per " + idMessaggio + " non esistente"));
            }
            pstmt.close();
        }
        sqlQuery = "UPDATE MESSAGGI SET proprietario='GestoreMessaggi' WHERE proprietario<>'GestoreMessaggi' AND id_egov=?  AND tipo=?";
        pstmt = con.prepareStatement(sqlQuery);
        pstmt.setString(1, idMessaggio);
        pstmt.setString(2, tipoMessaggio);
        operation = pstmt.executeUpdate();
        result = false;
        if (operation > 0) {
            result = true;
            this.log.debug((Object)("Messaggio " + idMessaggio + " eliminato"));
        } else {
            this.log.debug((Object)("Messaggio " + idMessaggio + " non esistente"));
        }
        pstmt.close();
        var9_19 = result;
        var11_14 = null;
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return var9_19;
        catch (Exception e) {
            try {
                this.log.error((Object)"deleteMessaggio error", (Throwable)e);
                throw new DriverMonitoraggioException("deleteMessaggio error: " + e.getMessage());
            }
            catch (Throwable var10_20) {
                var11_15 = null;
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw var10_20;
            }
        }
    }

    /*
     * Loose catch block
     */
    public long deleteRichiestePendenti(FilterSearch search) throws DriverMonitoraggioException {
        Connection con = null;
        Statement pstmt = null;
        ResultSet rs = null;
        Object sqlQueryObject = null;
        con = this.datasource.getConnection();
        if (con == null) {
            throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
        }
        Timestamp data_registrazione_limite = null;
        if (search.getSoglia() != -1L) {
            data_registrazione_limite = new Timestamp(DateManager.getTimeMillis() - search.getSoglia() * 1000L * 60L);
        }
        sqlQueryObject = this.newSQLQueryObjectListaRichiestePendenti(search);
        pstmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
        if (search.getSoglia() != -1L) {
            pstmt.setTimestamp(1, data_registrazione_limite);
        }
        rs = pstmt.executeQuery();
        Vector<Messaggio> msgs = new Vector<Messaggio>();
        this.log.debug((Object)("query[" + sqlQueryObject + "] listaMessaggi"));
        while (rs.next()) {
            Messaggio m = new Messaggio();
            m.setId(rs.getString("id_egov"));
            Dettaglio dettaglio = new Dettaglio();
            dettaglio.setTipo(rs.getString("tipo"));
            m.setDettaglio(dettaglio);
            msgs.add(m);
        }
        rs.close();
        pstmt.close();
        long numeroMsgEliminati = 0L;
        while (msgs.size() > 0) {
            Messaggio msgForDelete = (Messaggio)msgs.remove(0);
            if (!this.deleteMessaggio(msgForDelete.getId(), msgForDelete.getDettaglio().getTipo())) continue;
            ++numeroMsgEliminati;
        }
        this.log.debug((Object)("eliminati " + numeroMsgEliminati + " messaggi"));
        long l = numeroMsgEliminati;
        Object var13_14 = null;
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        return l;
        catch (Exception e) {
            try {
                if (sqlQueryObject != null) {
                    this.log.error((Object)("deleteRichiestePendenti error SQL[" + sqlQueryObject.toString() + "]"), (Throwable)e);
                    throw new DriverMonitoraggioException("deleteRichiestePendenti error SQL[" + sqlQueryObject.toString() + "]: " + e.getMessage(), e);
                }
                this.log.error((Object)"deleteRichiestePendenti error", (Throwable)e);
                throw new DriverMonitoraggioException("deleteRichiestePendenti error: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (Exception e2) {}
                throw throwable;
            }
        }
    }

    private ISQLQueryObject newSQLQueryObjectStatoRichiestePendenti(FilterSearch search) throws SQLQueryObjectException {
        return this.newSQLQueryObjectRichiestePendenti(true, search);
    }

    private ISQLQueryObject newSQLQueryObjectListaRichiestePendenti(FilterSearch search) throws SQLQueryObjectException {
        return this.newSQLQueryObjectRichiestePendenti(false, search);
    }

    private ISQLQueryObject newSQLQueryObjectRichiestePendenti(boolean statoRichieste, FilterSearch search) throws SQLQueryObjectException {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
        sqlQueryObject.addFromTable("MESSAGGI");
        if (search.getMessagePattern() != null && !"".equals(search.getMessagePattern())) {
            sqlQueryObject.addFromTable("DEFINIZIONE_MESSAGGI");
        }
        if (search.getEgov() != null) {
            sqlQueryObject.addFromTable("REPOSITORY_EGOV");
            if (search.getEgov().isAttesaRiscontro()) {
                sqlQueryObject.addFromTable("RISCONTRI_DA_RICEVERE");
            }
        }
        String legameTabelleSQL_MSG_ID = "MESSAGGI.id_egov=DEFINIZIONE_MESSAGGI.id_egov";
        String legameTabelleSQL_MSG_TIPO = "MESSAGGI.tipo=DEFINIZIONE_MESSAGGI.tipo";
        String legameTabelleSQL_EGOV_ID = "MESSAGGI.id_egov=REPOSITORY_EGOV.id_egov";
        String legameTabelleSQL_EGOV_TIPO = "MESSAGGI.tipo=REPOSITORY_EGOV.tipo";
        String legameTabelleSQL_RISCONTRO = "MESSAGGI.id_egov=RISCONTRI_DA_RICEVERE.id_egov";
        if (search.getMessagePattern() != null && !"".equals(search.getMessagePattern())) {
            sqlQueryObject.addWhereCondition(true, new String[]{legameTabelleSQL_MSG_ID, legameTabelleSQL_MSG_TIPO});
        }
        if (search.getEgov() != null) {
            sqlQueryObject.addWhereCondition(true, new String[]{legameTabelleSQL_EGOV_ID, legameTabelleSQL_EGOV_TIPO});
        }
        if (search.getEgov() != null && search.getEgov().isAttesaRiscontro()) {
            sqlQueryObject.addWhereCondition(legameTabelleSQL_RISCONTRO);
        }
        if (statoRichieste) {
            sqlQueryObject.addSelectCountField("MESSAGGI.id_egov", "totMessaggi", true);
            sqlQueryObject.addSelectAvgTimestampField("MESSAGGI.ora_registrazione", "ora_registrazione_media");
            sqlQueryObject.addSelectMinTimestampField("MESSAGGI.ora_registrazione", "ora_registrazione_old");
        } else {
            sqlQueryObject.addSelectField("MESSAGGI", "id_egov");
            sqlQueryObject.addSelectField("MESSAGGI", "tipo");
            sqlQueryObject.addSelectField("MESSAGGI", "proprietario");
            sqlQueryObject.addSelectField("MESSAGGI", "ORA_REGISTRAZIONE");
            sqlQueryObject.addSelectField("MESSAGGI", "ERRORE_PROCESSAMENTO");
            if (search.getMessagePattern() != null && !"".equals(search.getMessagePattern())) {
                sqlQueryObject.addSelectField("DEFINIZIONE_MESSAGGI", "MSG_BYTES");
            }
            if (search.getEgov() != null) {
                sqlQueryObject.addSelectField("REPOSITORY_EGOV", "TIPO_MITTENTE");
                sqlQueryObject.addSelectField("REPOSITORY_EGOV", "MITTENTE");
                sqlQueryObject.addSelectField("REPOSITORY_EGOV", "TIPO_DESTINATARIO");
                sqlQueryObject.addSelectField("REPOSITORY_EGOV", "DESTINATARIO");
                sqlQueryObject.addSelectField("REPOSITORY_EGOV", "TIPO_SERVIZIO");
                sqlQueryObject.addSelectField("REPOSITORY_EGOV", "SERVIZIO");
                sqlQueryObject.addSelectField("REPOSITORY_EGOV", "AZIONE");
                sqlQueryObject.addSelectField("REPOSITORY_EGOV", "PROFILO_DI_COLLABORAZIONE");
                sqlQueryObject.addSelectField("REPOSITORY_EGOV", "RIFERIMENTO_MESSAGGIO");
                sqlQueryObject.addSelectField("REPOSITORY_EGOV", "COLLABORAZIONE");
            }
            if (search.getEgov() == null || search.getEgov().isAttesaRiscontro()) {
                // empty if block
            }
        }
        sqlQueryObject.setANDLogicOperator(true);
        if (!statoRichieste) {
            sqlQueryObject.addOrderBy("MESSAGGI.ORA_REGISTRAZIONE");
            sqlQueryObject.setSortType(false);
        }
        if (search.getStato() == null || "".equals(search.getStato()) || !StatoMessaggio.CANCELLATO.getNomeStato().equals(search.getStato())) {
            sqlQueryObject.addWhereCondition("MESSAGGI.proprietario<>'GestoreMessaggi'");
        }
        if (search.getStato() != null && !"".equals(search.getStato())) {
            if (StatoMessaggio.CONSEGNA.getNomeStato().equals(search.getStato())) {
                sqlQueryObject.addWhereCondition("MESSAGGI.proprietario='ConsegnaContenutiApplicativi'");
            } else if (StatoMessaggio.SPEDIZIONE.getNomeStato().equals(search.getStato())) {
                sqlQueryObject.addWhereCondition(false, new String[]{"MESSAGGI.proprietario='InoltroBusteEGov'", "MESSAGGI.proprietario='InoltroRisposteEGov'"});
            } else if (StatoMessaggio.CANCELLATO.getNomeStato().equals(search.getStato())) {
                sqlQueryObject.addWhereCondition("MESSAGGI.proprietario='GestoreMessaggi'");
            } else if (StatoMessaggio.PROCESSAMENTO.getNomeStato().equals(search.getStato())) {
                sqlQueryObject.addWhereCondition(true, new String[]{"MESSAGGI.proprietario<>'InoltroBusteEGov'", "MESSAGGI.proprietario<>'InoltroRisposteEGov'", "MESSAGGI.proprietario<>'ConsegnaContenutiApplicativi'"});
            } else {
                throw new SQLQueryObjectException("Stato per filtro non conosciuto: " + search.getStato());
            }
        }
        if (search.getIdMessaggio() != null && !"".equals(search.getIdMessaggio())) {
            sqlQueryObject.addWhereCondition("MESSAGGI.id_egov='" + search.getIdMessaggio() + "'");
        }
        if (search.getMessagePattern() != null && !"".equals(search.getMessagePattern())) {
            sqlQueryObject.addWhereLikeCondition("DEFINIZIONE_MESSAGGI.MSG_BYTES", search.getMessagePattern(), true, false);
        }
        if (search.getSoglia() != -1L) {
            sqlQueryObject.addWhereCondition("MESSAGGI.ora_registrazione<=?");
        }
        if (!statoRichieste) {
            if (search.getLimit() != -1L) {
                sqlQueryObject.setLimit((int)search.getLimit());
            }
            if (search.getOffset() != -1L) {
                sqlQueryObject.setOffset((int)search.getOffset());
            }
        }
        if (search.getEgov() != null) {
            if (search.getEgov().getMittente() != null) {
                if (search.getEgov().getMittente().getTipoSoggetto() != null && !"".equals(search.getEgov().getMittente().getTipoSoggetto())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_EGOV.TIPO_MITTENTE='" + search.getEgov().getMittente().getTipoSoggetto() + "'");
                }
                if (search.getEgov().getMittente().getNomeSoggetto() != null && !"".equals(search.getEgov().getMittente().getNomeSoggetto())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_EGOV.MITTENTE='" + search.getEgov().getMittente().getNomeSoggetto() + "'");
                }
            }
            if (search.getEgov().getDestinatario() != null) {
                if (search.getEgov().getDestinatario().getTipoSoggetto() != null && !"".equals(search.getEgov().getDestinatario().getTipoSoggetto())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_EGOV.TIPO_DESTINATARIO='" + search.getEgov().getDestinatario().getTipoSoggetto() + "'");
                }
                if (search.getEgov().getDestinatario().getNomeSoggetto() != null && !"".equals(search.getEgov().getDestinatario().getNomeSoggetto())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_EGOV.DESTINATARIO='" + search.getEgov().getDestinatario().getNomeSoggetto() + "'");
                }
            }
            if (search.getEgov().getServizio() != null) {
                if (search.getEgov().getServizio().getTipo() != null && !"".equals(search.getEgov().getServizio().getTipo())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_EGOV.TIPO_SERVIZIO='" + search.getEgov().getServizio().getTipo() + "'");
                }
                if (search.getEgov().getServizio().getNome() != null && !"".equals(search.getEgov().getServizio().getNome())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_EGOV.SERVIZIO='" + search.getEgov().getServizio().getNome() + "'");
                }
            }
            if (search.getEgov().getAzione() != null && !"".equals(search.getEgov().getAzione())) {
                sqlQueryObject.addWhereCondition("REPOSITORY_EGOV.AZIONE='" + search.getEgov().getAzione() + "'");
            }
            if (search.getEgov().getProfiloCollaborazione() != null && !"".equals(search.getEgov().getProfiloCollaborazione())) {
                sqlQueryObject.addWhereCondition("REPOSITORY_EGOV.PROFILO_DI_COLLABORAZIONE='" + search.getEgov().getProfiloCollaborazione() + "'");
            }
            if (search.getEgov().getRiferimentoMessaggio() != null && !"".equals(search.getEgov().getRiferimentoMessaggio())) {
                sqlQueryObject.addWhereCondition("REPOSITORY_EGOV.RIFERIMENTO_MESSAGGIO='" + search.getEgov().getRiferimentoMessaggio() + "'");
            }
            if (search.getEgov().getCollaborazione() != null && !"".equals(search.getEgov().getCollaborazione())) {
                sqlQueryObject.addWhereCondition("REPOSITORY_EGOV.COLLABORAZIONE='" + search.getEgov().getCollaborazione() + "'");
            }
        }
        return sqlQueryObject;
    }

    private ISQLQueryObject newSQLQueryPacchettiDuplicati(FilterSearch search) throws SQLQueryObjectException {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
        sqlQueryObject.addFromTable("REPOSITORY_EGOV");
        sqlQueryObject.addSelectField("sum(DUPLICATI) as numduplicati");
        sqlQueryObject.setANDLogicOperator(true);
        if (search.getIdMessaggio() != null && !"".equals(search.getIdMessaggio())) {
            sqlQueryObject.addWhereCondition("REPOSITORY_EGOV.id_egov='" + search.getIdMessaggio() + "'");
        }
        if (search.getSoglia() != -1L) {
            sqlQueryObject.addWhereCondition("REPOSITORY_EGOV.ora_registrazione<=?");
        }
        if (search.getEgov() != null) {
            if (search.getEgov().getMittente() != null) {
                if (search.getEgov().getMittente().getTipoSoggetto() != null && !"".equals(search.getEgov().getMittente().getTipoSoggetto())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_EGOV.TIPO_MITTENTE='" + search.getEgov().getMittente().getTipoSoggetto() + "'");
                }
                if (search.getEgov().getMittente().getNomeSoggetto() != null && !"".equals(search.getEgov().getMittente().getNomeSoggetto())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_EGOV.MITTENTE='" + search.getEgov().getMittente().getNomeSoggetto() + "'");
                }
            }
            if (search.getEgov().getDestinatario() != null) {
                if (search.getEgov().getDestinatario().getTipoSoggetto() != null && !"".equals(search.getEgov().getDestinatario().getTipoSoggetto())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_EGOV.TIPO_DESTINATARIO='" + search.getEgov().getDestinatario().getTipoSoggetto() + "'");
                }
                if (search.getEgov().getDestinatario().getNomeSoggetto() != null && !"".equals(search.getEgov().getDestinatario().getNomeSoggetto())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_EGOV.DESTINATARIO='" + search.getEgov().getDestinatario().getNomeSoggetto() + "'");
                }
            }
            if (search.getEgov().getServizio() != null) {
                if (search.getEgov().getServizio().getTipo() != null && !"".equals(search.getEgov().getServizio().getTipo())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_EGOV.TIPO_SERVIZIO='" + search.getEgov().getServizio().getTipo() + "'");
                }
                if (search.getEgov().getServizio().getNome() != null && !"".equals(search.getEgov().getServizio().getNome())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_EGOV.SERVIZIO='" + search.getEgov().getServizio().getNome() + "'");
                }
            }
            if (search.getEgov().getAzione() != null && !"".equals(search.getEgov().getAzione())) {
                sqlQueryObject.addWhereCondition("REPOSITORY_EGOV.AZIONE='" + search.getEgov().getAzione() + "'");
            }
            if (search.getEgov().getProfiloCollaborazione() != null && !"".equals(search.getEgov().getProfiloCollaborazione())) {
                sqlQueryObject.addWhereCondition("REPOSITORY_EGOV.PROFILO_DI_COLLABORAZIONE='" + search.getEgov().getProfiloCollaborazione() + "'");
            }
            if (search.getEgov().getRiferimentoMessaggio() != null && !"".equals(search.getEgov().getRiferimentoMessaggio())) {
                sqlQueryObject.addWhereCondition("REPOSITORY_EGOV.RIFERIMENTO_MESSAGGIO='" + search.getEgov().getRiferimentoMessaggio() + "'");
            }
            if (search.getEgov().getCollaborazione() != null && !"".equals(search.getEgov().getCollaborazione())) {
                sqlQueryObject.addWhereCondition("REPOSITORY_EGOV.COLLABORAZIONE='" + search.getEgov().getCollaborazione() + "'");
            }
        }
        return sqlQueryObject;
    }
}

