/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.mdb.threads;

import it.link.threads.CostantiThreads;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.mdb.threads.ThreadsStartup;
import org.openspcoop.utils.PropertiesReader;

public class ThreadsImplProperties {
    private Logger log = ThreadsStartup.initialize ? OpenSPCoopLogger.getLoggerOpenSPCoopCore() : Logger.getLogger((String)"ThreadsProperties");
    private static ThreadsImplProperties threadsproperties = null;
    private PropertiesReader reader;
    private static String pool_type = null;
    private static Integer pool_depth = null;
    private static String coda_type = null;
    private static Integer coda_depth = null;
    private static Boolean redelivery_status = null;
    private static Long redelivery_delay = null;
    private static Integer redelivery_count = null;
    private static long attesa_producer = -1L;

    public ThreadsImplProperties() throws Exception {
        Properties propertiesReader = new Properties();
        InputStream properties = null;
        try {
            properties = ThreadsImplProperties.class.getResourceAsStream("/threads.properties");
            propertiesReader.load(properties);
            properties.close();
        }
        catch (IOException e) {
            this.log.error((Object)("Riscontrato errore durante la lettura del file 'threads.properties': \n\n" + e.getMessage()));
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new Exception("ThreadsProperties initialize error: " + e.getMessage(), e);
        }
        this.reader = new PropertiesReader(propertiesReader);
    }

    public static boolean initialize() {
        try {
            threadsproperties = new ThreadsImplProperties();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static ThreadsImplProperties getInstance() {
        if (threadsproperties == null) {
            ThreadsImplProperties.initialize();
        }
        return threadsproperties;
    }

    public String getPoolType() {
        if (pool_type == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("it.link.threads.pool_type");
                if (name != null) {
                    pool_type = name = name.trim();
                } else {
                    this.log.warn((Object)"Proprieta it.link.threads.pool_type' non impostata, viene utilizzato il default=fixed");
                    pool_type = "fixed";
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta it.link.threads.pool_type' non impostata, viene utilizzato il default=fixed, errore:" + e.getMessage()));
                pool_type = "fixed";
            }
        }
        return pool_type;
    }

    public int getPoolDepth() {
        if (pool_depth == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("it.link.threads.pool_depth");
                if (name != null) {
                    name = name.trim();
                    pool_depth = Integer.parseInt(name);
                } else {
                    this.log.warn((Object)"Proprieta it.link.threads.pool_depth' non impostata, viene utilizzato il default=25");
                    pool_depth = 25;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta it.link.threads.pool_depth' non impostata, viene utilizzato il default=25, errore:" + e.getMessage()));
                pool_depth = 25;
            }
        }
        return pool_depth;
    }

    public String getCodaType() {
        if (coda_type == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("it.link.threads.coda_type");
                if (name != null) {
                    coda_type = name = name.trim();
                } else {
                    this.log.warn((Object)"Proprieta it.link.threads.coda_type' non impostata, viene utilizzato il default=fixed");
                    coda_type = "fixed";
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta it.link.threads.coda_type' non impostata, viene utilizzato il default=fixed, errore:" + e.getMessage()));
                coda_type = "fixed";
            }
        }
        return coda_type;
    }

    public int getCodaDepth() {
        if (coda_depth == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("it.link.threads.coda_depth");
                if (name != null) {
                    name = name.trim();
                    coda_depth = Integer.parseInt(name);
                } else {
                    this.log.warn((Object)"Proprieta it.link.threads.coda_depth' non impostata, viene utilizzato il default=25");
                    coda_depth = 25;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta it.link.threads.coda_depth' non impostata, viene utilizzato il default=25, errore:" + e.getMessage()));
                coda_depth = 25;
            }
        }
        return coda_depth;
    }

    public boolean isRedeliveryAttivo() {
        if (redelivery_status == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("it.link.threads.redelivery_status");
                if (name != null) {
                    name = name.trim();
                    redelivery_status = Boolean.parseBoolean(name);
                } else {
                    this.log.warn((Object)"Proprieta it.link.threads.redelivery_status' non impostata, viene utilizzato il default=false");
                    redelivery_status = false;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta it.link.threads.redelivery_status' non impostata, viene utilizzato il default=false, errore:" + e.getMessage()));
                redelivery_status = false;
            }
        }
        return redelivery_status;
    }

    public long getRedeliveryDelay() {
        if (redelivery_delay == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("it.link.threads.redelivery_delay");
                if (name != null) {
                    name = name.trim();
                    long time = Long.parseLong(name);
                    redelivery_delay = time;
                } else {
                    this.log.warn((Object)"Proprieta it.link.threads.redelivery_delay' non impostata, viene utilizzato il default=60000");
                    redelivery_delay = 60000L;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta it.link.threads.redelivery_delay' non impostata, viene utilizzato il default=60000, errore:" + e.getMessage()));
                redelivery_delay = 60000L;
            }
        }
        return redelivery_delay;
    }

    public int getRedeliveryCount() {
        if (redelivery_count == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("it.link.threads.redelivery_count");
                if (name != null) {
                    name = name.trim();
                    redelivery_count = Integer.parseInt(name);
                } else {
                    this.log.warn((Object)"Proprieta it.link.threads.redelivery_count' non impostata, viene utilizzato il default=25");
                    redelivery_count = 25;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta it.link.threads.redelivery_count' non impostata, viene utilizzato il default=25, errore:" + e.getMessage()));
                redelivery_count = 25;
            }
        }
        return redelivery_count;
    }

    public long getAttesaProducer() {
        if (attesa_producer == -1L) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("it.link.threads.attesa_producer");
                if (name != null) {
                    name = name.trim();
                    attesa_producer = Long.parseLong(name);
                } else {
                    this.log.warn((Object)("Proprieta it.link.threads.attesa_producer' non impostata, viene utilizzato il default=" + CostantiThreads.ATTESA_PRODUCER));
                    attesa_producer = CostantiThreads.ATTESA_PRODUCER;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta it.link.threads.attesa_producer' non impostata, viene utilizzato il default=" + CostantiThreads.ATTESA_PRODUCER + ", errore:" + e.getMessage()));
                attesa_producer = CostantiThreads.ATTESA_PRODUCER;
            }
        }
        return attesa_producer;
    }
}

