/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.mdb;

import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.apache.log4j.Logger;
import org.openspcoop.egov.Busta;
import org.openspcoop.pdd.core.node.TransactionManager;
import org.openspcoop.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.mdb.EsitoLib;
import org.openspcoop.pdd.mdb.SbustamentoRisposte;
import org.openspcoop.pdd.mdb.SbustamentoRisposteMessage;
import org.openspcoop.pdd.services.OpenSPCoopStartup;
import org.openspcoop.pdd.timers.TimerMonitoraggioRisorse;

public class SbustamentoRisposteMDB
implements MessageDrivenBean,
MessageListener {
    private static final long serialVersionUID = 1L;
    private Logger log = null;
    private MessageDrivenContext ctxMDB;

    public void setMessageDrivenContext(MessageDrivenContext mdc) throws EJBException {
        this.ctxMDB = mdc;
    }

    public void ejbCreate() {
    }

    public void ejbRemove() {
    }

    public void onMessage(Message message) {
        if (message instanceof ObjectMessage) {
            if (!OpenSPCoopStartup.initialize) {
                this.ctxMDB.setRollbackOnly();
                return;
            }
            this.log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
            if (this.log == null) {
                System.out.println("[SbustamentoRisposte] Logger nullo. MDB abortito");
                return;
            }
            if (!TimerMonitoraggioRisorse.risorseDisponibili) {
                this.log.error((Object)("[SbustamentoRisposte] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            SbustamentoRisposte lib = new SbustamentoRisposte(this.log);
            if (!lib.inizializzazioneUltimata) {
                this.log = Logger.getLogger((String)"OpenSPCoop.SbustamentoRisposte");
                this.log.error((Object)"[SbustamentoRisposte] Inizializzazione MDB non riuscita");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            MsgDiagnostico msgDiag = new MsgDiagnostico("SbustamentoRisposte");
            msgDiag.mediumDebug("Ricezione richiesta (SbustamentoRisposteMessage)...");
            ObjectMessage received = (ObjectMessage)message;
            SbustamentoRisposteMessage sbustamentoRisposteMsg = null;
            try {
                sbustamentoRisposteMsg = (SbustamentoRisposteMessage)received.getObject();
            }
            catch (JMSException e) {
                msgDiag.logErroreGenerico((Exception)((Object)e), "received.getObject(SbustamentoRisposteMessage)");
                return;
            }
            String idEGovRequest = null;
            try {
                idEGovRequest = received.getStringProperty("ID");
            }
            catch (JMSException e) {
                msgDiag.logErroreGenerico((Exception)((Object)e), "received.getStringProperty(ID)");
                return;
            }
            Busta bustaRisposta = sbustamentoRisposteMsg.getBusta();
            String idEGovResponse = bustaRisposta.getID();
            msgDiag.mediumDebug("Transaction Manager...");
            try {
                if (!TransactionManager.validityCheck(msgDiag, "SbustamentoRisposte", idEGovResponse, "INBOX", received.getJMSMessageID())) {
                    msgDiag.lowDebug("Messaggio con id[" + idEGovResponse + "] non ha superato il validity check");
                    return;
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "TransactionManager.validityCheck");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            EsitoLib esito = null;
            try {
                OpenSPCoopStateful stato = new OpenSPCoopStateful();
                stato.setIDEgovSessione(idEGovRequest);
                stato.setMessageLib(sbustamentoRisposteMsg);
                esito = lib.onMessage(stato);
            }
            catch (Exception e) {
                this.log.error((Object)"[SbustamentoRisposte] Impossibile chiamare la libreria", (Throwable)e);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!esito.isEsitoInvocazione()) {
                this.log.error((Object)"[SbustamentoRisposte] Chiamata alla libreria fallita");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            this.log.debug((Object)"[SbustamentoRisposte] Chiamata alla libreria riuscita");
        }
    }
}

