/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.mdb;

import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.apache.log4j.Logger;
import org.openspcoop.pdd.core.node.TransactionManager;
import org.openspcoop.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.mdb.EsitoLib;
import org.openspcoop.pdd.mdb.Sbustamento;
import org.openspcoop.pdd.mdb.SbustamentoMessage;
import org.openspcoop.pdd.services.OpenSPCoopStartup;
import org.openspcoop.pdd.timers.TimerMonitoraggioRisorse;

public class SbustamentoMDB
implements MessageDrivenBean,
MessageListener {
    private static final long serialVersionUID = 1L;
    private MessageDrivenContext ctxMDB;
    private Logger log = null;

    public void setMessageDrivenContext(MessageDrivenContext mdc) throws EJBException {
        this.ctxMDB = mdc;
    }

    public void ejbCreate() {
    }

    public void ejbRemove() {
    }

    public void onMessage(Message message) {
        if (message instanceof ObjectMessage) {
            if (!OpenSPCoopStartup.initialize) {
                this.ctxMDB.setRollbackOnly();
                return;
            }
            this.log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
            if (this.log == null) {
                System.out.println("[Sbustamento] Logger nullo. MDB abortito");
                return;
            }
            if (!TimerMonitoraggioRisorse.risorseDisponibili) {
                this.log.error((Object)("[Sbustamento] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            Sbustamento lib = new Sbustamento(this.log);
            if (!lib.inizializzazioneUltimata) {
                this.log = Logger.getLogger((String)"OpenSPCoop.Sbustamento");
                this.log.error((Object)"[Sbustamento] Inizializzazione MDB non riuscita");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            MsgDiagnostico msgDiag = new MsgDiagnostico("Sbustamento");
            msgDiag.mediumDebug("Ricezione richiesta (SbustamentoMessage)...");
            ObjectMessage received = (ObjectMessage)message;
            SbustamentoMessage sbustamentoMsg = null;
            try {
                sbustamentoMsg = (SbustamentoMessage)received.getObject();
            }
            catch (JMSException e) {
                msgDiag.logErroreGenerico((Exception)((Object)e), "received.getObject(SbustamentoMessage)");
                return;
            }
            String idEGovRequest = null;
            try {
                idEGovRequest = received.getStringProperty("ID");
            }
            catch (JMSException e) {
                msgDiag.logErroreGenerico((Exception)((Object)e), "received.getStringProperty(ID)");
                return;
            }
            msgDiag.mediumDebug("Transaction Manager...");
            try {
                if (!TransactionManager.validityCheck(msgDiag, "Sbustamento", idEGovRequest, "INBOX", received.getJMSMessageID())) {
                    msgDiag.lowDebug("Messaggio con id[" + idEGovRequest + "] non ha superato il validity check");
                    return;
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "TransactionManager.validityCheck");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            EsitoLib esito = null;
            try {
                OpenSPCoopStateful stato = new OpenSPCoopStateful();
                stato.setIDEgovSessione(idEGovRequest);
                stato.setMessageLib(sbustamentoMsg);
                esito = lib.onMessage(stato);
            }
            catch (Exception e) {
                this.log.error((Object)"[Sbustamento] Impossibile chiamare la libreria", (Throwable)e);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!esito.isEsitoInvocazione()) {
                this.log.error((Object)"[Sbustamento] Chiamata alla libreria fallita");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            this.log.debug((Object)"[Sbustamento] Chiamata alla libreria riuscita");
        }
    }
}

