/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.mdb;

import java.util.Date;
import java.util.Vector;
import org.apache.axis.Message;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.config.PortaDelegata;
import org.openspcoop.dao.config.ServizioApplicativo;
import org.openspcoop.dao.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.egov.Busta;
import org.openspcoop.egov.Eccezione;
import org.openspcoop.egov.History;
import org.openspcoop.egov.Integrazione;
import org.openspcoop.egov.ProfiloDiCollaborazione;
import org.openspcoop.egov.ProprietaErroreApplicativo;
import org.openspcoop.egov.RepositoryEGov;
import org.openspcoop.egov.Riscontro;
import org.openspcoop.egov.XMLBuilder;
import org.openspcoop.pdd.config.RichiestaDelegata;
import org.openspcoop.pdd.core.EJBUtils;
import org.openspcoop.pdd.core.EJBUtilsConsegnaException;
import org.openspcoop.pdd.core.GestoreMessaggi;
import org.openspcoop.pdd.core.state.IOpenSPCoopState;
import org.openspcoop.pdd.core.state.OpenSPCoopStateException;
import org.openspcoop.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop.pdd.mdb.EsitoLib;
import org.openspcoop.pdd.mdb.GenericLib;
import org.openspcoop.pdd.mdb.SbustamentoMessage;
import org.openspcoop.pdd.monitor.InfoAttraversamentoPdD;
import org.openspcoop.pdd.monitor.NotificaTempiAttraversamentoPdDUtility;
import org.openspcoop.pdd.monitor.TipoPdD;
import org.openspcoop.utils.SoapUtils;
import org.openspcoop.utils.date.DateManager;

public class Sbustamento
extends GenericLib {
    public static final String ID_MODULO = "Sbustamento";
    private XMLBuilder xmlBuilder;

    public Sbustamento(Logger log) {
        super(ID_MODULO, log);
        this.inizializza();
    }

    protected void inizializza() {
        this.xmlBuilder = new XMLBuilder();
        super.inizializza();
    }

    /*
     * Unable to fully structure code
     */
    public EsitoLib onMessage(IOpenSPCoopState openspcoopstate) throws OpenSPCoopStateException {
        sbustamentoMsg = (SbustamentoMessage)openspcoopstate.getMessageLib();
        esito = new EsitoLib();
        richiestaApplicativa = sbustamentoMsg.getRichiestaApplicativa();
        bustaRichiesta = sbustamentoMsg.getBusta();
        idServizio = richiestaApplicativa.getIDServizio();
        idSoggettoFruitore = richiestaApplicativa.getSoggettoFruitore();
        errors = sbustamentoMsg.getErrors();
        isSPCoopErrore = sbustamentoMsg.getIsSPCoopErrore();
        bustaDiServizio = sbustamentoMsg.getIsBustaDiServizio();
        identitaPdD = sbustamentoMsg.getRichiestaApplicativa().getDominio();
        this.msgDiag.setDominioSPCoop(identitaPdD.getCodicePorta());
        this.msgDiag.setPrefixMsgPersonalizzati("sbustamentoBustaEGov.");
        this.msgDiag.addKeywords(bustaRichiesta, true);
        if (richiestaApplicativa.getIdentitaServizioApplicativoFruitore() != null) {
            this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE@", richiestaApplicativa.getIdentitaServizioApplicativoFruitore());
        }
        this.msgDiag.addKeyword("@ID_CORRELAZIONE_APPLICATIVA@", richiestaApplicativa.getIdCorrelazioneApplicativa());
        profiloGestione = richiestaApplicativa.getProfiloGestione();
        this.msgDiag.mediumDebug("Profilo di gestione [Sbustamento] della busta: " + profiloGestione);
        implementazionePdDMittente = sbustamentoMsg.getImplementazionePdDSoggettoMittente();
        this.msgDiag.mediumDebug("Inizializzo stato per la gestione della richiesta...");
        openspcoopstate.initResource(identitaPdD, "Sbustamento");
        idEGovRequest = openspcoopstate.getIDEgovSessione();
        this.msgDiag.setIdEGovRichiesta(idEGovRequest);
        this.msgDiag.setFruitore(idSoggettoFruitore);
        this.msgDiag.setServizio(idServizio);
        this.msgDiag.setDelegata(false);
        this.msgDiag.mediumDebug("Inizializzo contesto per la gestione...");
        ejbUtils = null;
        try {
            ejbUtils = new EJBUtils(identitaPdD, "Sbustamento", idEGovRequest, idEGovRequest, "INBOX", openspcoopstate, this.msgDiag, false, sbustamentoMsg.getImplementazionePdDSoggettoMittente(), sbustamentoMsg.getImplementazionePdDSoggettoDestinatario());
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "EJBUtils.new");
            openspcoopstate.releaseResource();
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazione(3);
            return esito;
        }
        oneWayVersione11 = sbustamentoMsg.isOneWayVersione11();
        ejbUtils.setOneWayVersione11(oneWayVersione11);
        ejbUtils.setPortaDiTipoStateless_esclusoOneWay11(sbustamentoMsg.isStateless());
        profiloCollaborazione = new ProfiloDiCollaborazione(openspcoopstate.getStatoRichiesta());
        historyBuste = new History(openspcoopstate.getStatoRichiesta());
        repositoryEGov = new RepositoryEGov(openspcoopstate.getStatoRichiesta(), true);
        ricevutaAsincrona = null;
        msgRequest = new GestoreMessaggi(openspcoopstate, true, idEGovRequest, "INBOX", this.msgDiag);
        msgResponse = null;
        msgRequest.setOneWayVersione11(oneWayVersione11);
        servizioApplicativoFruitore = richiestaApplicativa.getIdentitaServizioApplicativoFruitore();
        idCorrelazioneApplicativa = richiestaApplicativa.getIdCorrelazioneApplicativa();
        newConnectionForResponse = false;
        if (!"EGOV_IT_ServizioSincrono".equals(bustaRichiesta.getProfiloDiCollaborazione()) && !sbustamentoMsg.isStateless()) {
            newConnectionForResponse = this.configurazionePdDReader.newConnectionForResponseSPCoop();
        }
        ejbUtils.setReplyOnNewConnection(newConnectionForResponse);
        gestioneIndirizzoTelematico = false;
        if (!sbustamentoMsg.isStateless()) {
            gestioneIndirizzoTelematico = this.configurazionePdDReader.isUtilizzoIndirizzoTelematico();
        }
        ejbUtils.setUtilizzoIndirizzoTelematico(gestioneIndirizzoTelematico);
        sendSbloccoRicezioneBusteEGov = true;
        if (this.configurazionePdDReader.isUtilizzoIndirizzoTelematico() && bustaRichiesta.getIndirizzoTelematicoMittente() != null && !sbustamentoMsg.isStateless()) {
            sendSbloccoRicezioneBusteEGov = false;
        } else if (newConnectionForResponse) {
            sendSbloccoRicezioneBusteEGov = false;
        }
        ruoloBustaEgovRicevuta = sbustamentoMsg.getRuoloBustaEgovRicevuta();
        bustaHTTPReply = null;
        dataIngressoMessaggio = null;
        try {
            block219: {
                block221: {
                    if (isSPCoopErrore) {
                        this.msgDiag.mediumDebug("Gestione messaggio SPCoop errore...");
                        msgSPCoopErroreValido = true;
                        if (!this.configurazionePdDReader.getTipoValidazione(implementazionePdDMittente).equalsIgnoreCase("disabilitato") && errors.size() != 0) {
                            eccBuffer = new StringBuffer();
                            for (k = 0; k < errors.size(); ++k) {
                                er = errors.get(k);
                                if (k > 0) {
                                    eccBuffer.append("\n");
                                }
                                eccBuffer.append(er.toString());
                            }
                            this.msgDiag.addKeyword("@ECCEZIONI@", eccBuffer.toString());
                            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("validazioneBustaErrore.listaEccezioniMalformata"), this.msgDiag.getLivello("validazioneBustaErrore.listaEccezioniMalformata"));
                            if (this.configurazionePdDReader.getTipoValidazione(implementazionePdDMittente).equalsIgnoreCase("abilitato")) {
                                msgSPCoopErroreValido = false;
                            }
                        }
                        if (msgSPCoopErroreValido) {
                            this.msgDiag.addKeyword("@ECCEZIONI@", bustaRichiesta.toStringListaEccezioni());
                            this.msgDiag.addKeyword("@NUMERO_ECCEZIONI@", bustaRichiesta.sizeListaEccezioni() + "");
                            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("ricezioneBustaErrore"), this.msgDiag.getLivello("ricezioneBustaErrore"));
                        }
                        if (sendSbloccoRicezioneBusteEGov) {
                            this.msgDiag.mediumDebug("Invio messaggio di sblocco a RicezioneBusteEGov...");
                            msgResponse = ejbUtils.sendSbloccoRicezioneBusteEGov(richiestaApplicativa.getIdModuloInAttesa());
                        }
                        this.msgDiag.mediumDebug("Invio eventuale messaggio di errore al servizio applicativo (gestione errore)...");
                        eccezioneDaInviareServizioApplicativo = new Eccezione();
                        eccezioneDaInviareServizioApplicativo.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                        eccezioneDaInviareServizioApplicativo.setCodiceEccezione("EGOV_IT_001");
                        eccezioneDaInviareServizioApplicativo.setRilevanza("GRAVE");
                        if (msgSPCoopErroreValido) {
                            if (bustaRichiesta.sizeListaEccezioni() > 1) {
                                bf = new StringBuffer();
                                for (k = 0; k < bustaRichiesta.sizeListaEccezioni(); ++k) {
                                    bf.append("[" + bustaRichiesta.getEccezione(k).getCodiceEccezione() + "] " + bustaRichiesta.getEccezione(k).getPosizione() + "\n");
                                }
                                eccezioneDaInviareServizioApplicativo.setPosizione(bf.toString());
                            } else {
                                eccezioneDaInviareServizioApplicativo = bustaRichiesta.getEccezione(0);
                            }
                        } else if (errors.size() > 1) {
                            bf = new StringBuffer();
                            for (k = 0; k < errors.size(); ++k) {
                                bf.append("[" + errors.get(k).getCodiceEccezione() + "] " + errors.get(k).getPosizione() + "\n");
                            }
                            eccezioneDaInviareServizioApplicativo.setPosizione(bf.toString());
                        } else {
                            eccezioneDaInviareServizioApplicativo = errors.get(0);
                        }
                        this.gestioneErroreSPCoop(ejbUtils, profiloCollaborazione, repositoryEGov, bustaRichiesta, identitaPdD, eccezioneDaInviareServizioApplicativo, new IDSoggetto(bustaRichiesta.getTipoMittente(), bustaRichiesta.getMittente()));
                        openspcoopstate.commit();
                        this.msgDiag.mediumDebug("Rilascio connessione...");
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2);
                        return esito;
                    }
                    if (!isSPCoopErrore && !this.configurazionePdDReader.getTipoValidazione(implementazionePdDMittente).equalsIgnoreCase("disabilitato")) {
                        v0 = validazioneConErrori = errors.size() > 0;
                        if ("eGov1.1-lineeGuida1.1".equals(profiloGestione) || this.propertiesReader.ignoraEccezioniNonGravi_ValidazioneSPCoop()) {
                            validazioneConErrori = Busta.containsEccezioniGravi(errors);
                        }
                        if (validazioneConErrori) {
                            this.msgDiag.mediumDebug("Gestione messaggio SPCoop che non ha superato la validazione...");
                            mittenteRegistrato = true;
                            eccBuffer = new StringBuffer();
                            errorsClone = new Vector<Eccezione>();
                            for (k = 0; k < errors.size(); ++k) {
                                er = errors.get(k);
                                errorsClone.add(er);
                                if (k > 0) {
                                    eccBuffer.append("\n");
                                }
                                eccBuffer.append(er.toString());
                                if (!"EGOV_IT_101".equals(er.getCodiceEccezione())) continue;
                                mittenteRegistrato = false;
                            }
                            this.msgDiag.addKeyword("@ECCEZIONI@", eccBuffer.toString());
                            this.msgDiag.addKeyword("@NUMERO_ECCEZIONI@", errors.size() + "");
                            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("validazioneBusta.bustaNonCorretta"), this.msgDiag.getLivello("validazioneBusta.bustaNonCorretta"));
                            if (this.configurazionePdDReader.getTipoValidazione(implementazionePdDMittente).equalsIgnoreCase("abilitato")) {
                                bustaNonValida = bustaRichiesta.clone();
                                if (errors.size() > 0) {
                                    for (ii = 0; ii < errors.size(); ++ii) {
                                        ex = errors.get(ii);
                                        codiceEccezione = ex.getCodiceEccezione();
                                        posizione = ex.getPosizione();
                                        if (!"EGOV_IT_103".equals(codiceEccezione) || !"ProfiloCollaborazione".equals(posizione)) continue;
                                        bustaRichiesta.setProfiloDiCollaborazione("EGOV_IT_ServizioSincrono");
                                        break;
                                    }
                                }
                                ejbUtils.setRollbackRichiestaInCasoErrore(false);
                                if (mittenteRegistrato) {
                                    this.msgDiag.mediumDebug("Invio segnalazione di errore ...");
                                    ejbUtils.sendRispostaSPCoopErroreValidazione(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, errorsClone, idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                } else if (sendSbloccoRicezioneBusteEGov) {
                                    this.msgDiag.mediumDebug("Invio messaggio di sblocco a RicezioneBusteEGov...");
                                    msgResponse = ejbUtils.sendSbloccoRicezioneBusteEGov(richiestaApplicativa.getIdModuloInAttesa());
                                }
                                ejbUtils.setRollbackRichiestaInCasoErrore(true);
                                eccezioneDaInviareServizioApplicativo = new Eccezione();
                                if (errors.size() > 1) {
                                    eccezioneDaInviareServizioApplicativo.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                                    eccezioneDaInviareServizioApplicativo.setCodiceEccezione("EGOV_IT_001");
                                    eccezioneDaInviareServizioApplicativo.setRilevanza("GRAVE");
                                    bf = new StringBuffer();
                                    for (k = 0; k < errors.size(); ++k) {
                                        bf.append("[" + errors.get(k).getCodiceEccezione() + "] " + errors.get(k).getPosizione() + "\n");
                                    }
                                    eccezioneDaInviareServizioApplicativo.setPosizione(bf.toString());
                                } else {
                                    eccezioneDaInviareServizioApplicativo = errors.get(0);
                                }
                                this.msgDiag.mediumDebug("Invio eventuale messaggio di errore al servizio applicativo (gestione errore)...");
                                this.gestioneErroreSPCoop(ejbUtils, profiloCollaborazione, repositoryEGov, bustaNonValida, identitaPdD, eccezioneDaInviareServizioApplicativo, identitaPdD);
                                openspcoopstate.commit();
                                this.msgDiag.mediumDebug("Rilascio connessione...");
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2);
                                return esito;
                            }
                        }
                    }
                    if (!bustaRichiesta.containsEccezioniGravi() && bustaRichiesta.sizeListaEccezioni() > 0) {
                        this.msgDiag.addKeyword("@ECCEZIONI@", bustaRichiesta.toStringListaEccezioni());
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("ricezioneBusta.eccezioniNonGravi"), this.msgDiag.getLivello("ricezioneBusta.eccezioniNonGravi"));
                    }
                    if (!Busta.containsEccezioniGravi(errors) && errors.size() > 0) {
                        this.msgDiag.addKeyword("@ECCEZIONI@", Busta.toStringListaEccezioni(errors));
                        this.msgDiag.addKeyword("@NUMERO_ECCEZIONI@", errors.size() + "");
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("validazioneBusta.eccezioniNonGravi"), this.msgDiag.getLivello("validazioneBusta.eccezioniNonGravi"));
                    }
                    if (!"eGov1.1-lineeGuida1.1".equals(profiloGestione) && this.propertiesReader.isGestioneRiscontri(implementazionePdDMittente) && bustaRichiesta.sizeListaRiscontri() > 0) {
                        for (i = 0; i < bustaRichiesta.sizeListaRiscontri(); ++i) {
                            r = bustaRichiesta.getRiscontro(i);
                            this.msgDiag.addKeyword("@ID_EGOV_BUSTA_RISCONTRATA@", r.getID());
                            this.msgDiag.addKeyword("@DATA_RISCONTRO@", r.getOraRegistrazione().toString());
                            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("ricezioneRiscontro"), this.msgDiag.getLivello("ricezioneRiscontro"));
                            try {
                                msgRiscontrato = new GestoreMessaggi(openspcoopstate, true, r.getID(), "OUTBOX", this.msgDiag);
                                msgRiscontrato.validateAndDeleteMsgOneWayRiscontrato();
                                continue;
                            }
                            catch (Exception e) {
                                this.msgDiag.logErroreGenerico(e, "msgRiscontrato.validateAndDeleteMsgOneWayRiscontrato(" + r.getID() + ")");
                            }
                        }
                    }
                    this.msgDiag.mediumDebug("Controllo appartenenza Destinazione Busta (controllo esistenza soggetto)...");
                    existsSoggetto = false;
                    try {
                        existsSoggetto = this.configurazionePdDReader.existsSoggetto(idServizio.getSoggettoErogatore());
                    }
                    catch (Exception e) {
                        if (idServizio != null && idServizio.getSoggettoErogatore() != null) {
                            this.msgDiag.logErroreGenerico(e, "existsSoggetto(" + idServizio.getSoggettoErogatore().toString() + ")");
                        } else {
                            this.msgDiag.logErroreGenerico(e, "existsSoggetto()");
                        }
                        ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_536", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2);
                        return esito;
                    }
                    isSoggettoVirtuale = this.configurazionePdDReader.isSoggettoVirtuale(idServizio.getSoggettoErogatore());
                    if (!existsSoggetto && !isSoggettoVirtuale) {
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("soggettoDestinatarioNonGestito"), this.msgDiag.getLivello("soggettoDestinatarioNonGestito"));
                        ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_451", "Il soggetto richiesto dalla busta eGov non e' gestito dalla PdD ", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2);
                        return esito;
                    }
                    if (bustaDiServizio) {
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("ricezioneBustaServizio"), this.msgDiag.getLivello("ricezioneBustaServizio"));
                        if (sendSbloccoRicezioneBusteEGov) {
                            msgResponse = ejbUtils.sendSbloccoRicezioneBusteEGov(richiestaApplicativa.getIdModuloInAttesa());
                        }
                        ejbUtils.releaseInboxMessage(false);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2);
                        return esito;
                    }
                    returnSPCoopReply = false;
                    bustaHTTPReply = bustaRichiesta.invertiBusta(this.propertiesReader.getTipoTempoEGov(implementazionePdDMittente));
                    if (!"eGov1.1-lineeGuida1.1".equals(profiloGestione) && "EGOV_IT_MessaggioSingoloOneWay".equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                        if (this.propertiesReader.isCheckFromRegistroConfermaRicezioneAbilitato(implementazionePdDMittente) && sbustamentoMsg.isConfermaRicezioneRichiestoAccordo() && !bustaRichiesta.getConfermaRicezione()) {
                            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("funzionalitaRichiestaAccordo.confermaRicezioneNonPresente"), this.msgDiag.getLivello("funzionalitaRichiestaAccordo.confermaRicezioneNonPresente"));
                            e = Eccezione.getEccezioneValidazione((String)"EGOV_IT_113", (String)"ProfiloTrasmissione/confermaRicezione");
                            ejbUtils.sendRispostaSPCoopErroreValidazione(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, e, idCorrelazioneApplicativa, servizioApplicativoFruitore);
                            openspcoopstate.releaseResource();
                            esito.setEsitoInvocazione(true);
                            esito.setStatoInvocazione(2);
                            return esito;
                        }
                        if (this.propertiesReader.isCheckFromRegistroConsegnaInOrdineAbilitato(implementazionePdDMittente) && sbustamentoMsg.isConsegnaOrdineRichiestoAccordo() && bustaRichiesta.getSequenza() < 0L) {
                            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("funzionalitaRichiestaAccordo.consegnaInOrdineNonPresente"), this.msgDiag.getLivello("funzionalitaRichiestaAccordo.consegnaInOrdineNonPresente"));
                            e = Eccezione.getEccezioneValidazione((String)"EGOV_IT_402", (String)"Sequenza");
                            ejbUtils.sendRispostaSPCoopErroreValidazione(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, e, idCorrelazioneApplicativa, servizioApplicativoFruitore);
                            openspcoopstate.releaseResource();
                            esito.setEsitoInvocazione(true);
                            esito.setStatoInvocazione(2);
                            return esito;
                        }
                    }
                    v1 = checkDuplicato = "EGOV_IT_ALPIUUNAVOLTA".equals(bustaRichiesta.getInoltro()) != false || this.propertiesReader.isCheckFromRegistroFiltroDuplicatiAbilitato(implementazionePdDMittente) != false && sbustamentoMsg.isFiltroDuplicatiRichiestoAccordo() != false || "eGov1.1-lineeGuida1.1".equals(profiloGestione) != false;
                    if (!checkDuplicato) break block221;
                    bustaRegistrataConHistory = false;
                    if (openspcoopstate instanceof OpenSPCoopStateless && !oneWayVersione11 && !repositoryEGov.isRegistrataIntoInBox(bustaRichiesta.getID())) {
                        repositoryEGov.registraBustaIntoInboxForHistory(bustaRichiesta, this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi());
                        bustaRegistrataConHistory = true;
                    }
                    try {
                        block222: {
                            block224: {
                                block225: {
                                    block223: {
                                        bustaDuplicata = historyBuste.bustaRicevutaPrecedentemente(bustaRichiesta.getID());
                                        if (!bustaDuplicata) break block222;
                                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("ricezioneBustaDuplicata.count"), this.msgDiag.getLivello("ricezioneBustaDuplicata.count"));
                                        repositoryEGov.aggiornaDuplicatiIntoInBox(bustaRichiesta.getID());
                                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("ricezioneBustaDuplicata"), this.msgDiag.getLivello("ricezioneBustaDuplicata"));
                                        if (!"EGOV_IT_MessaggioSingoloOneWay".equals(bustaRichiesta.getProfiloDiCollaborazione()) || !bustaRichiesta.getConfermaRicezione() || "eGov1.1-lineeGuida1.1".equals(profiloGestione) || !this.propertiesReader.isGestioneRiscontri(implementazionePdDMittente)) break block223;
                                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("ricezioneBusteEGov.", "generazioneRiscontro"), this.msgDiag.getLivello("ricezioneBusteEGov.", "generazioneRiscontro"));
                                        r = new Riscontro();
                                        r.setID(bustaRichiesta.getID());
                                        r.setOraRegistrazione(bustaHTTPReply.getOraRegistrazione());
                                        r.setTipoOraRegistrazione(this.propertiesReader.getTipoTempoEGov(implementazionePdDMittente));
                                        bustaHTTPReply.setTipoServizioRichiedenteBustaDiServizio(bustaRichiesta.getTipoServizio());
                                        bustaHTTPReply.setServizioRichiedenteBustaDiServizio(bustaRichiesta.getServizio());
                                        bustaHTTPReply.setAzioneRichiedenteBustaDiServizio(bustaRichiesta.getAzione());
                                        bustaHTTPReply.addRiscontro(r);
                                        msgResponse = ejbUtils.buildAndSendRispostaSPCoop(richiestaApplicativa.getIdModuloInAttesa(), bustaHTTPReply, SoapUtils.build_Soap_Empty(), profiloGestione, idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                        break block224;
                                    }
                                    if (!(!"EGOV_IT_MessaggioSingoloOneWay".equals(bustaRichiesta.getProfiloDiCollaborazione()) || this.propertiesReader.isGestioneRiscontri(implementazionePdDMittente) && bustaRichiesta.getConfermaRicezione() || !"eGov1.1-lineeGuida1.1".equals(profiloGestione) && !this.propertiesReader.isGenerazioneSPCoopErroreFiltroDuplicati(implementazionePdDMittente))) {
                                        ejbUtils.sendRispostaSPCoopErroreValidazione(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, Eccezione.getEccezioneValidazione((String)"EGOV_IT_110", (String)"Messaggio/Identificatore"), idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                        openspcoopstate.releaseResource();
                                        esito.setEsitoInvocazione(true);
                                        esito.setStatoInvocazione(2);
                                        return esito;
                                    }
                                    if ("EGOV_IT_ServizioSincrono".equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                                        ejbUtils.sendRispostaSPCoopErroreValidazione(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, Eccezione.getEccezioneValidazione((String)"EGOV_IT_110", (String)"Messaggio/Identificatore"), idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                        openspcoopstate.releaseResource();
                                        esito.setEsitoInvocazione(true);
                                        esito.setStatoInvocazione(2);
                                        return esito;
                                    }
                                    if (!"EGOV_IT_ServizioAsincronoSimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione()) && !"EGOV_IT_ServizioAsincronoAsimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione())) break block225;
                                    ricevuta = null;
                                    if (!"EGOV_IT_ServizioAsincronoSimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione())) ** GOTO lbl313
                                    this.msgDiag.mediumDebug("Lettura Porta Applicativa ...");
                                    pa = this.configurazionePdDReader.getPortaApplicativa_SafeMethod(richiestaApplicativa.getIdPortaApplicativa(), richiestaApplicativa.getFiltroProprietaPorteApplicative());
                                    if (!this.configurazionePdDReader.ricevutaAsincronaSimmetricaAbilitata(pa)) {
                                        if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                                            ricevuta = "ricevuta di una richiesta asincrona simmetrica";
                                        } else if ("Risposta".equals(ruoloBustaEgovRicevuta)) {
                                            ricevuta = "ricevuta di una risposta asincrona simmetrica";
                                        }
                                    } else {
                                        ejbUtils.sendRispostaSPCoopErroreValidazione(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, Eccezione.getEccezioneValidazione((String)"EGOV_IT_110", (String)"Messaggio/Identificatore"), idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                        openspcoopstate.releaseResource();
                                        esito.setEsitoInvocazione(true);
                                        esito.setStatoInvocazione(2);
                                        return esito;
lbl313:
                                        // 1 sources

                                        this.msgDiag.mediumDebug("Lettura Porta Applicativa ...");
                                        pa = this.configurazionePdDReader.getPortaApplicativa_SafeMethod(richiestaApplicativa.getIdPortaApplicativa(), richiestaApplicativa.getFiltroProprietaPorteApplicative());
                                        if (!this.configurazionePdDReader.ricevutaAsincronaAsimmetricaAbilitata(pa)) {
                                            if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                                                ricevuta = "ricevuta di una richiesta asincrona asimmetrica";
                                            } else if ("Risposta".equals(ruoloBustaEgovRicevuta)) {
                                                ricevuta = "ricevuta di una risposta asincrona asimmetrica";
                                            }
                                        } else {
                                            ejbUtils.sendRispostaSPCoopErroreValidazione(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, Eccezione.getEccezioneValidazione((String)"EGOV_IT_110", (String)"Messaggio/Identificatore"), idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                            openspcoopstate.releaseResource();
                                            esito.setEsitoInvocazione(true);
                                            esito.setStatoInvocazione(2);
                                            return esito;
                                        }
                                    }
                                    if (ricevuta != null) {
                                        this.msgDiag.addKeyword("@TIPO_RICEVUTA_ASINCRONA@", ricevuta);
                                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("ricezioneBusteEGov.", "generazioneRicevutaAsincrona"), this.msgDiag.getLivello("ricezioneBusteEGov.", "generazioneRicevutaAsincrona"));
                                        bustaHTTPReply.setServizio(bustaRichiesta.getServizio());
                                        bustaHTTPReply.setTipoServizio(bustaRichiesta.getTipoServizio());
                                        bustaHTTPReply.setAzione(bustaRichiesta.getAzione());
                                        bustaHTTPReply.setProfiloDiCollaborazione("EGOV_IT_ServizioAsincronoSimmetrico");
                                        bustaHTTPReply.setRiferimentoMessaggio(bustaRichiesta.getID());
                                        if (this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDMittente)) {
                                            bustaHTTPReply.setCollaborazione(bustaRichiesta.getCollaborazione());
                                        }
                                        if ("eGov1.1-lineeGuida1.1".equals(profiloGestione)) {
                                            bustaHTTPReply.setConfermaRicezione(false);
                                            bustaHTTPReply.setInoltro("EGOV_IT_ALPIUUNAVOLTA");
                                        }
                                        msgResponse = ejbUtils.buildAndSendRispostaSPCoop(richiestaApplicativa.getIdModuloInAttesa(), bustaHTTPReply, SoapUtils.build_Soap_Empty(), profiloGestione, idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                    }
                                    break block224;
                                }
                                if ("eGov1.1-lineeGuida1.1".equals(profiloGestione) || this.propertiesReader.isGenerazioneSPCoopErroreFiltroDuplicati(implementazionePdDMittente)) {
                                    ejbUtils.sendRispostaSPCoopErroreValidazione(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, Eccezione.getEccezioneValidazione((String)"EGOV_IT_110", (String)"Messaggio/Identificatore"), idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                    openspcoopstate.releaseResource();
                                    esito.setEsitoInvocazione(true);
                                    esito.setStatoInvocazione(2);
                                    return esito;
                                }
                                if (sendSbloccoRicezioneBusteEGov) {
                                    msgResponse = ejbUtils.sendSbloccoRicezioneBusteEGov(richiestaApplicativa.getIdModuloInAttesa());
                                }
                            }
                            ejbUtils.releaseInboxMessage(false, true);
                            if (msgResponse != null) {
                                msgResponse.addMessaggiIntoCache_readFromTable("Sbustamento", "risposta in seguito a busta duplicata");
                            }
                            if (msgResponse != null) {
                                msgResponse.addProprietariIntoCache_readFromTable("Sbustamento", "risposta in seguito a busta duplicata", idEGovRequest, false);
                            }
                            openspcoopstate.releaseResource();
                            esito.setEsitoInvocazione(true);
                            esito.setStatoInvocazione(1);
                            return esito;
                        }
                        if (!bustaRegistrataConHistory) {
                            historyBuste.registraBustaRicevuta(bustaRichiesta.getID());
                        }
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("ricezioneBusta.registrazionePerFiltroDuplicati"), this.msgDiag.getLivello("ricezioneBusta.registrazionePerFiltroDuplicati"));
                    }
                    catch (Exception e) {
                        this.msgDiag.logErroreGenerico(e, "GestioneHistoryBusteRicevute");
                        ejbUtils.rollbackMessage("Gestione dell'history delle buste ricevute non riuscita");
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(false);
                        esito.setStatoInvocazione(3);
                        return esito;
                    }
                }
                if (!"eGov1.1-lineeGuida1.1".equals(profiloGestione) && this.propertiesReader.isGestioneRiscontri(implementazionePdDMittente)) {
                    this.msgDiag.mediumDebug("Gestione eventuali riscontri da inviare...");
                    senza_piggy_backing = true;
                    if ("EGOV_IT_MessaggioSingoloOneWay".equals(bustaRichiesta.getProfiloDiCollaborazione()) && senza_piggy_backing && bustaRichiesta.getConfermaRicezione()) {
                        r = new Riscontro();
                        r.setID(bustaRichiesta.getID());
                        r.setOraRegistrazione(bustaHTTPReply.getOraRegistrazione());
                        r.setTipoOraRegistrazione(this.propertiesReader.getTipoTempoEGov(implementazionePdDMittente));
                        bustaHTTPReply.addRiscontro(r);
                        bustaHTTPReply.setTipoServizioRichiedenteBustaDiServizio(bustaRichiesta.getTipoServizio());
                        bustaHTTPReply.setServizioRichiedenteBustaDiServizio(bustaRichiesta.getServizio());
                        bustaHTTPReply.setAzioneRichiedenteBustaDiServizio(bustaRichiesta.getAzione());
                        returnSPCoopReply = true;
                    }
                }
                v2 = gestioneAbilitata = "eGov1.1-lineeGuida1.1".equals(profiloGestione) == false && this.propertiesReader.isGestioneRiscontri(implementazionePdDMittente) != false && this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDMittente) != false && this.propertiesReader.isGestioneConsegnaInOrdine(implementazionePdDMittente) != false;
                if (gestioneAbilitata && bustaRichiesta.getSequenza() != -1L && !"EGOV_IT_MessaggioSingoloOneWay".equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                    this.msgDiag.mediumDebug("Gestione vincoli consegna in ordine...");
                    this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("consegnaInOrdine.profiloDiversoOneway"), this.msgDiag.getLivello("consegnaInOrdine.profiloDiversoOneway"));
                    e = Eccezione.getEccezioneValidazione((String)"EGOV_IT_401", (String)"Sequenza");
                    ejbUtils.sendRispostaSPCoopErroreValidazione(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, e, idCorrelazioneApplicativa, servizioApplicativoFruitore);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2);
                    return esito;
                }
                scenarioCooperazione = null;
                generazioneMsgOK = false;
                existsPA = true;
                pa = null;
                sa = null;
                integrazioneAsincrona = null;
                if ("EGOV_IT_MessaggioSingoloOneWay".equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                    this.msgDiag.mediumDebug("Gestione profilo di collaborazione OneWay...");
                    scenarioCooperazione = "OneWay_InvocazioneServizio";
                    this.msgDiag.mediumDebug("Gestione profilo di collaborazione OneWay (existsPA)...");
                    try {
                        existsPA = this.configurazionePdDReader.existsPA(richiestaApplicativa);
                    }
                    catch (Exception e) {
                        this.msgDiag.logErroreGenerico(e, "existsPA(richiestaApplicativa,oneway)");
                        ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_536", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2);
                        return esito;
                    }
                    if (!existsPA) {
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("portaApplicativaNonEsistente"), this.msgDiag.getLivello("portaApplicativaNonEsistente"));
                        ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_450", "La porta applicativa richiesta dalla busta eGov non esiste ", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2);
                        return esito;
                    }
                    this.msgDiag.mediumDebug("Lettura Porta Applicativa ...");
                    pa = this.configurazionePdDReader.getPortaApplicativa_SafeMethod(richiestaApplicativa.getIdPortaApplicativa(), richiestaApplicativa.getFiltroProprietaPorteApplicative());
                    generazioneMsgOK = this.configurazionePdDReader.isModalitaStatelessByProfiloServizio(pa, bustaRichiesta.getProfiloDiCollaborazione()) == false;
                    if (newConnectionForResponse && !bustaRichiesta.getConfermaRicezione()) {
                        dataIngressoMessaggio = msgRequest.getOraRegistrazioneMessaggio();
                    }
                } else {
                    if ("EGOV_IT_ServizioSincrono".equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                        this.msgDiag.mediumDebug("Gestione profilo di collaborazione Sincrono...");
                        if (bustaRichiesta.getRiferimentoMessaggio() != null) {
                            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("ricezioneRispostaSincrona"), this.msgDiag.getLivello("ricezioneRispostaSincrona"));
                            ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_525", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                            openspcoopstate.releaseResource();
                            esito.setEsitoInvocazione(true);
                            esito.setStatoInvocazione(2);
                            return esito;
                        }
                        scenarioCooperazione = "Sincrono_InvocazioneServizio";
                        this.msgDiag.mediumDebug("Gestione profilo di collaborazione Sincrono (existsPA)...");
                        try {
                            existsPA = this.configurazionePdDReader.existsPA(richiestaApplicativa);
                        }
                        catch (Exception e) {
                            this.msgDiag.logErroreGenerico(e, "existsPA(richiestaApplicativa,sincrono)");
                            ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_536", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                            openspcoopstate.releaseResource();
                            esito.setEsitoInvocazione(true);
                            esito.setStatoInvocazione(2);
                            return esito;
                        }
                        if (!existsPA) {
                            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("portaApplicativaNonEsistente"), this.msgDiag.getLivello("portaApplicativaNonEsistente"));
                            ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_450", "La porta applicativa richiesta dalla busta eGov non esiste ", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                            openspcoopstate.releaseResource();
                            esito.setEsitoInvocazione(true);
                            esito.setStatoInvocazione(2);
                            return esito;
                        }
                        this.msgDiag.mediumDebug("Lettura Porta Applicativa ...");
                        pa = this.configurazionePdDReader.getPortaApplicativa_SafeMethod(richiestaApplicativa.getIdPortaApplicativa(), richiestaApplicativa.getFiltroProprietaPorteApplicative());
                        this.msgDiag.mediumDebug("Gestione profilo di collaborazione Sincrono (registra busta ricevuta)...");
                        try {
                            profiloCollaborazione.registraBustaRicevuta(bustaRichiesta.getID());
                        }
                        catch (Exception e) {
                            this.msgDiag.logErroreGenerico(e, "profiloCollaborazione.registraBustaRicevuta(" + bustaRichiesta.getID() + ")");
                            ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_525", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                            openspcoopstate.releaseResource();
                            esito.setEsitoInvocazione(true);
                            esito.setStatoInvocazione(2);
                            return esito;
                        }
                    }
                    if ("EGOV_IT_ServizioAsincronoSimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                        if ("Richiesta".equals(ruoloBustaEgovRicevuta)) {
                            this.msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico richiesta...");
                            scenarioCooperazione = "AsincronoSimmetrico_InvocazioneServizio";
                            this.msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico richiesta (existsPA)...");
                            try {
                                existsPA = this.configurazionePdDReader.existsPA(richiestaApplicativa);
                            }
                            catch (Exception e) {
                                this.msgDiag.logErroreGenerico(e, "existsPA(richiestaApplicativa,asincronoSimmetricoRichiesta)");
                                ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_536", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2);
                                return esito;
                            }
                            if (!existsPA) {
                                this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("portaApplicativaNonEsistente"), this.msgDiag.getLivello("portaApplicativaNonEsistente"));
                                ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_450", "La porta applicativa richiesta dalla busta eGov non esiste ", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2);
                                return esito;
                            }
                            this.msgDiag.mediumDebug("Lettura Porta Applicativa ...");
                            pa = this.configurazionePdDReader.getPortaApplicativa_SafeMethod(richiestaApplicativa.getIdPortaApplicativa(), richiestaApplicativa.getFiltroProprietaPorteApplicative());
                            this.msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico richiesta (controllo ricevuta abilitata)...");
                            try {
                                richiestaApplicativa.setRicevutaAsincrona(this.configurazionePdDReader.ricevutaAsincronaSimmetricaAbilitata(pa));
                            }
                            catch (Exception e) {
                                this.msgDiag.logErroreGenerico(e, "ricevutaAsincronaSimmetricaAbilitata(pa)");
                                ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_536", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2);
                                return esito;
                            }
                            generazioneMsgOK = this.configurazionePdDReader.isModalitaStatelessByProfiloServizio(pa, bustaRichiesta.getProfiloDiCollaborazione()) == false ? richiestaApplicativa.isRicevutaAsincrona() == false : false;
                            this.msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico richiesta (registrazione busta ricevuta)...");
                            try {
                                tipoServizioCorrelato = null;
                                servizioCorrelato = null;
                                if (bustaRichiesta.getTipoServizioCorrelato() != null && bustaRichiesta.getServizioCorrelato() != null) {
                                    tipoServizioCorrelato = bustaRichiesta.getTipoServizioCorrelato();
                                    servizioCorrelato = bustaRichiesta.getServizioCorrelato();
                                } else {
                                    validazione = this.registroServiziReader.validaServizio(idSoggettoFruitore, idServizio, null);
                                    if (validazione == null || !validazione.getServizioRegistrato()) {
                                        throw new Exception("Servizio [" + idServizio.toString() + "] non esiste nel registro dei servizi");
                                    }
                                    if (validazione.getServizioCorrelato() == null || validazione.getTipoServizioCorrelato() == null) {
                                        throw new Exception("Servizio [" + idServizio.toString() + "] non possiede un servizio correlato associato");
                                    }
                                    tipoServizioCorrelato = validazione.getTipoServizioCorrelato();
                                    servizioCorrelato = validazione.getServizioCorrelato();
                                }
                                collaborazione = null;
                                if (this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDMittente)) {
                                    collaborazione = bustaRichiesta.getCollaborazione();
                                }
                                profiloCollaborazione.asincronoSimmetrico_registraRichiestaRicevuta(bustaRichiesta.getID(), collaborazione, tipoServizioCorrelato, servizioCorrelato, richiestaApplicativa.isRicevutaAsincrona(), this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi());
                            }
                            catch (Exception e) {
                                this.msgDiag.logErroreGenerico(e, "SalvataggioInformazioniProfiloAsincronoSimmetrico");
                                ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_525", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2);
                                return esito;
                            }
                            if (generazioneMsgOK) {
                                returnSPCoopReply = true;
                                bustaHTTPReply.setServizio(bustaRichiesta.getServizio());
                                bustaHTTPReply.setTipoServizio(bustaRichiesta.getTipoServizio());
                                bustaHTTPReply.setAzione(bustaRichiesta.getAzione());
                                bustaHTTPReply.setProfiloDiCollaborazione("EGOV_IT_ServizioAsincronoSimmetrico");
                                bustaHTTPReply.setRiferimentoMessaggio(bustaRichiesta.getID());
                                if (this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDMittente)) {
                                    bustaHTTPReply.setCollaborazione(bustaRichiesta.getCollaborazione());
                                }
                                if ("eGov1.1-lineeGuida1.1".equals(profiloGestione)) {
                                    bustaHTTPReply.setConfermaRicezione(false);
                                    bustaHTTPReply.setInoltro("EGOV_IT_ALPIUUNAVOLTA");
                                }
                            }
                        } else {
                            if ("Risposta".equals(ruoloBustaEgovRicevuta)) {
                                this.msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico risposta...");
                                scenarioCooperazione = "AsincronoSimmetrico_ConsegnaRisposta";
                            } else if ("RicevutaRichiesta".equals(ruoloBustaEgovRicevuta)) {
                                this.msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico ricevuta richiesta asincrona...");
                                ricevutaAsincrona = "ricevuta di una richiesta asincrona simmetrica";
                            } else if ("RicevutaRisposta".equals(ruoloBustaEgovRicevuta)) {
                                this.msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico ricevuta risposta asincrona ...");
                                ricevutaAsincrona = "ricevuta di una risposta asincrona simmetrica";
                            } else {
                                this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("profiloAsincrono.flussoRicevutaRichiestaRispostaNonCorretto"), this.msgDiag.getLivello("profiloAsincrono.flussoRicevutaRichiestaRispostaNonCorretto"));
                                ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_525", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2);
                                return esito;
                            }
                            this.msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico risposta (raccolta dati per consegna risposta)...");
                            try {
                                if (ricevutaAsincrona == null) {
                                    if ("eGov1.1-lineeGuida1.1".equals(profiloGestione)) {
                                        integrazioneAsincrona = profiloCollaborazione.asincronoSimmetrico_getDatiConsegnaRisposta(bustaRichiesta.getCollaborazione());
                                    }
                                    integrazioneAsincrona = profiloCollaborazione.asincronoSimmetrico_getDatiConsegnaRisposta(bustaRichiesta.getRiferimentoMessaggio());
                                }
                                integrazioneAsincrona = profiloCollaborazione.asincronoSimmetrico_getDatiConsegnaRicevuta(bustaRichiesta.getRiferimentoMessaggio());
                            }
                            catch (Exception e) {
                                this.msgDiag.logErroreGenerico(e, "RaccoltaDatiIntegrazioneProfiloAsincronoSimmetrico");
                                ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_525", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2);
                                return esito;
                            }
                        }
                    } else if ("EGOV_IT_ServizioAsincronoAsimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                        if ("Richiesta".equals(ruoloBustaEgovRicevuta)) {
                            this.msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoAsimmetrico richiesta...");
                            scenarioCooperazione = "AsincronoAsimmetrico_InvocazioneServizio";
                            this.msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoAsimmetrico richiesta (existsPA)...");
                            try {
                                existsPA = this.configurazionePdDReader.existsPA(richiestaApplicativa);
                            }
                            catch (Exception e) {
                                this.msgDiag.logErroreGenerico(e, "existsPA(richiestaApplicativa,asincronoAsimmetricoRichiesta)");
                                ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_536", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2);
                                return esito;
                            }
                            if (!existsPA) {
                                this.msgDiag.logPersonalizzato("(Richiesta) " + this.msgDiag.getMessaggio("portaApplicativaNonEsistente"), this.msgDiag.getLivello("portaApplicativaNonEsistente"));
                                ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_450", "La porta applicativa richiesta dalla busta eGov non esiste ", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2);
                                return esito;
                            }
                            this.msgDiag.mediumDebug("Lettura Porta Applicativa ...");
                            pa = this.configurazionePdDReader.getPortaApplicativa_SafeMethod(richiestaApplicativa.getIdPortaApplicativa(), richiestaApplicativa.getFiltroProprietaPorteApplicative());
                            this.msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoAsimmetrico richiesta (lettura servizio applicativo)...");
                            servizioApplicativo = null;
                            try {
                                servizioApplicativo = this.configurazionePdDReader.getServiziApplicativi(pa);
                                if (servizioApplicativo == null) {
                                    throw new Exception("Servizio applicativo non esistente");
                                }
                                if (servizioApplicativo.length > 1) {
                                    throw new Exception("profilo non utilizzabile con una porta applicativa a cui sono stati associati piu' servizi applicativi");
                                }
                                if (servizioApplicativo.length < 0) {
                                    throw new Exception("Non sono stati associati servizi applicativi alla porta applicativa");
                                }
                            }
                            catch (Exception e) {
                                this.msgDiag.logErroreGenerico(e, "LetturaServizioApplicatiProfiloAsincronoAsimmetrico");
                                ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "Sistema non disponibile", "OPENSPCOOP_ORG_525", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2);
                                return esito;
                            }
                            richiestaApplicativa.setServizioApplicativo(servizioApplicativo[0]);
                            this.msgDiag.mediumDebug("Lettura Servizio Applicativo ...");
                            try {
                                sa = this.configurazionePdDReader.getServizioApplicativo(richiestaApplicativa.getIdPortaApplicativa(), servizioApplicativo[0]);
                            }
                            catch (DriverConfigurazioneNotFound e) {
                                this.msgDiag.logErroreGenerico("Servizio applicativo [" + servizioApplicativo[0] + "] non esistente", "getServizioApplicativoProfiloAsincronoAsimmetrico");
                                ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_453", "Il servizio applicativo associato alla porta applicativa richiesta dalla busta eGov non esiste ", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2);
                                return esito;
                            }
                            catch (Exception e) {
                                this.msgDiag.logErroreGenerico(e, "getServizioApplicativoProfiloAsincronoAsimmetrico");
                                ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_536", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2);
                                return esito;
                            }
                            this.msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoAsimmetrico richiesta (exists ConsegnaRispostAsincrona)...");
                            existsConsegnaRispostaAsincrona = false;
                            this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_EROGATORE@", sa.getNome());
                            try {
                                existsConsegnaRispostaAsincrona = this.configurazionePdDReader.existsConsegnaRispostaAsincrona(sa);
                            }
                            catch (Exception e) {
                                this.msgDiag.logErroreGenerico(e, "existsConsegnaRispostaAsincrona_ProfiloAsincronoAsimmetrico");
                                ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_536", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2);
                                return esito;
                            }
                            if (!existsConsegnaRispostaAsincrona) {
                                this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("profiloAsincronoAsimmetrico.saSenzaRispostaAsincrona"), this.msgDiag.getLivello("profiloAsincronoAsimmetrico.saSenzaRispostaAsincrona"));
                                ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_411", "Definizione 'Ricezione Risposta Asincrona' necessaria per invocare il servizio richiesto.", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2);
                                return esito;
                            }
                            this.msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoAsimmetrico richiesta (servizio correlato)...");
                            if (sbustamentoMsg.getServizioCorrelato() == null || sbustamentoMsg.getTipoServizioCorrelato() == null) {
                                this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("profiloAsincronoAsimmetrico.servizioCorrelatoNonEsistente"), this.msgDiag.getLivello("profiloAsincronoAsimmetrico.servizioCorrelatoNonEsistente"));
                                ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_408", "Servizio correlato, associato al servizio SPCoop richiesto con la porta delegata, non trovato nel registro dei servizi di OpenSPCoop", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2);
                                return esito;
                            }
                            this.msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoAsimmetrico richiesta (ricevuta abilitata)...");
                            try {
                                richiestaApplicativa.setRicevutaAsincrona(this.configurazionePdDReader.ricevutaAsincronaAsimmetricaAbilitata(pa));
                            }
                            catch (Exception e) {
                                this.msgDiag.logErroreGenerico(e, "ricevutaAsincronaAsimmetricaAbilitata(pa)");
                                ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_536", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2);
                                return esito;
                            }
                            generazioneMsgOK = this.configurazionePdDReader.isModalitaStatelessByProfiloServizio(pa, bustaRichiesta.getProfiloDiCollaborazione()) == false ? richiestaApplicativa.isRicevutaAsincrona() == false : false;
                            this.msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoAsimmetrico richiesta (registrazione busta ricevuta)...");
                            try {
                                collaborazione = null;
                                if (this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDMittente)) {
                                    collaborazione = bustaRichiesta.getCollaborazione();
                                }
                                scadenza = this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi();
                                profiloCollaborazione.asincronoAsimmetrico_registraRichiestaRicevuta(bustaRichiesta.getID(), collaborazione, sbustamentoMsg.getTipoServizioCorrelato(), sbustamentoMsg.getServizioCorrelato(), richiestaApplicativa.isRicevutaAsincrona(), scadenza);
                            }
                            catch (Exception e) {
                                this.msgDiag.logErroreGenerico(e, "SalvataggioInformazioniProfiloAsincronoAsimmetrico");
                                ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_525", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2);
                                return esito;
                            }
                            if (generazioneMsgOK) {
                                returnSPCoopReply = true;
                                bustaHTTPReply.setServizio(bustaRichiesta.getServizio());
                                bustaHTTPReply.setTipoServizio(bustaRichiesta.getTipoServizio());
                                if (!"eGov1.1-lineeGuida1.1".equals(profiloGestione) && this.propertiesReader.isGenerazioneAttributiAsincroni(implementazionePdDMittente)) {
                                    bustaHTTPReply.setServizioCorrelato(sbustamentoMsg.getServizioCorrelato());
                                    bustaHTTPReply.setTipoServizioCorrelato(sbustamentoMsg.getTipoServizioCorrelato());
                                }
                                bustaHTTPReply.setAzione(bustaRichiesta.getAzione());
                                bustaHTTPReply.setProfiloDiCollaborazione("EGOV_IT_ServizioAsincronoAsimmetrico");
                                bustaHTTPReply.setRiferimentoMessaggio(bustaRichiesta.getID());
                                if (this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDMittente)) {
                                    bustaHTTPReply.setCollaborazione(bustaRichiesta.getCollaborazione());
                                }
                                if ("eGov1.1-lineeGuida1.1".equals(profiloGestione)) {
                                    bustaHTTPReply.setConfermaRicezione(false);
                                    bustaHTTPReply.setInoltro("EGOV_IT_ALPIUUNAVOLTA");
                                }
                            }
                        } else {
                            if ("Risposta".equals(ruoloBustaEgovRicevuta)) {
                                this.msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoAsimmetrico richiesta Stato...");
                                scenarioCooperazione = "AsincronoAsimmetrico_Polling";
                                idServizioOriginale = null;
                                this.msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoAsimmetrico richiesta Stato (lettura servizio originale)...");
                                try {
                                    idServizioOriginale = "eGov1.1-lineeGuida1.1".equals(profiloGestione) ? profiloCollaborazione.asincronoAsimmetrico_getDatiConsegnaRisposta(bustaRichiesta.getCollaborazione()) : profiloCollaborazione.asincronoAsimmetrico_getDatiConsegnaRisposta(bustaRichiesta.getRiferimentoMessaggio());
                                }
                                catch (Exception e) {
                                    this.msgDiag.logErroreGenerico(e, "profiloCollaborazione.asincronoAsimmetrico_getDatiConsegnaRisposta");
                                    ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_525", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                    openspcoopstate.releaseResource();
                                    esito.setEsitoInvocazione(true);
                                    esito.setStatoInvocazione(2);
                                    return esito;
                                }
                                richiestaApplicativa.getIDServizio().setServizio(idServizioOriginale.getServizio());
                                richiestaApplicativa.getIDServizio().setTipoServizio(idServizioOriginale.getTipoServizio());
                                richiestaApplicativa.getIDServizio().setAzione(idServizioOriginale.getAzione());
                                this.msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico richiesta Stato (existsPA)...");
                                try {
                                    existsPA = this.configurazionePdDReader.existsPA(richiestaApplicativa);
                                }
                                catch (Exception e) {
                                    this.msgDiag.logErroreGenerico(e, "existsPA(richiestaApplicativa,asincronoAsimmetricoRichiestaStato)");
                                    ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_536", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                    openspcoopstate.releaseResource();
                                    esito.setEsitoInvocazione(true);
                                    esito.setStatoInvocazione(2);
                                    return esito;
                                }
                                if (!existsPA) {
                                    this.msgDiag.logPersonalizzato("(RichiestaStato) " + this.msgDiag.getMessaggio("portaApplicativaNonEsistente"), this.msgDiag.getLivello("portaApplicativaNonEsistente"));
                                    ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_450", "La porta applicativa richiesta dalla busta eGov non esiste ", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                    openspcoopstate.releaseResource();
                                    esito.setEsitoInvocazione(true);
                                    esito.setStatoInvocazione(2);
                                    return esito;
                                }
                                this.msgDiag.mediumDebug("Lettura Porta Applicativa ...");
                                pa = this.configurazionePdDReader.getPortaApplicativa_SafeMethod(richiestaApplicativa.getIdPortaApplicativa(), richiestaApplicativa.getFiltroProprietaPorteApplicative());
                            } else if ("RicevutaRichiesta".equals(ruoloBustaEgovRicevuta)) {
                                this.msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico ricevuta richiesta...");
                                ricevutaAsincrona = "ricevuta di una richiesta asincrona asimmetrica";
                            } else if ("RicevutaRisposta".equals(ruoloBustaEgovRicevuta)) {
                                this.msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico ricevuta risposta...");
                                ricevutaAsincrona = "ricevuta di una risposta asincrona asimmetrica contenente l'esito della richiesta stato";
                            } else {
                                this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("profiloAsincrono.flussoRicevutaRichiestaRispostaNonCorretto"), this.msgDiag.getLivello("profiloAsincrono.flussoRicevutaRichiestaRispostaNonCorretto"));
                                ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_525", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2);
                                return esito;
                            }
                            try {
                                if (ricevutaAsincrona == null) ** GOTO lbl793
                                this.msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoAsimmetrico ricevuta (raccolta dati consegna per ricevuta)...");
                                integrazioneAsincrona = profiloCollaborazione.asincronoAsimmetrico_getDatiConsegnaRicevuta(bustaRichiesta.getRiferimentoMessaggio());
                            }
                            catch (Exception e) {
                                this.msgDiag.logErroreGenerico(e, "RaccoltaDatiIntegrazioneProfiloAsincronoAsimmetrico");
                                ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_525", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2);
                                return esito;
                            }
                        }
                    } else {
                        ecc = Eccezione.getEccezioneValidazione((String)"EGOV_IT_103", (String)("Busta eGov con profilo di collaborazione non gestito [" + bustaRichiesta.getProfiloDiCollaborazione() + "]"));
                        if (bustaRichiesta.getProfiloDiCollaborazione() == null) {
                            ecc.setPosizione("Busta egov senza Profilo di Collaborazione");
                        }
                        this.msgDiag.addKeyword("@ECCEZIONI@", ecc.toString());
                        this.msgDiag.addKeyword("@NUMERO_ECCEZIONI@", "1");
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("validazioneBusta.bustaNonCorretta"), this.msgDiag.getLivello("validazioneBusta.bustaNonCorretta"));
                        ecc.setPosizione("ProfiloCollaborazione");
                        ejbUtils.sendRispostaSPCoopErroreValidazione(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ecc, idCorrelazioneApplicativa, servizioApplicativoFruitore);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2);
                        return esito;
                    }
                }
lbl793:
                // 11 sources

                this.msgDiag.mediumDebug("Gestione profilo di collaborazione Asincrono, raccolta dati consegna...");
                consegnaApplicativaAsincrona = null;
                pdConsegnaApplicativaAsincrona = null;
                saConsegnaApplicativaAsincrona = null;
                try {
                    block220: {
                        if (integrazioneAsincrona == null) break block219;
                        soggettoFruitoreRichiestaAsincrona = new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario());
                        soggettoErogatoreRichiestaAsincrona = new IDSoggetto(bustaRichiesta.getTipoMittente(), bustaRichiesta.getMittente());
                        servizioRichiestaAsincrona = new IDServizio(soggettoErogatoreRichiestaAsincrona, bustaRichiesta.getTipoServizio(), bustaRichiesta.getServizio(), bustaRichiesta.getAzione());
                        proprietaErroreApplAsincrono = this.propertiesReader.getProprietaGestioneErrorePD();
                        proprietaErroreApplAsincrono.setDominio(identitaPdD.getCodicePorta());
                        proprietaErroreApplAsincrono.setIdModulo("Sbustamento");
                        consegnaApplicativaAsincrona = new RichiestaDelegata(soggettoFruitoreRichiestaAsincrona, integrazioneAsincrona.getLocationPD(), integrazioneAsincrona.getServizioApplicativo(), servizioRichiestaAsincrona, null, proprietaErroreApplAsincrono, identitaPdD);
                        consegnaApplicativaAsincrona.setScenario(scenarioCooperazione);
                        consegnaApplicativaAsincrona.setProfiloGestione(profiloGestione);
                        pdConsegnaApplicativaAsincrona = this.configurazionePdDReader.getPortaDelegata(consegnaApplicativaAsincrona.getIdPortaDelegata());
                        try {
                            saConsegnaApplicativaAsincrona = this.configurazionePdDReader.getServizioApplicativo(consegnaApplicativaAsincrona.getIdPortaDelegata(), consegnaApplicativaAsincrona.getServizioApplicativo());
                        }
                        catch (Exception e) {
                            if (e instanceof DriverConfigurazioneNotFound && "Anonimo".equals(consegnaApplicativaAsincrona.getServizioApplicativo())) break block220;
                            throw e;
                        }
                    }
                    this.configurazionePdDReader.aggiornaProprietaGestioneErrorePD(proprietaErroreApplAsincrono, saConsegnaApplicativaAsincrona);
                    if ("EGOV_IT_ServizioAsincronoSimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                        consegnaApplicativaAsincrona.setRicevutaAsincrona(this.configurazionePdDReader.ricevutaAsincronaSimmetricaAbilitata(pdConsegnaApplicativaAsincrona));
                    } else if ("RicevutaRisposta".equals(ruoloBustaEgovRicevuta)) {
                        consegnaApplicativaAsincrona.setRicevutaAsincrona(true);
                    } else {
                        consegnaApplicativaAsincrona.setRicevutaAsincrona(this.configurazionePdDReader.ricevutaAsincronaAsimmetricaAbilitata(pdConsegnaApplicativaAsincrona));
                    }
                    if (ricevutaAsincrona != null) {
                        consegnaApplicativaAsincrona.setUtilizzoConsegnaAsincrona(true);
                        if (profiloCollaborazione.asincrono_spedizioneRichiestaInCorso(bustaRichiesta.getRiferimentoMessaggio()) && "EGOV_IT_ServizioAsincronoSimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                            consegnaApplicativaAsincrona.setUtilizzoConsegnaAsincrona(false);
                        }
                        consegnaApplicativaAsincrona.setIdModuloInAttesa(integrazioneAsincrona.getIdModuloInAttesa());
                    } else {
                        consegnaApplicativaAsincrona.setIdModuloInAttesa(richiestaApplicativa.getIdModuloInAttesa());
                        if (!consegnaApplicativaAsincrona.isRicevutaAsincrona()) {
                            if ("eGov1.1-lineeGuida1.1".equals(profiloGestione)) {
                                profiloCollaborazione.eliminaBustaInviata(bustaRichiesta.getCollaborazione(), true);
                            } else {
                                profiloCollaborazione.eliminaBustaInviata(bustaRichiesta.getRiferimentoMessaggio(), true);
                            }
                        }
                        consegnaApplicativaAsincrona.setUtilizzoConsegnaAsincrona(true);
                        generazioneMsgOK = this.configurazionePdDReader.isModalitaStatelessByProfiloServizio(pdConsegnaApplicativaAsincrona, bustaRichiesta.getProfiloDiCollaborazione()) == false ? consegnaApplicativaAsincrona.isRicevutaAsincrona() == false : false;
                        if (generazioneMsgOK) {
                            returnSPCoopReply = true;
                            bustaHTTPReply.setServizio(bustaRichiesta.getServizio());
                            bustaHTTPReply.setTipoServizio(bustaRichiesta.getTipoServizio());
                            bustaHTTPReply.setAzione(bustaRichiesta.getAzione());
                            bustaHTTPReply.setProfiloDiCollaborazione("EGOV_IT_ServizioAsincronoSimmetrico");
                            bustaHTTPReply.setRiferimentoMessaggio(bustaRichiesta.getID());
                            if (this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDMittente)) {
                                bustaHTTPReply.setCollaborazione(bustaRichiesta.getCollaborazione());
                            }
                            bustaHTTPReply.setRiferimentoMsgBustaRichiedenteServizio(bustaRichiesta.getRiferimentoMessaggio());
                            if ("eGov1.1-lineeGuida1.1".equals(profiloGestione)) {
                                bustaHTTPReply.setConfermaRicezione(false);
                                bustaHTTPReply.setInoltro("EGOV_IT_ALPIUUNAVOLTA");
                            }
                        }
                    }
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "GestioneConsegnaProfiloAsincrono");
                    ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_525", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2);
                    return esito;
                }
            }
            this.msgDiag.mediumDebug("Impostazione scenario di cooperazione...");
            try {
                richiestaApplicativa.setScenario(scenarioCooperazione);
                repositoryEGov.aggiornaInfoIntegrazioneIntoInBox_Scenario(bustaRichiesta.getID(), scenarioCooperazione);
                ejbUtils.setScenarioCooperazione(scenarioCooperazione);
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "repositoryEGov.aggiornaInfoIntegrazioneIntoInBox_Scenario");
                ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_525", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(true);
                esito.setStatoInvocazione(2);
                return esito;
            }
            try {
                if (ricevutaAsincrona == null) {
                    if (consegnaApplicativaAsincrona == null) {
                        this.msgDiag.mediumDebug("Invio messaggio a ConsegnaContenutiApplicativi...");
                        ejbUtils.sendToConsegnaContenutiApplicativi(richiestaApplicativa, bustaRichiesta, msgRequest, pa, repositoryEGov);
                        if (ejbUtils.isGestioneStatelessConIntegrationManager()) {
                            generazioneMsgOK = true;
                            sendSbloccoRicezioneBusteEGov = true;
                        }
                    } else {
                        this.msgDiag.mediumDebug("Invio messaggio a ConsegnaContenutiApplicativi (consegnaAsincrona)...");
                        ejbUtils.sendToConsegnaContenutiApplicativi_gestioneMessaggio(consegnaApplicativaAsincrona, bustaRichiesta, msgRequest, saConsegnaApplicativaAsincrona);
                    }
                } else if (consegnaApplicativaAsincrona.isRicevutaAsincrona()) {
                    this.msgDiag.mediumDebug("Invio messaggio asincrono a Ricezione/Consegna ContenutiApplicativi...");
                    ejbUtils.updateIdEGovSessione(bustaRichiesta.getRiferimentoMessaggio());
                    dataIngressoMessaggioT = msgRequest.getOraRegistrazioneMessaggio();
                    msgRequest = ejbUtils.sendRispostaApplicativa(consegnaApplicativaAsincrona, pdConsegnaApplicativaAsincrona, saConsegnaApplicativaAsincrona);
                    msgRequest.aggiornaInfoAttraversamentoPdDMessaggioRisposta(null, null, dataIngressoMessaggioT);
                    ejbUtils.updateIdEGovSessione(idEGovRequest);
                }
                this.msgDiag.setServizioApplicativo(null);
            }
            catch (EJBUtilsConsegnaException e) {
                this.msgDiag.logPersonalizzato(e.getMessaggio(), e.getLivello());
                ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_512", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(true);
                esito.setStatoInvocazione(2);
                return esito;
            }
            catch (Exception e) {
                ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_512", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(true);
                esito.setStatoInvocazione(2);
                return esito;
            }
            oraRegistrazione = msgRequest.getOraRegistrazioneMessaggio();
            if (generazioneMsgOK) {
                try {
                    if (!returnSPCoopReply) {
                        if (!sendSbloccoRicezioneBusteEGov) ** GOTO lbl938
                        this.msgDiag.mediumDebug("Invio messaggio di sblocco a RicezioneBusteEGov...");
                        msgResponse = ejbUtils.sendSbloccoRicezioneBusteEGov(richiestaApplicativa.getIdModuloInAttesa());
                    }
                    this.msgDiag.mediumDebug("Invio messaggio a Ricezione/Consegna ContenutiApplicativi...");
                    msgResponse = ejbUtils.buildAndSendRispostaSPCoop(richiestaApplicativa.getIdModuloInAttesa(), bustaHTTPReply, SoapUtils.build_Soap_Empty(), profiloGestione, idCorrelazioneApplicativa, servizioApplicativoFruitore);
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "GenerazioneMsgOK(Riscontro/Ricevuta/Sblocco)");
                    ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_512", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2);
                    return esito;
                }
            } else if (ricevutaAsincrona != null) {
                try {
                    if (sendSbloccoRicezioneBusteEGov) {
                        this.msgDiag.mediumDebug("Invio messaggio di sblocco a RicezioneBusteEGov (ricevuta asincrona)...");
                        msgResponse = ejbUtils.sendSbloccoRicezioneBusteEGov(richiestaApplicativa.getIdModuloInAttesa());
                    }
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "SendSbloccoDopoRicezione(" + ricevutaAsincrona + ")");
                    ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_512", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2);
                    return esito;
                }
            }
lbl938:
            // 6 sources

            if (msgResponse != null && (!newConnectionForResponse || generazioneMsgOK && returnSPCoopReply)) {
                msgResponse.aggiornaInfoAttraversamentoPdDMessaggioRisposta(oraRegistrazione, DateManager.getTimestamp(), DateManager.getTimestamp());
            }
            this.msgDiag.mediumDebug("Aggiornamento proprietario messaggio...");
            if (ricevutaAsincrona == null) {
                msgRequest.aggiornaProprietarioMessaggio("ConsegnaContenutiApplicativi");
            } else if (consegnaApplicativaAsincrona != null && !consegnaApplicativaAsincrona.isRicevutaAsincrona()) {
                repositoryEGov.eliminaUtilizzoPdDFromInBox(idEGovRequest, true);
                msgRequest.aggiornaProprietarioMessaggio("GestoreMessaggi");
            }
            this.msgDiag.mediumDebug("Commit delle operazioni per la gestione della busta...");
            openspcoopstate.commit();
        }
        catch (Exception e) {
            this.log.error((Object)"ErroreGenerale", (Throwable)e);
            this.msgDiag.logErroreGenerico(e, "Generale");
            if ("EGOV_IT_ServizioSincrono".equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                try {
                    ejbUtils.sendRispostaSPCoopErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, "OPENSPCOOP_ORG_500", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2);
                }
                catch (Exception er) {
                    this.msgDiag.logErroreGenerico(er, "ejbUtils.sendErroreGenerale(profiloConRisposta)");
                    ejbUtils.rollbackMessage("Spedizione Errore al Mittente durante una richiesta sincrona non riuscita");
                    esito.setEsitoInvocazione(false);
                    esito.setStatoInvocazione(3);
                }
            } else {
                ejbUtils.rollbackMessage("ErroreGenerale:" + e.getMessage());
                esito.setStatoInvocazione(3);
                esito.setEsitoInvocazione(false);
            }
            openspcoopstate.releaseResource();
            return esito;
        }
        if (msgRequest != null) {
            msgRequest.addMessaggiIntoCache_readFromTable("Sbustamento", "richiesta");
        }
        if (msgResponse != null) {
            msgResponse.addMessaggiIntoCache_readFromTable("Sbustamento", "risposta");
        }
        if (msgRequest != null) {
            msgRequest.addProprietariIntoCache_readFromTable("Sbustamento", "richiesta", null, false);
        }
        if (msgResponse != null) {
            msgResponse.addProprietariIntoCache_readFromTable("Sbustamento", "risposta", idEGovRequest, false);
        }
        if (ricevutaAsincrona != null) {
            this.msgDiag.mediumDebug("Gestione ricevute asincrone...");
            try {
                isMessaggioDaEliminare = false;
                if (openspcoopstate instanceof OpenSPCoopStateless && "ricevuta di una richiesta asincrona simmetrica".equals(ricevutaAsincrona)) {
                    isMessaggioDaEliminare = true;
                }
                msgRiscontrato = new GestoreMessaggi(openspcoopstate, true, bustaRichiesta.getRiferimentoMessaggio(), "OUTBOX", this.msgDiag);
                msgRiscontrato.setReadyForDrop(isMessaggioDaEliminare);
                msgRiscontrato.validateAndDeleteMsgAsincronoRiscontrato(bustaRichiesta);
                this.msgDiag.addKeyword("@TIPO_RICEVUTA_ASINCRONA@", ricevutaAsincrona);
                this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("validazioneRicevutaAsincrona"), this.msgDiag.getLivello("validazioneRicevutaAsincrona"));
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "Validazione(" + ricevutaAsincrona + ")");
            }
        }
        this.msgDiag.mediumDebug("Rilascio connessione al database...");
        openspcoopstate.releaseResource();
        this.msgDiag.mediumDebug("Lavoro Terminato.");
        if ("EGOV_IT_MessaggioSingoloOneWay".equals(bustaRichiesta.getProfiloDiCollaborazione()) && newConnectionForResponse && !bustaRichiesta.getConfermaRicezione()) {
            info = new InfoAttraversamentoPdD(TipoPdD.APPLICATIVA, idSoggettoFruitore, idServizio.getSoggettoErogatore(), idEGovRequest, idServizio.getTipoServizio(), idServizio.getServizio(), idServizio.getAzione());
            info.setProfiloCollaborazione("EGOV_IT_MessaggioSingoloOneWay");
            info.setStato(true);
            ricezioneMessaggioIngresso = new Date(dataIngressoMessaggio.getTime());
            spedizioneMessaggioIngresso = DateManager.getDate();
            ricezioneMessaggioRisposta = DateManager.getDate();
            spedizioneMessaggioRisposta = DateManager.getDate();
            info.setTimeStamp1(ricezioneMessaggioIngresso);
            info.setTimeStamp2(spedizioneMessaggioIngresso);
            info.setTimeStamp3(ricezioneMessaggioRisposta);
            info.setTimeStamp4(spedizioneMessaggioRisposta);
            NotificaTempiAttraversamentoPdDUtility.notifica(info, this.msgDiag);
        }
        esito.setEsitoInvocazione(true);
        esito.setStatoInvocazione(1);
        return esito;
    }

    public void gestioneErroreSPCoop(EJBUtils ejbUtils, ProfiloDiCollaborazione profiloCollaborazione, RepositoryEGov repositoryEGov, Busta busta, IDSoggetto identitaPdD, Eccezione eccezione, IDSoggetto soggettoProduttoreEccezione) throws Exception {
        if ("EGOV_IT_ServizioSincrono".equals(busta.getProfiloDiCollaborazione()) && busta.getRiferimentoMessaggio() != null) {
            ejbUtils.releaseInboxMessage("OUTBOX", busta.getRiferimentoMessaggio(), true);
        } else if ("EGOV_IT_ServizioAsincronoSimmetrico".equals(busta.getProfiloDiCollaborazione()) || "EGOV_IT_ServizioAsincronoAsimmetrico".equals(busta.getProfiloDiCollaborazione())) {
            Integrazione integrazioneRispostaErrore = null;
            boolean spedizioneRichiestaInCorso = profiloCollaborazione.asincrono_spedizioneRichiestaInCorso(busta.getRiferimentoMessaggio());
            boolean spedizioneRispostaInCorso = profiloCollaborazione.asincrono_spedizioneRispostaInCorso(busta.getRiferimentoMessaggio());
            boolean ricevutaApplicativaAbilitata = true;
            boolean gestioneEffettuata = false;
            if ((spedizioneRichiestaInCorso || spedizioneRispostaInCorso) && (ricevutaApplicativaAbilitata = profiloCollaborazione.asincrono_ricevutaApplicativaAbilitata(busta.getRiferimentoMessaggio()))) {
                try {
                    integrazioneRispostaErrore = repositoryEGov.getInfoIntegrazioneFromOutBox(busta.getRiferimentoMessaggio());
                }
                catch (Exception e) {
                    throw new Exception("Riscontrato errore durante l'esamina dei dati di integrazione per la generazione di una risposta applicativa asincrona, in seguito alla ricezione di un Messaggio SPCoop Errore: " + e.getMessage());
                }
                if (integrazioneRispostaErrore != null) {
                    ServizioApplicativo sappl;
                    PortaDelegata pd;
                    RichiestaDelegata consegnaApplicativaAsincrona;
                    ProprietaErroreApplicativo proprietaErroreApplAsincrono;
                    block14: {
                        IDSoggetto soggettoFruitoreAsincrono = new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario());
                        IDSoggetto soggettoErogatoreAsincrono = new IDSoggetto(busta.getTipoMittente(), busta.getMittente());
                        IDServizio servizioAsincrono = new IDServizio(soggettoErogatoreAsincrono, busta.getTipoServizio(), busta.getServizio(), busta.getAzione());
                        proprietaErroreApplAsincrono = this.propertiesReader.getProprietaGestioneErrorePD();
                        proprietaErroreApplAsincrono.setDominio(identitaPdD.getCodicePorta());
                        proprietaErroreApplAsincrono.setIdModulo(ID_MODULO);
                        consegnaApplicativaAsincrona = new RichiestaDelegata(soggettoFruitoreAsincrono, integrazioneRispostaErrore.getLocationPD(), integrazioneRispostaErrore.getServizioApplicativo(), servizioAsincrono, null, proprietaErroreApplAsincrono, identitaPdD);
                        pd = this.configurazionePdDReader.getPortaDelegata(consegnaApplicativaAsincrona.getIdPortaDelegata());
                        sappl = null;
                        try {
                            sappl = this.configurazionePdDReader.getServizioApplicativo(consegnaApplicativaAsincrona.getIdPortaDelegata(), consegnaApplicativaAsincrona.getServizioApplicativo());
                        }
                        catch (Exception e) {
                            if (e instanceof DriverConfigurazioneNotFound && "Anonimo".equals(consegnaApplicativaAsincrona.getServizioApplicativo())) break block14;
                            throw e;
                        }
                    }
                    this.configurazionePdDReader.aggiornaProprietaGestioneErrorePD(proprietaErroreApplAsincrono, sappl);
                    consegnaApplicativaAsincrona.setUtilizzoConsegnaAsincrona(true);
                    if (spedizioneRichiestaInCorso && "EGOV_IT_ServizioAsincronoSimmetrico".equals(busta.getProfiloDiCollaborazione())) {
                        consegnaApplicativaAsincrona.setUtilizzoConsegnaAsincrona(false);
                    }
                    consegnaApplicativaAsincrona.setIdModuloInAttesa(integrazioneRispostaErrore.getIdModuloInAttesa());
                    Message responseAxisMessageError = this.xmlBuilder.msgErroreApplicativo_Eccezione(proprietaErroreApplAsincrono, eccezione, soggettoProduttoreEccezione);
                    ejbUtils.updateIdEGovSessione(busta.getRiferimentoMessaggio());
                    ejbUtils.sendRispostaApplicativaErrore(responseAxisMessageError, consegnaApplicativaAsincrona, spedizioneRichiestaInCorso, pd, sappl);
                    ejbUtils.updateIdEGovSessione(busta.getID());
                    gestioneEffettuata = true;
                } else if (spedizioneRichiestaInCorso) {
                    ejbUtils.releaseInboxMessage("OUTBOX", busta.getRiferimentoMessaggio(), true);
                    gestioneEffettuata = true;
                }
            }
            if (!gestioneEffettuata) {
                ejbUtils.releaseInboxMessage(true);
            }
        } else {
            ejbUtils.releaseInboxMessage(true);
        }
    }
}

