/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.mdb;

import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.apache.log4j.Logger;
import org.openspcoop.egov.Busta;
import org.openspcoop.pdd.core.node.TransactionManager;
import org.openspcoop.pdd.core.state.OpenSPCoopState;
import org.openspcoop.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.mdb.EsitoLib;
import org.openspcoop.pdd.mdb.InoltroRisposteEGov;
import org.openspcoop.pdd.mdb.InoltroRisposteEGovMessage;
import org.openspcoop.pdd.services.OpenSPCoopStartup;
import org.openspcoop.pdd.timers.TimerMonitoraggioRisorse;

public class InoltroRisposteEGovMDB
implements MessageDrivenBean,
MessageListener {
    private static final long serialVersionUID = 1L;
    private MessageDrivenContext ctxMDB;
    private Logger log = null;

    public void setMessageDrivenContext(MessageDrivenContext mdc) throws EJBException {
        this.ctxMDB = mdc;
    }

    public void ejbCreate() {
    }

    public void ejbRemove() {
    }

    public void onMessage(Message message) {
        if (message instanceof ObjectMessage) {
            if (!OpenSPCoopStartup.initialize) {
                this.ctxMDB.setRollbackOnly();
                return;
            }
            this.log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
            if (this.log == null) {
                System.out.println("[InoltroBusteEGov] Logger nullo. MDB abortito");
                return;
            }
            if (!TimerMonitoraggioRisorse.risorseDisponibili) {
                this.log.error((Object)("[InoltroBusteEGov] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            InoltroRisposteEGov lib = new InoltroRisposteEGov(this.log);
            if (!lib.inizializzazioneUltimata) {
                this.log = Logger.getLogger((String)"OpenSPCoop.InoltroBusteEGov");
                this.log.error((Object)"[InoltroBusteEGov] Inizializzazione MDB non riuscita");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            MsgDiagnostico msgDiag = new MsgDiagnostico("InoltroRisposteEGov");
            msgDiag.mediumDebug("Ricezione richiesta (InoltroRisposteEGovMessage)...");
            ObjectMessage received = (ObjectMessage)message;
            InoltroRisposteEGovMessage inoltroRisposteEGovMsg = null;
            try {
                inoltroRisposteEGovMsg = (InoltroRisposteEGovMessage)received.getObject();
            }
            catch (JMSException e) {
                msgDiag.logErroreGenerico((Exception)((Object)e), "received.getObject(InoltroRisposteEGovMessage)");
                return;
            }
            String idEGovRequest = null;
            try {
                idEGovRequest = received.getStringProperty("ID");
            }
            catch (JMSException e) {
                msgDiag.logErroreGenerico((Exception)((Object)e), "received.getStringProperty(ID)");
                return;
            }
            Busta busta = inoltroRisposteEGovMsg.getBustaRisposta();
            msgDiag.mediumDebug("Transaction Manager...");
            try {
                if (!TransactionManager.validityCheck(msgDiag, "InoltroRisposteEGov", busta.getID(), "OUTBOX", received.getJMSMessageID())) {
                    msgDiag.lowDebug("Messaggio con id[" + idEGovRequest + "] non ha superato il validity check");
                    return;
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "TransactionManager.validityCheck");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            EsitoLib esito = null;
            OpenSPCoopState stato = null;
            try {
                if (inoltroRisposteEGovMsg.getOpenspcoopstate() != null) {
                    stato = inoltroRisposteEGovMsg.getOpenspcoopstate();
                    ((OpenSPCoopStateless)stato).setUseConnection(true);
                    stato.setMessageLib(inoltroRisposteEGovMsg);
                    ((OpenSPCoopStateless)stato).setIDEgovSessione(idEGovRequest);
                } else {
                    stato = new OpenSPCoopStateful();
                    ((OpenSPCoopStateful)stato).setIDEgovSessione(idEGovRequest);
                    ((OpenSPCoopStateful)stato).setMessageLib(inoltroRisposteEGovMsg);
                }
                esito = lib.onMessage(stato);
            }
            catch (Exception e) {
                this.log.error((Object)"[InoltroRisposteEGov] Impossibile chiamare la libreria", (Throwable)e);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!esito.isEsitoInvocazione()) {
                this.log.error((Object)"[InoltroRisposteEGov] Chiamata alla libreria fallita");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            this.log.debug((Object)"[InoltroRisposteEGov] Chiamata alla libreria riuscita");
        }
    }
}

