/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.mdb;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.axis.Message;
import org.apache.axis.message.SOAPFault;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.config.Connettore;
import org.openspcoop.dao.config.ConnettoreProperty;
import org.openspcoop.dao.config.GestioneErrore;
import org.openspcoop.dao.config.PortaApplicativa;
import org.openspcoop.dao.config.driver.DriverConfigurazioneException;
import org.openspcoop.dao.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop.dao.config.driver.IDPortaApplicativa;
import org.openspcoop.dao.config.driver.IDPortaDelegata;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.dao.state.IState;
import org.openspcoop.dao.state.StatefulMessage;
import org.openspcoop.egov.Busta;
import org.openspcoop.egov.Eccezione;
import org.openspcoop.egov.Imbustamento;
import org.openspcoop.egov.Integrazione;
import org.openspcoop.egov.ProfiloDiCollaborazione;
import org.openspcoop.egov.ProprietaManifestAttachments;
import org.openspcoop.egov.ProprietaValidazione;
import org.openspcoop.egov.RepositoryEGov;
import org.openspcoop.egov.Sbustamento;
import org.openspcoop.egov.Trasmissione;
import org.openspcoop.egov.ValidatoreSPCoop;
import org.openspcoop.pdd.config.ClassNameProperties;
import org.openspcoop.pdd.config.ConfigurazionePdDReader;
import org.openspcoop.pdd.core.EJBUtils;
import org.openspcoop.pdd.core.GestoreMessaggi;
import org.openspcoop.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop.pdd.core.connettori.GestoreErroreConnettore;
import org.openspcoop.pdd.core.connettori.IConnettore;
import org.openspcoop.pdd.core.state.IOpenSPCoopState;
import org.openspcoop.pdd.core.state.OpenSPCoopState;
import org.openspcoop.pdd.core.state.OpenSPCoopStateException;
import org.openspcoop.pdd.logger.Dump;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.Tracciamento;
import org.openspcoop.pdd.mdb.EsitoLib;
import org.openspcoop.pdd.mdb.GenericLib;
import org.openspcoop.pdd.mdb.InoltroRisposteEGovMessage;
import org.openspcoop.pdd.monitor.InfoAttraversamentoPdD;
import org.openspcoop.pdd.monitor.NotificaTempiAttraversamentoPdDUtility;
import org.openspcoop.pdd.monitor.TipoPdD;
import org.openspcoop.utils.SoapUtils;
import org.openspcoop.utils.Utilities;
import org.openspcoop.utils.date.DateManager;
import org.openspcoop.wssecurity.WSSBaseUtils;
import org.openspcoop.wssecurity.WSSSender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InoltroRisposteEGov
extends GenericLib {
    public static final String ID_MODULO = "InoltroRisposteEGov";

    public InoltroRisposteEGov(Logger log) {
        super(ID_MODULO, log);
        this.inizializza();
    }

    @Override
    public EsitoLib onMessage(IOpenSPCoopState openspcoopstate) throws OpenSPCoopStateException {
        InoltroRisposteEGovMessage inoltroRisposteEGovMsg = (InoltroRisposteEGovMessage)openspcoopstate.getMessageLib();
        EsitoLib esito = new EsitoLib();
        IDSoggetto identitaPdD = inoltroRisposteEGovMsg.getDominio();
        this.msgDiag.setDominioSPCoop(identitaPdD.getCodicePorta());
        Busta busta = inoltroRisposteEGovMsg.getBustaRisposta();
        boolean inoltroSegnalazioneErrore = inoltroRisposteEGovMsg.getInoltroSegnalazioneErrore();
        String implementazionePdDDestinatario = inoltroRisposteEGovMsg.getImplementazionePdDSoggettoDestinatario();
        this.msgDiag.setPrefixMsgPersonalizzati("inoltroBusteEGov.");
        this.msgDiag.addKeywords(busta, true);
        this.msgDiag.setIdEGovRichiesta(busta.getRiferimentoMessaggio());
        this.msgDiag.setIdEGovRisposta(busta.getID());
        this.msgDiag.setFruitore(new IDSoggetto(busta.getTipoMittente(), busta.getMittente()));
        this.msgDiag.setServizio(new IDServizio(new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario()), busta.getTipoServizio(), busta.getServizio(), busta.getAzione()));
        this.msgDiag.addKeyword("@ID_CORRELAZIONE_APPLICATIVA@", inoltroRisposteEGovMsg.getIdCorrelazioneApplicativa());
        this.msgDiag.mediumDebug("Inizializzo stato per la gestione della richiesta...");
        openspcoopstate.initResource(identitaPdD, ID_MODULO);
        String idEGovRequest = openspcoopstate.getIDEgovSessione();
        this.msgDiag.mediumDebug("Inizializzo contesto per la gestione...");
        IDSoggetto soggettoMittente = new IDSoggetto(busta.getTipoMittente(), busta.getMittente());
        IDSoggetto soggettoDestinatario = new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario());
        String idEGovResponse = busta.getID();
        boolean oneWayVersione11 = inoltroRisposteEGovMsg.isOneWayVersione11();
        boolean functionAsRouter = false;
        this.msgDiag.mediumDebug("Esamina modalita' di ricezione (PdD/Router)...");
        boolean existsSoggetto = false;
        try {
            existsSoggetto = this.configurazionePdDReader.existsSoggetto(soggettoMittente);
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "existsSoggetto(" + soggettoMittente.toString() + ")");
            openspcoopstate.releaseResource();
            esito.setStatoInvocazione(3);
            esito.setEsitoInvocazione(false);
            return esito;
        }
        if (!existsSoggetto) {
            boolean routerFunctionActive = false;
            try {
                routerFunctionActive = this.configurazionePdDReader.routerFunctionActive();
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "routerFunctionActive()");
                openspcoopstate.releaseResource();
                esito.setStatoInvocazione(3);
                esito.setEsitoInvocazione(false);
                return esito;
            }
            if (routerFunctionActive) {
                functionAsRouter = true;
            } else {
                this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("routingTable.soggettoFruitoreNonGestito"), this.msgDiag.getLivello("routingTable.soggettoFruitoreNonGestito"));
                try {
                    GestoreMessaggi msgResponse = new GestoreMessaggi(openspcoopstate, false, idEGovResponse, "OUTBOX", this.msgDiag);
                    msgResponse.setOneWayVersione11(oneWayVersione11);
                    msgResponse.aggiornaProprietarioMessaggio("GestoreMessaggi");
                    RepositoryEGov repositoryEGov = new RepositoryEGov(openspcoopstate.getStatoRisposta(), false);
                    repositoryEGov.eliminaBustaStatelessFromOutBox(busta.getID());
                    openspcoopstate.commit();
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "EliminazioneMessaggioSoggettoFruitoreNonGestito");
                    openspcoopstate.releaseResource();
                    esito.setStatoInvocazione(3);
                    esito.setEsitoInvocazione(false);
                    return esito;
                }
                openspcoopstate.releaseResource();
                esito.setStatoInvocazione(3);
                esito.setEsitoInvocazione(true);
                return esito;
            }
        }
        TipoPdD tipoPorta = TipoPdD.APPLICATIVA;
        if (functionAsRouter) {
            tipoPorta = TipoPdD.ROUTER;
        }
        InfoAttraversamentoPdD info = new InfoAttraversamentoPdD(tipoPorta, soggettoMittente, soggettoDestinatario, idEGovRequest, busta.getTipoServizio(), busta.getServizio(), busta.getAzione());
        info.setIdMessaggioRitorno(busta.getID());
        info.setIdCorrelazione(busta.getCollaborazione());
        info.setProfiloCollaborazione(busta.getProfiloDiCollaborazione());
        info.setStato(false);
        EJBUtils ejbUtils = null;
        try {
            ejbUtils = new EJBUtils(identitaPdD, ID_MODULO, idEGovRequest, idEGovResponse, "OUTBOX", openspcoopstate, this.msgDiag, functionAsRouter, inoltroRisposteEGovMsg.getImplementazionePdDSoggettoMittente(), inoltroRisposteEGovMsg.getImplementazionePdDSoggettoDestinatario());
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "EJBUtils.new");
            openspcoopstate.releaseResource();
            esito.setStatoInvocazione(3);
            esito.setEsitoInvocazione(false);
            return esito;
        }
        ejbUtils.setOneWayVersione11(oneWayVersione11);
        GestoreMessaggi msgResponse = new GestoreMessaggi(openspcoopstate, false, idEGovResponse, "OUTBOX", this.msgDiag);
        msgResponse.setOneWayVersione11(oneWayVersione11);
        GestoreMessaggi msgConnectionReply = null;
        try {
            if (!msgResponse.isRiconsegnaMessaggio(null)) {
                this.msgDiag.lowDebug("Riconsegna messaggio prematura.");
                openspcoopstate.releaseResource();
                esito.setStatoInvocazione(3);
                esito.setEsitoInvocazione(false);
                return esito;
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "msgRequest.isRiconsegnaMessaggio()");
            ejbUtils.rollbackMessage("Errore verifica riconsegna messaggio");
            openspcoopstate.releaseResource();
            esito.setStatoInvocazione(3);
            esito.setEsitoInvocazione(true);
            return esito;
        }
        String profiloGestione = inoltroRisposteEGovMsg.getProfiloGestione();
        this.msgDiag.mediumDebug("Profilo di gestione [InoltroRisposteEGov] della busta: " + profiloGestione);
        RepositoryEGov repositoryEGov = null;
        RepositoryEGov repositoryConnectionReply = null;
        Tracciamento tracciamento = new Tracciamento(identitaPdD.getCodicePorta());
        ProprietaManifestAttachments proprietaManifestAttachments = this.propertiesReader.getProprietaManifestAttachments(implementazionePdDDestinatario);
        boolean readQualifiedAttribute = this.propertiesReader.isReadQualifiedAttribute(implementazionePdDDestinatario);
        try {
            PortaApplicativa pa;
            Date[] dateGestioneMessaggi;
            Message responseAxisMessage;
            Trasmissione tras;
            Connettore connettore;
            block128: {
                connettore = null;
                String erroreRicercaConnettore = null;
                if (functionAsRouter) {
                    this.msgDiag.logPersonalizzato("(Router) " + this.msgDiag.getMessaggio("routingTable.esaminaInCorso"), this.msgDiag.getLivello("routingTable.esaminaInCorso"));
                    try {
                        connettore = this.configurazionePdDReader.getForwardRoute(soggettoDestinatario);
                    }
                    catch (Exception e) {
                        erroreRicercaConnettore = e.getMessage();
                    }
                    this.msgDiag.logPersonalizzato("(Router) " + this.msgDiag.getMessaggio("routingTable.esaminaEffettuata"), this.msgDiag.getLivello("routingTable.esaminaEffettuata"));
                } else if (this.configurazionePdDReader.isUtilizzoIndirizzoTelematico() && busta.getIndirizzoTelematicoDestinatario() != null) {
                    this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("routingTable.utilizzoIndirizzoTelematico"), this.msgDiag.getLivello("routingTable.utilizzoIndirizzoTelematico"));
                    ConnettoreProperty locationIndTel = new ConnettoreProperty();
                    locationIndTel.setNome("location");
                    locationIndTel.setValore(busta.getIndirizzoTelematicoDestinatario());
                    connettore = new Connettore();
                    connettore.setTipo("http");
                    connettore.addProperty(locationIndTel);
                } else {
                    this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("routingTable.esaminaInCorso"), this.msgDiag.getLivello("routingTable.esaminaInCorso"));
                    if (inoltroSegnalazioneErrore) {
                        try {
                            IDServizio idServizio = new IDServizio(soggettoDestinatario, busta.getTipoServizio(), busta.getServizio(), busta.getAzione());
                            connettore = this.configurazionePdDReader.getForwardRoute(soggettoMittente, idServizio);
                        }
                        catch (Exception e) {
                            erroreRicercaConnettore = "RicercaConnettoreSpecializzato, " + e.getMessage();
                        }
                        if (connettore == null) {
                            try {
                                connettore = this.configurazionePdDReader.getForwardRoute(soggettoDestinatario);
                            }
                            catch (Exception e) {
                                erroreRicercaConnettore = "\nRicercaConnettore, " + e.getMessage();
                            }
                        }
                    } else {
                        try {
                            connettore = this.configurazionePdDReader.getForwardRoute(soggettoDestinatario);
                        }
                        catch (Exception e) {
                            erroreRicercaConnettore = e.getMessage();
                        }
                    }
                    this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("routingTable.esaminaEffettuata"), this.msgDiag.getLivello("routingTable.esaminaEffettuata"));
                }
                if (connettore == null) {
                    if (erroreRicercaConnettore != null) {
                        this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", erroreRicercaConnettore);
                        erroreRicercaConnettore = "Riscontrato errore durante la ricerca del connettore a cui inoltrare la busta: " + erroreRicercaConnettore;
                    } else {
                        this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", "non definito");
                        erroreRicercaConnettore = "Riscontrato errore durante la ricerca del connettore a cui inoltrare la busta: non definito";
                    }
                    this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("routingTable.esaminaInCorsoFallita"), this.msgDiag.getLivello("routingTable.esaminaInCorsoFallita"));
                    ejbUtils.rollbackMessage(erroreRicercaConnettore);
                    openspcoopstate.releaseResource();
                    esito.setStatoInvocazione(3);
                    esito.setEsitoInvocazione(false);
                    return esito;
                }
                String soggettoDestinatarioTrasmissione = "";
                tras = null;
                if (this.propertiesReader.isGenerazioneListaTrasmissioni(implementazionePdDDestinatario)) {
                    this.msgDiag.mediumDebug("Aggiunta trasmissione della busta eGov...");
                    tras = new Trasmissione();
                    tras.setOrigine(identitaPdD.getNome());
                    tras.setTipoOrigine(identitaPdD.getTipo());
                    IDSoggetto destTrasm = null;
                    destTrasm = connettore.getNomeDestinatarioTrasmissioneBusta() != null && connettore.getTipoDestinatarioTrasmissioneBusta() != null ? new IDSoggetto(connettore.getTipoDestinatarioTrasmissioneBusta(), connettore.getNomeDestinatarioTrasmissioneBusta()) : new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario());
                    tras.setDestinazione(destTrasm.getNome());
                    tras.setTipoDestinazione(destTrasm.getTipo());
                    tras.setOraRegistrazione(busta.getOraRegistrazione());
                    tras.setTempo(this.propertiesReader.getTipoTempoEGov(implementazionePdDDestinatario));
                    busta.addTrasmissione(tras);
                    if (!soggettoDestinatario.getNome().equals(destTrasm.getNome()) || !soggettoDestinatario.getTipo().equals(destTrasm.getTipo())) {
                        soggettoDestinatarioTrasmissione = " (tramite router " + destTrasm.getTipo() + "/" + destTrasm.getNome() + ")";
                    }
                }
                this.msgDiag.addKeyword("@DESTINATARIO_TRASMISSIONE@", soggettoDestinatarioTrasmissione);
                this.msgDiag.mediumDebug("Lettura messaggio da spedire...");
                responseAxisMessage = null;
                dateGestioneMessaggi = null;
                try {
                    responseAxisMessage = msgResponse.getMessage();
                    dateGestioneMessaggi = msgResponse.getInfoAttraversamentoPdDMessaggioRisposta();
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "msgResponse.getMessage()");
                    ejbUtils.rollbackMessage("Ricostruzione del messaggio Soap da Spedire non riuscita.");
                    openspcoopstate.releaseResource();
                    esito.setStatoInvocazione(3);
                    esito.setEsitoInvocazione(false);
                    return esito;
                }
                pa = null;
                if (!functionAsRouter) {
                    try {
                        IDPortaApplicativa idPA = new IDPortaApplicativa();
                        idPA.setIDServizio(new IDServizio(busta.getTipoMittente(), busta.getMittente(), busta.getTipoServizio(), busta.getServizio(), busta.getAzione()));
                        pa = this.configurazionePdDReader.getPortaApplicativa_SafeMethod(idPA, null);
                    }
                    catch (Exception e) {
                        if (e instanceof DriverConfigurazioneNotFound) break block128;
                        this.msgDiag.logErroreGenerico(e, "getPortaApplicativa_SafeMethod");
                        ejbUtils.rollbackMessage("Ricostruzione errore durante la lettura della porta applicativa.");
                        openspcoopstate.releaseResource();
                        esito.setStatoInvocazione(3);
                        esito.setEsitoInvocazione(false);
                        return esito;
                    }
                }
            }
            boolean scartaBody = false;
            if (!functionAsRouter && !inoltroSegnalazioneErrore && busta.getTipoServizio() != null && busta.getServizio() != null) {
                boolean allegaBody = this.configurazionePdDReader.isAllegaBody(pa);
                scartaBody = allegaBody ? true : this.configurazionePdDReader.isScartaBody(pa);
            }
            if (!functionAsRouter && !inoltroSegnalazioneErrore && busta.sizeListaEccezioni() == 0 && "eGov1.1-lineeGuida1.1".equals(profiloGestione)) {
                RepositoryEGov repositoryEGovRichiesta = new RepositoryEGov(openspcoopstate.getStatoRisposta(), false);
                Vector erroriValidazione = repositoryEGovRichiesta.getErrorsFromInBox(busta.getRiferimentoMessaggio());
                for (int i = 0; i < erroriValidazione.size(); ++i) {
                    Eccezione ec = (Eccezione)erroriValidazione.get(i);
                    if (!"INFO".equals(ec.getRilevanza())) continue;
                    busta.addEccezione(ec);
                }
            }
            this.msgDiag.mediumDebug("Imbustamento eGov...");
            if (inoltroRisposteEGovMsg.isImbustamentoEGov()) {
                try {
                    boolean isRichiesta = false;
                    if (inoltroSegnalazioneErrore) {
                        isRichiesta = true;
                    }
                    Imbustamento imbustatore = new Imbustamento();
                    boolean gestioneManifest = this.configurazionePdDReader.isGestioneManifestAttachments();
                    boolean onlyRefreshIdManifestAttachments = false;
                    if (functionAsRouter) {
                        onlyRefreshIdManifestAttachments = true;
                    }
                    if (!functionAsRouter && !inoltroSegnalazioneErrore && busta.getTipoServizio() != null && busta.getServizio() != null) {
                        IDPortaApplicativa idPA = new IDPortaApplicativa();
                        idPA.setIDServizio(new IDServizio(busta.getTipoMittente(), busta.getMittente(), busta.getTipoServizio(), busta.getServizio(), busta.getAzione()));
                        gestioneManifest = this.configurazionePdDReader.isGestioneManifestAttachments(pa);
                    }
                    if (!(!functionAsRouter || identitaPdD.getTipo().equals(busta.getTipoMittente()) && identitaPdD.getNome().equals(busta.getMittente()))) {
                        imbustatore.addTrasmissione(responseAxisMessage, tras, readQualifiedAttribute);
                    } else {
                        imbustatore.imbustamentoEGov(responseAxisMessage, busta, gestioneManifest, isRichiesta, scartaBody, onlyRefreshIdManifestAttachments, proprietaManifestAttachments);
                    }
                }
                catch (Exception e) {
                    if (functionAsRouter) {
                        this.msgDiag.logErroreGenerico(e, "imbustatore.addTrasmissione");
                    } else {
                        this.msgDiag.logErroreGenerico(e, "imbustatore.imbustamentoEGov");
                    }
                    ejbUtils.rollbackMessage("Imbustamento eGov non riuscito.");
                    openspcoopstate.releaseResource();
                    esito.setStatoInvocazione(3);
                    esito.setEsitoInvocazione(false);
                    return esito;
                }
            }
            if (!inoltroSegnalazioneErrore && !functionAsRouter) {
                WSSSender wssSender;
                this.msgDiag.mediumDebug("Gestione WSS della busta da inoltrare...");
                Hashtable<String, String> wssPropertiesResponse = new Hashtable<String, String>();
                try {
                    this.getWSSProperties(busta, this.configurazionePdDReader, openspcoopstate.getStatoRisposta(), this.msgDiag, wssPropertiesResponse);
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "getWSSProperties");
                    ejbUtils.rollbackMessage("Applicazione WSS non riuscita:" + e.getMessage());
                    openspcoopstate.releaseResource();
                    esito.setStatoInvocazione(3);
                    esito.setEsitoInvocazione(false);
                    return esito;
                }
                WSSBaseUtils baseWSS = null;
                if (wssPropertiesResponse != null && wssPropertiesResponse.size() > 0 && !(wssSender = new WSSSender(wssPropertiesResponse, baseWSS = new WSSBaseUtils(Utilities.getAxisServer(), this.propertiesReader.isGenerazioneActorDefault(implementazionePdDDestinatario), this.propertiesReader.getActorDefault(implementazionePdDDestinatario)))).process(responseAxisMessage)) {
                    this.msgDiag.logErroreGenerico(wssSender.getMsgErrore(), "Costruzione header WSS");
                    ejbUtils.rollbackMessage("Applicazione WSS non riuscita:" + wssSender.getMsgErrore());
                    openspcoopstate.releaseResource();
                    esito.setStatoInvocazione(3);
                    esito.setEsitoInvocazione(false);
                    return esito;
                }
            }
            this.msgDiag.mediumDebug("Rilascio connessione al database...");
            openspcoopstate.releaseResource();
            this.msgDiag.mediumDebug("Impostazione messaggio del connettore...");
            String tipoConnector = connettore.getTipo();
            this.msgDiag.addKeyword("@TIPO_CONNETTORE@", tipoConnector);
            ConnettoreMsg connettoreMsg = new ConnettoreMsg(tipoConnector, responseAxisMessage, connettore.getPropertyList());
            connettoreMsg.setBusta(busta);
            IConnettore connectorSender = null;
            int codiceRitornato = -1;
            Message responseHttpReply = null;
            boolean errorConsegna = false;
            boolean riconsegna = false;
            Timestamp dataRiconsegna = null;
            String motivoErroreConsegna = null;
            boolean invokerNonSupportato = false;
            SOAPFault faultConnectionReply = null;
            ClassNameProperties prop = ClassNameProperties.getInstance();
            String connectorClass = prop.getConnettore(tipoConnector);
            if (connectorClass == null) {
                this.msgDiag.logErroreGenerico("Connettore non registrato", "ClassNameProperties.getConnettore(" + tipoConnector + ")");
                invokerNonSupportato = true;
            }
            if (!invokerNonSupportato) {
                try {
                    Class<?> c = Class.forName(connectorClass);
                    connectorSender = (IConnettore)c.newInstance();
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "IConnettore.newInstance(tipo:" + tipoConnector + " class:" + connectorClass + ")");
                    invokerNonSupportato = true;
                }
                if (!invokerNonSupportato && connectorSender == null) {
                    this.msgDiag.logErroreGenerico("ConnectorSender is null", "IConnettore.newInstance(tipo:" + tipoConnector + " class:" + connectorClass + ")");
                    invokerNonSupportato = true;
                }
            }
            String location = "";
            String locationInoltro = null;
            if (connettoreMsg.getConnectorProperties() != null) {
                if (connettoreMsg.getConnectorProperties().get("location") != null) {
                    locationInoltro = connettoreMsg.getConnectorProperties().get("location");
                }
                if (locationInoltro != null && !locationInoltro.equals("")) {
                    if (busta.getTipoServizio() != null) {
                        location = location.replace("#TipoServizio", busta.getTipoServizio());
                    }
                    if (busta.getServizio() != null) {
                        location = location.replace("#Servizio", busta.getServizio());
                    }
                    if (busta.getAzione() != null) {
                        location = location.replace("#Azione", busta.getAzione());
                    }
                    String locationURL = connettoreMsg.getConnectorProperties().get("location");
                    if (busta.getTipoServizio() != null) {
                        locationURL = locationURL.replace("#TipoServizio", busta.getTipoServizio());
                    }
                    if (busta.getServizio() != null) {
                        locationURL = locationURL.replace("#Servizio", busta.getServizio());
                    }
                    if (busta.getAzione() != null) {
                        locationURL = locationURL.replace("#Azione", busta.getAzione());
                    }
                    connettoreMsg.getConnectorProperties().put("location", locationURL);
                }
                if (locationInoltro != null && !locationInoltro.equals("")) {
                    location = locationInoltro;
                }
            }
            this.msgDiag.addKeyword("@LOCATION@", location);
            if (connettoreMsg.getConnectorProperties() == null) {
                Hashtable<String, String> propCon = new Hashtable<String, String>();
                connettoreMsg.setConnectorProperties(propCon);
            }
            if (connettoreMsg.getConnectorProperties().get("connection-timeout") == null) {
                connettoreMsg.getConnectorProperties().put("connection-timeout", "" + this.propertiesReader.getConnectionTimeout_inoltroBusteEGov());
            }
            if (connettoreMsg.getConnectorProperties().get("read-connection-timeout") == null) {
                connettoreMsg.getConnectorProperties().put("read-connection-timeout", "" + this.propertiesReader.getReadConnectionTimeout_inoltroBusteEGov());
            }
            if (!invokerNonSupportato) {
                GestioneErrore gestioneConsegnaConnettore;
                GestoreErroreConnettore gestoreErrore;
                this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("inoltroInCorso"), this.msgDiag.getLivello("inoltroInCorso"));
                errorConsegna = !connectorSender.send(connettoreMsg);
                motivoErroreConsegna = connectorSender.getErrore();
                if (errorConsegna && motivoErroreConsegna == null) {
                    motivoErroreConsegna = "Errore durante la consegna";
                }
                boolean bl = errorConsegna = !(gestoreErrore = new GestoreErroreConnettore()).verificaConsegna(gestioneConsegnaConnettore = this.configurazionePdDReader.getGestioneErroreConnettoreComponenteCooperazione(), motivoErroreConsegna, connectorSender.getCodiceTrasporto(), connectorSender.getResponse());
                if (errorConsegna) {
                    motivoErroreConsegna = gestoreErrore.getErrore();
                    riconsegna = gestoreErrore.isRiconsegna();
                    dataRiconsegna = gestoreErrore.getDataRispedizione();
                }
                faultConnectionReply = gestoreErrore.getFault();
                codiceRitornato = connectorSender.getCodiceTrasporto();
                responseHttpReply = connectorSender.getResponse();
                this.msgDiag.addKeyword("@CODICE_CONSEGNA@", codiceRitornato + "");
                if (motivoErroreConsegna != null) {
                    this.msgDiag.addKeyword("@ERRORE_CONSEGNA@", motivoErroreConsegna);
                }
                if (responseHttpReply != null && this.configurazionePdDReader.dumpMessaggi()) {
                    Dump dumpApplicativo = new Dump(identitaPdD.getCodicePorta(), ID_MODULO, idEGovRequest);
                    dumpApplicativo.dumpRisposta(responseHttpReply);
                }
            }
            this.msgDiag.mediumDebug("Richiesta connessione al database per la gestione della risposta...");
            openspcoopstate.updateResource();
            if (!invokerNonSupportato) {
                this.msgDiag.mediumDebug("Tracciamento eGov della busta...");
                if (inoltroSegnalazioneErrore) {
                    tracciamento.registraRichiesta(((OpenSPCoopState)openspcoopstate).getConnectionDB(), busta, Tracciamento.createLocationString(false, locationInoltro), inoltroRisposteEGovMsg.getIdCorrelazioneApplicativa(), inoltroRisposteEGovMsg.getServizioApplicativoFruitore());
                } else {
                    tracciamento.registraRisposta(((OpenSPCoopState)openspcoopstate).getConnectionDB(), busta, Tracciamento.createLocationString(false, locationInoltro), inoltroRisposteEGovMsg.getIdCorrelazioneApplicativa(), inoltroRisposteEGovMsg.getServizioApplicativoFruitore());
                }
                if (errorConsegna) {
                    this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("inoltroConErrore"), this.msgDiag.getLivello("inoltroConErrore"));
                } else {
                    String tipoMsg = "Messaggio SPCoop";
                    if (ValidatoreSPCoop.isBustaSPCoopErrore((Busta)busta, (String)profiloGestione)) {
                        tipoMsg = tipoMsg + " Errore";
                    }
                    if (this.configurazionePdDReader.isUtilizzoIndirizzoTelematico() && busta.getIndirizzoTelematicoDestinatario() != null) {
                        this.msgDiag.addKeyword("@LOCATION@", "indirizzoTelematico[" + busta.getIndirizzoTelematicoDestinatario() + "]");
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("inoltroEffettuato"), this.msgDiag.getLivello("inoltroEffettuato"));
                    } else {
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("inoltroEffettuato"), this.msgDiag.getLivello("inoltroEffettuato"));
                    }
                }
            }
            boolean presenzaRispostaSPCoopConnectionReply = false;
            ValidatoreSPCoop validatorConnectionReply = null;
            if (responseHttpReply != null) {
                this.msgDiag.mediumDebug("Analisi della risposta (validazione sintattica)...");
                ProprietaValidazione property = new ProprietaValidazione();
                property.setValidazioneConSchema(this.configurazionePdDReader.isLivelloValidazioneRigido(implementazionePdDDestinatario));
                property.setValidazioneProfiloCollaborazione(this.configurazionePdDReader.isValidazioneProfiloCollaborazione(implementazionePdDDestinatario));
                property.setValidazioneManifestAttachments(this.configurazionePdDReader.isValidazioneManifestAttachments(implementazionePdDDestinatario) && this.configurazionePdDReader.isGestioneManifestAttachments(pa));
                validatorConnectionReply = new ValidatoreSPCoop(responseHttpReply, property, openspcoopstate.getStatoRisposta(), readQualifiedAttribute);
                presenzaRispostaSPCoopConnectionReply = validatorConnectionReply.validazioneSintattica();
                if (presenzaRispostaSPCoopConnectionReply) {
                    this.msgDiag.addKeywords(validatorConnectionReply.getBusta(), false);
                }
            }
            this.msgDiag.mediumDebug("Gestione errore consegna della risposta...");
            if (invokerNonSupportato) {
                ejbUtils.rollbackMessage("Connettore non supportato [tipo:" + tipoConnector + " class:" + connectorClass + "].");
                openspcoopstate.releaseResource();
                esito.setStatoInvocazione(3);
                esito.setEsitoInvocazione(false);
                return esito;
            }
            if (errorConsegna && !presenzaRispostaSPCoopConnectionReply) {
                if (faultConnectionReply != null) {
                    this.msgDiag.addKeyword("@SOAP_FAULT@", SoapUtils.toString((SOAPFault)faultConnectionReply));
                    this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("ricezioneSoapFault"), this.msgDiag.getLivello("ricezioneSoapFault"));
                }
                if (riconsegna) {
                    ejbUtils.rollbackMessage("Errore duranta la spedizione della busta: " + motivoErroreConsegna, dataRiconsegna);
                    esito.setEsitoInvocazione(false);
                } else {
                    if (inoltroSegnalazioneErrore) {
                        ejbUtils.releaseOutboxMessage(false);
                    } else {
                        ejbUtils.releaseInboxMessage(false);
                    }
                    esito.setEsitoInvocazione(true);
                }
                openspcoopstate.releaseResource();
                esito.setStatoInvocazione(3);
                return esito;
            }
            boolean isMessaggioSPCoopErroreConnectionReply = false;
            Busta bustaConnectionReply = null;
            if (presenzaRispostaSPCoopConnectionReply) {
                bustaConnectionReply = validatorConnectionReply.getBusta();
                isMessaggioSPCoopErroreConnectionReply = validatorConnectionReply.isSPCoopErrore();
                if (isMessaggioSPCoopErroreConnectionReply) {
                    this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("ricezioneMessaggioSPCoopErrore"), this.msgDiag.getLivello("ricezioneMessaggioSPCoopErrore"));
                } else {
                    this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("ricezioneMessaggioSPCoop"), this.msgDiag.getLivello("ricezioneMessaggioSPCoop"));
                }
                this.msgDiag.mediumDebug("Sbustamento eGov della risposta...");
                SOAPHeaderElement headerSPCoopRispostaConnectionReply = null;
                try {
                    boolean gestioneManifestRispostaHttp = false;
                    if (!functionAsRouter) {
                        gestioneManifestRispostaHttp = this.configurazionePdDReader.isGestioneManifestAttachments();
                    }
                    Sbustamento sbustatore = new Sbustamento();
                    headerSPCoopRispostaConnectionReply = sbustatore.sbustamentoEGov(responseHttpReply, gestioneManifestRispostaHttp, proprietaManifestAttachments);
                }
                catch (Exception e) {
                    tracciamento.registraRisposta(((OpenSPCoopState)openspcoopstate).getConnectionDB(), bustaConnectionReply, Tracciamento.createLocationString(true, locationInoltro), inoltroRisposteEGovMsg.getIdCorrelazioneApplicativa(), inoltroRisposteEGovMsg.getServizioApplicativoFruitore());
                    this.msgDiag.logErroreGenerico(e, "sbustatore.sbustamentoEGov(" + bustaConnectionReply.getID() + ")");
                    ejbUtils.rollbackMessage("Sbustamento busta nella connection Reply non riuscita.");
                    openspcoopstate.releaseResource();
                    esito.setStatoInvocazione(3);
                    esito.setEsitoInvocazione(false);
                    return esito;
                }
                this.msgDiag.mediumDebug("Tracciamento eGov della risposta...");
                tracciamento.registraRisposta(((OpenSPCoopState)openspcoopstate).getConnectionDB(), headerSPCoopRispostaConnectionReply, bustaConnectionReply, Tracciamento.createLocationString(true, locationInoltro), inoltroRisposteEGovMsg.getIdCorrelazioneApplicativa(), inoltroRisposteEGovMsg.getServizioApplicativoFruitore());
                if (functionAsRouter) {
                    this.msgDiag.mediumDebug("Registrazione messaggio nel Repository Messaggi/Buste...");
                    msgConnectionReply = new GestoreMessaggi(openspcoopstate, false, bustaConnectionReply.getID(), "OUTBOX", this.msgDiag);
                    msgConnectionReply.setOneWayVersione11(oneWayVersione11);
                    try {
                        if (msgConnectionReply.existsMessage_noCache()) {
                            String proprietarioMessaggio = msgConnectionReply.getProprietario(ID_MODULO);
                            if ("GestoreMessaggi".equals(proprietarioMessaggio)) {
                                this.msgDiag.infoOpenSPCoop("Altra copia della Busta eGov ricevuta come risposta nella http reply con id[" + bustaConnectionReply.getID() + "] gia' elaborata, forzo eliminazione prima di continuare il processamento");
                                msgConnectionReply.deleteMessage();
                            } else {
                                throw new Exception("Altra copia della Busta eGov ricevuta come risposta nella http reply con id[" + bustaConnectionReply.getID() + "] in elaborazione dal modulo " + proprietarioMessaggio);
                            }
                        }
                        msgConnectionReply.registraMessaggio(responseHttpReply);
                        msgConnectionReply.aggiornaProprietarioMessaggio(ID_MODULO);
                        msgConnectionReply.aggiornaRiferimentoMessaggio(busta.getID());
                        repositoryConnectionReply = new RepositoryEGov(openspcoopstate.getStatoRisposta(), false);
                        repositoryConnectionReply.registraBustaIntoOutBox(busta, this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi());
                        Integrazione infoIntegrazione = new Integrazione();
                        repositoryConnectionReply.aggiornaInfoIntegrazioneIntoOutBox(bustaConnectionReply.getID(), infoIntegrazione);
                    }
                    catch (Exception e) {
                        this.msgDiag.logErroreGenerico(e, "RegistrazioneRisposta(" + bustaConnectionReply.getID() + ")");
                        ejbUtils.rollbackMessage("Salvataggio messaggio nella connection Reply non riuscita.");
                        openspcoopstate.releaseResource();
                        esito.setStatoInvocazione(3);
                        esito.setEsitoInvocazione(false);
                        return esito;
                    }
                    this.msgDiag.mediumDebug("Ridirezione messaggio a InoltroRisposteEGov...");
                    try {
                        ejbUtils.sendToInoltroRisposteEGov(bustaConnectionReply, true, null, msgConnectionReply, null, null, true);
                    }
                    catch (Exception e) {
                        this.msgDiag.logErroreGenerico(e, "GenericLib.nodeSender.send(InoltroRisposteEGov ID:" + bustaConnectionReply.getID() + ")");
                        ejbUtils.rollbackMessage("Inoltro messaggio ricevuto nella connection Reply non riuscito.");
                        openspcoopstate.releaseResource();
                        esito.setStatoInvocazione(3);
                        esito.setEsitoInvocazione(false);
                        return esito;
                    }
                }
            } else if (responseHttpReply != null && faultConnectionReply != null) {
                this.msgDiag.addKeyword("@SOAP_FAULT@", SoapUtils.toString((SOAPFault)faultConnectionReply));
                this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("ricezioneSoapFault"), this.msgDiag.getLivello("ricezioneSoapFault"));
            }
            this.msgDiag.mediumDebug("Aggiorno proprietario messaggio ...");
            msgResponse.aggiornaProprietarioMessaggio("GestoreMessaggi");
            this.msgDiag.mediumDebug("Elimino utilizzo busta dalla PdD ...");
            repositoryEGov = new RepositoryEGov(openspcoopstate.getStatoRisposta(), false);
            if (oneWayVersione11) {
                repositoryEGov.eliminaBustaStatelessFromOutBox(busta.getID());
            } else {
                repositoryEGov.eliminaUtilizzoPdDFromOutBox(busta.getID());
            }
            this.msgDiag.mediumDebug("Commit delle operazioni per la gestione della busta...");
            openspcoopstate.commit();
            if (msgResponse != null) {
                msgResponse.addMessaggiIntoCache_readFromTable(ID_MODULO, "busta da inoltrare");
            }
            if (msgConnectionReply != null) {
                msgConnectionReply.addMessaggiIntoCache_readFromTable(ID_MODULO, "connection http reply");
            }
            if (msgResponse != null) {
                msgResponse.addProprietariIntoCache_readFromTable(ID_MODULO, "busta da inoltrare", idEGovRequest, functionAsRouter);
            }
            if (msgConnectionReply != null) {
                msgConnectionReply.addProprietariIntoCache_readFromTable(ID_MODULO, "connection http reply", idEGovResponse, functionAsRouter);
            }
            this.msgDiag.mediumDebug("Rilascio connessione al database...");
            openspcoopstate.releaseResource();
            boolean esitoNotifica = true;
            try {
                SOAPBody body = responseAxisMessage.getSOAPBody();
                if (body.hasFault()) {
                    esitoNotifica = false;
                }
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "TempiAttraversamentoPdD.getSoapBody");
                esitoNotifica = false;
            }
            if (dateGestioneMessaggi != null) {
                Date ricezioneMessaggioIngresso = null;
                Date spedizioneMessaggioIngresso = null;
                Date ricezioneMessaggioRisposta = null;
                if (dateGestioneMessaggi[0] != null && dateGestioneMessaggi[1] != null) {
                    ricezioneMessaggioIngresso = dateGestioneMessaggi[0];
                    spedizioneMessaggioIngresso = dateGestioneMessaggi[1];
                }
                if (dateGestioneMessaggi[2] != null) {
                    ricezioneMessaggioRisposta = dateGestioneMessaggi[2];
                }
                info.setTimeStamp1(ricezioneMessaggioIngresso);
                info.setTimeStamp2(spedizioneMessaggioIngresso);
                info.setTimeStamp3(ricezioneMessaggioRisposta);
                if (info.getTimeStamp4() == null) {
                    Date spedizioneMessaggioRisposta = DateManager.getDate();
                    info.setTimeStamp4(spedizioneMessaggioRisposta);
                }
            }
            info.setStato(esitoNotifica);
            NotificaTempiAttraversamentoPdDUtility.notifica(info, this.msgDiag);
            this.msgDiag.mediumDebug("Lavoro Terminato.");
            esito.setEsitoInvocazione(true);
            esito.setStatoInvocazione(1);
            return esito;
        }
        catch (Exception e) {
            this.log.error((Object)"ErroreGenerale", (Throwable)e);
            this.msgDiag.logErroreGenerico(e, "Generale");
            ejbUtils.rollbackMessage("ErroreGenerale:" + e.getMessage());
            esito.setStatoInvocazione(3);
            esito.setEsitoInvocazione(false);
            openspcoopstate.releaseResource();
            return esito;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getWSSProperties(Busta bustaRisposta, ConfigurazionePdDReader configurazionePdDReader, IState state, MsgDiagnostico msgDiag, Hashtable<String, String> wssPropertiesResponse) throws DriverConfigurazioneException {
        Hashtable<String, String> wssPropertiesResponseFound = null;
        ProfiloDiCollaborazione profiloCollaborazione = null;
        try {
            if (bustaRisposta.getProfiloDiCollaborazione() == null && bustaRisposta.sizeListaRiscontri() > 0) {
                if (bustaRisposta.getTipoServizioRichiedenteBustaDiServizio() != null && bustaRisposta.getServizioRichiedenteBustaDiServizio() != null) {
                    IDPortaApplicativa idPA = new IDPortaApplicativa();
                    idPA.setIDServizio(new IDServizio(bustaRisposta.getTipoMittente(), bustaRisposta.getMittente(), bustaRisposta.getTipoServizioRichiedenteBustaDiServizio(), bustaRisposta.getServizioRichiedenteBustaDiServizio(), bustaRisposta.getAzioneRichiedenteBustaDiServizio()));
                    wssPropertiesResponseFound = configurazionePdDReader.getPA_WSSForSender(configurazionePdDReader.getPortaApplicativa_SafeMethod(idPA, null));
                }
            } else if ("EGOV_IT_MessaggioSingoloOneWay".equals(bustaRisposta.getProfiloDiCollaborazione()) || "EGOV_IT_ServizioSincrono".equals(bustaRisposta.getProfiloDiCollaborazione())) {
                IDPortaApplicativa idPA = new IDPortaApplicativa();
                idPA.setIDServizio(new IDServizio(bustaRisposta.getTipoMittente(), bustaRisposta.getMittente(), bustaRisposta.getTipoServizio(), bustaRisposta.getServizio(), bustaRisposta.getAzione()));
                wssPropertiesResponseFound = configurazionePdDReader.getPA_WSSForSender(configurazionePdDReader.getPortaApplicativa_SafeMethod(idPA, null));
            } else if ("EGOV_IT_ServizioAsincronoSimmetrico".equals(bustaRisposta.getProfiloDiCollaborazione())) {
                profiloCollaborazione = new ProfiloDiCollaborazione(state);
                if (profiloCollaborazione.asincrono_isRicevutaRichiesta(bustaRisposta.getRiferimentoMessaggio())) {
                    IDPortaApplicativa idPA = new IDPortaApplicativa();
                    idPA.setIDServizio(new IDServizio(bustaRisposta.getTipoMittente(), bustaRisposta.getMittente(), bustaRisposta.getTipoServizio(), bustaRisposta.getServizio(), bustaRisposta.getAzione()));
                    wssPropertiesResponseFound = configurazionePdDReader.getPA_WSSForSender(configurazionePdDReader.getPortaApplicativa_SafeMethod(idPA, null));
                } else if (profiloCollaborazione.asincrono_isRicevutaRisposta(bustaRisposta.getRiferimentoMessaggio())) {
                    RepositoryEGov repository = new RepositoryEGov(state, false);
                    Integrazione integrazione = repository.getInfoIntegrazioneFromOutBox(bustaRisposta.getRiferimentoMsgBustaRichiedenteServizio());
                    IDPortaDelegata idPD = new IDPortaDelegata();
                    idPD.setLocationPD(integrazione.getLocationPD());
                    idPD.setSoggettoFruitore(new IDSoggetto(bustaRisposta.getTipoMittente(), bustaRisposta.getMittente()));
                    wssPropertiesResponseFound = configurazionePdDReader.getPD_WSSForSender(configurazionePdDReader.getPortaDelegata_SafeMethod(idPD));
                }
            } else if ("EGOV_IT_ServizioAsincronoAsimmetrico".equals(bustaRisposta.getProfiloDiCollaborazione())) {
                profiloCollaborazione = new ProfiloDiCollaborazione(state);
                if (profiloCollaborazione.asincrono_isRicevutaRichiesta(bustaRisposta.getRiferimentoMessaggio())) {
                    IDPortaApplicativa idPA = new IDPortaApplicativa();
                    idPA.setIDServizio(new IDServizio(bustaRisposta.getTipoMittente(), bustaRisposta.getMittente(), bustaRisposta.getTipoServizio(), bustaRisposta.getServizio(), bustaRisposta.getAzione()));
                    wssPropertiesResponseFound = configurazionePdDReader.getPA_WSSForSender(configurazionePdDReader.getPortaApplicativa_SafeMethod(idPA, null));
                } else if (profiloCollaborazione.asincrono_isRicevutaRisposta(bustaRisposta.getRiferimentoMessaggio())) {
                    IDPortaApplicativa idPA = new IDPortaApplicativa();
                    IDServizio idServizioOriginale = profiloCollaborazione.asincronoAsimmetrico_getDatiConsegnaRisposta(bustaRisposta.getRiferimentoMsgBustaRichiedenteServizio());
                    idPA.setIDServizio(new IDServizio(bustaRisposta.getTipoMittente(), bustaRisposta.getMittente(), idServizioOriginale.getTipoServizio(), idServizioOriginale.getServizio(), idServizioOriginale.getAzione()));
                    wssPropertiesResponseFound = configurazionePdDReader.getPA_WSSForSender(configurazionePdDReader.getPortaApplicativa_SafeMethod(idPA, null));
                }
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "LetturaDatiWSS");
            this.log.error((Object)"Lettura dati WS-Security per la spedizione del messaggio SPCoop di risposta non riuscita", (Throwable)e);
        }
        finally {
            if (profiloCollaborazione != null && state instanceof StatefulMessage) {
                ((StatefulMessage)state).closePreparedStatement();
            }
        }
        if (wssPropertiesResponseFound != null) {
            wssPropertiesResponse.putAll(wssPropertiesResponseFound);
        }
    }
}

