/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.mdb;

import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.apache.log4j.Logger;
import org.openspcoop.pdd.core.node.TransactionManager;
import org.openspcoop.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.mdb.EsitoLib;
import org.openspcoop.pdd.mdb.ImbustamentoRisposte;
import org.openspcoop.pdd.mdb.ImbustamentoRisposteMessage;
import org.openspcoop.pdd.services.OpenSPCoopStartup;
import org.openspcoop.pdd.timers.TimerMonitoraggioRisorse;

public class ImbustamentoRisposteMDB
implements MessageDrivenBean,
MessageListener {
    private static final long serialVersionUID = 1L;
    private Logger log = null;
    private MessageDrivenContext ctxMDB;

    public void setMessageDrivenContext(MessageDrivenContext mdc) throws EJBException {
        this.ctxMDB = mdc;
    }

    public void ejbCreate() {
    }

    public void ejbRemove() {
    }

    public void onMessage(Message message) {
        if (message instanceof ObjectMessage) {
            if (!OpenSPCoopStartup.initialize) {
                this.ctxMDB.setRollbackOnly();
                return;
            }
            this.log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
            if (this.log == null) {
                System.out.println("[ImbustamentoRisposte] Logger nullo. MDB abortito");
                return;
            }
            if (!TimerMonitoraggioRisorse.risorseDisponibili) {
                this.log.error((Object)("[ImbustamentoRisposte] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            ImbustamentoRisposte lib = new ImbustamentoRisposte(this.log);
            if (!lib.inizializzazioneUltimata) {
                this.log = Logger.getLogger((String)"OpenSPCoop.ImbustamentoRisposte");
                this.log.error((Object)"[ImbustamentoRisposte] Inizializzazione MDB non riuscita");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            MsgDiagnostico msgDiag = new MsgDiagnostico("ImbustamentoRisposte");
            msgDiag.mediumDebug("Ricezione richiesta (ImbustamentoRisposteMessage)...");
            ObjectMessage received = (ObjectMessage)message;
            ImbustamentoRisposteMessage imbustamentoRisposteMsg = null;
            try {
                imbustamentoRisposteMsg = (ImbustamentoRisposteMessage)received.getObject();
            }
            catch (JMSException e) {
                msgDiag.logErroreGenerico((Exception)((Object)e), "received.getObject(ImbustamentoRisposteMessage)");
                return;
            }
            String idEGovRequest = null;
            try {
                idEGovRequest = received.getStringProperty("ID");
            }
            catch (JMSException e) {
                msgDiag.logErroreGenerico((Exception)((Object)e), "received.getStringProperty(ID)");
                return;
            }
            String idEGovResponse = imbustamentoRisposteMsg.getIDEGovResponse();
            msgDiag.lowDebug("Transaction Manager...");
            try {
                if (!TransactionManager.validityCheck(msgDiag, "ImbustamentoRisposte", idEGovResponse, "OUTBOX", received.getJMSMessageID())) {
                    msgDiag.lowDebug("Messaggio con id[" + idEGovResponse + "] non ha superato il validity check");
                    return;
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "TransactionManager.validityCheck");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            EsitoLib esito = null;
            try {
                OpenSPCoopStateful stato = new OpenSPCoopStateful();
                stato.setIDEgovSessione(idEGovRequest);
                stato.setMessageLib(imbustamentoRisposteMsg);
                esito = lib.onMessage(stato);
            }
            catch (Exception e) {
                this.log.error((Object)"[ImbustamentoRisposte] Impossibile chiamare la libreria", (Throwable)e);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!esito.isEsitoInvocazione()) {
                this.log.error((Object)"[ImbustamentoRisposte] Chiamata alla libreria fallita");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            this.log.debug((Object)"[ImbustamentoRisposte] Chiamata alla libreria riuscita");
        }
    }
}

