/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.mdb;

import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.dao.state.IState;
import org.openspcoop.egov.Busta;
import org.openspcoop.egov.ProfiloDiCollaborazione;
import org.openspcoop.egov.RepositoryEGov;
import org.openspcoop.pdd.config.RichiestaApplicativa;
import org.openspcoop.pdd.config.RichiestaDelegata;
import org.openspcoop.pdd.core.EJBUtils;
import org.openspcoop.pdd.core.GestoreMessaggi;
import org.openspcoop.pdd.core.state.IOpenSPCoopState;
import org.openspcoop.pdd.core.state.OpenSPCoopStateException;
import org.openspcoop.pdd.mdb.EsitoLib;
import org.openspcoop.pdd.mdb.GenericLib;
import org.openspcoop.pdd.mdb.ImbustamentoRisposteMessage;

public class ImbustamentoRisposte
extends GenericLib {
    public static final String ID_MODULO = "ImbustamentoRisposte";

    public ImbustamentoRisposte(Logger log) {
        super(ID_MODULO, log);
        this.inizializza();
    }

    public EsitoLib onMessage(IOpenSPCoopState openspcoopstate) throws OpenSPCoopStateException {
        EsitoLib esito = new EsitoLib();
        ImbustamentoRisposteMessage imbustamentoRisposteMsg = (ImbustamentoRisposteMessage)openspcoopstate.getMessageLib();
        String idEGovRequest = openspcoopstate.getIDEgovSessione();
        String implementazionePdDMittente = imbustamentoRisposteMsg.getImplementazionePdDSoggettoMittente();
        Busta bustaRichiesta = imbustamentoRisposteMsg.getBusta();
        RichiestaApplicativa richiestaApplicativa = imbustamentoRisposteMsg.getRichiestaApplicativa();
        RichiestaDelegata richiestaDelegata = imbustamentoRisposteMsg.getRichiestaDelegata();
        String idEGovResponse = imbustamentoRisposteMsg.getIDEGovResponse();
        String idModuloInAttesa = null;
        IDSoggetto identitaPdD = null;
        String scenarioCooperazione = null;
        IDSoggetto soggettoFruitore = null;
        IDServizio idServizio = null;
        String servizioApplicativo = null;
        IDServizio servizioHeaderIntegrazione = null;
        if (bustaRichiesta != null) {
            servizioHeaderIntegrazione = new IDServizio();
            servizioHeaderIntegrazione.setTipoServizio(bustaRichiesta.getTipoServizio());
            servizioHeaderIntegrazione.setServizio(bustaRichiesta.getServizio());
            servizioHeaderIntegrazione.setAzione(bustaRichiesta.getAzione());
        }
        String profiloGestione = null;
        String servizioApplicativoFruitore = null;
        String idCorrelazioneApplicativa = null;
        if (richiestaApplicativa != null) {
            identitaPdD = richiestaApplicativa.getDominio();
            idModuloInAttesa = richiestaApplicativa.getIdModuloInAttesa();
            scenarioCooperazione = richiestaApplicativa.getScenario();
            soggettoFruitore = richiestaApplicativa.getSoggettoFruitore();
            idServizio = richiestaApplicativa.getIDServizio();
            servizioApplicativo = richiestaApplicativa.getServizioApplicativo();
            if (servizioHeaderIntegrazione != null) {
                servizioHeaderIntegrazione.setSoggettoErogatore(idServizio.getSoggettoErogatore());
            }
            profiloGestione = richiestaApplicativa.getProfiloGestione();
            servizioApplicativoFruitore = richiestaApplicativa.getIdentitaServizioApplicativoFruitore();
            idCorrelazioneApplicativa = richiestaApplicativa.getIdCorrelazioneApplicativa();
        } else {
            identitaPdD = richiestaDelegata.getDominio();
            idModuloInAttesa = richiestaDelegata.getIdModuloInAttesa();
            scenarioCooperazione = richiestaDelegata.getScenario();
            soggettoFruitore = richiestaDelegata.getSoggettoFruitore();
            idServizio = richiestaDelegata.getIdServizio();
            servizioApplicativo = richiestaDelegata.getServizioApplicativo();
            if (servizioHeaderIntegrazione != null) {
                servizioHeaderIntegrazione.setSoggettoErogatore(idServizio.getSoggettoErogatore());
            }
            profiloGestione = richiestaDelegata.getProfiloGestione();
            servizioApplicativoFruitore = richiestaDelegata.getServizioApplicativo();
            idCorrelazioneApplicativa = richiestaDelegata.getIdCorrelazioneApplicativa();
        }
        this.msgDiag.mediumDebug("Profilo di gestione [ImbustamentoRisposte] della busta: " + profiloGestione);
        this.msgDiag.setDominioSPCoop(identitaPdD.getCodicePorta());
        this.msgDiag.setIdEGovRichiesta(idEGovRequest);
        this.msgDiag.setIdEGovRisposta(idEGovResponse);
        this.msgDiag.setDelegata(false);
        this.msgDiag.setFruitore(soggettoFruitore);
        if (servizioHeaderIntegrazione != null) {
            this.msgDiag.setServizio(servizioHeaderIntegrazione);
        } else {
            this.msgDiag.setServizio(idServizio);
        }
        this.msgDiag.setServizioApplicativo(servizioApplicativo);
        this.msgDiag.setPrefixMsgPersonalizzati("imbustamentoRispostaBustaEGov.");
        this.msgDiag.addKeywords(bustaRichiesta, true);
        this.msgDiag.addKeyword("@ID_EGOV_RISPOSTA@", idEGovResponse);
        this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_EROGATORE@", servizioApplicativo);
        if (servizioApplicativoFruitore != null) {
            this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE@", servizioApplicativoFruitore);
        }
        this.msgDiag.addKeyword("@ID_CORRELAZIONE_APPLICATIVA@", idCorrelazioneApplicativa);
        this.msgDiag.mediumDebug("Inizializzo stato per la gestione della richiesta...");
        openspcoopstate.initResource(identitaPdD, ID_MODULO);
        this.msgDiag.mediumDebug("Inizializzo contesto per la gestione...");
        EJBUtils ejbUtils = null;
        try {
            ejbUtils = new EJBUtils(identitaPdD, ID_MODULO, idEGovRequest, idEGovResponse, "OUTBOX", openspcoopstate, this.msgDiag, false, imbustamentoRisposteMsg.getImplementazionePdDSoggettoMittente(), imbustamentoRisposteMsg.getImplementazionePdDSoggettoDestinatario());
            ejbUtils.setSpedizioneMsgIngresso(imbustamentoRisposteMsg.getSpedizioneMsgIngresso());
            ejbUtils.setRicezioneMsgRisposta(imbustamentoRisposteMsg.getRicezioneMsgRisposta());
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "EJBUtils.new");
            openspcoopstate.releaseResource();
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazione(3);
            return esito;
        }
        boolean oneWayVersione11 = imbustamentoRisposteMsg.isOneWayVersione11();
        ejbUtils.setOneWayVersione11(oneWayVersione11);
        IState statoRichiesta = openspcoopstate.getStatoRichiesta();
        ProfiloDiCollaborazione profiloCollaborazione = new ProfiloDiCollaborazione(statoRichiesta);
        RepositoryEGov repositoryEGov = new RepositoryEGov(statoRichiesta, true);
        GestoreMessaggi msgResponse = null;
        boolean newConnectionForResponse = false;
        if (!"EGOV_IT_ServizioSincrono".equals(bustaRichiesta.getProfiloDiCollaborazione()) && !imbustamentoRisposteMsg.isStateless()) {
            newConnectionForResponse = this.configurazionePdDReader.newConnectionForResponseSPCoop();
        }
        ejbUtils.setReplyOnNewConnection(newConnectionForResponse);
        boolean gestioneIndirizzoTelematico = false;
        if (!imbustamentoRisposteMsg.isStateless()) {
            gestioneIndirizzoTelematico = this.configurazionePdDReader.isUtilizzoIndirizzoTelematico();
        }
        ejbUtils.setUtilizzoIndirizzoTelematico(gestioneIndirizzoTelematico);
        try {
            Busta bustaRisposta = null;
            String tipoTempo = this.propertiesReader.getTipoTempoEGov(implementazionePdDMittente);
            boolean asincronoStateless = false;
            if ("Sincrono_InvocazioneServizio".equals(scenarioCooperazione)) {
                try {
                    this.msgDiag.mediumDebug("Generazione busta per il profilo di Collaborazione Sincrono...");
                    bustaRisposta = profiloCollaborazione.sincrono_generaBustaRisposta(idEGovRequest, tipoTempo);
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "profiloCollaborazione.sincrono_generaBustaRisposta");
                    ejbUtils.sendRispostaSPCoopErroreProcessamento(idModuloInAttesa, bustaRichiesta, "OPENSPCOOP_ORG_525", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2);
                    return esito;
                }
            }
            if ("AsincronoSimmetrico_InvocazioneServizio".equals(scenarioCooperazione)) {
                try {
                    this.msgDiag.mediumDebug("Generazione busta per il profilo di Collaborazione Asincrono Simmetrico (richiesta)...");
                    bustaRisposta = profiloCollaborazione.asincronoSimmetrico_getBustaRicevuta(idEGovRequest, idEGovRequest, true, tipoTempo);
                    asincronoStateless = imbustamentoRisposteMsg.isStateless();
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "profiloCollaborazione.asincronoSimmetrico_getBustaRicevuta(Richiesta)");
                    ejbUtils.sendRispostaSPCoopErroreProcessamento(idModuloInAttesa, bustaRichiesta, "OPENSPCOOP_ORG_525", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                    openspcoopstate.releaseResource();
                    esito.setStatoInvocazione(2);
                    esito.setEsitoInvocazione(true);
                    return esito;
                }
            }
            if ("AsincronoSimmetrico_ConsegnaRisposta".equals(scenarioCooperazione)) {
                try {
                    this.msgDiag.mediumDebug("Generazione busta per il profilo di Collaborazione Asincrono Simmetrico (risposta)...");
                    bustaRisposta = "eGov1.1-lineeGuida1.1".equals(profiloGestione) ? profiloCollaborazione.asincronoSimmetrico_getBustaRicevuta(bustaRichiesta.getCollaborazione(), idEGovRequest, false, tipoTempo) : profiloCollaborazione.asincronoSimmetrico_getBustaRicevuta(bustaRichiesta.getRiferimentoMessaggio(), idEGovRequest, false, tipoTempo);
                    if (bustaRisposta != null) {
                        bustaRisposta.setRiferimentoMsgBustaRichiedenteServizio(bustaRichiesta.getRiferimentoMessaggio());
                        bustaRisposta.setAzione(bustaRichiesta.getAzione());
                    }
                    asincronoStateless = imbustamentoRisposteMsg.isStateless();
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "profiloCollaborazione.asincronoSimmetrico_getBustaRicevuta(Risposta)");
                    ejbUtils.sendRispostaSPCoopErroreProcessamento(idModuloInAttesa, bustaRichiesta, "OPENSPCOOP_ORG_525", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                    openspcoopstate.releaseResource();
                    esito.setStatoInvocazione(2);
                    esito.setEsitoInvocazione(true);
                    return esito;
                }
            }
            if ("AsincronoAsimmetrico_InvocazioneServizio".equals(scenarioCooperazione)) {
                try {
                    boolean generazionAttributiAsincroni = !"eGov1.1-lineeGuida1.1".equals(profiloGestione) && this.propertiesReader.isGenerazioneAttributiAsincroni(implementazionePdDMittente);
                    this.msgDiag.mediumDebug("Generazione busta per il profilo di Collaborazione Asincrono Asimmetrico (richiesta)...");
                    bustaRisposta = profiloCollaborazione.asincronoAsimmetrico_getBustaRicevuta(idEGovRequest, idEGovRequest, true, generazionAttributiAsincroni, tipoTempo);
                    asincronoStateless = imbustamentoRisposteMsg.isStateless();
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "profiloCollaborazione.asincronoAsimmetrico_getBustaRicevuta(Richiesta)");
                    ejbUtils.sendRispostaSPCoopErroreProcessamento(idModuloInAttesa, bustaRichiesta, "OPENSPCOOP_ORG_525", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                    openspcoopstate.releaseResource();
                    esito.setStatoInvocazione(2);
                    esito.setEsitoInvocazione(true);
                    return esito;
                }
            }
            if ("AsincronoAsimmetrico_Polling".equals(scenarioCooperazione)) {
                try {
                    this.msgDiag.mediumDebug("Generazione busta per il profilo di Collaborazione Asincrono Asimmetrico (richiestaStato)...");
                    boolean generazionAttributiAsincroni = !"eGov1.1-lineeGuida1.1".equals(profiloGestione) && this.propertiesReader.isGenerazioneAttributiAsincroni(implementazionePdDMittente);
                    bustaRisposta = "eGov1.1-lineeGuida1.1".equals(profiloGestione) ? profiloCollaborazione.asincronoAsimmetrico_getBustaRicevuta(bustaRichiesta.getCollaborazione(), idEGovRequest, false, generazionAttributiAsincroni, tipoTempo) : profiloCollaborazione.asincronoAsimmetrico_getBustaRicevuta(bustaRichiesta.getRiferimentoMessaggio(), idEGovRequest, false, generazionAttributiAsincroni, tipoTempo);
                    if (bustaRisposta != null) {
                        bustaRisposta.setRiferimentoMsgBustaRichiedenteServizio(bustaRichiesta.getRiferimentoMessaggio());
                        bustaRisposta.setAzione(bustaRichiesta.getAzione());
                    }
                    asincronoStateless = imbustamentoRisposteMsg.isStateless();
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "profiloCollaborazione.asincronoAsimmetrico_getBustaRicevuta(Risposta)");
                    ejbUtils.sendRispostaSPCoopErroreProcessamento(idModuloInAttesa, bustaRichiesta, "OPENSPCOOP_ORG_525", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                    openspcoopstate.releaseResource();
                    esito.setStatoInvocazione(2);
                    esito.setEsitoInvocazione(true);
                    return esito;
                }
            }
            if ("eGov1.1-lineeGuida1.1".equals(profiloGestione)) {
                bustaRisposta.setConfermaRicezione(false);
                bustaRisposta.setInoltro("EGOV_IT_ALPIUUNAVOLTA");
            }
            this.msgDiag.mediumDebug("Check busta...");
            if (bustaRisposta == null) {
                throw new Exception("Busta di risposta [" + scenarioCooperazione + "] non generata.");
            }
            bustaRisposta.setID(idEGovResponse);
            this.msgDiag.addKeywords(bustaRisposta, false);
            this.msgDiag.mediumDebug("Spedizione busta di risposta al modulo in uscita (RicezioneBusteEGov/InoltroRisposteEGov)...");
            msgResponse = ejbUtils.sendRispostaSPCoop(idModuloInAttesa, bustaRisposta, profiloGestione, idCorrelazioneApplicativa, servizioApplicativoFruitore);
            this.msgDiag.mediumDebug("Elimino utilizzo busta dalla PdD...");
            repositoryEGov.eliminaUtilizzoPdDFromInBox(idEGovRequest, asincronoStateless);
            openspcoopstate.commit();
            if (msgResponse != null) {
                msgResponse.addMessaggiIntoCache_readFromTable(ID_MODULO, "risposta");
            }
            if (msgResponse != null) {
                msgResponse.addProprietariIntoCache_readFromTable(ID_MODULO, "risposta", idEGovRequest, false);
            }
            this.msgDiag.mediumDebug("Rilascio connessione al database...");
            openspcoopstate.releaseResource();
            this.msgDiag.mediumDebug("Lavoro Terminato.");
            esito.setStatoInvocazione(1);
            esito.setEsitoInvocazione(true);
            return esito;
        }
        catch (Exception e) {
            this.log.error((Object)"ErroreGenerale", (Throwable)e);
            this.msgDiag.logErroreGenerico(e, "Generale");
            try {
                ejbUtils.sendRispostaSPCoopErroreProcessamento(idModuloInAttesa, bustaRichiesta, "OPENSPCOOP_ORG_500", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                esito.setStatoInvocazione(2);
                esito.setEsitoInvocazione(true);
            }
            catch (Exception er) {
                this.msgDiag.logErroreGenerico(er, "ejbUtils.sendErroreGenerale(profiloConRisposta)");
                ejbUtils.rollbackMessage("Spedizione Errore al Mittente durante una richiesta con gestione della risposta non riuscita");
                esito.setStatoInvocazione(3);
                esito.setEsitoInvocazione(false);
            }
            openspcoopstate.releaseResource();
            return esito;
        }
    }
}

