/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.mdb;

import java.util.Date;
import org.apache.axis.Message;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.config.PortaDelegata;
import org.openspcoop.dao.config.ServizioApplicativo;
import org.openspcoop.dao.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.dao.state.StatelessMessage;
import org.openspcoop.egov.Busta;
import org.openspcoop.egov.ConsegnaInOrdine;
import org.openspcoop.egov.EGovException;
import org.openspcoop.egov.Integrazione;
import org.openspcoop.egov.ProfiloDiCollaborazione;
import org.openspcoop.egov.ProprietaErroreApplicativo;
import org.openspcoop.egov.RepositoryEGov;
import org.openspcoop.egov.Riscontri;
import org.openspcoop.egov.ServizioEGov;
import org.openspcoop.egov.XMLBuilder;
import org.openspcoop.pdd.config.RichiestaDelegata;
import org.openspcoop.pdd.core.EJBUtils;
import org.openspcoop.pdd.core.GestoreMessaggi;
import org.openspcoop.pdd.core.state.IOpenSPCoopState;
import org.openspcoop.pdd.core.state.OpenSPCoopState;
import org.openspcoop.pdd.core.state.OpenSPCoopStateException;
import org.openspcoop.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop.pdd.mdb.EsitoLib;
import org.openspcoop.pdd.mdb.GenericLib;
import org.openspcoop.pdd.mdb.ImbustamentoMessage;
import org.openspcoop.pdd.mdb.InoltroBusteEGovMessage;
import org.openspcoop.utils.SoapUtils;
import org.openspcoop.utils.date.DateManager;

public class Imbustamento
extends GenericLib {
    public static final String ID_MODULO = "Imbustamento";
    private XMLBuilder xmlBuilder;

    public Imbustamento(Logger log) {
        super(ID_MODULO, log);
        this.inizializza();
    }

    protected synchronized void inizializza() {
        this.xmlBuilder = new XMLBuilder();
        super.inizializza();
    }

    public EsitoLib onMessage(IOpenSPCoopState openspcoopstate) throws OpenSPCoopStateException {
        EsitoLib esito = new EsitoLib();
        ImbustamentoMessage imbustamentoMsg = (ImbustamentoMessage)openspcoopstate.getMessageLib();
        String idEGovRequest = openspcoopstate.getIDEgovSessione();
        String implementazionePdDDestinatario = imbustamentoMsg.getImplementazionePdDSoggettoDestinatario();
        RichiestaDelegata richiestaDelegata = imbustamentoMsg.getRichiestaDelegata();
        IDSoggetto identitaPdD = imbustamentoMsg.getRichiestaDelegata().getDominio();
        this.msgDiag.setDominioSPCoop(identitaPdD.getCodicePorta());
        this.msgDiag.setPrefixMsgPersonalizzati("imbustamentoBustaEGov.");
        this.msgDiag.setIdEGovRichiesta(idEGovRequest);
        this.msgDiag.addKeyword("@ID_EGOV_RICHIESTA@", idEGovRequest);
        this.msgDiag.setDelegata(true);
        this.msgDiag.setPorta(richiestaDelegata.getLocationPD());
        this.msgDiag.setFruitore(richiestaDelegata.getSoggettoFruitore());
        this.msgDiag.addKeywords(richiestaDelegata.getSoggettoFruitore());
        this.msgDiag.setServizio(richiestaDelegata.getIdServizio());
        this.msgDiag.addKeywords(richiestaDelegata.getIdServizio());
        this.msgDiag.setServizioApplicativo(richiestaDelegata.getServizioApplicativo());
        this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE@", richiestaDelegata.getServizioApplicativo());
        this.msgDiag.addKeyword("@PROFILO_COLLABORAZIONE@", richiestaDelegata.getProfiloCollaborazione());
        this.msgDiag.addKeyword("@ID_CORRELAZIONE_APPLICATIVA@", richiestaDelegata.getIdCorrelazioneApplicativa());
        this.msgDiag.addKeyword("@FUNZIONALITA_COLLABORAZIONE@", imbustamentoMsg.getInfoServizio().getCollaborazione() + "");
        this.msgDiag.addKeyword("@FUNZIONALITA_CONFERMA_RICEZIONE@", imbustamentoMsg.getInfoServizio().getConfermaRicezione() + "");
        this.msgDiag.addKeyword("@FUNZIONALITA_FILTRO_DUPLICATI@", "EGOV_IT_ALPIUUNAVOLTA".equals(imbustamentoMsg.getInfoServizio().getInoltro()) + "");
        this.msgDiag.mediumDebug("Inizializzo stato per la gestione della richiesta...");
        openspcoopstate.initResource(identitaPdD, ID_MODULO);
        this.msgDiag.mediumDebug("Inizializzo contesto per la gestione...");
        EJBUtils ejbUtils = null;
        try {
            ejbUtils = new EJBUtils(identitaPdD, ID_MODULO, idEGovRequest, idEGovRequest, "OUTBOX", openspcoopstate, this.msgDiag, false, imbustamentoMsg.getImplementazionePdDSoggettoMittente(), imbustamentoMsg.getImplementazionePdDSoggettoDestinatario());
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "EJBUtils.new");
            openspcoopstate.releaseResource();
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazione(3);
            return esito;
        }
        boolean oneWayVersione11 = imbustamentoMsg.isOneWayVersione11();
        ejbUtils.setOneWayVersione11(oneWayVersione11);
        RepositoryEGov repositoryEGov = new RepositoryEGov(openspcoopstate.getStatoRichiesta(), true);
        Riscontri gestoreRiscontri = new Riscontri(openspcoopstate.getStatoRichiesta());
        ProfiloDiCollaborazione profiloDiCollaborazione = new ProfiloDiCollaborazione(openspcoopstate.getStatoRichiesta());
        ConsegnaInOrdine ordineConsegna = new ConsegnaInOrdine(openspcoopstate.getStatoRichiesta());
        GestoreMessaggi msgRequest = null;
        GestoreMessaggi msgOK = null;
        ServizioEGov infoServizio = imbustamentoMsg.getInfoServizio();
        String riferimentoServizioCorrelato = imbustamentoMsg.getRiferimentoServizioCorrelato();
        boolean isServizioCorrelato = infoServizio.isCorrelato();
        IDServizio idServizio = richiestaDelegata.getIdServizio();
        IDSoggetto soggettoFruitore = richiestaDelegata.getSoggettoFruitore();
        String profiloGestione = richiestaDelegata.getProfiloGestione();
        ProprietaErroreApplicativo proprietaErroreAppl = richiestaDelegata.getFault();
        proprietaErroreAppl.setIdModulo(ID_MODULO);
        PortaDelegata pd = null;
        ServizioApplicativo sa = null;
        try {
            long scadenzaBusta;
            Busta busta;
            block112: {
                this.msgDiag.mediumDebug("Check utilizzo consegna risposta asincrona...");
                if (!infoServizio.getProfiloDiCollaborazione().equals("EGOV_IT_ServizioAsincronoSimmetrico") || riferimentoServizioCorrelato != null || isServizioCorrelato) {
                    richiestaDelegata.setUtilizzoConsegnaAsincrona(true);
                }
                this.msgDiag.mediumDebug("Costruzione busta eGov...");
                busta = new Busta();
                busta.setTipoDestinatario(idServizio.getSoggettoErogatore().getTipo());
                busta.setDestinatario(idServizio.getSoggettoErogatore().getNome());
                busta.setServizio(idServizio.getServizio());
                busta.setTipoServizio(idServizio.getTipoServizio());
                busta.setAzione(idServizio.getAzione());
                busta.setTipoMittente(soggettoFruitore.getTipo());
                busta.setMittente(soggettoFruitore.getNome());
                this.msgDiag.highDebug("Costruzione Busta eGov con ID = " + idEGovRequest);
                busta.setID(idEGovRequest);
                Date oraRegistrazione = DateManager.getDate();
                this.msgDiag.highDebug("Costruzione Busta eGov in data : [" + oraRegistrazione + "]");
                busta.setOraRegistrazione(oraRegistrazione);
                busta.setTipoOraRegistrazione(this.propertiesReader.getTipoTempoEGov(implementazionePdDDestinatario));
                busta.setScadenza(infoServizio.getScadenza());
                scadenzaBusta = this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi();
                if (!"eGov1.1-lineeGuida1.1".equals(profiloGestione)) {
                    busta.setInoltro(infoServizio.getInoltro());
                } else {
                    busta.setInoltro("EGOV_IT_ALPIUUNAVOLTA");
                }
                if (!"eGov1.1-lineeGuida1.1".equals(profiloGestione) && this.propertiesReader.isGestioneRiscontri(implementazionePdDDestinatario) && infoServizio.getConfermaRicezione()) {
                    busta.setConfermaRicezione(true);
                } else {
                    busta.setConfermaRicezione(false);
                }
                pd = this.configurazionePdDReader.getPortaDelegata(richiestaDelegata.getIdPortaDelegata());
                try {
                    sa = this.configurazionePdDReader.getServizioApplicativo(richiestaDelegata.getIdPortaDelegata(), richiestaDelegata.getServizioApplicativo());
                }
                catch (DriverConfigurazioneNotFound e) {
                    if ("Anonimo".equals(richiestaDelegata.getServizioApplicativo())) break block112;
                    throw e;
                }
            }
            if (!"eGov1.1-lineeGuida1.1".equals(profiloGestione) && this.propertiesReader.isGestioneConsegnaInOrdine(implementazionePdDDestinatario) && infoServizio.getOrdineConsegna()) {
                this.msgDiag.mediumDebug("Check vincoli consegna in ordine...");
                if (!infoServizio.getProfiloDiCollaborazione().equals("EGOV_IT_MessaggioSingoloOneWay")) {
                    this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("consegnaInOrdine.profiloNonOneway"), this.msgDiag.getLivello("consegnaInOrdine.profiloNonOneway"));
                    Message responseAxisMessageError = this.xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_414", "Richiesta funzionalita' di consegna in ordine con un profilo diverso da OneWay");
                    ejbUtils.sendRispostaApplicativaErrore(responseAxisMessageError, richiestaDelegata, pd, sa);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2);
                    return esito;
                }
                if (!this.propertiesReader.isGestioneRiscontri(implementazionePdDDestinatario)) {
                    this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("consegnaInOrdine.confermaRicezioneNonRichiesta"), this.msgDiag.getLivello("consegnaInOrdine.confermaRicezioneNonRichiesta"));
                    Message responseAxisMessageError = this.xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_415", "Richiesta funzionalita' di consegna in ordine che non rispetta i vincoli SPCoop. E' possibile che la richiesta non sia accompagnata dalla funzionalita' di gestione dei riscontri, un filtro duplicati o un id di collaborazione.");
                    ejbUtils.sendRispostaApplicativaErrore(responseAxisMessageError, richiestaDelegata, pd, sa);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2);
                    return esito;
                }
                if ("eGov1.1-lineeGuida1.1".equals(profiloGestione) || !this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDDestinatario)) {
                    this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("consegnaInOrdine.idCollaborazioneNonRichiesto"), this.msgDiag.getLivello("consegnaInOrdine.idCollaborazioneNonRichiesto"));
                    Message responseAxisMessageError = this.xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_415", "Richiesta funzionalita' di consegna in ordine che non rispetta i vincoli SPCoop. E' possibile che la richiesta non sia accompagnata dalla funzionalita' di gestione dei riscontri, un filtro duplicati o un id di collaborazione.");
                    ejbUtils.sendRispostaApplicativaErrore(responseAxisMessageError, richiestaDelegata, pd, sa);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2);
                    return esito;
                }
                if (!(infoServizio.getCollaborazione() && infoServizio.getConfermaRicezione() && "EGOV_IT_ALPIUUNAVOLTA".equals(infoServizio.getInoltro()))) {
                    this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("consegnaInOrdine.funzionalitaSPCoopMancanti"), this.msgDiag.getLivello("consegnaInOrdine.funzionalitaSPCoopMancanti"));
                    Message responseAxisMessageError = this.xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_415", "Richiesta funzionalita' di consegna in ordine che non rispetta i vincoli SPCoop. E' possibile che la richiesta non sia accompagnata dalla funzionalita' di gestione dei riscontri, un filtro duplicati o un id di collaborazione.");
                    ejbUtils.sendRispostaApplicativaErrore(responseAxisMessageError, richiestaDelegata, pd, sa);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2);
                    return esito;
                }
            }
            boolean gestioneConsegnaInOrdineAbilitata = !"eGov1.1-lineeGuida1.1".equals(profiloGestione) && this.propertiesReader.isGestioneRiscontri(implementazionePdDDestinatario) && this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDDestinatario) && this.propertiesReader.isGestioneConsegnaInOrdine(implementazionePdDDestinatario);
            boolean generazioneMsgOK = false;
            String scenarioCooperazione = null;
            if (infoServizio.getProfiloDiCollaborazione().equals("EGOV_IT_MessaggioSingoloOneWay")) {
                this.msgDiag.mediumDebug("Gestione profilo di Collaborazione OneWay ...");
                busta.setProfiloDiCollaborazione("EGOV_IT_MessaggioSingoloOneWay");
                scenarioCooperazione = "OneWay_InvocazioneServizio";
                if (!"eGov1.1-lineeGuida1.1".equals(profiloGestione) && this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDDestinatario) && infoServizio.getCollaborazione()) {
                    if (imbustamentoMsg.getIdCollaborazione() != null) {
                        busta.setCollaborazione(imbustamentoMsg.getIdCollaborazione());
                    } else {
                        busta.setCollaborazione(idEGovRequest);
                    }
                }
                if (gestioneConsegnaInOrdineAbilitata && infoServizio.getOrdineConsegna() && (oneWayVersione11 || openspcoopstate instanceof OpenSPCoopStateful)) {
                    this.msgDiag.mediumDebug("Gestione profilo di Collaborazione OneWay (consegna in ordine)...");
                    try {
                        ordineConsegna.setNextSequenza_daInviare(busta);
                    }
                    catch (Exception e) {
                        this.msgDiag.logErroreGenerico(e, "ordineConsegna.setNextSequenza_daInviare");
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2);
                        return esito;
                    }
                }
                generazioneMsgOK = !this.configurazionePdDReader.isModalitaStatelessByProfiloServizio(pd, infoServizio.getProfiloDiCollaborazione());
            } else if (infoServizio.getProfiloDiCollaborazione().equals("EGOV_IT_ServizioSincrono")) {
                this.msgDiag.mediumDebug("Gestione profilo di Collaborazione Sincrono ...");
                busta.setProfiloDiCollaborazione("EGOV_IT_ServizioSincrono");
                scenarioCooperazione = "Sincrono_InvocazioneServizio";
                try {
                    this.msgDiag.mediumDebug("Gestione profilo di Collaborazione Sincrono (Registrazione Busta da inviare)...");
                    profiloDiCollaborazione.registraBustaInviata(idEGovRequest);
                }
                catch (EGovException e) {
                    this.msgDiag.logErroreGenerico((Exception)((Object)e), "profiloDiCollaborazione.registraBustaInviata");
                    Message responseAxisMessageError = this.xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_525", "Sistema non disponibile");
                    ejbUtils.sendRispostaApplicativaErrore(responseAxisMessageError, richiestaDelegata, pd, sa);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2);
                    return esito;
                }
                if (!"eGov1.1-lineeGuida1.1".equals(profiloGestione) && this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDDestinatario) && infoServizio.getCollaborazione()) {
                    if (imbustamentoMsg.getIdCollaborazione() != null) {
                        busta.setCollaborazione(imbustamentoMsg.getIdCollaborazione());
                    } else {
                        busta.setCollaborazione(idEGovRequest);
                    }
                }
            } else if (infoServizio.getProfiloDiCollaborazione().equals("EGOV_IT_ServizioAsincronoSimmetrico")) {
                this.msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoSimmetrico ...");
                busta.setProfiloDiCollaborazione("EGOV_IT_ServizioAsincronoSimmetrico");
                this.msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoSimmetrico (check ricevuta abilitata)...");
                richiestaDelegata.setRicevutaAsincrona(this.configurazionePdDReader.ricevutaAsincronaSimmetricaAbilitata(pd));
                generazioneMsgOK = !this.configurazionePdDReader.isModalitaStatelessByProfiloServizio(pd, infoServizio.getProfiloDiCollaborazione()) ? !richiestaDelegata.isRicevutaAsincrona() : false;
                if (riferimentoServizioCorrelato == null && !isServizioCorrelato) {
                    this.msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoSimmetrico richiesta...");
                    if ("Anonimo".equals(richiestaDelegata.getServizioApplicativo())) {
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("profiloAsincronoSimmetrico.saAnonimo"), this.msgDiag.getLivello("profiloAsincronoSimmetrico.saAnonimo"));
                        Message responseAxisMessageError = this.xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_410", "Autenticazione necessaria per invocare il servizio richiesto.");
                        ejbUtils.sendRispostaApplicativaErrore(responseAxisMessageError, richiestaDelegata, pd, sa);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2);
                        return esito;
                    }
                    this.msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoSimmetrico richiesta (consegna asincrona)...");
                    boolean existsConsegnaRispostaAsincrona = false;
                    try {
                        existsConsegnaRispostaAsincrona = this.configurazionePdDReader.existsConsegnaRispostaAsincrona(sa);
                    }
                    catch (Exception e) {
                        this.msgDiag.logErroreGenerico(e, "existsConsegnaRispostaAsincrona(" + sa + ")");
                        Message responseAxisMessageError = this.xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_536", "Sistema non disponibile");
                        ejbUtils.sendRispostaApplicativaErrore(responseAxisMessageError, richiestaDelegata, pd, sa);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2);
                        return esito;
                    }
                    if (!existsConsegnaRispostaAsincrona) {
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("profiloAsincronoSimmetrico.saSenzaRispostaAsincrona"), this.msgDiag.getLivello("profiloAsincronoSimmetrico.saSenzaRispostaAsincrona"));
                        Message responseAxisMessageError = this.xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_411", "Definizione 'Ricezione Risposta Asincrona' necessaria per invocare il servizio richiesto.");
                        ejbUtils.sendRispostaApplicativaErrore(responseAxisMessageError, richiestaDelegata, pd, sa);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2);
                        return esito;
                    }
                    scenarioCooperazione = "AsincronoSimmetrico_InvocazioneServizio";
                    if (infoServizio.getServizioCorrelato() == null || infoServizio.getTipoServizioCorrelato() == null) {
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("profiloAsincronoSimmetrico.servizioCorrelatoNonEsistente"), this.msgDiag.getLivello("profiloAsincronoSimmetrico.servizioCorrelatoNonEsistente"));
                        Message responseAxisMessageError = this.xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_408", "Servizio correlato, associato al servizio SPCoop richiesto con la porta delegata, non trovato nel registro dei servizi di OpenSPCoop");
                        ejbUtils.sendRispostaApplicativaErrore(responseAxisMessageError, richiestaDelegata, pd, sa);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2);
                        return esito;
                    }
                    if (!"eGov1.1-lineeGuida1.1".equals(profiloGestione) && this.propertiesReader.isGenerazioneAttributiAsincroni(implementazionePdDDestinatario)) {
                        busta.setServizioCorrelato(infoServizio.getServizioCorrelato());
                        busta.setTipoServizioCorrelato(infoServizio.getTipoServizioCorrelato());
                    }
                    if ("eGov1.1-lineeGuida1.1".equals(profiloGestione) || this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDDestinatario) && infoServizio.getCollaborazione()) {
                        if (imbustamentoMsg.getIdCollaborazione() != null) {
                            busta.setCollaborazione(imbustamentoMsg.getIdCollaborazione());
                        } else {
                            busta.setCollaborazione(idEGovRequest);
                        }
                    }
                    try {
                        this.msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoSimmetrico richiesta (registrazione busta da inviare)...");
                        Integrazione infoIntegrazione = null;
                        if (this.configurazionePdDReader.isModalitaStatelessByProfiloServizio(pd, infoServizio.getProfiloDiCollaborazione())) {
                            infoIntegrazione = new Integrazione();
                            infoIntegrazione.setIdModuloInAttesa(this.idModulo);
                            infoIntegrazione.setLocationPD(richiestaDelegata.getLocationPD());
                            infoIntegrazione.setServizioApplicativo(richiestaDelegata.getServizioApplicativo());
                            if (busta.getScadenza() == null) {
                                busta.setScadenza(new Date(DateManager.getTimeMillis() + scadenzaBusta * 60L * 1000L));
                            }
                            if (openspcoopstate instanceof OpenSPCoopStateless) {
                                ((StatelessMessage)openspcoopstate.getStatoRichiesta()).setBusta(busta);
                            }
                        }
                        profiloDiCollaborazione.asincronoSimmetrico_registraRichiestaInviata(idEGovRequest, busta.getCollaborazione(), infoServizio.getTipoServizioCorrelato(), infoServizio.getServizioCorrelato(), richiestaDelegata.isRicevutaAsincrona(), infoIntegrazione, scadenzaBusta);
                    }
                    catch (EGovException e) {
                        this.msgDiag.logErroreGenerico((Exception)((Object)e), "profiloDiCollaborazione.asincronoSimmetrico_registraRichiestaInviata");
                        openspcoopstate.releaseResource();
                        Message responseAxisMessageError = this.xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_525", "Sistema non disponibile");
                        ejbUtils.sendRispostaApplicativaErrore(responseAxisMessageError, richiestaDelegata, pd, sa);
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2);
                        return esito;
                    }
                    richiestaDelegata.setUtilizzoConsegnaAsincrona(false);
                } else {
                    this.msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoSimmetrico risposta...");
                    scenarioCooperazione = "AsincronoSimmetrico_ConsegnaRisposta";
                    if (openspcoopstate instanceof OpenSPCoopStateless) {
                        if (busta.getScadenza() == null) {
                            busta.setScadenza(new Date(DateManager.getTimeMillis() + scadenzaBusta * 60L * 1000L));
                        }
                        ((StatelessMessage)openspcoopstate.getStatoRichiesta()).setBusta(busta);
                    }
                    try {
                        this.msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoSimmetrico risposta (lettura busta risposta)...");
                        Busta rispostaAsincrona = profiloDiCollaborazione.asincronoSimmetrico_getBustaRisposta(riferimentoServizioCorrelato, idEGovRequest, scadenzaBusta);
                        this.msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoSimmetrico risposta (check coerenza)...");
                        if (!busta.getTipoMittente().equals(rispostaAsincrona.getTipoDestinatario())) {
                            throw new EGovException("Il tipo di mittente della risposta non rispetta quello atteso nella gestione del profilo asincrono simmetrico.");
                        }
                        if (!busta.getMittente().equals(rispostaAsincrona.getDestinatario())) {
                            throw new EGovException("Il mittente della risposta non rispetta quello atteso nella gestione del profilo asincrono simmetrico.");
                        }
                        if (!busta.getTipoDestinatario().equals(rispostaAsincrona.getTipoMittente())) {
                            throw new EGovException("Il tipo di destinatario della risposta non rispetta quello atteso nella gestione del profilo asincrono simmetrico.");
                        }
                        if (!busta.getDestinatario().equals(rispostaAsincrona.getMittente())) {
                            throw new EGovException("Il destinatario della risposta non rispetta quello atteso nella gestione del profilo asincrono simmetrico.");
                        }
                        if (!busta.getTipoServizio().equals(rispostaAsincrona.getTipoServizioCorrelato())) {
                            throw new EGovException("Il tipo del servizio correlato invocato non rispetta quello atteso nella gestione del profilo asincrono simmetrico.");
                        }
                        if (!busta.getServizio().equals(rispostaAsincrona.getServizioCorrelato())) {
                            throw new EGovException("Il servizio correlato invocato non rispetta quello atteso nella gestione del profilo asincrono simmetrico.");
                        }
                        if (!"eGov1.1-lineeGuida1.1".equals(profiloGestione)) {
                            busta.setRiferimentoMessaggio(riferimentoServizioCorrelato);
                        }
                    }
                    catch (EGovException e) {
                        String codiceErrore = null;
                        String msgErrore = null;
                        if (e.getMessage() != null && e.getMessage().indexOf("Busta non trovata") != -1) {
                            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("profiloAsincronoSimmetrico.rispostaNonCorrelataRichiesta"), this.msgDiag.getLivello("profiloAsincronoSimmetrico.rispostaNonCorrelataRichiesta"));
                            codiceErrore = "OPENSPCOOP_ORG_409";
                            msgErrore = "risposta/richiestaStato non generabile poiche' non associata ad una precedente busta di richiesta asincrona";
                        } else {
                            this.msgDiag.logErroreGenerico((Exception)((Object)e), "profiloDiCollaborazione.asincronoSimmetrico_getBustaRisposta");
                            codiceErrore = "OPENSPCOOP_ORG_525";
                            msgErrore = "Sistema non disponibile";
                        }
                        Message responseAxisMessageError = this.xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, codiceErrore, msgErrore);
                        ejbUtils.sendRispostaApplicativaErrore(responseAxisMessageError, richiestaDelegata, pd, sa);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2);
                        return esito;
                    }
                    if ("eGov1.1-lineeGuida1.1".equals(profiloGestione) || this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDDestinatario) && infoServizio.getCollaborazione()) {
                        if (imbustamentoMsg.getIdCollaborazione() != null) {
                            busta.setCollaborazione(imbustamentoMsg.getIdCollaborazione());
                        } else {
                            busta.setCollaborazione(riferimentoServizioCorrelato);
                        }
                    }
                }
            } else if (infoServizio.getProfiloDiCollaborazione().equals("EGOV_IT_ServizioAsincronoAsimmetrico")) {
                this.msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoAsimmetrico ...");
                busta.setProfiloDiCollaborazione("EGOV_IT_ServizioAsincronoAsimmetrico");
                if (riferimentoServizioCorrelato == null && !isServizioCorrelato) {
                    this.msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoAsimmetrico richiesta...");
                    this.msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoAsimmetrico richiesta (ricevuta abilitata)...");
                    richiestaDelegata.setRicevutaAsincrona(this.configurazionePdDReader.ricevutaAsincronaAsimmetricaAbilitata(pd));
                    boolean bl = generazioneMsgOK = !richiestaDelegata.isRicevutaAsincrona();
                    generazioneMsgOK = this.configurazionePdDReader.isModalitaStatelessByProfiloServizio(pd, infoServizio.getProfiloDiCollaborazione()) ? !richiestaDelegata.isRicevutaAsincrona() : false;
                    scenarioCooperazione = "AsincronoAsimmetrico_InvocazioneServizio";
                    if ("eGov1.1-lineeGuida1.1".equals(profiloGestione) || this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDDestinatario) && infoServizio.getCollaborazione()) {
                        if (imbustamentoMsg.getIdCollaborazione() != null) {
                            busta.setCollaborazione(imbustamentoMsg.getIdCollaborazione());
                        } else {
                            busta.setCollaborazione(idEGovRequest);
                        }
                    }
                    try {
                        this.msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoAsimmetrico richiesta (registrazione busta da inviare)...");
                        if (this.configurazionePdDReader.isModalitaStatelessByProfiloServizio(pd, infoServizio.getProfiloDiCollaborazione())) {
                            if (busta.getScadenza() == null) {
                                busta.setScadenza(new Date(DateManager.getTimeMillis() + scadenzaBusta * 60L * 1000L));
                            }
                            if (openspcoopstate instanceof OpenSPCoopStateless) {
                                ((StatelessMessage)openspcoopstate.getStatoRichiesta()).setBusta(busta);
                            }
                        }
                        profiloDiCollaborazione.asincronoAsimmetrico_registraRichiestaInviata(idEGovRequest, busta.getCollaborazione(), richiestaDelegata.isRicevutaAsincrona(), scadenzaBusta);
                    }
                    catch (EGovException e) {
                        this.msgDiag.logErroreGenerico((Exception)((Object)e), "profiloDiCollaborazione.asincronoAsimmetrico_registraRichiestaInviata");
                        Message responseAxisMessageError = this.xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_525", "Sistema non disponibile");
                        ejbUtils.sendRispostaApplicativaErrore(responseAxisMessageError, richiestaDelegata, pd, sa);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2);
                        return esito;
                    }
                }
                this.msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoAsimmetrico richiestaStato...");
                scenarioCooperazione = "AsincronoAsimmetrico_Polling";
                richiestaDelegata.setRicevutaAsincrona(true);
                if (openspcoopstate instanceof OpenSPCoopStateless) {
                    if (busta.getScadenza() == null) {
                        busta.setScadenza(new Date(DateManager.getTimeMillis() + scadenzaBusta * 60L * 1000L));
                    }
                    ((StatelessMessage)openspcoopstate.getStatoRichiesta()).setBusta(busta);
                }
                try {
                    this.msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoAsimmetrico richiestaStato (lettura busta)...");
                    Busta richiestaStatoAsincrona = profiloDiCollaborazione.asincronoAsimmetrico_getBustaRisposta(riferimentoServizioCorrelato, idEGovRequest, scadenzaBusta);
                    this.msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoAsimmetrico richiestaStato (check coerenza)...");
                    if (!busta.getTipoMittente().equals(richiestaStatoAsincrona.getTipoMittente())) {
                        throw new EGovException("Il tipo di mittente della risposta non rispetta quello atteso nella gestione del profilo asincrono asimmetrico.");
                    }
                    if (!busta.getMittente().equals(richiestaStatoAsincrona.getMittente())) {
                        throw new EGovException("Il mittente della risposta non rispetta quello atteso nella gestione del profilo asincrono asimmetrico.");
                    }
                    if (!busta.getTipoDestinatario().equals(richiestaStatoAsincrona.getTipoDestinatario())) {
                        throw new EGovException("Il tipo di destinatario della risposta non rispetta quello atteso nella gestione del profilo asincrono asimmetrico.");
                    }
                    if (!busta.getDestinatario().equals(richiestaStatoAsincrona.getDestinatario())) {
                        throw new EGovException("Il destinatario della risposta non rispetta quello atteso nella gestione del profilo asincrono asimmetrico.");
                    }
                    if (!busta.getTipoServizio().equals(richiestaStatoAsincrona.getTipoServizioCorrelato())) {
                        throw new EGovException("Il tipo del servizio correlato invocato non rispetta quello atteso nella gestione del profilo asincrono asimmetrico.");
                    }
                    if (!busta.getServizio().equals(richiestaStatoAsincrona.getServizioCorrelato())) {
                        throw new EGovException("Il servizio correlato invocato non rispetta quello atteso nella gestione del profilo asincrono asimmetrico.");
                    }
                    if (!"eGov1.1-lineeGuida1.1".equals(profiloGestione)) {
                        busta.setRiferimentoMessaggio(riferimentoServizioCorrelato);
                    }
                }
                catch (EGovException e) {
                    String codiceErrore = null;
                    String msgErrore = null;
                    if (e.getMessage() != null && e.getMessage().indexOf("Busta non trovata") != -1) {
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("profiloAsincronoAsimmetrico.richiestaStatoNonCorrelataRichiesta"), this.msgDiag.getLivello("profiloAsincronoAsimmetrico.richiestaStatoNonCorrelataRichiesta"));
                        codiceErrore = "OPENSPCOOP_ORG_409";
                        msgErrore = "risposta/richiestaStato non generabile poiche' non associata ad una precedente busta di richiesta asincrona";
                    } else {
                        this.msgDiag.logErroreGenerico((Exception)((Object)e), "profiloDiCollaborazione.asincronoAsimmetrico_getBustaRisposta");
                        codiceErrore = "OPENSPCOOP_ORG_525";
                        msgErrore = "Sistema non disponibile";
                    }
                    Message responseAxisMessageError = this.xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, codiceErrore, msgErrore);
                    ejbUtils.sendRispostaApplicativaErrore(responseAxisMessageError, richiestaDelegata, pd, sa);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2);
                    return esito;
                }
                if ("eGov1.1-lineeGuida1.1".equals(profiloGestione) || this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDDestinatario) && infoServizio.getCollaborazione()) {
                    if (imbustamentoMsg.getIdCollaborazione() != null) {
                        busta.setCollaborazione(imbustamentoMsg.getIdCollaborazione());
                    } else {
                        busta.setCollaborazione(riferimentoServizioCorrelato);
                    }
                }
            } else {
                this.msgDiag.logErroreGenerico("Profilo di Collaborazione [" + infoServizio.getProfiloDiCollaborazione() + "] non gestito", "gestioneProfiloCollaborazione");
                Message responseAxisMessageError = this.xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_525", "Sistema non disponibile");
                ejbUtils.sendRispostaApplicativaErrore(responseAxisMessageError, richiestaDelegata, pd, sa);
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(true);
                esito.setStatoInvocazione(2);
                return esito;
            }
            richiestaDelegata.setScenario(scenarioCooperazione);
            ejbUtils.setScenarioCooperazione(scenarioCooperazione);
            richiestaDelegata.setIdCollaborazione(busta.getCollaborazione());
            richiestaDelegata.setProfiloCollaborazione(busta.getProfiloDiCollaborazione());
            boolean stateless = this.configurazionePdDReader.isModalitaStatelessByProfiloServizio(pd, infoServizio.getProfiloDiCollaborazione());
            if (!oneWayVersione11 && !stateless) {
                this.msgDiag.mediumDebug("Aggiornamento busta nel RepositoryEGov...");
                try {
                    repositoryEGov.aggiornaBustaIntoOutBox(busta, this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi());
                    repositoryEGov.aggiornaInfoIntegrazioneIntoOutBox_Scenario(busta.getID(), scenarioCooperazione);
                }
                catch (EGovException e) {
                    this.msgDiag.logErroreGenerico((Exception)((Object)e), "repositoryEGov.aggiornaBusta/InfoIntegrazione_IntoOutBox");
                    Message responseAxisMessageError = this.xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_525", "Sistema non disponibile");
                    ejbUtils.sendRispostaApplicativaErrore(responseAxisMessageError, richiestaDelegata, pd, sa);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2);
                    return esito;
                }
            }
            if (!"eGov1.1-lineeGuida1.1".equals(profiloGestione) && this.propertiesReader.isGestioneRiscontri(implementazionePdDDestinatario) && infoServizio.getConfermaRicezione()) {
                if ("EGOV_IT_MessaggioSingoloOneWay".equals(infoServizio.getProfiloDiCollaborazione())) {
                    this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("consegnaAffidabile.salvataggioInformazioni"), this.msgDiag.getLivello("consegnaAffidabile.salvataggioInformazioni"));
                    try {
                        gestoreRiscontri.registraRiscontroDaRicevere(busta.getID(), DateManager.getDate());
                    }
                    catch (EGovException e) {
                        this.msgDiag.logErroreGenerico((Exception)((Object)e), "gestoreRiscontri.registraRiscontroDaRicevere");
                        Message responseAxisMessageError = this.xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_525", "Sistema non disponibile");
                        ejbUtils.sendRispostaApplicativaErrore(responseAxisMessageError, richiestaDelegata, pd, sa);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2);
                        return esito;
                    }
                } else {
                    this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("consegnaAffidabile.profiloNonOneway"), this.msgDiag.getLivello("consegnaAffidabile.profiloNonOneway"));
                }
            }
            this.msgDiag.mediumDebug("Invio messaggio al modulo di InoltroBusteEGov...");
            InoltroBusteEGovMessage inoltroMSG = new InoltroBusteEGovMessage();
            inoltroMSG.setRichiestaDelegata(richiestaDelegata);
            inoltroMSG.setBusta(busta);
            inoltroMSG.setOneWayVersione11(oneWayVersione11);
            inoltroMSG.setImplementazionePdDSoggettoMittente(imbustamentoMsg.getImplementazionePdDSoggettoMittente());
            inoltroMSG.setImplementazionePdDSoggettoDestinatario(imbustamentoMsg.getImplementazionePdDSoggettoDestinatario());
            msgRequest = new GestoreMessaggi(openspcoopstate, true, idEGovRequest, "OUTBOX", this.msgDiag);
            if (!stateless) {
                if (oneWayVersione11) {
                    OpenSPCoopStateless statelessSerializzabile = ((OpenSPCoopStateless)openspcoopstate).rendiSerializzabile();
                    inoltroMSG.setOpenspcoopstate(statelessSerializzabile);
                    msgRequest.setOneWayVersione11(true);
                }
                try {
                    GenericLib.nodeSender.send(inoltroMSG, "InoltroBusteEGov", this.msgDiag, identitaPdD.getCodicePorta(), ID_MODULO, idEGovRequest, msgRequest);
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "GenericLib.nodeSender.send(InoltroBusteEGov)");
                    Message responseAxisMessageError = this.xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_512", "Sistema non disponibile");
                    ejbUtils.sendRispostaApplicativaErrore(responseAxisMessageError, richiestaDelegata, pd, sa);
                    openspcoopstate.releaseResource();
                    esito.setStatoInvocazione(2);
                    esito.setEsitoInvocazione(true);
                    return esito;
                }
            }
            if (generazioneMsgOK) {
                this.msgDiag.mediumDebug("Invio messaggio 'OK' al modulo di RicezioneContenutiApplicativi...");
                msgOK = this.propertiesReader.isHttp202OneWay() ? ejbUtils.sendRispostaApplicativaOK(SoapUtils.build_Soap_Empty(), richiestaDelegata, pd, sa) : ejbUtils.sendRispostaApplicativaOK(SoapUtils.buildOpenSPCoopOK_axisMsg((String)idEGovRequest), richiestaDelegata, pd, sa);
                msgOK.aggiornaInfoAttraversamentoPdDMessaggioRisposta(msgRequest.getOraRegistrazioneMessaggio(), DateManager.getTimestamp(), DateManager.getTimestamp());
            }
            this.msgDiag.mediumDebug("Aggiorno proprietario messaggio...");
            msgRequest.aggiornaProprietarioMessaggio("InoltroBusteEGov");
            this.msgDiag.mediumDebug("Commit delle operazioni per la gestione della richiesta...");
            openspcoopstate.commit();
            if (msgRequest != null) {
                msgRequest.addMessaggiIntoCache_readFromTable(ID_MODULO, "richiesta");
            }
            if (msgOK != null) {
                msgOK.addMessaggiIntoCache_readFromTable(ID_MODULO, "messaggio OK");
            }
            if (msgRequest != null) {
                msgRequest.addProprietariIntoCache_readFromTable(ID_MODULO, "richiesta", null, false);
            }
            if (msgOK != null) {
                msgOK.addProprietariIntoCache_readFromTable(ID_MODULO, "messaggio OK", idEGovRequest, false);
            }
            this.msgDiag.mediumDebug("Rilascio connessione al database...");
            openspcoopstate.releaseResource();
            this.msgDiag.mediumDebug("Lavoro Terminato.");
            esito.setEsitoInvocazione(true);
            esito.setStatoInvocazione(1);
            if (stateless) {
                ((OpenSPCoopState)openspcoopstate).setMessageLib(inoltroMSG);
            }
            return esito;
        }
        catch (Exception e) {
            this.log.error((Object)"ErroreGenerale", (Throwable)e);
            this.msgDiag.logErroreGenerico(e, "Generale");
            Message responseAxisMessageError = this.xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_500", "Sistema non disponibile");
            try {
                ejbUtils.sendRispostaApplicativaErrore(responseAxisMessageError, richiestaDelegata, pd, sa);
                esito.setStatoInvocazione(2);
                esito.setEsitoInvocazione(true);
            }
            catch (Exception er) {
                this.msgDiag.logErroreGenerico(er, "ejbUtils.sendErroreGenerale");
                ejbUtils.rollbackMessage("Spedizione Errore al Mittente durante una richiesta non riuscita");
                esito.setEsitoInvocazione(false);
                esito.setStatoInvocazione(3);
            }
            openspcoopstate.releaseResource();
            return esito;
        }
    }
}

