/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.mdb;

import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.apache.log4j.Logger;
import org.openspcoop.dao.state.IState;
import org.openspcoop.dao.state.StatelessMessage;
import org.openspcoop.pdd.config.RichiestaApplicativa;
import org.openspcoop.pdd.config.RichiestaDelegata;
import org.openspcoop.pdd.core.node.TransactionManager;
import org.openspcoop.pdd.core.state.OpenSPCoopState;
import org.openspcoop.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.mdb.ConsegnaContenutiApplicativi;
import org.openspcoop.pdd.mdb.ConsegnaContenutiApplicativiMessage;
import org.openspcoop.pdd.mdb.EsitoLib;
import org.openspcoop.pdd.services.OpenSPCoopStartup;
import org.openspcoop.pdd.timers.TimerMonitoraggioRisorse;

public class ConsegnaContenutiApplicativiMDB
implements MessageDrivenBean,
MessageListener {
    private static final long serialVersionUID = 1L;
    private Logger log = null;
    private MessageDrivenContext ctxMDB;

    public void setMessageDrivenContext(MessageDrivenContext mdc) throws EJBException {
        this.ctxMDB = mdc;
    }

    public void ejbCreate() {
    }

    public void ejbRemove() {
    }

    public void onMessage(Message message) {
        if (message instanceof ObjectMessage) {
            if (!OpenSPCoopStartup.initialize) {
                this.ctxMDB.setRollbackOnly();
                return;
            }
            this.log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
            if (this.log == null) {
                System.out.println("[ConsegnaContenutiApplicativi] Logger nullo. MDB abortito");
                return;
            }
            if (!TimerMonitoraggioRisorse.risorseDisponibili) {
                this.log.error((Object)("[ConsegnaContenutiApplicativi] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            ConsegnaContenutiApplicativi lib = new ConsegnaContenutiApplicativi(this.log);
            if (!lib.inizializzazioneUltimata) {
                this.log = Logger.getLogger((String)"OpenSPCoop.ConsegnaContenutiApplicativi");
                this.log.error((Object)"[ConsegnaContenutiApplicativi] Inizializzazione MDB non riuscita");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            MsgDiagnostico msgDiag = new MsgDiagnostico("ConsegnaContenutiApplicativi");
            msgDiag.mediumDebug("Ricezione richiesta (ConsegnaContenutiApplicativiMessage)...");
            ObjectMessage received = (ObjectMessage)message;
            ConsegnaContenutiApplicativiMessage consegnaContenutiApplicativiMsg = null;
            try {
                consegnaContenutiApplicativiMsg = (ConsegnaContenutiApplicativiMessage)received.getObject();
            }
            catch (JMSException e) {
                msgDiag.logErroreGenerico((Exception)((Object)e), "received.getObject(ConsegnaContenutiApplicativiMessage)");
                return;
            }
            String idEGovConsegna = null;
            try {
                idEGovConsegna = received.getStringProperty("ID");
            }
            catch (JMSException e) {
                msgDiag.logErroreGenerico((Exception)((Object)e), "received.getStringProperty(ID)");
                return;
            }
            RichiestaApplicativa richiestaApplicativa = consegnaContenutiApplicativiMsg.getRichiestaApplicativa();
            RichiestaDelegata richiestaDelegata = consegnaContenutiApplicativiMsg.getRichiestaDelegata();
            String servizioApplicativo = null;
            servizioApplicativo = richiestaApplicativa != null ? richiestaApplicativa.getServizioApplicativo() : richiestaDelegata.getServizioApplicativo();
            msgDiag.mediumDebug("Transaction Manager...");
            try {
                if (!TransactionManager.validityCheck(msgDiag, "ConsegnaContenutiApplicativi", idEGovConsegna, "INBOX", received.getJMSMessageID(), servizioApplicativo)) {
                    msgDiag.lowDebug("Messaggio con id[" + idEGovConsegna + "] non ha superato il validity check");
                    return;
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "TransactionManager.validityCheck");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            EsitoLib esito = null;
            OpenSPCoopState stato = null;
            try {
                if (consegnaContenutiApplicativiMsg.getOpenspcoopstate() != null) {
                    stato = consegnaContenutiApplicativiMsg.getOpenspcoopstate();
                    if (stato.getStatoRichiesta() == null && consegnaContenutiApplicativiMsg.getBusta() != null) {
                        StatelessMessage statoRichiesta = new StatelessMessage();
                        statoRichiesta.setBusta(consegnaContenutiApplicativiMsg.getBusta());
                        stato.setStatoRichiesta((IState)statoRichiesta);
                    }
                    ((OpenSPCoopStateless)stato).setUseConnection(true);
                    ((OpenSPCoopStateless)stato).setMessageLib(consegnaContenutiApplicativiMsg);
                    ((OpenSPCoopStateless)stato).setIDEgovSessione(idEGovConsegna);
                } else {
                    stato = new OpenSPCoopStateful();
                    ((OpenSPCoopStateful)stato).setIDEgovSessione(idEGovConsegna);
                    ((OpenSPCoopStateful)stato).setMessageLib(consegnaContenutiApplicativiMsg);
                }
                esito = lib.onMessage(stato);
            }
            catch (Exception e) {
                this.log.error((Object)"[ConsegnaContenutiApplicativi] Impossibile chiamare la libreria", (Throwable)e);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!esito.isEsitoInvocazione()) {
                this.log.error((Object)"[ConsegnaContenutiApplicativi] Chiamata alla libreria fallita");
                this.ctxMDB.setRollbackOnly();
            } else {
                this.log.debug((Object)"[ConsegnaContenutiApplicativi] Chiamata alla libreria riuscita");
            }
        }
    }
}

