/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.mdb;

import java.io.ByteArrayInputStream;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.soap.AttachmentPart;
import org.apache.axis.Message;
import org.apache.axis.encoding.Base64;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPFault;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.config.GestioneErrore;
import org.openspcoop.dao.config.PortaApplicativa;
import org.openspcoop.dao.config.PortaDelegata;
import org.openspcoop.dao.config.ServizioApplicativo;
import org.openspcoop.dao.config.ValidazioneContenutiApplicativi;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.egov.Busta;
import org.openspcoop.egov.ConsegnaInOrdine;
import org.openspcoop.egov.Imbustamento;
import org.openspcoop.egov.Riscontro;
import org.openspcoop.pdd.config.ClassNameProperties;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.config.RichiestaApplicativa;
import org.openspcoop.pdd.config.RichiestaDelegata;
import org.openspcoop.pdd.core.EJBUtils;
import org.openspcoop.pdd.core.GestoreMessaggi;
import org.openspcoop.pdd.core.ValidatoreMessaggiApplicativi;
import org.openspcoop.pdd.core.ValidatoreMessaggiApplicativiException;
import org.openspcoop.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop.pdd.core.connettori.GestoreErroreConnettore;
import org.openspcoop.pdd.core.connettori.IConnettore;
import org.openspcoop.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop.pdd.core.integrazione.IGestoreIntegrazionePA;
import org.openspcoop.pdd.core.integrazione.IGestoreIntegrazionePASoap;
import org.openspcoop.pdd.core.state.IOpenSPCoopState;
import org.openspcoop.pdd.core.state.OpenSPCoopStateException;
import org.openspcoop.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop.pdd.logger.Dump;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.mdb.ConsegnaContenutiApplicativiMessage;
import org.openspcoop.pdd.mdb.EsitoLib;
import org.openspcoop.pdd.mdb.GenericLib;
import org.openspcoop.pdd.mdb.ImbustamentoRisposteMessage;
import org.openspcoop.utils.SoapUtils;
import org.openspcoop.utils.date.DateManager;
import org.w3c.dom.Node;

public class ConsegnaContenutiApplicativi
extends GenericLib {
    public static final String ID_MODULO = "ConsegnaContenutiApplicativi";
    public static Hashtable<String, IGestoreIntegrazionePA> gestoriIntegrazionePA = null;
    public static String[] defaultGestoriIntegrazionePA = null;
    public static boolean initializeService = false;

    public ConsegnaContenutiApplicativi(Logger log) {
        super(ID_MODULO, log);
        this.inizializza();
    }

    protected synchronized void inizializza() {
        super.inizializza();
        ConsegnaContenutiApplicativi.initializeService(ClassNameProperties.getInstance(), this.propertiesReader);
    }

    public static synchronized void initializeService(ClassNameProperties className, OpenSPCoopProperties propertiesReader) {
        if (initializeService) {
            return;
        }
        boolean error = false;
        Logger logCore = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        defaultGestoriIntegrazionePA = propertiesReader.getTipoIntegrazionePA();
        gestoriIntegrazionePA = new Hashtable();
        for (int i = 0; i < defaultGestoriIntegrazionePA.length; ++i) {
            String classType = className.getIntegrazionePortaApplicativa(defaultGestoriIntegrazionePA[i]);
            try {
                Class<?> c = Class.forName(classType);
                gestoriIntegrazionePA.put(defaultGestoriIntegrazionePA[i], (IGestoreIntegrazionePA)c.newInstance());
                logCore.info((Object)("Inizializzazione gestore integrazione PdD->servizioApplicativo di tipo " + defaultGestoriIntegrazionePA[i] + " effettuata."));
                continue;
            }
            catch (Exception e) {
                logCore.error((Object)("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione dell'integrazione di tipo [" + defaultGestoriIntegrazionePA[i] + "]: " + e.getMessage()));
                error = true;
            }
        }
        try {
            GenericLib.nodeSender = EJBUtils.getNodeSender(propertiesReader, logCore);
        }
        catch (Exception e) {
            error = true;
        }
        initializeService = !error;
    }

    public static synchronized void aggiornaListaGestoreIntegrazione(String newTipo, ClassNameProperties className, OpenSPCoopProperties propertiesReader) throws Exception {
        if (gestoriIntegrazionePA.contains(newTipo)) {
            return;
        }
        String classType = className.getIntegrazionePortaApplicativa(newTipo);
        Logger logCore = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        try {
            Class<?> c = Class.forName(classType);
            gestoriIntegrazionePA.put(newTipo, (IGestoreIntegrazionePA)c.newInstance());
            logCore.info((Object)("Inizializzazione gestore integrazione PdD->servizioApplicativo di tipo " + newTipo + " effettuata."));
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione dell'integrazione di tipo [" + newTipo + "]: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EsitoLib onMessage(IOpenSPCoopState openspcoopstate) throws OpenSPCoopStateException {
        boolean gestioneConsegnaInOrdineAbilitata;
        EsitoLib esito = new EsitoLib();
        ConsegnaContenutiApplicativiMessage consegnaContenutiApplicativiMsg = (ConsegnaContenutiApplicativiMessage)openspcoopstate.getMessageLib();
        String idEGovConsegna = openspcoopstate.getIDEgovSessione();
        String implementazionePdDMittente = consegnaContenutiApplicativiMsg.getImplementazionePdDSoggettoMittente();
        RichiestaApplicativa richiestaApplicativa = consegnaContenutiApplicativiMsg.getRichiestaApplicativa();
        RichiestaDelegata richiestaDelegata = consegnaContenutiApplicativiMsg.getRichiestaDelegata();
        Busta bustaRichiesta = consegnaContenutiApplicativiMsg.getBusta();
        this.msgDiag.setPrefixMsgPersonalizzati("consegnaContenutiApplicativi.");
        if (bustaRichiesta != null) {
            this.msgDiag.addKeywords(bustaRichiesta, true);
        }
        String servizio = null;
        String tipoServizio = null;
        String azione = null;
        if (bustaRichiesta != null) {
            servizio = bustaRichiesta.getServizio();
            tipoServizio = bustaRichiesta.getTipoServizio();
            azione = bustaRichiesta.getAzione();
        }
        String idModuloInAttesa = null;
        IDSoggetto identitaPdD = null;
        IDSoggetto soggettoFruitore = null;
        String servizioApplicativo = null;
        String scenarioCooperazione = null;
        IDServizio idServizio = null;
        boolean isRicevutaAsincrona = false;
        String[] tipiIntegrazione = null;
        boolean allegaBody = false;
        boolean scartaBody = false;
        String servizioApplicativoFruitore = null;
        String idCorrelazioneApplicativa = null;
        boolean portaStateless = false;
        IDServizio servizioHeaderIntegrazione = null;
        IDSoggetto soggettoFruitoreHeaderIntegrazione = null;
        if (bustaRichiesta != null) {
            servizioHeaderIntegrazione = new IDServizio();
            servizioHeaderIntegrazione.setTipoServizio(bustaRichiesta.getTipoServizio());
            servizioHeaderIntegrazione.setServizio(bustaRichiesta.getServizio());
            servizioHeaderIntegrazione.setAzione(bustaRichiesta.getAzione());
        }
        String profiloGestione = null;
        if (richiestaApplicativa != null) {
            identitaPdD = richiestaApplicativa.getDominio();
            soggettoFruitore = richiestaApplicativa.getSoggettoFruitore();
            servizioApplicativo = richiestaApplicativa.getServizioApplicativo();
            idModuloInAttesa = richiestaApplicativa.getIdModuloInAttesa();
            scenarioCooperazione = richiestaApplicativa.getScenario();
            isRicevutaAsincrona = richiestaApplicativa.isRicevutaAsincrona();
            idServizio = richiestaApplicativa.getIDServizio();
            if (servizioHeaderIntegrazione != null) {
                servizioHeaderIntegrazione.setSoggettoErogatore(idServizio.getSoggettoErogatore());
            }
            profiloGestione = richiestaApplicativa.getProfiloGestione();
            servizioApplicativoFruitore = richiestaApplicativa.getIdentitaServizioApplicativoFruitore();
            idCorrelazioneApplicativa = richiestaApplicativa.getIdCorrelazioneApplicativa();
        } else {
            identitaPdD = richiestaDelegata.getDominio();
            soggettoFruitore = richiestaDelegata.getSoggettoFruitore();
            servizioApplicativo = richiestaDelegata.getServizioApplicativo();
            idModuloInAttesa = richiestaDelegata.getIdModuloInAttesa();
            scenarioCooperazione = richiestaDelegata.getScenario();
            isRicevutaAsincrona = richiestaDelegata.isRicevutaAsincrona();
            idServizio = richiestaDelegata.getIdServizio();
            if (servizioHeaderIntegrazione != null && "AsincronoSimmetrico_ConsegnaRisposta".equals(scenarioCooperazione)) {
                servizioHeaderIntegrazione.setSoggettoErogatore(new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario()));
                soggettoFruitoreHeaderIntegrazione = new IDSoggetto(bustaRichiesta.getTipoMittente(), bustaRichiesta.getMittente());
            } else {
                servizioHeaderIntegrazione.setSoggettoErogatore(idServizio.getSoggettoErogatore());
            }
            profiloGestione = richiestaDelegata.getProfiloGestione();
            servizioApplicativoFruitore = richiestaDelegata.getServizioApplicativo();
            idCorrelazioneApplicativa = richiestaDelegata.getIdCorrelazioneApplicativa();
        }
        this.msgDiag.mediumDebug("Profilo di gestione [ConsegnaContenutiApplicativi] della busta: " + profiloGestione);
        this.msgDiag.setDominioSPCoop(identitaPdD.getCodicePorta());
        this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_EROGATORE@", servizioApplicativo);
        if (servizioApplicativoFruitore != null) {
            this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE@", servizioApplicativoFruitore);
        }
        this.msgDiag.setIdEGovRichiesta(idEGovConsegna);
        if (soggettoFruitoreHeaderIntegrazione != null) {
            this.msgDiag.setFruitore(soggettoFruitoreHeaderIntegrazione);
        } else {
            this.msgDiag.setFruitore(soggettoFruitore);
        }
        if (servizioHeaderIntegrazione != null) {
            this.msgDiag.setServizio(servizioHeaderIntegrazione);
        } else {
            this.msgDiag.setServizio(idServizio);
        }
        this.msgDiag.setDelegata(false);
        this.msgDiag.setServizioApplicativo(servizioApplicativo);
        String profiloCollaborazione = EJBUtils.getProfiloCollaborazioneByScenarioCooperazione(scenarioCooperazione);
        PortaApplicativa pa = null;
        PortaDelegata pd = null;
        ServizioApplicativo sa = null;
        if (richiestaApplicativa != null) {
            try {
                pa = this.configurazionePdDReader.getPortaApplicativa(richiestaApplicativa.getIdPortaApplicativa(), richiestaApplicativa.getFiltroProprietaPorteApplicative());
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "RichiestaApplicativa.getPortaApplicativa");
                esito.setEsitoInvocazione(false);
                esito.setStatoInvocazione(3);
                return esito;
            }
            try {
                sa = this.configurazionePdDReader.getServizioApplicativo(richiestaApplicativa.getIdPortaApplicativa(), richiestaApplicativa.getServizioApplicativo());
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "RichiestaApplicativa.getServizioApplicativo");
                esito.setEsitoInvocazione(false);
                esito.setStatoInvocazione(3);
                return esito;
            }
        }
        try {
            pd = this.configurazionePdDReader.getPortaDelegata(richiestaDelegata.getIdPortaDelegata());
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "RichiestaDelegata.getPortaApplicativa");
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazione(3);
            return esito;
        }
        try {
            sa = this.configurazionePdDReader.getServizioApplicativo(richiestaDelegata.getIdPortaDelegata(), richiestaDelegata.getServizioApplicativo());
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "RichiestaDelegata.getServizioApplicativo");
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazione(3);
            return esito;
        }
        if (richiestaApplicativa != null) {
            try {
                allegaBody = this.configurazionePdDReader.isAllegaBody(pa);
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "RichiestaApplicativa.isAllegaBody");
                esito.setEsitoInvocazione(false);
                esito.setStatoInvocazione(3);
                return esito;
            }
            try {
                scartaBody = this.configurazionePdDReader.isScartaBody(pa);
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "RichiestaApplicativa.isScartaBody");
                esito.setEsitoInvocazione(false);
                esito.setStatoInvocazione(3);
                return esito;
            }
            try {
                tipiIntegrazione = this.configurazionePdDReader.getTipiIntegrazione(pa);
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "RichiestaApplicativa.getTipiIntegrazione");
                esito.setEsitoInvocazione(false);
                esito.setStatoInvocazione(3);
                return esito;
            }
            try {
                portaStateless = this.configurazionePdDReader.isModalitaStatelessByProfiloServizio(pa, profiloCollaborazione);
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "RichiestaApplicativa.isModalitaStateless(" + profiloCollaborazione + ")");
                esito.setEsitoInvocazione(false);
                return esito;
            }
        }
        try {
            allegaBody = this.configurazionePdDReader.isAllegaBody(pd);
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "RichiestaDelegata.isAllegaBody");
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazione(3);
            return esito;
        }
        try {
            scartaBody = this.configurazionePdDReader.isScartaBody(pd);
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "RichiestaDelegata.isScartaBody");
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazione(3);
            return esito;
        }
        try {
            tipiIntegrazione = this.configurazionePdDReader.getTipiIntegrazione(pd);
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "RichiestaDelegata.getTipiIntegrazione");
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazione(3);
            return esito;
        }
        try {
            portaStateless = this.configurazionePdDReader.isModalitaStatelessByProfiloServizio(pd, profiloCollaborazione);
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "RichiestaDelegata.isModalitaStateless(" + profiloCollaborazione + ")");
            esito.setEsitoInvocazione(false);
            return esito;
        }
        this.msgDiag.mediumDebug("Richiesta connessione al database per la gestione della richiesta...");
        openspcoopstate.initResource(identitaPdD, ID_MODULO);
        boolean existsModuloInAttesaRispostaApplicativa = false;
        if ("Sincrono_InvocazioneServizio".equals(scenarioCooperazione)) {
            existsModuloInAttesaRispostaApplicativa = true;
        } else if ("AsincronoAsimmetrico_Polling".equals(scenarioCooperazione)) {
            existsModuloInAttesaRispostaApplicativa = true;
        } else if ("AsincronoAsimmetrico_InvocazioneServizio".equals(scenarioCooperazione) || "AsincronoSimmetrico_InvocazioneServizio".equals(scenarioCooperazione) || "AsincronoSimmetrico_ConsegnaRisposta".equals(scenarioCooperazione)) {
            existsModuloInAttesaRispostaApplicativa = isRicevutaAsincrona || portaStateless;
        } else if (richiestaApplicativa != null && "OneWay_InvocazioneServizio".equals(richiestaApplicativa.getScenario())) {
            existsModuloInAttesaRispostaApplicativa = portaStateless;
        }
        this.msgDiag.mediumDebug("Inizializzo contesto per la gestione...");
        EJBUtils ejbUtils = null;
        try {
            ejbUtils = new EJBUtils(identitaPdD, ID_MODULO, idEGovConsegna, idEGovConsegna, "INBOX", openspcoopstate, this.msgDiag, false, consegnaContenutiApplicativiMsg.getImplementazionePdDSoggettoMittente(), consegnaContenutiApplicativiMsg.getImplementazionePdDSoggettoDestinatario());
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "EJBUtils.new");
            openspcoopstate.releaseResource();
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazione(3);
            return esito;
        }
        boolean oneWayVersione11 = consegnaContenutiApplicativiMsg.isOneWayVersione11();
        ejbUtils.setOneWayVersione11(oneWayVersione11);
        ejbUtils.setOneWayVersione11(oneWayVersione11);
        this.msgDiag.mediumDebug("Inizializzo contesto per la gestione (GestoreMessaggio)...");
        GestoreMessaggi msgRequest = new GestoreMessaggi(openspcoopstate, true, idEGovConsegna, "INBOX", this.msgDiag);
        GestoreMessaggi msgResponse = null;
        msgRequest.setPortaDiTipoStateless(portaStateless);
        msgRequest.setOneWayVersione11(oneWayVersione11);
        try {
            if (!msgRequest.isRiconsegnaMessaggio(servizioApplicativo)) {
                openspcoopstate.releaseResource();
                if (!existsModuloInAttesaRispostaApplicativa) {
                    this.msgDiag.lowDebug("Riconsegna messaggio prematura.");
                    esito.setEsitoInvocazione(false);
                    esito.setStatoInvocazione(3);
                } else {
                    if (richiestaApplicativa != null && "OneWay_InvocazioneServizio".equals(richiestaApplicativa.getScenario())) {
                        this.msgDiag.logErroreGenerico("Messaggio eliminato durante il controllo di ri-consegna (" + scenarioCooperazione + ")", "msgRequest.isRiconsegnaMessaggio(" + servizioApplicativo + "," + scenarioCooperazione + ")");
                    } else {
                        this.msgDiag.logErroreGenerico("Messaggio eliminato durante il controllo di ri-consegna (" + scenarioCooperazione + ",STATELESS)", "msgRequest.isRiconsegnaMessaggio(" + servizioApplicativo + "," + scenarioCooperazione + ",STATELESS)");
                    }
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(3);
                }
                this.log.error((Object)"ConsegnaContenutiApplicativiEsco al punto 1");
                return esito;
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "msgRequest.isRiconsegnaMessaggio(" + servizioApplicativo + ")");
            ejbUtils.rollbackMessage("Errore verifica riconsegna messaggio", servizioApplicativo);
            openspcoopstate.releaseResource();
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazione(3);
            return esito;
        }
        ConsegnaInOrdine ordineConsegna = null;
        this.msgDiag.mediumDebug("Inizializzo contesto per la gestione (Consegna)...");
        ConnettoreMsg connettoreMsg = null;
        GestioneErrore gestioneConsegnaConnettore = null;
        boolean consegnaPerRiferimento = false;
        boolean rispostaPerRiferimento = false;
        ValidazioneContenutiApplicativi validazioneContenutoApplicativoApplicativo = null;
        if (ID_MODULO.equals(scenarioCooperazione) || "AsincronoSimmetrico_ConsegnaRisposta".equals(scenarioCooperazione)) {
            try {
                connettoreMsg = this.configurazionePdDReader.getConsegnaRispostaAsincrona(sa, richiestaDelegata);
                validazioneContenutoApplicativoApplicativo = this.configurazionePdDReader.getTipoValidazioneContenutoApplicativo(pd, implementazionePdDMittente);
                gestioneConsegnaConnettore = this.configurazionePdDReader.getGestioneErroreConnettore_RispostaAsincrona(sa);
                consegnaPerRiferimento = this.configurazionePdDReader.consegnaRispostaAsincronaPerRiferimento(sa);
                rispostaPerRiferimento = this.configurazionePdDReader.consegnaRispostaAsincronaRispostaPerRiferimento(sa);
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "ConsegnaAsincrona.getDatiConsegna(sa:" + servizioApplicativo + ")");
                ejbUtils.rollbackMessage("[ConsegnaAsincrona] Connettore per consegna applicativa non definito:" + e.getMessage(), servizioApplicativo);
                esito.setEsitoInvocazione(false);
                esito.setStatoInvocazione(3);
                return esito;
            }
        }
        if ("AsincronoAsimmetrico_Polling".equals(scenarioCooperazione)) {
            try {
                connettoreMsg = this.configurazionePdDReader.getConsegnaRispostaAsincrona(sa, richiestaApplicativa);
                validazioneContenutoApplicativoApplicativo = this.configurazionePdDReader.getTipoValidazioneContenutoApplicativo(pa, implementazionePdDMittente);
                gestioneConsegnaConnettore = this.configurazionePdDReader.getGestioneErroreConnettore_RispostaAsincrona(sa);
                consegnaPerRiferimento = this.configurazionePdDReader.consegnaRispostaAsincronaPerRiferimento(sa);
                rispostaPerRiferimento = this.configurazionePdDReader.consegnaRispostaAsincronaRispostaPerRiferimento(sa);
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "AsincronoSimmetricoPolling.getDatiConsegna(sa:" + servizioApplicativo + ")");
                ejbUtils.rollbackMessage("[AsincronoSimmetricoPolling] Connettore per consegna applicativa non definito:" + e.getMessage(), servizioApplicativo);
                esito.setEsitoInvocazione(false);
                esito.setStatoInvocazione(3);
                return esito;
            }
        }
        try {
            connettoreMsg = this.configurazionePdDReader.getInvocazioneServizio(sa, richiestaApplicativa);
            validazioneContenutoApplicativoApplicativo = this.configurazionePdDReader.getTipoValidazioneContenutoApplicativo(pa, implementazionePdDMittente);
            gestioneConsegnaConnettore = this.configurazionePdDReader.getGestioneErroreConnettore_InvocazioneServizio(sa);
            consegnaPerRiferimento = this.configurazionePdDReader.invocazioneServizioPerRiferimento(sa);
            rispostaPerRiferimento = this.configurazionePdDReader.invocazioneServizioRispostaPerRiferimento(sa);
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "InvocazioneServizio.getDatiConsegna(sa:" + servizioApplicativo + ")");
            ejbUtils.rollbackMessage("Connettore per consegna applicativa non definito:" + e.getMessage(), servizioApplicativo);
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazione(3);
            return esito;
        }
        if (connettoreMsg == null) {
            this.msgDiag.logErroreGenerico("Connettore non definito nella configurazione (is null)", "getDatiConsegna(sa:" + servizioApplicativo + ")");
            ejbUtils.rollbackMessage("Connettore per consegna applicativa non definito.", servizioApplicativo);
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazione(3);
            return esito;
        }
        if (gestioneConsegnaConnettore == null) {
            this.msgDiag.logErroreGenerico("Gestore Errore di consegna non definito nella configurazione (is null)", "getDatiConsegna(sa:" + servizioApplicativo + ")");
            ejbUtils.rollbackMessage("Connettore per consegna applicativa non definito.", servizioApplicativo);
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazione(3);
            return esito;
        }
        String idEGovResponse = null;
        if (existsModuloInAttesaRispostaApplicativa) {
            this.msgDiag.mediumDebug("Creazione idEGov risposta...");
            try {
                Imbustamento imbustatore = new Imbustamento();
                idEGovResponse = imbustatore.buildID_eGov(openspcoopstate.getStatoRisposta(), identitaPdD.getCodicePorta(), identitaPdD.getNome());
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "imbustatore.buildID_eGov(idEGovResponse)");
                if (existsModuloInAttesaRispostaApplicativa) {
                    try {
                        ejbUtils.sendRispostaSPCoopErroreProcessamento(idModuloInAttesa, bustaRichiesta, "OPENSPCOOP_ORG_507", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2);
                    }
                    catch (Exception sendError) {
                        ejbUtils.rollbackMessage("Creazione id eGov di risposta (sendRispostaApplicativa) fallita");
                        esito.setStatoInvocazione(3);
                        esito.setEsitoInvocazione(false);
                    }
                } else {
                    ejbUtils.rollbackMessage("Creazione id eGov di risposta fallita");
                    esito.setStatoInvocazione(3);
                    esito.setEsitoInvocazione(false);
                }
                openspcoopstate.releaseResource();
                return esito;
            }
            this.msgDiag.setIdEGovRisposta(idEGovResponse);
            this.msgDiag.addKeyword("@ID_EGOV_RISPOSTA@", idEGovResponse);
        }
        this.msgDiag.mediumDebug("Inizializzo contesto per la gestione (Risposta)...");
        boolean newConnectionForResponse = false;
        if ("OneWay_InvocazioneServizio".equals(scenarioCooperazione)) {
            if (!consegnaContenutiApplicativiMsg.isStateless() && !existsModuloInAttesaRispostaApplicativa) {
                newConnectionForResponse = this.configurazionePdDReader.newConnectionForResponseSPCoop();
            }
        } else if (!"EGOV_IT_ServizioSincrono".equals(bustaRichiesta.getProfiloDiCollaborazione()) && !consegnaContenutiApplicativiMsg.isStateless()) {
            newConnectionForResponse = this.configurazionePdDReader.newConnectionForResponseSPCoop();
        }
        ejbUtils.setReplyOnNewConnection(newConnectionForResponse);
        boolean gestioneIndirizzoTelematico = false;
        if (!consegnaContenutiApplicativiMsg.isStateless()) {
            gestioneIndirizzoTelematico = this.configurazionePdDReader.isUtilizzoIndirizzoTelematico();
        }
        ejbUtils.setUtilizzoIndirizzoTelematico(gestioneIndirizzoTelematico);
        boolean consegnaInOrdine = false;
        boolean bl = gestioneConsegnaInOrdineAbilitata = !"eGov1.1-lineeGuida1.1".equals(profiloGestione) && this.propertiesReader.isGestioneRiscontri(implementazionePdDMittente) && this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDMittente) && this.propertiesReader.isGestioneConsegnaInOrdine(implementazionePdDMittente);
        if (gestioneConsegnaInOrdineAbilitata && "OneWay_InvocazioneServizio".equals(scenarioCooperazione) && bustaRichiesta.getSequenza() != -1L) {
            consegnaInOrdine = true;
        }
        try {
            String tipoConnector;
            block246: {
                SOAPFault fault;
                block245: {
                    if (consegnaInOrdine && (oneWayVersione11 || openspcoopstate instanceof OpenSPCoopStateful)) {
                        this.msgDiag.mediumDebug("Controllo consegna in ordine...");
                        try {
                            ordineConsegna = new ConsegnaInOrdine(openspcoopstate.getStatoRichiesta());
                            if (!ordineConsegna.isConsegnaInOrdine(bustaRichiesta, this.propertiesReader.getGestioneSerializableDB_AttesaAttiva(), this.propertiesReader.getGestioneSerializableDB_CheckInterval())) {
                                this.msgDiag.addKeyword("@SEQUENZA_ATTESA@", ordineConsegna.getSequenzaAttesa() + "");
                                if (ordineConsegna.getSequenzaAttesa() > bustaRichiesta.getSequenza()) {
                                    this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("consegnaInOrdine.messaggioGiaConsegnato"), this.msgDiag.getLivello("consegnaInOrdine.messaggioGiaConsegnato"));
                                    ejbUtils.releaseInboxMessage(true);
                                    esito.setEsitoInvocazione(true);
                                    esito.setStatoInvocazione(3);
                                } else {
                                    this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("consegnaInOrdine.messaggioFuoriOrdine"), this.msgDiag.getLivello("consegnaInOrdine.messaggioFuoriOrdine"));
                                    ejbUtils.rollbackMessage(this.msgDiag.getMessaggio("consegnaInOrdine.messaggioFuoriOrdine"), servizioApplicativo);
                                    esito.setEsitoInvocazione(false);
                                    esito.setStatoInvocazione(3);
                                }
                                openspcoopstate.releaseResource();
                                return esito;
                            }
                        }
                        catch (Exception e) {
                            this.log.error((Object)"Riscontrato errore durante la gestione della sequenza per la consegna in ordine", (Throwable)e);
                            this.msgDiag.logErroreGenerico(e, "GetioneSequenzaInOrdine");
                            ejbUtils.rollbackMessage("Errore verifica consegna in ordine: " + e.getMessage(), servizioApplicativo);
                            openspcoopstate.releaseResource();
                            esito.setEsitoInvocazione(false);
                            esito.setStatoInvocazione(3);
                            return esito;
                        }
                    }
                    this.msgDiag.mediumDebug("Ricostruzione SOAPEnvelope di richiesta/consegna...");
                    Message consegnaAxisMessage = null;
                    try {
                        consegnaAxisMessage = !consegnaPerRiferimento ? msgRequest.getMessage() : msgRequest.buildRichiestaPubblicazioneMessaggio_RepositoryMessaggi(soggettoFruitore, tipoServizio, servizio, azione);
                    }
                    catch (Exception e) {
                        this.msgDiag.logErroreGenerico(e, "msgRequest.getMessage()");
                        if (existsModuloInAttesaRispostaApplicativa) {
                            ejbUtils.sendRispostaSPCoopErroreProcessamento(idModuloInAttesa, bustaRichiesta, "OPENSPCOOP_ORG_509", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                            esito.setStatoInvocazione(2);
                            esito.setEsitoInvocazione(true);
                        } else {
                            ejbUtils.rollbackMessage("Ricostruzione del messaggio Soap da Spedire non riuscita.", servizioApplicativo);
                            esito.setStatoInvocazione(3);
                            esito.setEsitoInvocazione(false);
                        }
                        openspcoopstate.releaseResource();
                        this.log.error((Object)"ConsegnaContenutiApplicativiEsco al punto 3");
                        return esito;
                    }
                    this.msgDiag.mediumDebug("Gestione header di integrazione per la richiesta...");
                    HeaderIntegrazione headerIntegrazione = new HeaderIntegrazione();
                    if (soggettoFruitoreHeaderIntegrazione != null) {
                        headerIntegrazione.getEgov().setTipoMittente(soggettoFruitoreHeaderIntegrazione.getTipo());
                        headerIntegrazione.getEgov().setMittente(soggettoFruitoreHeaderIntegrazione.getNome());
                    } else {
                        headerIntegrazione.getEgov().setTipoMittente(soggettoFruitore.getTipo());
                        headerIntegrazione.getEgov().setMittente(soggettoFruitore.getNome());
                    }
                    if (servizioHeaderIntegrazione != null) {
                        headerIntegrazione.getEgov().setTipoDestinatario(servizioHeaderIntegrazione.getSoggettoErogatore().getTipo());
                        headerIntegrazione.getEgov().setDestinatario(servizioHeaderIntegrazione.getSoggettoErogatore().getNome());
                        headerIntegrazione.getEgov().setTipoServizio(servizioHeaderIntegrazione.getTipoServizio());
                        headerIntegrazione.getEgov().setServizio(servizioHeaderIntegrazione.getServizio());
                        headerIntegrazione.getEgov().setAzione(servizioHeaderIntegrazione.getAzione());
                    } else {
                        headerIntegrazione.getEgov().setTipoDestinatario(idServizio.getSoggettoErogatore().getTipo());
                        headerIntegrazione.getEgov().setDestinatario(idServizio.getSoggettoErogatore().getNome());
                        headerIntegrazione.getEgov().setTipoServizio(idServizio.getTipoServizio());
                        headerIntegrazione.getEgov().setServizio(idServizio.getServizio());
                        headerIntegrazione.getEgov().setAzione(idServizio.getAzione());
                    }
                    headerIntegrazione.getEgov().setID(bustaRichiesta.getID());
                    headerIntegrazione.getEgov().setRiferimentoMessaggio(bustaRichiesta.getRiferimentoMessaggio());
                    headerIntegrazione.getEgov().setIdCollaborazione(bustaRichiesta.getCollaborazione());
                    headerIntegrazione.getEgov().setProfiloDiCollaborazione(bustaRichiesta.getProfiloDiCollaborazione());
                    headerIntegrazione.setIdApplicativo(idCorrelazioneApplicativa);
                    headerIntegrazione.setServizioApplicativo(servizioApplicativoFruitore);
                    Properties propertiesTrasporto = new Properties();
                    Properties propertiesUrlBased = new Properties();
                    if (tipiIntegrazione == null) {
                        tipiIntegrazione = defaultGestoriIntegrazionePA;
                    }
                    for (int i = 0; i < tipiIntegrazione.length; ++i) {
                        try {
                            IGestoreIntegrazionePA gestore;
                            if (!gestoriIntegrazionePA.containsKey(tipiIntegrazione[i])) {
                                ConsegnaContenutiApplicativi.aggiornaListaGestoreIntegrazione(tipiIntegrazione[i], ClassNameProperties.getInstance(), this.propertiesReader);
                            }
                            if ((gestore = gestoriIntegrazionePA.get(tipiIntegrazione[i])) != null) {
                                if (tipiIntegrazione[i].equals("trasporto")) {
                                    gestore.setHeader(headerIntegrazione, consegnaAxisMessage, propertiesTrasporto);
                                    continue;
                                }
                                if (tipiIntegrazione[i].equals("urlBased")) {
                                    gestore.setHeader(headerIntegrazione, consegnaAxisMessage, propertiesUrlBased);
                                    continue;
                                }
                                if (gestore instanceof IGestoreIntegrazionePASoap) {
                                    if (!this.propertiesReader.deleteHeaderIntegrazionePA(false)) {
                                        ((IGestoreIntegrazionePASoap)gestore).updateHeader(headerIntegrazione, consegnaAxisMessage);
                                        continue;
                                    }
                                    gestore.setHeader(headerIntegrazione, consegnaAxisMessage, new Properties());
                                    continue;
                                }
                                gestore.setHeader(headerIntegrazione, consegnaAxisMessage, new Properties());
                                continue;
                            }
                            this.msgDiag.logErroreGenerico("Gestore [" + tipiIntegrazione[i] + "] non inizializzato (is null)", "gestoriIntegrazionePA.get(" + tipiIntegrazione[i] + ")");
                            continue;
                        }
                        catch (Exception e) {
                            this.msgDiag.logErroreGenerico(e, "gestoriIntegrazionePA.aggiornaGet(" + tipiIntegrazione[i] + ")");
                        }
                    }
                    this.msgDiag.mediumDebug("Rilascio connessione al database...");
                    openspcoopstate.releaseResource();
                    this.msgDiag.mediumDebug("Impostazione messaggio del connettore...");
                    Properties spcoopProperties = connettoreMsg.getPropertiesTrasporto();
                    if (spcoopProperties != null) {
                        Enumeration<Object> enumSPC = spcoopProperties.keys();
                        while (enumSPC.hasMoreElements()) {
                            String key = (String)enumSPC.nextElement();
                            String value = (String)spcoopProperties.get(key);
                            if ("mittente".equalsIgnoreCase(value)) {
                                if (soggettoFruitoreHeaderIntegrazione != null) {
                                    propertiesTrasporto.put(key, soggettoFruitoreHeaderIntegrazione.getNome());
                                    continue;
                                }
                                propertiesTrasporto.put(key, soggettoFruitore.getNome());
                                continue;
                            }
                            if ("tipoMittente".equalsIgnoreCase(value)) {
                                if (soggettoFruitoreHeaderIntegrazione != null) {
                                    propertiesTrasporto.put(key, soggettoFruitoreHeaderIntegrazione.getTipo());
                                    continue;
                                }
                                propertiesTrasporto.put(key, soggettoFruitore.getTipo());
                                continue;
                            }
                            if ("destinatario".equalsIgnoreCase(value)) {
                                if (servizioHeaderIntegrazione != null) {
                                    propertiesTrasporto.put(key, servizioHeaderIntegrazione.getSoggettoErogatore().getNome());
                                    continue;
                                }
                                propertiesTrasporto.put(key, idServizio.getSoggettoErogatore().getNome());
                                continue;
                            }
                            if ("tipoDestinatario".equalsIgnoreCase(value)) {
                                if (servizioHeaderIntegrazione != null) {
                                    propertiesTrasporto.put(key, servizioHeaderIntegrazione.getSoggettoErogatore().getTipo());
                                    continue;
                                }
                                propertiesTrasporto.put(key, idServizio.getSoggettoErogatore().getTipo());
                                continue;
                            }
                            if ("servizio".equalsIgnoreCase(value)) {
                                if (servizioHeaderIntegrazione != null) {
                                    propertiesTrasporto.put(key, servizioHeaderIntegrazione.getServizio());
                                    continue;
                                }
                                propertiesTrasporto.put(key, idServizio.getServizio());
                                continue;
                            }
                            if ("tipoServizio".equalsIgnoreCase(value)) {
                                if (servizioHeaderIntegrazione != null) {
                                    propertiesTrasporto.put(key, servizioHeaderIntegrazione.getTipoServizio());
                                    continue;
                                }
                                propertiesTrasporto.put(key, idServizio.getTipoServizio());
                                continue;
                            }
                            if ("azione".equalsIgnoreCase(value)) {
                                if (servizioHeaderIntegrazione != null) {
                                    propertiesTrasporto.put(key, servizioHeaderIntegrazione.getAzione());
                                    continue;
                                }
                                propertiesTrasporto.put(key, idServizio.getAzione());
                                continue;
                            }
                            if (!"idegov".equalsIgnoreCase(value)) continue;
                            propertiesTrasporto.put(key, bustaRichiesta.getID());
                        }
                    }
                    connettoreMsg.setRequestMessage(consegnaAxisMessage);
                    connettoreMsg.setPropertiesTrasporto(propertiesTrasporto);
                    connettoreMsg.setPropertiesUrlBased(propertiesUrlBased);
                    connettoreMsg.setBusta(bustaRichiesta);
                    this.msgDiag.mediumDebug("Inizializzazione connettore per la spedizione...");
                    tipoConnector = connettoreMsg.getTipoConnettore();
                    this.msgDiag.addKeyword("@TIPO_CONNETTORE@", tipoConnector);
                    IConnettore connectorSender = null;
                    Message responseAxisMessage = null;
                    int codiceRitornato = -1;
                    boolean errorConsegna = false;
                    boolean riconsegna = false;
                    Timestamp dataRiconsegna = null;
                    String motivoErroreConsegna = null;
                    boolean invokerNonSupportato = false;
                    fault = null;
                    ClassNameProperties prop = ClassNameProperties.getInstance();
                    String connectorClass = prop.getConnettore(tipoConnector);
                    if (connectorClass == null) {
                        this.msgDiag.logErroreGenerico("Connettore non registrato", "ClassNameProperties.getConnettore(" + tipoConnector + ")");
                        invokerNonSupportato = true;
                    }
                    if (!invokerNonSupportato) {
                        try {
                            Class<?> c = Class.forName(connectorClass);
                            connectorSender = (IConnettore)c.newInstance();
                        }
                        catch (Exception e) {
                            this.msgDiag.logErroreGenerico(e, "IConnettore.newInstance(tipo:" + tipoConnector + " class:" + connectorClass + ")");
                            invokerNonSupportato = true;
                        }
                        if (!invokerNonSupportato && connectorSender == null) {
                            this.msgDiag.logErroreGenerico("ConnectorSender is null", "IConnettore.newInstance(tipo:" + tipoConnector + " class:" + connectorClass + ")");
                            invokerNonSupportato = true;
                        }
                    }
                    String location = "";
                    if (connettoreMsg.getConnectorProperties() != null) {
                        if (connettoreMsg.getConnectorProperties().get("location") != null) {
                            location = connettoreMsg.getConnectorProperties().get("location");
                        }
                        if (!location.equals("")) {
                            location = location.replace("#TipoServizio", bustaRichiesta.getTipoServizio());
                            location = location.replace("#Servizio", bustaRichiesta.getServizio());
                            if (bustaRichiesta.getAzione() != null) {
                                location = location.replace("#Azione", bustaRichiesta.getAzione());
                            }
                            String locationURL = connettoreMsg.getConnectorProperties().get("location");
                            locationURL = locationURL.replace("#TipoServizio", bustaRichiesta.getTipoServizio());
                            locationURL = locationURL.replace("#Servizio", bustaRichiesta.getServizio());
                            if (bustaRichiesta.getAzione() != null) {
                                locationURL = locationURL.replace("#Azione", bustaRichiesta.getAzione());
                            }
                            connettoreMsg.getConnectorProperties().put("location", locationURL);
                        }
                    }
                    this.msgDiag.addKeyword("@LOCATION@", location);
                    if (connettoreMsg.getConnectorProperties() == null) {
                        Hashtable<String, String> propCon = new Hashtable<String, String>();
                        connettoreMsg.setConnectorProperties(propCon);
                    }
                    if (connettoreMsg.getConnectorProperties().get("connection-timeout") == null) {
                        connettoreMsg.getConnectorProperties().put("connection-timeout", "" + this.propertiesReader.getConnectionTimeout_consegnaContenutiApplicativi());
                    }
                    if (connettoreMsg.getConnectorProperties().get("read-connection-timeout") == null) {
                        connettoreMsg.getConnectorProperties().put("read-connection-timeout", "" + this.propertiesReader.getReadConnectionTimeout_consegnaContenutiApplicativi());
                    }
                    if (!invokerNonSupportato) {
                        GestoreErroreConnettore gestoreErrore;
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("consegnaInCorso"), this.msgDiag.getLivello("consegnaInCorso"));
                        ejbUtils.setSpedizioneMsgIngresso(DateManager.getTimestamp());
                        errorConsegna = !connectorSender.send(connettoreMsg);
                        ejbUtils.setRicezioneMsgRisposta(DateManager.getTimestamp());
                        motivoErroreConsegna = connectorSender.getErrore();
                        if (errorConsegna && motivoErroreConsegna == null) {
                            motivoErroreConsegna = "Errore durante la consegna";
                        }
                        boolean bl2 = errorConsegna = !(gestoreErrore = new GestoreErroreConnettore()).verificaConsegna(gestioneConsegnaConnettore, motivoErroreConsegna, connectorSender.getCodiceTrasporto(), connectorSender.getResponse());
                        if (errorConsegna) {
                            motivoErroreConsegna = gestoreErrore.getErrore();
                            riconsegna = gestoreErrore.isRiconsegna();
                            dataRiconsegna = gestoreErrore.getDataRispedizione();
                        }
                        fault = gestoreErrore.getFault();
                        codiceRitornato = connectorSender.getCodiceTrasporto();
                        responseAxisMessage = connectorSender.getResponse();
                        this.msgDiag.addKeyword("@CODICE_CONSEGNA@", codiceRitornato + "");
                        if (motivoErroreConsegna != null) {
                            this.msgDiag.addKeyword("@ERRORE_CONSEGNA@", motivoErroreConsegna);
                        }
                        if (responseAxisMessage != null && this.configurazionePdDReader.dumpMessaggi()) {
                            Dump dumpApplicativo = new Dump(identitaPdD.getCodicePorta(), ID_MODULO, idEGovConsegna);
                            dumpApplicativo.dumpRisposta(responseAxisMessage);
                        }
                    }
                    if (!invokerNonSupportato) {
                        if (errorConsegna) {
                            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("consegnaConErrore"), this.msgDiag.getLivello("consegnaConErrore"));
                        } else {
                            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("consegnaEffettuata"), this.msgDiag.getLivello("consegnaEffettuata"));
                        }
                    }
                    this.msgDiag.mediumDebug("Richiesta risorsa per la gestione della risposta...");
                    try {
                        boolean gestioneAsincroniStateless = ("EGOV_IT_ServizioAsincronoAsimmetrico".equals(profiloCollaborazione) || "EGOV_IT_ServizioAsincronoSimmetrico".equals(profiloCollaborazione)) && portaStateless;
                        boolean oldGestioneConnessione = false;
                        if (gestioneAsincroniStateless) {
                            oldGestioneConnessione = ((OpenSPCoopStateless)openspcoopstate).isUseConnection();
                            ((OpenSPCoopStateless)openspcoopstate).setUseConnection(true);
                        }
                        openspcoopstate.updateResource();
                        if (gestioneAsincroniStateless) {
                            ((OpenSPCoopStateless)openspcoopstate).setUseConnection(oldGestioneConnessione);
                        }
                        ejbUtils.updateOpenSPCoopState(openspcoopstate);
                        msgRequest.updateOpenSPCoopState(openspcoopstate);
                    }
                    catch (Exception e) {
                        this.msgDiag.logErroreGenerico(e, "openspcoopstate.updateResource()");
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(false);
                        esito.setStatoInvocazione(3);
                        return esito;
                    }
                    this.msgDiag.mediumDebug("Gestione errore consegna della risposta...");
                    if (invokerNonSupportato) {
                        if (existsModuloInAttesaRispostaApplicativa) {
                            ejbUtils.sendRispostaSPCoopErroreProcessamento(idModuloInAttesa, bustaRichiesta, "OPENSPCOOP_ORG_515", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                            esito.setEsitoInvocazione(true);
                            esito.setStatoInvocazione(2);
                        } else {
                            ejbUtils.rollbackMessage("Connettore non supportato [tipo:" + tipoConnector + " class:" + connectorClass + "].", servizioApplicativo);
                            esito.setEsitoInvocazione(false);
                            esito.setStatoInvocazione(3);
                        }
                        openspcoopstate.releaseResource();
                        return esito;
                    }
                    if (errorConsegna) {
                        if (existsModuloInAttesaRispostaApplicativa) {
                            if (responseAxisMessage == null) {
                                ejbUtils.sendRispostaSPCoopErroreProcessamento(idModuloInAttesa, bustaRichiesta, "OPENSPCOOP_ORG_516", "Servizio Applicativo non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2);
                                return esito;
                            }
                        } else {
                            if (fault != null) {
                                this.msgDiag.addKeyword("@SOAP_FAULT@", SoapUtils.toString((SOAPFault)fault));
                                this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("ricezioneSoapFault"), this.msgDiag.getLivello("ricezioneSoapFault"));
                            }
                            if (riconsegna) {
                                ejbUtils.rollbackMessage("Consegna [" + tipoConnector + "] con errore: " + motivoErroreConsegna, dataRiconsegna, servizioApplicativo);
                                esito.setEsitoInvocazione(false);
                                esito.setStatoInvocazione(3);
                            } else {
                                ejbUtils.releaseInboxMessage(true);
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(3);
                            }
                            openspcoopstate.releaseResource();
                            this.log.error((Object)"ConsegnaContenutiApplicativiEsco al punto 5");
                            return esito;
                        }
                    }
                    if (!existsModuloInAttesaRispostaApplicativa) break block245;
                    if (richiestaApplicativa != null && "OneWay_InvocazioneServizio".equals(richiestaApplicativa.getScenario())) {
                        boolean returnSPCoopReply = false;
                        Busta bustaHTTPReply = null;
                        if (!"eGov1.1-lineeGuida1.1".equals(profiloGestione) && this.propertiesReader.isGestioneRiscontri(implementazionePdDMittente)) {
                            this.msgDiag.mediumDebug("Gestione eventuali riscontri da inviare...");
                            boolean senza_piggy_backing = true;
                            if ("EGOV_IT_MessaggioSingoloOneWay".equals(bustaRichiesta.getProfiloDiCollaborazione()) && senza_piggy_backing && bustaRichiesta.getConfermaRicezione()) {
                                bustaHTTPReply = bustaRichiesta.invertiBusta(this.propertiesReader.getTipoTempoEGov(implementazionePdDMittente));
                                Riscontro r = new Riscontro();
                                r.setID(bustaRichiesta.getID());
                                r.setOraRegistrazione(bustaHTTPReply.getOraRegistrazione());
                                r.setTipoOraRegistrazione(this.propertiesReader.getTipoTempoEGov(implementazionePdDMittente));
                                bustaHTTPReply.addRiscontro(r);
                                bustaHTTPReply.setTipoServizioRichiedenteBustaDiServizio(bustaRichiesta.getTipoServizio());
                                bustaHTTPReply.setServizioRichiedenteBustaDiServizio(bustaRichiesta.getServizio());
                                bustaHTTPReply.setAzioneRichiedenteBustaDiServizio(bustaRichiesta.getAzione());
                                returnSPCoopReply = true;
                            }
                        }
                        if (!returnSPCoopReply) {
                            if (fault != null) {
                                this.msgDiag.mediumDebug("Invio messaggio di fault a Ricezione/Consegna ContenutiApplicativi...");
                                msgResponse = ejbUtils.sendSOAPFault(richiestaApplicativa.getIdModuloInAttesa(), responseAxisMessage);
                            } else {
                                this.msgDiag.mediumDebug("Invio messaggio di sblocco a RicezioneBusteEGov...");
                                msgResponse = ejbUtils.sendSbloccoRicezioneBusteEGov(richiestaApplicativa.getIdModuloInAttesa());
                            }
                        } else if (fault != null) {
                            this.msgDiag.mediumDebug("Invio messaggio di fault a Ricezione/Consegna ContenutiApplicativi...");
                            msgResponse = ejbUtils.sendSOAPFault(richiestaApplicativa.getIdModuloInAttesa(), responseAxisMessage);
                        } else {
                            this.msgDiag.mediumDebug("Invio messaggio a Ricezione/Consegna ContenutiApplicativi...");
                            msgResponse = ejbUtils.buildAndSendRispostaSPCoop(richiestaApplicativa.getIdModuloInAttesa(), bustaHTTPReply, SoapUtils.build_Soap_Empty(), profiloGestione, idCorrelazioneApplicativa, servizioApplicativoFruitore);
                        }
                        msgResponse.aggiornaInfoAttraversamentoPdDMessaggioRisposta(msgRequest.getOraRegistrazioneMessaggio(), ejbUtils.getSpedizioneMsgIngresso(), ejbUtils.getRicezioneMsgRisposta());
                        break block246;
                    } else {
                        block244: {
                            if (rispostaPerRiferimento && !errorConsegna) {
                                this.msgDiag.mediumDebug("Gestione risposta per riferimento...");
                                boolean rilasciaRisorsa = false;
                                if (openspcoopstate instanceof OpenSPCoopStateless) {
                                    OpenSPCoopStateless state = (OpenSPCoopStateless)openspcoopstate;
                                    if (state.resourceReleased()) {
                                        state.setUseConnection(true);
                                        state.updateResource();
                                        rilasciaRisorsa = true;
                                    } else {
                                        state.setUseConnection(true);
                                    }
                                }
                                try {
                                    Node prelevaMessaggioResponse = responseAxisMessage.getSOAPBody().getFirstChild();
                                    if (prelevaMessaggioResponse == null) {
                                        throw new Exception("Identificativo non presente [prelevaMessaggioResponse]");
                                    }
                                    Node prelevaMessaggioReturn = prelevaMessaggioResponse.getFirstChild();
                                    if (prelevaMessaggioReturn == null) {
                                        throw new Exception("Identificativo non presente [prelevaMessaggioReturn]");
                                    }
                                    Node idMessaggioPresenteNelRepositoryNode = prelevaMessaggioReturn.getFirstChild();
                                    if (idMessaggioPresenteNelRepositoryNode == null) {
                                        throw new Exception("Identificativo non presente [idMessaggioPresenteNelRepositoryNode]");
                                    }
                                    byte[] idMessaggioPresenteNelRepositoryByte = Base64.decode((String)idMessaggioPresenteNelRepositoryNode.getNodeValue());
                                    String idMessaggioPresenteNelRepository = new String(idMessaggioPresenteNelRepositoryByte);
                                    if (idMessaggioPresenteNelRepository == null) {
                                        throw new Exception("Identificativo non presente");
                                    }
                                    GestoreMessaggi gestoreMsgFromRepository = new GestoreMessaggi(openspcoopstate, false, idMessaggioPresenteNelRepository, "INBOX", this.msgDiag);
                                    Message msgFromRepository = gestoreMsgFromRepository.getMessage();
                                    if (idMessaggioPresenteNelRepository == null) {
                                        throw new Exception("Messaggio non presente nel repository");
                                    }
                                    byte[] bodyApplicativoPrecedentementePubblicato = SoapUtils.sbustamentoMessaggio((Message)msgFromRepository);
                                    responseAxisMessage = gestoreMsgFromRepository.buildRispostaPrelevamentoMessaggio_RepositoryMessaggi(bodyApplicativoPrecedentementePubblicato);
                                }
                                catch (Exception e) {
                                    this.msgDiag.addKeyword("@ERRORE_CONSEGNA@", "risposta per riferimento non costruita, " + e.getMessage());
                                    this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("consegnaConErrore"), this.msgDiag.getLivello("consegnaConErrore"));
                                    ejbUtils.sendRispostaSPCoopErroreProcessamento(idModuloInAttesa, bustaRichiesta, "OPENSPCOOP_ORG_511", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                    esito.setEsitoInvocazione(true);
                                    esito.setStatoInvocazione(2);
                                    openspcoopstate.releaseResource();
                                    EsitoLib prelevaMessaggioReturn = esito;
                                    return prelevaMessaggioReturn;
                                }
                                finally {
                                    if (openspcoopstate instanceof OpenSPCoopStateless) {
                                        OpenSPCoopStateless state = (OpenSPCoopStateless)openspcoopstate;
                                        if (rilasciaRisorsa) {
                                            state.releaseResource();
                                        }
                                        state.setUseConnection(false);
                                    }
                                }
                            }
                            this.msgDiag.mediumDebug("Gestione risposta...");
                            if (responseAxisMessage == null) {
                                this.msgDiag.addKeyword("@ERRORE_CONSEGNA@", "risposta applicativa attesa ma non ricevuta");
                                this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("consegnaConErrore"), this.msgDiag.getLivello("consegnaConErrore"));
                                ejbUtils.sendRispostaSPCoopErroreProcessamento(idModuloInAttesa, bustaRichiesta, "OPENSPCOOP_ORG_517", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2);
                                return esito;
                            }
                            if ("abilitato".equals(validazioneContenutoApplicativoApplicativo.getStato()) || "warningOnly".equals(validazioneContenutoApplicativoApplicativo.getStato())) {
                                Object idSValidazioneXSD;
                                ByteArrayInputStream binXSD = null;
                                try {
                                    if (responseAxisMessage.getSOAPBody() == null || responseAxisMessage.getSOAPBody().hasFault()) break block244;
                                    this.msgDiag.mediumDebug("Validatore contenuti applicativi della risposta...");
                                    boolean readWSDL = "wsdl".equals(validazioneContenutoApplicativoApplicativo.getTipo());
                                    idSValidazioneXSD = idServizio;
                                    if (servizioHeaderIntegrazione != null) {
                                        idSValidazioneXSD = servizioHeaderIntegrazione;
                                    }
                                    ValidatoreMessaggiApplicativi validatoreMessaggiApplicativi = new ValidatoreMessaggiApplicativi(this.registroServiziReader, (IDServizio)idSValidazioneXSD, responseAxisMessage.getSOAPBody(), readWSDL);
                                    boolean checkStyle = false;
                                    if (idSValidazioneXSD.getAzione() != null && (readWSDL || "openspcoop".equals(validazioneContenutoApplicativoApplicativo.getTipo()))) {
                                        checkStyle = true;
                                    }
                                    this.msgDiag.mediumDebug("Validatore contenuti applicativi (raccolta url XSD Definitorio)...");
                                    String urlXSD = validatoreMessaggiApplicativi.getURLWsdlDefinitorio();
                                    byte[] bytesXSD = validatoreMessaggiApplicativi.getBytesWsdlDefinitorio();
                                    if (urlXSD == null) {
                                        if (bytesXSD == null) throw new Exception("Wsdl definitorio (xsd) non definito nell'accordo di servizio");
                                        if (bytesXSD.length <= 0) {
                                            throw new Exception("Wsdl definitorio (xsd) non definito nell'accordo di servizio");
                                        }
                                    }
                                    if (urlXSD != null) {
                                        this.msgDiag.mediumDebug("Validazione xsd (url:" + urlXSD + ") della risposta (validazione)...");
                                    } else {
                                        this.msgDiag.mediumDebug("Validazione xsd della risposta ...");
                                    }
                                    validatoreMessaggiApplicativi.validateWithWsdlDefinitorio(false, checkStyle);
                                    if (idSValidazioneXSD.getAzione() != null && ("wsdl".equals(validazioneContenutoApplicativoApplicativo.getTipo()) || "openspcoop".equals(validazioneContenutoApplicativoApplicativo.getTipo()))) {
                                        this.msgDiag.mediumDebug("Validazione wsdl della risposta ...");
                                        validatoreMessaggiApplicativi.validateWithWsdlLogicoImplementativo(false, null);
                                    }
                                }
                                catch (ValidatoreMessaggiApplicativiException ex) {
                                    this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", ex.getMessage());
                                    this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("validazioneContenutiApplicativiNonRiuscita"), this.msgDiag.getLivello("validazioneContenutiApplicativiNonRiuscita"));
                                    if (!"warningOnly".equals(validazioneContenutoApplicativoApplicativo.getStato())) {
                                        ejbUtils.sendRispostaSPCoopErroreProcessamento(idModuloInAttesa, bustaRichiesta, ex.getCodiceErrore(), ex.getMsgErrore(), idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                        openspcoopstate.releaseResource();
                                        esito.setEsitoInvocazione(true);
                                        esito.setStatoInvocazione(2);
                                        idSValidazioneXSD = esito;
                                        return idSValidazioneXSD;
                                    }
                                }
                                catch (Exception ex) {
                                    this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", ex.getMessage());
                                    this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("validazioneContenutiApplicativiNonRiuscita"), this.msgDiag.getLivello("validazioneContenutiApplicativiNonRiuscita"));
                                    this.log.error((Object)"Riscontrato errore durante la validazione xsd della risposta applicativa", (Throwable)ex);
                                    if (!"warningOnly".equals(validazioneContenutoApplicativoApplicativo.getStato())) {
                                        ejbUtils.sendRispostaSPCoopErroreProcessamento(idModuloInAttesa, bustaRichiesta, "OPENSPCOOP_ORG_531", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                        openspcoopstate.releaseResource();
                                        esito.setEsitoInvocazione(true);
                                        esito.setStatoInvocazione(2);
                                        idSValidazioneXSD = esito;
                                        return idSValidazioneXSD;
                                    }
                                }
                                finally {
                                    if (binXSD != null) {
                                        try {
                                            binXSD.close();
                                        }
                                        catch (Exception e) {}
                                    }
                                }
                            }
                        }
                        if (richiestaApplicativa != null) {
                            if (scartaBody) {
                                try {
                                    if (responseAxisMessage.countAttachments() <= 0) {
                                        throw new Exception("La funzionalita' e' permessa solo per messaggi SOAP With Attachments");
                                    }
                                }
                                catch (Exception e) {
                                    this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                                    this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("funzionalitaScartaBodyNonRiuscita"), this.msgDiag.getLivello("funzionalitaScartaBodyNonRiuscita"));
                                    ejbUtils.sendRispostaSPCoopErroreProcessamento(idModuloInAttesa, bustaRichiesta, "OPENSPCOOP_ORG_425", "Funzionalita' 'scarta body' non e' riuscito ad utilizzare il messaggio inviato dal client: " + e.getMessage(), idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                    openspcoopstate.releaseResource();
                                    esito.setEsitoInvocazione(true);
                                    esito.setStatoInvocazione(2);
                                    return esito;
                                }
                            }
                            if (allegaBody) {
                                try {
                                    if (responseAxisMessage.countAttachments() > 0) {
                                        throw new Exception("La funzionalita' non e' permessa per messaggi con attachments");
                                    }
                                    byte[] body = SoapUtils.sbustamentoSOAPEnvelope((SOAPEnvelope)responseAxisMessage.getSOAPEnvelope());
                                    org.apache.axis.attachments.AttachmentPart ap = (org.apache.axis.attachments.AttachmentPart)responseAxisMessage.createAttachmentPart();
                                    ByteArrayInputStream isContent = new ByteArrayInputStream(body);
                                    ap.setContent((Object)isContent, "text/xml");
                                    responseAxisMessage.addAttachmentPart((AttachmentPart)ap);
                                    responseAxisMessage.getSOAPBody().removeContents();
                                }
                                catch (Exception e) {
                                    this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                                    this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("funzionalitaAllegaBodyNonRiuscita"), this.msgDiag.getLivello("funzionalitaAllegaBodyNonRiuscita"));
                                    ejbUtils.sendRispostaSPCoopErroreProcessamento(idModuloInAttesa, bustaRichiesta, "OPENSPCOOP_ORG_424", "Funzionalita' 'allega body' non e' riuscito ad utilizzare il messaggio inviato dal client: " + e.getMessage(), idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                    openspcoopstate.releaseResource();
                                    esito.setEsitoInvocazione(true);
                                    esito.setStatoInvocazione(2);
                                    return esito;
                                }
                            }
                        }
                        this.msgDiag.mediumDebug("Registrazione messaggio di risposta nel RepositoryMessaggi...");
                        try {
                            msgResponse = new GestoreMessaggi(openspcoopstate, false, idEGovResponse, "OUTBOX", this.msgDiag);
                            msgResponse.registraMessaggio(responseAxisMessage);
                            msgResponse.aggiornaRiferimentoMessaggio(idEGovConsegna);
                            msgResponse.aggiornaProprietarioMessaggio("ImbustamentoRisposte");
                            if (!oneWayVersione11) {
                                msgResponse.aggiornaInfoAttraversamentoPdDMessaggioRisposta(msgRequest.getOraRegistrazioneMessaggio(), ejbUtils.getSpedizioneMsgIngresso(), ejbUtils.getRicezioneMsgRisposta());
                            }
                        }
                        catch (Exception e) {
                            this.msgDiag.addKeyword("@ERRORE_CONSEGNA@", "salvataggio risposta, " + e.getMessage());
                            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("consegnaConErrore"), this.msgDiag.getLivello("consegnaConErrore"));
                            msgResponse.deleteMessageFromFileSystem();
                            ejbUtils.sendRispostaSPCoopErroreProcessamento(idModuloInAttesa, bustaRichiesta, "OPENSPCOOP_ORG_510", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                            openspcoopstate.releaseResource();
                            esito.setEsitoInvocazione(true);
                            esito.setStatoInvocazione(2);
                            return esito;
                        }
                        ImbustamentoRisposteMessage imbustamentoRisposteMSG = new ImbustamentoRisposteMessage();
                        imbustamentoRisposteMSG.setIDEGovResponse(idEGovResponse);
                        imbustamentoRisposteMSG.setRichiestaApplicativa(richiestaApplicativa);
                        imbustamentoRisposteMSG.setRichiestaDelegata(richiestaDelegata);
                        imbustamentoRisposteMSG.setBusta(bustaRichiesta);
                        imbustamentoRisposteMSG.setSpedizioneMsgIngresso(ejbUtils.getSpedizioneMsgIngresso());
                        imbustamentoRisposteMSG.setRicezioneMsgRisposta(ejbUtils.getRicezioneMsgRisposta());
                        imbustamentoRisposteMSG.setOneWayVersione11(oneWayVersione11);
                        imbustamentoRisposteMSG.setStateless(consegnaContenutiApplicativiMsg.isStateless());
                        imbustamentoRisposteMSG.setImplementazionePdDSoggettoMittente(consegnaContenutiApplicativiMsg.getImplementazionePdDSoggettoMittente());
                        imbustamentoRisposteMSG.setImplementazionePdDSoggettoDestinatario(consegnaContenutiApplicativiMsg.getImplementazionePdDSoggettoDestinatario());
                        this.msgDiag.mediumDebug("Invio messaggio al modulo di ImbustamentoRisposte...");
                        if (openspcoopstate instanceof OpenSPCoopStateful) {
                            try {
                                GenericLib.nodeSender.send(imbustamentoRisposteMSG, "ImbustamentoRisposte", this.msgDiag, identitaPdD.getCodicePorta(), ID_MODULO, idEGovConsegna, msgResponse);
                            }
                            catch (Exception e) {
                                this.msgDiag.logErroreGenerico(e, "GenericLib.nodeSender.send(ImbustamentoRisposte)");
                                msgResponse.deleteMessageFromFileSystem();
                                ejbUtils.sendRispostaSPCoopErroreProcessamento(idModuloInAttesa, bustaRichiesta, "OPENSPCOOP_ORG_512", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2);
                                return esito;
                            }
                        } else {
                            ((OpenSPCoopStateless)openspcoopstate).setMessageLib(imbustamentoRisposteMSG);
                        }
                    }
                    break block246;
                }
                this.msgDiag.mediumDebug("Registrazione eventuale fault...");
                if (fault != null) {
                    this.msgDiag.addKeyword("@SOAP_FAULT@", SoapUtils.toString((SOAPFault)fault));
                    this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("ricezioneSoapFault"), this.msgDiag.getLivello("ricezioneSoapFault"));
                }
            }
            if (ordineConsegna != null && (oneWayVersione11 || openspcoopstate instanceof OpenSPCoopStateful)) {
                this.msgDiag.mediumDebug("Aggiornamento numero sequenza per consegna in ordine...");
                ordineConsegna.setNextSequenza_daRicevere(bustaRichiesta);
            }
            this.msgDiag.lowDebug("Consegna " + tipoConnector + " effettuata con successo.");
            this.msgDiag.mediumDebug("Commit delle operazioni per la gestione della richiesta...");
            openspcoopstate.commit();
            if (msgRequest != null) {
                msgRequest.addMessaggiIntoCache_readFromTable(ID_MODULO, "richiesta");
            }
            if (msgResponse != null) {
                msgResponse.addMessaggiIntoCache_readFromTable(ID_MODULO, "risposta");
            }
            if (msgRequest != null) {
                msgRequest.addProprietariIntoCache_readFromTable(ID_MODULO, "richiesta", null, false);
            }
            if (msgResponse != null) {
                msgResponse.addProprietariIntoCache_readFromTable(ID_MODULO, "risposta", idEGovConsegna, false);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"ErroreGenerale", (Throwable)e);
            this.msgDiag.logErroreGenerico(e, "Generale");
            if (msgResponse != null) {
                msgResponse.deleteMessageFromFileSystem();
            }
            if (existsModuloInAttesaRispostaApplicativa) {
                try {
                    ejbUtils.sendRispostaSPCoopErroreProcessamento(idModuloInAttesa, bustaRichiesta, "OPENSPCOOP_ORG_500", "Sistema non disponibile", idCorrelazioneApplicativa, servizioApplicativoFruitore);
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2);
                }
                catch (Exception er) {
                    this.msgDiag.logErroreGenerico(er, "ejbUtils.sendErroreGenerale(profiloConRisposta)");
                    ejbUtils.rollbackMessage("Spedizione Errore al Mittente durante una richiesta con gestione della risposta non riuscita", servizioApplicativo);
                    esito.setEsitoInvocazione(false);
                    esito.setStatoInvocazione(3);
                }
            } else {
                ejbUtils.rollbackMessage("ErroreGenerale:" + e.getMessage(), servizioApplicativo);
                esito.setEsitoInvocazione(false);
                esito.setStatoInvocazione(3);
            }
            openspcoopstate.releaseResource();
            return esito;
        }
        if (!consegnaPerRiferimento) {
            try {
                GestoreMessaggi gestoreEliminazioneDestinatario = new GestoreMessaggi(openspcoopstate, true, idEGovConsegna, "INBOX", this.msgDiag);
                gestoreEliminazioneDestinatario.setOneWayVersione11(oneWayVersione11);
                gestoreEliminazioneDestinatario.eliminaDestinatarioMessaggio(servizioApplicativo, null);
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "gestoreEliminazioneDestinatario.eliminaDestinatarioMessaggio(" + servizioApplicativo + ",null)");
            }
        }
        this.msgDiag.mediumDebug("ConsegnaContenutiApplicativi Rilascio le risorse..");
        openspcoopstate.releaseResource();
        this.msgDiag.mediumDebug("Lavoro Terminato.");
        esito.setEsitoInvocazione(true);
        esito.setStatoInvocazione(1);
        return esito;
    }
}

