/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.logger;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import javax.sql.DataSource;
import org.openspcoop.dao.commons.DriverException;
import org.openspcoop.dao.config.OpenspcoopAppender;
import org.openspcoop.egov.Busta;
import org.openspcoop.egov.Eccezione;
import org.openspcoop.egov.Riscontro;
import org.openspcoop.egov.Trasmissione;
import org.openspcoop.pdd.logger.ITracciamentoOpenSPCoopAppender;
import org.openspcoop.pdd.logger.TracciamentoException;
import org.openspcoop.utils.GestoreJNDI;
import org.openspcoop.utils.Utilities;

public class TracciamentoOpenSPCoopAppenderDB
implements ITracciamentoOpenSPCoopAppender {
    private DataSource ds = null;
    private String datasource = null;
    private String tipoDatabase = null;
    private boolean singleConnection = false;
    private boolean openspcoopConnection = false;
    private static final String TRACCIAMENTO = "tracce";
    private static final String TRACCIAMENTO_LISTA_ECCEZIONI = "tracce_eccezioni";
    private static final String TRACCIAMENTO_LISTA_RISCONTRI = "tracce_riscontri";
    private static final String TRACCIAMENTO_LISTA_TRASMISSIONI = "tracce_trasmissioni";
    private static Connection connection = null;
    private static String datasourceConnection = null;

    private synchronized void initConnection(DataSource dsA, String dataSourceS) throws Exception {
        if (connection == null) {
            try {
                datasourceConnection = dataSourceS;
                connection = dsA.getConnection();
            }
            catch (Exception e) {
                throw new Exception("Inizializzazione single connection non riuscita", e);
            }
        }
    }

    public void initializeAppender(OpenspcoopAppender appenderProperties) throws TracciamentoException {
        try {
            String openspcoopConnectionString;
            Properties properties = new Properties();
            Properties ctx = new Properties();
            if (appenderProperties.sizePropertyList() > 0) {
                for (int i = 0; i < appenderProperties.sizePropertyList(); ++i) {
                    properties.put(appenderProperties.getProperty(i).getNome(), appenderProperties.getProperty(i).getValore());
                }
            } else {
                throw new TracciamentoException("Proprieta' 'datasource' non definita");
            }
            ctx = Utilities.readProperties((String)"context-", (Properties)properties);
            this.datasource = properties.getProperty("datasource");
            this.tipoDatabase = properties.getProperty("tipoDatabase");
            GestoreJNDI jndi = new GestoreJNDI(ctx);
            String singleConnectionString = properties.getProperty("singleConnection");
            if (singleConnectionString != null && "true".equals(singleConnectionString = singleConnectionString.trim())) {
                this.singleConnection = true;
            }
            if ((openspcoopConnectionString = properties.getProperty("usePdDConnection")) != null && "true".equals(openspcoopConnectionString = openspcoopConnectionString.trim())) {
                this.openspcoopConnection = true;
            }
            if (this.singleConnection) {
                if (connection == null) {
                    DataSource ds = (DataSource)jndi.lookup(this.datasource);
                    this.initConnection(ds, this.datasource);
                }
            } else {
                this.ds = (DataSource)jndi.lookup(this.datasource);
            }
        }
        catch (Exception e) {
            throw new TracciamentoException("Errore durante l'inizializzazione dell'appender: " + e.getMessage(), e);
        }
    }

    /*
     * Loose catch block
     */
    public void log(Connection conOpenSPCoopPdD, Date gdo, String idPorta, String tipoMessaggio, Busta busta, String location, String idCorrelazioneApplicativa, String servizioApplicativo) throws TracciamentoException {
        block52: {
            int i;
            if (busta == null) {
                throw new TracciamentoException("Errore durante il tracciamento di un busta: busta is null");
            }
            Statement stmt = null;
            ResultSet rs = null;
            Connection con = null;
            boolean releaseConnectionPool = false;
            if (!this.singleConnection) {
                if (this.openspcoopConnection && conOpenSPCoopPdD != null) {
                    con = conOpenSPCoopPdD;
                } else {
                    con = this.ds.getConnection();
                    if (con == null) {
                        throw new Exception("Connessione non fornita dal datasource [" + this.datasource + "]");
                    }
                    releaseConnectionPool = true;
                }
            } else {
                con = connection;
                if (con == null) {
                    throw new Exception("Connessione non fornita dal datasource [" + datasourceConnection + "]");
                }
            }
            int idtraccia = 0;
            String generazioneID_nomeColonnaSQL = "";
            String generazioneID_valoreColonnaSQL = "";
            if ("postgresql".equals(this.tipoDatabase) || "oracle".equals(this.tipoDatabase)) {
                String sequenceQuery = null;
                sequenceQuery = "postgresql".equals(this.tipoDatabase) ? "select nextval('tracce_id_seq'::text) as nextval" : "select tracce_sequence.nextval as nextval from dual";
                stmt = con.prepareStatement(sequenceQuery);
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    throw new Exception("ID autoincrementale non ottenuto via Sequence");
                }
                idtraccia = rs.getInt("nextval");
                if (idtraccia < 0) {
                    throw new Exception("ID autoincrementale non ottenuto: is null?");
                }
                rs.close();
                stmt.close();
                generazioneID_nomeColonnaSQL = ",id";
                generazioneID_valoreColonnaSQL = ",?";
            }
            stmt = null;
            String updateString = "INSERT INTO tracce (gdo, gdo_int,idporta, tipo_messaggio, mittente, tipo_mittente, indtelematico_mitt, destinatario, tipo_destinatario,  indtelematico_dest, profilo_collaborazione, servizio_correlato,tipo_servizio_correlato , collaborazione,  servizio, tipo_servizio, azione, id_egov, ora_registrazione, tipo_ora_reg, rif_messaggio, scadenza,  inoltro, conferma_ricezione, sequenza,location,correlazione_applicativa,sa_fruitore" + generazioneID_nomeColonnaSQL + ") VALUES (?, ?, ? , ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? , ? , ? , ? , ? " + generazioneID_valoreColonnaSQL + ")";
            if ("postgresql".equals(this.tipoDatabase) || "oracle".equals(this.tipoDatabase)) {
                stmt = con.prepareStatement(updateString);
            } else if ("default".equals(this.tipoDatabase) || "mysql".equals(this.tipoDatabase)) {
                stmt = con.prepareStatement(updateString, 1);
            } else {
                throw new Exception("Tipo di database non definito/gestito: " + this.tipoDatabase);
            }
            Timestamp gdoT = new Timestamp(gdo.getTime());
            stmt.setTimestamp(1, gdoT);
            stmt.setLong(2, gdoT.getTime());
            Utilities.setSQLStringValue((PreparedStatement)stmt, (int)3, (String)idPorta);
            Utilities.setSQLStringValue((PreparedStatement)stmt, (int)4, (String)tipoMessaggio);
            Utilities.setSQLStringValue((PreparedStatement)stmt, (int)5, (String)busta.getMittente());
            Utilities.setSQLStringValue((PreparedStatement)stmt, (int)6, (String)busta.getTipoMittente());
            Utilities.setSQLStringValue((PreparedStatement)stmt, (int)7, (String)busta.getIndirizzoTelematicoMittente());
            Utilities.setSQLStringValue((PreparedStatement)stmt, (int)8, (String)busta.getDestinatario());
            Utilities.setSQLStringValue((PreparedStatement)stmt, (int)9, (String)busta.getTipoDestinatario());
            Utilities.setSQLStringValue((PreparedStatement)stmt, (int)10, (String)busta.getIndirizzoTelematicoDestinatario());
            Utilities.setSQLStringValue((PreparedStatement)stmt, (int)11, (String)busta.getProfiloDiCollaborazione());
            Utilities.setSQLStringValue((PreparedStatement)stmt, (int)12, (String)busta.getServizioCorrelato());
            Utilities.setSQLStringValue((PreparedStatement)stmt, (int)13, (String)busta.getTipoServizioCorrelato());
            Utilities.setSQLStringValue((PreparedStatement)stmt, (int)14, (String)busta.getCollaborazione());
            Utilities.setSQLStringValue((PreparedStatement)stmt, (int)15, (String)busta.getServizio());
            Utilities.setSQLStringValue((PreparedStatement)stmt, (int)16, (String)busta.getTipoServizio());
            Utilities.setSQLStringValue((PreparedStatement)stmt, (int)17, (String)busta.getAzione());
            Utilities.setSQLStringValue((PreparedStatement)stmt, (int)18, (String)busta.getID());
            if (busta.getOraRegistrazione() != null) {
                stmt.setTimestamp(19, new Timestamp(busta.getOraRegistrazione().getTime()));
            } else {
                stmt.setTimestamp(19, null);
            }
            Utilities.setSQLStringValue((PreparedStatement)stmt, (int)20, (String)busta.getTipoOraRegistrazione());
            Utilities.setSQLStringValue((PreparedStatement)stmt, (int)21, (String)busta.getRiferimentoMessaggio());
            if (busta.getScadenza() == null) {
                stmt.setTimestamp(22, null);
            } else {
                stmt.setTimestamp(22, new Timestamp(busta.getScadenza().getTime()));
            }
            Utilities.setSQLStringValue((PreparedStatement)stmt, (int)23, (String)busta.getInoltro());
            if (busta.getConfermaRicezione()) {
                stmt.setInt(24, 1);
            } else {
                stmt.setInt(24, 0);
            }
            stmt.setLong(25, busta.getSequenza());
            Utilities.setSQLStringValue((PreparedStatement)stmt, (int)26, (String)location);
            Utilities.setSQLStringValue((PreparedStatement)stmt, (int)27, (String)idCorrelazioneApplicativa);
            Utilities.setSQLStringValue((PreparedStatement)stmt, (int)28, (String)servizioApplicativo);
            if ("postgresql".equals(this.tipoDatabase) || "oracle".equals(this.tipoDatabase)) {
                stmt.setInt(29, idtraccia);
            }
            stmt.executeUpdate();
            if ("default".equals(this.tipoDatabase) || "mysql".equals(this.tipoDatabase)) {
                rs = stmt.getGeneratedKeys();
                if (!rs.next()) {
                    throw new Exception("ID autoincrementale non ottenuto via JDBC3.0");
                }
                idtraccia = rs.getInt(1);
                if (idtraccia < 0) {
                    throw new Exception("ID autoincrementale non ottenuto: is null?");
                }
                rs.close();
            }
            stmt.close();
            String sqlString = null;
            for (i = 0; i < busta.sizeListaRiscontri(); ++i) {
                Riscontro riscontro = busta.getRiscontro(i);
                sqlString = "INSERT INTO tracce_riscontri (idtraccia, riscontro, ora_registrazione, tipo_ora_reg) VALUES (?, ?, ?, ?)";
                stmt = con.prepareStatement(sqlString);
                stmt.setLong(1, idtraccia);
                Utilities.setSQLStringValue((PreparedStatement)stmt, (int)2, (String)riscontro.getID());
                if (riscontro.getOraRegistrazione() != null) {
                    stmt.setTimestamp(3, new Timestamp(riscontro.getOraRegistrazione().getTime()));
                } else {
                    stmt.setTimestamp(3, null);
                }
                Utilities.setSQLStringValue((PreparedStatement)stmt, (int)4, (String)riscontro.getTipoOraRegistrazione());
                stmt.executeUpdate();
                stmt.close();
            }
            for (i = 0; i < busta.sizeListaTrasmissioni(); ++i) {
                Trasmissione trasmissione = busta.getTrasmissione(i);
                sqlString = "INSERT INTO tracce_trasmissioni (idtraccia, origine,tipo_origine ,indtelematico_orig , destinazione, tipo_destinazione, indtel_destinazione, ora_registrazione, tipo_ora_registrazione) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
                stmt = con.prepareStatement(sqlString);
                stmt.setLong(1, idtraccia);
                Utilities.setSQLStringValue((PreparedStatement)stmt, (int)2, (String)trasmissione.getOrigine());
                Utilities.setSQLStringValue((PreparedStatement)stmt, (int)3, (String)trasmissione.getTipoOrigine());
                Utilities.setSQLStringValue((PreparedStatement)stmt, (int)4, (String)trasmissione.getIndirizzoTelematicoOrigine());
                Utilities.setSQLStringValue((PreparedStatement)stmt, (int)5, (String)trasmissione.getDestinazione());
                Utilities.setSQLStringValue((PreparedStatement)stmt, (int)6, (String)trasmissione.getTipoDestinazione());
                Utilities.setSQLStringValue((PreparedStatement)stmt, (int)7, (String)trasmissione.getIndirizzoTelematicoDestinazione());
                if (trasmissione.getOraRegistrazione() != null) {
                    stmt.setTimestamp(8, new Timestamp(trasmissione.getOraRegistrazione().getTime()));
                } else {
                    stmt.setTimestamp(8, null);
                }
                Utilities.setSQLStringValue((PreparedStatement)stmt, (int)9, (String)trasmissione.getTempo());
                stmt.executeUpdate();
                stmt.close();
            }
            for (i = 0; i < busta.sizeListaEccezioni(); ++i) {
                Eccezione eccezione = busta.getEccezione(i);
                sqlString = "INSERT INTO tracce_eccezioni (idtraccia, contesto_codifica, codice_eccezione, rilevanza, posizione) VALUES (?, ?, ?, ?, ?)";
                stmt = con.prepareStatement(sqlString);
                stmt.setLong(1, idtraccia);
                Utilities.setSQLStringValue((PreparedStatement)stmt, (int)2, (String)eccezione.getContestoCodifica());
                Utilities.setSQLStringValue((PreparedStatement)stmt, (int)3, (String)eccezione.getCodiceEccezione());
                Utilities.setSQLStringValue((PreparedStatement)stmt, (int)4, (String)eccezione.getRilevanza());
                Utilities.setSQLStringValue((PreparedStatement)stmt, (int)5, (String)eccezione.getPosizione());
                stmt.executeUpdate();
                stmt.close();
            }
            Object var22_22 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (releaseConnectionPool) {
                try {
                    con.close();
                }
                catch (Exception e) {}
            }
            break block52;
            {
                catch (Exception e) {
                    throw new TracciamentoException("Errore durante il tracciamento di una busta: " + e.getMessage() + "\nL'id egov della busta era: " + busta.getID(), e);
                }
            }
            catch (Throwable throwable) {
                Object var22_23 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (releaseConnectionPool) {
                    try {
                        con.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public String getTipoDatabase() {
        return this.tipoDatabase;
    }

    public void setTipoDatabase(String tipoDatabase) {
        this.tipoDatabase = tipoDatabase;
    }

    /*
     * Loose catch block
     */
    public void isAlive() throws DriverException {
        block19: {
            Connection con = null;
            Statement stmtTest = null;
            if (!this.singleConnection) {
                con = this.ds.getConnection();
                if (con == null) {
                    throw new Exception("Connessione non fornita dal datasource [" + this.datasource + "]");
                }
            } else {
                con = connection;
                if (con == null) {
                    throw new Exception("Connessione non fornita dal datasource [" + datasourceConnection + "]");
                }
            }
            stmtTest = con.createStatement();
            stmtTest.execute("SELECT * from db_info");
            Object var5_3 = null;
            try {
                if (stmtTest != null) {
                    stmtTest.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!this.singleConnection) {
                try {
                    con.close();
                }
                catch (Exception e) {}
            }
            break block19;
            {
                catch (Exception e) {
                    throw new DriverException("Connessione al database Tracciamento non disponibile: " + e.getMessage(), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                try {
                    if (stmtTest != null) {
                        stmtTest.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!this.singleConnection) {
                    try {
                        con.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }
}

