/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.logger;

import java.sql.Connection;
import java.util.Vector;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.log4j.Logger;
import org.openspcoop.egov.Busta;
import org.openspcoop.egov.XMLBuilder;
import org.openspcoop.pdd.config.ConfigurazionePdDReader;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.logger.ITracciamentoOpenSPCoopAppender;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.utils.date.DateManager;

public class Tracciamento {
    protected Logger loggerTracciamento = null;
    private String dominioSPCoop;
    private Vector<ITracciamentoOpenSPCoopAppender> loggerTracciamentoOpenSPCoopAppender = null;
    private Vector<String> tipoTracciamentoOpenSPCoopAppender = null;
    private ConfigurazionePdDReader configurazionePdDReader;
    private XMLBuilder xmlBuilder;
    private MsgDiagnostico msgDiagErroreTracciamento = null;

    public static String createLocationString(boolean bustaRicevuta, String location) {
        if (bustaRicevuta) {
            return "IN:" + location;
        }
        return "OUT:" + location;
    }

    public Tracciamento(String dominio) {
        this.dominioSPCoop = dominio;
        this.loggerTracciamento = OpenSPCoopLogger.loggerTracciamento;
        this.loggerTracciamentoOpenSPCoopAppender = OpenSPCoopLogger.loggerTracciamentoOpenSPCoopAppender;
        this.tipoTracciamentoOpenSPCoopAppender = OpenSPCoopLogger.tipoTracciamentoOpenSPCoopAppender;
        this.configurazionePdDReader = ConfigurazionePdDReader.getInstance();
        this.msgDiagErroreTracciamento = new MsgDiagnostico(OpenSPCoopProperties.getInstance().getIdentificativoPortaDefault());
        this.xmlBuilder = new XMLBuilder();
    }

    public Tracciamento() {
        this(OpenSPCoopProperties.getInstance().getIdentificativoPortaDefault());
    }

    public void setDominioSPCoop(String dominio) {
        this.dominioSPCoop = dominio;
    }

    @Deprecated
    public String filter(String msg) {
        String xml = msg.replaceAll("&lt;", "<");
        xml = xml.replaceAll("&quot;", "\"");
        xml = xml.replaceAll("&gt;", ">");
        return xml;
    }

    public void registraRichiesta(Connection conOpenSPCoopPdD, Busta busta, String location) {
        this.registraRichiesta(conOpenSPCoopPdD, busta, location, null, null);
    }

    public void registraRichiesta(Connection conOpenSPCoopPdD, Busta busta, String location, String idCorrelazioneApplicativa, String servizioApplicativo) {
        if (this.configurazionePdDReader.tracciamentoBusteEGov()) {
            String xml = null;
            try {
                if (OpenSPCoopLogger.loggerTracciamentoAbilitato) {
                    xml = this.xmlBuilder.buildString_Tracciamento(busta, this.dominioSPCoop, "Richiesta");
                    if (xml == null) {
                        throw new Exception("Traccia non costruita");
                    }
                    this.loggerTracciamento.info((Object)xml);
                }
                for (int i = 0; i < this.loggerTracciamentoOpenSPCoopAppender.size(); ++i) {
                    try {
                        this.loggerTracciamentoOpenSPCoopAppender.get(i).log(conOpenSPCoopPdD, DateManager.getDate(), this.dominioSPCoop, "Richiesta", busta, location, idCorrelazioneApplicativa, servizioApplicativo);
                        continue;
                    }
                    catch (Exception e) {
                        OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante il tracciamento personalizzato [" + this.tipoTracciamentoOpenSPCoopAppender.get(i) + "] della richiesta: " + e.getMessage() + ". Traccia non registrata:\n" + xml), (Throwable)e);
                        try {
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", "Richiesta");
                            this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIAMENTO_PERSONALIZZATO@", this.tipoTracciamentoOpenSPCoopAppender.get(i));
                            this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                            this.msgDiagErroreTracciamento.logPersonalizzato(this.msgDiagErroreTracciamento.getMessaggio("registrazioneNonRiuscita.openspcoopAppender"), this.msgDiagErroreTracciamento.getLivello("registrazioneNonRiuscita.openspcoopAppender"));
                            continue;
                        }
                        catch (Exception eMsg) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Exception e) {
                if (xml == null && !OpenSPCoopLogger.loggerTracciamentoAbilitato) {
                    try {
                        xml = this.xmlBuilder.buildString_Tracciamento(busta, this.dominioSPCoop, "Richiesta");
                    }
                    catch (Exception eBuild) {
                        // empty catch block
                    }
                }
                if (xml == null) {
                    OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante la costruzione della traccia: " + e.getMessage()), (Throwable)e);
                }
                OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante il tracciamento della richiesta: " + e.getMessage() + ". Traccia non registrata:\n" + xml), (Throwable)e);
                try {
                    this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", "Richiesta");
                    this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                    this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                    this.msgDiagErroreTracciamento.logPersonalizzato(this.msgDiagErroreTracciamento.getMessaggio("registrazioneNonRiuscita"), this.msgDiagErroreTracciamento.getLivello("registrazioneNonRiuscita"));
                }
                catch (Exception eMsg) {
                    // empty catch block
                }
            }
        }
    }

    public void registraRichiesta(Connection conOpenSPCoopPdD, byte[] busta, Busta bustaObject, String location) {
        this.registraRichiesta(conOpenSPCoopPdD, busta, bustaObject, location, null, null);
    }

    public void registraRichiesta(Connection conOpenSPCoopPdD, byte[] busta, Busta bustaObject, String location, String idCorrelazioneApplicativa, String servizioApplicativo) {
        if (this.configurazionePdDReader.tracciamentoBusteEGov()) {
            String xml = null;
            try {
                if (OpenSPCoopLogger.loggerTracciamentoAbilitato) {
                    xml = this.xmlBuilder.buildString_Tracciamento(busta, this.dominioSPCoop, "Richiesta");
                    if (xml == null) {
                        throw new Exception("Traccia non costruita");
                    }
                    this.loggerTracciamento.info((Object)xml);
                }
                for (int i = 0; i < this.loggerTracciamentoOpenSPCoopAppender.size(); ++i) {
                    try {
                        this.loggerTracciamentoOpenSPCoopAppender.get(i).log(conOpenSPCoopPdD, DateManager.getDate(), this.dominioSPCoop, "Richiesta", bustaObject, location, idCorrelazioneApplicativa, servizioApplicativo);
                        continue;
                    }
                    catch (Exception e) {
                        OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante il tracciamento personalizzato [" + this.tipoTracciamentoOpenSPCoopAppender.get(i) + "] della richiesta: " + e.getMessage() + ". Traccia non registrata:\n" + xml), (Throwable)e);
                        try {
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", "Richiesta");
                            this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIAMENTO_PERSONALIZZATO@", this.tipoTracciamentoOpenSPCoopAppender.get(i));
                            this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                            this.msgDiagErroreTracciamento.logPersonalizzato(this.msgDiagErroreTracciamento.getMessaggio("registrazioneNonRiuscita.openspcoopAppender"), this.msgDiagErroreTracciamento.getLivello("registrazioneNonRiuscita.openspcoopAppender"));
                            continue;
                        }
                        catch (Exception eMsg) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Exception e) {
                if (xml == null && !OpenSPCoopLogger.loggerTracciamentoAbilitato) {
                    try {
                        xml = this.xmlBuilder.buildString_Tracciamento(busta, this.dominioSPCoop, "Richiesta");
                    }
                    catch (Exception eBuild) {
                        // empty catch block
                    }
                }
                if (xml == null) {
                    OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante la costruzione della traccia: " + e.getMessage()), (Throwable)e);
                }
                OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante il tracciamento della richiesta: " + e.getMessage() + ". Traccia non registrata:\n" + xml), (Throwable)e);
                try {
                    this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", "Richiesta");
                    this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                    this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                    this.msgDiagErroreTracciamento.logPersonalizzato(this.msgDiagErroreTracciamento.getMessaggio("registrazioneNonRiuscita"), this.msgDiagErroreTracciamento.getLivello("registrazioneNonRiuscita"));
                }
                catch (Exception eMsg) {
                    // empty catch block
                }
            }
        }
    }

    public void registraRichiesta(Connection conOpenSPCoopPdD, SOAPHeaderElement busta, Busta bustaObject, String location) {
        this.registraRichiesta(conOpenSPCoopPdD, busta, bustaObject, location, null, null);
    }

    public void registraRichiesta(Connection conOpenSPCoopPdD, SOAPHeaderElement busta, Busta bustaObject, String location, String idCorrelazioneApplicativa, String servizioApplicativo) {
        if (this.configurazionePdDReader.tracciamentoBusteEGov()) {
            String xml = null;
            try {
                if (OpenSPCoopLogger.loggerTracciamentoAbilitato) {
                    xml = this.xmlBuilder.buildString_Tracciamento(busta, this.dominioSPCoop, "Richiesta");
                    if (xml == null) {
                        throw new Exception("Traccia non costruita");
                    }
                    this.loggerTracciamento.info((Object)xml);
                }
                for (int i = 0; i < this.loggerTracciamentoOpenSPCoopAppender.size(); ++i) {
                    try {
                        this.loggerTracciamentoOpenSPCoopAppender.get(i).log(conOpenSPCoopPdD, DateManager.getDate(), this.dominioSPCoop, "Richiesta", bustaObject, location, idCorrelazioneApplicativa, servizioApplicativo);
                        continue;
                    }
                    catch (Exception e) {
                        OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante il tracciamento personalizzato [" + this.tipoTracciamentoOpenSPCoopAppender.get(i) + "] della richiesta: " + e.getMessage() + ". Traccia non registrata:\n" + xml), (Throwable)e);
                        try {
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", "Richiesta");
                            this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIAMENTO_PERSONALIZZATO@", this.tipoTracciamentoOpenSPCoopAppender.get(i));
                            this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                            this.msgDiagErroreTracciamento.logPersonalizzato(this.msgDiagErroreTracciamento.getMessaggio("registrazioneNonRiuscita.openspcoopAppender"), this.msgDiagErroreTracciamento.getLivello("registrazioneNonRiuscita.openspcoopAppender"));
                            continue;
                        }
                        catch (Exception eMsg) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Exception e) {
                if (xml == null && !OpenSPCoopLogger.loggerTracciamentoAbilitato) {
                    try {
                        xml = this.xmlBuilder.buildString_Tracciamento(busta, this.dominioSPCoop, "Richiesta");
                    }
                    catch (Exception eBuild) {
                        // empty catch block
                    }
                }
                if (xml == null) {
                    OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante la costruzione della traccia: " + e.getMessage()), (Throwable)e);
                }
                OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante il tracciamento della richiesta: " + e.getMessage() + ". Traccia non registrata:\n" + xml), (Throwable)e);
                try {
                    this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", "Richiesta");
                    this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                    this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                    this.msgDiagErroreTracciamento.logPersonalizzato(this.msgDiagErroreTracciamento.getMessaggio("registrazioneNonRiuscita"), this.msgDiagErroreTracciamento.getLivello("registrazioneNonRiuscita"));
                }
                catch (Exception eMsg) {
                    // empty catch block
                }
            }
        }
    }

    public void registraRisposta(Connection conOpenSPCoopPdD, Busta busta, String location) {
        this.registraRisposta(conOpenSPCoopPdD, busta, location, null, null);
    }

    public void registraRisposta(Connection conOpenSPCoopPdD, Busta busta, String location, String idCorrelazioneApplicativa, String servizioApplicativo) {
        if (this.configurazionePdDReader.tracciamentoBusteEGov()) {
            String xml = null;
            try {
                if (OpenSPCoopLogger.loggerTracciamentoAbilitato) {
                    xml = this.xmlBuilder.buildString_Tracciamento(busta, this.dominioSPCoop, "Risposta");
                    if (xml == null) {
                        throw new Exception("Traccia non costruita");
                    }
                    this.loggerTracciamento.info((Object)xml);
                }
                for (int i = 0; i < this.loggerTracciamentoOpenSPCoopAppender.size(); ++i) {
                    try {
                        this.loggerTracciamentoOpenSPCoopAppender.get(i).log(conOpenSPCoopPdD, DateManager.getDate(), this.dominioSPCoop, "Risposta", busta, location, idCorrelazioneApplicativa, servizioApplicativo);
                        continue;
                    }
                    catch (Exception e) {
                        OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante il tracciamento personalizzato [" + this.tipoTracciamentoOpenSPCoopAppender.get(i) + "] della risposta: " + e.getMessage() + ". Traccia non registrata:\n" + xml), (Throwable)e);
                        try {
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", "Risposta");
                            this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIAMENTO_PERSONALIZZATO@", this.tipoTracciamentoOpenSPCoopAppender.get(i));
                            this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                            this.msgDiagErroreTracciamento.logPersonalizzato(this.msgDiagErroreTracciamento.getMessaggio("registrazioneNonRiuscita.openspcoopAppender"), this.msgDiagErroreTracciamento.getLivello("registrazioneNonRiuscita.openspcoopAppender"));
                            continue;
                        }
                        catch (Exception eMsg) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Exception e) {
                if (xml == null && !OpenSPCoopLogger.loggerTracciamentoAbilitato) {
                    try {
                        xml = this.xmlBuilder.buildString_Tracciamento(busta, this.dominioSPCoop, "Risposta");
                    }
                    catch (Exception eBuild) {
                        // empty catch block
                    }
                }
                if (xml == null) {
                    OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante la costruzione della traccia: " + e.getMessage()), (Throwable)e);
                }
                OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante il tracciamento della risposta: " + e.getMessage() + ". Traccia non registrata:\n" + xml), (Throwable)e);
                try {
                    this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", "Risposta");
                    this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                    this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                    this.msgDiagErroreTracciamento.logPersonalizzato(this.msgDiagErroreTracciamento.getMessaggio("registrazioneNonRiuscita"), this.msgDiagErroreTracciamento.getLivello("registrazioneNonRiuscita"));
                }
                catch (Exception eMsg) {
                    // empty catch block
                }
            }
        }
    }

    public void registraRisposta(Connection conOpenSPCoopPdD, byte[] busta, Busta bustaObject, String location) {
        this.registraRisposta(conOpenSPCoopPdD, busta, bustaObject, location, null, null);
    }

    public void registraRisposta(Connection conOpenSPCoopPdD, byte[] busta, Busta bustaObject, String location, String idCorrelazioneApplicativa, String servizioApplicativo) {
        if (this.configurazionePdDReader.tracciamentoBusteEGov()) {
            String xml = null;
            try {
                if (OpenSPCoopLogger.loggerTracciamentoAbilitato) {
                    xml = this.xmlBuilder.buildString_Tracciamento(busta, this.dominioSPCoop, "Risposta");
                    if (xml == null) {
                        throw new Exception("Traccia non costruita");
                    }
                    this.loggerTracciamento.info((Object)xml);
                }
                for (int i = 0; i < this.loggerTracciamentoOpenSPCoopAppender.size(); ++i) {
                    try {
                        this.loggerTracciamentoOpenSPCoopAppender.get(i).log(conOpenSPCoopPdD, DateManager.getDate(), this.dominioSPCoop, "Risposta", bustaObject, location, idCorrelazioneApplicativa, servizioApplicativo);
                        continue;
                    }
                    catch (Exception e) {
                        OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante il tracciamento personalizzato [" + this.tipoTracciamentoOpenSPCoopAppender.get(i) + "] della risposta: " + e.getMessage() + ". Traccia non registrata:\n" + xml), (Throwable)e);
                        try {
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", "Risposta");
                            this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIAMENTO_PERSONALIZZATO@", this.tipoTracciamentoOpenSPCoopAppender.get(i));
                            this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                            this.msgDiagErroreTracciamento.logPersonalizzato(this.msgDiagErroreTracciamento.getMessaggio("registrazioneNonRiuscita.openspcoopAppender"), this.msgDiagErroreTracciamento.getLivello("registrazioneNonRiuscita.openspcoopAppender"));
                            continue;
                        }
                        catch (Exception eMsg) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Exception e) {
                if (xml == null && !OpenSPCoopLogger.loggerTracciamentoAbilitato) {
                    try {
                        xml = this.xmlBuilder.buildString_Tracciamento(busta, this.dominioSPCoop, "Risposta");
                    }
                    catch (Exception eBuild) {
                        // empty catch block
                    }
                }
                if (xml == null) {
                    OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante la costruzione della traccia: " + e.getMessage()), (Throwable)e);
                }
                OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante il tracciamento della risposta: " + e.getMessage() + ". Traccia non registrata:\n" + xml), (Throwable)e);
                try {
                    this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", "Risposta");
                    this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                    this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                    this.msgDiagErroreTracciamento.logPersonalizzato(this.msgDiagErroreTracciamento.getMessaggio("registrazioneNonRiuscita"), this.msgDiagErroreTracciamento.getLivello("registrazioneNonRiuscita"));
                }
                catch (Exception eMsg) {
                    // empty catch block
                }
            }
        }
    }

    public void registraRisposta(Connection conOpenSPCoopPdD, SOAPHeaderElement busta, Busta bustaObject, String location) {
        this.registraRisposta(conOpenSPCoopPdD, busta, bustaObject, location, null, null);
    }

    public void registraRisposta(Connection conOpenSPCoopPdD, SOAPHeaderElement busta, Busta bustaObject, String location, String idCorrelazioneApplicativa, String servizioApplicativo) {
        if (this.configurazionePdDReader.tracciamentoBusteEGov()) {
            String xml = null;
            try {
                if (OpenSPCoopLogger.loggerTracciamentoAbilitato) {
                    xml = this.xmlBuilder.buildString_Tracciamento(busta, this.dominioSPCoop, "Risposta");
                    if (xml == null) {
                        throw new Exception("Traccia non costruita");
                    }
                    this.loggerTracciamento.info((Object)xml);
                }
                for (int i = 0; i < this.loggerTracciamentoOpenSPCoopAppender.size(); ++i) {
                    try {
                        this.loggerTracciamentoOpenSPCoopAppender.get(i).log(conOpenSPCoopPdD, DateManager.getDate(), this.dominioSPCoop, "Risposta", bustaObject, location, idCorrelazioneApplicativa, servizioApplicativo);
                        continue;
                    }
                    catch (Exception e) {
                        OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante il tracciamento personalizzato [" + this.tipoTracciamentoOpenSPCoopAppender.get(i) + "] della risposta: " + e.getMessage() + ". Traccia non registrata:\n" + xml), (Throwable)e);
                        try {
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", "Risposta");
                            this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIAMENTO_PERSONALIZZATO@", this.tipoTracciamentoOpenSPCoopAppender.get(i));
                            this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                            this.msgDiagErroreTracciamento.logPersonalizzato(this.msgDiagErroreTracciamento.getMessaggio("registrazioneNonRiuscita.openspcoopAppender"), this.msgDiagErroreTracciamento.getLivello("registrazioneNonRiuscita.openspcoopAppender"));
                            continue;
                        }
                        catch (Exception eMsg) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Exception e) {
                if (xml == null && !OpenSPCoopLogger.loggerTracciamentoAbilitato) {
                    try {
                        xml = this.xmlBuilder.buildString_Tracciamento(busta, this.dominioSPCoop, "Risposta");
                    }
                    catch (Exception eBuild) {
                        // empty catch block
                    }
                }
                if (xml == null) {
                    OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante la costruzione della traccia: " + e.getMessage()), (Throwable)e);
                }
                OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante il tracciamento della risposta: " + e.getMessage() + ". Traccia non registrata:\n" + xml), (Throwable)e);
                try {
                    this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", "Risposta");
                    this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                    this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                    this.msgDiagErroreTracciamento.logPersonalizzato(this.msgDiagErroreTracciamento.getMessaggio("registrazioneNonRiuscita"), this.msgDiagErroreTracciamento.getLivello("registrazioneNonRiuscita"));
                }
                catch (Exception eMsg) {
                    // empty catch block
                }
            }
        }
    }
}

