/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.logger;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.config.MessaggiDiagnostici;
import org.openspcoop.dao.config.Tracciamento;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.egov.Imbustamento;
import org.openspcoop.pdd.config.ClassNameProperties;
import org.openspcoop.pdd.logger.IMsgDiagnosticoOpenSPCoopAppender;
import org.openspcoop.pdd.logger.ITracciamentoOpenSPCoopAppender;
import org.openspcoop.pdd.logger.LogLevels;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenSPCoopLogger {
    protected static Logger loggerTracciamento = null;
    protected static boolean loggerTracciamentoAbilitato = false;
    protected static Logger loggerMsgDiagnostico = null;
    protected static boolean loggerMsgDiagnosticoAbilitato = false;
    protected static Logger loggerOpenSPCoop = null;
    protected static boolean loggerMsgDiagnosticoReadableAbilitato = false;
    protected static Logger loggerIntegrationManager = null;
    protected static boolean loggerIntegrationManagerAbilitato = false;
    protected static Logger loggerDump = null;
    protected static Logger loggerOpenSPCoopConsole = Logger.getLogger((String)"OpenSPCoop");
    protected static Logger loggerOpenSPCoopCore = null;
    protected static Vector<IMsgDiagnosticoOpenSPCoopAppender> loggerMsgDiagnosticoOpenSPCoopAppender = new Vector();
    protected static Vector<String> tipoMsgDiagnosticoOpenSPCoopAppender = new Vector();
    protected static Vector<ITracciamentoOpenSPCoopAppender> loggerTracciamentoOpenSPCoopAppender = new Vector();
    protected static Vector<String> tipoTracciamentoOpenSPCoopAppender = new Vector();

    public static boolean initialize(String rootDirectory) {
        try {
            Properties loggerProperties = new Properties();
            File loggerFile = new File(rootDirectory + "logger.log4j.properties");
            if (!loggerFile.exists()) {
                loggerProperties.load(OpenSPCoopLogger.class.getResourceAsStream("/logger.log4j.properties"));
            } else {
                loggerProperties.load(new FileInputStream(loggerFile));
            }
            PropertyConfigurator.configure((Properties)loggerProperties);
            loggerTracciamento = Logger.getLogger((String)"openspcoop.tracciamento");
            if (loggerTracciamento == null) {
                throw new Exception("Logger openspcoop.tracciamento non trovato");
            }
            String tmp = loggerProperties.getProperty("log4j.category.openspcoop.tracciamento");
            if (tmp != null) {
                tmp.trim();
                if (tmp.startsWith("OFF")) {
                    loggerOpenSPCoopConsole.info((Object)"Sistema di logging delle tracce disabilitato da log4j (OFF).");
                    loggerTracciamentoAbilitato = false;
                } else {
                    loggerTracciamentoAbilitato = true;
                }
            }
            if ((loggerMsgDiagnostico = Logger.getLogger((String)"openspcoop.msgDiagnostico")) == null) {
                throw new Exception("Logger openspcoop.msgDiagnostico non trovato");
            }
            tmp = loggerProperties.getProperty("log4j.category.openspcoop.msgDiagnostico");
            if (tmp != null) {
                tmp.trim();
                if (tmp.startsWith("OFF")) {
                    loggerOpenSPCoopConsole.info((Object)"Sistema di logging dei messaggi diagnostici disabilitato da log4j (OFF).");
                    loggerMsgDiagnosticoAbilitato = false;
                } else {
                    loggerMsgDiagnosticoAbilitato = true;
                }
            }
            if ((loggerOpenSPCoop = Logger.getLogger((String)"openspcoop.portaDiDominio")) == null) {
                throw new Exception("Logger openspcoop.portaDiDominio non trovato");
            }
            tmp = loggerProperties.getProperty("log4j.category.openspcoop.portaDiDominio");
            if (tmp != null) {
                tmp.trim();
                if (tmp.startsWith("OFF")) {
                    loggerOpenSPCoopConsole.info((Object)"Sistema di logging dei messaggi diagnostici 'readable' disabilitato da log4j (OFF).");
                    loggerMsgDiagnosticoReadableAbilitato = false;
                } else {
                    loggerMsgDiagnosticoReadableAbilitato = true;
                }
            }
            if ((loggerIntegrationManager = Logger.getLogger((String)"openspcoop.integrationManager")) == null) {
                throw new Exception("Logger openspcoop.integrationManager non trovato");
            }
            tmp = loggerProperties.getProperty("log4j.category.openspcoop.integrationManager");
            if (tmp != null) {
                tmp.trim();
                if (tmp.startsWith("OFF")) {
                    loggerOpenSPCoopConsole.info((Object)"Sistema di logging dei messaggi diagnostici 'readable' per il servizio di IntegrationManager disabilitato da log4j (OFF).");
                    loggerIntegrationManagerAbilitato = false;
                } else {
                    loggerIntegrationManagerAbilitato = true;
                }
            }
            if ((loggerDump = Logger.getLogger((String)"openspcoop.dump")) == null) {
                throw new Exception("Logger openspcoop.dump non trovato");
            }
            loggerOpenSPCoopCore = Logger.getLogger((String)"openspcoop.core");
            if (loggerOpenSPCoopCore == null) {
                throw new Exception("Logger openspcoop.core non trovato");
            }
            loggerOpenSPCoopConsole.info((Object)"Sistema di logging correttamente inizializzato.");
            return true;
        }
        catch (Exception e) {
            loggerOpenSPCoopConsole.error((Object)("Riscontrato errore durante l'inizializzazione del sistema di logging di OpenSPCoop: " + e.getMessage()));
            return false;
        }
    }

    public static boolean initializeMsgDiagnosticiOpenSPCoopAppender(MessaggiDiagnostici msgDiagConfig) {
        try {
            if (msgDiagConfig != null) {
                ClassNameProperties prop = ClassNameProperties.getInstance();
                for (int i = 0; i < msgDiagConfig.sizeOpenspcoopAppenderList(); ++i) {
                    String connectorClass = prop.getMsgDiagnosticoOpenSPCoopAppender(msgDiagConfig.getOpenspcoopAppender(i).getTipo());
                    if (connectorClass == null) {
                        throw new Exception("Riscontrato errore durante il caricamento del msg diagnostico appender [" + msgDiagConfig.getOpenspcoopAppender(i).getTipo() + "]: appender non registrato.");
                    }
                    IMsgDiagnosticoOpenSPCoopAppender appender = null;
                    try {
                        Class<?> c = Class.forName(connectorClass);
                        appender = (IMsgDiagnosticoOpenSPCoopAppender)c.newInstance();
                        appender.initializeAppender(msgDiagConfig.getOpenspcoopAppender(i));
                    }
                    catch (ClassNotFoundException e) {
                        throw new Exception("Riscontrato errore durante il caricamento del msg diagnostico appender specificato [" + msgDiagConfig.getOpenspcoopAppender(i).getTipo() + "]: " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new Exception("Riscontrato errore durante l'inizializzazione del msg diagnostico appender specificato [" + msgDiagConfig.getOpenspcoopAppender(i).getTipo() + "]: " + e.getMessage());
                    }
                    loggerMsgDiagnosticoOpenSPCoopAppender.add(appender);
                    tipoMsgDiagnosticoOpenSPCoopAppender.add(msgDiagConfig.getOpenspcoopAppender(i).getTipo());
                    loggerOpenSPCoopConsole.info((Object)("Sistema di logging: MsgDiagnosticoOpenSPCoopAppender di tipo [" + msgDiagConfig.getOpenspcoopAppender(i).getTipo() + "] correttamente inizializzato."));
                }
            }
            return true;
        }
        catch (Exception e) {
            loggerMsgDiagnosticoOpenSPCoopAppender.clear();
            loggerOpenSPCoopConsole.error((Object)("Riscontrato errore durante l'inizializzazione degli appender personalizzati per msg diagnostici: " + e.getMessage()));
            return false;
        }
    }

    public static boolean initializeTracciamentoOpenSPCoopAppender(Tracciamento tracciamentoConfig) {
        try {
            if (tracciamentoConfig != null) {
                ClassNameProperties prop = ClassNameProperties.getInstance();
                for (int i = 0; i < tracciamentoConfig.sizeOpenspcoopAppenderList(); ++i) {
                    String connectorClass = prop.getTracciamentoOpenSPCoopAppender(tracciamentoConfig.getOpenspcoopAppender(i).getTipo());
                    if (connectorClass == null) {
                        throw new Exception("Riscontrato errore durante il caricamento del tracciamento appender [" + tracciamentoConfig.getOpenspcoopAppender(i).getTipo() + "]: appender non registrato.");
                    }
                    ITracciamentoOpenSPCoopAppender appender = null;
                    try {
                        Class<?> c = Class.forName(connectorClass);
                        appender = (ITracciamentoOpenSPCoopAppender)c.newInstance();
                        appender.initializeAppender(tracciamentoConfig.getOpenspcoopAppender(i));
                    }
                    catch (ClassNotFoundException e) {
                        throw new Exception("Riscontrato errore durante il caricamento del tracciamento appender specificato [" + tracciamentoConfig.getOpenspcoopAppender(i).getTipo() + "]: " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new Exception("Riscontrato errore durante l'inizializzazione del tracciamento appender specificato [" + tracciamentoConfig.getOpenspcoopAppender(i).getTipo() + "]: " + e.getMessage());
                    }
                    loggerTracciamentoOpenSPCoopAppender.add(appender);
                    tipoTracciamentoOpenSPCoopAppender.add(tracciamentoConfig.getOpenspcoopAppender(i).getTipo());
                    loggerOpenSPCoopConsole.info((Object)("Sistema di logging: TracciamentoOpenSPCoopAppender di tipo [" + tracciamentoConfig.getOpenspcoopAppender(i).getTipo() + "] correttamente inizializzato."));
                }
            }
            return true;
        }
        catch (Exception e) {
            loggerMsgDiagnosticoOpenSPCoopAppender.clear();
            loggerOpenSPCoopConsole.error((Object)("Riscontrato errore durante l'inizializzazione degli appender personalizzati per msg diagnostici: " + e.getMessage()));
            return false;
        }
    }

    protected static String humanReadable(String xml, String idEGov) {
        int indexFinish;
        int indexStart = xml.indexOf("MessaggioDiagnostico");
        StringBuffer bf = new StringBuffer();
        for (int i = 1; i < indexStart; ++i) {
            bf.append(xml.charAt(i));
        }
        String xmnls = bf.toString();
        String livello = null;
        int valueLivello = -1;
        indexStart = xml.indexOf("<" + xmnls + "LivelloDiSeverita");
        if (indexStart != -1 && (indexFinish = xml.indexOf("</" + xmnls + "LivelloDiSeverita>")) != -1) {
            livello = xml.substring(indexStart + xmnls.length() + 19, indexFinish);
        }
        try {
            Integer test = new Integer(livello);
            valueLivello = test;
        }
        catch (Exception e) {
            String errorCompatibilitaAxis = " xmlns:xsi=\"http://www.w3.org/1999/XMLSchema-instance\"";
            indexStart = xml.indexOf("<" + xmnls + "LivelloDiSeverita");
            if (indexStart != -1 && (indexFinish = xml.indexOf("</" + xmnls + "LivelloDiSeverita>")) != -1) {
                livello = xml.substring(indexStart + xmnls.length() + 19 + errorCompatibilitaAxis.length(), indexFinish);
            }
            try {
                Integer test = new Integer(livello);
                valueLivello = test;
            }
            catch (Exception er) {
                valueLivello = -1;
            }
        }
        String ora = "N.D.";
        indexStart = xml.indexOf("<" + xmnls + "OraRegistrazione");
        if (indexStart != -1 && (indexFinish = xml.indexOf("</" + xmnls + "OraRegistrazione>")) != -1) {
            ora = xml.substring(indexStart + xmnls.length() + 20, indexStart + xmnls.length() + 20 + 19).replace('T', ' ');
        }
        String idPorta = "?PDD_Inesistente?";
        indexStart = xml.indexOf("<" + xmnls + "IdentificativoPorta");
        if (indexStart != -1 && (indexFinish = xml.indexOf("</" + xmnls + "IdentificativoPorta>")) != -1) {
            idPorta = xml.substring(indexStart + xmnls.length() + 21, indexFinish);
        }
        String idFunzione = "?Funzione_Inesistente?";
        indexStart = xml.indexOf("<" + xmnls + "IdentificativoFunzione");
        if (indexStart != -1 && (indexFinish = xml.indexOf("</" + xmnls + "IdentificativoFunzione>")) != -1) {
            idFunzione = xml.substring(indexStart + xmnls.length() + 24, indexFinish);
        }
        String text = "?N.D.?";
        indexStart = xml.indexOf("<" + xmnls + "TestoDiagnostico");
        if (indexStart != -1 && (indexFinish = xml.indexOf("</" + xmnls + "TestoDiagnostico>")) != -1) {
            text = xml.substring(indexStart + xmnls.length() + 18, indexFinish);
        }
        StringBuffer showMsg = new StringBuffer();
        showMsg.append(idPorta);
        showMsg.append(" <");
        showMsg.append(ora);
        showMsg.append("> ");
        showMsg.append("MsgDiagnostico(");
        showMsg.append(LogLevels.toOpenSPCoop(valueLivello).toString());
        showMsg.append(") [");
        showMsg.append(idFunzione);
        showMsg.append("] ");
        if (idEGov != null) {
            showMsg.append("\nID: ");
            showMsg.append(idEGov);
        }
        showMsg.append("\n");
        showMsg.append(text);
        showMsg.append("\n");
        return showMsg.toString();
    }

    protected static String humanReadable(String idPorta, String idFunzione, int valueLivello, String text, String idEGov, String idCorrelazioneApplicativa, String porta, boolean delegata, IDSoggetto fruitore, IDServizio servizio, String servizioApplicativo) {
        StringBuffer showMsg = new StringBuffer();
        showMsg.append(idPorta);
        showMsg.append(".");
        showMsg.append(idFunzione);
        showMsg.append(" <");
        showMsg.append(Imbustamento.getDate_eGovFormat());
        showMsg.append("> ");
        showMsg.append("(");
        showMsg.append(LogLevels.toOpenSPCoop(valueLivello).toString());
        showMsg.append(")");
        if (idEGov != null) {
            showMsg.append(" IDeGov:");
            showMsg.append(idEGov);
        }
        if (idCorrelazioneApplicativa != null) {
            showMsg.append(" IDApplicativo:");
            showMsg.append(idCorrelazioneApplicativa);
        }
        if (delegata) {
            if (porta != null) {
                showMsg.append(" PD:" + porta);
            } else {
                showMsg.append(" PA:" + porta);
            }
        }
        if (servizioApplicativo != null) {
            showMsg.append(" SA:" + servizioApplicativo);
        }
        if (fruitore != null) {
            showMsg.append(" FR:");
            showMsg.append(fruitore.toString());
        }
        if (fruitore != null && servizio != null) {
            showMsg.append(" -> ");
        }
        if (servizio != null) {
            if (servizio.getServizio() != null && servizio.getTipoServizio() != null && servizio.getSoggettoErogatore() != null) {
                showMsg.append(" S:");
                showMsg.append(servizio.toString());
            } else if (servizio.getSoggettoErogatore() != null) {
                showMsg.append(" ER:");
                showMsg.append(servizio.getSoggettoErogatore().toString());
            }
        }
        showMsg.append("\n");
        showMsg.append(text);
        showMsg.append("\n");
        return showMsg.toString();
    }

    public static Logger getLoggerOpenSPCoopConsole() {
        return loggerOpenSPCoopConsole;
    }

    public static Logger getLoggerOpenSPCoopCore() {
        return loggerOpenSPCoopCore;
    }

    public static Vector<IMsgDiagnosticoOpenSPCoopAppender> getLoggerMsgDiagnosticoOpenSPCoopAppender() {
        return loggerMsgDiagnosticoOpenSPCoopAppender;
    }

    public static Vector<String> getTipoMsgDiagnosticoOpenSPCoopAppender() {
        return tipoMsgDiagnosticoOpenSPCoopAppender;
    }

    public static Vector<ITracciamentoOpenSPCoopAppender> getLoggerTracciamentoOpenSPCoopAppender() {
        return loggerTracciamentoOpenSPCoopAppender;
    }

    public static Vector<String> getTipoTracciamentoOpenSPCoopAppender() {
        return tipoTracciamentoOpenSPCoopAppender;
    }
}

