/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.logger;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import javax.sql.DataSource;
import org.openspcoop.dao.commons.DriverException;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.config.OpenspcoopAppender;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.logger.IMsgDiagnosticoOpenSPCoopAppender;
import org.openspcoop.pdd.logger.MsgDiagnosticoException;
import org.openspcoop.utils.GestoreJNDI;
import org.openspcoop.utils.Utilities;

public class MsgDiagnosticoOpenSPCoopAppenderDB
implements IMsgDiagnosticoOpenSPCoopAppender {
    private DataSource ds = null;
    private String datasource = null;
    private boolean singleConnection = false;
    private static final String MSG_DIAGNOSTICI = "msgdiagnostici";
    private static final String MSG_DIAGNOSTICI_CORRELAZIONE = "msgdiag_correlazione";
    private static final String MSG_DIAGNOSTICI_CORRELAZIONE_SA = "msgdiag_correlazione_sa";
    private static final String MSG_CORR_INDEX = "MSG_CORR_INDEX";
    private static Connection connection = null;
    private static String datasourceConnection = null;
    private OpenSPCoopProperties openspcoopProperties = null;
    private static boolean writeCorrelazione = true;

    private synchronized void initConnection(DataSource dsA, String dataSourceS) throws Exception {
        if (connection == null) {
            try {
                datasourceConnection = dataSourceS;
                connection = dsA.getConnection();
            }
            catch (Exception e) {
                throw new Exception("Inizializzazione single connection non riuscita", e);
            }
        }
    }

    public void initializeAppender(OpenspcoopAppender appenderProperties) throws MsgDiagnosticoException {
        try {
            String correlazioneString;
            Properties properties = new Properties();
            Properties ctx = new Properties();
            if (appenderProperties.sizePropertyList() > 0) {
                for (int i = 0; i < appenderProperties.sizePropertyList(); ++i) {
                    properties.put(appenderProperties.getProperty(i).getNome(), appenderProperties.getProperty(i).getValore());
                }
            } else {
                throw new MsgDiagnosticoException("Proprieta' 'datasource' non definita");
            }
            ctx = Utilities.readProperties((String)"context-", (Properties)properties);
            this.datasource = properties.getProperty("datasource");
            GestoreJNDI jndi = new GestoreJNDI(ctx);
            String singleConnectionString = properties.getProperty("singleConnection");
            if (singleConnectionString != null) {
                if ("true".equals(singleConnectionString = singleConnectionString.trim())) {
                    this.singleConnection = true;
                    if (connection == null) {
                        DataSource ds = (DataSource)jndi.lookup(this.datasource);
                        this.initConnection(ds, this.datasource);
                    }
                } else {
                    this.ds = (DataSource)jndi.lookup(this.datasource);
                }
            } else {
                this.ds = (DataSource)jndi.lookup(this.datasource);
            }
            if ((correlazioneString = properties.getProperty("correlazione")) != null && "false".equalsIgnoreCase(correlazioneString)) {
                writeCorrelazione = false;
            }
            this.openspcoopProperties = OpenSPCoopProperties.getInstance();
        }
        catch (Exception e) {
            throw new MsgDiagnosticoException("Errore durante l'inizializzazione dell'appender: " + e.getMessage(), e);
        }
    }

    public void log(Date gdo, String idPorta, String idFunzione, int severita, String messaggio) throws MsgDiagnosticoException {
        this.log(gdo, idPorta, idFunzione, severita, messaggio, null, null);
    }

    public void log(Date gdo, String idPorta, String idFunzione, int severita, String messaggio, String idEGov) throws MsgDiagnosticoException {
        this.log(gdo, idPorta, idFunzione, severita, messaggio, idEGov, null);
    }

    /*
     * Loose catch block
     */
    public void log(Date gdo, String idPorta, String idFunzione, int severita, String messaggio, String idEGov, String idEgovRisposta) throws MsgDiagnosticoException {
        block21: {
            Statement stmt = null;
            Connection con = null;
            if (!this.singleConnection) {
                con = this.ds.getConnection();
                if (con == null) {
                    throw new Exception("Connessione non fornita dal datasource [" + this.datasource + "]");
                }
            } else {
                con = connection;
                if (con == null) {
                    throw new Exception("Connessione non fornita dal datasource [" + datasourceConnection + "]");
                }
            }
            String updateString = "INSERT INTO msgdiagnostici (gdo, idporta, idfunzione, severita, messaggio, idegov, idegov_risposta) VALUES (?, ?, ?, ?, ?, ?, ?)";
            stmt = con.prepareStatement(updateString);
            if (gdo != null) {
                stmt.setTimestamp(1, new Timestamp(gdo.getTime()));
            } else {
                stmt.setTimestamp(1, null);
            }
            Utilities.setSQLStringValue((PreparedStatement)stmt, (int)2, (String)idPorta);
            Utilities.setSQLStringValue((PreparedStatement)stmt, (int)3, (String)idFunzione);
            stmt.setInt(4, severita);
            Utilities.setSQLStringValue((PreparedStatement)stmt, (int)5, (String)messaggio);
            Utilities.setSQLStringValue((PreparedStatement)stmt, (int)6, (String)idEGov);
            Utilities.setSQLStringValue((PreparedStatement)stmt, (int)7, (String)idEgovRisposta);
            stmt.executeUpdate();
            stmt.close();
            Object var12_12 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!this.singleConnection) {
                try {
                    con.close();
                }
                catch (Exception e) {}
            }
            break block21;
            {
                catch (Exception e) {
                    throw new MsgDiagnosticoException("Errore durante la registrazione del msg diagnostico: " + e.getMessage() + "\nIl messaggio era: " + messaggio, e);
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!this.singleConnection) {
                    try {
                        con.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void logCorrelazione(String idEGov, Date gdo, String porta, boolean delegata, IDSoggetto fruitore, IDServizio servizio, String idCorrelazioneApplicativa) throws MsgDiagnosticoException {
        block36: {
            if (writeCorrelazione) {
                Statement stmt = null;
                Connection con = null;
                if (!this.singleConnection) {
                    con = this.ds.getConnection();
                    if (con == null) {
                        throw new Exception("Connessione non fornita dal datasource [" + this.datasource + "]");
                    }
                } else {
                    con = connection;
                    if (con == null) {
                        throw new Exception("Connessione non fornita dal datasource [" + datasourceConnection + "]");
                    }
                }
                String updateString = "INSERT INTO msgdiag_correlazione (idegov, gdo, porta, delegata, tipo_fruitore, fruitore, tipo_erogatore, erogatore, tipo_servizio, servizio, azione, id_correlazione_applicativa) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ? , ? , ? , ?)";
                stmt = con.prepareStatement(updateString);
                if (idEGov == null) {
                    throw new Exception("Identificativo eGov non definito");
                }
                Utilities.setSQLStringValue((PreparedStatement)stmt, (int)1, (String)idEGov);
                if (gdo == null) {
                    throw new Exception("Data di registrazione non definita");
                }
                stmt.setTimestamp(2, new Timestamp(gdo.getTime()));
                Utilities.setSQLStringValue((PreparedStatement)stmt, (int)3, (String)porta);
                if (delegata) {
                    stmt.setInt(4, 1);
                } else {
                    stmt.setInt(4, 0);
                }
                if (fruitore != null) {
                    if (fruitore.getTipo() == null) {
                        throw new Exception("Tipo fruitore non definito");
                    }
                    Utilities.setSQLStringValue((PreparedStatement)stmt, (int)5, (String)fruitore.getTipo());
                    if (fruitore.getNome() == null) {
                        throw new Exception("Nome fruitore non definito");
                    }
                } else {
                    throw new Exception("Fruitore non definito");
                }
                Utilities.setSQLStringValue((PreparedStatement)stmt, (int)6, (String)fruitore.getNome());
                if (servizio != null) {
                    if (servizio.getSoggettoErogatore() != null) {
                        if (servizio.getSoggettoErogatore().getTipo() == null) {
                            throw new Exception("Tipo soggetto erogatore non definito");
                        }
                        Utilities.setSQLStringValue((PreparedStatement)stmt, (int)7, (String)servizio.getSoggettoErogatore().getTipo());
                        if (servizio.getSoggettoErogatore().getNome() == null) {
                            throw new Exception("Nome soggetto erogatore non definito");
                        }
                    } else {
                        throw new Exception("Soggetto erogatore non definito");
                    }
                    Utilities.setSQLStringValue((PreparedStatement)stmt, (int)8, (String)servizio.getSoggettoErogatore().getNome());
                    if (servizio.getTipoServizio() == null) {
                        throw new Exception("Tipo servizio non definito");
                    }
                    Utilities.setSQLStringValue((PreparedStatement)stmt, (int)9, (String)servizio.getTipoServizio());
                    if (servizio.getServizio() == null) {
                        throw new Exception("Nome servizio non definito");
                    }
                    Utilities.setSQLStringValue((PreparedStatement)stmt, (int)10, (String)servizio.getServizio());
                } else {
                    throw new Exception("IDServizio non definito");
                }
                Utilities.setSQLStringValue((PreparedStatement)stmt, (int)11, (String)servizio.getAzione());
                Utilities.setSQLStringValue((PreparedStatement)stmt, (int)12, (String)idCorrelazioneApplicativa);
                stmt.executeUpdate();
                stmt.close();
                Object var12_12 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!this.singleConnection) {
                    try {
                        con.close();
                    }
                    catch (Exception e) {}
                }
                break block36;
                {
                    catch (Exception e) {
                        throw new MsgDiagnosticoException("Errore durante la registrazione del msg diagnostico di correlazione: " + e.getMessage(), e);
                    }
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (!this.singleConnection) {
                        try {
                            con.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    public void logCorrelazioneServizioApplicativo(String idEGov, boolean delegata, String servizioApplicativo) throws MsgDiagnosticoException {
        block33: {
            if (writeCorrelazione) {
                Statement stmt = null;
                Connection con = null;
                ResultSet rs = null;
                if (!this.singleConnection) {
                    con = this.ds.getConnection();
                    if (con == null) {
                        throw new Exception("Connessione non fornita dal datasource [" + this.datasource + "]");
                    }
                } else {
                    con = connection;
                    if (con == null) {
                        throw new Exception("Connessione non fornita dal datasource [" + datasourceConnection + "]");
                    }
                }
                StringBuffer selectString = new StringBuffer("SELECT ");
                if (this.openspcoopProperties.isForceIndex()) {
                    selectString.append(" /*+ index(msgdiag_correlazione MSG_CORR_INDEX) */ ");
                }
                selectString.append(" id FROM msgdiag_correlazione WHERE idegov=? AND delegata=?");
                stmt = con.prepareStatement(selectString.toString());
                if (idEGov == null) {
                    throw new Exception("Identificativo eGov non definito");
                }
                Utilities.setSQLStringValue((PreparedStatement)stmt, (int)1, (String)idEGov);
                if (delegata) {
                    stmt.setInt(2, 1);
                } else {
                    stmt.setInt(2, 0);
                }
                long idCorrelazione = -1L;
                rs = stmt.executeQuery();
                if (rs.next()) {
                    idCorrelazione = rs.getLong("id");
                    if (idCorrelazione == -1L) {
                        throw new Exception("ID Correlazione non esistente");
                    }
                } else {
                    throw new Exception("Non esiste una correlazione con l'id[" + idEGov + "] e delegata[" + delegata + "]");
                }
                rs.close();
                stmt.close();
                String updateString = "INSERT INTO msgdiag_correlazione_sa (id_correlazione, servizio_applicativo) VALUES (?, ?)";
                stmt = con.prepareStatement(updateString);
                stmt.setLong(1, idCorrelazione);
                Utilities.setSQLStringValue((PreparedStatement)stmt, (int)2, (String)servizioApplicativo);
                stmt.executeUpdate();
                stmt.close();
                Object var12_11 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!this.singleConnection) {
                    try {
                        con.close();
                    }
                    catch (Exception e) {}
                }
                break block33;
                {
                    catch (Exception e) {
                        throw new MsgDiagnosticoException("Errore durante la registrazione del msg diagnostico di correlazione: " + e.getMessage(), e);
                    }
                }
                catch (Throwable throwable) {
                    Object var12_12 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (!this.singleConnection) {
                        try {
                            con.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    public void isAlive() throws DriverException {
        block19: {
            Connection con = null;
            Statement stmtTest = null;
            if (!this.singleConnection) {
                con = this.ds.getConnection();
                if (con == null) {
                    throw new Exception("Connessione non fornita dal datasource [" + this.datasource + "]");
                }
            } else {
                con = connection;
                if (con == null) {
                    throw new Exception("Connessione non fornita dal datasource [" + datasourceConnection + "]");
                }
            }
            stmtTest = con.createStatement();
            stmtTest.execute("SELECT * from db_info");
            Object var5_3 = null;
            try {
                if (stmtTest != null) {
                    stmtTest.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!this.singleConnection) {
                try {
                    con.close();
                }
                catch (Exception e) {}
            }
            break block19;
            {
                catch (Exception e) {
                    throw new DriverException("Connessione al database MsgDiagnostici non disponibile: " + e.getMessage(), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                try {
                    if (stmtTest != null) {
                        stmtTest.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!this.singleConnection) {
                    try {
                        con.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }
}

