/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.logger;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.openspcoop.dao.msgdiagnostico.MessaggioDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.utils.GestoreJNDI;
import org.openspcoop.utils.Utilities;

public class MsgDiagnosticoLog4JAppender
extends AppenderSkeleton {
    private static final String MSG_DIAGNOSTICI = "msgdiagnostici";
    private IUnmarshallingContext uctx = null;
    private PrintStream ps = null;
    private DataSource ds = null;
    private String dburl = "";
    private String dbuser = "";
    private String dbpw = "";
    private String filerej = "msgdiagnostici.rejected";
    private String dbdriver = "";
    private String dataSource = null;
    private String provider = null;

    public void setDBUrl(String dburl) {
        this.dburl = dburl;
    }

    public String getDBUrl() {
        return this.dburl;
    }

    public void setDBUser(String dbuser) {
        this.dbuser = dbuser;
    }

    public String getDBUser() {
        return this.dbuser;
    }

    public void setDBPwd(String dbpw) {
        this.dbpw = dbpw;
    }

    public String getDBPwd() {
        return this.dbpw;
    }

    public void setDBDriver(String dbdriver) {
        this.dbdriver = dbdriver;
    }

    public String getDBDriver() {
        return this.dbdriver;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setFileRejected(String filerej) {
        this.filerej = filerej;
    }

    public String getFileRejected() {
        return this.filerej;
    }

    public boolean requiresLayout() {
        return true;
    }

    public void activateOptions() {
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(MessaggioDiagnostico.class);
            this.uctx = bfact.createUnmarshallingContext();
        }
        catch (JiBXException e) {
            System.err.println("[MessaggioDiagnosticoAppender] Riscontrato errore durante la creazione del contesto di unmarshall:\n" + e.getMessage());
        }
        try {
            this.ps = new PrintStream(this.filerej);
        }
        catch (IOException ioe) {
            System.err.println("[MessaggioDiagnosticoAppender] IOException: " + ioe.getMessage());
        }
        if (this.dataSource != null) {
            try {
                Properties context = new Properties();
                if (this.provider != null) {
                    context.put("java.naming.provider.url", this.provider);
                }
                GestoreJNDI jndi = new GestoreJNDI(context);
                this.ds = (DataSource)jndi.lookup(this.dataSource);
            }
            catch (Exception e) {
                System.err.println("[MessaggioDiagnosticoAppender] Lookup DataSource Exception: " + e.getMessage());
            }
        } else {
            try {
                Class.forName(this.dbdriver);
            }
            catch (Exception ex) {
                System.err.println("[MessaggioDiagnosticoAppender] ClassNotFoundException: " + ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void append(LoggingEvent event) {
        block27: {
            Connection con;
            Logger log;
            block26: {
                log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
                String singleTrace = (String)event.getMessage();
                boolean procedi = true;
                if (singleTrace == null) break block27;
                ByteArrayInputStream sbis = null;
                MessaggioDiagnostico msgDiagXML = null;
                try {
                    sbis = new ByteArrayInputStream(singleTrace.getBytes());
                    msgDiagXML = (MessaggioDiagnostico)this.uctx.unmarshalDocument((InputStream)sbis, null);
                    try {
                        sbis.close();
                    }
                    catch (IOException ioe) {}
                }
                catch (Exception e) {
                    try {
                        sbis.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    if (singleTrace != null && !singleTrace.equals("") && !singleTrace.equals(" ")) {
                        log.error((Object)("[MessaggioDiagnosticoAppender] Riscontrato errore durante l'unmarshall del file di configurazione:\n" + e.getMessage()), (Throwable)e);
                        this.ps.println(singleTrace);
                    }
                    procedi = false;
                }
                con = null;
                if (procedi) {
                    try {
                        con = this.ds != null ? this.ds.getConnection() : DriverManager.getConnection(this.dburl, this.dbuser, this.dbpw);
                        if (con == null) {
                            throw new Exception("Connection is null");
                        }
                    }
                    catch (Exception ex) {
                        log.error((Object)("[MessaggioDiagnosticoAppender] GetConnection, SQLException: " + ex.getMessage()), (Throwable)ex);
                        this.ps.println(singleTrace);
                        procedi = false;
                    }
                }
                if (!procedi) break block27;
                Statement stmt = null;
                con.setAutoCommit(false);
                Date gdo = null;
                BigInteger severita = BigInteger.ZERO;
                String idporta = "";
                String idfunzione = "";
                String messaggio = "";
                gdo = msgDiagXML.getOraRegistrazione();
                idporta = msgDiagXML.getIdentificativoPorta();
                idfunzione = msgDiagXML.getIdentificativoFunzione();
                severita = msgDiagXML.getLivelloDiSeverita();
                messaggio = msgDiagXML.getTestoDiagnostico();
                String updateString = "INSERT INTO msgdiagnostici (gdo, idporta, idfunzione, severita, messaggio) VALUES (?, ?, ?, ?, ?)";
                stmt = con.prepareStatement(updateString);
                if (gdo != null) {
                    stmt.setTimestamp(1, new Timestamp(gdo.getTime() - 0x6DDD00L));
                } else {
                    stmt.setTimestamp(1, null);
                }
                Utilities.setSQLStringValue((PreparedStatement)stmt, (int)2, (String)idporta);
                Utilities.setSQLStringValue((PreparedStatement)stmt, (int)3, (String)idfunzione);
                stmt.setInt(4, severita.intValue());
                Utilities.setSQLStringValue((PreparedStatement)stmt, (int)5, (String)messaggio);
                stmt.executeUpdate();
                stmt.close();
                con.commit();
                con.setAutoCommit(true);
                Object var16_21 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    break block26;
                }
                catch (Exception e) {}
                break block26;
                {
                    catch (Exception ex) {
                        log.error((Object)("[MessaggioDiagnosticoAppender] Registrazione non riuscita: " + ex.getMessage()), (Throwable)ex);
                        this.ps.println(singleTrace);
                        Object var16_22 = null;
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                            break block26;
                        }
                        catch (Exception e) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var16_23 = null;
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            try {
                con.close();
            }
            catch (SQLException ex) {
                log.error((Object)("[MessaggioDiagnosticoAppender] Exception closing connection to DB " + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    public void close() {
        this.ps.close();
    }
}

