/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.logger;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.egov.Busta;
import org.openspcoop.egov.XMLBuilder;
import org.openspcoop.pdd.config.ConfigurazionePdDReader;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.logger.IMsgDiagnosticoOpenSPCoopAppender;
import org.openspcoop.pdd.logger.LogLevels;
import org.openspcoop.pdd.logger.MsgDiagnosticiProperties;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.utils.date.DateManager;

public class MsgDiagnostico {
    private Logger loggerMsgDiagnostico = null;
    private Logger loggerOpenSPCoop = null;
    private Logger loggerIntegrationManager = null;
    private Logger loggerOpenSPCoopFatal = null;
    private Vector<IMsgDiagnosticoOpenSPCoopAppender> loggerMsgDiagnosticoOpenSPCoopAppender = null;
    private Vector<String> tipoMsgDiagnosticoOpenSPCoopAppender = null;
    private String dominioSPCoop;
    private String idModulo;
    private String idEGovRichiesta;
    private String idEGovRisposta;
    private XMLBuilder xmlBuilder;
    private ConfigurazionePdDReader configurazionePdDReader;
    private MsgDiagnosticiProperties msgDiagPropertiesReader;
    private Hashtable<String, String> keywordLogPersonalizzati = null;
    private IDSoggetto fruitore;
    private IDServizio servizio;
    private String porta;
    private boolean delegata;
    private String servizioApplicativo;
    private String idCorrelazioneApplicativa;
    private String prefixMsgPersonalizzati = null;

    public MsgDiagnostico(String dominio, String modulo) {
        this.dominioSPCoop = dominio;
        this.idModulo = modulo;
        this.loggerMsgDiagnostico = OpenSPCoopLogger.loggerMsgDiagnostico;
        this.loggerOpenSPCoop = OpenSPCoopLogger.loggerOpenSPCoop;
        this.loggerIntegrationManager = OpenSPCoopLogger.loggerIntegrationManager;
        this.loggerOpenSPCoopFatal = OpenSPCoopLogger.loggerOpenSPCoopConsole;
        this.loggerMsgDiagnosticoOpenSPCoopAppender = OpenSPCoopLogger.loggerMsgDiagnosticoOpenSPCoopAppender;
        this.tipoMsgDiagnosticoOpenSPCoopAppender = OpenSPCoopLogger.tipoMsgDiagnosticoOpenSPCoopAppender;
        this.configurazionePdDReader = ConfigurazionePdDReader.getInstance();
        this.msgDiagPropertiesReader = MsgDiagnosticiProperties.getInstance();
        this.xmlBuilder = new XMLBuilder();
        this.keywordLogPersonalizzati = new Hashtable();
    }

    public MsgDiagnostico(String modulo) {
        this(OpenSPCoopProperties.getInstance().getIdentificativoPortaDefault(), modulo);
    }

    public void setDominioSPCoop(String dominio) {
        this.dominioSPCoop = dominio;
    }

    public void setFunzione(String modulo) {
        this.idModulo = modulo;
    }

    public String getFunzione() {
        return this.idModulo;
    }

    public void setIdEGovRichiesta(String idEGov) {
        this.idEGovRichiesta = idEGov;
    }

    public void setIdEGovRisposta(String idEGov) {
        this.idEGovRisposta = idEGov;
    }

    public void aggiornaFiltri() {
    }

    @Deprecated
    public String filter(String msg) {
        String xml = msg.replaceAll("&lt;", "<");
        xml = xml.replaceAll("&quot;", "\"");
        xml = xml.replaceAll("&gt;", ">");
        return xml;
    }

    public void setFruitore(IDSoggetto fruitore) {
        this.fruitore = fruitore;
    }

    public void setServizio(IDServizio servizio) {
        this.servizio = servizio;
    }

    public void setPorta(String porta) {
        this.porta = porta;
    }

    public void setDelegata(boolean delegata) {
        this.delegata = delegata;
    }

    public void setServizioApplicativo(String servizioApplicativo) {
        this.servizioApplicativo = servizioApplicativo;
    }

    public void setIdCorrelazioneApplicativa(String idCorrelazioneApplicativa) {
        this.idCorrelazioneApplicativa = idCorrelazioneApplicativa;
    }

    public void addKeyword(String key, String value) {
        if (key != null) {
            String tmpValue = value;
            if (tmpValue == null) {
                tmpValue = "";
            }
            if (this.keywordLogPersonalizzati.containsKey(key)) {
                this.keywordLogPersonalizzati.remove(key);
            }
            this.keywordLogPersonalizzati.put(key, tmpValue);
        }
    }

    public void addKeywords(Busta busta, boolean richiesta) {
        if (busta != null) {
            if (richiesta) {
                this.keywordLogPersonalizzati.put("@ID_EGOV_RICHIESTA@", busta.getID());
                if (busta.getProfiloDiCollaborazione() != null) {
                    this.keywordLogPersonalizzati.put("@PROFILO_COLLABORAZIONE@", busta.getProfiloDiCollaborazione());
                }
                this.keywordLogPersonalizzati.put("@TIPO_MITTENTE_BUSTA_RICHIESTA@", busta.getTipoMittente());
                this.keywordLogPersonalizzati.put("@MITTENTE_BUSTA_RICHIESTA@", busta.getMittente());
                this.keywordLogPersonalizzati.put("@TIPO_DESTINATARIO_BUSTA_RICHIESTA@", busta.getTipoDestinatario());
                this.keywordLogPersonalizzati.put("@DESTINATARIO_BUSTA_RICHIESTA@", busta.getDestinatario());
                if (busta.getTipoServizio() != null) {
                    this.keywordLogPersonalizzati.put("@TIPO_SERVIZIO_BUSTA_RICHIESTA@", busta.getTipoServizio());
                }
                if (busta.getServizio() != null) {
                    this.keywordLogPersonalizzati.put("@SERVIZIO_BUSTA_RICHIESTA@", busta.getServizio());
                }
                if (busta.getAzione() != null) {
                    this.keywordLogPersonalizzati.put("@AZIONE_BUSTA_RICHIESTA@", busta.getAzione());
                } else {
                    this.keywordLogPersonalizzati.put("@AZIONE_BUSTA_RICHIESTA@", "");
                }
                if (busta.getRiferimentoMessaggio() != null) {
                    this.keywordLogPersonalizzati.put("@RIFERIMENTO_MESSAGGIO_RICHIESTA@", busta.getRiferimentoMessaggio());
                }
                if (busta.getSequenza() > 0L) {
                    this.keywordLogPersonalizzati.put("@SEQUENZA@", busta.getSequenza() + "");
                }
                if (busta.getIndirizzoTelematicoMittente() != null) {
                    this.keywordLogPersonalizzati.put("@INDIRIZZO_TELEMATICO_MITTENTE_RICHIESTA@", busta.getIndirizzoTelematicoMittente());
                }
                if (busta.getIndirizzoTelematicoDestinatario() != null) {
                    this.keywordLogPersonalizzati.put("@INDIRIZZO_TELEMATICO_DESTINATARIO_RICHIESTA@", busta.getIndirizzoTelematicoDestinatario());
                }
                if (busta.getScadenza() != null) {
                    this.keywordLogPersonalizzati.put("@SCADENZA_BUSTA_RICHIESTA@", busta.getScadenza().toString());
                }
            } else {
                this.keywordLogPersonalizzati.put("@ID_EGOV_RISPOSTA@", busta.getID());
                if (busta.getProfiloDiCollaborazione() != null) {
                    this.keywordLogPersonalizzati.put("@PROFILO_COLLABORAZIONE@", busta.getProfiloDiCollaborazione());
                }
                this.keywordLogPersonalizzati.put("@TIPO_MITTENTE_BUSTA_RISPOSTA@", busta.getTipoMittente());
                this.keywordLogPersonalizzati.put("@MITTENTE_BUSTA_RISPOSTA@", busta.getMittente());
                this.keywordLogPersonalizzati.put("@TIPO_DESTINATARIO_BUSTA_RISPOSTA@", busta.getTipoDestinatario());
                this.keywordLogPersonalizzati.put("@DESTINATARIO_BUSTA_RISPOSTA@", busta.getDestinatario());
                if (busta.getTipoServizio() != null) {
                    this.keywordLogPersonalizzati.put("@TIPO_SERVIZIO_BUSTA_RISPOSTA@", busta.getTipoServizio());
                }
                if (busta.getServizio() != null) {
                    this.keywordLogPersonalizzati.put("@SERVIZIO_BUSTA_RISPOSTA@", busta.getServizio());
                }
                if (busta.getAzione() != null) {
                    this.keywordLogPersonalizzati.put("@AZIONE_BUSTA_RISPOSTA@", busta.getAzione());
                } else {
                    this.keywordLogPersonalizzati.put("@AZIONE_BUSTA_RISPOSTA@", "");
                }
                if (busta.getRiferimentoMessaggio() != null) {
                    this.keywordLogPersonalizzati.put("@RIFERIMENTO_MESSAGGIO_RISPOSTA@", busta.getRiferimentoMessaggio());
                }
                if (busta.getSequenza() > 0L) {
                    this.keywordLogPersonalizzati.put("@SEQUENZA@", busta.getSequenza() + "");
                }
                if (busta.getIndirizzoTelematicoMittente() != null) {
                    this.keywordLogPersonalizzati.put("@INDIRIZZO_TELEMATICO_MITTENTE_RISPOSTA@", busta.getIndirizzoTelematicoMittente());
                }
                if (busta.getIndirizzoTelematicoDestinatario() != null) {
                    this.keywordLogPersonalizzati.put("@INDIRIZZO_TELEMATICO_DESTINATARIO_RISPOSTA@", busta.getIndirizzoTelematicoDestinatario());
                }
                if (busta.getScadenza() != null) {
                    this.keywordLogPersonalizzati.put("@SCADENZA_BUSTA_RISPOSTA@", busta.getScadenza().toString());
                }
            }
        }
    }

    public void addKeywords(IDSoggetto soggettoFruitore) {
        this.addKeywords(soggettoFruitore, null, null);
    }

    public void addKeywords(IDServizio idServizio) {
        this.addKeywords(null, idServizio, null);
    }

    public void addKeywords(IDSoggetto soggettoFruitore, IDServizio idServizio, String idEgov) {
        if (idEgov != null) {
            this.keywordLogPersonalizzati.put("@ID_EGOV_RICHIESTA@", idEgov);
        }
        if (soggettoFruitore != null) {
            this.keywordLogPersonalizzati.put("@TIPO_MITTENTE_BUSTA_RICHIESTA@", soggettoFruitore.getTipo());
            this.keywordLogPersonalizzati.put("@MITTENTE_BUSTA_RICHIESTA@", soggettoFruitore.getNome());
        }
        if (idServizio != null) {
            if (idServizio.getSoggettoErogatore() != null) {
                this.keywordLogPersonalizzati.put("@TIPO_DESTINATARIO_BUSTA_RICHIESTA@", idServizio.getSoggettoErogatore().getTipo());
                this.keywordLogPersonalizzati.put("@DESTINATARIO_BUSTA_RICHIESTA@", idServizio.getSoggettoErogatore().getNome());
            }
            this.keywordLogPersonalizzati.put("@TIPO_SERVIZIO_BUSTA_RICHIESTA@", idServizio.getTipoServizio());
            this.keywordLogPersonalizzati.put("@SERVIZIO_BUSTA_RICHIESTA@", idServizio.getServizio());
            if (idServizio.getAzione() != null) {
                this.keywordLogPersonalizzati.put("@AZIONE_BUSTA_RICHIESTA@", idServizio.getAzione());
            }
        }
    }

    public String replaceKeywords(String msg) {
        StringBuffer bf = new StringBuffer();
        StringBuffer keyword = new StringBuffer();
        boolean separator = false;
        char separatorChar = '@';
        for (int i = 0; i < msg.length(); ++i) {
            char ch = msg.charAt(i);
            if (separatorChar == ch) {
                if (!separator) {
                    keyword.append(separatorChar);
                    separator = true;
                    continue;
                }
                keyword.append(separatorChar);
                bf.append(this.keywordLogPersonalizzati.get(keyword.toString()));
                keyword.delete(0, keyword.length());
                separator = false;
                continue;
            }
            if (separator) {
                keyword.append(ch);
                continue;
            }
            bf.append(ch);
        }
        return bf.toString();
    }

    public void setPrefixMsgPersonalizzati(String v) {
        this.prefixMsgPersonalizzati = v;
    }

    public int getLivello(String keyLivelloPersonalizzato) {
        return this.getLivello(this.prefixMsgPersonalizzati, keyLivelloPersonalizzato);
    }

    public int getLivello(String prefix, String keyLivelloPersonalizzato) {
        Integer livello = this.msgDiagPropertiesReader.getLivello(prefix, keyLivelloPersonalizzato);
        if (livello != null) {
            return livello;
        }
        return -1;
    }

    public String getMessaggio(String keyMsgPersonalizzato) {
        return this.getMessaggio(this.prefixMsgPersonalizzati, keyMsgPersonalizzato);
    }

    public String getMessaggio(String prefix, String keyMsgPersonalizzato) {
        String msgTmp = this.msgDiagPropertiesReader.getMessaggio(prefix, keyMsgPersonalizzato);
        if (msgTmp == null) {
            msgTmp = "Messaggio diagnostico [" + prefix + "." + keyMsgPersonalizzato + "] non definito nella configurazione della porta di dominio??";
        }
        return msgTmp;
    }

    public void logCorrelazione() {
        if (Integer.MIN_VALUE != this.configurazionePdDReader.getSeveritaSPCoop_msgDiagnostici()) {
            try {
                for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                    try {
                        this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).logCorrelazione(this.idEGovRichiesta, DateManager.getDate(), this.porta, this.delegata, this.fruitore, this.servizio, this.idCorrelazioneApplicativa);
                        continue;
                    }
                    catch (Exception e) {
                        OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante l'emissione del msg diagnostico di correlazione [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage()), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("MsgDiagnostico.logCorrelazione error " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void logCorrelazioneServizioApplicativo() {
        if (Integer.MIN_VALUE != this.configurazionePdDReader.getSeveritaSPCoop_msgDiagnostici()) {
            try {
                for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                    try {
                        this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).logCorrelazioneServizioApplicativo(this.idEGovRichiesta, this.delegata, this.servizioApplicativo);
                        continue;
                    }
                    catch (Exception e) {
                        OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante l'emissione del msg diagnostico di correlazione [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage()), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("MsgDiagnostico.logCorrelazione error " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void logPersonalizzato(String messaggio, int livelloLog) {
        block15: {
            if (messaggio == null) {
                OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)"MsgDiagnostico.logPersonalizzato error, messaggio non definito.");
                return;
            }
            int severitaLogEmessoPerFiltro = livelloLog;
            int severitaLivelloCNIPA = LogLevels.toIntervalloCNIPA(livelloLog);
            if (severitaLivelloCNIPA < 0 || severitaLivelloCNIPA > 7) {
                OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("MsgDiagnostico.logPersonalizzato error, conversione a livello CNIPA non riuscita [" + severitaLivelloCNIPA + "]"));
                return;
            }
            Level logLevelseveritaLivelloCNIPA = LogLevels.toOpenSPCoop(severitaLivelloCNIPA);
            int severitaSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaSPCoop_msgDiagnostici());
            int severitaOpenSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaOpenSPCoop_msgDiagnostici());
            try {
                String msgReplaceKey = null;
                if (severitaLogEmessoPerFiltro <= severitaSPCoopRichiestaPdD) {
                    msgReplaceKey = this.replaceKeywords(messaggio);
                    if (OpenSPCoopLogger.loggerMsgDiagnosticoAbilitato) {
                        String xml = this.xmlBuilder.buildString_Diagnostico(this.dominioSPCoop, this.idModulo, severitaLivelloCNIPA, msgReplaceKey);
                        try {
                            this.loggerMsgDiagnostico.log((Priority)logLevelseveritaLivelloCNIPA, (Object)xml);
                        }
                        catch (Exception e) {
                            OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante l'emissione del msg diagnostico 'spcoop': " + e.getMessage()), (Throwable)e);
                        }
                    }
                    for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                        try {
                            this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(DateManager.getDate(), this.dominioSPCoop, this.idModulo, severitaLivelloCNIPA, msgReplaceKey, this.idEGovRichiesta, this.idEGovRisposta);
                            continue;
                        }
                        catch (Exception e) {
                            OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage()), (Throwable)e);
                        }
                    }
                }
                boolean humanReadableAbilitato = false;
                humanReadableAbilitato = "IntegrationManager".equals(this.idModulo) ? OpenSPCoopLogger.loggerIntegrationManagerAbilitato : OpenSPCoopLogger.loggerMsgDiagnosticoReadableAbilitato;
                if (!humanReadableAbilitato || severitaLogEmessoPerFiltro > severitaOpenSPCoopRichiestaPdD) break block15;
                if (msgReplaceKey == null) {
                    msgReplaceKey = this.replaceKeywords(messaggio);
                }
                String message = OpenSPCoopLogger.humanReadable(this.dominioSPCoop, this.idModulo, severitaLivelloCNIPA, msgReplaceKey, this.idEGovRichiesta, this.idCorrelazioneApplicativa, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo);
                try {
                    if ("IntegrationManager".equals(this.idModulo)) {
                        this.loggerIntegrationManager.log((Priority)logLevelseveritaLivelloCNIPA, (Object)message);
                        break block15;
                    }
                    this.loggerOpenSPCoop.log((Priority)logLevelseveritaLivelloCNIPA, (Object)message);
                }
                catch (Exception e) {
                    OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage()), (Throwable)e);
                }
            }
            catch (Exception e) {
                OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("MsgDiagnostico.logPersonalizzato error " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void logErroreGenerico(Exception e, String posizioneErrore) {
        String msg = null;
        msg = e instanceof NullPointerException ? "NullPointerException" : e.getMessage();
        this.logErroreGenerico(msg, posizioneErrore);
    }

    public void logErroreGenerico(String message, String posizioneErrore) {
        this.addKeyword("@ERRORE_PROCESSAMENTO@", message);
        this.addKeyword("@POSIZIONE_ERRORE@", posizioneErrore);
        this.logPersonalizzato(this.getMessaggio("all.", "erroreGenerico"), this.getLivello("all.", "erroreGenerico"));
    }

    public void fatalOpenSPCoop(String msg) {
        block13: {
            int severitaLogEmessoPerFiltro = LogLevels.toIntervalloOpenSPCoop(0);
            int severitaSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaSPCoop_msgDiagnostici());
            int severitaOpenSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaOpenSPCoop_msgDiagnostici());
            try {
                if (severitaLogEmessoPerFiltro <= severitaSPCoopRichiestaPdD) {
                    if (OpenSPCoopLogger.loggerMsgDiagnosticoAbilitato) {
                        String xml = this.xmlBuilder.buildString_Diagnostico(this.dominioSPCoop, this.idModulo, 0, msg);
                        try {
                            this.loggerMsgDiagnostico.log((Priority)LogLevels.LOG_LEVEL_FATAL_OPENSPCOOP, (Object)xml);
                        }
                        catch (Exception e) {
                            OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante l'emissione del msg diagnostico 'spcoop': " + e.getMessage()), (Throwable)e);
                        }
                    }
                    for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                        try {
                            this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(DateManager.getDate(), this.dominioSPCoop, this.idModulo, 0, msg, this.idEGovRichiesta, this.idEGovRisposta);
                            continue;
                        }
                        catch (Exception e) {
                            OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage()), (Throwable)e);
                        }
                    }
                }
                boolean humanReadableAbilitato = false;
                humanReadableAbilitato = "IntegrationManager".equals(this.idModulo) ? OpenSPCoopLogger.loggerIntegrationManagerAbilitato : OpenSPCoopLogger.loggerMsgDiagnosticoReadableAbilitato;
                if (!humanReadableAbilitato || severitaLogEmessoPerFiltro > severitaOpenSPCoopRichiestaPdD) break block13;
                String message = OpenSPCoopLogger.humanReadable(this.dominioSPCoop, this.idModulo, 0, msg, this.idEGovRichiesta, this.idCorrelazioneApplicativa, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo);
                try {
                    if ("IntegrationManager".equals(this.idModulo)) {
                        this.loggerIntegrationManager.log((Priority)LogLevels.LOG_LEVEL_FATAL_OPENSPCOOP, (Object)message);
                    } else {
                        this.loggerOpenSPCoop.log((Priority)LogLevels.LOG_LEVEL_FATAL_OPENSPCOOP, (Object)message);
                    }
                }
                catch (Exception e) {
                    OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage()), (Throwable)e);
                }
                this.loggerOpenSPCoopFatal.log((Priority)LogLevels.LOG_LEVEL_FATAL_OPENSPCOOP, (Object)message);
            }
            catch (Exception e) {
                OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("MsgDiagnostico.fatalOpenSPCoop error " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void errorSPCoop(String msg) {
        block12: {
            int severitaLogEmessoPerFiltro = LogLevels.toIntervalloOpenSPCoop(1);
            int severitaSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaSPCoop_msgDiagnostici());
            int severitaOpenSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaOpenSPCoop_msgDiagnostici());
            try {
                if (severitaLogEmessoPerFiltro <= severitaSPCoopRichiestaPdD) {
                    if (OpenSPCoopLogger.loggerMsgDiagnosticoAbilitato) {
                        String xml = this.xmlBuilder.buildString_Diagnostico(this.dominioSPCoop, this.idModulo, 1, msg);
                        try {
                            this.loggerMsgDiagnostico.log((Priority)LogLevels.LOG_LEVEL_ERROR_SPCOOP, (Object)xml);
                        }
                        catch (Exception e) {
                            OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante l'emissione del msg diagnostico 'spcoop': " + e.getMessage()), (Throwable)e);
                        }
                    }
                    for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                        try {
                            this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(DateManager.getDate(), this.dominioSPCoop, this.idModulo, 1, msg, this.idEGovRichiesta, this.idEGovRisposta);
                            continue;
                        }
                        catch (Exception e) {
                            OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage()), (Throwable)e);
                        }
                    }
                }
                boolean humanReadableAbilitato = false;
                humanReadableAbilitato = "IntegrationManager".equals(this.idModulo) ? OpenSPCoopLogger.loggerIntegrationManagerAbilitato : OpenSPCoopLogger.loggerMsgDiagnosticoReadableAbilitato;
                if (!humanReadableAbilitato || severitaLogEmessoPerFiltro > severitaOpenSPCoopRichiestaPdD) break block12;
                String message = OpenSPCoopLogger.humanReadable(this.dominioSPCoop, this.idModulo, 1, msg, this.idEGovRichiesta, this.idCorrelazioneApplicativa, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo);
                try {
                    if ("IntegrationManager".equals(this.idModulo)) {
                        this.loggerIntegrationManager.log((Priority)LogLevels.LOG_LEVEL_ERROR_SPCOOP, (Object)message);
                        break block12;
                    }
                    this.loggerOpenSPCoop.log((Priority)LogLevels.LOG_LEVEL_ERROR_SPCOOP, (Object)message);
                }
                catch (Exception e) {
                    OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage()), (Throwable)e);
                }
            }
            catch (Exception e) {
                OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("MsgDiagnostico.errorSPCoop error " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void errorOpenSPCoop(String msg) {
        block12: {
            int severitaLogEmessoPerFiltro = LogLevels.toIntervalloOpenSPCoop(2);
            int severitaSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaSPCoop_msgDiagnostici());
            int severitaOpenSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaOpenSPCoop_msgDiagnostici());
            try {
                if (severitaLogEmessoPerFiltro <= severitaSPCoopRichiestaPdD) {
                    if (OpenSPCoopLogger.loggerMsgDiagnosticoAbilitato) {
                        String xml = this.xmlBuilder.buildString_Diagnostico(this.dominioSPCoop, this.idModulo, 2, msg);
                        try {
                            this.loggerMsgDiagnostico.log((Priority)LogLevels.LOG_LEVEL_ERROR_OPENSPCOOP, (Object)xml);
                        }
                        catch (Exception e) {
                            OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante l'emissione del msg diagnostico 'spcoop': " + e.getMessage()), (Throwable)e);
                        }
                    }
                    for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                        try {
                            this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(DateManager.getDate(), this.dominioSPCoop, this.idModulo, 2, msg, this.idEGovRichiesta, this.idEGovRisposta);
                            continue;
                        }
                        catch (Exception e) {
                            OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage()), (Throwable)e);
                        }
                    }
                }
                boolean humanReadableAbilitato = false;
                humanReadableAbilitato = "IntegrationManager".equals(this.idModulo) ? OpenSPCoopLogger.loggerIntegrationManagerAbilitato : OpenSPCoopLogger.loggerMsgDiagnosticoReadableAbilitato;
                if (!humanReadableAbilitato || severitaLogEmessoPerFiltro > severitaOpenSPCoopRichiestaPdD) break block12;
                String message = OpenSPCoopLogger.humanReadable(this.dominioSPCoop, this.idModulo, 2, msg, this.idEGovRichiesta, this.idCorrelazioneApplicativa, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo);
                try {
                    if ("IntegrationManager".equals(this.idModulo)) {
                        this.loggerIntegrationManager.log((Priority)LogLevels.LOG_LEVEL_ERROR_OPENSPCOOP, (Object)message);
                        break block12;
                    }
                    this.loggerOpenSPCoop.log((Priority)LogLevels.LOG_LEVEL_ERROR_OPENSPCOOP, (Object)message);
                }
                catch (Exception e) {
                    OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage()), (Throwable)e);
                }
            }
            catch (Exception e) {
                OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("MsgDiagnostico.errorOpenSPCoop error " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void infoSPCoop(String msg) {
        block12: {
            int severitaLogEmessoPerFiltro = LogLevels.toIntervalloOpenSPCoop(3);
            int severitaSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaSPCoop_msgDiagnostici());
            int severitaOpenSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaOpenSPCoop_msgDiagnostici());
            try {
                if (severitaLogEmessoPerFiltro <= severitaSPCoopRichiestaPdD) {
                    if (OpenSPCoopLogger.loggerMsgDiagnosticoAbilitato) {
                        String xml = this.xmlBuilder.buildString_Diagnostico(this.dominioSPCoop, this.idModulo, 3, msg);
                        try {
                            this.loggerMsgDiagnostico.log((Priority)LogLevels.LOG_LEVEL_INFO_SPCOOP, (Object)xml);
                        }
                        catch (Exception e) {
                            OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante l'emissione del msg diagnostico 'spcoop': " + e.getMessage()), (Throwable)e);
                        }
                    }
                    for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                        try {
                            this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(DateManager.getDate(), this.dominioSPCoop, this.idModulo, 3, msg, this.idEGovRichiesta, this.idEGovRisposta);
                            continue;
                        }
                        catch (Exception e) {
                            OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage()), (Throwable)e);
                        }
                    }
                }
                boolean humanReadableAbilitato = false;
                humanReadableAbilitato = "IntegrationManager".equals(this.idModulo) ? OpenSPCoopLogger.loggerIntegrationManagerAbilitato : OpenSPCoopLogger.loggerMsgDiagnosticoReadableAbilitato;
                if (!humanReadableAbilitato || severitaLogEmessoPerFiltro > severitaOpenSPCoopRichiestaPdD) break block12;
                String message = OpenSPCoopLogger.humanReadable(this.dominioSPCoop, this.idModulo, 3, msg, this.idEGovRichiesta, this.idCorrelazioneApplicativa, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo);
                try {
                    if ("IntegrationManager".equals(this.idModulo)) {
                        this.loggerIntegrationManager.log((Priority)LogLevels.LOG_LEVEL_INFO_SPCOOP, (Object)message);
                        break block12;
                    }
                    this.loggerOpenSPCoop.log((Priority)LogLevels.LOG_LEVEL_INFO_SPCOOP, (Object)message);
                }
                catch (Exception e) {
                    OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage()), (Throwable)e);
                }
            }
            catch (Exception e) {
                OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("MsgDiagnostico.infoSPCoop error " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void infoOpenSPCoop(String msg) {
        block12: {
            int severitaLogEmessoPerFiltro = LogLevels.toIntervalloOpenSPCoop(4);
            int severitaSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaSPCoop_msgDiagnostici());
            int severitaOpenSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaOpenSPCoop_msgDiagnostici());
            try {
                if (severitaLogEmessoPerFiltro <= severitaSPCoopRichiestaPdD) {
                    if (OpenSPCoopLogger.loggerMsgDiagnosticoAbilitato) {
                        String xml = this.xmlBuilder.buildString_Diagnostico(this.dominioSPCoop, this.idModulo, 4, msg);
                        try {
                            this.loggerMsgDiagnostico.log((Priority)LogLevels.LOG_LEVEL_INFO_OPENSPCOOP, (Object)xml);
                        }
                        catch (Exception e) {
                            OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante l'emissione del msg diagnostico 'spcoop': " + e.getMessage()), (Throwable)e);
                        }
                    }
                    for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                        try {
                            this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(DateManager.getDate(), this.dominioSPCoop, this.idModulo, 4, msg, this.idEGovRichiesta, this.idEGovRisposta);
                            continue;
                        }
                        catch (Exception e) {
                            OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage()), (Throwable)e);
                        }
                    }
                }
                boolean humanReadableAbilitato = false;
                humanReadableAbilitato = "IntegrationManager".equals(this.idModulo) ? OpenSPCoopLogger.loggerIntegrationManagerAbilitato : OpenSPCoopLogger.loggerMsgDiagnosticoReadableAbilitato;
                if (!humanReadableAbilitato || severitaLogEmessoPerFiltro > severitaOpenSPCoopRichiestaPdD) break block12;
                String message = OpenSPCoopLogger.humanReadable(this.dominioSPCoop, this.idModulo, 4, msg, this.idEGovRichiesta, this.idCorrelazioneApplicativa, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo);
                try {
                    if ("IntegrationManager".equals(this.idModulo)) {
                        this.loggerIntegrationManager.log((Priority)LogLevels.LOG_LEVEL_INFO_OPENSPCOOP, (Object)message);
                        break block12;
                    }
                    this.loggerOpenSPCoop.log((Priority)LogLevels.LOG_LEVEL_INFO_OPENSPCOOP, (Object)message);
                }
                catch (Exception e) {
                    OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage()), (Throwable)e);
                }
            }
            catch (Exception e) {
                OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("MsgDiagnostico.infoOpenSPCoop error " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void lowDebug(String msg) {
        block12: {
            int severitaLogEmessoPerFiltro = LogLevels.toIntervalloOpenSPCoop(5);
            int severitaSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaSPCoop_msgDiagnostici());
            int severitaOpenSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaOpenSPCoop_msgDiagnostici());
            try {
                if (severitaLogEmessoPerFiltro <= severitaSPCoopRichiestaPdD) {
                    if (OpenSPCoopLogger.loggerMsgDiagnosticoAbilitato) {
                        String xml = this.xmlBuilder.buildString_Diagnostico(this.dominioSPCoop, this.idModulo, 5, msg);
                        try {
                            this.loggerMsgDiagnostico.log((Priority)LogLevels.LOG_LEVEL_DEBUG_LOW, (Object)xml);
                        }
                        catch (Exception e) {
                            OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante l'emissione del msg diagnostico 'spcoop': " + e.getMessage()), (Throwable)e);
                        }
                    }
                    for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                        try {
                            this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(DateManager.getDate(), this.dominioSPCoop, this.idModulo, 5, msg, this.idEGovRichiesta, this.idEGovRisposta);
                            continue;
                        }
                        catch (Exception e) {
                            OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage()), (Throwable)e);
                        }
                    }
                }
                boolean humanReadableAbilitato = false;
                humanReadableAbilitato = "IntegrationManager".equals(this.idModulo) ? OpenSPCoopLogger.loggerIntegrationManagerAbilitato : OpenSPCoopLogger.loggerMsgDiagnosticoReadableAbilitato;
                if (!humanReadableAbilitato || severitaLogEmessoPerFiltro > severitaOpenSPCoopRichiestaPdD) break block12;
                String message = OpenSPCoopLogger.humanReadable(this.dominioSPCoop, this.idModulo, 5, msg, this.idEGovRichiesta, this.idCorrelazioneApplicativa, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo);
                try {
                    if ("IntegrationManager".equals(this.idModulo)) {
                        this.loggerIntegrationManager.log((Priority)LogLevels.LOG_LEVEL_DEBUG_LOW, (Object)message);
                        break block12;
                    }
                    this.loggerOpenSPCoop.log((Priority)LogLevels.LOG_LEVEL_DEBUG_LOW, (Object)message);
                }
                catch (Exception e) {
                    OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage()), (Throwable)e);
                }
            }
            catch (Exception e) {
                OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("MsgDiagnostico.lowDebug error " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void mediumDebug(String msg) {
        block12: {
            int severitaLogEmessoPerFiltro = LogLevels.toIntervalloOpenSPCoop(6);
            int severitaSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaSPCoop_msgDiagnostici());
            int severitaOpenSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaOpenSPCoop_msgDiagnostici());
            try {
                if (severitaLogEmessoPerFiltro <= severitaSPCoopRichiestaPdD) {
                    if (OpenSPCoopLogger.loggerMsgDiagnosticoAbilitato) {
                        String xml = this.xmlBuilder.buildString_Diagnostico(this.dominioSPCoop, this.idModulo, 6, msg);
                        try {
                            this.loggerMsgDiagnostico.log((Priority)LogLevels.LOG_LEVEL_DEBUG_MEDIUM, (Object)xml);
                        }
                        catch (Exception e) {
                            OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante l'emissione del msg diagnostico 'spcoop': " + e.getMessage()), (Throwable)e);
                        }
                    }
                    for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                        try {
                            this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(DateManager.getDate(), this.dominioSPCoop, this.idModulo, 6, msg, this.idEGovRichiesta, this.idEGovRisposta);
                            continue;
                        }
                        catch (Exception e) {
                            OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage()), (Throwable)e);
                        }
                    }
                }
                boolean humanReadableAbilitato = false;
                humanReadableAbilitato = "IntegrationManager".equals(this.idModulo) ? OpenSPCoopLogger.loggerIntegrationManagerAbilitato : OpenSPCoopLogger.loggerMsgDiagnosticoReadableAbilitato;
                if (!humanReadableAbilitato || severitaLogEmessoPerFiltro > severitaOpenSPCoopRichiestaPdD) break block12;
                String message = OpenSPCoopLogger.humanReadable(this.dominioSPCoop, this.idModulo, 6, msg, this.idEGovRichiesta, this.idCorrelazioneApplicativa, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo);
                try {
                    if ("IntegrationManager".equals(this.idModulo)) {
                        this.loggerIntegrationManager.log((Priority)LogLevels.LOG_LEVEL_DEBUG_MEDIUM, (Object)message);
                        break block12;
                    }
                    this.loggerOpenSPCoop.log((Priority)LogLevels.LOG_LEVEL_DEBUG_MEDIUM, (Object)message);
                }
                catch (Exception e) {
                    OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage()), (Throwable)e);
                }
            }
            catch (Exception e) {
                OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("MsgDiagnostico.mediumDebug error " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void highDebug(String msg) {
        block12: {
            int severitaLogEmessoPerFiltro = LogLevels.toIntervalloOpenSPCoop(7);
            int severitaSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaSPCoop_msgDiagnostici());
            int severitaOpenSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaOpenSPCoop_msgDiagnostici());
            try {
                if (severitaLogEmessoPerFiltro <= severitaSPCoopRichiestaPdD) {
                    if (OpenSPCoopLogger.loggerMsgDiagnosticoAbilitato) {
                        String xml = this.xmlBuilder.buildString_Diagnostico(this.dominioSPCoop, this.idModulo, 7, msg);
                        try {
                            this.loggerMsgDiagnostico.log((Priority)LogLevels.LOG_LEVEL_DEBUG_HIGH, (Object)xml);
                        }
                        catch (Exception e) {
                            OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante l'emissione del msg diagnostico 'spcoop': " + e.getMessage()), (Throwable)e);
                        }
                    }
                    for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                        try {
                            this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(DateManager.getDate(), this.dominioSPCoop, this.idModulo, 7, msg, this.idEGovRichiesta, this.idEGovRisposta);
                            continue;
                        }
                        catch (Exception e) {
                            OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage()), (Throwable)e);
                        }
                    }
                }
                boolean humanReadableAbilitato = false;
                humanReadableAbilitato = "IntegrationManager".equals(this.idModulo) ? OpenSPCoopLogger.loggerIntegrationManagerAbilitato : OpenSPCoopLogger.loggerMsgDiagnosticoReadableAbilitato;
                if (!humanReadableAbilitato || severitaLogEmessoPerFiltro > severitaOpenSPCoopRichiestaPdD) break block12;
                String message = OpenSPCoopLogger.humanReadable(this.dominioSPCoop, this.idModulo, 7, msg, this.idEGovRichiesta, this.idCorrelazioneApplicativa, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo);
                try {
                    if ("IntegrationManager".equals(this.idModulo)) {
                        this.loggerIntegrationManager.log((Priority)LogLevels.LOG_LEVEL_DEBUG_HIGH, (Object)message);
                        break block12;
                    }
                    this.loggerOpenSPCoop.log((Priority)LogLevels.LOG_LEVEL_DEBUG_HIGH, (Object)message);
                }
                catch (Exception e) {
                    OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage()), (Throwable)e);
                }
            }
            catch (Exception e) {
                OpenSPCoopLogger.loggerOpenSPCoopCore.error((Object)("MsgDiagnostico.highDebug error " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

