/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.logger;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import javax.activation.DataHandler;
import org.apache.axis.Message;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.log4j.Logger;
import org.openspcoop.pdd.config.MailcapActivationReader;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.utils.date.DateManager;

public class Dump {
    private Logger loggerDump = null;
    private String dominioSPCoop;
    private String idModulo;
    private String idEGov;
    private String signature;

    public Dump(String dominio, String modulo, String idEGov) {
        this.dominioSPCoop = dominio;
        this.idModulo = modulo;
        this.idEGov = idEGov;
        this.loggerDump = OpenSPCoopLogger.loggerDump;
        this.signature = this.dominioSPCoop + " <" + DateManager.getDate() + "> " + this.idModulo + ".\n";
    }

    public void dumpRichiestaMessage(byte[] msg) {
        try {
            this.loggerDump.info((Object)(this.signature + "Messaggio di richiesta con identificativo [" + this.idEGov + "]:\n" + new String(msg)));
        }
        catch (Exception e) {
            this.loggerDump.error((Object)("Riscontrato errore durante il dump del messaggio con identificativo [" + this.idEGov + "]:" + e));
        }
    }

    public void dumpRichiestaMessage(Message msg) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)stream);
            this.loggerDump.info((Object)(this.signature + "Messaggio di richiesta con identificativo [" + this.idEGov + "]:\n" + stream.toString()));
        }
        catch (Exception e) {
            this.loggerDump.error((Object)("Riscontrato errore durante il dump del messaggio con identificativo [" + this.idEGov + "]:" + e));
        }
    }

    public void dumpRichiesta(byte[] msg) {
        this.dump("richiesta", msg);
    }

    public void dumpRichiesta(Message msg) {
        this.dump("richiesta", msg);
    }

    public void dumpRispostaMessage(byte[] msg) {
        try {
            this.loggerDump.info((Object)(this.signature + "Messaggio di risposta relativa alla richiesta con identificativo [" + this.idEGov + "]:\n" + new String(msg)));
        }
        catch (Exception e) {
            this.loggerDump.error((Object)("Riscontrato errore durante il dump del messaggio con identificativo [" + this.idEGov + "]:" + e));
        }
    }

    public void dumpRispostaMessage(Message msg) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)stream);
            this.loggerDump.info((Object)(this.signature + "Messaggio di risposta relativa alla richiesta con identificativo [" + this.idEGov + "]:\n" + stream.toString()));
        }
        catch (Exception e) {
            this.loggerDump.error((Object)("Riscontrato errore durante il dump del messaggio con identificativo [" + this.idEGov + "]:" + e));
        }
    }

    public void dumpRisposta(byte[] msg) {
        this.dump("risposta", msg);
    }

    public void dumpRisposta(Message msg) {
        this.dump("risposta", msg);
    }

    public void dumpIntegrationManagerGetMessage(Message msg) {
        this.dump("integrationManagerGetMessage", msg);
    }

    private void dump(String tipoMessaggio, Message msg) {
        try {
            StringBuffer out = new StringBuffer();
            out.append(this.signature);
            out.append("Messaggio di " + tipoMessaggio + " con identificativo [");
            out.append(this.idEGov);
            out.append("] \n");
            out.append("------ SOAPEnvelope ------\n");
            out.append(msg.getSOAPEnvelope().getAsString() + "\n");
            Collection c = msg.getAttachmentsImpl().getAttachments();
            for (AttachmentPart ap : c) {
                if (ap.getContentId() != null) {
                    out.append("------ Attachment id[" + ap.getContentId() + "]------\n");
                } else if (ap.getContentLocation() != null) {
                    out.append("------ Attachment location[" + ap.getContentLocation() + "]------\n");
                }
                out.append("Id[" + ap.getContentId() + "] location[" + ap.getContentLocation() + "] type[" + ap.getContentType() + "]: ");
                DataHandler dh = ap.getDataHandler();
                InputStream inputDH = dh.getInputStream();
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                byte[] readB = new byte[8192];
                int readByte = 0;
                while ((readByte = inputDH.read(readB)) != -1) {
                    bout.write(readB, 0, readByte);
                }
                inputDH.close();
                bout.flush();
                bout.close();
                out.append(bout.toString());
                if (MailcapActivationReader.existsDataContentHandler(ap.getContentType())) {
                    ap.setDataHandler(new DataHandler((Object)bout.toByteArray(), ap.getContentType()));
                }
                out.append("\n");
            }
            this.loggerDump.info((Object)out.toString());
        }
        catch (Exception e) {
            this.loggerDump.error((Object)("Riscontrato errore durante il dump del messaggio con identificativo [" + this.idEGov + "]:" + e));
        }
    }

    private void dump(String tipoMessaggio, byte[] msg) {
        try {
            StringBuffer out = new StringBuffer();
            out.append(this.signature);
            out.append("Messaggio di " + tipoMessaggio + " con identificativo [");
            out.append(this.idEGov);
            out.append("]\n");
            out.append(new String(msg));
            out.append("\n");
            this.loggerDump.info((Object)out.toString());
        }
        catch (Exception e) {
            this.loggerDump.error((Object)("Riscontrato errore durante il dump del messaggio con identificativo [" + this.idEGov + "]:" + e));
        }
    }
}

