/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.logger;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.openspcoop.egov.Busta;
import org.openspcoop.egov.Eccezione;
import org.openspcoop.egov.Riscontro;
import org.openspcoop.egov.Trasmissione;
import org.openspcoop.pdd.logger.DriverMSGDiagnosticiException;
import org.openspcoop.pdd.logger.DriverTracciamentoException;
import org.openspcoop.pdd.logger.IDriverTracciamento;
import org.openspcoop.pdd.logger.dto.Traccia;
import org.openspcoop.utils.sql.ISQLQueryObject;
import org.openspcoop.utils.sql.SQLObjectFactory;
import org.openspcoop.utils.sql.SQLQueryObjectException;

public class DriverTracciamento
implements IDriverTracciamento {
    DataSource datasource = null;
    Connection connection = null;
    String tipoDatabase = null;
    private Logger log = null;

    public DriverTracciamento(String nomeDataSource, String tipoDatabase, Properties prop, Logger log) throws DriverMSGDiagnosticiException {
        try {
            this.log = log;
        }
        catch (Exception e) {
            throw new DriverMSGDiagnosticiException("Errore durante l'inizializzazione del logger...", e);
        }
        try {
            this.log.info((Object)"Inizializzo DriverLogAnalyzer...");
            InitialContext initCtx = new InitialContext(prop);
            this.datasource = (DataSource)initCtx.lookup(nomeDataSource);
            if (this.datasource == null) {
                throw new Exception("datasource is null");
            }
            initCtx.close();
            this.log.info((Object)"Inizializzo DriverLogAnalyzer terminata.");
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante la ricerca del datasource...", (Throwable)e);
            throw new DriverMSGDiagnosticiException("Errore durante la ricerca del datasource...", e);
        }
        try {
            this.log.info((Object)"Inizializzo ISQLQueryObject...");
            if (!("postgresql".equals(tipoDatabase) || "mysql".equals(tipoDatabase) || "oracle".equals(tipoDatabase))) {
                throw new Exception("Tipo database non gestito");
            }
            this.tipoDatabase = tipoDatabase;
            this.log.info((Object)"Inizializzo ISQLQueryObject terminata.");
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante la ricerca del SQLQueryObject...", (Throwable)e);
            throw new DriverMSGDiagnosticiException("Errore durante la ricerca del SQLQueryObject...", e);
        }
    }

    public DriverTracciamento(Connection connection, String tipoDatabase, Logger log) throws DriverMSGDiagnosticiException {
        try {
            this.log = log;
        }
        catch (Exception e) {
            throw new DriverMSGDiagnosticiException("Errore durante l'inizializzazione del logger...", e);
        }
        this.connection = connection;
        try {
            this.log.info((Object)"Inizializzo ISQLQueryObject...");
            if (!("postgresql".equals(tipoDatabase) || "mysql".equals(tipoDatabase) || "oracle".equals(tipoDatabase))) {
                throw new Exception("Tipo database non gestito");
            }
            this.tipoDatabase = tipoDatabase;
            this.log.info((Object)"Inizializzo ISQLQueryObject terminata.");
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante la ricerca del SQLQueryObject...", (Throwable)e);
            throw new DriverMSGDiagnosticiException("Errore durante la ricerca del SQLQueryObject...", e);
        }
    }

    public Traccia getTraccia(String idEGov, String identificativoPorta) throws DriverTracciamentoException, SQLQueryObjectException {
        return this.getTraccia(idEGov, identificativoPorta, false);
    }

    public Traccia getTracciaPerRiferimentoMessaggio(String riferimentoMessaggio, String identificativoPorta) throws DriverTracciamentoException, SQLQueryObjectException {
        return this.getTraccia(riferimentoMessaggio, identificativoPorta, true);
    }

    private ISQLQueryObject getSQLQueryObject() throws SQLQueryObjectException {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
        return sqlQueryObject;
    }

    /*
     * Loose catch block
     */
    private Traccia getTraccia(String idEGov, String identificativoPorta, boolean rifMsg) throws DriverTracciamentoException, SQLQueryObjectException {
        Connection connectionDB = null;
        Statement pstmt = null;
        ResultSet rs = null;
        Statement pstmtLista = null;
        ResultSet rsLista = null;
        Traccia tr = null;
        if (this.connection != null) {
            connectionDB = this.connection;
        } else {
            connectionDB = this.datasource.getConnection();
            if (connectionDB == null) {
                throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
            }
        }
        ISQLQueryObject sqlQueryObject = this.getSQLQueryObject();
        sqlQueryObject.addFromTable("tracce");
        sqlQueryObject.addSelectField("*");
        if (rifMsg) {
            sqlQueryObject.addWhereCondition("rif_messaggio=?");
        } else {
            sqlQueryObject.addWhereCondition("id_egov=?");
        }
        sqlQueryObject.addWhereCondition("idporta=?");
        sqlQueryObject.setANDLogicOperator(true);
        pstmt = connectionDB.prepareStatement(sqlQueryObject.toString());
        pstmt.setString(1, idEGov);
        pstmt.setString(2, identificativoPorta);
        rs = pstmt.executeQuery();
        if (rs.next()) {
            tr = new Traccia();
            tr.setGdo(rs.getTimestamp("gdo"));
            tr.setIdporta(rs.getString("idporta"));
            tr.setTipoMessaggio(rs.getString("tipo_messaggio"));
            Busta busta = new Busta();
            if (rs.getString("tipo_mittente") != null && !"".equals(rs.getString("tipo_mittente"))) {
                busta.setTipoMittente(rs.getString("tipo_mittente"));
            }
            if (rs.getString("mittente") != null && !"".equals(rs.getString("mittente"))) {
                busta.setMittente(rs.getString("mittente"));
            }
            if (rs.getString("indtelematico_mitt") != null && !"".equals(rs.getString("indtelematico_mitt"))) {
                busta.setIndirizzoTelematicoMittente(rs.getString("indtelematico_mitt"));
            }
            if (rs.getString("tipo_destinatario") != null && !"".equals(rs.getString("tipo_destinatario"))) {
                busta.setTipoDestinatario(rs.getString("tipo_destinatario"));
            }
            if (rs.getString("destinatario") != null && !"".equals(rs.getString("destinatario"))) {
                busta.setDestinatario(rs.getString("destinatario"));
            }
            if (rs.getString("indtelematico_dest") != null && !"".equals(rs.getString("indtelematico_dest"))) {
                busta.setIndirizzoTelematicoDestinatario(rs.getString("indtelematico_dest"));
            }
            if (rs.getString("profilo_collaborazione") != null && !"".equals(rs.getString("profilo_collaborazione"))) {
                busta.setProfiloDiCollaborazione(rs.getString("profilo_collaborazione"));
            }
            if (rs.getString("servizio_correlato") != null && !"".equals(rs.getString("servizio_correlato"))) {
                busta.setServizioCorrelato(rs.getString("servizio_correlato"));
            }
            if (rs.getString("tipo_servizio_correlato") != null && !"".equals(rs.getString("tipo_servizio_correlato"))) {
                busta.setTipoServizioCorrelato(rs.getString("tipo_servizio_correlato"));
            }
            if (rs.getString("collaborazione") != null && !"".equals(rs.getString("collaborazione"))) {
                busta.setCollaborazione(rs.getString("collaborazione"));
            }
            if (rs.getString("servizio") != null && !"".equals(rs.getString("servizio"))) {
                busta.setServizio(rs.getString("servizio"));
            }
            if (rs.getString("tipo_servizio") != null && !"".equals(rs.getString("tipo_servizio"))) {
                busta.setTipoServizio(rs.getString("tipo_servizio"));
            }
            if (rs.getString("azione") != null && !"".equals(rs.getString("azione"))) {
                busta.setAzione(rs.getString("azione"));
            }
            if (rs.getString("id_egov") != null && !"".equals(rs.getString("id_egov"))) {
                busta.setID(rs.getString("id_egov"));
            }
            if (rs.getTimestamp("ora_registrazione") != null) {
                busta.setOraRegistrazione((Date)rs.getTimestamp("ora_registrazione"));
            }
            if (rs.getString("tipo_ora_reg") != null && !"".equals(rs.getString("tipo_ora_reg"))) {
                busta.setTipoOraRegistrazione(rs.getString("tipo_ora_reg"));
            }
            if (rs.getString("rif_messaggio") != null && !"".equals(rs.getString("rif_messaggio"))) {
                busta.setRiferimentoMessaggio(rs.getString("rif_messaggio"));
            }
            if (rs.getTimestamp("scadenza") != null) {
                busta.setScadenza((Date)rs.getTimestamp("scadenza"));
            }
            if (rs.getString("inoltro") != null && !"".equals(rs.getString("inoltro"))) {
                busta.setInoltro(rs.getString("inoltro"));
            }
            if (rs.getInt("conferma_ricezione") == 1) {
                busta.setConfermaRicezione(true);
            } else {
                busta.setConfermaRicezione(false);
            }
            if (rs.getLong("sequenza") > 0L) {
                busta.setSequenza(rs.getLong("sequenza"));
            }
            long idTraccia = rs.getLong("id");
            sqlQueryObject = this.getSQLQueryObject();
            sqlQueryObject.addFromTable("tracce_trasmissioni");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("idtraccia=?");
            sqlQueryObject.setANDLogicOperator(true);
            pstmtLista = connectionDB.prepareStatement(sqlQueryObject.toString());
            pstmtLista.setLong(1, idTraccia);
            rsLista = pstmtLista.executeQuery();
            while (rsLista.next()) {
                Trasmissione trtr = new Trasmissione();
                if (rsLista.getString("origine") != null && !"".equals(rsLista.getString("origine"))) {
                    trtr.setOrigine(rsLista.getString("origine"));
                }
                if (rsLista.getString("tipo_origine") != null && !"".equals(rsLista.getString("tipo_origine"))) {
                    trtr.setTipoOrigine(rsLista.getString("tipo_origine"));
                }
                if (rsLista.getString("indtelematico_orig") != null && !"".equals(rsLista.getString("indtelematico_orig"))) {
                    trtr.setIndirizzoTelematicoOrigine(rsLista.getString("indtelematico_orig"));
                }
                if (rsLista.getString("destinazione") != null && !"".equals(rsLista.getString("destinazione"))) {
                    trtr.setDestinazione(rsLista.getString("destinazione"));
                }
                if (rsLista.getString("tipo_destinazione") != null && !"".equals(rsLista.getString("tipo_destinazione"))) {
                    trtr.setTipoDestinazione(rsLista.getString("tipo_destinazione"));
                }
                if (rsLista.getString("indtel_destinazione") != null && !"".equals(rsLista.getString("indtel_destinazione"))) {
                    trtr.setIndirizzoTelematicoDestinazione(rsLista.getString("indtel_destinazione"));
                }
                if (rsLista.getTimestamp("ora_registrazione") != null) {
                    trtr.setOraRegistrazione((Date)rsLista.getTimestamp("ora_registrazione"));
                }
                if (rsLista.getString("tipo_ora_registrazione") != null && !"".equals(rsLista.getString("tipo_ora_registrazione"))) {
                    trtr.setTempo(rsLista.getString("tipo_ora_registrazione"));
                }
                busta.addTrasmissione(trtr);
            }
            rsLista.close();
            pstmtLista.close();
            sqlQueryObject = this.getSQLQueryObject();
            sqlQueryObject.addFromTable("tracce_eccezioni");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("idtraccia=?");
            sqlQueryObject.setANDLogicOperator(true);
            pstmtLista = connectionDB.prepareStatement(sqlQueryObject.toString());
            pstmtLista.setLong(1, idTraccia);
            rsLista = pstmtLista.executeQuery();
            while (rsLista.next()) {
                Eccezione trec = new Eccezione();
                if (rsLista.getString("contesto_codifica") != null && !"".equals(rsLista.getString("contesto_codifica"))) {
                    trec.setContestoCodifica(rsLista.getString("contesto_codifica"));
                }
                if (rsLista.getString("codice_eccezione") != null && !"".equals(rsLista.getString("codice_eccezione"))) {
                    trec.setCodiceEccezione(rsLista.getString("codice_eccezione"));
                }
                if (rsLista.getString("rilevanza") != null && !"".equals(rsLista.getString("rilevanza"))) {
                    trec.setRilevanza(rsLista.getString("rilevanza"));
                }
                if (rsLista.getString("posizione") != null && !"".equals(rsLista.getString("posizione"))) {
                    trec.setPosizione(rsLista.getString("posizione"));
                }
                busta.addEccezione(trec);
            }
            rsLista.close();
            pstmtLista.close();
            sqlQueryObject = this.getSQLQueryObject();
            sqlQueryObject.addFromTable("tracce_riscontri");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("idtraccia=?");
            sqlQueryObject.setANDLogicOperator(true);
            pstmtLista = connectionDB.prepareStatement(sqlQueryObject.toString());
            pstmtLista.setLong(1, idTraccia);
            rsLista = pstmtLista.executeQuery();
            while (rsLista.next()) {
                Riscontro trris = new Riscontro();
                if (rsLista.getString("riscontro") != null && !"".equals(rsLista.getString("riscontro"))) {
                    trris.setID(rsLista.getString("riscontro"));
                }
                if (rsLista.getTimestamp("ora_registrazione") != null) {
                    trris.setOraRegistrazione((Date)rsLista.getTimestamp("ora_registrazione"));
                }
                if (rsLista.getString("tipo_ora_reg") != null && !"".equals(rsLista.getString("tipo_ora_reg"))) {
                    trris.setTipoOraRegistrazione(rsLista.getString("tipo_ora_reg"));
                }
                busta.addRiscontro(trris);
            }
            rsLista.close();
            pstmtLista.close();
            tr.setBusta(busta);
        }
        rs.close();
        pstmt.close();
        Traccia traccia = tr;
        Object var16_15 = null;
        try {
            rsLista.close();
        }
        catch (Exception eClose) {
            // empty catch block
        }
        try {
            pstmtLista.close();
        }
        catch (Exception eClose) {
            // empty catch block
        }
        try {
            rs.close();
        }
        catch (Exception eClose) {
            // empty catch block
        }
        try {
            pstmt.close();
        }
        catch (Exception eClose) {
            // empty catch block
        }
        try {
            if (this.connection == null) {
                connectionDB.close();
            }
        }
        catch (Exception eClose) {
            // empty catch block
        }
        return traccia;
        catch (Exception e) {
            try {
                throw new DriverTracciamentoException("Tracciamento exception: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                Object var16_16 = null;
                try {
                    rsLista.close();
                }
                catch (Exception eClose) {
                    // empty catch block
                }
                try {
                    pstmtLista.close();
                }
                catch (Exception eClose) {
                    // empty catch block
                }
                try {
                    rs.close();
                }
                catch (Exception eClose) {
                    // empty catch block
                }
                try {
                    pstmt.close();
                }
                catch (Exception eClose) {
                    // empty catch block
                }
                try {
                    if (this.connection == null) {
                        connectionDB.close();
                    }
                }
                catch (Exception eClose) {}
                throw throwable;
            }
        }
    }
}

