/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.logger;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.pdd.logger.DriverMSGDiagnosticiException;
import org.openspcoop.pdd.logger.IDriverMSGDiagnostici;
import org.openspcoop.pdd.logger.LogLevels;
import org.openspcoop.pdd.logger.dto.Egov;
import org.openspcoop.pdd.logger.dto.FilterSearch;
import org.openspcoop.pdd.logger.dto.MsgDiagnostico;
import org.openspcoop.pdd.logger.dto.MsgDiagnosticoCorrelazione;
import org.openspcoop.pdd.logger.dto.MsgDiagnosticoCorrelazioneList;
import org.openspcoop.pdd.logger.dto.MsgDiagnosticoList;
import org.openspcoop.utils.sql.ISQLQueryObject;
import org.openspcoop.utils.sql.SQLObjectFactory;
import org.openspcoop.utils.sql.SQLQueryObjectException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverMSGDiagnostici
implements IDriverMSGDiagnostici {
    DataSource datasource = null;
    String tipoDatabase = null;
    Connection con = null;
    private Logger log = null;

    public DriverMSGDiagnostici(String nomeDataSource, String tipoDatabase, Properties prop) throws DriverMSGDiagnosticiException {
        try {
            this.log = Logger.getLogger((String)"DRIVER_DB_LOGANALIZER");
        }
        catch (Exception e) {
            throw new DriverMSGDiagnosticiException("Errore durante l'inizializzazione del logger...", e);
        }
        try {
            this.log.info((Object)"Inizializzo DriverLogAnalyzer...");
            InitialContext initCtx = new InitialContext(prop);
            this.datasource = (DataSource)initCtx.lookup(nomeDataSource);
            if (this.datasource == null) {
                throw new Exception("datasource is null");
            }
            initCtx.close();
            this.log.info((Object)"Inizializzo DriverLogAnalyzer terminata.");
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante la ricerca del datasource...", (Throwable)e);
            throw new DriverMSGDiagnosticiException("Errore durante la ricerca del datasource...", e);
        }
        try {
            this.log.info((Object)"Inizializzo ISQLQueryObject...");
            if (!("postgresql".equals(tipoDatabase) || "mysql".equals(tipoDatabase) || "oracle".equals(tipoDatabase))) {
                throw new Exception("Tipo database non gestito");
            }
            this.tipoDatabase = tipoDatabase;
            this.log.info((Object)"Inizializzo ISQLQueryObject terminata.");
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante la ricerca del SQLQueryObject...", (Throwable)e);
            throw new DriverMSGDiagnosticiException("Errore durante la ricerca del SQLQueryObject...", e);
        }
    }

    public DriverMSGDiagnostici(Connection connection, String tipoDatabase, Logger log) throws DriverMSGDiagnosticiException {
        try {
            this.log = log;
        }
        catch (Exception e) {
            throw new DriverMSGDiagnosticiException("Errore durante l'inizializzazione del logger...", e);
        }
        this.con = connection;
        try {
            this.log.info((Object)"Inizializzo ISQLQueryObject...");
            if (!("postgresql".equals(tipoDatabase) || "mysql".equals(tipoDatabase) || "oracle".equals(tipoDatabase))) {
                throw new Exception("Tipo database non gestito");
            }
            this.tipoDatabase = tipoDatabase;
            this.log.info((Object)"Inizializzo ISQLQueryObject terminata.");
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante la ricerca del SQLQueryObject...", (Throwable)e);
            throw new DriverMSGDiagnosticiException("Errore durante la ricerca del SQLQueryObject...", e);
        }
    }

    @Override
    public MsgDiagnosticoList getListaLog(FilterSearch filter) throws DriverMSGDiagnosticiException {
        if (filter == null) {
            throw new DriverMSGDiagnosticiException("Parametro di ricerca non valido.");
        }
        String idEgov = filter.getIdEgov();
        if (idEgov == null || "".equals(idEgov)) {
            throw new DriverMSGDiagnosticiException("Parametro idEgov non valido.");
        }
        String idPorta = filter.getIdentificativoPorta();
        return this.getListaLogByIdEgov(idEgov, idPorta, (int)filter.getLimit(), (int)filter.getOffset());
    }

    /*
     * Loose catch block
     */
    private String[] getMSGDiagnosticoCorrelazioneSA(long idCorrelazione) throws DriverMSGDiagnosticiException, SQLQueryObjectException {
        Statement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        boolean closeConnection = true;
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
        sqlQueryObject.addFromTable("msgdiag_correlazione_sa");
        sqlQueryObject.addWhereCondition("id_correlazione='" + idCorrelazione + "'");
        ArrayList<String> listaNomeSA = new ArrayList<String>();
        if (this.con != null) {
            con = this.con;
            closeConnection = false;
        } else {
            con = this.datasource.getConnection();
            if (con == null) {
                throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
            }
        }
        stmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
        rs = stmt.executeQuery();
        while (rs.next()) {
            listaNomeSA.add(rs.getString("servizio_applicativo"));
        }
        rs.close();
        stmt.close();
        String[] stringArray = listaNomeSA.toArray(new String[listaNomeSA.size()]);
        Object var11_10 = null;
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        if (closeConnection) {
            try {
                con.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        return stringArray;
        catch (Exception e) {
            try {
                throw new DriverMSGDiagnosticiException(e);
            }
            catch (Throwable throwable) {
                block21: {
                    Object var11_11 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    if (!closeConnection) break block21;
                    try {
                        con.close();
                    }
                    catch (Exception e2) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    private MsgDiagnosticoList getListaLogByIdEgov(String idEgov, String identificativoPorta, int limit, int offset) throws DriverMSGDiagnosticiException {
        if (idEgov == null || "".equals(idEgov)) {
            throw new DriverMSGDiagnosticiException("idEgov non valido.");
        }
        Statement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        boolean closeConnection = true;
        ISQLQueryObject sqlObj = null;
        ArrayList<MsgDiagnostico> listaMSGDiagnostici = new ArrayList<MsgDiagnostico>();
        if (this.con != null) {
            con = this.con;
            closeConnection = false;
        } else {
            con = this.datasource.getConnection();
            if (con == null) {
                throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
            }
        }
        sqlObj = this.createSQLQueryObj(idEgov, identificativoPorta, limit, offset);
        this.log.debug((Object)("Eseguo query : " + sqlObj.createSQLQuery()));
        stmt = con.prepareStatement(sqlObj.createSQLQuery());
        stmt.setString(1, idEgov);
        if (identificativoPorta != null && !"".equals(identificativoPorta)) {
            stmt.setString(2, identificativoPorta);
        }
        rs = stmt.executeQuery();
        while (rs.next()) {
            MsgDiagnostico loggedEntry = new MsgDiagnostico();
            Timestamp gdo = rs.getTimestamp("gdo");
            Calendar cal = Calendar.getInstance();
            cal.setTime(gdo);
            loggedEntry.setGdo(cal);
            loggedEntry.setIdEgov(idEgov);
            loggedEntry.setIdFunzione(rs.getString("idfunzione"));
            loggedEntry.setIdPorta(rs.getString("idporta"));
            loggedEntry.setMessaggio(rs.getString("messaggio"));
            loggedEntry.setSeverita(LogLevels.toStringValue(rs.getInt("severita")));
            loggedEntry.setIdEgovRisposta(rs.getString("idegov_risposta"));
            listaMSGDiagnostici.add(loggedEntry);
        }
        rs.close();
        stmt.close();
        MsgDiagnosticoList entryList = new MsgDiagnosticoList();
        entryList.setTotEntry(this.getTotMSGDiagnosticiByIdEgov(idEgov, identificativoPorta));
        entryList.setMsgDiagnosticoList(listaMSGDiagnostici.toArray(new MsgDiagnostico[listaMSGDiagnostici.size()]));
        MsgDiagnosticoList msgDiagnosticoList = entryList;
        Object var15_15 = null;
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        if (closeConnection) {
            try {
                con.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        return msgDiagnosticoList;
        catch (Exception e) {
            try {
                throw new DriverMSGDiagnosticiException(e);
            }
            catch (Throwable throwable) {
                block23: {
                    Object var15_16 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    if (!closeConnection) break block23;
                    try {
                        con.close();
                    }
                    catch (Exception e2) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    private List<MsgDiagnosticoCorrelazione> getInfoEntryCorrelazione(FilterSearch filter, boolean all) throws DriverMSGDiagnosticiException, SQLQueryObjectException {
        Statement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        boolean closeConnection = true;
        if (this.con != null) {
            con = this.con;
            closeConnection = false;
        } else {
            con = this.datasource.getConnection();
            if (con == null) {
                throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
            }
        }
        String sqlQuery = "";
        if (all) {
            sqlQuery = this.createUnionObj(filter);
        } else {
            ISQLQueryObject sqlQueryObject = this.createSQLQueryObjCorrelazione(filter, false);
            sqlQueryObject.setLimit((int)filter.getLimit());
            sqlQueryObject.setOffset((int)filter.getOffset());
            sqlQuery = sqlQueryObject.createSQLQuery();
        }
        this.log.debug((Object)("eseguo query  :" + sqlQuery));
        stmt = con.prepareStatement(sqlQuery);
        int numRipetizioni = 1;
        if (all) {
            numRipetizioni = filter.isPartial() ? 2 : 3;
        }
        int count = 1;
        for (int j = 1; j <= numRipetizioni; ++j) {
            if (filter.getDataInizio() != null) {
                stmt.setTimestamp(count, new Timestamp(filter.getDataInizio().getTimeInMillis()));
                ++count;
            }
            if (filter.getDataFine() != null) {
                stmt.setTimestamp(count, new Timestamp(filter.getDataFine().getTimeInMillis()));
                ++count;
            }
            if (j == 2 || filter.getIdEgov() == null || "".equals(filter.getIdEgov())) continue;
            stmt.setString(count, filter.getIdEgov());
            ++count;
        }
        ArrayList<MsgDiagnosticoCorrelazione> listaMSGCorrelazione = new ArrayList<MsgDiagnosticoCorrelazione>();
        long[] offsetMap = new long[]{0L, 0L, 0L};
        if (filter.getOffsetMap() != null) {
            offsetMap = filter.getOffsetMap();
        }
        rs = stmt.executeQuery();
        while (rs.next()) {
            MsgDiagnosticoCorrelazione entry = new MsgDiagnosticoCorrelazione();
            entry.setId(rs.getLong("id"));
            entry.setIdEgov(rs.getString("idegov"));
            Timestamp gdo = rs.getTimestamp("gdo");
            Calendar cal = Calendar.getInstance();
            cal.setTime(gdo);
            entry.setGdo(cal);
            entry.setCorrelazioneApplicativa(rs.getString("id_correlazione_applicativa"));
            String tipo_servizio = rs.getString("tipo_servizio");
            if (tipo_servizio != null) {
                offsetMap[0] = offsetMap[0] + 1L;
                entry.setNomePorta(rs.getString("porta"));
                IDSoggetto fruitore = new IDSoggetto(rs.getString("tipo_fruitore"), rs.getString("fruitore"));
                IDSoggetto erogatore = new IDSoggetto(rs.getString("tipo_erogatore"), rs.getString("erogatore"));
                IDServizio servizio = new IDServizio(erogatore);
                servizio.setServizio(rs.getString("servizio"));
                servizio.setTipoServizio(rs.getString("tipo_servizio"));
                Egov egov = new Egov();
                egov.setAzione(rs.getString("azione"));
                egov.setErogatore(erogatore);
                egov.setFruitore(fruitore);
                egov.setServizio(servizio);
                entry.setInformazioniEgov(egov);
                entry.setDelegata(rs.getInt("delegata") == 1);
                entry.setServiziApplicativiList(this.getMSGDiagnosticoCorrelazioneSA(rs.getLong("id")));
            } else if (entry.getIdEgov() == null || "".equals(entry)) {
                offsetMap[1] = offsetMap[1] + 1L;
            } else {
                offsetMap[2] = offsetMap[2] + 1L;
            }
            listaMSGCorrelazione.add(entry);
        }
        rs.close();
        stmt.close();
        this.log.debug((Object)("offsetmap[correlati]: " + offsetMap[0]));
        this.log.debug((Object)("offsetmap[diagnostici]: " + offsetMap[1]));
        this.log.debug((Object)("offsetmap[notexist]: " + offsetMap[2]));
        filter.setOffsetMap(offsetMap);
        ArrayList<MsgDiagnosticoCorrelazione> arrayList = listaMSGCorrelazione;
        Object var21_23 = null;
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        if (closeConnection) {
            try {
                con.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        return arrayList;
        catch (Exception e) {
            try {
                throw new DriverMSGDiagnosticiException(e);
            }
            catch (Throwable throwable) {
                block32: {
                    Object var21_24 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    if (!closeConnection) break block32;
                    try {
                        con.close();
                    }
                    catch (Exception e2) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    private int getTotMSGDiagnosticiByIdEgov(String idEgov, String idPorta) throws DriverMSGDiagnosticiException, SQLQueryObjectException {
        Statement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        boolean closeConnection = true;
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
        sqlQueryObject.addSelectCountField("id", "totMSG");
        sqlQueryObject.addFromTable("msgdiagnostici");
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addWhereCondition("idegov=?");
        if (idPorta != null && !"".equals(idPorta)) {
            sqlQueryObject.addWhereCondition("idporta=?");
        }
        if (this.con != null) {
            con = this.con;
            closeConnection = false;
        } else {
            con = this.datasource.getConnection();
            if (con == null) {
                throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
            }
        }
        stmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
        stmt.setString(1, idEgov);
        if (idPorta != null && !"".equals(idPorta)) {
            stmt.setString(2, idPorta);
        }
        int totMSG = 0;
        rs = stmt.executeQuery();
        if (rs.next()) {
            totMSG = rs.getInt("totMSG");
        }
        rs.close();
        stmt.close();
        this.log.debug((Object)("getTotMSGDiagnosticiByIdEgov : idegov[" + idEgov + "] tot[" + totMSG + "]"));
        int n = totMSG;
        Object var11_11 = null;
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        if (closeConnection) {
            try {
                con.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        return n;
        catch (Exception e) {
            try {
                throw new DriverMSGDiagnosticiException(e);
            }
            catch (Throwable throwable) {
                block23: {
                    Object var11_12 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    if (!closeConnection) break block23;
                    try {
                        con.close();
                    }
                    catch (Exception e2) {}
                }
                throw throwable;
            }
        }
    }

    private ISQLQueryObject createSQLQueryObj(String idEgov, String identificativoPorta, int limit, int offset) throws SQLQueryObjectException {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
        sqlQueryObject.addSelectField("gdo");
        sqlQueryObject.addSelectField("idporta");
        sqlQueryObject.addSelectField("idfunzione");
        sqlQueryObject.addSelectField("severita");
        sqlQueryObject.addSelectField("messaggio");
        sqlQueryObject.addSelectField("idegov");
        sqlQueryObject.addSelectField("idegov_risposta");
        sqlQueryObject.addFromTable("msgdiagnostici");
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addWhereCondition(true, new String[]{"msgdiagnostici.idegov=?"});
        if (identificativoPorta != null && !"".equals(identificativoPorta)) {
            sqlQueryObject.addWhereCondition(true, new String[]{"msgdiagnostici.idporta=?"});
        }
        if (limit > 0) {
            sqlQueryObject.setLimit(limit);
        } else {
            sqlQueryObject.setLimit(1000);
        }
        if (offset > 0) {
            sqlQueryObject.setOffset(offset);
        }
        sqlQueryObject.addOrderBy("gdo");
        sqlQueryObject.setSortType(true);
        return sqlQueryObject;
    }

    private String createUnionObj(FilterSearch filter) throws SQLQueryObjectException {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
        sqlQueryObject.addOrderBy("gdo");
        sqlQueryObject.setSortType(false);
        sqlQueryObject.setLimit((int)filter.getLimit());
        if (filter.isPartial()) {
            return sqlQueryObject.createSQLUnion(false, new ISQLQueryObject[]{this.createSQLQueryObjCorrelazione(filter, true), this.createSqlQueryObjDiagnostici(filter, true)});
        }
        return sqlQueryObject.createSQLUnion(false, new ISQLQueryObject[]{this.createSQLQueryObjCorrelazione(filter, true), this.createSqlQueryObjDiagnostici(filter, true), this.createQueryObjDiagnosticiNotExist(filter, true)});
    }

    private ISQLQueryObject createSQLQueryObjCorrelazione(FilterSearch filter, boolean setLimit) throws SQLQueryObjectException {
        Egov egov;
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
        sqlQueryObject.addFromTable("msgdiag_correlazione");
        if (filter.getServizioApplicativo() != null && !"".equals(filter.getServizioApplicativo())) {
            sqlQueryObject.addFromTable("msgdiag_correlazione_sa");
        }
        sqlQueryObject.addSelectField("msgdiag_correlazione", "idegov");
        sqlQueryObject.addSelectField("msgdiag_correlazione", "gdo");
        sqlQueryObject.addSelectField("msgdiag_correlazione", "porta");
        sqlQueryObject.addSelectField("msgdiag_correlazione", "delegata");
        sqlQueryObject.addSelectField("msgdiag_correlazione", "tipo_fruitore");
        sqlQueryObject.addSelectField("msgdiag_correlazione", "fruitore");
        sqlQueryObject.addSelectField("msgdiag_correlazione", "tipo_erogatore");
        sqlQueryObject.addSelectField("msgdiag_correlazione", "erogatore");
        sqlQueryObject.addSelectField("msgdiag_correlazione", "tipo_servizio");
        sqlQueryObject.addSelectField("msgdiag_correlazione", "servizio");
        sqlQueryObject.addSelectField("msgdiag_correlazione", "azione");
        sqlQueryObject.addSelectField("msgdiag_correlazione", "id");
        sqlQueryObject.addSelectField("msgdiag_correlazione", "id_correlazione_applicativa");
        sqlQueryObject.addSelectAliasField("null", "idporta");
        sqlQueryObject.addSelectAliasField("null", "idfunzione");
        sqlQueryObject.addSelectAliasField("null", "severita");
        sqlQueryObject.addSelectAliasField("null", "idegov_risposta");
        sqlQueryObject.addSelectAliasField("null", "messaggio");
        sqlQueryObject.setANDLogicOperator(true);
        if (filter.getDataInizio() != null) {
            sqlQueryObject.addWhereCondition("msgdiag_correlazione.gdo>=?");
        }
        if (filter.getDataFine() != null) {
            sqlQueryObject.addWhereCondition("msgdiag_correlazione.gdo<=?");
        }
        if (filter.getIdEgov() != null && !"".equals(filter.getIdEgov())) {
            sqlQueryObject.addWhereCondition("msgdiag_correlazione.idegov=?");
        }
        if (filter.getNomePorta() != null && !"".equals(filter.getNomePorta())) {
            sqlQueryObject.addWhereCondition("msgdiag_correlazione.porta='" + filter.getNomePorta() + "'");
        }
        if (filter.isDelegata() != null) {
            sqlQueryObject.addWhereCondition("msgdiag_correlazione.delegata=" + (filter.isDelegata() != false ? 1 : 0));
        }
        if (filter.getCorrelazioneApplicativa() != null && !"".equals(filter.getCorrelazioneApplicativa())) {
            sqlQueryObject.addWhereLikeCondition("msgdiag_correlazione.id_correlazione_applicativa", filter.getCorrelazioneApplicativa(), true, true);
        }
        if (filter.getServizioApplicativo() != null && !"".equals(filter.getServizioApplicativo())) {
            sqlQueryObject.addWhereCondition("msgdiag_correlazione.id=msgdiag_correlazione_sa.id_correlazione");
            sqlQueryObject.addWhereCondition("msgdiag_correlazione_sa.servizio_applicativo='" + filter.getServizioApplicativo() + "'");
        }
        if ((egov = filter.getEgov()) != null) {
            if (egov.getFruitore() != null) {
                if (egov.getFruitore().getTipo() != null && !"".equals(egov.getFruitore().getTipo())) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.tipo_fruitore='" + egov.getFruitore().getTipo() + "'");
                }
                if (egov.getFruitore().getNome() != null && !"".equals(egov.getFruitore().getNome())) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.fruitore='" + egov.getFruitore().getNome() + "'");
                }
            }
            if (egov.getErogatore() != null) {
                if (egov.getErogatore().getTipo() != null && !"".equals(egov.getErogatore().getTipo())) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.tipo_erogatore='" + egov.getErogatore().getTipo() + "'");
                }
                if (egov.getErogatore().getNome() != null && !"".equals(egov.getErogatore().getNome())) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.erogatore='" + egov.getErogatore().getNome() + "'");
                }
            }
            if (egov.getServizio() != null) {
                if (egov.getServizio().getTipoServizio() != null && !"".equals(egov.getServizio().getTipoServizio())) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.tipo_servizio='" + egov.getServizio().getTipoServizio() + "'");
                }
                if (egov.getServizio().getServizio() != null && !"".equals(egov.getServizio().getServizio())) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.servizio='" + egov.getServizio().getServizio() + "'");
                }
            }
            if (egov.getAzione() != null && !"".equals(egov.getAzione())) {
                sqlQueryObject.addWhereCondition("msgdiag_correlazione.azione='" + egov.getAzione() + "'");
            }
        }
        sqlQueryObject.addOrderBy("gdo");
        sqlQueryObject.setSortType(false);
        if (setLimit) {
            sqlQueryObject.setLimit((int)filter.getLimit());
            this.log.debug((Object)("Limit :" + filter.getLimit()));
            long offset = filter.getOffsetMap() != null && filter.getOffsetMap().length > 2 ? filter.getOffsetMap()[0] : 0L;
            this.log.debug((Object)("Offset : " + offset));
            sqlQueryObject.setOffset((int)offset);
        }
        return sqlQueryObject;
    }

    private ISQLQueryObject createSqlQueryObjDiagnostici(FilterSearch filter, boolean setLimit) throws SQLQueryObjectException {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
        sqlQueryObject.addSelectField("idegov");
        sqlQueryObject.addSelectField("gdo");
        sqlQueryObject.addSelectAliasField("null", "porta");
        sqlQueryObject.addSelectAliasField("null", "delegata");
        sqlQueryObject.addSelectAliasField("null", "tipo_fruitore");
        sqlQueryObject.addSelectAliasField("null", "fruitore");
        sqlQueryObject.addSelectAliasField("null", "tipo_erogatore");
        sqlQueryObject.addSelectAliasField("null", "erogatore");
        sqlQueryObject.addSelectAliasField("null", "tipo_servizio");
        sqlQueryObject.addSelectAliasField("null", "servizio");
        sqlQueryObject.addSelectAliasField("null", "azione");
        sqlQueryObject.addSelectField("id");
        sqlQueryObject.addSelectAliasField("null", "id_correlazione_applicativa");
        sqlQueryObject.addSelectField("idporta");
        sqlQueryObject.addSelectField("idfunzione");
        sqlQueryObject.addSelectField("severita");
        sqlQueryObject.addSelectField("idegov_risposta");
        sqlQueryObject.addSelectField("messaggio");
        sqlQueryObject.addFromTable("msgdiagnostici");
        sqlQueryObject.setANDLogicOperator(true);
        if (filter.getDataInizio() != null) {
            sqlQueryObject.addWhereCondition("msgdiagnostici.gdo>=?");
        }
        if (filter.getDataFine() != null) {
            sqlQueryObject.addWhereCondition("msgdiagnostici.gdo<=?");
        }
        if (filter.getIdEgov() != null && !"".equals(filter.getIdEgov())) {
            sqlQueryObject.addWhereCondition("msgdiagnostici.idegov=?");
        } else {
            sqlQueryObject.addWhereCondition("msgdiagnostici.idegov is NULL");
        }
        sqlQueryObject.addOrderBy("gdo");
        sqlQueryObject.setSortType(false);
        if (setLimit) {
            sqlQueryObject.setLimit((int)filter.getLimit());
            this.log.debug((Object)("Limit:" + filter.getLimit()));
            long offset = filter.getOffsetMap() != null && filter.getOffsetMap().length > 2 ? filter.getOffsetMap()[1] : 0L;
            this.log.debug((Object)("Offset : " + offset));
            sqlQueryObject.setOffset((int)offset);
        }
        return sqlQueryObject;
    }

    private ISQLQueryObject createQueryObjGetMessaggiDiagnostici(FilterSearch filter, String msgToSearch, boolean isCount, boolean sortType) throws SQLQueryObjectException {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
        sqlQueryObject.addFromTable("msgdiagnostici");
        if (isCount) {
            sqlQueryObject.addSelectCountField("msgdiagnostici.id", "tot", true);
        } else {
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.addSelectField("msgdiagnostici", "gdo");
            sqlQueryObject.addSelectAliasField("msgdiagnostici", "id", "idMSGDIAG");
            sqlQueryObject.addOrderBy("msgdiagnostici.gdo");
            sqlQueryObject.setSortType(sortType);
        }
        if (filter.getDataInizio() != null) {
            sqlQueryObject.addWhereCondition("msgdiagnostici.gdo>=?");
        }
        if (filter.getDataFine() != null) {
            sqlQueryObject.addWhereCondition("msgdiagnostici.gdo<=?");
        }
        if (filter.getSeverita() != null) {
            sqlQueryObject.addWhereCondition("msgdiagnostici.severita<=?");
        }
        if (filter.getIdFunzione() != null) {
            String idF = filter.getIdFunzione();
            if ("RicezioneContenutiApplicativi".equals(idF) || "Imbustamento".equals(idF) || "RicezioneBusteEGov".equals(idF) || "Sbustamento".equals(idF)) {
                sqlQueryObject.addWhereLikeCondition("msgdiagnostici.idfunzione", idF, true, true);
            }
            if ("InoltroBusteEGov".equals(idF)) {
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("msgdiagnostici.idfunzione", idF), sqlQueryObject.getWhereLikeCondition("msgdiagnostici.idfunzione", "InoltroRisposteEGov")});
            }
            if ("ConsegnaContenutiApplicativi".equals(idF)) {
                sqlQueryObject.addWhereLikeCondition("msgdiagnostici.idfunzione", idF);
            }
        }
        if (msgToSearch != null && !"".equals(msgToSearch)) {
            sqlQueryObject.addWhereLikeCondition("msgdiagnostici.messaggio", msgToSearch, true, true);
        }
        if (!isCount && filter.getLimit() > 0L) {
            sqlQueryObject.setLimit((int)filter.getLimit());
            sqlQueryObject.setOffset((int)filter.getOffset());
        }
        sqlQueryObject.setANDLogicOperator(true);
        if (filter.getEgov() != null) {
            String nome;
            String tipo;
            sqlQueryObject.addFromTable("msgdiag_correlazione");
            sqlQueryObject.addWhereCondition("msgdiagnostici.idegov=msgdiag_correlazione.idegov");
            Egov egov = filter.getEgov();
            IDSoggetto destinatario = egov.getErogatore();
            IDSoggetto mittente = egov.getFruitore();
            IDServizio servizio = egov.getServizio();
            String azione = egov.getAzione();
            if (destinatario != null) {
                tipo = destinatario.getTipo();
                nome = destinatario.getNome();
                if (tipo != null && !"".equals(tipo)) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.tipo_erogatore = ?");
                }
                if (nome != null && !"".equals(nome)) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.erogatore = ?");
                }
            }
            if (mittente != null) {
                tipo = mittente.getTipo();
                nome = mittente.getNome();
                if (tipo != null && !"".equals(tipo)) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.tipo_fruitore = ?");
                }
                if (nome != null && !"".equals(nome)) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.fruitore = ?");
                }
            }
            if (servizio != null) {
                tipo = servizio.getTipoServizio();
                nome = servizio.getServizio();
                if (tipo != null && !"".equals(tipo)) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.tipo_servizio = ?");
                }
                if (nome != null && !"".equals(nome)) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.servizio = ?");
                }
            }
            if (azione != null && !"".equals(azione)) {
                sqlQueryObject.addWhereCondition("msgdiag_correlazione.azione = ?");
            }
            if (filter.getDataInizio() != null) {
                sqlQueryObject.addWhereCondition("msgdiag_correlazione.gdo>=?");
            }
            if (filter.getDataFine() != null) {
                sqlQueryObject.addWhereCondition("msgdiag_correlazione.gdo<=?");
            }
        }
        return sqlQueryObject;
    }

    private ISQLQueryObject createQueryObjDiagnosticiNotExist(FilterSearch filter, boolean setLimit) throws SQLQueryObjectException {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
        ISQLQueryObject innerObj = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
        sqlQueryObject.addSelectField("idegov");
        sqlQueryObject.addSelectField("gdo");
        sqlQueryObject.addSelectAliasField("null", "porta");
        sqlQueryObject.addSelectAliasField("null", "delegata");
        sqlQueryObject.addSelectAliasField("null", "tipo_fruitore");
        sqlQueryObject.addSelectAliasField("null", "fruitore");
        sqlQueryObject.addSelectAliasField("null", "tipo_erogatore");
        sqlQueryObject.addSelectAliasField("null", "erogatore");
        sqlQueryObject.addSelectAliasField("null", "tipo_servizio");
        sqlQueryObject.addSelectAliasField("null", "servizio");
        sqlQueryObject.addSelectAliasField("null", "azione");
        sqlQueryObject.addSelectField("id");
        sqlQueryObject.addSelectAliasField("null", "id_correlazione_applicativa");
        sqlQueryObject.addSelectField("idporta");
        sqlQueryObject.addSelectField("idfunzione");
        sqlQueryObject.addSelectField("severita");
        sqlQueryObject.addSelectField("idegov_risposta");
        sqlQueryObject.addSelectField("messaggio");
        sqlQueryObject.addFromTable("msgdiagnostici");
        sqlQueryObject.setANDLogicOperator(true);
        if (filter.getDataInizio() != null) {
            sqlQueryObject.addWhereCondition("msgdiagnostici.gdo>=?");
        }
        if (filter.getDataFine() != null) {
            sqlQueryObject.addWhereCondition("msgdiagnostici.gdo<=?");
        }
        if (filter.getIdEgov() != null && !"".equals(filter.getIdEgov())) {
            sqlQueryObject.addWhereCondition("msgdiagnostici.idegov=?");
        }
        innerObj.addFromTable("msgdiag_correlazione");
        innerObj.addWhereCondition("msgdiag_correlazione.idegov=msgdiagnostici.idegov");
        sqlQueryObject.addWhereExistsCondition(true, innerObj);
        sqlQueryObject.addOrderBy("gdo");
        sqlQueryObject.setSortType(false);
        if (setLimit) {
            sqlQueryObject.setLimit((int)filter.getLimit());
            this.log.debug((Object)("Limit : " + filter.getLimit()));
            long offset = filter.getOffsetMap() != null && filter.getOffsetMap().length > 2 ? filter.getOffsetMap()[2] : 0L;
            this.log.debug((Object)("Offset : " + offset));
            sqlQueryObject.setOffset((int)offset);
        }
        return sqlQueryObject;
    }

    @Override
    public MsgDiagnosticoCorrelazioneList searchMsgDiagnostici(FilterSearch filter) throws DriverMSGDiagnosticiException {
        try {
            this.log.debug((Object)"Richiesta Search Messaggi diagnostici");
            this.log.debug((Object)("Filtro Impostato: " + filter.toString()));
            List<MsgDiagnosticoCorrelazione> listaMSG = null;
            if (filter.getEgov() != null || filter.getCorrelatiOnly() != null && filter.getCorrelatiOnly().booleanValue() || filter.getCorrelazioneApplicativa() != null || filter.getServizioApplicativo() != null) {
                this.log.debug((Object)"Filtro solo su messaggi correlati.");
                listaMSG = this.getInfoEntryCorrelazione(filter, false);
            } else {
                listaMSG = this.getInfoEntryCorrelazione(filter, true);
            }
            MsgDiagnosticoCorrelazioneList list = new MsgDiagnosticoCorrelazioneList();
            list.setOffsetMap(filter.getOffsetMap());
            this.log.debug((Object)("offsetmap[correlati]: " + filter.getOffsetMap()[0]));
            this.log.debug((Object)("offsetmap[diagnostici]: " + filter.getOffsetMap()[1]));
            this.log.debug((Object)("offsetmap[notexist]: " + filter.getOffsetMap()[2]));
            list.setMsgDiagnosticoCorrelazioneList(listaMSG.toArray(new MsgDiagnosticoCorrelazione[listaMSG.size()]));
            long totEntry = 0L;
            totEntry = filter.getEgov() != null || filter.getCorrelatiOnly() != null && filter.getCorrelatiOnly() != false || filter.getCorrelazioneApplicativa() != null || filter.getServizioApplicativo() != null ? this.getTotEntryCorrelazione(filter) : this.getTotUnionEntry(filter);
            list.setTotEntry(totEntry);
            this.log.debug((Object)("Messaggi Recuperati: " + listaMSG.size() + " su " + totEntry));
            return list;
        }
        catch (SQLQueryObjectException e) {
            throw new DriverMSGDiagnosticiException(e);
        }
    }

    /*
     * Loose catch block
     */
    private long getTotUnionEntry(FilterSearch filter) throws DriverMSGDiagnosticiException, SQLQueryObjectException {
        int j;
        Egov egov;
        Statement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        boolean closeConnection = true;
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
        ISQLQueryObject sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
        ISQLQueryObject sqlQueryObject3 = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
        ISQLQueryObject subquery = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
        if (this.con != null) {
            con = this.con;
            closeConnection = false;
        } else {
            con = this.datasource.getConnection();
            if (con == null) {
                throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
            }
        }
        long totale = 0L;
        int totMSG = 0;
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addFromTable("msgdiag_correlazione");
        sqlQueryObject.addSelectCountField("idegov", "totale");
        if (filter.getDataInizio() != null) {
            sqlQueryObject.addWhereCondition("msgdiag_correlazione.gdo>=?");
        }
        if (filter.getDataFine() != null) {
            sqlQueryObject.addWhereCondition("msgdiag_correlazione.gdo<=?");
        }
        if (filter.getIdEgov() != null && !"".equals(filter.getIdEgov())) {
            sqlQueryObject.addWhereCondition("msgdiag_correlazione.idegov=?");
        }
        if (filter.getNomePorta() != null && !"".equals(filter.getNomePorta())) {
            sqlQueryObject.addWhereCondition("msgdiag_correlazione.porta='" + filter.getNomePorta() + "'");
        }
        if (filter.isDelegata() != null) {
            sqlQueryObject.addWhereCondition("msgdiag_correlazione.delegata=" + (filter.isDelegata() != false ? 1 : 0));
        }
        if ((egov = filter.getEgov()) != null) {
            if (egov.getFruitore() != null) {
                if (egov.getFruitore().getTipo() != null && !"".equals(egov.getFruitore().getTipo())) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.tipo_fruitore='" + egov.getFruitore().getTipo() + "'");
                }
                if (egov.getFruitore().getNome() != null && !"".equals(egov.getFruitore().getNome())) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.fruitore='" + egov.getFruitore().getNome() + "'");
                }
            }
            if (egov.getErogatore() != null) {
                if (egov.getErogatore().getTipo() != null && !"".equals(egov.getErogatore().getTipo())) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.tipo_erogatore='" + egov.getErogatore().getTipo() + "'");
                }
                if (egov.getErogatore().getNome() != null && !"".equals(egov.getErogatore().getNome())) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.erogatore='" + egov.getErogatore().getNome() + "'");
                }
            }
            if (egov.getServizio() != null) {
                if (egov.getServizio().getTipoServizio() != null && !"".equals(egov.getServizio().getTipoServizio())) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.tipo_servizio='" + egov.getServizio().getTipoServizio() + "'");
                }
                if (egov.getServizio().getServizio() != null && !"".equals(egov.getServizio().getServizio())) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.servizio='" + egov.getServizio().getServizio() + "'");
                }
            }
            if (egov.getAzione() != null && !"".equals(egov.getAzione())) {
                sqlQueryObject.addWhereCondition("msgdiag_correlazione.azione='" + egov.getAzione() + "'");
            }
        }
        this.log.debug((Object)("eseguo query:" + sqlQueryObject.createSQLQuery()));
        stmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
        int count = 1;
        for (j = 1; j < 2; ++j) {
            if (filter.getDataInizio() != null) {
                stmt.setTimestamp(count, new Timestamp(filter.getDataInizio().getTimeInMillis()));
                ++count;
            }
            if (filter.getDataFine() != null) {
                stmt.setTimestamp(count, new Timestamp(filter.getDataFine().getTimeInMillis()));
                ++count;
            }
            if (filter.getIdEgov() == null || "".equals(filter.getIdEgov())) continue;
            stmt.setString(count, filter.getIdEgov());
            ++count;
        }
        totMSG = 0;
        rs = stmt.executeQuery();
        if (rs.next()) {
            totMSG = rs.getInt("totale");
        }
        rs.close();
        stmt.close();
        totale += (long)totMSG;
        this.log.debug((Object)("getTotUnionEntry (Count 1): [" + totMSG + "] entry matchano il filtro :" + filter.toString()));
        sqlQueryObject2.setANDLogicOperator(true);
        sqlQueryObject2.addFromTable("msgdiagnostici");
        sqlQueryObject2.addSelectCountField("*", "totale");
        sqlQueryObject2.addWhereCondition("msgdiagnostici.idegov is NULL");
        if (filter.getDataInizio() != null) {
            sqlQueryObject2.addWhereCondition("msgdiagnostici.gdo>=?");
        }
        if (filter.getDataFine() != null) {
            sqlQueryObject2.addWhereCondition("msgdiagnostici.gdo<=?");
        }
        if (filter.getIdEgov() != null && !"".equals(filter.getIdEgov())) {
            sqlQueryObject2.addWhereCondition("msgdiagnostici.idegov=?");
        }
        if (filter.getNomePorta() != null && !"".equals(filter.getNomePorta())) {
            sqlQueryObject2.addWhereCondition("msgdiagnostici.porta='" + filter.getNomePorta() + "'");
        }
        if (filter.isDelegata() != null) {
            sqlQueryObject2.addWhereCondition("msgdiagnostici.delegata=" + (filter.isDelegata() != false ? 1 : 0));
        }
        if ((egov = filter.getEgov()) != null) {
            if (egov.getFruitore() != null) {
                if (egov.getFruitore().getTipo() != null && !"".equals(egov.getFruitore().getTipo())) {
                    sqlQueryObject2.addWhereCondition("msgdiag_correlazione.tipo_fruitore='" + egov.getFruitore().getTipo() + "'");
                }
                if (egov.getFruitore().getNome() != null && !"".equals(egov.getFruitore().getNome())) {
                    sqlQueryObject2.addWhereCondition("msgdiag_correlazione.fruitore='" + egov.getFruitore().getNome() + "'");
                }
            }
            if (egov.getErogatore() != null) {
                if (egov.getErogatore().getTipo() != null && !"".equals(egov.getErogatore().getTipo())) {
                    sqlQueryObject2.addWhereCondition("msgdiag_correlazione.tipo_erogatore='" + egov.getErogatore().getTipo() + "'");
                }
                if (egov.getErogatore().getNome() != null && !"".equals(egov.getErogatore().getNome())) {
                    sqlQueryObject2.addWhereCondition("msgdiag_correlazione.erogatore='" + egov.getErogatore().getNome() + "'");
                }
            }
            if (egov.getServizio() != null) {
                if (egov.getServizio().getTipoServizio() != null && !"".equals(egov.getServizio().getTipoServizio())) {
                    sqlQueryObject2.addWhereCondition("msgdiag_correlazione.tipo_servizio='" + egov.getServizio().getTipoServizio() + "'");
                }
                if (egov.getServizio().getServizio() != null && !"".equals(egov.getServizio().getServizio())) {
                    sqlQueryObject2.addWhereCondition("msgdiag_correlazione.servizio='" + egov.getServizio().getServizio() + "'");
                }
            }
            if (egov.getAzione() != null && !"".equals(egov.getAzione())) {
                sqlQueryObject2.addWhereCondition("msgdiagnostici.azione='" + egov.getAzione() + "'");
            }
        }
        this.log.debug((Object)("eseguo query:" + sqlQueryObject2.createSQLQuery()));
        stmt = con.prepareStatement(sqlQueryObject2.createSQLQuery());
        count = 1;
        for (j = 1; j < 2; ++j) {
            if (filter.getDataInizio() != null) {
                stmt.setTimestamp(count, new Timestamp(filter.getDataInizio().getTimeInMillis()));
                ++count;
            }
            if (filter.getDataFine() != null) {
                stmt.setTimestamp(count, new Timestamp(filter.getDataFine().getTimeInMillis()));
                ++count;
            }
            if (filter.getIdEgov() == null || "".equals(filter.getIdEgov())) continue;
            stmt.setString(count, filter.getIdEgov());
            ++count;
        }
        totMSG = 0;
        rs = stmt.executeQuery();
        if (rs.next()) {
            totMSG = rs.getInt("totale");
        }
        rs.close();
        stmt.close();
        totale += (long)totMSG;
        this.log.debug((Object)("getTotUnionEntry (Count 2): [" + totMSG + "] entry matchano il filtro :" + filter.toString()));
        if (!filter.isPartial()) {
            sqlQueryObject3.setANDLogicOperator(true);
            sqlQueryObject3.addFromTable("msgdiagnostici");
            sqlQueryObject3.addSelectCountField("idegov", "totale");
            subquery.addFromTable("msgdiag_correlazione");
            subquery.addWhereCondition("msgdiag_correlazione.idegov=msgdiagnostici.idegov");
            sqlQueryObject3.addWhereExistsCondition(true, subquery);
            if (filter.getDataInizio() != null) {
                sqlQueryObject3.addWhereCondition("msgdiagnostici.gdo>=?");
            }
            if (filter.getDataFine() != null) {
                sqlQueryObject3.addWhereCondition("msgdiagnostici.gdo<=?");
            }
            if (filter.getIdEgov() != null && !"".equals(filter.getIdEgov())) {
                sqlQueryObject3.addWhereCondition("msgdiagnostici.idegov=?");
            }
            if (filter.getNomePorta() != null && !"".equals(filter.getNomePorta())) {
                sqlQueryObject3.addWhereCondition("msgdiagnostici.porta='" + filter.getNomePorta() + "'");
            }
            if (filter.isDelegata() != null) {
                sqlQueryObject3.addWhereCondition("msgdiagnostici.delegata=" + (filter.isDelegata() != false ? 1 : 0));
            }
            if ((egov = filter.getEgov()) != null) {
                if (egov.getFruitore() != null) {
                    if (egov.getFruitore().getTipo() != null && !"".equals(egov.getFruitore().getTipo())) {
                        sqlQueryObject3.addWhereCondition("msgdiag_correlazione.tipo_fruitore='" + egov.getFruitore().getTipo() + "'");
                    }
                    if (egov.getFruitore().getNome() != null && !"".equals(egov.getFruitore().getNome())) {
                        sqlQueryObject3.addWhereCondition("msgdiag_correlazione.fruitore='" + egov.getFruitore().getNome() + "'");
                    }
                }
                if (egov.getErogatore() != null) {
                    if (egov.getErogatore().getTipo() != null && !"".equals(egov.getErogatore().getTipo())) {
                        sqlQueryObject3.addWhereCondition("msgdiag_correlazione.tipo_erogatore='" + egov.getErogatore().getTipo() + "'");
                    }
                    if (egov.getErogatore().getNome() != null && !"".equals(egov.getErogatore().getNome())) {
                        sqlQueryObject3.addWhereCondition("msgdiag_correlazione.erogatore='" + egov.getErogatore().getNome() + "'");
                    }
                }
                if (egov.getServizio() != null) {
                    if (egov.getServizio().getTipoServizio() != null && !"".equals(egov.getServizio().getTipoServizio())) {
                        sqlQueryObject3.addWhereCondition("msgdiag_correlazione.tipo_servizio='" + egov.getServizio().getTipoServizio() + "'");
                    }
                    if (egov.getServizio().getServizio() != null && !"".equals(egov.getServizio().getServizio())) {
                        sqlQueryObject3.addWhereCondition("msgdiag_correlazione.servizio='" + egov.getServizio().getServizio() + "'");
                    }
                }
                if (egov.getAzione() != null && !"".equals(egov.getAzione())) {
                    sqlQueryObject3.addWhereCondition("msgdiagnostici.azione='" + egov.getAzione() + "'");
                }
            }
            this.log.debug((Object)("eseguo query:" + sqlQueryObject3.createSQLQuery()));
            stmt = con.prepareStatement(sqlQueryObject3.createSQLQuery());
            count = 1;
            for (j = 1; j < 2; ++j) {
                if (filter.getDataInizio() != null) {
                    stmt.setTimestamp(count, new Timestamp(filter.getDataInizio().getTimeInMillis()));
                    ++count;
                }
                if (filter.getDataFine() != null) {
                    stmt.setTimestamp(count, new Timestamp(filter.getDataFine().getTimeInMillis()));
                    ++count;
                }
                if (filter.getIdEgov() == null || "".equals(filter.getIdEgov())) continue;
                stmt.setString(count, filter.getIdEgov());
                ++count;
            }
            totMSG = 0;
            rs = stmt.executeQuery();
            if (rs.next()) {
                totMSG = rs.getInt("totale");
            }
            rs.close();
            stmt.close();
            totale += (long)totMSG;
            this.log.debug((Object)("getTotUnionEntry (Count 3): [" + totMSG + "] entry matchano il filtro :" + filter.toString()));
        }
        this.log.debug((Object)("Totale Union Count : " + totale));
        long l = totale;
        Object var18_17 = null;
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        if (closeConnection) {
            try {
                con.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        return l;
        catch (Exception e) {
            try {
                throw new DriverMSGDiagnosticiException(e);
            }
            catch (Throwable throwable) {
                block81: {
                    Object var18_18 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    if (!closeConnection) break block81;
                    try {
                        con.close();
                    }
                    catch (Exception e2) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    private long getTotEntryCorrelazione(FilterSearch filter) throws DriverMSGDiagnosticiException, SQLQueryObjectException {
        Egov egov;
        Statement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        boolean closeConnection = true;
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
        sqlQueryObject.addSelectCountField("msgdiag_correlazione.id", "totMSG");
        sqlQueryObject.addFromTable("msgdiag_correlazione");
        if (filter.getServizioApplicativo() != null && !"".equals(filter.getServizioApplicativo())) {
            sqlQueryObject.addFromTable("msgdiag_correlazione_sa");
        }
        sqlQueryObject.setANDLogicOperator(true);
        if (filter.getDataInizio() != null) {
            sqlQueryObject.addWhereCondition("msgdiag_correlazione.gdo>=?");
        }
        if (filter.getDataFine() != null) {
            sqlQueryObject.addWhereCondition("msgdiag_correlazione.gdo<=?");
        }
        if (filter.getIdEgov() != null && !"".equals(filter.getIdEgov())) {
            sqlQueryObject.addWhereCondition("msgdiag_correlazione.idegov=?");
        }
        if (filter.getNomePorta() != null && !"".equals(filter.getNomePorta())) {
            sqlQueryObject.addWhereCondition("msgdiag_correlazione.porta='" + filter.getNomePorta() + "'");
        }
        if (filter.isDelegata() != null) {
            sqlQueryObject.addWhereCondition("msgdiag_correlazione.delegata=" + (filter.isDelegata() != false ? 1 : 0));
        }
        if (filter.getCorrelazioneApplicativa() != null && !"".equals(filter.getCorrelazioneApplicativa())) {
            sqlQueryObject.addWhereLikeCondition("msgdiag_correlazione.id_correlazione_applicativa", filter.getCorrelazioneApplicativa(), true, true);
        }
        if (filter.getServizioApplicativo() != null && !"".equals(filter.getServizioApplicativo())) {
            sqlQueryObject.addWhereCondition("msgdiag_correlazione.id=msgdiag_correlazione_sa.id_correlazione");
            sqlQueryObject.addWhereCondition("msgdiag_correlazione_sa.servizio_applicativo='" + filter.getServizioApplicativo() + "'");
        }
        if ((egov = filter.getEgov()) != null) {
            if (egov.getFruitore() != null) {
                if (egov.getFruitore().getTipo() != null && !"".equals(egov.getFruitore().getTipo())) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.tipo_fruitore='" + egov.getFruitore().getTipo() + "'");
                }
                if (egov.getFruitore().getNome() != null && !"".equals(egov.getFruitore().getNome())) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.fruitore='" + egov.getFruitore().getNome() + "'");
                }
            }
            if (egov.getErogatore() != null) {
                if (egov.getErogatore().getTipo() != null && !"".equals(egov.getErogatore().getTipo())) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.tipo_erogatore='" + egov.getErogatore().getTipo() + "'");
                }
                if (egov.getErogatore().getNome() != null && !"".equals(egov.getErogatore().getNome())) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.erogatore='" + egov.getErogatore().getNome() + "'");
                }
            }
            if (egov.getServizio() != null) {
                if (egov.getServizio().getTipoServizio() != null && !"".equals(egov.getServizio().getTipoServizio())) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.tipo_servizio='" + egov.getServizio().getTipoServizio() + "'");
                }
                if (egov.getServizio().getServizio() != null && !"".equals(egov.getServizio().getServizio())) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.servizio='" + egov.getServizio().getServizio() + "'");
                }
            }
            if (egov.getAzione() != null && !"".equals(egov.getAzione())) {
                sqlQueryObject.addWhereCondition("msgdiag_correlazione.azione='" + egov.getAzione() + "'");
            }
        }
        if (this.con != null) {
            con = this.con;
            closeConnection = false;
        } else {
            con = this.datasource.getConnection();
            if (con == null) {
                throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
            }
        }
        stmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
        int i = 1;
        if (filter.getDataInizio() != null) {
            stmt.setTimestamp(i++, new Timestamp(filter.getDataInizio().getTimeInMillis()));
        }
        if (filter.getDataFine() != null) {
            stmt.setTimestamp(i++, new Timestamp(filter.getDataFine().getTimeInMillis()));
        }
        if (filter.getIdEgov() != null && !"".equals(filter.getIdEgov())) {
            stmt.setString(i++, filter.getIdEgov());
        }
        int totMSG = 0;
        rs = stmt.executeQuery();
        if (rs.next()) {
            totMSG = rs.getInt("totMSG");
        }
        rs.close();
        stmt.close();
        this.log.debug((Object)("getTotEntryCorrelazione : [" + totMSG + "] entry matchano il filtro :" + filter.toString()));
        long l = totMSG;
        Object var13_12 = null;
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        if (closeConnection) {
            try {
                con.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        return l;
        catch (Exception e) {
            try {
                throw new DriverMSGDiagnosticiException(e);
            }
            catch (Throwable throwable) {
                block43: {
                    Object var13_13 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    if (!closeConnection) break block43;
                    try {
                        con.close();
                    }
                    catch (Exception e2) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public MsgDiagnostico getDettaglio(FilterSearch filter) throws DriverMSGDiagnosticiException {
        if (filter == null) {
            throw new DriverMSGDiagnosticiException("Parametro di ricerca non valido.");
        }
        long id = filter.getId();
        if (id <= 0L) {
            throw new DriverMSGDiagnosticiException("Id non valido");
        }
        Statement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        boolean closeConnection = true;
        MsgDiagnostico loggedEntry = null;
        if (this.con != null) {
            con = this.con;
            closeConnection = false;
        } else {
            con = this.datasource.getConnection();
            if (con == null) {
                throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
            }
        }
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
        sqlQueryObject.addFromTable("msgdiagnostici");
        sqlQueryObject.addWhereCondition("id=?");
        sqlQueryObject.setLimit(1000);
        sqlQueryObject.addOrderBy("id");
        this.log.debug((Object)("Eseguo query : " + sqlQueryObject.createSQLQuery()));
        stmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
        stmt.setLong(1, id);
        rs = stmt.executeQuery();
        if (rs.next()) {
            loggedEntry = new MsgDiagnostico();
            Timestamp gdo = rs.getTimestamp("gdo");
            Calendar cal = Calendar.getInstance();
            cal.setTime(gdo);
            loggedEntry.setId(id);
            loggedEntry.setGdo(cal);
            loggedEntry.setIdEgov(rs.getString("idegov"));
            loggedEntry.setIdFunzione(rs.getString("idfunzione"));
            loggedEntry.setIdPorta(rs.getString("idporta"));
            loggedEntry.setMessaggio(rs.getString("messaggio"));
            loggedEntry.setSeverita(LogLevels.toStringValue(rs.getInt("severita")));
            loggedEntry.setIdEgovRisposta(rs.getString("idegov_risposta"));
        }
        rs.close();
        stmt.close();
        MsgDiagnostico msgDiagnostico = loggedEntry;
        Object var13_12 = null;
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        if (closeConnection) {
            try {
                con.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        return msgDiagnostico;
        catch (Exception e) {
            try {
                throw new DriverMSGDiagnosticiException(e);
            }
            catch (Throwable throwable) {
                block23: {
                    Object var13_13 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    if (!closeConnection) break block23;
                    try {
                        con.close();
                    }
                    catch (Exception e2) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public long getCountMessaggiDiagnostici(FilterSearch filter, String msgToSearch) throws DriverMSGDiagnosticiException {
        if (filter == null) {
            throw new DriverMSGDiagnosticiException("Parametro di ricerca non valido.");
        }
        Statement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        boolean closeConnection = true;
        if (this.con != null) {
            con = this.con;
            closeConnection = false;
        } else {
            con = this.datasource.getConnection();
            if (con == null) {
                throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
            }
        }
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
        sqlQueryObject = this.createQueryObjGetMessaggiDiagnostici(filter, msgToSearch, true, false);
        this.log.debug((Object)("Eseguo query : " + sqlQueryObject.createSQLQuery()));
        stmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
        int param_index = 0;
        if (filter.getDataInizio() != null) {
            stmt.setTimestamp(++param_index, new Timestamp(filter.getDataInizio().getTimeInMillis()));
        }
        if (filter.getDataFine() != null) {
            stmt.setTimestamp(++param_index, new Timestamp(filter.getDataFine().getTimeInMillis()));
        }
        if (filter.getSeverita() != null) {
            stmt.setString(++param_index, filter.getSeverita() + "");
        }
        if (filter.getEgov() != null) {
            String nome;
            String tipo;
            Egov egov = filter.getEgov();
            IDSoggetto destinatario = egov.getErogatore();
            IDSoggetto mittente = egov.getFruitore();
            IDServizio servizio = egov.getServizio();
            String azione = egov.getAzione();
            if (destinatario != null) {
                tipo = destinatario.getTipo();
                nome = destinatario.getNome();
                if (tipo != null && !"".equals(tipo)) {
                    stmt.setString(++param_index, tipo);
                }
                if (nome != null && !"".equals(nome)) {
                    stmt.setString(++param_index, nome);
                }
            }
            if (mittente != null) {
                tipo = mittente.getTipo();
                nome = mittente.getNome();
                if (tipo != null && !"".equals(tipo)) {
                    stmt.setString(++param_index, tipo);
                }
                if (nome != null && !"".equals(nome)) {
                    stmt.setString(++param_index, nome);
                }
            }
            if (servizio != null) {
                tipo = servizio.getTipoServizio();
                nome = servizio.getServizio();
                if (tipo != null && !"".equals(tipo)) {
                    stmt.setString(++param_index, tipo);
                }
                if (nome != null && !"".equals(nome)) {
                    stmt.setString(++param_index, nome);
                }
            }
            if (azione != null && !"".equals(azione)) {
                stmt.setString(++param_index, azione);
            }
            if (filter.getDataInizio() != null) {
                stmt.setTimestamp(++param_index, new Timestamp(filter.getDataInizio().getTimeInMillis()));
            }
            if (filter.getDataFine() != null) {
                stmt.setTimestamp(++param_index, new Timestamp(filter.getDataFine().getTimeInMillis()));
            }
        }
        rs = stmt.executeQuery();
        long tot = 0L;
        if (rs.next()) {
            tot = rs.getLong("tot");
        }
        rs.close();
        stmt.close();
        long l = tot;
        Object var17_19 = null;
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        if (closeConnection) {
            try {
                con.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        return l;
        catch (Exception e) {
            try {
                throw new DriverMSGDiagnosticiException(e);
            }
            catch (Throwable throwable) {
                block38: {
                    Object var17_20 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    if (!closeConnection) break block38;
                    try {
                        con.close();
                    }
                    catch (Exception e2) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public List<MsgDiagnostico> getMessaggiDiagnostici(FilterSearch filter, String msgToSearch, boolean sortType) throws DriverMSGDiagnosticiException {
        if (filter == null) {
            throw new DriverMSGDiagnosticiException("Parametro di ricerca non valido.");
        }
        Statement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        boolean closeConnection = true;
        MsgDiagnostico loggedEntry = null;
        String query = null;
        if (this.con != null) {
            con = this.con;
            closeConnection = false;
        } else {
            con = this.datasource.getConnection();
            if (con == null) {
                throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
            }
        }
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
        sqlQueryObject = this.createQueryObjGetMessaggiDiagnostici(filter, msgToSearch, false, sortType);
        query = sqlQueryObject.createSQLQuery();
        this.log.debug((Object)("Eseguo query : " + sqlQueryObject.createSQLQuery()));
        stmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
        int param_index = 0;
        if (filter.getDataInizio() != null) {
            stmt.setTimestamp(++param_index, new Timestamp(filter.getDataInizio().getTimeInMillis()));
        }
        if (filter.getDataFine() != null) {
            stmt.setTimestamp(++param_index, new Timestamp(filter.getDataFine().getTimeInMillis()));
        }
        if (filter.getSeverita() != null) {
            stmt.setString(++param_index, filter.getSeverita() + "");
        }
        if (filter.getEgov() != null) {
            String nome;
            String tipo;
            Egov egov = filter.getEgov();
            IDSoggetto destinatario = egov.getErogatore();
            IDSoggetto mittente = egov.getFruitore();
            IDServizio servizio = egov.getServizio();
            String azione = egov.getAzione();
            if (destinatario != null) {
                tipo = destinatario.getTipo();
                nome = destinatario.getNome();
                if (tipo != null && !"".equals(tipo)) {
                    stmt.setString(++param_index, tipo);
                }
                if (nome != null && !"".equals(nome)) {
                    stmt.setString(++param_index, nome);
                }
            }
            if (mittente != null) {
                tipo = mittente.getTipo();
                nome = mittente.getNome();
                if (tipo != null && !"".equals(tipo)) {
                    stmt.setString(++param_index, tipo);
                }
                if (nome != null && !"".equals(nome)) {
                    stmt.setString(++param_index, nome);
                }
            }
            if (servizio != null) {
                tipo = servizio.getTipoServizio();
                nome = servizio.getServizio();
                if (tipo != null && !"".equals(tipo)) {
                    stmt.setString(++param_index, tipo);
                }
                if (nome != null && !"".equals(nome)) {
                    stmt.setString(++param_index, nome);
                }
            }
            if (azione != null && !"".equals(azione)) {
                stmt.setString(++param_index, azione);
            }
            if (filter.getDataInizio() != null) {
                stmt.setTimestamp(++param_index, new Timestamp(filter.getDataInizio().getTimeInMillis()));
            }
            if (filter.getDataFine() != null) {
                stmt.setTimestamp(++param_index, new Timestamp(filter.getDataFine().getTimeInMillis()));
            }
        }
        rs = stmt.executeQuery();
        ArrayList<Long> listID = new ArrayList<Long>();
        while (rs.next()) {
            long idLetto = rs.getLong("idMSGDIAG");
            listID.add(idLetto);
        }
        rs.close();
        stmt.close();
        ArrayList<MsgDiagnostico> list = new ArrayList<MsgDiagnostico>();
        sqlQueryObject = this.createQueryObjGetMessaggioDiagnostico();
        String sqlQuery = sqlQueryObject.createSQLQuery();
        while (listID.size() > 0) {
            long idMsgDiagnostico = (Long)listID.remove(0);
            this.log.debug((Object)("Eseguo query : " + sqlQuery.replace("?", "" + idMsgDiagnostico)));
            stmt = con.prepareStatement(sqlQuery);
            stmt.setLong(1, idMsgDiagnostico);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new SQLQueryObjectException("MsgDiagnostico con id[" + idMsgDiagnostico + "] non trovato");
            }
            loggedEntry = new MsgDiagnostico();
            Timestamp gdo = rs.getTimestamp("gdo");
            Calendar cal = Calendar.getInstance();
            cal.setTime(gdo);
            loggedEntry.setId(rs.getLong("id_diagnostico"));
            loggedEntry.setGdo(cal);
            loggedEntry.setIdEgov(rs.getString("idegov_diagnostico"));
            loggedEntry.setIdFunzione(rs.getString("idfunzione"));
            loggedEntry.setIdPorta(rs.getString("idporta"));
            loggedEntry.setMessaggio(rs.getString("messaggio"));
            loggedEntry.setSeverita(LogLevels.toStringValue(rs.getInt("severita")));
            loggedEntry.setIdEgovRisposta(rs.getString("idegov_risposta"));
            list.add(loggedEntry);
            rs.close();
            stmt.close();
        }
        ArrayList<MsgDiagnostico> arrayList = list;
        Object var20_22 = null;
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        if (closeConnection) {
            try {
                con.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        return arrayList;
        catch (Exception e) {
            try {
                if (query != null) {
                    throw new DriverMSGDiagnosticiException("[" + query + "] " + e);
                }
                throw new DriverMSGDiagnosticiException(e);
            }
            catch (Throwable throwable) {
                block41: {
                    Object var20_23 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    if (!closeConnection) break block41;
                    try {
                        con.close();
                    }
                    catch (Exception e2) {}
                }
                throw throwable;
            }
        }
    }

    private ISQLQueryObject createQueryObjGetMessaggioDiagnostico() throws SQLQueryObjectException {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
        sqlQueryObject.addFromTable("msgdiagnostici");
        sqlQueryObject.addSelectAliasField("msgdiagnostici", "idegov", "idegov_diagnostico");
        sqlQueryObject.addSelectField("msgdiagnostici", "gdo");
        sqlQueryObject.addSelectAliasField("msgdiagnostici", "id", "id_diagnostico");
        sqlQueryObject.addSelectField("msgdiagnostici", "idporta");
        sqlQueryObject.addSelectField("msgdiagnostici", "idfunzione");
        sqlQueryObject.addSelectField("msgdiagnostici", "severita");
        sqlQueryObject.addSelectField("msgdiagnostici", "idegov_risposta");
        sqlQueryObject.addSelectField("msgdiagnostici", "messaggio");
        sqlQueryObject.addWhereCondition("msgdiagnostici.id=?");
        sqlQueryObject.setANDLogicOperator(true);
        return sqlQueryObject;
    }
}

