/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.threshold;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.openspcoop.pdd.config.DBManager;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.config.Resource;
import org.openspcoop.pdd.core.threshold.IThreshold;
import org.openspcoop.pdd.core.threshold.ThresholdException;
import org.openspcoop.pdd.logger.MsgDiagnostico;

public class PostgreSQLThreshold
implements IThreshold {
    public static OpenSPCoopProperties properties = OpenSPCoopProperties.getInstance();
    public static String ID_MODULO = "PostgreSQLThreshold";
    private static final String Query = "SELECT SUM(pg_database_size(pg_database.datname)) as size FROM pg_database JOIN pg_shadow ON pg_database.datdba = pg_shadow.usesysid;";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean check(String parametro) throws ThresholdException {
        DBManager dbManager = DBManager.getInstance();
        Resource resource = null;
        long size = 0L;
        long factor = 1L;
        boolean result = false;
        Statement s = null;
        ResultSet rs = null;
        String[] parametri = parametro.split(";");
        String Soglia = parametri[0].toLowerCase();
        StringBuffer valore = new StringBuffer();
        int ch = Soglia.charAt(0);
        int i = 1;
        while (Character.isDigit((char)ch)) {
            valore.append((char)ch);
            if (i < Soglia.length()) {
                ch = Soglia.charAt(i++);
                continue;
            }
            ch = 102;
        }
        if (Soglia.endsWith("kb") || Soglia.endsWith("k")) {
            factor = 1024L;
        } else if (Soglia.endsWith("mb") || Soglia.endsWith("m")) {
            factor = 0x100000L;
        } else if (Soglia.endsWith("gb") || Soglia.endsWith("g")) {
            factor = 0x40000000L;
        }
        MsgDiagnostico msgDiag = new MsgDiagnostico(ID_MODULO);
        Connection connection = null;
        try {
            try {
                if (parametri.length < 2) {
                    resource = dbManager.getResource(properties.getIdentificativoPortaDefault(), ID_MODULO);
                    if (resource == null) {
                        throw new Exception("Risorsa is null");
                    }
                    if (resource.getResource() == null) {
                        throw new Exception("Connessione is null");
                    }
                    connection = (Connection)resource.getResource();
                } else {
                    InitialContext c = new InitialContext();
                    DataSource ds = (DataSource)c.lookup(parametri[1]);
                    c.close();
                    connection = ds.getConnection();
                }
                long Threshold = Long.parseLong(valore.toString()) * factor;
                if (Threshold < 0L) {
                    throw new Exception("Valore di soglia negativo");
                }
                s = connection.createStatement();
                if (!s.execute(Query)) {
                    throw new Exception("Impossibile verficare lo spazio occupato");
                }
                rs = s.getResultSet();
                if (rs == null) {
                    throw new Exception("Nessun risultato disponibile per la verifica di soglia");
                }
                if (!rs.next()) {
                    throw new Exception("Nessun risultato disponibile per la verifica di soglia");
                }
                size = rs.getLong(1);
                if (size == 0L) {
                    throw new Exception("La quantita' di spazio occupata dai DB e' NULL");
                }
                result = size < Threshold;
            }
            catch (Exception e) {
                throw new ThresholdException("PostgreSQLThreshold error: " + e.getMessage(), e);
            }
            Object var23_20 = null;
            {
            }
        }
        catch (Throwable throwable) {
            Object var23_21 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (s != null) {
                    s.close();
                }
                rs = null;
                s = null;
                if (parametri.length < 2) {
                    dbManager.releaseResource(properties.getIdentificativoPortaDefault(), ID_MODULO, resource);
                    throw throwable;
                }
                if (connection == null) throw throwable;
                if (connection.isClosed()) throw throwable;
                connection.close();
                throw throwable;
            }
            catch (SQLException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException ex) {}
        if (rs != null) {
            rs.close();
        }
        if (s != null) {
            s.close();
        }
        rs = null;
        s = null;
        if (parametri.length < 2) {
            dbManager.releaseResource(properties.getIdentificativoPortaDefault(), ID_MODULO, resource);
        } else if (connection != null && !connection.isClosed()) {
            connection.close();
        }
        msgDiag.highDebug("Spazio occupato da tutti i databse: " + size + "; Spazio entro la soglia: " + result);
        return result;
    }
}

