/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.threshold;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.openspcoop.pdd.config.DBManager;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.config.Resource;
import org.openspcoop.pdd.core.threshold.IThreshold;
import org.openspcoop.pdd.core.threshold.ThresholdException;

public class MySQLThreshold
implements IThreshold {
    public static OpenSPCoopProperties properties = OpenSPCoopProperties.getInstance();
    public static String ID_MODULO = "MySQLThreshold";
    private static final String Query = "SHOW TABLE STATUS LIKE 'MESSAGGI'";

    public boolean check(String parametro) throws ThresholdException {
        DBManager dbManager = DBManager.getInstance();
        Resource resource = null;
        boolean result = false;
        Statement s = null;
        ResultSet rs = null;
        try {
            resource = dbManager.getResource(properties.getIdentificativoPortaDefault(), ID_MODULO);
            if (resource == null) {
                throw new Exception("Risorsa is null");
            }
            if (resource.getResource() == null) {
                throw new Exception("Connessione is null");
            }
            Connection connection = (Connection)resource.getResource();
            long Threshold = Long.parseLong(parametro);
            if (Threshold < 0L) {
                throw new Exception("Valore di soglia negativo");
            }
            s = connection.createStatement();
            if (!s.execute(Query)) {
                throw new Exception("Impossibile verficare lo spazio rimanente sul tablespace");
            }
            rs = s.getResultSet();
            if (rs == null) {
                throw new Exception("Nessun risultato disponibile per la verifica di soglia");
            }
            if (!rs.next()) {
                throw new Exception("Nessun risultato disponibile per la verifica di soglia");
            }
            String Comment2 = rs.getString("Comment");
            if (Comment2 == null) {
                throw new Exception("La quantita' di spazio disponibile sul DB e' NULL");
            }
            long FreeTableSpace = Long.parseLong(Comment2.substring(13, Comment2.length() - 3));
            result = FreeTableSpace > Threshold;
        }
        catch (Exception e) {
            throw new ThresholdException("MySQLThreshold error: " + e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (s != null) {
                    s.close();
                }
            }
            catch (SQLException ex) {}
            rs = null;
            s = null;
            dbManager.releaseResource(properties.getIdentificativoPortaDefault(), ID_MODULO, resource);
        }
        return result;
    }
}

