/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.state;

import java.util.Vector;
import org.apache.log4j.Logger;
import org.openspcoop.pdd.config.DBManager;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.config.Resource;
import org.openspcoop.pdd.core.state.OpenSPCoopStateException;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;

public class OpenSPCoopStateConnectionPool {
    private static Vector<Resource> connectionPool = new Vector();
    private static long connectionsNumber = 0L;
    private static Logger logConsole = null;
    private static Logger log = null;
    private static OpenSPCoopProperties properties = null;
    private static DBManager dbManager = null;
    private static String validazione = null;

    public static void initConnections(long num, Logger lConsole) throws OpenSPCoopStateException {
        if (num < 0L) {
            throw new OpenSPCoopStateException("Numero di connessioni minore di zero [" + num + "]");
        }
        connectionsNumber = num;
        logConsole = lConsole;
        log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        properties = OpenSPCoopProperties.getInstance();
        dbManager = DBManager.getInstance();
        validazione = properties.getValidationConnectionPoolStateless();
        try {
            int i = 0;
            while ((long)i < connectionsNumber) {
                Resource resourceDB = dbManager.getResource(properties.getIdentificativoPortaDefault(), "InitOpenSPCoopStatefulPool");
                if (resourceDB == null) {
                    throw new OpenSPCoopStateException("Riscontrato errore durante la richiesta di una connessione al DB (Risorsa is null).");
                }
                if (resourceDB.getResource() == null) {
                    throw new OpenSPCoopStateException("Riscontrato errore durante la richiesta di una connessione al DB (Connessione is null).");
                }
                connectionPool.add(resourceDB);
                ++i;
            }
            logConsole.info((Object)("Inizializzate " + connectionPool.size() + " connessione al database per la gestione stateless"));
        }
        catch (Exception e) {
            logConsole.error((Object)("Inizializzate " + connectionPool.size() + " connessione al database per la gestione stateless, con errore: " + e.getMessage()));
            log.error((Object)("Inizializzate " + connectionPool.size() + " connessione al database per la gestione stateless, con errore: " + e.getMessage()), (Throwable)e);
        }
    }

    public static synchronized Resource getResource() throws OpenSPCoopStateException {
        if (connectionPool.size() > 0) {
            Resource r = connectionPool.remove(0);
            if (validazione != null) {
                // empty if block
            }
            return r;
        }
        throw new OpenSPCoopStateException("Risorsa per la connessione al database non disponibile");
    }

    public static void releaseResource(Resource r) {
        connectionPool.add(r);
    }

    public static void closeResources() {
        long connessioniPrecedentiPrese = connectionPool.size();
        try {
            while (connectionPool.size() > 0) {
                Resource r = connectionPool.remove(0);
                dbManager.releaseResource(properties.getIdentificativoPortaDefault(), "InitOpenSPCoopStatefulPool", r);
            }
            if (connessioniPrecedentiPrese > 0L) {
                log.info((Object)("Rilasciate " + connectionPool.size() + " connessione al database per la gestione stateless"));
            }
        }
        catch (Exception e) {
            logConsole.error((Object)("Rilasciate " + (connessioniPrecedentiPrese - (long)connectionPool.size()) + " connessione al database per la gestione stateless, altri rilasci con errore: " + e.getMessage()));
            log.error((Object)("Rilasciate " + (connessioniPrecedentiPrese - (long)connectionPool.size()) + " connessione al database per la gestione stateless, altri rilasci con errore: " + e.getMessage()), (Throwable)e);
        }
    }
}

