/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.node;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.ejb.CreateException;
import org.apache.log4j.Logger;
import org.openspcoop.pdd.config.ClassNameProperties;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.GestoreMessaggi;
import org.openspcoop.pdd.core.GestoreMessaggiException;
import org.openspcoop.pdd.core.node.INodeSender;
import org.openspcoop.pdd.core.node.NodeException;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.mdb.GenericMessage;
import org.openspcoop.pdd.mdb.threads.MessaggioSerializzato;
import org.openspcoop.utils.jdbc.IJDBCAdapter;

public class NodeSenderDB
implements INodeSender {
    private static final String ID_MODULO = "NODE_SENDER_DB";
    private static IJDBCAdapter adapter = null;
    private static OpenSPCoopProperties propertiesReader;
    private static Logger log;
    private static boolean isInitialized;

    private synchronized void init() throws CreateException {
        if (!isInitialized) {
            try {
                propertiesReader = OpenSPCoopProperties.getInstance();
                log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
                ClassNameProperties classNameProperties = ClassNameProperties.getInstance();
                String adapterClass = classNameProperties.getJDBCAdapter(propertiesReader.getRepositoryJDBCAdapter());
                if (adapterClass == null) {
                    log.error((Object)("Inizializzione GestoreMessaggi non riuscita: AdapterClass non registrata [" + propertiesReader.getRepositoryJDBCAdapter() + "]"));
                }
                Class<?> c = Class.forName(adapterClass);
                adapter = (IJDBCAdapter)c.newInstance();
            }
            catch (Exception e) {
                log.error((Object)("Inizializzione GestoreMessaggi non riuscita: AdapterClass non trovata [" + propertiesReader.getRepositoryJDBCAdapter() + "]:" + e.getMessage()), (Throwable)e);
                System.out.println("Inizializzazione NODESENDER FALLITA: " + e);
                return;
            }
            isInitialized = true;
        }
    }

    public void send(Serializable msg, String destinazione, MsgDiagnostico msgDiag, String codicePorta, String idModulo, String idMessaggio, GestoreMessaggi gm) throws NodeException {
        byte[] msgByte;
        if (!isInitialized) {
            try {
                this.init();
            }
            catch (Exception e) {
                OpenSPCoopLogger.getLoggerOpenSPCoopCore().error((Object)"Inizializzazione NODESENDER FALLITA", (Throwable)e);
                return;
            }
        }
        MessaggioSerializzato messaggioSerializzato = new MessaggioSerializzato(idMessaggio, (GenericMessage)msg);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(messaggioSerializzato);
            out.close();
            msgByte = bos.toByteArray();
        }
        catch (IOException e) {
            log.error((Object)("NODE_SENDER_DB Serializzazione messaggio fallita: " + e.getMessage()), (Throwable)e);
            return;
        }
        try {
            gm.aggiungiMessaggioSerializzato(adapter, msgByte);
        }
        catch (GestoreMessaggiException e) {
            throw new NodeException(e);
        }
        msgDiag.highDebug("ObjectMessage send (NOP operation).");
    }

    static {
        isInitialized = false;
    }
}

