/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.node;

import java.sql.Connection;
import org.openspcoop.dao.state.IState;
import org.openspcoop.dao.state.StateMessage;
import org.openspcoop.dao.state.StatefulMessage;
import org.openspcoop.egov.RepositoryEGov;
import org.openspcoop.pdd.config.DBManager;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.config.Resource;
import org.openspcoop.pdd.core.GestoreMessaggi;
import org.openspcoop.pdd.core.node.INodeReceiver;
import org.openspcoop.pdd.core.node.NodeException;
import org.openspcoop.pdd.core.node.NodeTimeoutException;
import org.openspcoop.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.mdb.GenericMessage;
import org.openspcoop.pdd.services.RicezioneBusteEGovMessage;
import org.openspcoop.pdd.services.RicezioneContenutiApplicativiMessage;

public class NodeReceiverDB
implements INodeReceiver {
    private static OpenSPCoopProperties openspcoopProperties = OpenSPCoopProperties.getInstance();

    public Object receive(MsgDiagnostico msgDiag, String codicePorta, String idModulo, String idMessaggio, long timeout, long checkInterval) throws NodeException, NodeTimeoutException {
        GenericMessage objReturn = null;
        DBManager dbManager = DBManager.getInstance();
        Resource resource = null;
        Connection connectionDB = null;
        String tipoMessaggio = null;
        if (idModulo.startsWith("RicezioneContenutiApplicativi")) {
            tipoMessaggio = "INBOX";
        } else if (idModulo.startsWith("RicezioneBusteEGov")) {
            tipoMessaggio = "OUTBOX";
        }
        OpenSPCoopStateful openspcoopstate = new OpenSPCoopStateful();
        openspcoopstate.setStatoRichiesta((IState)new StatefulMessage(null, null));
        openspcoopstate.setStatoRisposta((IState)new StatefulMessage(null, null));
        GestoreMessaggi gestoreMessaggioRichiesta = new GestoreMessaggi(openspcoopstate, false, idMessaggio, tipoMessaggio, msgDiag);
        try {
            String idRisposta = null;
            GestoreMessaggi gestoreMessaggioRisposta = null;
            boolean messaggioPresente = false;
            int refreshOnlyCacheCount = 0;
            for (long attesa = 0L; attesa < timeout; attesa += checkInterval) {
                msgDiag.highDebug("Analisi richiesta con ID [" + idMessaggio + "] tipo [" + tipoMessaggio + "] contatoreRif[" + ++refreshOnlyCacheCount + "]");
                int nodeDBRefresh = openspcoopProperties.getNodeReceiverCheckDBInterval();
                int nodeRiferimentoMsgRefresh = openspcoopProperties.getNodeReceiverCheckDBInterval();
                try {
                    if (nodeRiferimentoMsgRefresh > 2) {
                        nodeRiferimentoMsgRefresh = nodeDBRefresh / 2;
                    }
                }
                catch (Exception e) {
                    msgDiag.highDebug("CheckDBInterval (proprieta' 'org.openspcoop.pdd.nodeReceiver.checkDB') non corretto: " + e.getMessage());
                }
                msgDiag.highDebug("Proprieta' nodeDBRefresh[" + nodeDBRefresh + "] nodeRiferimentoMsgRefresh[" + nodeRiferimentoMsgRefresh + "]");
                boolean checkOnlyCache = openspcoopProperties.isAbilitataCacheGestoreMessaggi();
                if (refreshOnlyCacheCount == nodeDBRefresh + 1) {
                    msgDiag.highDebug("Re-inizializzo contatore refreshOnlyCacheCount");
                    refreshOnlyCacheCount = 1;
                    checkOnlyCache = false;
                }
                if (refreshOnlyCacheCount % nodeRiferimentoMsgRefresh == 0) {
                    msgDiag.highDebug("Re-inizializzo idRisposta e gestoreMessaggioRisposta");
                    idRisposta = null;
                    gestoreMessaggioRisposta = null;
                }
                boolean needConnection = false;
                if (!openspcoopProperties.singleConnection_TransactionManager()) {
                    needConnection = true;
                } else if (resource == null) {
                    needConnection = true;
                }
                if (!checkOnlyCache && needConnection) {
                    msgDiag.highDebug("Prendo Connessione per NodeReceiver");
                    resource = dbManager.getResource(codicePorta, idModulo);
                    if (resource == null) {
                        throw new NodeException("Risorsa is null");
                    }
                    if (resource.getResource() == null) {
                        throw new NodeException("Connessione is null");
                    }
                    connectionDB = (Connection)resource.getResource();
                    ((StateMessage)openspcoopstate.getStatoRichiesta()).setConnectionDB(connectionDB);
                    ((StateMessage)openspcoopstate.getStatoRisposta()).setConnectionDB(connectionDB);
                }
                if (idRisposta == null) {
                    msgDiag.highDebug("Analisi richiesta con ID [" + idMessaggio + "] tipo [" + tipoMessaggio + "]: lettura ID Risposta");
                    idRisposta = gestoreMessaggioRichiesta.mapRiferimentoIntoIDEgov(checkOnlyCache);
                }
                if (idRisposta != null) {
                    if (gestoreMessaggioRisposta == null) {
                        msgDiag.highDebug("Analisi richiesta con ID [" + idMessaggio + "] tipo [" + tipoMessaggio + "]: Costruisco GestoreRisposta per ID[" + idRisposta + "]");
                        gestoreMessaggioRisposta = new GestoreMessaggi(openspcoopstate, false, idRisposta, tipoMessaggio, msgDiag);
                        msgDiag.highDebug("Analisi risposta con ID [" + idRisposta + "] tipo [" + tipoMessaggio + "]: existsMessage(" + checkOnlyCache + ")");
                        messaggioPresente = checkOnlyCache ? gestoreMessaggioRisposta.existsMessage_onlyCache() : gestoreMessaggioRisposta.existsMessage();
                    } else if (!messaggioPresente) {
                        msgDiag.highDebug("Analisi risposta con ID [" + idRisposta + "] tipo [" + tipoMessaggio + "]: existsMessage(" + checkOnlyCache + ")");
                        messaggioPresente = checkOnlyCache ? gestoreMessaggioRisposta.existsMessage_onlyCache() : gestoreMessaggioRisposta.existsMessage();
                    }
                }
                msgDiag.highDebug("Analisi risposta con ID [" + idRisposta + "] tipo [" + tipoMessaggio + "]: existsMessage=" + messaggioPresente);
                if (messaggioPresente) {
                    msgDiag.highDebug("getProprietario(" + checkOnlyCache + ")");
                    String proprietario = gestoreMessaggioRisposta.getProprietario(idModulo, checkOnlyCache);
                    msgDiag.highDebug("getProprietario(" + checkOnlyCache + ") proprietario=" + proprietario);
                    if (idModulo.startsWith("RicezioneContenutiApplicativi")) {
                        messaggioPresente = idModulo.equals(proprietario);
                    } else if (idModulo.startsWith("RicezioneBusteEGov")) {
                        messaggioPresente = idModulo.equals(proprietario);
                    }
                    msgDiag.highDebug("Analisi risposta con ID [" + idRisposta + "] tipo [" + tipoMessaggio + "] proprietario[" + proprietario + " existsMessage=" + messaggioPresente);
                }
                if (!messaggioPresente) {
                    if (!openspcoopProperties.singleConnection_NodeReceiver() && !checkOnlyCache) {
                        msgDiag.highDebug("Rilascio connessione per NodeReceiver");
                        dbManager.releaseResource(codicePorta, idModulo, resource);
                    }
                    msgDiag.highDebug("Sleep...");
                    try {
                        Thread.sleep(checkInterval);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    continue;
                }
                if (needConnection && checkOnlyCache) {
                    msgDiag.highDebug("Prendo Connessione per NodeReceiver EGOV");
                    resource = dbManager.getResource(codicePorta, idModulo);
                    if (resource == null) {
                        throw new NodeException("Risorsa is null");
                    }
                    if (resource.getResource() == null) {
                        throw new NodeException("Connessione is null");
                    }
                    connectionDB = (Connection)resource.getResource();
                }
                StatefulMessage state = new StatefulMessage(connectionDB, null);
                if (idModulo.startsWith("RicezioneContenutiApplicativi")) {
                    msgDiag.highDebug("Lettura risposta per RicezioneContenutiApplicativi...");
                    objReturn = new RicezioneContenutiApplicativiMessage();
                    ((RicezioneContenutiApplicativiMessage)objReturn).setIdEGovRisposta(idRisposta);
                    RepositoryEGov repositoryEGov = new RepositoryEGov((IState)state, false);
                    ((RicezioneContenutiApplicativiMessage)objReturn).setIdCollaborazione(repositoryEGov.getCollaborazioneFromInBox(idRisposta));
                    ((RicezioneContenutiApplicativiMessage)objReturn).setProfiloCollaborazione(repositoryEGov.getProfiloCollaborazioneFromInBox(idRisposta));
                    msgDiag.highDebug("Lettura risposta per RicezioneContenutiApplicativi effettuata");
                } else if (idModulo.startsWith("RicezioneBusteEGov")) {
                    msgDiag.highDebug("Lettura risposta per RicezioneBusteEGov...");
                    objReturn = new RicezioneBusteEGovMessage();
                    RepositoryEGov repositoryEGov = new RepositoryEGov((IState)state, false);
                    if (repositoryEGov.isRegistrataIntoOutBox(idRisposta)) {
                        ((RicezioneBusteEGovMessage)objReturn).setBustaRisposta(repositoryEGov.getBustaFromOutBox(idRisposta));
                    } else {
                        ((RicezioneBusteEGovMessage)objReturn).setIdMessaggioSblocco(idRisposta);
                    }
                    msgDiag.highDebug("Lettura risposta per RicezioneBusteEGov effettuata");
                }
                if (!openspcoopProperties.singleConnection_NodeReceiver() && !checkOnlyCache) {
                    msgDiag.highDebug("Rilascio connessione per NodeReceiver");
                    dbManager.releaseResource(codicePorta, idModulo, resource);
                }
                msgDiag.highDebug("Fine Lettura");
                break;
            }
        }
        catch (Exception e) {
            throw new NodeException("Riscontrato errore nella ricezione del messaggio di risposta per la gestione della richiesta:" + e.getMessage(), e);
        }
        finally {
            msgDiag.highDebug("Rilascio connessione per NodeReceiver");
            dbManager.releaseResource(codicePorta, idModulo, resource);
        }
        if (objReturn == null) {
            throw new NodeTimeoutException("Riscontrato errore durante ricezione del messaggio: Messaggio non ricevuto");
        }
        return objReturn;
    }
}

