/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.jmx;

import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ReflectionException;
import org.apache.log4j.Logger;
import org.openspcoop.dao.config.MessaggiDiagnostici;
import org.openspcoop.dao.config.OpenspcoopAppender;
import org.openspcoop.dao.config.Tracciamento;
import org.openspcoop.pdd.config.ConfigurazionePdDReader;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.logger.LogLevels;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;

public class ConfigurazionePdD
extends NotificationBroadcasterSupport
implements DynamicMBean {
    static final String CACHE_ABILITATA = "cacheAbilitata";
    static final String MSG_DIAGNOSTICI_SPCOOP_LIVELLO = "livelloMsgDiagnosticiSPCoop";
    static final String MSG_DIAGNOSTICI_OPENSPCOOP_LIVELLO = "livelloMsgDiagnosticiOpenSPCoop";
    static final String MSG_DIAGNOSTICI_APPENDER = "msgDiagnosticiAppender";
    static final String TRACCIAMENTO_ABILITATO = "tracciamentoAbilitato";
    static final String DUMP_ABILITATO = "dumpApplicativoAbilitato";
    static final String TRACCIAMENTO_APPENDER = "tracciamentoAppender";
    static final String RESET_CACHE = "resetCache";
    static final String ABILITA_CACHE = "abilitaCache";
    public boolean cacheAbilitata = false;
    public String livelloMsgDiagnosticiSPCoop = "";
    public String livelloMsgDiagnosticiOpenSPCoop = "";
    public String[] msgDiagnosticiAppender = null;
    public boolean tracciamentoAbilitato = true;
    public boolean dumpApplicativoAbilitato = false;
    public String[] tracciamentoAppender = null;
    private Logger log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
    ConfigurazionePdDReader configReader = ConfigurazionePdDReader.getInstance();
    OpenSPCoopProperties openspcoopProperties = OpenSPCoopProperties.getInstance();

    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attributeName == null || attributeName.equals("")) {
            throw new IllegalArgumentException("Il nome dell'attributo e' nullo o vuoto");
        }
        if (attributeName.equals(CACHE_ABILITATA)) {
            return this.cacheAbilitata;
        }
        if (attributeName.equals(MSG_DIAGNOSTICI_SPCOOP_LIVELLO)) {
            return this.livelloMsgDiagnosticiSPCoop;
        }
        if (attributeName.equals(MSG_DIAGNOSTICI_OPENSPCOOP_LIVELLO)) {
            return this.livelloMsgDiagnosticiOpenSPCoop;
        }
        if (attributeName.equals(MSG_DIAGNOSTICI_APPENDER)) {
            return this.msgDiagnosticiAppender;
        }
        if (attributeName.equals(TRACCIAMENTO_ABILITATO)) {
            return this.tracciamentoAbilitato;
        }
        if (attributeName.equals(DUMP_ABILITATO)) {
            return this.dumpApplicativoAbilitato;
        }
        if (attributeName.equals(TRACCIAMENTO_APPENDER)) {
            return this.tracciamentoAppender;
        }
        throw new AttributeNotFoundException("Attributo " + attributeName + " non trovato");
    }

    public AttributeList getAttributes(String[] attributesNames) {
        if (attributesNames == null) {
            throw new IllegalArgumentException("Array nullo");
        }
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributesNames.length; ++i) {
            try {
                list.add(new Attribute(attributesNames[i], this.getAttribute(attributesNames[i])));
                continue;
            }
            catch (JMException ex) {
                // empty catch block
            }
        }
        return list;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        block13: {
            if (attribute == null) {
                throw new IllegalArgumentException("Il nome dell'attributo e' nullo");
            }
            try {
                if (attribute.getName().equals(CACHE_ABILITATA)) {
                    boolean v = (Boolean)attribute.getValue();
                    if (v && !this.cacheAbilitata) {
                        this.abilitaCache();
                    } else {
                        this.disabilitaCache();
                    }
                    break block13;
                }
                if (attribute.getName().equals(MSG_DIAGNOSTICI_SPCOOP_LIVELLO)) {
                    this.setLivelloMsgDiagnosticiSPCoop((String)attribute.getValue());
                    break block13;
                }
                if (attribute.getName().equals(MSG_DIAGNOSTICI_OPENSPCOOP_LIVELLO)) {
                    this.setLivelloMsgDiagnosticiOpenSPCoop((String)attribute.getValue());
                    break block13;
                }
                if (attribute.getName().equals(MSG_DIAGNOSTICI_APPENDER)) {
                    this.msgDiagnosticiAppender = (String[])attribute.getValue();
                    break block13;
                }
                if (attribute.getName().equals(TRACCIAMENTO_ABILITATO)) {
                    this.setTracciamentoAbilitato((Boolean)attribute.getValue());
                    break block13;
                }
                if (attribute.getName().equals(DUMP_ABILITATO)) {
                    this.setDumpAbilitato((Boolean)attribute.getValue());
                    break block13;
                }
                if (attribute.getName().equals(TRACCIAMENTO_APPENDER)) {
                    this.tracciamentoAppender = (String[])attribute.getValue();
                    break block13;
                }
                throw new AttributeNotFoundException("Attributo " + attribute.getName() + " non trovato");
            }
            catch (ClassCastException ce) {
                throw new InvalidAttributeValueException("il tipo " + attribute.getValue().getClass() + " dell'attributo " + attribute.getName() + " non e' valido");
            }
            catch (JMException j) {
                throw new MBeanException(j);
            }
        }
    }

    public AttributeList setAttributes(AttributeList list) {
        if (list == null) {
            throw new IllegalArgumentException("Lista degli attributi e' nulla");
        }
        AttributeList ret = new AttributeList();
        Iterator it = ret.iterator();
        while (it.hasNext()) {
            try {
                Attribute attribute = (Attribute)it.next();
                this.setAttribute(attribute);
                ret.add(attribute);
            }
            catch (JMException ex) {}
        }
        return ret;
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (actionName == null || actionName.equals("")) {
            throw new IllegalArgumentException("Nessuna operazione definita");
        }
        if (actionName.equals(RESET_CACHE)) {
            return this.resetCache();
        }
        if (actionName.equals(ABILITA_CACHE)) {
            if (params.length != 4) {
                throw new MBeanException(new Exception("[AbilitaCache] Lunghezza parametri non corretta: " + params.length));
            }
            return this.abilitaCache((Long)params[0], (Boolean)params[1], (Long)params[2], (Long)params[3]);
        }
        throw new UnsupportedOperationException("Operazione " + actionName + " sconosciuta");
    }

    public MBeanInfo getMBeanInfo() {
        boolean READABLE = true;
        boolean WRITABLE = true;
        boolean IS_GETTER = true;
        String className = this.getClass().getName();
        String description = "Risorsa per la configurazione della Porta di Dominio OpenSPCoop v1.2";
        MBeanAttributeInfo cacheAbilitataVAR = new MBeanAttributeInfo(CACHE_ABILITATA, Boolean.TYPE.getName(), "Indicazione se e' abilita una cache anteposta alla configurazione letta dalla Porta di Dominio", true, true, false);
        MBeanAttributeInfo livelloMsgDiagnosticiSPCoopVAR = new MBeanAttributeInfo(MSG_DIAGNOSTICI_SPCOOP_LIVELLO, String.class.getName(), "Livello dei messaggi diagnostici emessi dalla Porta di Dominio \n[off,fatalOpenspcoop,errorSpcoop,errorOpenspcoop,infoSpcoop,infoOpenspcoop,debugLow,debugMedium,debugHigh,all]", true, true, false);
        MBeanAttributeInfo livelloMsgDiagnosticiOpenSPCoopVAR = new MBeanAttributeInfo(MSG_DIAGNOSTICI_OPENSPCOOP_LIVELLO, String.class.getName(), "Livello dei messaggi diagnostici human readable emessi dalla Porta di Dominio \n[off,fatalOpenspcoop,errorSpcoop,errorOpenspcoop,infoSpcoop,infoOpenspcoop,debugLow,debugMedium,debugHigh,all]", true, true, false);
        MBeanAttributeInfo msgDiagnosticiAppenderVAR = new MBeanAttributeInfo(MSG_DIAGNOSTICI_APPENDER, String[].class.getName(), "Appender personalizzati per la registrazione dei messaggi diagnostici emessi dalla Porta di Dominio", true, false, false);
        MBeanAttributeInfo tracciamentoAbilitatoVAR = new MBeanAttributeInfo(TRACCIAMENTO_ABILITATO, Boolean.TYPE.getName(), "Indicazione se e' abilito il tracciamento delle buste e-Gov emesse/ricevute dalla Porta di Dominio", true, true, false);
        MBeanAttributeInfo dumpApplicativoAbilitatoVAR = new MBeanAttributeInfo(DUMP_ABILITATO, Boolean.TYPE.getName(), "Indicazione se e' abilito la registrazione dei contenuti applicativi gestiti dalla Porta di Dominio", true, true, false);
        MBeanAttributeInfo tracciamentoAppenderVAR = new MBeanAttributeInfo(TRACCIAMENTO_APPENDER, String[].class.getName(), "Appender personalizzati per la registrazione delle buste e-Gov emesse/ricevute dalla Porta di Dominio", true, false, false);
        MBeanOperationInfo resetCacheOP = new MBeanOperationInfo(RESET_CACHE, "Svuota la cache dei dati letti dalla configurazione della Porta di Dominio", null, String.class.getName(), 1);
        MBeanOperationInfo abilitaCacheParametriOP = new MBeanOperationInfo(ABILITA_CACHE, "Abilita la cache dei dati letti dalla configurazione della Porta di Dominio", new MBeanParameterInfo[]{new MBeanParameterInfo("dimensioneCache", Long.TYPE.getName(), "Dimensione della cache"), new MBeanParameterInfo("algoritmoCacheLRU", Boolean.TYPE.getName(), "Algoritmo utilizzato (lru/mru)"), new MBeanParameterInfo("itemIdleTime", Long.TYPE.getName(), "Indica il massimo intervallo di tempo che un item pu\u00f2 esistere senza essere acceduto (con -1 verra' assegnato un tempo infinito)"), new MBeanParameterInfo("itemLifeSecond", Long.TYPE.getName(), "Vita di un elemento inserito in cache")}, String.class.getName(), 1);
        MBeanConstructorInfo defaultConstructor = new MBeanConstructorInfo("Default Constructor", "Crea e inizializza una nuova istanza del MBean", null);
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{cacheAbilitataVAR, livelloMsgDiagnosticiSPCoopVAR, livelloMsgDiagnosticiOpenSPCoopVAR, msgDiagnosticiAppenderVAR, tracciamentoAbilitatoVAR, dumpApplicativoAbilitatoVAR, tracciamentoAppenderVAR};
        MBeanConstructorInfo[] constructors = new MBeanConstructorInfo[]{defaultConstructor};
        MBeanOperationInfo[] operations = new MBeanOperationInfo[]{resetCacheOP, abilitaCacheParametriOP};
        return new MBeanInfo(className, description, attributes, constructors, operations, null);
    }

    public ConfigurazionePdD() {
        this.cacheAbilitata = this.openspcoopProperties.isAbilitataCacheConfig();
        this.livelloMsgDiagnosticiSPCoop = LogLevels.toStringValue(this.configReader.getSeveritaSPCoop_msgDiagnostici());
        this.livelloMsgDiagnosticiOpenSPCoop = LogLevels.toStringValue(this.configReader.getSeveritaOpenSPCoop_msgDiagnostici());
        MessaggiDiagnostici msg = this.configReader.getOpenSPCoopAppender_MsgDiagnostici();
        if (msg != null && msg.sizeOpenspcoopAppenderList() > 0) {
            this.msgDiagnosticiAppender = new String[msg.sizeOpenspcoopAppenderList()];
            for (int i = 0; i < msg.sizeOpenspcoopAppenderList(); ++i) {
                OpenspcoopAppender appender = msg.getOpenspcoopAppender(i);
                this.msgDiagnosticiAppender[i] = "Appender di tipo " + appender.getTipo() + ", properties size:" + appender.sizePropertyList();
                for (int j = 0; j < appender.sizePropertyList(); ++j) {
                    this.msgDiagnosticiAppender[i] = this.msgDiagnosticiAppender[i] + "\n[nome=" + appender.getProperty(j).getNome() + " valore=" + appender.getProperty(j).getValore() + "]";
                }
            }
        }
        this.tracciamentoAbilitato = this.configReader.tracciamentoBusteEGov();
        this.dumpApplicativoAbilitato = this.configReader.dumpMessaggi();
        Tracciamento tracciamento = this.configReader.getOpenSPCoopAppender_Tracciamento();
        if (tracciamento != null && tracciamento.sizeOpenspcoopAppenderList() > 0) {
            this.tracciamentoAppender = new String[tracciamento.sizeOpenspcoopAppenderList()];
            for (int i = 0; i < tracciamento.sizeOpenspcoopAppenderList(); ++i) {
                OpenspcoopAppender appender = tracciamento.getOpenspcoopAppender(i);
                this.tracciamentoAppender[i] = "Appender di tipo " + appender.getTipo() + ", properties size:" + appender.sizePropertyList();
                for (int j = 0; j < appender.sizePropertyList(); ++j) {
                    this.tracciamentoAppender[i] = this.tracciamentoAppender[i] + "\n[nome=" + appender.getProperty(j).getNome() + " valore=" + appender.getProperty(j).getValore() + "]";
                }
            }
        }
    }

    public String resetCache() {
        try {
            if (!this.cacheAbilitata) {
                throw new Exception("Cache non abilitata");
            }
            ConfigurazionePdDReader.resetCache();
            return "Operazione di reset effettuata con successo";
        }
        catch (Exception e) {
            this.log.error((Object)"Operazione di reset non riuscita", (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public void abilitaCache() {
        try {
            ConfigurazionePdDReader.abilitaCache();
            this.cacheAbilitata = true;
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public String abilitaCache(long dimensioneCache, boolean algoritmoCacheLRU, long itemIdleTime, long itemLifeSecond) {
        try {
            ConfigurazionePdDReader.abilitaCache(dimensioneCache, algoritmoCacheLRU, itemIdleTime, itemLifeSecond);
            this.cacheAbilitata = true;
            return "Abilitazione cache effettuata con successo";
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String disabilitaCache() {
        try {
            ConfigurazionePdDReader.disabilitaCache();
            this.cacheAbilitata = false;
            return "Disabilitazione cache effettuata con successo";
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public void setLivelloMsgDiagnosticiSPCoop(String livelloMsgDiagnosticiSPCoop) throws JMException {
        if (!("off".equals(livelloMsgDiagnosticiSPCoop) || "fatalOpenspcoop".equals(livelloMsgDiagnosticiSPCoop) || "errorSpcoop".equals(livelloMsgDiagnosticiSPCoop) || "errorOpenspcoop".equals(livelloMsgDiagnosticiSPCoop) || "infoSpcoop".equals(livelloMsgDiagnosticiSPCoop) || "infoOpenspcoop".equals(livelloMsgDiagnosticiSPCoop) || "debugLow".equals(livelloMsgDiagnosticiSPCoop) || "debugMedium".equals(livelloMsgDiagnosticiSPCoop) || "debugHigh".equals(livelloMsgDiagnosticiSPCoop) || "all".equals(livelloMsgDiagnosticiSPCoop))) {
            throw new JMException("Livello " + livelloMsgDiagnosticiSPCoop + " non conosciuto");
        }
        this.livelloMsgDiagnosticiSPCoop = livelloMsgDiagnosticiSPCoop;
        ConfigurazionePdDReader.livelloSPCoop_msgDiagnosticiJMX = LogLevels.toOpenSPCoop(this.livelloMsgDiagnosticiSPCoop);
        ConfigurazionePdDReader.severitaSPCoop_msgDiagnosticiJMX = LogLevels.toSPCoop(this.livelloMsgDiagnosticiSPCoop);
    }

    public void setLivelloMsgDiagnosticiOpenSPCoop(String livelloMsgDiagnosticiOpenSPCoop) throws JMException {
        if (!("off".equals(livelloMsgDiagnosticiOpenSPCoop) || "fatalOpenspcoop".equals(livelloMsgDiagnosticiOpenSPCoop) || "errorSpcoop".equals(livelloMsgDiagnosticiOpenSPCoop) || "errorOpenspcoop".equals(livelloMsgDiagnosticiOpenSPCoop) || "infoSpcoop".equals(livelloMsgDiagnosticiOpenSPCoop) || "infoOpenspcoop".equals(livelloMsgDiagnosticiOpenSPCoop) || "debugLow".equals(livelloMsgDiagnosticiOpenSPCoop) || "debugMedium".equals(livelloMsgDiagnosticiOpenSPCoop) || "debugHigh".equals(livelloMsgDiagnosticiOpenSPCoop) || "all".equals(livelloMsgDiagnosticiOpenSPCoop))) {
            throw new JMException("Livello " + livelloMsgDiagnosticiOpenSPCoop + " non conosciuto");
        }
        this.livelloMsgDiagnosticiOpenSPCoop = livelloMsgDiagnosticiOpenSPCoop;
        ConfigurazionePdDReader.livelloOpenSPCoop_msgDiagnosticiJMX = LogLevels.toOpenSPCoop(this.livelloMsgDiagnosticiOpenSPCoop);
        ConfigurazionePdDReader.severitaOpenSPCoop_msgDiagnosticiJMX = LogLevels.toSPCoop(this.livelloMsgDiagnosticiOpenSPCoop);
    }

    public void setTracciamentoAbilitato(boolean v) {
        this.tracciamentoAbilitato = v;
        ConfigurazionePdDReader.tracciamentoBusteEGovJMX = v;
    }

    public void setDumpAbilitato(boolean v) {
        this.dumpApplicativoAbilitato = v;
        ConfigurazionePdDReader.dumpMessaggiJMX = v;
    }
}

