/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.integrazione;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import org.apache.axis.Message;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.PrefixedQName;
import org.apache.axis.message.SOAPHeader;
import org.apache.axis.message.SOAPHeaderElement;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop.pdd.core.integrazione.HeaderIntegrazioneEGov;
import org.openspcoop.pdd.core.integrazione.HeaderIntegrazioneException;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.utils.ValidatoreXSD;
import org.w3c.dom.Node;

public class UtilitiesIntegrazione {
    private Properties keyValueIntegrazione = null;
    private static UtilitiesIntegrazione utilitiesIntegrazione = null;

    public UtilitiesIntegrazione() {
        OpenSPCoopProperties properties = OpenSPCoopProperties.getInstance();
        this.keyValueIntegrazione = properties.getKeyValue_HeaderIntegrazione();
    }

    static UtilitiesIntegrazione getInstance() {
        if (utilitiesIntegrazione == null) {
            UtilitiesIntegrazione.initialize();
        }
        return utilitiesIntegrazione;
    }

    private static synchronized void initialize() {
        if (utilitiesIntegrazione == null) {
            utilitiesIntegrazione = new UtilitiesIntegrazione();
        }
    }

    public void readProperties(Properties prop, HeaderIntegrazione integrazione) throws HeaderIntegrazioneException {
        try {
            if (prop != null && integrazione != null) {
                Enumeration<?> keys = prop.propertyNames();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    if (key == null) continue;
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazione.get("tipoMittente"))) {
                        integrazione.getEgov().setTipoMittente(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazione.get("mittente"))) {
                        integrazione.getEgov().setMittente(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazione.get("tipoDestinatario"))) {
                        integrazione.getEgov().setTipoDestinatario(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazione.get("destinatario"))) {
                        integrazione.getEgov().setDestinatario(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazione.get("tipoServizio"))) {
                        integrazione.getEgov().setTipoServizio(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazione.get("servizio"))) {
                        integrazione.getEgov().setServizio(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazione.get("azione"))) {
                        integrazione.getEgov().setAzione(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazione.get("idegov"))) {
                        integrazione.getEgov().setID(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazione.get("riferimentoMessaggio"))) {
                        integrazione.getEgov().setRiferimentoMessaggio(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazione.get("idCollaborazione"))) {
                        integrazione.getEgov().setIdCollaborazione(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazione.get("idApplicativo"))) {
                        integrazione.setIdApplicativo(prop.getProperty(key));
                        continue;
                    }
                    if (!key.equalsIgnoreCase((String)this.keyValueIntegrazione.get("servizioApplicativo"))) continue;
                    integrazione.setServizioApplicativo(prop.getProperty(key));
                }
            }
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("UtilitiesIntegrazione, lettura dell'header non riuscita: " + e.getMessage(), e);
        }
    }

    public void setProperties(HeaderIntegrazione integrazione, Properties properties) throws HeaderIntegrazioneException {
        try {
            if (properties != null && integrazione != null) {
                if (integrazione.getEgov() != null) {
                    if (integrazione.getEgov().getTipoMittente() != null) {
                        properties.put(this.keyValueIntegrazione.get("tipoMittente"), integrazione.getEgov().getTipoMittente());
                    }
                    if (integrazione.getEgov().getMittente() != null) {
                        properties.put(this.keyValueIntegrazione.get("mittente"), integrazione.getEgov().getMittente());
                    }
                    if (integrazione.getEgov().getTipoDestinatario() != null) {
                        properties.put(this.keyValueIntegrazione.get("tipoDestinatario"), integrazione.getEgov().getTipoDestinatario());
                    }
                    if (integrazione.getEgov().getDestinatario() != null) {
                        properties.put(this.keyValueIntegrazione.get("destinatario"), integrazione.getEgov().getDestinatario());
                    }
                    if (integrazione.getEgov().getTipoServizio() != null) {
                        properties.put(this.keyValueIntegrazione.get("tipoServizio"), integrazione.getEgov().getTipoServizio());
                    }
                    if (integrazione.getEgov().getServizio() != null) {
                        properties.put(this.keyValueIntegrazione.get("servizio"), integrazione.getEgov().getServizio());
                    }
                    if (integrazione.getEgov().getAzione() != null) {
                        properties.put(this.keyValueIntegrazione.get("azione"), integrazione.getEgov().getAzione());
                    }
                    if (integrazione.getEgov().getID() != null) {
                        properties.put(this.keyValueIntegrazione.get("idegov"), integrazione.getEgov().getID());
                    }
                    if (integrazione.getEgov().getRiferimentoMessaggio() != null) {
                        properties.put(this.keyValueIntegrazione.get("riferimentoMessaggio"), integrazione.getEgov().getRiferimentoMessaggio());
                    }
                    if (integrazione.getEgov().getIdCollaborazione() != null) {
                        properties.put(this.keyValueIntegrazione.get("idCollaborazione"), integrazione.getEgov().getIdCollaborazione());
                    }
                }
                if (integrazione.getIdApplicativo() != null) {
                    properties.put(this.keyValueIntegrazione.get("idApplicativo"), integrazione.getIdApplicativo());
                }
                if (integrazione.getServizioApplicativo() != null) {
                    properties.put(this.keyValueIntegrazione.get("servizioApplicativo"), integrazione.getServizioApplicativo());
                }
            }
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("UtilitiesIntegrazione, creazione delle proprieta' dell'header non riuscita: " + e.getMessage(), e);
        }
    }

    public void readHeader(Message message, HeaderIntegrazione integrazione, boolean delete, ValidatoreXSD validatoreXSD, String actorIntegrazione) throws HeaderIntegrazioneException {
        try {
            if (actorIntegrazione == null) {
                throw new Exception("Actor non definito");
            }
            SOAPHeader header = (SOAPHeader)message.getSOAPHeader();
            if (header == null) {
                OpenSPCoopLogger.getLoggerOpenSPCoopCore().debug((Object)"SOAPHeader non presente");
                return;
            }
            SOAPHeaderElement headerElement = null;
            Iterator it = header.examineAllHeaderElements();
            while (it.hasNext() && !actorIntegrazione.equals((headerElement = (SOAPHeaderElement)it.next()).getActor())) {
                headerElement = null;
            }
            if (headerElement == null) {
                OpenSPCoopLogger.getLoggerOpenSPCoopCore().debug((Object)"Header di integrazione non presente");
                return;
            }
            if (validatoreXSD == null) {
                throw new Exception("Validatore XSD non istanziato");
            }
            Name actor = null;
            Name mustUnderstand = null;
            Iterator itR = headerElement.getAllAttributes();
            while (itR.hasNext()) {
                Name n = (Name)itR.next();
                if ("actor".equals(n.getLocalName())) {
                    actor = n;
                    headerElement.removeAttribute(n);
                }
                if (!"mustUnderstand".equals(n.getLocalName())) continue;
                mustUnderstand = n;
                headerElement.removeAttribute(n);
            }
            validatoreXSD.valida((InputStream)new ByteArrayInputStream(headerElement.getAsString().getBytes()));
            if (actor != null) {
                headerElement.addAttribute(actor, actorIntegrazione);
            }
            if (mustUnderstand != null) {
                headerElement.addAttribute(mustUnderstand, "0");
            }
            if (delete) {
                header.removeChild((Node)headerElement);
            }
            String tipoMittente = null;
            try {
                tipoMittente = headerElement.getAttribute((String)this.keyValueIntegrazione.get("tipoMittente"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (tipoMittente != null) {
                integrazione.getEgov().setTipoMittente(tipoMittente);
            }
            String mittente = null;
            try {
                mittente = headerElement.getAttribute((String)this.keyValueIntegrazione.get("mittente"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (mittente != null) {
                integrazione.getEgov().setMittente(mittente);
            }
            String tipoDestinatario = null;
            try {
                tipoDestinatario = headerElement.getAttribute((String)this.keyValueIntegrazione.get("tipoDestinatario"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (tipoDestinatario != null) {
                integrazione.getEgov().setTipoDestinatario(tipoDestinatario);
            }
            String destinatario = null;
            try {
                destinatario = headerElement.getAttribute((String)this.keyValueIntegrazione.get("destinatario"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (destinatario != null) {
                integrazione.getEgov().setDestinatario(destinatario);
            }
            String tipoServizio = null;
            try {
                tipoServizio = headerElement.getAttribute((String)this.keyValueIntegrazione.get("tipoServizio"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (tipoServizio != null) {
                integrazione.getEgov().setTipoServizio(tipoServizio);
            }
            String servizio = null;
            try {
                servizio = headerElement.getAttribute((String)this.keyValueIntegrazione.get("servizio"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (servizio != null) {
                integrazione.getEgov().setServizio(servizio);
            }
            String azione = null;
            try {
                azione = headerElement.getAttribute((String)this.keyValueIntegrazione.get("azione"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (azione != null) {
                integrazione.getEgov().setAzione(azione);
            }
            String idEGov = null;
            try {
                idEGov = headerElement.getAttribute((String)this.keyValueIntegrazione.get("idegov"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (idEGov != null) {
                integrazione.getEgov().setID(idEGov);
            }
            String riferimentoMessaggio = null;
            try {
                riferimentoMessaggio = headerElement.getAttribute((String)this.keyValueIntegrazione.get("riferimentoMessaggio"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (riferimentoMessaggio != null) {
                integrazione.getEgov().setRiferimentoMessaggio(riferimentoMessaggio);
            }
            String collaborazione = null;
            try {
                collaborazione = headerElement.getAttribute((String)this.keyValueIntegrazione.get("idCollaborazione"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (collaborazione != null) {
                integrazione.getEgov().setIdCollaborazione(collaborazione);
            }
            String idApplicativo = null;
            try {
                idApplicativo = headerElement.getAttribute((String)this.keyValueIntegrazione.get("idApplicativo"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (idApplicativo != null) {
                integrazione.setIdApplicativo(idApplicativo);
            }
            String sa = null;
            try {
                sa = headerElement.getAttribute((String)this.keyValueIntegrazione.get("servizioApplicativo"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (sa != null) {
                integrazione.setServizioApplicativo(sa);
            }
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("UtilitiesIntegrazione, lettura dell'header soap non riuscita: " + e.getMessage(), e);
        }
    }

    public void updateHeader(Message message, IDSoggetto soggettoFruitore, IDServizio idServizio, String idEGov, String servizioApplicativo, String correlazioneApplicativa, String actorIntegrazione, String nomeElemento, String prefix, String namespace) throws Exception {
        HeaderIntegrazione integrazione = new HeaderIntegrazione();
        integrazione.setIdApplicativo(correlazioneApplicativa);
        integrazione.setServizioApplicativo(servizioApplicativo);
        HeaderIntegrazioneEGov egov = new HeaderIntegrazioneEGov();
        egov.setTipoMittente(soggettoFruitore.getTipo());
        egov.setMittente(soggettoFruitore.getNome());
        egov.setTipoDestinatario(idServizio.getSoggettoErogatore().getTipo());
        egov.setDestinatario(idServizio.getSoggettoErogatore().getNome());
        egov.setTipoServizio(idServizio.getTipoServizio());
        egov.setServizio(idServizio.getServizio());
        egov.setAzione(idServizio.getAzione());
        egov.setID(idEGov);
        integrazione.setEgov(egov);
        this.updateHeader(message, integrazione, actorIntegrazione, nomeElemento, prefix, namespace);
    }

    public void updateHeader(Message message, HeaderIntegrazione integrazione, String actorIntegrazione, String nomeElemento, String prefix, String namespace) throws Exception {
        MessageElement tmp;
        if (actorIntegrazione == null) {
            throw new Exception("Actor non definito");
        }
        SOAPHeader header = (SOAPHeader)message.getSOAPHeader();
        SOAPHeaderElement headerIntegrazione = null;
        if (header == null) {
            OpenSPCoopLogger.getLoggerOpenSPCoopCore().debug((Object)"SOAPHeader non presente: add soapHeader");
            header = (SOAPHeader)message.getSOAPEnvelope().addHeader();
        } else {
            Iterator it = header.examineAllHeaderElements();
            while (it.hasNext() && !actorIntegrazione.equals((headerIntegrazione = (SOAPHeaderElement)it.next()).getActor())) {
                headerIntegrazione = null;
            }
            if (headerIntegrazione == null) {
                OpenSPCoopLogger.getLoggerOpenSPCoopCore().debug((Object)"Header di integrazione non presente, lo creo");
            }
        }
        Vector<MessageElement> v = new Vector<MessageElement>();
        if (headerIntegrazione != null) {
            Iterator it = headerIntegrazione.getChildElements();
            if (it.hasNext()) {
                tmp = (MessageElement)it.next();
                v.add(tmp);
            }
            header.removeChild((Node)headerIntegrazione);
        }
        SOAPHeaderElement headerIntegrazioneNEW = this.buildHeader(integrazione, nomeElemento, prefix, namespace, actorIntegrazione);
        while (v.size() > 0) {
            tmp = (MessageElement)v.remove(0);
            headerIntegrazioneNEW.addChildElement((SOAPElement)tmp);
        }
        header.addChildElement((SOAPElement)headerIntegrazioneNEW);
    }

    public SOAPHeaderElement buildHeader(HeaderIntegrazione integrazione, String nomeElemento, String prefix, String namespace, String actor) throws HeaderIntegrazioneException {
        try {
            PrefixedQName name = new PrefixedQName(namespace, nomeElemento, prefix);
            SOAPHeaderElement header = new SOAPHeaderElement((Name)name);
            header.setActor(actor);
            header.setMustUnderstand(false);
            header.addNamespaceDeclaration("SOAP_ENV", "http://schemas.xmlsoap.org/soap/envelope/");
            this.setAttributes(integrazione, header);
            return header;
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("UtilitiesIntegrazione, creazione dell'header soap non riuscita: " + e.getMessage(), e);
        }
    }

    public void setAttributes(HeaderIntegrazione integrazione, SOAPHeaderElement header) {
        String name;
        if (integrazione.getEgov() != null) {
            if (integrazione.getEgov().getTipoMittente() != null) {
                name = (String)this.keyValueIntegrazione.get("tipoMittente");
                header.setAttribute(name, integrazione.getEgov().getTipoMittente());
            }
            if (integrazione.getEgov().getMittente() != null) {
                name = (String)this.keyValueIntegrazione.get("mittente");
                header.setAttribute(name, integrazione.getEgov().getMittente());
            }
            if (integrazione.getEgov().getTipoDestinatario() != null) {
                name = (String)this.keyValueIntegrazione.get("tipoDestinatario");
                header.setAttribute(name, integrazione.getEgov().getTipoDestinatario());
            }
            if (integrazione.getEgov().getDestinatario() != null) {
                name = (String)this.keyValueIntegrazione.get("destinatario");
                header.setAttribute(name, integrazione.getEgov().getDestinatario());
            }
            if (integrazione.getEgov().getTipoServizio() != null) {
                name = (String)this.keyValueIntegrazione.get("tipoServizio");
                header.setAttribute(name, integrazione.getEgov().getTipoServizio());
            }
            if (integrazione.getEgov().getServizio() != null) {
                name = (String)this.keyValueIntegrazione.get("servizio");
                header.setAttribute(name, integrazione.getEgov().getServizio());
            }
            if (integrazione.getEgov().getAzione() != null) {
                name = (String)this.keyValueIntegrazione.get("azione");
                header.setAttribute(name, integrazione.getEgov().getAzione());
            }
            if (integrazione.getEgov().getID() != null) {
                name = (String)this.keyValueIntegrazione.get("idegov");
                header.setAttribute(name, integrazione.getEgov().getID());
            }
            if (integrazione.getEgov().getRiferimentoMessaggio() != null) {
                name = (String)this.keyValueIntegrazione.get("riferimentoMessaggio");
                header.setAttribute(name, integrazione.getEgov().getRiferimentoMessaggio());
            }
            if (integrazione.getEgov().getIdCollaborazione() != null) {
                name = (String)this.keyValueIntegrazione.get("idCollaborazione");
                header.setAttribute(name, integrazione.getEgov().getIdCollaborazione());
            }
        }
        if (integrazione.getIdApplicativo() != null) {
            name = (String)this.keyValueIntegrazione.get("idApplicativo");
            header.setAttribute(name, integrazione.getIdApplicativo());
        }
        if (integrazione.getServizioApplicativo() != null) {
            name = (String)this.keyValueIntegrazione.get("servizioApplicativo");
            header.setAttribute(name, integrazione.getServizioApplicativo());
        }
    }
}

