/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.integrazione;

import java.util.Properties;
import javax.xml.soap.SOAPElement;
import org.apache.axis.Message;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.log4j.Logger;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop.pdd.core.integrazione.HeaderIntegrazioneException;
import org.openspcoop.pdd.core.integrazione.IGestoreIntegrazionePASoap;
import org.openspcoop.pdd.core.integrazione.UtilitiesIntegrazione;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.utils.ValidatoreXSD;

public class GestoreIntegrazionePASoap
implements IGestoreIntegrazionePASoap {
    UtilitiesIntegrazione utilities = UtilitiesIntegrazione.getInstance();
    OpenSPCoopProperties openspcoopProperties = OpenSPCoopProperties.getInstance();
    private ValidatoreXSD validatoreXSD = null;
    private static Logger log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();

    public GestoreIntegrazionePASoap() {
        try {
            this.validatoreXSD = new ValidatoreXSD(UtilitiesIntegrazione.class.getResourceAsStream("/integrazione.xsd"));
        }
        catch (Exception e) {
            log.error((Object)("Integrazione.xsd, errore durante la costruzione del validatore xsd: " + e.getMessage()));
        }
    }

    public void readHeader(HeaderIntegrazione integrazione, Message message, boolean deleteHeader) throws HeaderIntegrazioneException {
        try {
            this.utilities.readHeader(message, integrazione, deleteHeader, this.validatoreXSD, this.openspcoopProperties.getHeaderSoapActorIntegrazione());
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDSoap, " + e.getMessage(), e);
        }
    }

    public void setHeader(HeaderIntegrazione integrazione, Message message, Properties properties) throws HeaderIntegrazioneException {
        try {
            SOAPHeaderElement header = this.utilities.buildHeader(integrazione, this.openspcoopProperties.getHeaderSoapNameIntegrazione(), this.openspcoopProperties.getHeaderSoapPrefixIntegrazione(), this.openspcoopProperties.getHeaderSoapActorIntegrazione(), this.openspcoopProperties.getHeaderSoapActorIntegrazione());
            message.getSOAPHeader().addChildElement((SOAPElement)header);
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePASoap, " + e.getMessage(), e);
        }
    }

    public void updateHeader(HeaderIntegrazione integrazione, Message message) throws HeaderIntegrazioneException {
        try {
            this.utilities.updateHeader(message, integrazione, this.openspcoopProperties.getHeaderSoapActorIntegrazione(), this.openspcoopProperties.getHeaderSoapNameIntegrazione(), this.openspcoopProperties.getHeaderSoapPrefixIntegrazione(), this.openspcoopProperties.getHeaderSoapActorIntegrazione());
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDSoap, " + e.getMessage(), e);
        }
    }
}

