/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.connettori;

import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Date;
import javax.xml.soap.SOAPException;
import org.apache.axis.Message;
import org.apache.axis.message.SOAPBody;
import org.apache.axis.message.SOAPFault;
import org.apache.log4j.Logger;
import org.openspcoop.dao.config.GestioneErrore;
import org.openspcoop.dao.config.GestioneErroreCodiceTrasporto;
import org.openspcoop.dao.config.GestioneErroreSoapFault;
import org.openspcoop.pdd.core.GestoreMessaggiException;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.utils.SoapUtils;
import org.openspcoop.utils.UtilsException;
import org.openspcoop.utils.date.DateManager;

public class GestoreErroreConnettore {
    private boolean riconsegna;
    private Timestamp dataRispedizione;
    private String errore;
    private SOAPFault fault;
    private static Logger log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
    private static GestioneErrore gestioneErroreDefaultComponenteIntegrazione = null;
    private static GestioneErrore gestioneErroreDefaultComponenteCooperazione = null;

    public static GestioneErrore getGestioneErroreDefaultComponenteIntegrazione() {
        if (gestioneErroreDefaultComponenteIntegrazione != null) {
            return gestioneErroreDefaultComponenteIntegrazione;
        }
        GestioneErrore gestione = new GestioneErrore();
        gestione.setComportamento("rispedisci");
        GestioneErroreCodiceTrasporto codiceTrasporto = new GestioneErroreCodiceTrasporto();
        codiceTrasporto.setComportamento("accetta");
        codiceTrasporto.setValoreMinimo(new BigInteger("200"));
        codiceTrasporto.setValoreMassimo(new BigInteger("299"));
        gestione.addCodiceTrasporto(codiceTrasporto);
        GestioneErroreSoapFault faultAccetta = new GestioneErroreSoapFault();
        faultAccetta.setComportamento("accetta");
        gestione.addSoapFault(faultAccetta);
        gestioneErroreDefaultComponenteIntegrazione = gestione;
        return gestione;
    }

    public static GestioneErrore getGestioneErroreDefaultComponenteCooperazione() {
        if (gestioneErroreDefaultComponenteCooperazione != null) {
            return gestioneErroreDefaultComponenteCooperazione;
        }
        GestioneErrore gestione = new GestioneErrore();
        gestione.setComportamento("rispedisci");
        GestioneErroreCodiceTrasporto codiceTrasporto = new GestioneErroreCodiceTrasporto();
        codiceTrasporto.setComportamento("accetta");
        codiceTrasporto.setValoreMinimo(new BigInteger("200"));
        codiceTrasporto.setValoreMassimo(new BigInteger("299"));
        gestione.addCodiceTrasporto(codiceTrasporto);
        GestioneErroreSoapFault faultClient = new GestioneErroreSoapFault();
        faultClient.setFaultCode("Client");
        faultClient.setFaultString("EGOV_IT_001 - Formato Busta non corretto");
        faultClient.setComportamento("accetta");
        gestione.addSoapFault(faultClient);
        GestioneErroreSoapFault faultSoapClient = new GestioneErroreSoapFault();
        faultSoapClient.setFaultCode("soap:Client");
        faultSoapClient.setFaultString("EGOV_IT_001 - Formato Busta non corretto");
        faultSoapClient.setComportamento("accetta");
        gestione.addSoapFault(faultSoapClient);
        GestioneErroreSoapFault faultServer = new GestioneErroreSoapFault();
        faultServer.setFaultCode("Server");
        faultServer.setFaultString("EGOV_IT_300 - Errore nel processamento del messaggio SPCoop");
        faultServer.setComportamento("rispedisci");
        gestione.addSoapFault(faultServer);
        GestioneErroreSoapFault faultSoapServer = new GestioneErroreSoapFault();
        faultSoapServer.setFaultCode("soap:Server");
        faultSoapServer.setFaultString("EGOV_IT_300 - Errore nel processamento del messaggio SPCoop");
        faultSoapServer.setComportamento("rispedisci");
        gestione.addSoapFault(faultSoapServer);
        gestioneErroreDefaultComponenteCooperazione = gestione;
        return gestione;
    }

    public boolean verificaConsegna(GestioneErrore gestioneErrore, String msgErroreConnettore, long codiceTrasporto, Message messageResponse) throws GestoreMessaggiException, SOAPException, UtilsException {
        GestioneErroreCodiceTrasporto gestore;
        int i;
        Date now = DateManager.getDate();
        this.dataRispedizione = new Timestamp(now.getTime());
        if (msgErroreConnettore != null) {
            this.errore = msgErroreConnettore;
            if ("rispedisci".equalsIgnoreCase(gestioneErrore.getComportamento())) {
                this.riconsegna = true;
                if (gestioneErrore.getCadenzaRispedizione() != null) {
                    try {
                        int cadenzaRispedizione = Integer.parseInt(gestioneErrore.getCadenzaRispedizione());
                        this.dataRispedizione = new Timestamp(now.getTime() + (long)(cadenzaRispedizione * 60 * 1000));
                    }
                    catch (Exception e) {
                        log.error((Object)("Intervallo di rispedizione non impostato: " + e.getMessage()));
                    }
                }
            } else {
                this.riconsegna = false;
            }
            return false;
        }
        SOAPBody body = null;
        if (messageResponse != null) {
            body = (SOAPBody)messageResponse.getSOAPBody();
        }
        if (body != null && body.hasFault()) {
            this.fault = (SOAPFault)body.getFault();
            for (i = 0; i < gestioneErrore.sizeSoapFaultList(); ++i) {
                gestore = gestioneErrore.getSoapFault(i);
                boolean match = true;
                if (gestore.getFaultCode() != null && !gestore.getFaultCode().equalsIgnoreCase(this.fault.getFaultCode())) {
                    match = false;
                }
                if (gestore.getFaultActor() != null && !gestore.getFaultActor().equalsIgnoreCase(this.fault.getFaultActor())) {
                    match = false;
                }
                if (!(gestore.getFaultString() == null || this.fault.getFaultString().contains(gestore.getFaultString()) || this.fault.getFaultString().contains(gestore.getFaultString().toLowerCase()) || this.fault.getFaultString().contains(gestore.getFaultString().toUpperCase()))) {
                    match = false;
                }
                if (!match) continue;
                if ("rispedisci".equalsIgnoreCase(gestore.getComportamento())) {
                    this.errore = "errore applicativo, " + SoapUtils.toString((SOAPFault)this.fault);
                    this.riconsegna = true;
                    if (gestore.getCadenzaRispedizione() != null) {
                        try {
                            int cadenzaRispedizione = Integer.parseInt(gestore.getCadenzaRispedizione());
                            this.dataRispedizione = new Timestamp(now.getTime() + (long)(cadenzaRispedizione * 60 * 1000));
                        }
                        catch (Exception e) {
                            log.error((Object)("Intervallo di rispedizione non impostato (soap fault): " + e.getMessage()));
                        }
                    } else if (gestioneErrore.getCadenzaRispedizione() != null) {
                        try {
                            int cadenzaRispedizione = Integer.parseInt(gestioneErrore.getCadenzaRispedizione());
                            this.dataRispedizione = new Timestamp(now.getTime() + (long)(cadenzaRispedizione * 60 * 1000));
                        }
                        catch (Exception e) {
                            log.error((Object)("Intervallo di rispedizione non impostato: " + e.getMessage()));
                        }
                    }
                    return false;
                }
                this.riconsegna = false;
                return true;
            }
        }
        for (i = 0; i < gestioneErrore.sizeCodiceTrasportoList(); ++i) {
            gestore = gestioneErrore.getCodiceTrasporto(i);
            long valoreMinimo = Long.MIN_VALUE;
            long valoreMassimo = Long.MAX_VALUE;
            if (gestore.getValoreMinimo() != null) {
                valoreMinimo = gestore.getValoreMinimo().longValue();
            }
            if (gestore.getValoreMassimo() != null) {
                valoreMassimo = gestore.getValoreMassimo().longValue();
            }
            if (codiceTrasporto < valoreMinimo || codiceTrasporto > valoreMassimo) continue;
            if ("rispedisci".equalsIgnoreCase(gestore.getComportamento())) {
                this.errore = "errore di trasporto, codice " + codiceTrasporto;
                if (this.fault != null) {
                    this.errore = this.errore + " (" + SoapUtils.toString((SOAPFault)this.fault) + ")";
                }
                this.riconsegna = true;
                if (gestore.getCadenzaRispedizione() != null) {
                    try {
                        int cadenzaRispedizione = Integer.parseInt(gestore.getCadenzaRispedizione());
                        this.dataRispedizione = new Timestamp(now.getTime() + (long)(cadenzaRispedizione * 60 * 1000));
                    }
                    catch (Exception e) {
                        log.error((Object)("Intervallo di rispedizione non impostato (codice di trasporto): " + e.getMessage()));
                    }
                } else if (gestioneErrore.getCadenzaRispedizione() != null) {
                    try {
                        int cadenzaRispedizione = Integer.parseInt(gestioneErrore.getCadenzaRispedizione());
                        this.dataRispedizione = new Timestamp(now.getTime() + (long)(cadenzaRispedizione * 60 * 1000));
                    }
                    catch (Exception e) {
                        log.error((Object)("Intervallo di rispedizione non impostato: " + e.getMessage()));
                    }
                }
                return false;
            }
            this.riconsegna = false;
            return true;
        }
        if ("rispedisci".equalsIgnoreCase(gestioneErrore.getComportamento())) {
            this.errore = "errore di trasporto, codice " + codiceTrasporto;
            if (this.fault != null) {
                this.errore = this.errore + " (" + SoapUtils.toString((SOAPFault)this.fault) + ")";
            }
            this.riconsegna = true;
            if (gestioneErrore.getCadenzaRispedizione() != null) {
                try {
                    int cadenzaRispedizione = Integer.parseInt(gestioneErrore.getCadenzaRispedizione());
                    this.dataRispedizione = new Timestamp(now.getTime() + (long)(cadenzaRispedizione * 60 * 1000));
                }
                catch (Exception e) {
                    log.error((Object)("Intervallo di rispedizione non impostato: " + e.getMessage()));
                }
            }
            return false;
        }
        this.riconsegna = false;
        return true;
    }

    public String getErrore() {
        return this.errore;
    }

    public boolean isRiconsegna() {
        return this.riconsegna;
    }

    public Timestamp getDataRispedizione() {
        return this.dataRispedizione;
    }

    public SOAPFault getFault() {
        return this.fault;
    }
}

