/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.connettori;

import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import javax.xml.messaging.URLEndpoint;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.AxisProperties;
import org.apache.axis.Message;
import org.apache.axis.soap.SOAPConnectionImpl;
import org.apache.log4j.Logger;
import org.openspcoop.egov.Busta;
import org.openspcoop.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop.pdd.core.connettori.IConnettore;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;

public class ConnettoreSAAJ
implements IConnettore {
    private Logger log = null;
    private String errore;
    private Message response;
    private int codice;
    private Message requestMsg;
    private Hashtable<String, String> properties;
    private Busta bustaSPCoop;
    private String idEGovMessaggio;
    private boolean debug = false;

    public boolean send(ConnettoreMsg request) {
        this.log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        if (request == null) {
            this.errore = "Messaggio da consegnare is Null (ConnettoreMsg)";
            return false;
        }
        this.requestMsg = request.getRequestMessage();
        this.properties = request.getConnectorProperties();
        this.bustaSPCoop = request.getBusta();
        if (this.bustaSPCoop != null) {
            this.idEGovMessaggio = this.bustaSPCoop.getID();
        }
        if (this.requestMsg == null) {
            this.errore = "Messaggio da consegnare is Null (AxisMsg)";
            return false;
        }
        if (this.properties == null) {
            this.errore = "Proprieta' del connettore non definite";
        }
        if (this.properties.size() == 0) {
            this.errore = "Proprieta' del connettore non definite";
        }
        if (this.properties.get("location") == null) {
            this.errore = "Proprieta' 'location' non fornita e richiesta da questo tipo di connettore [" + request.getTipoConnettore() + "]";
            return false;
        }
        if (this.properties.get("debug") != null && "true".equalsIgnoreCase(this.properties.get("debug").trim())) {
            this.debug = true;
        }
        return this.sendSAAJ();
    }

    private boolean sendSAAJ() {
        try {
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] impostazione timeout..."));
            }
            int connectionTimeout = -1;
            int readConnectionTimeout = -1;
            if (this.properties.get("connection-timeout") != null) {
                try {
                    connectionTimeout = Integer.parseInt(this.properties.get("connection-timeout"));
                }
                catch (Exception e) {
                    this.log.error((Object)"Parametro connection-timeout errato", (Throwable)e);
                }
            }
            if (connectionTimeout == -1) {
                connectionTimeout = 10000;
            }
            if (this.properties.get("read-connection-timeout") != null) {
                try {
                    readConnectionTimeout = Integer.parseInt(this.properties.get("read-connection-timeout"));
                }
                catch (Exception e) {
                    this.log.error((Object)"Parametro read-connection-timeout errato", (Throwable)e);
                }
            }
            if (readConnectionTimeout == -1) {
                readConnectionTimeout = 120000;
            }
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] impostazione http timeout CT[" + connectionTimeout + "] RT[" + readConnectionTimeout + "]..."));
            }
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] check validita URL..."));
            }
            URL urlTest = new URL(this.properties.get("location"));
            URLConnection connectionTest = urlTest.openConnection();
            HttpURLConnection httpConnTest = (HttpURLConnection)connectionTest;
            httpConnTest.setRequestMethod("POST");
            httpConnTest.setConnectTimeout(connectionTimeout);
            httpConnTest.setReadTimeout(readConnectionTimeout);
            httpConnTest.setDoOutput(true);
            OutputStream outTest = httpConnTest.getOutputStream();
            outTest.close();
            httpConnTest.disconnect();
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] prefixOptimization..."));
            }
            String prefixOptimization = "true";
            if (this.properties.get("prefix-optimization") != null) {
                if ("false".equalsIgnoreCase(this.properties.get("prefix-optimization"))) {
                    prefixOptimization = "false";
                }
                this.log.info((Object)("Prefix Optimization = '" + prefixOptimization + "'"));
                AxisProperties.setProperty((String)"enableNamespacePrefixOptimization", (String)prefixOptimization);
            }
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] creazione connessione..."));
            }
            SOAPConnectionImpl connection = new SOAPConnectionImpl();
            URLEndpoint urlConnection = new URLEndpoint(this.properties.get("location"));
            try {
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] set timeout..."));
                }
                connection.setTimeout(Integer.valueOf(readConnectionTimeout));
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] send..."));
                }
                this.response = (Message)connection.call((SOAPMessage)this.requestMsg, (Object)urlConnection);
            }
            catch (SOAPException sendError) {
                String errorMsg = sendError.getMessage();
                connection.close();
                this.errore = "Errore avvenuto durante la consegna SOAP (lettura risposta): " + errorMsg;
                return false;
            }
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] check consistenza..."));
            }
            if (this.response != null && this.response.getSOAPBody() != null && this.response.getSOAPBody().hasFault() && this.response.getSOAPBody().getFault().getFaultString().indexOf("Premature end of file") != -1) {
                this.response = null;
            }
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] connection.close ..."));
            }
            connection.close();
            this.codice = 200;
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] gestione invio/risposta http effettuata con successo"));
            }
            return true;
        }
        catch (Exception e) {
            this.errore = "Errore avvenuto durante la consegna SOAP: " + e.getMessage();
            return false;
        }
    }

    public String getErrore() {
        return this.errore;
    }

    public int getCodiceTrasporto() {
        return this.codice;
    }

    public Message getResponse() {
        return this.response;
    }
}

