/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.connettori;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import javax.naming.InitialContext;
import org.apache.axis.Message;
import org.apache.axis.soap.SOAP11Constants;
import org.apache.axis.soap.SOAPConstants;
import org.apache.log4j.Logger;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.egov.Busta;
import org.openspcoop.pdd.core.autenticazione.Credenziali;
import org.openspcoop.pdd.core.connettori.ConnettoreJMSProperties;
import org.openspcoop.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop.pdd.core.connettori.IConnettore;
import org.openspcoop.pdd.core.connettori.IConnettoreJMSSetProperties;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.utils.SoapUtils;

public class ConnettoreJMS
implements IConnettore {
    private static final String QUEUE = "queue";
    private static final String TOPIC = "topic";
    private static final String TEXT_MESSAGE = "TextMessage";
    private static final String BYTES_MESSAGE = "BytesMessage";
    private static final String LOCATIONS_CACHE_ABILITATA = "abilitata";
    private static final String LOCATIONS_CACHE_DISABILITATA = "disabilitata";
    private static Hashtable<String, Destination> locations = new Hashtable();
    private Logger log = null;
    private String errore;
    private Message response;
    private int codice;
    private Message requestMsg;
    private Hashtable<String, String> properties;
    private boolean sbustamentoSoap;
    private Properties propertiesTrasporto;
    private Busta bustaSPCoop;
    private String tipoConnettore;
    private String idEGovMessaggio;
    private Credenziali credenziali;
    private boolean debug = false;
    private int acknowledgeModeSessione = 1;

    public boolean send(ConnettoreMsg request) {
        if (request == null) {
            this.errore = "Messaggio da consegnare is Null (ConnettoreMsg)";
            return false;
        }
        this.log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        this.requestMsg = request.getRequestMessage();
        this.properties = request.getConnectorProperties();
        this.sbustamentoSoap = request.getSbustamentoSOAP();
        this.propertiesTrasporto = request.getPropertiesTrasporto();
        this.bustaSPCoop = request.getBusta();
        if (this.bustaSPCoop != null) {
            this.idEGovMessaggio = this.bustaSPCoop.getID();
        }
        this.credenziali = request.getCredenziali();
        if (this.requestMsg == null) {
            this.errore = "Messaggio da consegnare is Null (AxisMsg)";
            return false;
        }
        if (this.properties == null) {
            this.errore = "Proprieta' del connettore non definite";
        }
        if (this.properties.size() == 0) {
            this.errore = "Proprieta' del connettore non definite";
        }
        this.tipoConnettore = request.getTipoConnettore();
        if (this.properties.get("location") == null) {
            this.errore = "Proprieta' 'location' non fornita e richiesta da questo tipo di connettore [" + request.getTipoConnettore() + "]";
            return false;
        }
        if (this.properties.get("tipo") == null) {
            this.errore = "Proprieta' 'tipo' non fornita e richiesta da questo tipo di connettore [" + request.getTipoConnettore() + "]";
            return false;
        }
        if (!this.properties.get("tipo").equalsIgnoreCase(QUEUE) && !this.properties.get("tipo").equalsIgnoreCase(TOPIC)) {
            this.errore = "Proprieta' 'tipo' non correttamente fornita per il connettore [" + request.getTipoConnettore() + "] \n(Valori possibili sono 'queue' o 'topic')";
            return false;
        }
        if (this.properties.get("locations-cache") != null && !this.properties.get("locations-cache").equalsIgnoreCase(LOCATIONS_CACHE_ABILITATA) && !this.properties.get("locations-cache").equalsIgnoreCase(LOCATIONS_CACHE_DISABILITATA)) {
            this.errore = "Proprieta' 'locations-cache' non correttamente fornita per il connettore [" + request.getTipoConnettore() + "] \n(Valori possibili sono 'abilitata' o 'disabilitata')";
            return false;
        }
        if (this.properties.get("connection-factory") == null) {
            this.errore = "Proprieta' 'connection-factory' non fornita e richiesta da questo tipo di connettore [" + request.getTipoConnettore() + "]";
            return false;
        }
        if (this.properties.get("send-as") == null) {
            this.errore = "Proprieta' 'send-as' non fornita e richiesta da questo tipo di connettore [" + request.getTipoConnettore() + "]";
            return false;
        }
        if (!this.properties.get("send-as").equalsIgnoreCase(TEXT_MESSAGE) && !this.properties.get("send-as").equalsIgnoreCase(BYTES_MESSAGE)) {
            this.errore = "Proprieta' 'send-as' non correttamente fornita per il connettore [" + request.getTipoConnettore() + "] \n(Valori possibili sono 'TextMessage' o 'BytesMessage')";
            return false;
        }
        if (this.properties.get("acknowledgeMode") != null) {
            if ("AUTO_ACKNOWLEDGE".equals(this.properties.get("acknowledgeMode"))) {
                this.acknowledgeModeSessione = 1;
            } else if ("CLIENT_ACKNOWLEDGE".equals(this.properties.get("acknowledgeMode"))) {
                this.acknowledgeModeSessione = 2;
            } else if ("DUPS_OK_ACKNOWLEDGE".equals(this.properties.get("acknowledgeMode"))) {
                this.acknowledgeModeSessione = 3;
            } else {
                this.log.error((Object)"Tipo di acknowledgeModeSessione non conosciuto (viene utilizzato il default:AUTO_ACKNOWLEDGE)");
            }
        }
        if (this.properties.get("debug") != null && "true".equalsIgnoreCase(this.properties.get("debug").trim())) {
            this.debug = true;
        }
        return this.sendJMS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendJMS() {
        boolean bl;
        Connection qc = null;
        Session qs = null;
        ConnectionFactory qcf = null;
        MessageProducer sender = null;
        Queue queueDestination = null;
        Topic topicDestination = null;
        InitialContext ctxJMS = null;
        InitialContext ctxLocalPool = null;
        try {
            String connectionFactory;
            ConnettoreJMSProperties overwriteProperties;
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] trasformazione del messaggio in byte..."));
            }
            byte[] consegna = null;
            if (this.sbustamentoSoap) {
                consegna = SoapUtils.sbustamentoMessaggio((Message)this.requestMsg);
            } else {
                ByteArrayOutputStream reqBuffer = new ByteArrayOutputStream();
                this.requestMsg.writeTo((OutputStream)reqBuffer);
                consegna = reqBuffer.toByteArray();
                reqBuffer.close();
            }
            if (consegna == null) {
                this.errore = "Errore avvenuto durante la consegna JMS: Trasformazione del messaggio in byte[] non riuscita";
                boolean reqBuffer = false;
                return reqBuffer;
            }
            if (this.debug) {
                try {
                    String contentTypeRichiesta = this.requestMsg.getContentType((SOAPConstants)new SOAP11Constants());
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] Messaggio inviato (ContentType:" + contentTypeRichiesta + ") :\n" + new String(consegna)));
                }
                catch (Exception e) {
                    this.log.error((Object)("[" + this.idEGovMessaggio + "] DebugMode, log del messaggio inviato non riuscito"), (Throwable)e);
                }
            }
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] raccolta credenziali..."));
            }
            String user = null;
            String password = null;
            if (this.credenziali != null) {
                user = this.credenziali.getUsername();
                password = this.credenziali.getPassword();
            } else {
                user = this.properties.get("user");
                password = this.properties.get("password");
            }
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] creazione jndi context ed eventuale pool-local-context..."));
            }
            Properties propertiesJMS = new Properties();
            Properties propertiesLocalPool = new Properties();
            Enumeration<String> enumCTX = this.properties.keys();
            while (enumCTX.hasMoreElements()) {
                String key = enumCTX.nextElement();
                String value = this.properties.get(key);
                if (key.startsWith("context-")) {
                    key = key.substring("context-".length());
                    propertiesJMS.put(key, value);
                    continue;
                }
                if (key.startsWith("pool-")) {
                    key = key.substring("pool-".length());
                    propertiesLocalPool.put(key, value);
                    continue;
                }
                if (!key.startsWith("lookupDestination-")) continue;
                if (!((key = key.substring("lookupDestination-".length())).indexOf("#Azione") == -1 && value.indexOf("#Azione") == -1 || this.bustaSPCoop != null && this.bustaSPCoop.getAzione() != null)) {
                    throw new Exception("Proprieta' 'location' definita dinamicamente (#Azione), ma busta eGov e Azione SPCoop non definita per questo Connettore[" + this.tipoConnettore + "]");
                }
                if (!(key.indexOf("#Servizio") == -1 && value.indexOf("#Servizio") == -1 || this.bustaSPCoop != null && this.bustaSPCoop.getServizio() != null)) {
                    throw new Exception("Proprieta' 'location' definita dinamicamente (#Servizio), ma busta eGov e Servizio SPCoop non definito per questo Connettore[" + this.tipoConnettore + "]");
                }
                if (!(key.indexOf("#TipoServizio") == -1 && value.indexOf("#TipoServizio") == -1 || this.bustaSPCoop != null && this.bustaSPCoop.getTipoServizio() != null)) {
                    throw new Exception("Proprieta' 'location' definita dinamicamente (#TipoServizio), ma busta eGov e TipoServizio SPCoop non definito per questo Connettore[" + this.tipoConnettore + "]");
                }
                if (this.bustaSPCoop.getAzione() != null) {
                    key = key.replace("#Azione", this.bustaSPCoop.getAzione());
                }
                if (this.bustaSPCoop.getServizio() != null) {
                    key = key.replace("#Servizio", this.bustaSPCoop.getServizio());
                }
                if (this.bustaSPCoop.getTipoServizio() != null) {
                    key = key.replace("#TipoServizio", this.bustaSPCoop.getTipoServizio());
                }
                if (this.bustaSPCoop.getAzione() != null) {
                    value = value.replace("#Azione", this.bustaSPCoop.getAzione());
                }
                if (this.bustaSPCoop.getServizio() != null) {
                    value = value.replace("#Servizio", this.bustaSPCoop.getServizio());
                }
                if (this.bustaSPCoop.getTipoServizio() != null) {
                    value = value.replace("#TipoServizio", this.bustaSPCoop.getTipoServizio());
                }
                propertiesJMS.put(key, value);
            }
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] creazione jndi context ed eventuale pool-local-context, Overwrite da file properties..."));
            }
            if ((overwriteProperties = ConnettoreJMSProperties.getInstance()) != null) {
                Hashtable<String, IDServizio> idServizi = overwriteProperties.getIDServizi_Pubblicazione();
                String indiceServizio = null;
                Enumeration<String> e = idServizi.keys();
                while (e.hasMoreElements()) {
                    String keyElement;
                    IDServizio match;
                    if (this.bustaSPCoop == null || (match = idServizi.get(keyElement = e.nextElement())) == null || match.getServizio() == null || match.getTipoServizio() == null || match.getSoggettoErogatore() == null || match.getSoggettoErogatore().getNome() == null || match.getSoggettoErogatore().getTipo() == null || !match.getServizio().equals(this.bustaSPCoop.getServizio()) || !match.getTipoServizio().equals(this.bustaSPCoop.getTipoServizio()) || !match.getSoggettoErogatore().getNome().equals(this.bustaSPCoop.getDestinatario()) || !match.getSoggettoErogatore().getTipo().equals(this.bustaSPCoop.getTipoDestinatario())) continue;
                    indiceServizio = keyElement;
                    break;
                }
                if (indiceServizio != null) {
                    Properties propertiesPoolOver;
                    Properties propertiesContextOver = overwriteProperties.getJNDIContext_Configurazione(indiceServizio);
                    if (propertiesContextOver != null) {
                        Enumeration<Object> el = propertiesContextOver.keys();
                        while (el.hasMoreElements()) {
                            String keyP = (String)el.nextElement();
                            propertiesJMS.setProperty(keyP, propertiesContextOver.getProperty(keyP));
                        }
                    }
                    if ((propertiesPoolOver = overwriteProperties.getJNDIPool_Configurazione(indiceServizio)) != null) {
                        Enumeration<Object> el = propertiesPoolOver.keys();
                        while (el.hasMoreElements()) {
                            String keyP = (String)el.nextElement();
                            propertiesLocalPool.setProperty(keyP, propertiesPoolOver.getProperty(keyP));
                        }
                    }
                }
            }
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] impostazione contesto..."));
            }
            ctxJMS = new InitialContext(propertiesJMS);
            if (propertiesLocalPool.size() > 0) {
                ctxLocalPool = new InitialContext(propertiesLocalPool);
            }
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] lookup connection factory..."));
            }
            if ((connectionFactory = this.properties.get("connection-factory")) != null) {
                connectionFactory = connectionFactory.trim();
            }
            if (ctxLocalPool != null) {
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] lookup connection factory da ctxLocalPool..."));
                }
                qcf = (ConnectionFactory)ctxLocalPool.lookup(connectionFactory);
            } else {
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] lookup connection factory da ctxJMS..."));
                }
                qcf = (ConnectionFactory)ctxJMS.lookup(connectionFactory);
            }
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] lookup coda/topic..."));
            }
            String location = this.properties.get("location");
            boolean findDestinationInCache = false;
            if (LOCATIONS_CACHE_ABILITATA.equals(this.properties.get("locations-cache"))) {
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] lookup coda/topic in cache [" + locations.containsKey(location) + "]..."));
                }
                if (locations.containsKey(location)) {
                    if (QUEUE.equalsIgnoreCase(this.properties.get("tipo"))) {
                        queueDestination = (Queue)locations.get(location);
                    } else {
                        topicDestination = (Topic)locations.get(location);
                    }
                    findDestinationInCache = true;
                    if (this.debug) {
                        this.log.debug((Object)("[" + this.idEGovMessaggio + "] lookup coda/topic in cache effettuata con successo..."));
                    }
                }
            }
            if (!findDestinationInCache) {
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] lookup coda/topic (non e' presente in cache, o cache non abilitata)..."));
                }
                if (QUEUE.equalsIgnoreCase(this.properties.get("tipo"))) {
                    if (this.debug) {
                        this.log.debug((Object)("[" + this.idEGovMessaggio + "] lookup coda..."));
                    }
                    queueDestination = (Queue)ctxJMS.lookup(location);
                    if (this.debug) {
                        this.log.debug((Object)("[" + this.idEGovMessaggio + "] lookup coda effettuata..."));
                    }
                } else {
                    if (this.debug) {
                        this.log.debug((Object)("[" + this.idEGovMessaggio + "] lookup topic..."));
                    }
                    topicDestination = (Topic)ctxJMS.lookup(location);
                    if (this.debug) {
                        this.log.debug((Object)("[" + this.idEGovMessaggio + "] lookup topic effettuato..."));
                    }
                }
            }
            if (!findDestinationInCache && LOCATIONS_CACHE_ABILITATA.equals(this.properties.get("locations-cache"))) {
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] aggiunto coda/topic in cache..."));
                }
                if (QUEUE.equalsIgnoreCase(this.properties.get("tipo"))) {
                    this.putDestination(location, (Destination)queueDestination);
                } else {
                    this.putDestination(location, (Destination)topicDestination);
                }
            }
            if (user != null && password != null) {
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] create connection (user:" + user + " password:" + password + ")..."));
                }
                qc = qcf.createConnection(user, password);
            } else {
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] create connection..."));
                }
                qc = qcf.createConnection();
            }
            if (qc == null) {
                throw new Exception("Connessione JMS non ritornata (is null) dalla ConnectionFactory[" + connectionFactory + "]");
            }
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] create sessione [" + this.acknowledgeModeSessione + "]..."));
            }
            if ((qs = qc.createSession(false, this.acknowledgeModeSessione)) == null) {
                throw new Exception("Sessione JMS non ritornata (is null) dalla Connessione creata con la ConnectionFactory[" + connectionFactory + "]");
            }
            if (QUEUE.equalsIgnoreCase(this.properties.get("tipo"))) {
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] create queue producer..."));
                }
                sender = qs.createProducer((Destination)queueDestination);
            } else {
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] create topic producer..."));
                }
                sender = qs.createProducer((Destination)topicDestination);
            }
            if (sender == null) {
                throw new Exception("Sender JMS non creato (is null) attraverso la Sessione creata con la Connessione presa dalla ConnectionFactory[" + connectionFactory + "]");
            }
            BytesMessage messageJMS = null;
            if (BYTES_MESSAGE.equalsIgnoreCase(this.properties.get("send-as"))) {
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] create BytesMessage..."));
                }
                messageJMS = qs.createBytesMessage();
                messageJMS.writeBytes(consegna);
            } else {
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] create TextMessage..."));
                }
                messageJMS = qs.createTextMessage(new String(consegna));
            }
            if (messageJMS == null) {
                throw new Exception("Messaggio JMS non creato (is null) attraverso la Sessione creata con la Connessione presa dalla ConnectionFactory[" + connectionFactory + "]");
            }
            if (this.propertiesTrasporto != null) {
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] set proprieta' jms..."));
                }
                Enumeration<Object> enumSPC = this.propertiesTrasporto.keys();
                while (enumSPC.hasMoreElements()) {
                    String key = (String)enumSPC.nextElement();
                    String value = (String)this.propertiesTrasporto.get(key);
                    if (this.debug) {
                        this.log.debug((Object)("[" + this.idEGovMessaggio + "] set proprieta' [" + key + "]=[" + value + "]..."));
                    }
                    messageJMS.setStringProperty(key, value);
                }
            }
            if (overwriteProperties != null) {
                String[] classiJMSSetProprieties;
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] set proprieta' dinamiche..."));
                }
                if ((classiJMSSetProprieties = overwriteProperties.getClassNameSetPropertiesJMS()) != null) {
                    for (int i = 0; i < classiJMSSetProprieties.length; ++i) {
                        if (this.debug) {
                            this.log.debug((Object)("[" + this.idEGovMessaggio + "] set proprieta' dinamiche con classe[" + classiJMSSetProprieties[i] + "]..."));
                        }
                        try {
                            Class<?> c = Class.forName(classiJMSSetProprieties[i]);
                            IConnettoreJMSSetProperties setProperties = (IConnettoreJMSSetProperties)c.newInstance();
                            setProperties.setProperties(this.requestMsg, (javax.jms.Message)messageJMS);
                            continue;
                        }
                        catch (Exception e) {
                            this.log.error((Object)("Setting delle proprieta' JMS tramite classe [" + classiJMSSetProprieties[i] + "] non riuscita"), (Throwable)e);
                        }
                    }
                }
            }
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] send message..."));
            }
            sender.send((javax.jms.Message)messageJMS);
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] send message effettuata..."));
            }
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] sender.close ..."));
            }
            sender.close();
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] session.close ..."));
            }
            qs.close();
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] connection.close ..."));
            }
            qc.close();
            this.codice = 200;
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] connettore jms ha pubblicato con successo"));
            }
            bl = true;
        }
        catch (Exception e) {
            this.log.error((Object)"Errore avvenuto durante la consegna JMS", (Throwable)e);
            this.errore = "Errore avvenuto durante la consegna JMS: " + e.getMessage();
            try {
                sender.close();
            }
            catch (Exception ec) {
                // empty catch block
            }
            try {
                if (qs != null) {
                    qs.close();
                }
            }
            catch (Exception ec) {
                // empty catch block
            }
            try {
                if (qc != null) {
                    qc.close();
                }
            }
            catch (Exception ec) {
                // empty catch block
            }
            boolean bl2 = false;
            return bl2;
        }
        finally {
            try {
                if (ctxJMS != null) {
                    ctxJMS.close();
                }
            }
            catch (Exception close) {}
            try {
                if (ctxLocalPool != null) {
                    ctxLocalPool.close();
                }
            }
            catch (Exception close) {}
        }
        return bl;
    }

    public synchronized void putDestination(String key, Destination destination) {
        try {
            locations.put(key, destination);
        }
        catch (Exception e) {
            this.log.error((Object)("ERROR INSERT CODA IN CACHE: " + e.getMessage()), (Throwable)e);
        }
    }

    public String getErrore() {
        return this.errore;
    }

    public int getCodiceTrasporto() {
        return this.codice;
    }

    public Message getResponse() {
        return this.response;
    }
}

