/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.connettori;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.axis.Message;
import org.apache.axis.encoding.Base64;
import org.apache.axis.soap.SOAP11Constants;
import org.apache.axis.soap.SOAPConstants;
import org.apache.log4j.Logger;
import org.openspcoop.egov.Busta;
import org.openspcoop.pdd.config.MailcapActivationReader;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.autenticazione.Credenziali;
import org.openspcoop.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop.pdd.core.connettori.IConnettore;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.utils.SoapUtils;
import org.openspcoop.utils.UtilsException;
import org.xml.sax.SAXParseException;

public class ConnettoreHTTP
implements IConnettore {
    public static final int HTTP_CONNECTION_TIMEOUT = 10000;
    public static final int HTTP_READ_CONNECTION_TIMEOUT = 120000;
    private String errore;
    private Message responseMsg;
    private int codice;
    public ByteArrayOutputStream outByte = new ByteArrayOutputStream();
    private Message requestMsg;
    private Hashtable<String, String> properties;
    private boolean sbustamentoSoap;
    private Properties propertiesTrasporto;
    private Properties propertiesUrlBased;
    private Credenziali credenziali;
    private Busta bustaSPCoop;
    private boolean debug = false;
    private OpenSPCoopProperties openspcoopProperties = null;
    private String idEGovMessaggio;
    private Logger log = null;

    public boolean send(ConnettoreMsg request) {
        this.log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        this.openspcoopProperties = OpenSPCoopProperties.getInstance();
        if (request == null) {
            this.errore = "Messaggio da consegnare is Null (ConnettoreMsg)";
            return false;
        }
        this.requestMsg = request.getRequestMessage();
        this.properties = request.getConnectorProperties();
        this.sbustamentoSoap = request.getSbustamentoSOAP();
        this.propertiesTrasporto = request.getPropertiesTrasporto();
        this.propertiesUrlBased = request.getPropertiesUrlBased();
        this.bustaSPCoop = request.getBusta();
        if (this.bustaSPCoop != null) {
            this.idEGovMessaggio = this.bustaSPCoop.getID();
        }
        this.credenziali = request.getCredenziali();
        if (this.requestMsg == null) {
            this.errore = "Messaggio da consegnare is Null (AxisMsg)";
            return false;
        }
        if (this.properties == null) {
            this.errore = "Proprieta' del connettore non definite";
        }
        if (this.properties.size() == 0) {
            this.errore = "Proprieta' del connettore non definite";
        }
        if (this.properties.get("location") == null) {
            this.errore = "Proprieta' 'location' non fornita e richiesta da questo tipo di connettore [" + request.getTipoConnettore() + "]";
            return false;
        }
        if (this.properties.get("debug") != null && "true".equalsIgnoreCase(this.properties.get("debug").trim())) {
            this.debug = true;
        }
        return this.sendHTTP();
    }

    private boolean sendHTTP() {
        try {
            InputStream is;
            int resultHTTPOperation;
            HttpURLConnection httpConn;
            block81: {
                String mimeTypeAttachment;
                String locationRisposta;
                String tipoRisposta;
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] creazione URL..."));
                }
                StringBuffer urlBuilder = new StringBuffer();
                urlBuilder.append(this.properties.get("location"));
                if (this.propertiesUrlBased != null && this.propertiesUrlBased.size() > 0) {
                    Enumeration<Object> enumSPC = this.propertiesUrlBased.keys();
                    while (enumSPC.hasMoreElements()) {
                        if (!urlBuilder.toString().contains("?")) {
                            urlBuilder.append("?");
                        } else {
                            urlBuilder.append("&");
                        }
                        String key = (String)enumSPC.nextElement();
                        String value = (String)this.propertiesUrlBased.get(key);
                        urlBuilder.append(key);
                        urlBuilder.append("=");
                        urlBuilder.append(value);
                    }
                }
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] creazione URL [" + urlBuilder.toString() + "]..."));
                }
                URL url = new URL(urlBuilder.toString());
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] creazione connessione alla URL [" + urlBuilder.toString() + "]..."));
                }
                URLConnection connection = url.openConnection();
                httpConn = (HttpURLConnection)connection;
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] impostazione content type..."));
                }
                String contentTypeRichiesta = this.requestMsg.getContentType((SOAPConstants)new SOAP11Constants());
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] impostazione http content type [" + contentTypeRichiesta + "]..."));
                }
                httpConn.setRequestProperty("Content-Type", contentTypeRichiesta);
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] impostazione timeout..."));
                }
                int connectionTimeout = -1;
                int readConnectionTimeout = -1;
                if (this.properties.get("connection-timeout") != null) {
                    try {
                        connectionTimeout = Integer.parseInt(this.properties.get("connection-timeout"));
                    }
                    catch (Exception e) {
                        this.log.error((Object)"Parametro connection-timeout errato", (Throwable)e);
                    }
                }
                if (connectionTimeout == -1) {
                    connectionTimeout = 10000;
                }
                if (this.properties.get("read-connection-timeout") != null) {
                    try {
                        readConnectionTimeout = Integer.parseInt(this.properties.get("read-connection-timeout"));
                    }
                    catch (Exception e) {
                        this.log.error((Object)"Parametro read-connection-timeout errato", (Throwable)e);
                    }
                }
                if (readConnectionTimeout == -1) {
                    readConnectionTimeout = 120000;
                }
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] impostazione http timeout CT[" + connectionTimeout + "] RT[" + readConnectionTimeout + "]..."));
                }
                httpConn.setConnectTimeout(connectionTimeout);
                httpConn.setReadTimeout(readConnectionTimeout);
                httpConn.setInstanceFollowRedirects(true);
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] impostazione soap action..."));
                }
                String soapAction = null;
                if (!this.sbustamentoSoap) {
                    soapAction = (String)this.requestMsg.getProperty("SOAPAction");
                    if (soapAction == null) {
                        soapAction = "OpenSPCoop";
                    }
                    httpConn.setRequestProperty("SOAPAction", soapAction);
                    if (this.debug) {
                        this.log.debug((Object)("[" + this.idEGovMessaggio + "] SOAP Action inviata [" + soapAction + "]"));
                    }
                }
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] impostazione autenticazione..."));
                }
                String user = null;
                String password = null;
                if (this.credenziali != null) {
                    user = this.credenziali.getUsername();
                    password = this.credenziali.getPassword();
                } else {
                    user = this.properties.get("user");
                    password = this.properties.get("password");
                }
                if (user != null && password != null) {
                    String authentication = user + ":" + password;
                    authentication = "Basic " + Base64.encode((byte[])authentication.getBytes());
                    httpConn.setRequestProperty("authorization", authentication);
                    if (this.debug) {
                        this.log.debug((Object)("[" + this.idEGovMessaggio + "] impostazione autenticazione (username:" + user + " password:" + password + ") [" + authentication + "]..."));
                    }
                }
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] impostazione header di trasporto..."));
                }
                if (this.propertiesTrasporto != null) {
                    Enumeration<Object> enumSPC = this.propertiesTrasporto.keys();
                    while (enumSPC.hasMoreElements()) {
                        String key = (String)enumSPC.nextElement();
                        String value = (String)this.propertiesTrasporto.get(key);
                        if (this.debug) {
                            this.log.debug((Object)("[" + this.idEGovMessaggio + "] set proprieta' [" + key + "]=[" + value + "]..."));
                        }
                        httpConn.setRequestProperty(key, value);
                    }
                }
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] impostazione POST..."));
                }
                httpConn.setRequestMethod("POST");
                httpConn.setDoOutput(true);
                httpConn.setDoInput(true);
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] spedizione byte..."));
                }
                OutputStream out = httpConn.getOutputStream();
                if (this.debug) {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    if (this.sbustamentoSoap) {
                        this.log.debug((Object)("[" + this.idEGovMessaggio + "] Sbustamento..."));
                        SoapUtils.sbustamentoMessaggio((Message)this.requestMsg, (OutputStream)bout);
                    } else {
                        this.requestMsg.writeTo((OutputStream)bout);
                    }
                    bout.flush();
                    bout.close();
                    out.write(bout.toByteArray());
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] Messaggio inviato (ContentType:" + contentTypeRichiesta + ") :\n" + bout.toString()));
                    bout.close();
                } else if (this.sbustamentoSoap) {
                    if (this.debug) {
                        this.log.debug((Object)("[" + this.idEGovMessaggio + "] Sbustamento..."));
                    }
                    SoapUtils.sbustamentoMessaggio((Message)this.requestMsg, (OutputStream)out);
                } else {
                    this.requestMsg.writeTo(out);
                }
                out.close();
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] Analisi risposta..."));
                }
                if ((tipoRisposta = httpConn.getHeaderField("Content-Type")) == null) {
                    tipoRisposta = httpConn.getHeaderField("Content-Type".toLowerCase());
                }
                if (tipoRisposta == null) {
                    tipoRisposta = httpConn.getHeaderField("Content-Type".toUpperCase());
                }
                if ((locationRisposta = httpConn.getHeaderField("Content-Location")) == null) {
                    locationRisposta = httpConn.getHeaderField("Content-Location".toLowerCase());
                }
                if (locationRisposta == null) {
                    locationRisposta = httpConn.getHeaderField("Content-Location".toUpperCase());
                }
                boolean imbustamentoConAttachment = false;
                if ("true".equals(httpConn.getHeaderField(this.openspcoopProperties.getTunnelSOAPKeyWord()))) {
                    imbustamentoConAttachment = true;
                }
                if ((mimeTypeAttachment = httpConn.getHeaderField(this.openspcoopProperties.getTunnelSOAPKeyWordMimeType())) == null) {
                    mimeTypeAttachment = "application/openspcoop";
                }
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] Analisi risposta input stream e risultato http..."));
                }
                resultHTTPOperation = httpConn.getResponseCode();
                is = null;
                is = resultHTTPOperation < 300 ? httpConn.getInputStream() : httpConn.getErrorStream();
                if (is != null && resultHTTPOperation != 202) {
                    block80: {
                        String tipoLetturaRisposta = null;
                        try {
                            int readByte;
                            byte[] readB;
                            if (this.debug) {
                                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                                readB = new byte[65536];
                                readByte = 0;
                                while ((readByte = is.read(readB)) != -1) {
                                    bout.write(readB, 0, readByte);
                                }
                                is.close();
                                bout.flush();
                                bout.close();
                                this.log.debug((Object)("[" + this.idEGovMessaggio + "] Messaggio ricevuto (ContentType:" + tipoRisposta + ") :\n" + bout.toString()));
                                is = new ByteArrayInputStream(bout.toByteArray());
                            }
                            if (!this.sbustamentoSoap) {
                                if (this.debug) {
                                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] Ricostruzione normale..."));
                                }
                                tipoLetturaRisposta = "Costruzione messaggio SOAP";
                                this.responseMsg = new Message((Object)is, false, tipoRisposta, locationRisposta);
                                break block80;
                            }
                            if (imbustamentoConAttachment) {
                                if (this.debug) {
                                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] Imbustamento con attachments..."));
                                }
                                tipoLetturaRisposta = "Costruzione messaggio SOAP per Tunnel con mimeType " + mimeTypeAttachment;
                                try {
                                    this.responseMsg = SoapUtils.imbustamentoMessaggioConAttachment((InputStream)is, (String)mimeTypeAttachment, (boolean)MailcapActivationReader.existsDataContentHandler(mimeTypeAttachment));
                                    break block80;
                                }
                                catch (UtilsException e) {
                                    if (e.getMessage() == null || !e.getMessage().equals("Contenuto da imbustare non presente")) {
                                        throw e;
                                    }
                                    break block80;
                                }
                            }
                            if (tipoRisposta != null && tipoRisposta.contains("multipart/related")) {
                                if (this.debug) {
                                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] Imbustamento messaggio multipart/related..."));
                                }
                                tipoLetturaRisposta = "Imbustamento messaggio multipart/related in un SOAP WithAttachments";
                                ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
                                readB = new byte[65536];
                                readByte = 0;
                                while ((readByte = is.read(readB)) != -1) {
                                    byteBuffer.write(readB, 0, readByte);
                                }
                                if (byteBuffer.size() > 0) {
                                    this.responseMsg = SoapUtils.imbustamentoMessaggio((byte[])byteBuffer.toByteArray(), (boolean)this.openspcoopProperties.isDeleteInstructionTargetMachineXml());
                                }
                            } else {
                                if (this.debug) {
                                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] Imbustamento messaggio..."));
                                }
                                tipoLetturaRisposta = "Imbustamento messaggio xml in un messaggio SOAP";
                                this.responseMsg = new Message((Object)is, true, tipoRisposta, locationRisposta);
                            }
                        }
                        catch (Exception e) {
                            this.errore = "Errore avvenuto durante la consegna HTTP (" + tipoLetturaRisposta + "): " + e.getMessage();
                            this.log.error((Object)("Errore avvenuto durante la consegna HTTP (" + tipoLetturaRisposta + ")"), (Throwable)e);
                            return false;
                        }
                    }
                    if (this.debug) {
                        this.log.debug((Object)("[" + this.idEGovMessaggio + "] save messaggio..."));
                    }
                    try {
                        if (this.responseMsg != null && this.responseMsg.countAttachments() == 0) {
                            this.responseMsg.getSOAPPartAsBytes();
                        }
                    }
                    catch (Exception e) {
                        this.errore = "Errore avvenuto durante la consegna HTTP (salvataggio risposta): " + e.getMessage();
                        return false;
                    }
                    if (this.debug) {
                        this.log.debug((Object)("[" + this.idEGovMessaggio + "] check consistenza messaggio..."));
                    }
                    try {
                        this.responseMsg.getSOAPEnvelope().getAsString();
                    }
                    catch (Exception e) {
                        boolean premature;
                        this.responseMsg = null;
                        boolean result2XX = resultHTTPOperation >= 200 && resultHTTPOperation <= 299;
                        boolean bl = premature = e.getMessage() != null && e.getMessage().indexOf("Premature end of file") != -1 && result2XX;
                        if (premature || !result2XX) break block81;
                        this.errore = "Errore avvenuto durante la consegna HTTP (lettura risposta): " + e.getMessage();
                        return false;
                    }
                }
            }
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] chiusura socket..."));
            }
            if (is != null) {
                is.close();
            }
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] chiusura connessione..."));
            }
            httpConn.disconnect();
            this.codice = resultHTTPOperation;
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] gestione invio/risposta http effettuata con successo"));
            }
            return true;
        }
        catch (Exception e) {
            this.errore = "Errore avvenuto durante la consegna HTTP: " + e.getMessage();
            return false;
        }
    }

    public String getErrore() {
        return this.errore;
    }

    public int getCodiceTrasporto() {
        return this.codice;
    }

    public Message getResponse() {
        return this.responseMsg;
    }

    public void checkXMLInstructionTargetMachine() throws Exception {
        try {
            this.responseMsg.getSOAPBody();
        }
        catch (Exception e) {
            if (e instanceof SAXParseException && "The processing instruction target matching \"[xX][mM][lL]\" is not allowed.".equals(e.getMessage())) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                this.responseMsg.writeTo((OutputStream)bout);
                bout.close();
                ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
                bout.reset();
                int readByte = 0;
                block2: while ((readByte = bin.read()) != -1) {
                    if ((char)readByte == '<') {
                        byte[] bytePotenzialiXML = new byte[4];
                        readByte = bin.read(bytePotenzialiXML);
                        if (readByte != 4) {
                            bout.write(60);
                            bout.write(bytePotenzialiXML, 0, readByte);
                            continue;
                        }
                        if ((char)bytePotenzialiXML[0] == '?' && (char)bytePotenzialiXML[1] == 'x' && (char)bytePotenzialiXML[2] == 'm' && (char)bytePotenzialiXML[3] == 'l') {
                            ByteArrayOutputStream boutTmp = new ByteArrayOutputStream();
                            while ((char)readByte != '>') {
                                boutTmp.write(readByte);
                                readByte = bin.read();
                                if (readByte != -1) continue;
                                bout.write(boutTmp.toByteArray());
                                continue block2;
                            }
                            continue;
                        }
                        bout.write(60);
                        bout.write(bytePotenzialiXML);
                        continue;
                    }
                    bout.write(readByte);
                }
                bin.close();
                bout.flush();
                bout.close();
                this.responseMsg = SoapUtils.build((byte[])bout.toByteArray(), (boolean)false);
            }
            throw e;
        }
    }
}

