/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.autorizzazione;

import java.io.Serializable;
import org.apache.jcs.JCS;
import org.apache.jcs.access.exception.CacheException;
import org.apache.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.pdd.config.ClassNameProperties;
import org.openspcoop.pdd.core.autorizzazione.AutorizzazioneException;
import org.openspcoop.pdd.core.autorizzazione.EsitoAutorizzazione;
import org.openspcoop.pdd.core.autorizzazione.IAutorizzazioneSPCoop;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.utils.CacheResponse;

public class GestoreAutorizzazioneSPCoop {
    private static IAutorizzazioneSPCoop autorizzazioneSPCoop = null;
    private static String tipoAutorizzazioneSPCoop = null;
    private static final String AUTORIZZAZIONE_SPCOOP_CACHE_NAME = "autorizzazioneSPCoop";
    private static JCS cacheAutorizzazioneSPCoop = null;
    private static Logger logger = null;
    private static Logger logConsole = OpenSPCoopLogger.getLoggerOpenSPCoopConsole();
    private static ClassNameProperties className = ClassNameProperties.getInstance();
    private static boolean isAttivoAutorizzazioneSPCoop = false;

    public static void resetCache() throws AutorizzazioneException {
        if (cacheAutorizzazioneSPCoop != null) {
            try {
                cacheAutorizzazioneSPCoop.clear();
            }
            catch (Exception e) {
                throw new AutorizzazioneException(e.getMessage(), e);
            }
        }
    }

    public static void abilitaCache() throws AutorizzazioneException {
        if (cacheAutorizzazioneSPCoop != null) {
            throw new AutorizzazioneException("Cache gia' abilitata");
        }
        try {
            cacheAutorizzazioneSPCoop = JCS.getInstance((String)"configurazionePdD");
        }
        catch (Exception e) {
            throw new AutorizzazioneException(e.getMessage(), e);
        }
    }

    public static void abilitaCache(long dimensioneCache, boolean algoritmoCacheLRU, long itemIdleTime, long itemLifeSecond) throws AutorizzazioneException {
        if (cacheAutorizzazioneSPCoop != null) {
            throw new AutorizzazioneException("Cache gia' abilitata");
        }
        try {
            String algoritmoCache = null;
            algoritmoCache = algoritmoCacheLRU ? "lru" : "mru";
            GestoreAutorizzazioneSPCoop.initCacheAutorizzazione((int)dimensioneCache, algoritmoCache, itemIdleTime, itemLifeSecond, null);
        }
        catch (Exception e) {
            throw new AutorizzazioneException(e.getMessage(), e);
        }
    }

    public static void disabilitaCache() throws AutorizzazioneException {
        if (cacheAutorizzazioneSPCoop == null) {
            throw new AutorizzazioneException("Cache gia' disabilitata");
        }
        try {
            cacheAutorizzazioneSPCoop.clear();
            cacheAutorizzazioneSPCoop = null;
        }
        catch (Exception e) {
            throw new AutorizzazioneException(e.getMessage(), e);
        }
    }

    public static boolean isCacheAbilitata() {
        return cacheAutorizzazioneSPCoop != null;
    }

    public static void initialize(String tipoAutorizzazioneSPCoop, Logger log) throws Exception {
        GestoreAutorizzazioneSPCoop.initialize(tipoAutorizzazioneSPCoop, false, -1, null, -1L, -1L, log);
    }

    public static void initialize(String tipoAutorizzazioneSPCoop, int dimensioneCache, String algoritmoCache, long idleTime, long itemLifeSecond, Logger log) throws Exception {
        GestoreAutorizzazioneSPCoop.initialize(tipoAutorizzazioneSPCoop, true, dimensioneCache, algoritmoCache, idleTime, itemLifeSecond, log);
    }

    private static void initialize(String tipoAutorizzazioneSPCoop, boolean cacheAbilitata, int dimensioneCache, String algoritmoCache, long idleTime, long itemLifeSecond, Logger log) throws Exception {
        logger = log;
        GestoreAutorizzazioneSPCoop.tipoAutorizzazioneSPCoop = tipoAutorizzazioneSPCoop;
        if (!"none".equalsIgnoreCase(tipoAutorizzazioneSPCoop)) {
            String classType = className.getAutorizzazioneSPCoop(tipoAutorizzazioneSPCoop);
            try {
                Class<?> c = Class.forName(classType);
                autorizzazioneSPCoop = (IAutorizzazioneSPCoop)c.newInstance();
                log.info((Object)("Inizializzazione gestore AutorizzazioneSPCoop di tipo " + classType + " effettuata."));
            }
            catch (Exception e) {
                throw new AutorizzazioneException("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per l'autorizzazione SPCoop: " + e.getMessage(), e);
            }
        } else {
            return;
        }
        if (cacheAbilitata) {
            GestoreAutorizzazioneSPCoop.initCacheAutorizzazione(dimensioneCache, algoritmoCache, idleTime, itemLifeSecond, log);
        }
        isAttivoAutorizzazioneSPCoop = true;
    }

    public static void initCacheAutorizzazione(int dimensioneCache, String algoritmoCache, long idleTime, long itemLifeSecond, Logger log) throws Exception {
        String msg;
        if (log != null) {
            log.info((Object)"Inizializzazione cache Autorizzazione SPCoop");
        }
        cacheAutorizzazioneSPCoop = JCS.getInstance((String)AUTORIZZAZIONE_SPCOOP_CACHE_NAME);
        if (dimensioneCache > 0 || algoritmoCache != null) {
            ICompositeCacheAttributes cacheAttr = cacheAutorizzazioneSPCoop.getCacheAttributes();
            if (dimensioneCache > 0) {
                try {
                    msg = "Dimensione della cache (Autorizzazione SPCoop) impostata al valore: " + dimensioneCache;
                    if (log != null) {
                        log.info((Object)msg);
                    }
                    logConsole.info((Object)msg);
                    cacheAttr.setMaxObjects(dimensioneCache);
                }
                catch (Exception error) {
                    throw new AutorizzazioneException("Parametro errato per la dimensione della cache (Gestore Messaggi): " + error.getMessage(), error);
                }
            }
            if (algoritmoCache != null) {
                msg = "Algoritmo di cache (Autorizzazione SPCoop) impostato al valore: " + algoritmoCache;
                if (log != null) {
                    log.info((Object)msg);
                }
                logConsole.info((Object)msg);
                if ("mru".equalsIgnoreCase(algoritmoCache)) {
                    cacheAttr.setCacheName("org.apache.jcs.engine.memory.mru.MRUMemoryCache");
                } else {
                    cacheAttr.setCacheName("org.apache.jcs.engine.memory.lru.LRUMemoryCache");
                }
            }
            cacheAutorizzazioneSPCoop.setCacheAttributes(cacheAttr);
        }
        if (idleTime > 0L || itemLifeSecond > 0L) {
            IElementAttributes elemAttr = cacheAutorizzazioneSPCoop.getDefaultElementAttributes();
            if (idleTime > 0L) {
                try {
                    msg = "Attributo 'IdleTime' (Autorizzazione SPCoop) impostato al valore: " + idleTime;
                    if (log != null) {
                        log.info((Object)msg);
                    }
                    logConsole.info((Object)msg);
                    elemAttr.setIdleTime(idleTime);
                }
                catch (Exception error) {
                    throw new AutorizzazioneException("Parametro errato per l'attributo 'IdleTime' (Gestore Messaggi): " + error.getMessage(), error);
                }
            }
            if (itemLifeSecond > 0L) {
                try {
                    msg = "Attributo 'MaxLifeSecond' (Autorizzazione SPCoop) impostato al valore: " + itemLifeSecond;
                    if (log != null) {
                        log.info((Object)msg);
                    }
                    logConsole.info((Object)msg);
                    elemAttr.setMaxLifeSeconds(itemLifeSecond);
                }
                catch (Exception error) {
                    throw new AutorizzazioneException("Parametro errato per l'attributo 'MaxLifeSecond' (Gestore Messaggi): " + error.getMessage(), error);
                }
            }
            cacheAutorizzazioneSPCoop.setDefaultElementAttributes(elemAttr);
        }
    }

    public static EsitoAutorizzazione verificaAutorizzazioneSPCoop(String identitaPdDMittente, String identitaServizioApplicativo, String subjectWSSServizioApplicativo, IDSoggetto soggettoFruitore, IDServizio idServizio) throws Exception {
        if (cacheAutorizzazioneSPCoop == null) {
            return autorizzazioneSPCoop.process(identitaPdDMittente, identitaServizioApplicativo, subjectWSSServizioApplicativo, soggettoFruitore, idServizio);
        }
        if (soggettoFruitore == null || soggettoFruitore.getTipo() == null || soggettoFruitore.getNome() == null) {
            throw new AutorizzazioneException("(Parametri) Soggetto fruitore non definito");
        }
        if (idServizio == null) {
            throw new AutorizzazioneException("(Parametri) IDServizio non definito");
        }
        if (idServizio.getTipoServizio() == null || idServizio.getServizio() == null) {
            throw new AutorizzazioneException("(Parametri) Servizio non definito");
        }
        if (idServizio.getSoggettoErogatore() == null || idServizio.getSoggettoErogatore().getTipo() == null || idServizio.getSoggettoErogatore().getNome() == null) {
            throw new AutorizzazioneException("(Parametri) Soggetto erogatore non definito");
        }
        String keyCache = null;
        keyCache = soggettoFruitore.toString() + " -> " + idServizio.toString();
        if (identitaPdDMittente != null) {
            keyCache = keyCache + " mittente(" + identitaPdDMittente + ")";
        }
        if (identitaServizioApplicativo != null) {
            keyCache = keyCache + " identitaSA(" + identitaServizioApplicativo + ")";
        }
        if (subjectWSSServizioApplicativo != null) {
            keyCache = keyCache + " subjectWSS(" + subjectWSSServizioApplicativo + ")";
        }
        if (keyCache == null) {
            throw new AutorizzazioneException("KeyCache non definita");
        }
        JCS jCS = cacheAutorizzazioneSPCoop;
        synchronized (jCS) {
            CacheResponse response = (CacheResponse)cacheAutorizzazioneSPCoop.get((Object)keyCache);
            if (response != null) {
                if (response.getObject() != null) {
                    logger.debug((Object)("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] (methodo:verificaAutorizzazioneSPCoop) in cache."));
                    return (EsitoAutorizzazione)response.getObject();
                }
                if (response.getException() != null) {
                    logger.debug((Object)("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] (methodo:verificaAutorizzazioneSPCoop) in cache."));
                    throw (Exception)response.getException();
                }
                logger.error((Object)"In cache non e' presente ne un oggetto ne un'eccezione.");
            }
            logger.debug((Object)("oggetto con chiave [" + keyCache + "] (methodo:verificaAutorizzazioneSPCoop) ricerco nella configurazione..."));
            EsitoAutorizzazione esito = autorizzazioneSPCoop.process(identitaPdDMittente, identitaServizioApplicativo, subjectWSSServizioApplicativo, soggettoFruitore, idServizio);
            if (esito != null) {
                if (esito.isServizioAutorizzato() || "EGOV_IT_201".equals(esito.getCodiceErrore())) {
                    logger.info((Object)("Aggiungo oggetto [" + keyCache + "] in cache"));
                    try {
                        CacheResponse responseCache = new CacheResponse();
                        responseCache.setObject((Serializable)esito);
                        cacheAutorizzazioneSPCoop.put((Object)keyCache, (Object)responseCache);
                    }
                    catch (CacheException e) {
                        logger.error((Object)("Errore durante l'inserimento in cache [" + keyCache + "]: " + e.getMessage()));
                    }
                }
                return esito;
            }
            throw new AutorizzazioneException("Metodo (GestoreAutorizzazioneSPCoop.autorizzazioneSPCoop.process) ha ritornato un valore di esito null");
        }
    }

    public static boolean isAttivoAutorizzazioneSPCoop() {
        return isAttivoAutorizzazioneSPCoop;
    }

    public static String getTipoAutorizzazioneSPCoop() {
        return tipoAutorizzazioneSPCoop;
    }
}

