/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core;

import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.config.PortaDelegata;
import org.openspcoop.dao.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop.pdd.config.ConfigurazionePdDReader;
import org.openspcoop.pdd.config.RichiestaDelegata;
import org.openspcoop.pdd.core.ParametriPortaDelegata;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;

public class IdentificazionePortaDelegata {
    private String location;
    private String urlInvocazionePD;
    private String nomePDIndivituata;
    private boolean nomePortaDelegataURLBased = true;
    private PortaDelegata pd = null;
    private String msgError;
    private String codiceError;
    private IDSoggetto soggetto;
    private String tipoAutenticazione;
    private String tipoAutorizzazione;
    private Logger log;

    public IdentificazionePortaDelegata(ParametriPortaDelegata parPD) {
        this.location = parPD.getLocation();
        this.urlInvocazionePD = parPD.getUrlInvocazionePD();
        this.log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        if (this.urlInvocazionePD.endsWith("/")) {
            this.urlInvocazionePD = this.urlInvocazionePD.substring(0, this.urlInvocazionePD.length() - 1);
        }
        this.nomePortaDelegataURLBased = parPD.isNomePortaDelegataURLBased();
    }

    public boolean process() {
        try {
            if (this.location == null || "".equals(this.location)) {
                this.msgError = "La porta delegata invocata non esiste \nNella url di invocazione alla Porta di Dominio non e' stata fornita il nome di una PD";
                this.codiceError = "OPENSPCOOP_ORG_401";
                return false;
            }
            ConfigurazionePdDReader configurazionePdDReader = ConfigurazionePdDReader.getInstance();
            if (this.nomePortaDelegataURLBased) {
                String portaDelegata = this.urlInvocazionePD;
                while (portaDelegata.contains("/")) {
                    try {
                        this.soggetto = configurazionePdDReader.getSoggettoSPCoop(portaDelegata);
                    }
                    catch (DriverConfigurazioneNotFound dNotFound) {
                        // empty catch block
                    }
                    if (this.soggetto != null) {
                        this.nomePDIndivituata = portaDelegata;
                        break;
                    }
                    int indexCut = -1;
                    for (int i = portaDelegata.length() - 1; i >= 0; --i) {
                        if (portaDelegata.charAt(i) != '/') continue;
                        indexCut = i;
                        break;
                    }
                    portaDelegata = portaDelegata.substring(0, indexCut);
                }
                try {
                    this.soggetto = configurazionePdDReader.getSoggettoSPCoop(portaDelegata);
                }
                catch (DriverConfigurazioneNotFound dNotFound) {
                    // empty catch block
                }
                if (this.soggetto != null) {
                    this.nomePDIndivituata = portaDelegata;
                }
            }
            if (this.nomePDIndivituata == null) {
                try {
                    this.soggetto = configurazionePdDReader.getSoggettoSPCoop(this.location);
                }
                catch (DriverConfigurazioneNotFound dNotFound) {
                    this.msgError = "La porta delegata invocata non esiste  location[" + this.location + "] urlInvocazione[" + this.urlInvocazionePD + "]";
                    this.log.error((Object)(this.msgError + ": " + dNotFound.getMessage()));
                    this.codiceError = "OPENSPCOOP_ORG_401";
                    return false;
                }
                if (this.soggetto != null) {
                    this.nomePDIndivituata = this.location;
                }
            }
            if (this.soggetto == null) {
                this.msgError = "La porta delegata invocata non esiste  location[" + this.location + "] urlInvocazione[" + this.urlInvocazionePD + "]";
                this.codiceError = "OPENSPCOOP_ORG_401";
                return false;
            }
            RichiestaDelegata richiestaDelegata = new RichiestaDelegata(this.soggetto, this.nomePDIndivituata);
            try {
                this.pd = configurazionePdDReader.getPortaDelegata(richiestaDelegata.getIdPortaDelegata());
            }
            catch (DriverConfigurazioneNotFound notFound) {
                this.msgError = "La porta delegata invocata non esiste " + notFound.getMessage();
                this.codiceError = "OPENSPCOOP_ORG_401";
                return false;
            }
            try {
                this.tipoAutenticazione = configurazionePdDReader.getAutenticazione(this.pd);
            }
            catch (DriverConfigurazioneNotFound notFound) {
                this.msgError = "La porta delegata invocata non esiste  [lettura tipo autenticazione] " + notFound.getMessage();
                this.codiceError = "OPENSPCOOP_ORG_401";
                return false;
            }
            try {
                this.tipoAutorizzazione = configurazionePdDReader.getAutorizzazione(this.pd);
            }
            catch (DriverConfigurazioneNotFound notFound) {
                this.msgError = "La porta delegata invocata non esiste  [lettura tipo autenticazione] " + notFound.getMessage();
                this.codiceError = "OPENSPCOOP_ORG_401";
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)("Identificazione porta delegata non riuscita location[" + this.location + "] urlInvocazione[" + this.urlInvocazionePD + "]"), (Throwable)e);
            this.msgError = "Sistema non disponibile";
            this.codiceError = "OPENSPCOOP_ORG_502";
            return false;
        }
    }

    public IDSoggetto getSoggettoSPCoop() {
        return this.soggetto;
    }

    public String getMsgError() {
        return this.msgError;
    }

    public String getCodiceErrore() {
        return this.codiceError;
    }

    public String getTipoAutenticazione() {
        return this.tipoAutenticazione;
    }

    public String getTipoAutorizzazione() {
        return this.tipoAutorizzazione;
    }

    public String getNomePDIndivituata() {
        return this.nomePDIndivituata;
    }

    public PortaDelegata getPd() {
        return this.pd;
    }
}

