/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Vector;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.config.CorrelazioneApplicativa;
import org.openspcoop.dao.config.CorrelazioneApplicativaElemento;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.dao.state.IState;
import org.openspcoop.dao.state.StateMessage;
import org.openspcoop.egov.Configurazione;
import org.openspcoop.pdd.core.GestoreMessaggiException;
import org.openspcoop.pdd.core.ParametriPortaDelegata;
import org.openspcoop.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop.utils.DynamicNamespaceContext;
import org.openspcoop.utils.date.DateManager;
import org.openspcoop.utils.regexp.RegularExpressionEngine;
import org.openspcoop.utils.sql.ISQLQueryObject;
import org.openspcoop.utils.sql.SQLObjectFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GestoreCorrelazioneApplicativa {
    private Logger log = null;
    public static final String CORRELAZIONE_APPLICATIVA = "CORRELAZIONE_APPLICATIVA";
    private IState state;
    private String idEGovCorrelato;
    private String idCorrelazione;
    private String codiceErrore;
    private String msgErrore;
    private IDSoggetto soggettoFruitore;
    private IDServizio idServizio;
    private String servizioApplicativo;

    public GestoreCorrelazioneApplicativa(IState state, Logger alog, IDSoggetto soggettoFruitore, IDServizio idServizio, String servizioApplicativo) {
        this.state = state;
        this.log = alog != null ? alog : Logger.getLogger((String)"GestoreCorrelazioneApplicativa");
        this.soggettoFruitore = soggettoFruitore;
        this.idServizio = idServizio;
        this.servizioApplicativo = servizioApplicativo;
    }

    public GestoreCorrelazioneApplicativa(IState state, Logger alog) {
        this(state, alog, null, null, null);
    }

    public boolean verificaCorrelazione(CorrelazioneApplicativa correlazioneApplicativa, ParametriPortaDelegata parPD, SOAPEnvelope envelope, HeaderIntegrazione headerIntegrazione, boolean readFirstHeaderIntegrazione) throws GestoreMessaggiException {
        if (correlazioneApplicativa == null) {
            this.codiceErrore = "OPENSPCOOP_ORG_416";
            this.msgErrore = "Richiesta funzionalita' di correlazione applicativa tra id applicativi e id e-Gov: la configurazione fornita non permette di effettuare la correlazione";
            throw new GestoreMessaggiException("Dati per l'identificazione dell'id di correlazione non presenti.");
        }
        NodeList nList = null;
        try {
            if (envelope.getBody() == null || !envelope.getBody().hasChildNodes()) {
                throw new Exception("Body applicativo non presente nel messaggio Soap");
            }
            nList = envelope.getBody().getChildNodes();
            if (nList == null || nList.getLength() == 0) {
                throw new Exception("Elementi del Body non presenti?");
            }
        }
        catch (Exception e) {
            this.codiceErrore = "OPENSPCOOP_ORG_416";
            this.msgErrore = "Richiesta funzionalita' di correlazione applicativa tra id applicativi e id e-Gov: la configurazione fornita non permette di effettuare la correlazione";
            throw new GestoreMessaggiException("Errore durante l'analisi dell'elementName: " + e.getMessage());
        }
        Vector<CorrelazioneApplicativaElemento> c = new Vector<CorrelazioneApplicativaElemento>();
        int posizioneElementoQualsiasi = -1;
        for (int i = 0; i < correlazioneApplicativa.sizeElementoList(); ++i) {
            CorrelazioneApplicativaElemento elemento = correlazioneApplicativa.getElemento(i);
            if (elemento.getNome() == null || "".equals(elemento.getNome())) {
                if (posizioneElementoQualsiasi != -1) {
                    this.codiceErrore = "OPENSPCOOP_ORG_416";
                    this.msgErrore = "Richiesta funzionalita' di correlazione applicativa tra id applicativi e id e-Gov: la configurazione fornita non permette di effettuare la correlazione";
                    throw new GestoreMessaggiException("Errore durante l'analisi dell'elementName: piu' di un elemento '*' non puo' essere definito");
                }
                posizioneElementoQualsiasi = i;
                continue;
            }
            c.add(elemento);
        }
        if (posizioneElementoQualsiasi >= 0) {
            c.add(correlazioneApplicativa.getElemento(posizioneElementoQualsiasi));
        }
        boolean findCorrelazione = false;
        boolean correlazioneNonRiuscitaDaAccettare = false;
        String idCorrelazioneApplicativa = null;
        block13: for (int elem = 0; elem < nList.getLength() && !findCorrelazione; ++elem) {
            String elementName = null;
            Node nodeInEsame = nList.item(elem);
            try {
                elementName = nodeInEsame.getLocalName();
            }
            catch (Exception e) {
                this.codiceErrore = "OPENSPCOOP_ORG_416";
                this.msgErrore = "Richiesta funzionalita' di correlazione applicativa tra id applicativi e id e-Gov: la configurazione fornita non permette di effettuare la correlazione";
                throw new GestoreMessaggiException("Errore durante l'analisi dell'elementName: " + e.getMessage());
            }
            for (int i = 0; i < c.size(); ++i) {
                DynamicNamespaceContext dnc;
                CorrelazioneApplicativaElemento elemento = (CorrelazioneApplicativaElemento)c.get(i);
                boolean bloccaIdentificazioneNonRiuscita = true;
                if ("accetta".equals(elemento.getIdentificazioneFallita())) {
                    bloccaIdentificazioneNonRiuscita = false;
                }
                boolean matchNodePerCorrelazioneApplicativa = false;
                String nomeElemento = null;
                if (elemento.getNome() == null || "".equals(elemento.getNome())) {
                    matchNodePerCorrelazioneApplicativa = true;
                    nomeElemento = "*";
                    if (!(elem + 1 == nList.getLength())) {
                        continue;
                    }
                } else if (elementName.equals(elemento.getNome())) {
                    matchNodePerCorrelazioneApplicativa = true;
                    nomeElemento = elemento.getNome();
                } else {
                    try {
                        dnc = DynamicNamespaceContext.getNamespaceContext((Node)envelope);
                        nomeElemento = RegularExpressionEngine.getStringMatchPatternContentBased((MessageElement)envelope, (DynamicNamespaceContext)dnc, (String)elemento.getNome());
                        if (nomeElemento != null) {
                            matchNodePerCorrelazioneApplicativa = true;
                        }
                    }
                    catch (Exception e) {
                        this.log.info((Object)("Calcolo non riuscito [" + elementName + "] [" + elemento.getNome() + "]: " + e.getMessage()));
                    }
                }
                if (!matchNodePerCorrelazioneApplicativa) continue;
                if ("disabilitato".equals(elemento.getIdentificazione())) {
                    correlazioneNonRiuscitaDaAccettare = true;
                    findCorrelazione = true;
                    continue block13;
                }
                if (readFirstHeaderIntegrazione && headerIntegrazione.getIdApplicativo() != null) {
                    idCorrelazioneApplicativa = headerIntegrazione.getIdApplicativo();
                    findCorrelazione = true;
                    continue block13;
                }
                if ("urlBased".equals(elemento.getIdentificazione())) {
                    try {
                        String urlInvocazionePD = parPD.getUrlInvocazionePD_formBased();
                        idCorrelazioneApplicativa = RegularExpressionEngine.getStringMatchPatternURLBased((String)urlInvocazionePD, (String)elemento.getPattern());
                    }
                    catch (Exception e) {
                        if (bloccaIdentificazioneNonRiuscita) {
                            this.codiceErrore = "OPENSPCOOP_ORG_416";
                            this.msgErrore = "Richiesta funzionalita' di correlazione applicativa tra id applicativi e id e-Gov: la configurazione fornita non permette di effettuare la correlazione";
                            throw new GestoreMessaggiException("Identificativo di correlazione applicativa non identificato nell'elemento [" + nomeElemento + "] con modalita' di acquisizione urlBased (Pattern:" + elemento.getPattern() + "): " + e.getMessage());
                        }
                        correlazioneNonRiuscitaDaAccettare = true;
                    }
                } else if ("inputBased".equals(elemento.getIdentificazione())) {
                    idCorrelazioneApplicativa = headerIntegrazione.getIdApplicativo();
                    if (idCorrelazioneApplicativa == null) {
                        if (bloccaIdentificazioneNonRiuscita) {
                            this.codiceErrore = "OPENSPCOOP_ORG_416";
                            this.msgErrore = "Richiesta funzionalita' di correlazione applicativa tra id applicativi e id e-Gov: la configurazione fornita non permette di effettuare la correlazione";
                            throw new GestoreMessaggiException("Identificativo di correlazione applicativa per l'elemento [" + nomeElemento + "] " + "con modalita' di acquisizione inputBased non presente tra le informazioni di integrazione");
                        }
                        correlazioneNonRiuscitaDaAccettare = true;
                    }
                } else {
                    try {
                        dnc = DynamicNamespaceContext.getNamespaceContext((Node)envelope);
                        idCorrelazioneApplicativa = RegularExpressionEngine.getStringMatchPatternContentBased((MessageElement)envelope, (DynamicNamespaceContext)dnc, (String)elemento.getPattern());
                    }
                    catch (Exception e) {
                        if (bloccaIdentificazioneNonRiuscita) {
                            this.codiceErrore = "OPENSPCOOP_ORG_416";
                            this.msgErrore = "Richiesta funzionalita' di correlazione applicativa tra id applicativi e id e-Gov: la configurazione fornita non permette di effettuare la correlazione";
                            throw new GestoreMessaggiException("Identificativo di correlazione applicativa non identificato nell'elemento [" + nomeElemento + "] con modalita' di acquisizione contentBased (Pattern:" + elemento.getPattern() + "): " + e.getMessage());
                        }
                        correlazioneNonRiuscitaDaAccettare = true;
                    }
                }
                findCorrelazione = true;
                continue block13;
            }
        }
        if (idCorrelazioneApplicativa == null) {
            if (!correlazioneNonRiuscitaDaAccettare) {
                this.codiceErrore = "OPENSPCOOP_ORG_416";
                this.msgErrore = "Richiesta funzionalita' di correlazione applicativa tra id applicativi e id e-Gov: la configurazione fornita non permette di effettuare la correlazione";
                throw new GestoreMessaggiException("Identificativo di correlazione applicativa non identificato; nessun elemento tra quelli di correlazione definiti, sono presenti nel body");
            }
            return false;
        }
        this.idCorrelazione = idCorrelazioneApplicativa;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            StateMessage stateMSG = (StateMessage)this.state;
            Connection connectionDB = stateMSG.getConnectionDB();
            String valoreAzione = "(AZIONE is null)";
            if (this.idServizio.getAzione() != null && !"".equals(this.idServizio.getAzione())) {
                valoreAzione = "AZIONE=?";
            }
            StringBuffer query = new StringBuffer();
            query.append("SELECT * FROM CORRELAZIONE_APPLICATIVA WHERE ID_APPLICATIVO=? AND SERVIZIO_APPLICATIVO=? AND TIPO_MITTENTE=? AND MITTENTE=? AND TIPO_DESTINATARIO=? AND DESTINATARIO=? AND TIPO_SERVIZIO=? AND SERVIZIO=? AND " + valoreAzione);
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setString(1, idCorrelazioneApplicativa);
            pstmt.setString(2, this.servizioApplicativo);
            pstmt.setString(3, this.soggettoFruitore.getTipo());
            pstmt.setString(4, this.soggettoFruitore.getNome());
            pstmt.setString(5, this.idServizio.getSoggettoErogatore().getTipo());
            pstmt.setString(6, this.idServizio.getSoggettoErogatore().getNome());
            pstmt.setString(7, this.idServizio.getTipoServizio());
            pstmt.setString(8, this.idServizio.getServizio());
            if (this.idServizio.getAzione() != null && !"".equals(this.idServizio.getAzione())) {
                pstmt.setString(9, this.idServizio.getAzione());
            }
            if ((rs = pstmt.executeQuery()) == null) {
                pstmt.close();
                this.log.error((Object)"Verifica correlazione IDApplicativo - ID eGov non riuscita: ResultSet is null?");
                throw new GestoreMessaggiException("Verifica correlazione IDApplicativo - ID eGov non riuscita: ResultSet is null?");
            }
            boolean correlazionePresente = rs.next();
            if (correlazionePresente) {
                this.idEGovCorrelato = rs.getString("ID_EGOV");
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception er) {
            this.codiceErrore = "OPENSPCOOP_ORG_529";
            this.msgErrore = "Sistema non disponibile";
            this.log.error((Object)("Verifica correlazione IDApplicativo - ID eGov non riuscita: " + er.getMessage()));
            throw new GestoreMessaggiException("Verifica correlazione IDApplicativo - ID eGov non riuscita: " + er.getMessage());
        }
        return this.idEGovCorrelato != null;
    }

    public void applicaCorrelazione(CorrelazioneApplicativa correlazioneApplicativa, String idApplicativo, String idEGovRequest) throws GestoreMessaggiException {
        if (correlazioneApplicativa == null) {
            this.codiceErrore = "OPENSPCOOP_ORG_416";
            this.msgErrore = "Richiesta funzionalita' di correlazione applicativa tra id applicativi e id e-Gov: la configurazione fornita non permette di effettuare la correlazione";
            throw new GestoreMessaggiException("Dati per l'identificazione dell'id di correlazione non presenti.");
        }
        if (idEGovRequest == null) {
            this.codiceErrore = "OPENSPCOOP_ORG_416";
            this.msgErrore = "Richiesta funzionalita' di correlazione applicativa tra id applicativi e id e-Gov: la configurazione fornita non permette di effettuare la correlazione";
            throw new GestoreMessaggiException("Identificativo eGov non presente tra i parametri di invocazione.");
        }
        if (idApplicativo == null) {
            this.codiceErrore = "OPENSPCOOP_ORG_416";
            this.msgErrore = "Richiesta funzionalita' di correlazione applicativa tra id applicativi e id e-Gov: la configurazione fornita non permette di effettuare la correlazione";
            throw new GestoreMessaggiException("Identificativo Applicativo non presente tra i parametri di invocazione.");
        }
        Timestamp scadenzaCorrelazioneT = null;
        if (correlazioneApplicativa.getScadenza() != null) {
            try {
                long scadenza = Long.parseLong(correlazioneApplicativa.getScadenza());
                scadenzaCorrelazioneT = new Timestamp(DateManager.getTimeMillis() + scadenza * 60L * 1000L);
            }
            catch (Exception e) {
                this.codiceErrore = "OPENSPCOOP_ORG_529";
                this.msgErrore = "Sistema non disponibile";
                throw new GestoreMessaggiException("Scadenza impostata per la correlazione applicativa non corretta: " + e.getMessage());
            }
        }
        PreparedStatement pstmtInsert = null;
        try {
            StateMessage stateMSG = (StateMessage)this.state;
            Connection connectionDB = stateMSG.getConnectionDB();
            StringBuffer queryInsert = new StringBuffer();
            queryInsert.append("INSERT INTO CORRELAZIONE_APPLICATIVA");
            queryInsert.append(" (ID_EGOV,ID_APPLICATIVO,SERVIZIO_APPLICATIVO,TIPO_MITTENTE,MITTENTE,TIPO_DESTINATARIO,DESTINATARIO,TIPO_SERVIZIO,SERVIZIO,AZIONE ");
            if (scadenzaCorrelazioneT != null) {
                queryInsert.append(",SCADENZA");
            }
            queryInsert.append(") VALUES (?,?,?,?,?,?,?,?,?,?");
            if (scadenzaCorrelazioneT != null) {
                queryInsert.append(",?");
            }
            queryInsert.append(")");
            pstmtInsert = connectionDB.prepareStatement(queryInsert.toString());
            pstmtInsert.setString(1, idEGovRequest);
            pstmtInsert.setString(2, idApplicativo);
            pstmtInsert.setString(3, this.servizioApplicativo);
            pstmtInsert.setString(4, this.soggettoFruitore.getTipo());
            pstmtInsert.setString(5, this.soggettoFruitore.getNome());
            pstmtInsert.setString(6, this.idServizio.getSoggettoErogatore().getTipo());
            pstmtInsert.setString(7, this.idServizio.getSoggettoErogatore().getNome());
            pstmtInsert.setString(8, this.idServizio.getTipoServizio());
            pstmtInsert.setString(9, this.idServizio.getServizio());
            pstmtInsert.setString(10, this.idServizio.getAzione());
            if (scadenzaCorrelazioneT != null) {
                pstmtInsert.setTimestamp(11, scadenzaCorrelazioneT);
            }
            String valoreAzione = "N.D.";
            if (this.idServizio.getAzione() != null && !"".equals(this.idServizio.getAzione())) {
                valoreAzione = this.idServizio.getAzione();
            }
            stateMSG.getPreparedStatement().put("INSERT CorrelazioneApplicativa_" + idEGovRequest + "_" + idApplicativo + "_" + this.soggettoFruitore.getTipo() + this.soggettoFruitore.getNome() + "_" + this.idServizio.getSoggettoErogatore().getTipo() + this.idServizio.getSoggettoErogatore().getNome() + "_" + this.idServizio.getTipoServizio() + this.idServizio.getServizio() + "_" + valoreAzione, pstmtInsert);
        }
        catch (Exception er) {
            this.codiceErrore = "OPENSPCOOP_ORG_529";
            this.msgErrore = "Sistema non disponibile";
            this.log.error((Object)("Correlazione IDApplicativo - ID eGov non riuscita: " + er.getMessage()));
            throw new GestoreMessaggiException("Correlazione IDApplicativo - ID eGov non riuscita: " + er.getMessage());
        }
    }

    public Vector<Long> getCorrelazioniScadute(int limit, int offset, boolean logQuery) throws GestoreMessaggiException {
        Vector<Long> idMsg = new Vector<Long>();
        Statement pstmtMsgScaduti = null;
        ResultSet rs = null;
        String queryString = null;
        try {
            StateMessage stateMSG = (StateMessage)this.state;
            Connection connectionDB = stateMSG.getConnectionDB();
            Timestamp nowT = DateManager.getTimestamp();
            if (Configurazione.getSqlQueryObjectType() == null) {
                StringBuffer query = new StringBuffer();
                query.append("SELECT id FROM ");
                query.append(CORRELAZIONE_APPLICATIVA);
                query.append(" WHERE SCADENZA is not null AND SCADENZA < ?");
                queryString = query.toString();
            } else {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("SCADENZA");
                sqlQueryObject.addFromTable(CORRELAZIONE_APPLICATIVA);
                sqlQueryObject.addWhereCondition("SCADENZA is not null");
                sqlQueryObject.addWhereCondition("SCADENZA < ?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("SCADENZA");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            pstmtMsgScaduti = connectionDB.prepareStatement(queryString);
            pstmtMsgScaduti.setTimestamp(1, nowT);
            long startDateSQLCommand = DateManager.getTimeMillis();
            if (logQuery) {
                this.log.debug((Object)("[QUERY] (CorrelazioneApplicativa.scaduta) [" + queryString + "] 1[" + nowT + "]..."));
            }
            rs = pstmtMsgScaduti.executeQuery();
            long endDateSQLCommand = DateManager.getTimeMillis();
            long secondSQLCommand = (endDateSQLCommand - startDateSQLCommand) / 1000L;
            if (logQuery) {
                this.log.debug((Object)("[QUERY] (CorrelazioneApplicativa.scaduta) [" + queryString + "] 1[" + nowT + "] effettuata in " + secondSQLCommand + " secondi"));
            }
            int countLimit = 0;
            int countOffset = 0;
            while (rs.next()) {
                if (Configurazione.getSqlQueryObjectType() == null) {
                    if (countOffset >= offset) {
                        idMsg.add(rs.getLong("id"));
                        if (++countLimit != limit) continue;
                        break;
                    }
                    ++countOffset;
                    continue;
                }
                idMsg.add(rs.getLong("id"));
            }
            rs.close();
            pstmtMsgScaduti.close();
            return idMsg;
        }
        catch (Exception e) {
            String errorMsg = "[GestoreCorrelazioneApplicativa.getCorrelazioniScadute] errore, queryString[" + queryString + "]: " + e.getMessage();
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtMsgScaduti != null) {
                    pstmtMsgScaduti.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            this.log.error((Object)errorMsg);
            throw new GestoreMessaggiException(errorMsg);
        }
    }

    public String[] getIDMappingCorrelazioneApplicativa(long idCorrelazioneApplicativa) throws GestoreMessaggiException {
        PreparedStatement pstmtReadMSG = null;
        ResultSet rs = null;
        try {
            StateMessage stateMSG = (StateMessage)this.state;
            Connection connectionDB = stateMSG.getConnectionDB();
            String query = "SELECT ID_EGOV,ID_APPLICATIVO  FROM CORRELAZIONE_APPLICATIVA WHERE id=?";
            pstmtReadMSG = connectionDB.prepareStatement(query);
            pstmtReadMSG.setLong(1, idCorrelazioneApplicativa);
            rs = pstmtReadMSG.executeQuery();
            if (rs.next()) {
                String[] s = new String[]{rs.getString("ID_EGOV"), rs.getString("ID_APPLICATIVO")};
                rs.close();
                pstmtReadMSG.close();
                return s;
            }
            rs.close();
            pstmtReadMSG.close();
            throw new Exception("CorrelazioneApplicativa con id[" + idCorrelazioneApplicativa + "] non trovata");
        }
        catch (Exception e) {
            String errorMsg = "GestoreCorrelazioneApplicativa, error getIDMappingCorrelazioneApplicativa [" + idCorrelazioneApplicativa + "] : " + e.getMessage();
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtReadMSG != null) {
                    pstmtReadMSG.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            this.log.error((Object)errorMsg);
            throw new GestoreMessaggiException(errorMsg);
        }
    }

    public void deleteCorrelazioneApplicativa(long idCorrelazioneApplicativa) throws GestoreMessaggiException {
        PreparedStatement pstmtDeleteMSG = null;
        try {
            StateMessage stateMSG = (StateMessage)this.state;
            Connection connectionDB = stateMSG.getConnectionDB();
            String query = "DELETE FROM CORRELAZIONE_APPLICATIVA WHERE id=?";
            pstmtDeleteMSG = connectionDB.prepareStatement(query);
            pstmtDeleteMSG.setLong(1, idCorrelazioneApplicativa);
            pstmtDeleteMSG.execute();
            pstmtDeleteMSG.close();
        }
        catch (Exception e) {
            String errorMsg = "GestoreCorrelazioneApplicativa, error deleteCorrelazione [" + idCorrelazioneApplicativa + "] : " + e.getMessage();
            try {
                if (pstmtDeleteMSG != null) {
                    pstmtDeleteMSG.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            this.log.error((Object)errorMsg);
            throw new GestoreMessaggiException(errorMsg);
        }
    }

    public String getIdEGovCorrelato() {
        return this.idEGovCorrelato;
    }

    public String getCodiceErrore() {
        return this.codiceErrore;
    }

    public String getMsgErrore() {
        return this.msgErrore;
    }

    public String getIdCorrelazione() {
        return this.idCorrelazione;
    }
}

