/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.config;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openspcoop.pdd.config.OpenSPCoopConfigurationException;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.services.OpenSPCoopStartup;

public class PddProperties {
    private Logger log = OpenSPCoopStartup.initialize ? OpenSPCoopLogger.getLoggerOpenSPCoopCore() : Logger.getLogger((String)"PddProperties");
    private Properties reader = new Properties();
    private static PddProperties pddProperties = null;

    public PddProperties(String location) throws Exception {
        InputStream properties = null;
        try {
            properties = location != null ? new FileInputStream(location) : PddProperties.class.getResourceAsStream("/pdd.properties");
            this.reader.load(properties);
            properties.close();
        }
        catch (IOException e) {
            this.log.error((Object)("Riscontrato errore durante la lettura del file 'pdd.properties': \n\n" + e.getMessage()));
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new Exception("PddProperties initialize error: " + e.getMessage());
        }
    }

    public static boolean initialize(String location) {
        try {
            pddProperties = new PddProperties(location);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static PddProperties getInstance() throws OpenSPCoopConfigurationException {
        if (pddProperties == null) {
            throw new OpenSPCoopConfigurationException("PddProperties non inizializzato");
        }
        return pddProperties;
    }

    public String getValidazioneEGov_Stato(String nomePdd) {
        return this.reader.getProperty(nomePdd + ".validazioneEGov.stato");
    }

    public String getValidazioneEGov_Controllo(String nomePdd) {
        return this.reader.getProperty(nomePdd + ".validazioneEGov.controllo");
    }

    public String getValidazioneEGov_ProfiloCollaborazione(String nomePdd) {
        return this.reader.getProperty(nomePdd + ".validazioneEGov.profiloCollaborazione");
    }

    public String getValidazioneEGov_ManifestAttachments(String nomePdd) {
        return this.reader.getProperty(nomePdd + ".validazioneEGov.manifestAttachments");
    }

    public String getValidazioneEGov_FiltroDuplicatiLetturaRegistro(String nomePdd) {
        return this.reader.getProperty(nomePdd + ".validazioneEGov.filtroDuplicati.letturaRegistro");
    }

    public String getValidazioneEGov_ConfermaRicezioneLetturaRegistro(String nomePdd) {
        return this.reader.getProperty(nomePdd + ".validazioneEGov.confermaRicezione.letturaRegistro");
    }

    public String getValidazioneEGov_ConsegnaInOrdineLetturaRegistro(String nomePdd) {
        return this.reader.getProperty(nomePdd + ".validazioneEGov.consegnaInOrdine.letturaRegistro");
    }

    public String getValidazioneEGov_readQualifiedAttribute(String nomePdd) {
        return this.reader.getProperty(nomePdd + ".validazioneEGov.readQualifiedAttribute");
    }

    public String getBustaEGov_TempoTipo(String nomePdd) {
        return this.reader.getProperty(nomePdd + ".bustaEGov.tempo.tipo");
    }

    public String getBustaEGov_AsincroniAttributiCorrelatiEnable(String nomePdd) {
        return this.reader.getProperty(nomePdd + ".bustaEGov.asincroni.attributiCorrelati.enable");
    }

    public String getBustaEGov_CollaborazioneEnable(String nomePdd) {
        return this.reader.getProperty(nomePdd + ".bustaEGov.collaborazione.enable");
    }

    public String getBustaEGov_ConsegnaInOrdineEnable(String nomePdd) {
        return this.reader.getProperty(nomePdd + ".bustaEGov.consegnaInOrdine.enable");
    }

    public String getBustaEGov_TrasmissioneEnable(String nomePdd) {
        return this.reader.getProperty(nomePdd + ".bustaEGov.trasmissione.enable");
    }

    public String getBustaEGov_RiscontriEnable(String nomePdd) {
        return this.reader.getProperty(nomePdd + ".bustaEGov.riscontri.enable");
    }

    public String getBustaEGov_FiltroduplicatiGenerazioneSPCoopErrore(String nomePdd) {
        return this.reader.getProperty(nomePdd + ".bustaEGov.filtroduplicati.generazioneSPCoopErrore");
    }

    public String getBustaEGov_ManifestAttachments_roleRichiesta(String nomePdd) {
        return this.reader.getProperty(nomePdd + ".bustaEGov.manifestAttachments.role.richiesta");
    }

    public String getBustaEGov_ManifestAttachments_roleRisposta(String nomePdd) {
        return this.reader.getProperty(nomePdd + ".bustaEGov.manifestAttachments.role.risposta");
    }

    public String getBustaEGov_ManifestAttachments_roleAllegato(String nomePdd) {
        return this.reader.getProperty(nomePdd + ".bustaEGov.manifestAttachments.role.allegato");
    }

    public String getValidazioneContenutiApplicativi_Stato(String nomePdd) {
        return this.reader.getProperty(nomePdd + ".validazioneContenutiApplicativi.stato");
    }

    public String getValidazioneContenutiApplicativi_Tipo(String nomePdd) {
        return this.reader.getProperty(nomePdd + ".validazioneContenutiApplicativi.tipo");
    }

    public String getWSSecurity_ActorDefaultEnable(String nomePdd) {
        return this.reader.getProperty(nomePdd + ".wssecurity.actorDefault.enable");
    }

    public String getWSSecurity_ActorDefaultValue(String nomePdd) {
        return this.reader.getProperty(nomePdd + ".wssecurity.actorDefault.valore");
    }
}

