/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.DBUtils;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.config.AccessoConfigurazionePdD;
import org.openspcoop.egov.IGestoreRepositoryEGov;
import org.openspcoop.egov.ProprietaErroreApplicativo;
import org.openspcoop.egov.ProprietaManifestAttachments;
import org.openspcoop.pdd.config.ClassNameProperties;
import org.openspcoop.pdd.config.OpenSPCoopConfigurationException;
import org.openspcoop.pdd.config.PddProperties;
import org.openspcoop.pdd.core.autorizzazione.IAutorizzazioneSPCoop;
import org.openspcoop.pdd.core.integrazione.IGestoreIntegrazionePA;
import org.openspcoop.pdd.core.integrazione.IGestoreIntegrazionePD;
import org.openspcoop.pdd.core.node.INodeReceiver;
import org.openspcoop.pdd.core.node.INodeSender;
import org.openspcoop.pdd.core.threshold.IThreshold;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.monitor.INotificaTempiAttraversamentoPdD;
import org.openspcoop.pdd.services.OpenSPCoopStartup;
import org.openspcoop.utils.PropertiesReader;
import org.openspcoop.utils.date.IDate;
import org.openspcoop.utils.jdbc.IJDBCAdapter;
import org.openspcoop.utils.sql.ISQLQueryObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenSPCoopProperties {
    private Logger log = OpenSPCoopStartup.initialize ? OpenSPCoopLogger.getLoggerOpenSPCoopCore() : Logger.getLogger((String)"OpenSPCoopProperties");
    private static OpenSPCoopProperties openspcoopProperties = null;
    private PropertiesReader reader;
    private PddProperties pddReader;
    private static Boolean isPdDLight = null;
    private static String rootDirectory = null;
    private static String pathConfigurazionePDD = null;
    private static String tipoConfigurazionePDD = null;
    private static Boolean isCondivisioneConfigurazioneRegistroDB = null;
    private static Properties jndiContext_Configurazione = null;
    private static Boolean isAbilitataCacheConfig_value = null;
    private static Integer dimensioneCacheConfig_value = null;
    private static String algoritmoCacheConfig_value = null;
    private static Integer itemIdleTimeCacheConfig_value = null;
    private static Integer itemLifeSecondCacheConfig_value = null;
    private static AccessoConfigurazionePdD accessoConfigurazionePdD = null;
    private static Boolean isConfigurazioneDinamica_value = null;
    private static String jndiNameDatasource = null;
    private static Properties jndiContextDatasource = null;
    private static String jndiNameConnectionFactory = null;
    private static Properties jndiContextConnectionFactory = null;
    private static int acknowledgeModeSessioneConnectionFactory = -1;
    private static Properties jndiContext_CodeInterne = null;
    private static Properties jndiContext_TimerEJB = null;
    private static Boolean isTimerGestoreMessaggiAbilitato = null;
    private static Boolean isTimerGestorePuliziaMessaggiAnomaliAbilitato = null;
    private static Boolean isTimerGestoreRepositoryEGovAbilitato = null;
    private static Boolean isTimerGestoreRiscontriRicevuteAbilitato = null;
    private static Boolean isTimerGestoreMessaggiAbilitatoLog = null;
    private static Boolean isTimerGestorePuliziaMessaggiAnomaliAbilitatoLog = null;
    private static Boolean isTimerGestoreRepositoryEGovAbilitatoLog = null;
    private static Boolean isTimerGestoreRiscontriRicevuteAbilitatoLog = null;
    private static String repositoryType = null;
    private static String databaseType = null;
    private static Boolean isRepositoryOnFS_value = null;
    private static String repositoryDirectory = null;
    private static String repositoryJDBCAdapter = null;
    private static Boolean forceIndex = null;
    private static Long repositoryIntervalloEliminazioneMessaggi = null;
    private static Long repositoryIntervalloScadenzaMessaggi = null;
    private static Long msgGiaInProcessamento_AttesaAttiva = null;
    private static Integer msgGiaInProcessamento_CheckInterval = null;
    private static String[] repositoryThresholdTypes = null;
    private static boolean repositoryThresholdTypesRead = false;
    private static String repositoryThresholdValue = null;
    private static boolean repositoryThresholdValueRead = false;
    private static Long repositoryThresholdCheckInterval = null;
    private static Boolean isAbilitatoControlloRisorseDB = null;
    private static Boolean isAbilitatoControlloRisorseJMS = null;
    private static Boolean isAbilitatoControlloRisorseTracciamentiPersonalizzati = null;
    private static Boolean isAbilitatoControlloRisorseMsgDiagnosticiPersonalizzati = null;
    private static Boolean isAbilitatoControlloRisorseConfigurazione = null;
    private static Boolean isAbilitatoControlloRisorseRegistriServizi = null;
    private static Boolean isControlloRisorseRegistriRaggiungibilitaTotale = null;
    private static Long controlloRisorseCheckInterval = null;
    private static ProprietaErroreApplicativo proprietaGestioneErrorePD = null;
    private static Boolean isErroreApplicativoIntoDetails = null;
    private static String identificativoPortaDefault = null;
    private static String nomePortaDefault = null;
    private static String tipoPortaDefault = null;
    private static IDSoggetto identitaPortaDefault = null;
    private static String tipoAutorizzazioneSPCoop = null;
    private static Boolean isAbilitataCacheAutorizzazioneSPCoop_value = null;
    private static Integer dimensioneCacheAutorizzazioneSPCoop_value = null;
    private static String algoritmoCacheAutorizzazioneSPCoop_value = null;
    private static Integer itemIdleTimeCacheAutorizzazioneSPCoop_value = null;
    private static Integer itemLifeSecondCacheAutorizzazioneSPCoop_value = null;
    private static Properties getBypassFilterMustUnderstandProperties = null;
    private static Boolean isBypassFilterMustUnderstandEnabledForAllHeaders = null;
    private static Long nodeReceiverTimeout = null;
    private static Long nodeReceiverTimeoutRicezioneContenutiApplicativi = null;
    private static Long nodeReceiverTimeoutRicezioneBusteEgov = null;
    private static Integer nodeReceiverCheckInterval = null;
    private static Integer nodeReceiverCheckDBInterval = null;
    private static String nodeReceiver = null;
    private static Boolean singleConnection_nodeReceiver_value = null;
    private static String nodeSender = null;
    private static Long timerEJBDeployTimeout = null;
    private static Integer timerEJBDeployCheckInterval = null;
    private static Long transactionManager_AttesaAttiva = null;
    private static Integer transactionManager_CheckInterval = null;
    private static Integer transactionManager_CheckDBInterval = null;
    private static Boolean singleConnection_TransactionManager_value = null;
    private static Long gestioneSerializableDB_AttesaAttiva = null;
    private static Integer gestioneSerializableDB_CheckInterval = null;
    private static String tipoSeriale_IdentificativoEGov = null;
    private static Integer prefissoSeriale_IdentificativoEGov = null;
    private static String gestoreRepositoryEGov = null;
    private static Boolean isGenerazioneAttributiAsincroni = null;
    private static Boolean isHttp202OneWay = null;
    private static Boolean isHttp202OneWay_PD_HTTPEmptyResponse = null;
    private static Vector<String> tipiSoggetti = null;
    private static boolean tipiSoggettiRead = false;
    private static Vector<String> tipiServizi = null;
    private static boolean tipiServiziRead = false;
    private static Boolean isSPCoopErrore_EccezioniNonGravi = null;
    private static Boolean ignoraEccezioniNonGravi_ValidazioneSPCoop = null;
    private static Boolean isGenerazioneListaTrasmissioni = null;
    private static Boolean isGenerazioneSPCoopErroreFiltroDuplicati = null;
    private static Boolean isCheckFromRegistroFiltroDuplicatiAbilitato = null;
    private static Boolean isCheckFromRegistroConfermaRicezioneAbilitato = null;
    private static Boolean isCheckFromRegistroConsegnaInOrdineAbilitato = null;
    private static Boolean isGestioneElementoCollaborazione = null;
    private static Boolean isGestioneConsegnaInOrdine = null;
    private static Boolean isGestioneRiscontri = null;
    private static Boolean isGenerazioneSPCoopErrore_strutturaMalformataHeaderEGov = null;
    private static String roleRichiestaManifest = null;
    private static String roleRispostaManifest = null;
    private static String roleAllegatoManifest = null;
    private static Boolean isReadQualifiedAttribute = null;
    private static String filePddProperties = null;
    private static boolean filePddPropertiesLetto = false;
    private static String[] tipoIntegrazionePD = null;
    private static boolean tipoIntegrazionePDRead = false;
    private static String[] tipoIntegrazionePA = null;
    private static boolean tipoIntegrazionePARead = false;
    private static Properties keyValue_HeaderIntegrazione = null;
    private static Boolean deleteHeaderIntegrazionePD = null;
    private static Boolean processHeaderIntegrazionePA = null;
    private static String headerSoapNameIntegrazione = null;
    private static String headerSoapActorIntegrazione = null;
    private static String headerSoapPrefixIntegrazione = null;
    private static Boolean isRitardoConsegnaAbilitato = null;
    private static Long ritardoConsegnaEsponenziale = null;
    private static Boolean isRitardoConsegnaEsponenzialeConMoltiplicazione = null;
    private static Long ritardoConsegnaEsponenzialeLimite = null;
    private static Boolean isAbilitataCacheGestoreMessaggi_value = null;
    private static Integer dimensioneCacheGestoreMessaggi_value = null;
    private static String algoritmoCacheGestoreMessaggi_value = null;
    private static Integer itemIdleTimeCacheGestoreMessaggi_value = null;
    private static Integer itemLifeSecondCacheGestoreMessaggi_value = null;
    private static Boolean isRisorseJMXAbilitate = null;
    private static String jndiNameMBeanServer = null;
    private static Properties jndiContextMBeanServer = null;
    private static String contextRisorseJMX_value = null;
    private static Integer connectionTimeout_inoltroBusteEGov = null;
    private static Integer connectionTimeout_consegnaContenutiApplicativi = null;
    private static Integer readConnectionTimeout_inoltroBusteEGov = null;
    private static Integer readConnectionTimeout_consegnaContenutiApplicativi = null;
    private static String tipoTempoEGov = null;
    private static String tipoDateManager = null;
    private static Properties dateManagerProperties = null;
    private static Boolean integrationManager_isNomePortaDelegataUrlBasedValue = null;
    private static Boolean integrationManager_readInformazioniTrasportoValue = null;
    private static Boolean isDeleteInstructionTargetMachineXml = null;
    private static String tunnelSOAPKeyWord = null;
    private static String tunnelSOAPKeyWordMimeType = null;
    private static Long timeoutBustaRispostaAsincrona = null;
    private static Integer checkIntervalBustaRispostaAsincrona = null;
    private static String cluster_id = null;
    private static String statelessOneWay = null;
    private static String statelessSincrono = null;
    private static String statelessAsincrono = null;
    private static Boolean isGestioneOnewayStateful_1_1 = null;
    private static String statelessRouting = null;
    private static String statelessNegoziamentoConnessioneDatasource = "abilitato";
    private static Boolean isGestioneStateful_RinegoziamentoConnessione = null;
    private static Integer connectionNumberPoolStateless = null;
    private static String validationConnectionPoolStateless = null;
    private static boolean read_validationConnectionPoolStateless = false;
    private static String[] tipiMisurazioneTempiAttraversamentoPdD = null;
    private static boolean tipiMisurazioneTempiAttraversamentoPdDRead = false;
    private static Boolean isGenerazioneActorDefault = null;
    private static String actorDefault = null;
    private static Boolean isReadObjectStatoBozza = null;
    private static Boolean isIcarHttp200ResponseCodeEnabled = null;

    public OpenSPCoopProperties() throws Exception {
        Properties propertiesReader = new Properties();
        InputStream properties = null;
        try {
            properties = OpenSPCoopProperties.class.getResourceAsStream("/openspcoop.properties");
            propertiesReader.load(properties);
            properties.close();
        }
        catch (IOException e) {
            this.log.error((Object)("Riscontrato errore durante la lettura del file 'openspcoop.properties': \n\n" + e.getMessage()));
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new Exception("OpenSPCoopProperties initialize error: " + e.getMessage(), e);
        }
        this.reader = new PropertiesReader(propertiesReader);
    }

    public static boolean initialize() {
        try {
            openspcoopProperties = new OpenSPCoopProperties();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static OpenSPCoopProperties getInstance() {
        if (openspcoopProperties == null) {
            OpenSPCoopProperties.initialize();
        }
        return openspcoopProperties;
    }

    public static void updatePddPropertiesReader(PddProperties pddProperties) {
        OpenSPCoopProperties.openspcoopProperties.pddReader = pddProperties;
    }

    public boolean validaConfigurazione() {
        try {
            Class<?> c;
            String algoritmo;
            String tipoClass;
            Object gestore;
            int i;
            Class<?> c2;
            Class<?> c3;
            String tipoClass2;
            long intervalloCheck;
            String tipoRepository;
            ClassNameProperties className = ClassNameProperties.getInstance();
            if (!"db".equalsIgnoreCase(this.getTipoConfigurazionePDD())) {
                if (this.getRootDirectory() == null) {
                    return false;
                }
                if (!new File(this.getRootDirectory()).exists()) {
                    this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.confDirectory'. \n La directory indicata non esiste [" + this.getRootDirectory() + "]."));
                    return false;
                }
            }
            if ("fs".equals(tipoRepository = this.getRepositoryType())) {
                if (this.getRepositoryDirectory() == null) {
                    return false;
                }
                if (!new File(this.getRepositoryDirectory()).exists()) {
                    this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.repository.directory'. \n La directory indicata non esiste [" + this.getRepositoryDirectory() + "]."));
                    return false;
                }
            } else if ("db".equals(tipoRepository)) {
                if (this.getRepositoryJDBCAdapter() == null) {
                    return false;
                }
                String adapterClass = className.getJDBCAdapter(this.getRepositoryJDBCAdapter());
                if (adapterClass == null) {
                    this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.repository.jdbcAdapter'. \n L'adapter indicato non esiste [" + this.getRepositoryJDBCAdapter() + "] nelle classi registrate in OpenSPCoop"));
                    return false;
                }
                try {
                    Class<?> c4 = Class.forName(adapterClass);
                    IJDBCAdapter adapter = (IJDBCAdapter)c4.newInstance();
                    adapter.toString();
                }
                catch (Exception e) {
                    this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.repository.jdbcAdapter'. \n L'adapter indicato non esiste [" + this.getRepositoryJDBCAdapter() + "]: " + e.getMessage()));
                    return false;
                }
            } else {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.repository.tipo'. \n Il tipo indicato non e' un tipo valido [" + this.getRepositoryType() + "]."));
                return false;
            }
            this.isRepositoryOnFS();
            this.isCondivisioneConfigurazioneRegistroDB();
            long intervalloEliminazione = this.getRepositoryIntervalloEliminazioneMessaggi();
            if (intervalloEliminazione <= 0L) {
                if (intervalloEliminazione != -1L) {
                    this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.repository.timer'. \n Valore non valido [" + intervalloEliminazione + "]."));
                }
                return false;
            }
            long intervalloScadenza = this.getRepositoryIntervalloScadenzaMessaggi();
            if (intervalloScadenza <= 0L) {
                if (intervalloScadenza != -1L) {
                    this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.repository.scadenzaMessaggio'. \n Valore non valido [" + intervalloScadenza + "]."));
                }
                return false;
            }
            this.getMsgGiaInProcessamento_AttesaAttiva();
            this.getMsgGiaInProcessamento_CheckInterval();
            String[] tipiThreshold = this.getRepositoryThresholdTypes();
            if (tipiThreshold != null) {
                intervalloCheck = this.getRepositoryThresholdCheckInterval();
                if (intervalloCheck <= 0L) {
                    this.log.error((Object)"Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.repository.threshold.checkInterval', valore non impostato/valido.");
                    return false;
                }
                for (int i2 = 0; i2 < tipiThreshold.length; ++i2) {
                    if (this.getRepositoryThresholdValue(tipiThreshold[i2]) == null) {
                        return false;
                    }
                    tipoClass2 = className.getThreshold(tipiThreshold[i2]);
                    if (tipoClass2 == null) {
                        this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.repository.threshold.tipo'. \n La classe di Threshold indicata non esiste [" + tipiThreshold[i2] + "] nelle classi registrate in OpenSPCoop"));
                        return false;
                    }
                    try {
                        c3 = Class.forName(tipoClass2);
                        IThreshold t = (IThreshold)c3.newInstance();
                        t.toString();
                        continue;
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.repository.threshold.tipo'. \n La classe di Threshold indicata non esiste [" + tipiThreshold[i2] + "]: " + e.getMessage()));
                        return false;
                    }
                }
            }
            if (this.isAbilitatoControlloRisorseConfigurazione() || this.isAbilitatoControlloRisorseDB() || this.isAbilitatoControlloRisorseJMS() || this.isAbilitatoControlloRisorseMsgDiagnosticiPersonalizzati() || this.isAbilitatoControlloRisorseRegistriServizi() || this.isAbilitatoControlloRisorseTracciamentiPersonalizzati()) {
                intervalloCheck = this.getControlloRisorseCheckInterval();
                if (intervalloCheck <= 0L) {
                    this.log.error((Object)"Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.risorse.checkInterval', valore non impostato/valido.");
                    return false;
                }
                this.isControlloRisorseRegistriRaggiungibilitaTotale();
            }
            if (this.getTipoConfigurazionePDD() == null) {
                this.log.error((Object)"Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.config.tipo'. Proprieta' non impostata");
                return false;
            }
            if (!"xml".equalsIgnoreCase(this.getTipoConfigurazionePDD()) && !"db".equalsIgnoreCase(this.getTipoConfigurazionePDD())) {
                this.log.error((Object)"Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.config.tipo'. Tipo non Supportato");
                return false;
            }
            if ("db".equalsIgnoreCase(this.getTipoConfigurazionePDD())) {
                if (this.getPathConfigurazionePDD().indexOf("@") != -1) {
                    try {
                        String tipoDatabase = DBUtils.estraiTipoDatabaseFromLocation((String)this.getPathConfigurazionePDD());
                        tipoDatabase.toString();
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.config.location', mentre veniva analizzato il prefisso tipoDatabase@datasource: " + e.getMessage()));
                        return false;
                    }
                } else if (this.getDatabaseType() == null) {
                    this.log.error((Object)("La configurazione della porta di dominio di tipo [" + this.getTipoConfigurazionePDD() + "] richiede la definizione del tipo di database indicato o come prefisso della location (tipoDB@datasource) o attraverso la proprieta' 'org.openspcoop.pdd.repository.tipoDatabase'"));
                }
            }
            if (this.getPathConfigurazionePDD() == null) {
                this.log.error((Object)"Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.config.location'. Proprieta' non impostata");
                return false;
            }
            if ("xml".equalsIgnoreCase(this.getTipoConfigurazionePDD())) {
                String path = this.getPathConfigurazionePDD();
                if (!path.startsWith("http://") && !path.startsWith("file://")) {
                    if (!new File(path).exists()) {
                        this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.config.location'. \n Il file indicato non esiste [" + path + "]."));
                        return false;
                    }
                } else {
                    try {
                        URL v = new URL(path);
                        v.toString();
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.config.location'. \n La url indicata non e' corretta [" + path + "]."));
                        return false;
                    }
                }
            } else if (!"db".equalsIgnoreCase(this.getTipoConfigurazionePDD())) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.config.tipo'. \n Tipo non supportato [" + this.getTipoConfigurazionePDD() + "]."));
                return false;
            }
            try {
                if (this.isAbilitataCacheConfig()) {
                    String algoritmo2 = this.getAlgoritmoCacheConfig();
                    if (algoritmo2 != null && !"lru".equals(algoritmo2) && !"mru".equals(algoritmo2)) {
                        this.log.error((Object)("Algoritmo utilizzato con la cache non conosciuto: " + algoritmo2));
                        throw new Exception("Algoritmo Cache non conosciuto");
                    }
                    this.getDimensioneCacheConfig();
                    this.getItemIdleTimeCacheConfig();
                    this.getItemLifeSecondCacheConfig();
                }
            }
            catch (Exception e) {
                return false;
            }
            this.isConfigurazioneDinamica();
            if (this.getJNDIName_DataSource() == null) {
                this.log.error((Object)"Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.dataSource'. Proprieta' non impostata");
                return false;
            }
            if (this.getJNDIContext_DataSource() == null) {
                this.log.error((Object)"Riscontrato errore durante la lettura della proprieta' del contesto JNDI per il datasource: 'org.openspcoop.pdd.dataSource.property.*'. Proprieta' definite in maniera errata?");
                return false;
            }
            if (this.getNodeReceiver() == null) {
                return false;
            }
            String tipoClass3 = className.getNodeReceiver(this.getNodeReceiver());
            if (tipoClass3 == null) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.nodeReceiver'. \n Il node receiver indicato non esiste [" + this.getNodeReceiver() + "] nelle classi registrate in OpenSPCoop"));
                return false;
            }
            try {
                c2 = Class.forName(tipoClass3);
                INodeReceiver nodeReceiver = (INodeReceiver)c2.newInstance();
                nodeReceiver.toString();
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.nodeReceiver'. \n Il node receiver indicato non esiste [" + this.getNodeReceiver() + "]: " + e.getMessage()));
                return false;
            }
            this.getNodeReceiverTimeout();
            this.getNodeReceiverTimeoutRicezioneContenutiApplicativi();
            this.getNodeReceiverTimeoutRicezioneBusteEgov();
            this.getNodeReceiverCheckInterval();
            this.getNodeReceiverCheckDBInterval();
            this.singleConnection_NodeReceiver();
            if (this.getNodeSender() == null) {
                return false;
            }
            tipoClass3 = className.getNodeSender(this.getNodeSender());
            if (tipoClass3 == null) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.nodeSender'. \n Il node sender indicato non esiste [" + this.getNodeSender() + "] nelle classi registrate in OpenSPCoop"));
                return false;
            }
            try {
                c2 = Class.forName(tipoClass3);
                INodeSender nodeSender = (INodeSender)c2.newInstance();
                nodeSender.toString();
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.nodeSender'. \n Il node sender indicato non esiste [" + this.getNodeSender() + "]: " + e.getMessage()));
                return false;
            }
            if ("db".equals(this.getNodeSender())) {
                if (this.getRepositoryJDBCAdapter() == null) {
                    this.log.error((Object)"Un JDBCAdapter deve essere definito in caso di NodeSender=db");
                    return false;
                }
                String adapterClass = className.getJDBCAdapter(this.getRepositoryJDBCAdapter());
                if (adapterClass == null) {
                    this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.repository.jdbcAdapter'. \n L'adapter indicato non esiste [" + this.getRepositoryJDBCAdapter() + "] nelle classi registrate in OpenSPCoop"));
                    return false;
                }
                try {
                    Class<?> c5 = Class.forName(adapterClass);
                    IJDBCAdapter adapter = (IJDBCAdapter)c5.newInstance();
                    adapter.toString();
                }
                catch (Exception e) {
                    this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.repository.jdbcAdapter'. \n L'adapter indicato non esiste [" + this.getRepositoryJDBCAdapter() + "]: " + e.getMessage()));
                    return false;
                }
            }
            if ("jms".equals(this.getNodeReceiver()) || "jms".equals(this.getNodeSender())) {
                if (this.getJNDIName_ConnectionFactory() == null) {
                    this.log.error((Object)"Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.queueConnectionFactory'. Proprieta' non impostata");
                    return false;
                }
                if (this.getJNDIContext_ConnectionFactory() == null) {
                    this.log.error((Object)"Riscontrato errore durante la lettura della proprieta' del contesto JNDI del ConnectionFactory: 'org.openspcoop.pdd.connectionFactory.property.*'. Proprieta' definite in maniera errata?");
                    return false;
                }
                if (this.getJNDIQueueName("jms".equals(this.getNodeReceiver()), "jms".equals(this.getNodeSender())) == null) {
                    return false;
                }
                if (this.getJNDIContext_CodeInterne() == null) {
                    this.log.error((Object)"Riscontrato errore durante la lettura della proprieta' del contesto JNDI delle code interne: 'org.openspcoop.pdd.queue.property.*'. Proprieta' definite in maniera errata?");
                    return false;
                }
                this.getAcknowledgeModeSessioneConnectionFactory();
                this.getTransactionManager_AttesaAttiva();
                this.getTransactionManager_CheckDBInterval();
                this.getTransactionManager_CheckInterval();
                this.singleConnection_TransactionManager();
            }
            if (this.getJNDITimerEJBName() == null) {
                return false;
            }
            if (this.getJNDIContext_TimerEJB() == null) {
                this.log.error((Object)"Riscontrato errore durante la lettura della proprieta' del contesto JNDI delle code interne: 'org.openspcoop.pdd.queue.property.*'. Proprieta' definite in maniera errata?");
                return false;
            }
            this.getTimerEJBDeployTimeout();
            this.getTimerEJBDeployCheckInterval();
            this.isTimerGestoreMessaggiAbilitato();
            this.isTimerGestoreRepositoryEGovAbilitato();
            this.isTimerGestoreRiscontriRicevuteAbilitato();
            this.getGestioneSerializableDB_AttesaAttiva();
            this.getGestioneSerializableDB_CheckInterval();
            ProprietaErroreApplicativo paError = this.getProprietaGestioneErrorePD();
            if (paError == null) {
                this.log.error((Object)"Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.erroreApplicativo'.");
                return false;
            }
            if (this.getIdentitaPortaDefault() == null) {
                this.log.error((Object)"Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.identificativoPorta'.");
                return false;
            }
            if (this.getTipoIntegrazionePD() == null) {
                this.log.error((Object)"Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.integrazione.tipo.pd'. Almeno un tipo di integrazione e' obbligatorio.");
                return false;
            }
            String[] tipiIntegrazionePD = this.getTipoIntegrazionePD();
            for (i = 0; i < tipiIntegrazionePD.length; ++i) {
                tipoClass2 = className.getIntegrazionePortaDelegata(tipiIntegrazionePD[i]);
                if (tipoClass2 == null) {
                    this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.integrazione.tipo.pd." + tipiIntegrazionePD[i] + "'. \n L'header di integrazione indicato non esiste nelle classi registrate in OpenSPCoop"));
                    return false;
                }
                try {
                    c3 = Class.forName(tipoClass2);
                    gestore = (IGestoreIntegrazionePD)c3.newInstance();
                    gestore.toString();
                    continue;
                }
                catch (Exception e) {
                    this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.integrazione.tipo.pd." + tipiIntegrazionePD[i] + "'. \n L'header di integrazione indicato non esiste: " + e.getMessage()));
                    return false;
                }
            }
            if (!this.checkTipiIntegrazione(tipiIntegrazionePD)) {
                return false;
            }
            if (this.getTipoIntegrazionePA() == null) {
                String[] tipiIntegrazionePA = this.getTipoIntegrazionePA();
                for (i = 0; i < tipiIntegrazionePA.length; ++i) {
                    tipoClass2 = className.getIntegrazionePortaApplicativa(tipiIntegrazionePA[i]);
                    if (tipoClass2 == null) {
                        this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.integrazione.tipo.pa." + tipiIntegrazionePA[i] + "'. \n L'header di integrazione indicato non esiste nelle classi registrate in OpenSPCoop"));
                        return false;
                    }
                    try {
                        c3 = Class.forName(tipoClass2);
                        gestore = (IGestoreIntegrazionePA)c3.newInstance();
                        gestore.toString();
                        continue;
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.integrazione.tipo.pa." + tipiIntegrazionePA[i] + "'. \n L'header di integrazione indicato non esiste: " + e.getMessage()));
                        return false;
                    }
                }
                if (!this.checkTipiIntegrazione(tipiIntegrazionePA)) {
                    return false;
                }
            }
            this.deleteHeaderIntegrazionePD();
            this.processHeaderIntegrazionePA();
            if (this.getTipoAutorizzazioneSPCoop() == null) {
                return false;
            }
            if (!"none".equals(this.getTipoAutorizzazioneSPCoop())) {
                tipoClass = className.getAutorizzazioneSPCoop(this.getTipoAutorizzazioneSPCoop());
                if (tipoClass == null) {
                    this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.autorizzazioneSPCoop'. \n L'autorizzazione SPCoop indicata non esiste [" + this.getTipoAutorizzazioneSPCoop() + "] nelle classi registrate in OpenSPCoop"));
                    return false;
                }
                try {
                    Class<?> c6 = Class.forName(tipoClass);
                    IAutorizzazioneSPCoop auth = (IAutorizzazioneSPCoop)c6.newInstance();
                    auth.toString();
                }
                catch (Exception e) {
                    this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.autorizzazioneSPCoop'. \n L'autorizzazione SPCoop indicata non esiste [" + this.getTipoAutorizzazioneSPCoop() + "]: " + e.getMessage()));
                    return false;
                }
            }
            try {
                if (this.isAbilitataCacheAutorizzazioneSPCoop()) {
                    algoritmo = this.getAlgoritmoCacheAutorizzazioneSPCoop();
                    if (algoritmo != null && !"lru".equals(algoritmo) && !"mru".equals(algoritmo)) {
                        this.log.error((Object)("Algoritmo utilizzato con la cache (Autorizzazione SPCoop) non conosciuto: " + algoritmo));
                        throw new Exception("Algoritmo Cache (Autorizzazione SPCoop) non conosciuto");
                    }
                    this.getDimensioneCacheAutorizzazioneSPCoop();
                    this.getItemIdleTimeCacheAutorizzazioneSPCoop();
                    this.getItemLifeSecondCacheAutorizzazioneSPCoop();
                }
            }
            catch (Exception e) {
                return false;
            }
            if (this.getGestoreRepositoryEGov() == null) {
                return false;
            }
            tipoClass = className.getRepositoryEGov(this.getGestoreRepositoryEGov());
            if (tipoClass == null) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.repositoryEGov'. \n Il gestore del repository egov indicato non esiste [" + this.getGestoreRepositoryEGov() + "] nelle classi registrate in OpenSPCoop"));
                return false;
            }
            try {
                c = Class.forName(tipoClass);
                IGestoreRepositoryEGov repository = (IGestoreRepositoryEGov)c.newInstance();
                repository.toString();
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.repositoryEGov'. \n Il gestore del repository egov indicato non esiste [" + this.getGestoreRepositoryEGov() + "]: " + e.getMessage()));
                return false;
            }
            if (this.getDatabaseType() != null) {
                if (!("mysql".equals(this.getDatabaseType()) || "postgresql".equals(this.getDatabaseType()) || "oracle".equals(this.getDatabaseType()))) {
                    this.log.error((Object)"Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.repository.tipoDatabase', tipo di database non gestito");
                    return false;
                }
                tipoClass = className.getSQLQueryObject(this.getDatabaseType());
                if (tipoClass == null) {
                    this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.repository.tipoDatabase'. \n L'oggetto SQLQuery indicato non esiste [" + this.getDatabaseType() + "] nelle classi registrate in OpenSPCoop"));
                    return false;
                }
                try {
                    c = Class.forName(tipoClass);
                    ISQLQueryObject sqlQuery = (ISQLQueryObject)c.newInstance();
                    sqlQuery.toString();
                }
                catch (Exception e) {
                    this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.repository.tipoDatabase'. \n L'oggetto SQLQuery indicato non esiste [" + this.getDatabaseType() + "]: " + e.getMessage()));
                    return false;
                }
            }
            if (this.getTipoSeriale_IdentificativoEGov() == null) {
                return false;
            }
            String tipo = this.getTipoSeriale_IdentificativoEGov();
            if (!("default".equals(tipo) || "mysql".equals(tipo) || "static".equals(tipo))) {
                this.log.error((Object)"Riscontrato errore durante la lettura della proprieta' di openspcoop  : 'org.openspcoop.egov.id.tipo': tipo non gestito");
                return false;
            }
            if ("static".equals(tipo)) {
                if (this.getPrefissoSeriale_IdentificativoEGov() == -2) {
                    return false;
                }
                if (this.getPrefissoSeriale_IdentificativoEGov() > 99) {
                    this.log.error((Object)"Riscontrato errore durante la lettura della proprieta' di openspcoop  : 'org.openspcoop.egov.id.prefix': massima lunghezza del prefisso e' di due cifre");
                    return false;
                }
            }
            this.getConnectionTimeout_consegnaContenutiApplicativi();
            this.getConnectionTimeout_inoltroBusteEGov();
            this.getReadConnectionTimeout_consegnaContenutiApplicativi();
            this.getReadConnectionTimeout_inoltroBusteEGov();
            if (this.isRitardoConsegnaAbilitato()) {
                if (this.getRitardoConsegnaEsponenziale() <= 0L) {
                    return false;
                }
                if (this.getRitardoConsegnaEsponenziale() > 0L) {
                    try {
                        this.isRitardoConsegnaEsponenzialeConMoltiplicazione();
                    }
                    catch (Exception e) {
                        return false;
                    }
                    if (this.getRitardoConsegnaEsponenzialeLimite() <= 0L) {
                        return false;
                    }
                }
            }
            try {
                if (this.isAbilitataCacheGestoreMessaggi()) {
                    algoritmo = this.getAlgoritmoCacheGestoreMessaggi();
                    if (algoritmo != null && !"lru".equals(algoritmo) && !"mru".equals(algoritmo)) {
                        this.log.error((Object)("Algoritmo utilizzato con la cache (Gestore Messaggi) non conosciuto: " + algoritmo));
                        throw new Exception("Algoritmo Cache (Gestore Messaggi) non conosciuto");
                    }
                    this.getDimensioneCacheGestoreMessaggi();
                    this.getItemIdleTimeCacheGestoreMessaggi();
                    this.getItemLifeSecondCacheGestoreMessaggi();
                }
            }
            catch (Exception e) {
                return false;
            }
            this.isRisorseJMXAbilitate();
            this.getJNDIName_MBeanServer();
            this.getJNDIContext_MBeanServer();
            if (this.getTipoDateManager() == null) {
                return false;
            }
            String tipoDateManger = className.getDateManager(this.getTipoDateManager());
            if (tipoDateManger == null) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.date.tipo'. \n Il DateManager indicato non esiste [" + this.getTipoDateManager() + "] nelle classi registrate in OpenSPCoop"));
                return false;
            }
            try {
                c = Class.forName(tipoDateManger);
                IDate date = (IDate)c.newInstance();
                date.toString();
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.date.tipo'. \n Il DateManager indicato non esiste [" + this.getTipoDateManager() + "]: " + e.getMessage()));
                return false;
            }
            if (this.getDateManagerProperties() == null) {
                this.log.error((Object)"Riscontrato errore durante la lettura della proprieta' del DataManager: 'org.openspcoop.pdd.date.property.*'. Proprieta' definite in maniera errata?");
                return false;
            }
            this.getTipoTempoEGov("standard");
            this.integrationManager_readInformazioniTrasporto();
            this.integrationManager_isNomePortaDelegataUrlBased();
            this.isDeleteInstructionTargetMachineXml();
            this.getTunnelSOAPKeyWord();
            this.getTunnelSOAPKeyWordMimeType();
            this.isBypassFilterMustUnderstandEnabledForAllHeaders();
            this.getTimeoutBustaRispostaAsincrona();
            this.getCheckIntervalBustaRispostaAsincrona();
            this.isGenerazioneAttributiAsincroni("standard");
            this.isHttp202OneWay();
            this.isHttp202OneWay_PD_HTTPEmptyResponse();
            this.getTipiSoggetti();
            this.getTipiServizi();
            this.isIgnoraEccezioniNonGravi();
            this.isGenerazioneListaTrasmissioni("standard");
            this.isGenerazioneSPCoopErroreFiltroDuplicati("standard");
            this.isCheckFromRegistroFiltroDuplicatiAbilitato("standard");
            this.isCheckFromRegistroConfermaRicezioneAbilitato("standard");
            this.isCheckFromRegistroConsegnaInOrdineAbilitato("standard");
            this.isGestioneConsegnaInOrdine("standard");
            this.isGestioneElementoCollaborazione("standard");
            this.isGestioneRiscontri("standard");
            this.ignoraEccezioniNonGravi_ValidazioneSPCoop();
            this.isGenerazioneSPCoopErrore_strutturaMalformataHeaderEGov();
            this.getRoleRichiestaManifest("standard");
            this.getRoleRispostaManifest("standard");
            this.getRoleAllegatoManifest("standard");
            this.isReadQualifiedAttribute("standard");
            if (this.getStatelessOneWay() == null) {
                return false;
            }
            if (this.getStatelessSincrono() == null) {
                return false;
            }
            if (this.getStatelessRouting() == null) {
                return false;
            }
            if (this.getNegoziamentoConnessioneDatasource() == null) {
                return false;
            }
            if ("disabilitato".equals(this.getNegoziamentoConnessioneDatasource())) {
                if (this.getConnectionNumberPoolStateless() < 0) {
                    return false;
                }
                this.getValidationConnectionPoolStateless();
            }
            this.isGestioneOnewayStateful_1_1();
            this.isGestioneStateful_RinegoziamentoConnessione();
            if (this.getTipiMisurazioneTempiAttraversamentoPdD() != null) {
                String[] tipiIntegrazione = this.getTipiMisurazioneTempiAttraversamentoPdD();
                for (int i3 = 0; i3 < tipiIntegrazione.length; ++i3) {
                    String tipoClass4 = className.getNotificaTempiAttraversamentoPdD(tipiIntegrazione[i3]);
                    if (tipoClass4 == null) {
                        this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.monitor.misurazioneTempi." + tipiIntegrazione[i3] + "'. \n Il tipo non esiste nelle classi registrate in OpenSPCoop"));
                        return false;
                    }
                    try {
                        Class<?> c7 = Class.forName(tipoClass4);
                        INotificaTempiAttraversamentoPdD gestore2 = (INotificaTempiAttraversamentoPdD)c7.newInstance();
                        gestore2.toString();
                        continue;
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.monitor.misurazioneTempi." + tipiIntegrazione[i3] + "'. \n Il tipo non esiste: " + e.getMessage()));
                        return false;
                    }
                }
            }
            this.isGenerazioneActorDefault("standard");
            this.getActorDefault("standard");
            this.isReadObjectStatoBozza();
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)("Riscontrato errore durante la validazione lettura della proprieta' di openspcoop: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    private boolean checkTipiIntegrazione(String[] tipiIntegrazione) {
        for (int i = 0; i < tipiIntegrazione.length; ++i) {
            if ("trasporto".equals(tipiIntegrazione[i]) || "urlBased".equals(tipiIntegrazione[i])) {
                if (this.getKeyValue_HeaderIntegrazione() == null) {
                    this.log.error((Object)"Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.integrazione.keyword.*'.");
                    return false;
                }
                Properties prop = this.getKeyValue_HeaderIntegrazione();
                if (prop.get("tipoMittente") == null) {
                    this.log.error((Object)"Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.integrazione.keyword.tipoMittente'.");
                    return false;
                }
                if (prop.get("mittente") == null) {
                    this.log.error((Object)"Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.integrazione.keyword.mittente'.");
                    return false;
                }
                if (prop.get("tipoDestinatario") == null) {
                    this.log.error((Object)"Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.integrazione.keyword.tipoDestinatario'.");
                    return false;
                }
                if (prop.get("destinatario") == null) {
                    this.log.error((Object)"Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.integrazione.keyword.destinatario'.");
                    return false;
                }
                if (prop.get("tipoServizio") == null) {
                    this.log.error((Object)"Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.integrazione.keyword.tipoServizio'.");
                    return false;
                }
                if (prop.get("servizio") == null) {
                    this.log.error((Object)"Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.integrazione.keyword.servizio'.");
                    return false;
                }
                if (prop.get("azione") == null) {
                    this.log.error((Object)"Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.integrazione.keyword.azione'.");
                    return false;
                }
                if (prop.get("idegov") == null) {
                    this.log.error((Object)"Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.integrazione.keyword.idegov'.");
                    return false;
                }
                if (prop.get("riferimentoMessaggio") == null) {
                    this.log.error((Object)"Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.integrazione.keyword.riferimentoMessaggio'.");
                    return false;
                }
                if (prop.get("idCollaborazione") == null) {
                    this.log.error((Object)"Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.integrazione.keyword.idCollaborazione'.");
                    return false;
                }
                if (prop.get("idApplicativo") == null) {
                    this.log.error((Object)"Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.integrazione.keyword.idApplicativo'.");
                    return false;
                }
                if (prop.get("servizioApplicativo") != null) break;
                this.log.error((Object)"Riscontrato errore durante la lettura della proprieta' di openspcoop: 'org.openspcoop.pdd.integrazione.keyword.servizioApplicativo'.");
                return false;
            }
            if (!"soap".equals(tipiIntegrazione[i])) continue;
            if (this.getHeaderSoapNameIntegrazione() == null) {
                return false;
            }
            if (this.getHeaderSoapActorIntegrazione() == null) {
                return false;
            }
            if (this.getHeaderSoapPrefixIntegrazione() != null) continue;
            return false;
        }
        return true;
    }

    public String getRootDirectory() {
        if (!"db".equalsIgnoreCase(this.getTipoConfigurazionePDD()) && rootDirectory == null) {
            try {
                String root = null;
                root = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.confDirectory");
                if (root == null) {
                    throw new Exception("non definita");
                }
                if (!(root = root.trim()).endsWith(File.separator)) {
                    root = root + File.separator;
                }
                rootDirectory = root;
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop, 'org.openspcoop.pdd.confDirectory': " + e.getMessage()));
                rootDirectory = null;
            }
        }
        return rootDirectory;
    }

    public String getPathConfigurazionePDD() {
        if (pathConfigurazionePDD == null) {
            try {
                String indirizzo = this.reader.getValue("org.openspcoop.pdd.config.location");
                if (indirizzo == null) {
                    throw new Exception("non definita");
                }
                indirizzo = indirizzo.trim();
                if ("xml".equalsIgnoreCase(this.getTipoConfigurazionePDD()) && !indirizzo.startsWith("http://") && !indirizzo.startsWith("file://")) {
                    if (!indirizzo.startsWith("${")) {
                        String root = this.getRootDirectory();
                        indirizzo = root + indirizzo;
                    }
                    if (indirizzo.indexOf("${") != -1) {
                        while (indirizzo.indexOf("${") != -1) {
                            int indexStart = indirizzo.indexOf("${");
                            int indexEnd = indirizzo.indexOf("}");
                            if (indexEnd == -1) {
                                throw new Exception("errore durante l'interpretazione del path [" + indirizzo + "]: ${ utilizzato senza la rispettiva chiusura }");
                            }
                            String nameSystemProperty = indirizzo.substring(indexStart + "${".length(), indexEnd);
                            String valueSystemProperty = System.getProperty(nameSystemProperty);
                            if (valueSystemProperty == null) {
                                throw new Exception("errore durante l'interpretazione del path [" + indirizzo + "]: variabile di sistema ${" + nameSystemProperty + "} non esistente");
                            }
                            indirizzo = indirizzo.replace("${" + nameSystemProperty + "}", valueSystemProperty);
                        }
                    }
                }
                pathConfigurazionePDD = indirizzo;
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.config.location': " + e.getMessage()));
                pathConfigurazionePDD = null;
            }
        }
        return pathConfigurazionePDD;
    }

    public String getTipoConfigurazionePDD() {
        if (tipoConfigurazionePDD == null) {
            try {
                String tipo = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.config.tipo");
                if (tipo == null) {
                    throw new Exception("non definita");
                }
                tipoConfigurazionePDD = tipo = tipo.trim();
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.config.tipo': " + e.getMessage()));
                tipoConfigurazionePDD = null;
            }
        }
        return tipoConfigurazionePDD;
    }

    public boolean isCondivisioneConfigurazioneRegistroDB() {
        if (isCondivisioneConfigurazioneRegistroDB == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.config.db.condivisioneDBRegserv");
                isCondivisioneConfigurazioneRegistroDB = value == null ? Boolean.valueOf(false) : Boolean.valueOf(Boolean.parseBoolean(value));
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.config.db.condivisioneDBRegserv' (Viene utilizzato il default:false): " + e.getMessage()));
                isCondivisioneConfigurazioneRegistroDB = false;
            }
        }
        return isCondivisioneConfigurazioneRegistroDB;
    }

    public Properties getJNDIContext_Configurazione() {
        if (jndiContext_Configurazione == null) {
            Properties prop = new Properties();
            try {
                jndiContext_Configurazione = prop = this.reader.readProperties_convertEnvProperties("org.openspcoop.pdd.config.property.");
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura delle propriete' JNDI per la configurazione di openspcoop 'org.openspcoop.pdd.config.property.*': " + e.getMessage()));
                jndiContext_Configurazione = null;
            }
        }
        return jndiContext_Configurazione;
    }

    public boolean isAbilitataCacheConfig() {
        if (isAbilitataCacheConfig_value == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.config.cache.enable");
                if (value != null) {
                    value = value.trim();
                    isAbilitataCacheConfig_value = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.config.cache.enable' non impostata, viene utilizzato il default=false");
                    isAbilitataCacheConfig_value = false;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.config.cache.enable' non impostata, viene utilizzato il default=false, errore:" + e.getMessage()));
                isAbilitataCacheConfig_value = false;
            }
        }
        return isAbilitataCacheConfig_value;
    }

    public int getDimensioneCacheConfig() throws OpenSPCoopConfigurationException {
        if (dimensioneCacheConfig_value == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.config.cache.dimensione");
                if (value != null) {
                    value = value.trim();
                    dimensioneCacheConfig_value = Integer.parseInt(value);
                } else {
                    dimensioneCacheConfig_value = -1;
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.config.cache.dimensione': " + e.getMessage()));
                throw new OpenSPCoopConfigurationException("Riscontrato errore durante la lettura della proprieta' di openspcoop  'org.openspcoop.pdd.config.cache.dimensione'", e);
            }
        }
        return dimensioneCacheConfig_value;
    }

    public String getAlgoritmoCacheConfig() throws OpenSPCoopConfigurationException {
        if (algoritmoCacheConfig_value == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.config.cache.algoritmo");
                algoritmoCacheConfig_value = value != null ? (value = value.trim()) : null;
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.config.cache.algoritmo': " + e.getMessage()));
                throw new OpenSPCoopConfigurationException("Riscontrato errore durante la lettura della proprieta' di openspcoop  'org.openspcoop.pdd.config.cache.algoritmo'", e);
            }
        }
        return algoritmoCacheConfig_value;
    }

    public int getItemIdleTimeCacheConfig() throws OpenSPCoopConfigurationException {
        if (itemIdleTimeCacheConfig_value == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.config.cache.itemIdleTime");
                if (value != null) {
                    value = value.trim();
                    itemIdleTimeCacheConfig_value = Integer.parseInt(value);
                } else {
                    itemIdleTimeCacheConfig_value = -1;
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.config.cache.itemIdleTime': " + e.getMessage()));
                throw new OpenSPCoopConfigurationException("Riscontrato errore durante la lettura della proprieta' di openspcoop  'org.openspcoop.pdd.config.cache.itemIdleTime'", e);
            }
        }
        return itemIdleTimeCacheConfig_value;
    }

    public int getItemLifeSecondCacheConfig() throws OpenSPCoopConfigurationException {
        if (itemLifeSecondCacheConfig_value == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.config.cache.itemLifeSecond");
                if (value != null) {
                    value = value.trim();
                    itemLifeSecondCacheConfig_value = Integer.parseInt(value);
                } else {
                    itemLifeSecondCacheConfig_value = -1;
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.config.cache.itemLifeSecond': " + e.getMessage()));
                throw new OpenSPCoopConfigurationException("Riscontrato errore durante la lettura della proprieta' di openspcoop  'org.openspcoop.pdd.config.cache.itemLifeSecond'", e);
            }
        }
        return itemLifeSecondCacheConfig_value;
    }

    public AccessoConfigurazionePdD getAccessoConfigurazionePdD() throws OpenSPCoopConfigurationException {
        if (accessoConfigurazionePdD == null) {
            try {
                AccessoConfigurazionePdD conf = new AccessoConfigurazionePdD();
                conf.setTipo(this.getTipoConfigurazionePDD());
                if ("db".equalsIgnoreCase(this.getTipoConfigurazionePDD())) {
                    String tipoDatabase = null;
                    String location = null;
                    if (this.getPathConfigurazionePDD().indexOf("@") != -1) {
                        tipoDatabase = DBUtils.estraiTipoDatabaseFromLocation((String)this.getPathConfigurazionePDD());
                        location = this.getPathConfigurazionePDD().substring(this.getPathConfigurazionePDD().indexOf("@") + 1);
                    } else {
                        tipoDatabase = this.getDatabaseType();
                        location = this.getPathConfigurazionePDD();
                    }
                    conf.setLocation(location);
                    conf.setTipoDatabase(tipoDatabase);
                } else {
                    conf.setLocation(this.getPathConfigurazionePDD());
                }
                conf.setContext(this.getJNDIContext_Configurazione());
                conf.setCondivisioneDatabasePddRegistro(this.isCondivisioneConfigurazioneRegistroDB());
                conf.setUtilizzoCache(this.isAbilitataCacheConfig());
                if (conf.getUtilizzoCache()) {
                    int life;
                    int idle;
                    int dimensione;
                    String algoritmo = this.getAlgoritmoCacheConfig();
                    if (algoritmo != null) {
                        conf.setAlgoritmoCache(algoritmo);
                    }
                    if ((dimensione = this.getDimensioneCacheConfig()) != -1) {
                        conf.setDimensioneCache(Integer.valueOf(dimensione));
                    }
                    if ((idle = this.getItemIdleTimeCacheConfig()) != -1) {
                        conf.setItemIdleTimeCache(Integer.valueOf(idle));
                    }
                    if ((life = this.getItemLifeSecondCacheConfig()) != -1) {
                        conf.setItemLifeTimeCache(Integer.valueOf(life));
                    }
                }
                accessoConfigurazionePdD = conf;
            }
            catch (Exception e) {
                throw new OpenSPCoopConfigurationException("Riscontrato errore durante la lettura della modalita' di accesso alla configurazione della PdD OpenSPCoop", e);
            }
        }
        return accessoConfigurazionePdD;
    }

    public boolean isConfigurazioneDinamica() {
        if (isConfigurazioneDinamica_value == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.config.refresh");
                if (value != null) {
                    value = value.trim();
                    isConfigurazioneDinamica_value = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.config.refresh' non impostata, viene utilizzato il default=true");
                    isConfigurazioneDinamica_value = true;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.config.refresh' non impostata, viene utilizzato il default=true, errore:" + e.getMessage()));
                isConfigurazioneDinamica_value = true;
            }
        }
        return isConfigurazioneDinamica_value;
    }

    public String getJNDIName_DataSource() {
        if (jndiNameDatasource == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.dataSource");
                if (name == null) {
                    throw new Exception("non definita");
                }
                jndiNameDatasource = name = name.trim();
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.dataSource': " + e.getMessage()));
                jndiNameDatasource = null;
            }
        }
        return jndiNameDatasource;
    }

    public Properties getJNDIContext_DataSource() {
        if (jndiContextDatasource == null) {
            Properties prop = new Properties();
            try {
                jndiContextDatasource = prop = this.reader.readProperties_convertEnvProperties("org.openspcoop.pdd.dataSource.property.");
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura delle propriete' JNDI per il datasource di openspcoop 'org.openspcoop.pdd.dataSource.property.*': " + e.getMessage()));
                jndiContextDatasource = null;
            }
        }
        return jndiContextDatasource;
    }

    public String getJNDIName_ConnectionFactory() {
        if (jndiNameConnectionFactory == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.queueConnectionFactory");
                if (name == null) {
                    throw new Exception("non definita");
                }
                jndiNameConnectionFactory = name = name.trim();
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.queueConnectionFactory': " + e.getMessage()));
                jndiNameConnectionFactory = null;
            }
        }
        return jndiNameConnectionFactory;
    }

    public Properties getJNDIContext_ConnectionFactory() {
        if (jndiContextConnectionFactory == null) {
            Properties prop = new Properties();
            try {
                jndiContextConnectionFactory = prop = this.reader.readProperties_convertEnvProperties("org.openspcoop.pdd.connectionFactory.property.");
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura delle propriete' JNDI del ConnectionFactory di openspcoop 'org.openspcoop.pdd.connectionFactory.property.*': " + e.getMessage()));
                jndiContextConnectionFactory = null;
            }
        }
        return jndiContextConnectionFactory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getAcknowledgeModeSessioneConnectionFactory() {
        if (acknowledgeModeSessioneConnectionFactory != -1) return acknowledgeModeSessioneConnectionFactory;
        try {
            String name = null;
            name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.queueConnectionFactory.session.AcknowledgeMode");
            if (name != null) {
                if ("AUTO_ACKNOWLEDGE".equals(name = name.trim())) {
                    acknowledgeModeSessioneConnectionFactory = 1;
                    return acknowledgeModeSessioneConnectionFactory;
                } else if ("CLIENT_ACKNOWLEDGE".equals(name)) {
                    acknowledgeModeSessioneConnectionFactory = 2;
                    return acknowledgeModeSessioneConnectionFactory;
                } else {
                    if (!"DUPS_OK_ACKNOWLEDGE".equals(name)) throw new Exception("Tipo di acknowledgeModeSessione non conosciuto (viene utilizzato il default:AUTO_ACKNOWLEDGE)");
                    acknowledgeModeSessioneConnectionFactory = 3;
                }
                return acknowledgeModeSessioneConnectionFactory;
            } else {
                this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.queueConnectionFactory.session.AcknowledgeMode' non impostata, viene utilizzato il default=AUTO_ACKNOWLEDGE");
                acknowledgeModeSessioneConnectionFactory = 1;
            }
            return acknowledgeModeSessioneConnectionFactory;
        }
        catch (Exception e) {
            this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.queueConnectionFactory.session.AcknowledgeMode' non impostata, viene utilizzato il default=AUTO_ACKNOWLEDGE, errore:" + e.getMessage()));
            acknowledgeModeSessioneConnectionFactory = 1;
        }
        return acknowledgeModeSessioneConnectionFactory;
    }

    public Hashtable<String, String> getJNDIQueueName(boolean receiverJMSActive, boolean senderJMSActive) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        try {
            boolean ricezioneContenutiApplicativi = !receiverJMSActive;
            boolean ricezioneBusteEGov = !receiverJMSActive;
            boolean consegnaContenutiApplicativi = !senderJMSActive;
            boolean inoltroBusteEGov = !senderJMSActive;
            boolean inoltroRisposteEGov = !senderJMSActive;
            boolean imbustamento = !senderJMSActive;
            boolean imbustamentoRisposte = !senderJMSActive;
            boolean sbustamento = !senderJMSActive;
            boolean sbustamentoRisposte = !senderJMSActive;
            Enumeration en = this.reader.propertyNames();
            while (en.hasMoreElements()) {
                String value;
                String property = (String)en.nextElement();
                if (!property.startsWith("org.openspcoop.pdd.queue.")) continue;
                String key = property.substring("org.openspcoop.pdd.queue.".length());
                if (key != null) {
                    key = key.trim();
                }
                if ((value = this.reader.getValue_convertEnvProperties(property)) != null) {
                    value = value.trim();
                }
                if (receiverJMSActive) {
                    if ("ricezioneContenutiApplicativi".equals(key) && value != null) {
                        table.put("RicezioneContenutiApplicativi", value);
                        ricezioneContenutiApplicativi = true;
                    } else if ("ricezioneBusteEGov".equals(key) && value != null) {
                        table.put("RicezioneBusteEGov", value);
                        ricezioneBusteEGov = true;
                    }
                }
                if (!senderJMSActive) continue;
                if ("inoltroBusteEGov".equals(key) && value != null) {
                    table.put("InoltroBusteEGov", value);
                    inoltroBusteEGov = true;
                    continue;
                }
                if ("inoltroRisposteEGov".equals(key) && value != null) {
                    table.put("InoltroRisposteEGov", value);
                    inoltroRisposteEGov = true;
                    continue;
                }
                if ("consegnaContenutiApplicativi".equals(key) && value != null) {
                    table.put("ConsegnaContenutiApplicativi", value);
                    consegnaContenutiApplicativi = true;
                    continue;
                }
                if ("imbustamento".equals(key) && value != null) {
                    table.put("Imbustamento", value);
                    imbustamento = true;
                    continue;
                }
                if ("imbustamentoRisposte".equals(key) && value != null) {
                    table.put("ImbustamentoRisposte", value);
                    imbustamentoRisposte = true;
                    continue;
                }
                if ("sbustamento".equals(key) && value != null) {
                    table.put("Sbustamento", value);
                    sbustamento = true;
                    continue;
                }
                if (!"sbustamentoRisposte".equals(key) || value == null) continue;
                table.put("SbustamentoRisposte", value);
                sbustamentoRisposte = true;
            }
            if (!ricezioneContenutiApplicativi) {
                this.log.error((Object)"Riscontrato errore durante la lettura dei nomi JNDI delle code di openspcoop: coda org.openspcoop.pdd.queue.ricezioneContenutiApplicativi non definita");
                return null;
            }
            if (!ricezioneBusteEGov) {
                this.log.error((Object)"Riscontrato errore durante la lettura dei nomi JNDI delle code di openspcoop: coda org.openspcoop.pdd.queue.ricezioneBusteEGov non definita");
                return null;
            }
            if (!consegnaContenutiApplicativi) {
                this.log.error((Object)"Riscontrato errore durante la lettura dei nomi JNDI delle code di openspcoop: coda org.openspcoop.pdd.queue.consegnaContenutiApplicativi non definita");
                return null;
            }
            if (!inoltroBusteEGov) {
                this.log.error((Object)"Riscontrato errore durante la lettura dei nomi JNDI delle code di openspcoop: coda org.openspcoop.pdd.queue.inoltroBusteEGov non definita");
                return null;
            }
            if (!inoltroRisposteEGov) {
                this.log.error((Object)"Riscontrato errore durante la lettura dei nomi JNDI delle code di openspcoop: coda org.openspcoop.pdd.queue.inoltroRisposteEGov non definita");
                return null;
            }
            if (!imbustamento) {
                this.log.error((Object)"Riscontrato errore durante la lettura dei nomi JNDI delle code di openspcoop: coda org.openspcoop.pdd.queue.imbustamento non definita");
                return null;
            }
            if (!imbustamentoRisposte) {
                this.log.error((Object)"Riscontrato errore durante la lettura dei nomi JNDI delle code di openspcoop: coda org.openspcoop.pdd.queue.imbustamentoRisposte non definita");
                return null;
            }
            if (!sbustamentoRisposte) {
                this.log.error((Object)"Riscontrato errore durante la lettura dei nomi JNDI delle code di openspcoop: coda org.openspcoop.pdd.queue.sbustamentoRisposte non definita");
                return null;
            }
            if (!sbustamento) {
                this.log.error((Object)"Riscontrato errore durante la lettura dei nomi JNDI delle code di openspcoop: coda org.openspcoop.pdd.queue.sbustamento non definita");
                return null;
            }
            return table;
        }
        catch (Exception e) {
            this.log.error((Object)("Riscontrato errore durante la lettura dei nomi JNDI delle code di openspcoop 'org.openspcoop.pdd.queue.property.*': " + e.getMessage()));
            return null;
        }
    }

    public Properties getJNDIContext_CodeInterne() {
        if (jndiContext_CodeInterne == null) {
            Properties prop = new Properties();
            try {
                jndiContext_CodeInterne = prop = this.reader.readProperties_convertEnvProperties("org.openspcoop.pdd.queue.property.");
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura delle propriete' JNDI delle code di openspcoop 'org.openspcoop.pdd.queue.property.*': " + e.getMessage()));
                jndiContext_CodeInterne = null;
            }
        }
        return jndiContext_CodeInterne;
    }

    public Hashtable<String, String> getJNDITimerEJBName() {
        Hashtable<String, String> table = new Hashtable<String, String>();
        try {
            boolean gestoreBusteNonRiscontrate = false;
            boolean gestoreMessaggi = false;
            boolean gestorePuliziaMessaggiAnomali = false;
            boolean gestoreRepositoryEGov = false;
            Enumeration en = this.reader.propertyNames();
            while (en.hasMoreElements()) {
                String value;
                String property = (String)en.nextElement();
                if (!property.startsWith("org.openspcoop.pdd.timer.")) continue;
                String key = property.substring("org.openspcoop.pdd.timer.".length());
                if (key != null) {
                    key = key.trim();
                }
                if ((value = this.reader.getValue_convertEnvProperties(property)) != null) {
                    value = value.trim();
                }
                if ("gestoreBusteNonRiscontrate".equals(key) && value != null) {
                    table.put("GestoreBusteNonRiscontrate", value);
                    gestoreBusteNonRiscontrate = true;
                    continue;
                }
                if ("gestoreMessaggi".equals(key) && value != null) {
                    table.put("GestoreMessaggi", value);
                    gestoreMessaggi = true;
                    continue;
                }
                if ("gestorePuliziaMessaggiAnomali".equals(key) && value != null) {
                    table.put("GestoreConsistenzaDatabase", value);
                    gestorePuliziaMessaggiAnomali = true;
                    continue;
                }
                if (!"gestoreRepositoryEGov".equals(key) || value == null) continue;
                table.put("GestoreRepositoryEGov", value);
                gestoreRepositoryEGov = true;
            }
            if (!gestoreBusteNonRiscontrate && this.isTimerGestoreRiscontriRicevuteAbilitato()) {
                this.log.error((Object)"Riscontrato errore durante la lettura dei nomi JNDI dei timer openspcoop: timer org.openspcoop.pdd.timer.gestoreBusteNonRiscontrate non definito");
                return null;
            }
            if (!gestoreMessaggi && this.isTimerGestoreMessaggiAbilitato()) {
                this.log.error((Object)"Riscontrato errore durante la lettura dei nomi JNDI dei timer openspcoop: timer org.openspcoop.pdd.timer.gestoreMessaggi non definito");
                return null;
            }
            if (!gestorePuliziaMessaggiAnomali && this.isTimerGestorePuliziaMessaggiAnomaliAbilitato()) {
                this.log.error((Object)"Riscontrato errore durante la lettura dei nomi JNDI dei timer openspcoop: timer org.openspcoop.pdd.timer.gestorePuliziaMessaggiAnomali non definito");
                return null;
            }
            if (!gestoreRepositoryEGov && this.isTimerGestoreRepositoryEGovAbilitato()) {
                this.log.error((Object)"Riscontrato errore durante la lettura dei nomi JNDI dei timer openspcoop: timer org.openspcoop.pdd.timer.gestoreRepositoryEGov  non definito");
                return null;
            }
            return table;
        }
        catch (Exception e) {
            this.log.error((Object)("Riscontrato errore durante la lettura dei nomi JNDI delle code di openspcoop 'org.openspcoop.pdd.queue.property.*': " + e.getMessage()));
            return null;
        }
    }

    public Properties getJNDIContext_TimerEJB() {
        if (jndiContext_TimerEJB == null) {
            Properties prop = new Properties();
            try {
                jndiContext_TimerEJB = prop = this.reader.readProperties_convertEnvProperties("org.openspcoop.pdd.timer.property.");
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura delle propriete' JNDI dei timer di openspcoop 'org.openspcoop.pdd.timer.property.*': " + e.getMessage()));
                jndiContext_TimerEJB = null;
            }
        }
        return jndiContext_TimerEJB;
    }

    public boolean isTimerGestoreMessaggiAbilitato() {
        if (isTimerGestoreMessaggiAbilitato == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.timer.gestoreMessaggi.enable");
                if (value != null) {
                    value = value.trim();
                    isTimerGestoreMessaggiAbilitato = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.timer.gestoreMessaggi.enable' non impostata, viene utilizzato il default=true");
                    isTimerGestoreMessaggiAbilitato = true;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.timer.gestoreMessaggi.enable', viene utilizzato il default=true, errore:" + e.getMessage()));
                isTimerGestoreMessaggiAbilitato = true;
            }
        }
        return isTimerGestoreMessaggiAbilitato;
    }

    public boolean isTimerGestorePuliziaMessaggiAnomaliAbilitato() {
        if (isTimerGestorePuliziaMessaggiAnomaliAbilitato == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.timer.gestorePuliziaMessaggiAnomali.enable");
                if (value != null) {
                    value = value.trim();
                    isTimerGestorePuliziaMessaggiAnomaliAbilitato = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.timer.gestorePuliziaMessaggiAnomali.enable' non impostata, viene utilizzato il default=true");
                    isTimerGestorePuliziaMessaggiAnomaliAbilitato = true;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.timer.gestorePuliziaMessaggiAnomali.enable', viene utilizzato il default=true, errore:" + e.getMessage()));
                isTimerGestorePuliziaMessaggiAnomaliAbilitato = true;
            }
        }
        return isTimerGestorePuliziaMessaggiAnomaliAbilitato;
    }

    public boolean isTimerGestoreRepositoryEGovAbilitato() {
        if (isTimerGestoreRepositoryEGovAbilitato == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.timer.gestoreRepositoryEGov.enable");
                if (value != null) {
                    value = value.trim();
                    isTimerGestoreRepositoryEGovAbilitato = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.timer.gestoreRepositoryEGov.enable' non impostata, viene utilizzato il default=true");
                    isTimerGestoreRepositoryEGovAbilitato = true;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.timer.gestoreRepositoryEGov.enable', viene utilizzato il default=true, errore:" + e.getMessage()));
                isTimerGestoreRepositoryEGovAbilitato = true;
            }
        }
        return isTimerGestoreRepositoryEGovAbilitato;
    }

    public boolean isTimerGestoreRiscontriRicevuteAbilitato() {
        if (isTimerGestoreRiscontriRicevuteAbilitato == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.timer.gestoreBusteNonRiscontrate.enable");
                if (value != null) {
                    value = value.trim();
                    isTimerGestoreRiscontriRicevuteAbilitato = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.timer.gestoreBusteNonRiscontrate.enable' non impostata, viene utilizzato il default=true");
                    isTimerGestoreRiscontriRicevuteAbilitato = true;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.timer.gestoreBusteNonRiscontrate.enable', viene utilizzato il default=true, errore:" + e.getMessage()));
                isTimerGestoreRiscontriRicevuteAbilitato = true;
            }
        }
        return isTimerGestoreRiscontriRicevuteAbilitato;
    }

    public boolean isTimerGestoreMessaggiAbilitatoLog() {
        if (isTimerGestoreMessaggiAbilitatoLog == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.timer.gestoreMessaggi.logQuery");
                if (value != null) {
                    value = value.trim();
                    isTimerGestoreMessaggiAbilitatoLog = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.timer.gestoreMessaggi.logQuery' non impostata, viene utilizzato il default=false");
                    isTimerGestoreMessaggiAbilitatoLog = false;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.timer.gestoreMessaggi.logQuery', viene utilizzato il default=false, errore:" + e.getMessage()));
                isTimerGestoreMessaggiAbilitatoLog = false;
            }
        }
        return isTimerGestoreMessaggiAbilitatoLog;
    }

    public boolean isTimerGestorePuliziaMessaggiAnomaliAbilitatoLog() {
        if (isTimerGestorePuliziaMessaggiAnomaliAbilitatoLog == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.timer.gestorePuliziaMessaggiAnomali.logQuery");
                if (value != null) {
                    value = value.trim();
                    isTimerGestorePuliziaMessaggiAnomaliAbilitatoLog = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.timer.gestorePuliziaMessaggiAnomali.logQuery' non impostata, viene utilizzato il default=false");
                    isTimerGestorePuliziaMessaggiAnomaliAbilitatoLog = false;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.timer.gestorePuliziaMessaggiAnomali.logQuery', viene utilizzato il default=false, errore:" + e.getMessage()));
                isTimerGestorePuliziaMessaggiAnomaliAbilitatoLog = false;
            }
        }
        return isTimerGestorePuliziaMessaggiAnomaliAbilitatoLog;
    }

    public boolean isTimerGestoreRepositoryEGovAbilitatoLog() {
        if (isTimerGestoreRepositoryEGovAbilitatoLog == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.timer.gestoreRepositoryEGov.logQuery");
                if (value != null) {
                    value = value.trim();
                    isTimerGestoreRepositoryEGovAbilitatoLog = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.timer.gestoreRepositoryEGov.logQuery' non impostata, viene utilizzato il default=false");
                    isTimerGestoreRepositoryEGovAbilitatoLog = false;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.timer.gestoreRepositoryEGov.logQuery', viene utilizzato il default=false, errore:" + e.getMessage()));
                isTimerGestoreRepositoryEGovAbilitatoLog = false;
            }
        }
        return isTimerGestoreRepositoryEGovAbilitatoLog;
    }

    public boolean isTimerGestoreRiscontriRicevuteAbilitatoLog() {
        if (isTimerGestoreRiscontriRicevuteAbilitatoLog == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.timer.gestoreBusteNonRiscontrate.logQuery");
                if (value != null) {
                    value = value.trim();
                    isTimerGestoreRiscontriRicevuteAbilitatoLog = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.timer.gestoreBusteNonRiscontrate.logQuery' non impostata, viene utilizzato il default=false");
                    isTimerGestoreRiscontriRicevuteAbilitatoLog = false;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.timer.gestoreBusteNonRiscontrate.logQuery', viene utilizzato il default=false, errore:" + e.getMessage()));
                isTimerGestoreRiscontriRicevuteAbilitatoLog = false;
            }
        }
        return isTimerGestoreRiscontriRicevuteAbilitatoLog;
    }

    public String getRepositoryType() {
        if (repositoryType == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.repository.tipo");
                if (name == null) {
                    throw new Exception("non definita");
                }
                repositoryType = name = name.trim();
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.repository.tipo': " + e.getMessage()));
                repositoryType = null;
            }
        }
        return repositoryType;
    }

    public String getDatabaseType() {
        if (databaseType == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.repository.tipoDatabase");
                if (name != null) {
                    name = name.trim();
                }
                databaseType = name;
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.repository.tipoDatabase': " + e.getMessage()));
                databaseType = null;
            }
        }
        return databaseType;
    }

    public boolean isRepositoryOnFS() {
        if (isRepositoryOnFS_value == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.repository.tipo");
                if (name != null) {
                    isRepositoryOnFS_value = "db".equals(name = name.trim()) ? Boolean.valueOf(false) : Boolean.valueOf(true);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.repository.tipo' non impostata, viene utilizzato il default=true");
                    isRepositoryOnFS_value = true;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.repository.tipo' non impostata, viene utilizzato il default=true, errore:" + e.getMessage()));
                isRepositoryOnFS_value = true;
            }
        }
        return isRepositoryOnFS_value;
    }

    public String getRepositoryDirectory() {
        if (repositoryDirectory == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.repository.directory");
                if (name == null) {
                    throw new Exception("non definita");
                }
                repositoryDirectory = name = name.trim();
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.repository.directory': " + e.getMessage()));
                repositoryDirectory = null;
            }
        }
        return repositoryDirectory;
    }

    public String getRepositoryJDBCAdapter() {
        if (repositoryJDBCAdapter == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.repository.jdbcAdapter");
                if (name == null) {
                    throw new Exception("non definita");
                }
                repositoryJDBCAdapter = name = name.trim();
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.repository.jdbcAdapter': " + e.getMessage()));
                repositoryJDBCAdapter = null;
            }
        }
        return repositoryJDBCAdapter;
    }

    public boolean isForceIndex() {
        if (forceIndex == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.repository.forceIndex");
                if (name != null) {
                    name = name.trim();
                    forceIndex = Boolean.parseBoolean(name);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.repository.forceIndex' non impostata, viene utilizzato il default=false");
                    forceIndex = false;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.repository.forceIndex' non impostata, viene utilizzato il default=false, errore:" + e.getMessage()));
                forceIndex = false;
            }
        }
        return forceIndex;
    }

    public long getRepositoryIntervalloEliminazioneMessaggi() {
        if (repositoryIntervalloEliminazioneMessaggi == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.repository.timer");
                if (name == null) {
                    throw new Exception("non definita");
                }
                name = name.trim();
                repositoryIntervalloEliminazioneMessaggi = Long.parseLong(name);
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.repository.timer': " + e.getMessage()));
                repositoryIntervalloEliminazioneMessaggi = -1L;
            }
        }
        return repositoryIntervalloEliminazioneMessaggi;
    }

    public long getRepositoryIntervalloScadenzaMessaggi() {
        if (repositoryIntervalloScadenzaMessaggi == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.repository.scadenzaMessaggio");
                if (name == null) {
                    throw new Exception("non definita");
                }
                name = name.trim();
                repositoryIntervalloScadenzaMessaggi = Long.parseLong(name);
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.repository.scadenzaMessaggio': " + e.getMessage()));
                repositoryIntervalloScadenzaMessaggi = -1L;
            }
        }
        return repositoryIntervalloScadenzaMessaggi;
    }

    public long getMsgGiaInProcessamento_AttesaAttiva() {
        if (msgGiaInProcessamento_AttesaAttiva == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.repository.messaggioInProcessamento.attesaAttiva");
                if (name != null) {
                    name = name.trim();
                    long time = Long.parseLong(name);
                    msgGiaInProcessamento_AttesaAttiva = time * 1000L;
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.repository.messaggioInProcessamento.attesaAttiva' non impostato, viene utilizzato il default=90000");
                    msgGiaInProcessamento_AttesaAttiva = 90000L;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.repository.messaggioInProcessamento.attesaAttiva' non impostato, viene utilizzato il default=90000, errore:" + e.getMessage()));
                msgGiaInProcessamento_AttesaAttiva = 90000L;
            }
        }
        return msgGiaInProcessamento_AttesaAttiva;
    }

    public int getMsgGiaInProcessamento_CheckInterval() {
        if (msgGiaInProcessamento_CheckInterval == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.repository.messaggioInProcessamento.check");
                if (name != null) {
                    name = name.trim();
                    int time = Integer.parseInt(name);
                    msgGiaInProcessamento_CheckInterval = time;
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.repository.messaggioInProcessamento.check' non impostato, viene utilizzato il default=500");
                    msgGiaInProcessamento_CheckInterval = 500;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.repository.messaggioInProcessamento.check' non impostato, viene utilizzato il default=500, errore:" + e.getMessage()));
                msgGiaInProcessamento_CheckInterval = 500;
            }
        }
        return msgGiaInProcessamento_CheckInterval;
    }

    public String[] getRepositoryThresholdTypes() {
        if (!repositoryThresholdTypesRead) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.repository.threshold.tipi");
                if (name == null) {
                    repositoryThresholdTypes = null;
                } else {
                    String[] r = name.trim().split(",");
                    for (int i = 0; i < r.length; ++i) {
                        r[i] = r[i].trim();
                    }
                    repositoryThresholdTypes = r;
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.repository.threshold.tipi': " + e.getMessage()));
                repositoryThresholdTypes = null;
            }
            repositoryThresholdTypesRead = true;
        }
        return repositoryThresholdTypes;
    }

    public String getRepositoryThresholdValue(String tipoThreshould) {
        if (!repositoryThresholdValueRead) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.repository.threshold." + tipoThreshould + ".valore");
                repositoryThresholdValue = name != null ? (name = name.trim()) : null;
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.repository.threshold." + tipoThreshould + ".valore': " + e.getMessage()));
                repositoryThresholdValue = null;
            }
            repositoryThresholdValueRead = true;
        }
        return repositoryThresholdValue;
    }

    public long getRepositoryThresholdCheckInterval() {
        if (repositoryThresholdCheckInterval == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.repository.threshold.checkInterval");
                if (name != null) {
                    name = name.trim();
                    repositoryThresholdCheckInterval = Long.parseLong(name);
                } else {
                    repositoryThresholdCheckInterval = 0L;
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.repository.threshold.checkInterval': " + e.getMessage()));
                repositoryThresholdCheckInterval = -1L;
            }
        }
        return repositoryThresholdCheckInterval;
    }

    public boolean isAbilitatoControlloRisorseDB() {
        if (isAbilitatoControlloRisorseDB == null) {
            isAbilitatoControlloRisorseDB = this.isAbilitatoControlloRisorse("db");
        }
        return isAbilitatoControlloRisorseDB;
    }

    public boolean isAbilitatoControlloRisorseJMS() {
        if (isAbilitatoControlloRisorseJMS == null) {
            isAbilitatoControlloRisorseJMS = this.isAbilitatoControlloRisorse("jms");
        }
        return isAbilitatoControlloRisorseJMS;
    }

    public boolean isAbilitatoControlloRisorseTracciamentiPersonalizzati() {
        if (isAbilitatoControlloRisorseTracciamentiPersonalizzati == null) {
            isAbilitatoControlloRisorseTracciamentiPersonalizzati = this.isAbilitatoControlloRisorse("tracciamento");
        }
        return isAbilitatoControlloRisorseTracciamentiPersonalizzati;
    }

    public boolean isAbilitatoControlloRisorseMsgDiagnosticiPersonalizzati() {
        if (isAbilitatoControlloRisorseMsgDiagnosticiPersonalizzati == null) {
            isAbilitatoControlloRisorseMsgDiagnosticiPersonalizzati = this.isAbilitatoControlloRisorse("msgdiagnostici");
        }
        return isAbilitatoControlloRisorseMsgDiagnosticiPersonalizzati;
    }

    public boolean isAbilitatoControlloRisorseConfigurazione() {
        if (isAbilitatoControlloRisorseConfigurazione == null) {
            isAbilitatoControlloRisorseConfigurazione = this.isAbilitatoControlloRisorse("configurazione");
        }
        return isAbilitatoControlloRisorseConfigurazione;
    }

    public boolean isAbilitatoControlloRisorseRegistriServizi() {
        if (isAbilitatoControlloRisorseRegistriServizi == null) {
            isAbilitatoControlloRisorseRegistriServizi = this.isAbilitatoControlloRisorse("registri");
        }
        return isAbilitatoControlloRisorseRegistriServizi;
    }

    private boolean isAbilitatoControlloRisorse(String tipo) {
        try {
            String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.risorse.check." + tipo);
            if (value == null) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.risorse.check." + tipo + "' non impostata, viene utilizzato il default=false"));
                return false;
            }
            return "abilitato".equals(value);
        }
        catch (Exception e) {
            this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.risorse.check." + tipo + "' non impostata, viene utilizzato il default=false, errore:" + e.getMessage()));
            return false;
        }
    }

    public boolean isControlloRisorseRegistriRaggiungibilitaTotale() {
        if (isControlloRisorseRegistriRaggiungibilitaTotale == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.risorse.check.registri.tipo");
                if (value == null) {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.risorse.check.registri.tipo' non impostata, viene utilizzato il default=false");
                    isControlloRisorseRegistriRaggiungibilitaTotale = false;
                } else {
                    isControlloRisorseRegistriRaggiungibilitaTotale = "singolo".equals(value);
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.risorse.check.registri.tipo' non impostata, viene utilizzato il default=false, errore:" + e.getMessage()));
                isControlloRisorseRegistriRaggiungibilitaTotale = false;
            }
        }
        return isControlloRisorseRegistriRaggiungibilitaTotale;
    }

    public long getControlloRisorseCheckInterval() {
        if (controlloRisorseCheckInterval == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.risorse.checkInterval");
                if (name != null) {
                    name = name.trim();
                    controlloRisorseCheckInterval = Long.parseLong(name);
                } else {
                    controlloRisorseCheckInterval = 0L;
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.risorse.checkInterval': " + e.getMessage()));
                controlloRisorseCheckInterval = -1L;
            }
        }
        return controlloRisorseCheckInterval;
    }

    public ProprietaErroreApplicativo getProprietaGestioneErrorePD() {
        if (proprietaGestioneErrorePD == null) {
            String fault = null;
            try {
                fault = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.erroreApplicativo.fault");
                if (fault == null) {
                    throw new Exception("non definita");
                }
                fault = fault.trim();
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.erroreApplicativo.fault': " + e.getMessage()));
                return null;
            }
            String faultActor = null;
            try {
                faultActor = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.erroreApplicativo.faultActor");
                if (faultActor == null) {
                    throw new Exception("non definita");
                }
                faultActor = faultActor.trim();
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.erroreApplicativo.faultActor': " + e.getMessage()));
                return null;
            }
            String faultGeneric = null;
            try {
                faultGeneric = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.erroreApplicativo.genericFaultCode");
                if (faultGeneric == null) {
                    throw new Exception("non definita");
                }
                faultGeneric = faultGeneric.trim();
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.erroreApplicativo.genericFaultCode': " + e.getMessage()));
                return null;
            }
            String faultPrefix = null;
            try {
                faultPrefix = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.erroreApplicativo.prefixFaultCode");
                if (faultPrefix != null) {
                    faultPrefix = faultPrefix.trim();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            ProprietaErroreApplicativo gestione = new ProprietaErroreApplicativo();
            if ("xml".equals(fault)) {
                gestione.setFaultAsXML(true);
            } else {
                gestione.setFaultAsXML(false);
            }
            gestione.setFaultActor(faultActor);
            if ("abilitato".equals(faultGeneric)) {
                gestione.setFaultAsGenericCode(true);
            } else {
                gestione.setFaultAsGenericCode(false);
            }
            gestione.setFaultPrefixCode(faultPrefix);
            gestione.setInsertAsDetails(this.isErroreApplicativoIntoDetails());
            proprietaGestioneErrorePD = gestione;
        }
        ProprietaErroreApplicativo pNew = new ProprietaErroreApplicativo();
        pNew.setDominio(proprietaGestioneErrorePD.getDominio());
        pNew.setFaultActor(proprietaGestioneErrorePD.getFaultActor());
        pNew.setFaultAsGenericCode(proprietaGestioneErrorePD.isFaultAsGenericCode());
        pNew.setFaultAsXML(proprietaGestioneErrorePD.isFaultAsXML());
        pNew.setFaultPrefixCode(proprietaGestioneErrorePD.getFaultPrefixCode());
        pNew.setIdModulo(proprietaGestioneErrorePD.getIdModulo());
        pNew.setInsertAsDetails(proprietaGestioneErrorePD.isInsertAsDetails());
        return pNew;
    }

    public boolean isErroreApplicativoIntoDetails() {
        if (isErroreApplicativoIntoDetails == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.erroreApplicativo.fault.details");
                if (value != null) {
                    value = value.trim();
                    isErroreApplicativoIntoDetails = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.erroreApplicativo.fault.details' non impostata, viene utilizzato il default=true");
                    isErroreApplicativoIntoDetails = true;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.erroreApplicativo.fault.details' non impostata, viene utilizzato il default=true, errore:" + e.getMessage()));
                isErroreApplicativoIntoDetails = true;
            }
        }
        return isErroreApplicativoIntoDetails;
    }

    public String getIdentificativoPortaDefault() {
        if (identificativoPortaDefault == null) {
            try {
                String fault = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.identificativoPorta.dominio");
                if (fault == null) {
                    throw new Exception("non definita");
                }
                identificativoPortaDefault = fault = fault.trim();
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.identificativoPorta.dominio': " + e.getMessage()));
                identificativoPortaDefault = null;
            }
        }
        return identificativoPortaDefault;
    }

    public String getNomePortaDefault() {
        if (nomePortaDefault == null) {
            try {
                String fault = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.identificativoPorta.nome");
                if (fault == null) {
                    throw new Exception("non definita");
                }
                nomePortaDefault = fault = fault.trim();
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.identificativoPorta.nome': " + e.getMessage()));
                nomePortaDefault = null;
            }
        }
        return nomePortaDefault;
    }

    public String getTipoPortaDefault() {
        if (tipoPortaDefault == null) {
            try {
                String fault = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.identificativoPorta.tipo");
                if (fault == null) {
                    throw new Exception("non definita");
                }
                tipoPortaDefault = fault = fault.trim();
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.identificativoPorta.tipo': " + e.getMessage()));
                tipoPortaDefault = null;
            }
        }
        return tipoPortaDefault;
    }

    public IDSoggetto getIdentitaPortaDefault() {
        if (identitaPortaDefault == null) {
            String pdd = this.getIdentificativoPortaDefault();
            String nome = this.getNomePortaDefault();
            String tipo = this.getTipoPortaDefault();
            identitaPortaDefault = tipo == null || nome == null || pdd == null ? null : new IDSoggetto(tipo, nome, pdd);
        }
        IDSoggetto idNew = new IDSoggetto();
        idNew.setCodicePorta(identitaPortaDefault.getCodicePorta());
        idNew.setNome(identitaPortaDefault.getNome());
        idNew.setTipo(identitaPortaDefault.getTipo());
        return idNew;
    }

    public String getTipoAutorizzazioneSPCoop() {
        if (tipoAutorizzazioneSPCoop == null) {
            try {
                String autorizzazione = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.autorizzazioneSPCoop.tipo");
                if (autorizzazione == null) {
                    throw new Exception("non definita");
                }
                tipoAutorizzazioneSPCoop = autorizzazione = autorizzazione.trim();
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.autorizzazioneSPCoop.tipo': " + e.getMessage()));
                tipoAutorizzazioneSPCoop = null;
            }
        }
        return tipoAutorizzazioneSPCoop;
    }

    public boolean isAbilitataCacheAutorizzazioneSPCoop() {
        if (isAbilitataCacheAutorizzazioneSPCoop_value == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.autorizzazioneSPCoop.cache.enable");
                if (value != null) {
                    value = value.trim();
                    isAbilitataCacheAutorizzazioneSPCoop_value = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.autorizzazioneSPCoop.cache.enable' non impostata, viene utilizzato il default=false");
                    isAbilitataCacheAutorizzazioneSPCoop_value = false;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.autorizzazioneSPCoop.cache.enable' non impostata, viene utilizzato il default=false, errore:" + e.getMessage()));
                isAbilitataCacheAutorizzazioneSPCoop_value = false;
            }
        }
        return isAbilitataCacheAutorizzazioneSPCoop_value;
    }

    public int getDimensioneCacheAutorizzazioneSPCoop() throws OpenSPCoopConfigurationException {
        if (dimensioneCacheAutorizzazioneSPCoop_value == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.autorizzazioneSPCoop.cache.dimensione");
                if (value != null) {
                    value = value.trim();
                    dimensioneCacheAutorizzazioneSPCoop_value = Integer.parseInt(value);
                } else {
                    dimensioneCacheAutorizzazioneSPCoop_value = -1;
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.autorizzazioneSPCoop.cache.dimensione': " + e.getMessage()));
                throw new OpenSPCoopConfigurationException("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.autorizzazioneSPCoop.cache.dimensione'", e);
            }
        }
        return dimensioneCacheAutorizzazioneSPCoop_value;
    }

    public String getAlgoritmoCacheAutorizzazioneSPCoop() throws OpenSPCoopConfigurationException {
        if (algoritmoCacheAutorizzazioneSPCoop_value == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.autorizzazioneSPCoop.cache.algoritmo");
                algoritmoCacheAutorizzazioneSPCoop_value = value != null ? (value = value.trim()) : null;
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.autorizzazioneSPCoop.cache.algoritmo': " + e.getMessage()));
                throw new OpenSPCoopConfigurationException("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.autorizzazioneSPCoop.cache.algoritmo'", e);
            }
        }
        return algoritmoCacheAutorizzazioneSPCoop_value;
    }

    public int getItemIdleTimeCacheAutorizzazioneSPCoop() throws OpenSPCoopConfigurationException {
        if (itemIdleTimeCacheAutorizzazioneSPCoop_value == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.autorizzazioneSPCoop.cache.itemIdleTime");
                if (value != null) {
                    value = value.trim();
                    itemIdleTimeCacheAutorizzazioneSPCoop_value = Integer.parseInt(value);
                } else {
                    itemIdleTimeCacheAutorizzazioneSPCoop_value = -1;
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.autorizzazioneSPCoop.cache.itemIdleTime': " + e.getMessage()));
                throw new OpenSPCoopConfigurationException("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.autorizzazioneSPCoop.cache.itemIdleTime'", e);
            }
        }
        return itemIdleTimeCacheAutorizzazioneSPCoop_value;
    }

    public int getItemLifeSecondCacheAutorizzazioneSPCoop() throws OpenSPCoopConfigurationException {
        if (itemLifeSecondCacheAutorizzazioneSPCoop_value == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.autorizzazioneSPCoop.cache.itemLifeSecond");
                if (value != null) {
                    value = value.trim();
                    itemLifeSecondCacheAutorizzazioneSPCoop_value = Integer.parseInt(value);
                } else {
                    itemLifeSecondCacheAutorizzazioneSPCoop_value = -1;
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.autorizzazioneSPCoop.cache.itemLifeSecond': " + e.getMessage()));
                throw new OpenSPCoopConfigurationException("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.autorizzazioneSPCoop.cache.itemLifeSecond'", e);
            }
        }
        return itemLifeSecondCacheAutorizzazioneSPCoop_value;
    }

    public Properties getBypassFilterMustUnderstandProperties() {
        if (getBypassFilterMustUnderstandProperties == null) {
            Properties prop = new Properties();
            try {
                getBypassFilterMustUnderstandProperties = prop = this.reader.readProperties_convertEnvProperties("org.openspcoop.pdd.services.BypassMustUnderstandHandler.header.");
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura delle propriete' 'org.openspcoop.pdd.services.BypassMustUnderstandHandler.header.*': " + e.getMessage()));
                getBypassFilterMustUnderstandProperties = null;
            }
        }
        return getBypassFilterMustUnderstandProperties;
    }

    public boolean isBypassFilterMustUnderstandEnabledForAllHeaders() {
        if (isBypassFilterMustUnderstandEnabledForAllHeaders == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.services.BypassMustUnderstandHandler.allHeaders");
                if (value != null) {
                    value = value.trim();
                    isBypassFilterMustUnderstandEnabledForAllHeaders = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.services.BypassMustUnderstandHandler.allHeaders' non impostata, viene utilizzato il default=false");
                    isBypassFilterMustUnderstandEnabledForAllHeaders = false;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.services.BypassMustUnderstandHandler.allHeaders' non impostata, viene utilizzato il default=false, errore:" + e.getMessage()));
                isBypassFilterMustUnderstandEnabledForAllHeaders = false;
            }
        }
        return isBypassFilterMustUnderstandEnabledForAllHeaders;
    }

    public long getNodeReceiverTimeout() {
        if (nodeReceiverTimeout == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.nodeReceiver.timeout");
                if (name != null) {
                    name = name.trim();
                    nodeReceiverTimeout = Long.parseLong(name);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.nodeReceiver.timeout' non impostata, viene utilizzato il default=300000");
                    nodeReceiverTimeout = 300000L;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.nodeReceiver.timeout' non impostata, viene utilizzato il default=300000, errore:" + e.getMessage()));
                nodeReceiverTimeout = 300000L;
            }
        }
        return nodeReceiverTimeout;
    }

    public long getNodeReceiverTimeoutRicezioneContenutiApplicativi() {
        if (nodeReceiverTimeoutRicezioneContenutiApplicativi == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.nodeReceiver.ricezioneContenutiApplicativi.timeout");
                if (name != null) {
                    name = name.trim();
                    nodeReceiverTimeoutRicezioneContenutiApplicativi = Long.parseLong(name);
                } else {
                    this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.nodeReceiver.ricezioneContenutiApplicativi.timeout' non impostata, viene utilizzato il default=" + this.getNodeReceiverTimeout()));
                    nodeReceiverTimeoutRicezioneContenutiApplicativi = this.getNodeReceiverTimeout();
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.nodeReceiver.ricezioneContenutiApplicativi.timeout' non impostata, viene utilizzato il default=" + this.getNodeReceiverTimeout() + ", errore:" + e.getMessage()));
                nodeReceiverTimeoutRicezioneContenutiApplicativi = this.getNodeReceiverTimeout();
            }
        }
        return nodeReceiverTimeoutRicezioneContenutiApplicativi;
    }

    public long getNodeReceiverTimeoutRicezioneBusteEgov() {
        if (nodeReceiverTimeoutRicezioneBusteEgov == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.nodeReceiver.ricezioneBusteEGov.timeout");
                if (name != null) {
                    name = name.trim();
                    nodeReceiverTimeoutRicezioneBusteEgov = Long.parseLong(name);
                } else {
                    this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.nodeReceiver.ricezioneBusteEGov.timeout' non impostata, viene utilizzato il default=" + this.getNodeReceiverTimeout()));
                    nodeReceiverTimeoutRicezioneBusteEgov = this.getNodeReceiverTimeout();
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.nodeReceiver.ricezioneBusteEGov.timeout' non impostata, viene utilizzato il default=" + this.getNodeReceiverTimeout() + ", errore:" + e.getMessage()));
                nodeReceiverTimeoutRicezioneBusteEgov = this.getNodeReceiverTimeout();
            }
        }
        return nodeReceiverTimeoutRicezioneBusteEgov;
    }

    public int getNodeReceiverCheckInterval() {
        if (nodeReceiverCheckInterval == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.nodeReceiver.check");
                if (name != null) {
                    name = name.trim();
                    nodeReceiverCheckInterval = Integer.parseInt(name);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.nodeReceiver.check' non impostata, viene utilizzato il default=10");
                    nodeReceiverCheckInterval = 10;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.nodeReceiver.check' non impostata, viene utilizzato il default=10, errore:" + e.getMessage()));
                nodeReceiverCheckInterval = 10;
            }
        }
        return nodeReceiverCheckInterval;
    }

    public int getNodeReceiverCheckDBInterval() {
        if (nodeReceiverCheckDBInterval == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.nodeReceiver.checkDB");
                if (name != null) {
                    name = name.trim();
                    int time = Integer.parseInt(name);
                    nodeReceiverCheckDBInterval = time;
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.nodeReceiver.checkDB' non impostata, viene utilizzato il default=25");
                    nodeReceiverCheckDBInterval = 25;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.nodeReceiver.checkDB' non impostata, viene utilizzato il default=25, errore:" + e.getMessage()));
                nodeReceiverCheckDBInterval = 25;
            }
        }
        return nodeReceiverCheckDBInterval;
    }

    public String getNodeReceiver() {
        if (nodeReceiver == null) {
            try {
                nodeReceiver = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.nodeReceiver");
                if (nodeReceiver == null) {
                    throw new Exception("non definita");
                }
                nodeReceiver = nodeReceiver.trim();
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.nodeReceiver': " + e.getMessage()));
                nodeReceiver = null;
            }
        }
        return nodeReceiver;
    }

    public boolean singleConnection_NodeReceiver() {
        if (singleConnection_nodeReceiver_value == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.nodeReceiver.singleConnection");
                if (value != null) {
                    value = value.trim();
                    singleConnection_nodeReceiver_value = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.nodeReceiver.singleConnection' non impostata, viene utilizzato il default=false");
                    singleConnection_nodeReceiver_value = false;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.nodeReceiver.singleConnection' non impostata, viene utilizzato il default=false, errore:" + e.getMessage()));
                singleConnection_nodeReceiver_value = false;
            }
        }
        return singleConnection_nodeReceiver_value;
    }

    public String getNodeSender() {
        if (nodeSender == null) {
            try {
                nodeSender = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.nodeSender");
                if (nodeSender == null) {
                    throw new Exception("non definita");
                }
                nodeSender = nodeSender.trim();
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.nodeSender': " + e.getMessage()));
                nodeSender = null;
            }
        }
        return nodeSender;
    }

    public long getTimerEJBDeployTimeout() {
        if (timerEJBDeployTimeout == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.timer.timeout");
                if (name != null) {
                    name = name.trim();
                    timerEJBDeployTimeout = Long.parseLong(name);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.timer.timeout' non impostata, viene utilizzato il default=60000");
                    timerEJBDeployTimeout = 60000L;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.timer.timeout' non impostata, viene utilizzato il default=60000, errore:" + e.getMessage()));
                timerEJBDeployTimeout = 60000L;
            }
        }
        return timerEJBDeployTimeout;
    }

    public int getTimerEJBDeployCheckInterval() {
        if (timerEJBDeployCheckInterval == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.timer.check");
                if (name != null) {
                    name = name.trim();
                    timerEJBDeployCheckInterval = Integer.parseInt(name);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.timer.check' non impostata, viene utilizzato il default=200");
                    timerEJBDeployCheckInterval = 200;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.timer.check' non impostata, viene utilizzato il default=200, errore:" + e.getMessage()));
                timerEJBDeployCheckInterval = 200;
            }
        }
        return timerEJBDeployCheckInterval;
    }

    public long getTransactionManager_AttesaAttiva() {
        if (transactionManager_AttesaAttiva == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.core.TransactionManager.attesaAttiva");
                if (name != null) {
                    name = name.trim();
                    long time = Long.parseLong(name);
                    transactionManager_AttesaAttiva = time * 1000L;
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.core.TransactionManager.attesaAttiva' non impostata, viene utilizzato il default=120000");
                    transactionManager_AttesaAttiva = 120000L;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.core.TransactionManager.attesaAttiva' non impostata, viene utilizzato il default=120000, errore:" + e.getMessage()));
                transactionManager_AttesaAttiva = 120000L;
            }
        }
        return transactionManager_AttesaAttiva;
    }

    public int getTransactionManager_CheckInterval() {
        if (transactionManager_CheckInterval == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.core.TransactionManager.check");
                if (name != null) {
                    name = name.trim();
                    int time = Integer.parseInt(name);
                    transactionManager_CheckInterval = time;
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.core.TransactionManager.check' non impostata, viene utilizzato il default=10");
                    transactionManager_CheckInterval = 10;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.core.TransactionManager.check' non impostata, viene utilizzato il default=10, errore:" + e.getMessage()));
                transactionManager_CheckInterval = 10;
            }
        }
        return transactionManager_CheckInterval;
    }

    public int getTransactionManager_CheckDBInterval() {
        if (transactionManager_CheckDBInterval == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.core.TransactionManager.checkDB");
                if (name != null) {
                    name = name.trim();
                    int time = Integer.parseInt(name);
                    transactionManager_CheckDBInterval = time;
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.core.TransactionManager.checkDB' non impostata, viene utilizzato il default=25");
                    transactionManager_CheckDBInterval = 25;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.core.TransactionManager.checkDB' non impostata, viene utilizzato il default=25, errore:" + e.getMessage()));
                transactionManager_CheckDBInterval = 25;
            }
        }
        return transactionManager_CheckDBInterval;
    }

    public boolean singleConnection_TransactionManager() {
        if (singleConnection_TransactionManager_value == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.core.TransactionManager.singleConnection");
                if (value != null) {
                    value = value.trim();
                    singleConnection_TransactionManager_value = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.core.TransactionManager.singleConnection' non impostata, viene utilizzato il default=false");
                    singleConnection_TransactionManager_value = false;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.core.TransactionManager.singleConnection' non impostata, viene utilizzato il default=false, errore:" + e.getMessage()));
                singleConnection_TransactionManager_value = false;
            }
        }
        return singleConnection_TransactionManager_value;
    }

    public long getGestioneSerializableDB_AttesaAttiva() {
        if (gestioneSerializableDB_AttesaAttiva == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.jdbc.serializable.attesaAttiva");
                if (name != null) {
                    name = name.trim();
                    long time = Long.parseLong(name);
                    gestioneSerializableDB_AttesaAttiva = time * 1000L;
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.jdbc.serializable.attesaAttiva' non impostata, viene utilizzato il default=60000");
                    gestioneSerializableDB_AttesaAttiva = 60000L;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.jdbc.serializable.attesaAttiva' non impostata, viene utilizzato il default=60000, errore:" + e.getMessage()));
                gestioneSerializableDB_AttesaAttiva = 60000L;
            }
        }
        return gestioneSerializableDB_AttesaAttiva;
    }

    public int getGestioneSerializableDB_CheckInterval() {
        if (gestioneSerializableDB_CheckInterval == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.jdbc.serializable.check");
                if (name != null) {
                    name = name.trim();
                    int time = Integer.parseInt(name);
                    gestioneSerializableDB_CheckInterval = time;
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.jdbc.serializable.check' non impostata, viene utilizzato il default=100");
                    gestioneSerializableDB_CheckInterval = 100;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.jdbc.serializable.check' non impostata, viene utilizzato il default=100, errore:" + e.getMessage()));
                gestioneSerializableDB_CheckInterval = 100;
            }
        }
        return gestioneSerializableDB_CheckInterval;
    }

    public String getTipoSeriale_IdentificativoEGov() {
        if (tipoSeriale_IdentificativoEGov == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.egov.id.tipo");
                if (name == null) {
                    throw new Exception("proprieta non definita");
                }
                tipoSeriale_IdentificativoEGov = name != null ? name.trim() : null;
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.egov.id.tipo': " + e.getMessage()));
                tipoSeriale_IdentificativoEGov = null;
            }
        }
        return tipoSeriale_IdentificativoEGov;
    }

    public int getPrefissoSeriale_IdentificativoEGov() {
        if (prefissoSeriale_IdentificativoEGov == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.egov.id.prefix");
                prefissoSeriale_IdentificativoEGov = name != null ? Integer.valueOf(Integer.parseInt(name.trim())) : Integer.valueOf(-1);
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.egov.id.prefix': " + e.getMessage()));
                prefissoSeriale_IdentificativoEGov = -2;
            }
        }
        return prefissoSeriale_IdentificativoEGov;
    }

    public String getGestoreRepositoryEGov() {
        if (gestoreRepositoryEGov == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.egov.repository.gestore");
                if (name == null) {
                    throw new Exception("non definita");
                }
                gestoreRepositoryEGov = name = name.trim();
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.egov.repository.gestore': " + e.getMessage()));
                gestoreRepositoryEGov = null;
            }
        }
        return gestoreRepositoryEGov;
    }

    public boolean isGenerazioneAttributiAsincroni(String implementazionePdDSoggetto) {
        String tipo;
        if (this.pddReader != null && (tipo = this.pddReader.getBustaEGov_AsincroniAttributiCorrelatiEnable(implementazionePdDSoggetto)) != null && ("true".equalsIgnoreCase(tipo) || "false".equalsIgnoreCase(tipo))) {
            return "true".equalsIgnoreCase(tipo);
        }
        if (isGenerazioneAttributiAsincroni == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.egov.asincroni.attributiCorrelati.enable");
                if (value != null) {
                    value = value.trim();
                    isGenerazioneAttributiAsincroni = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.egov.asincroni.attributiCorrelati.enable' non impostata, viene utilizzato il default=true");
                    isGenerazioneAttributiAsincroni = true;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.egov.asincroni.attributiCorrelati.enable' non impostata, viene utilizzato il default=true, errore:" + e.getMessage()));
                isGenerazioneAttributiAsincroni = true;
            }
        }
        return isGenerazioneAttributiAsincroni;
    }

    public boolean isHttp202OneWay() {
        if (isHttp202OneWay == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.egov.oneway.http202");
                if (value != null) {
                    value = value.trim();
                    isHttp202OneWay = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.egov.oneway.http202' non impostata, viene utilizzato il default=true");
                    isHttp202OneWay = true;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.egov.oneway.http202' non impostata, viene utilizzato il default=true, errore:" + e.getMessage()));
                isHttp202OneWay = true;
            }
        }
        return isHttp202OneWay;
    }

    public boolean isHttp202OneWay_PD_HTTPEmptyResponse() {
        if (isHttp202OneWay_PD_HTTPEmptyResponse == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.egov.oneway.http202.bodyEmptyWithHeader.enable");
                if (value != null) {
                    value = value.trim();
                    isHttp202OneWay_PD_HTTPEmptyResponse = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.egov.oneway.http202.bodyEmptyWithHeader.enable' non impostata, viene utilizzato il default=true");
                    isHttp202OneWay_PD_HTTPEmptyResponse = true;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.egov.oneway.http202.bodyEmptyWithHeader.enable' non impostata, viene utilizzato il default=true, errore:" + e.getMessage()));
                isHttp202OneWay_PD_HTTPEmptyResponse = true;
            }
        }
        return isHttp202OneWay_PD_HTTPEmptyResponse;
    }

    public Vector<String> getTipiSoggetti() {
        if (!tipiSoggettiRead) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.egov.soggetti.tipi");
                if (value == null) {
                    tipiSoggetti = new Vector();
                    tipiSoggetti.add("AOO");
                    tipiSoggetti.add("SPC");
                    tipiSoggetti.add("TEST");
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.egov.soggetti.tipi' non impostata, viene utilizzato il default=AOO,SPC,TEST");
                } else {
                    String[] r = (value = value.trim()).split(",");
                    if (r != null && r.length > 0) {
                        tipiSoggetti = new Vector();
                        for (int i = 0; i < r.length; ++i) {
                            tipiSoggetti.add(r[i]);
                        }
                    } else {
                        tipiSoggetti = new Vector();
                        tipiSoggetti.add("AOO");
                        tipiSoggetti.add("SPC");
                        tipiSoggetti.add("TEST");
                        this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.egov.soggetti.tipi' non impostata, viene utilizzato il default=AOO,SPC,TEST");
                    }
                }
            }
            catch (Exception e) {
                tipiSoggetti = new Vector();
                tipiSoggetti.add("AOO");
                tipiSoggetti.add("SPC");
                tipiSoggetti.add("TEST");
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.egov.soggetti.tipi' non impostata, viene utilizzato il default=AOO,SPC,TEST, errore:" + e.getMessage()));
            }
            tipiSoggettiRead = true;
        }
        return tipiSoggetti;
    }

    public Vector<String> getTipiServizi() {
        if (!tipiServiziRead) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.egov.servizi.tipi");
                if (value == null) {
                    tipiServizi = new Vector();
                    tipiServizi.add("LDAP");
                    tipiServizi.add("SPC");
                    tipiServizi.add("TEST");
                    tipiServizi.add("UDDI");
                    tipiServizi.add("URL");
                    tipiServizi.add("WSDL");
                    tipiServizi.add("ebXMLRegistry");
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.egov.servizi.tipi' non impostata, viene utilizzato il default=LDAP,SPC,TEST,UDDI,URL,WSDL,ebXMLRegistry");
                } else {
                    String[] r = (value = value.trim()).split(",");
                    if (r != null && r.length > 0) {
                        tipiServizi = new Vector();
                        for (int i = 0; i < r.length; ++i) {
                            tipiServizi.add(r[i]);
                        }
                    } else {
                        tipiServizi = new Vector();
                        tipiServizi.add("LDAP");
                        tipiServizi.add("SPC");
                        tipiServizi.add("TEST");
                        tipiServizi.add("UDDI");
                        tipiServizi.add("URL");
                        tipiServizi.add("WSDL");
                        tipiServizi.add("ebXMLRegistry");
                        this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.egov.servizi.tipi' non impostata, viene utilizzato il default=LDAP,SPC,TEST,UDDI,URL,WSDL,ebXMLRegistry");
                    }
                }
            }
            catch (Exception e) {
                tipiServizi = new Vector();
                tipiServizi.add("LDAP");
                tipiServizi.add("SPC");
                tipiServizi.add("TEST");
                tipiServizi.add("UDDI");
                tipiServizi.add("URL");
                tipiServizi.add("WSDL");
                tipiServizi.add("ebXMLRegistry");
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.egov.servizi.tipi' non impostata, viene utilizzato il default=LDAP,SPC,TEST,UDDI,URL,WSDL,ebXMLRegistry, errore:" + e.getMessage()));
            }
            tipiServiziRead = true;
        }
        return tipiServizi;
    }

    public boolean isIgnoraEccezioniNonGravi() {
        if (isSPCoopErrore_EccezioniNonGravi == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.egov.spcoopErrore.ignoraNonGravi.enable");
                if (value != null) {
                    value = value.trim();
                    isSPCoopErrore_EccezioniNonGravi = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.egov.spcoopErrore.ignoraNonGravi.enable' non impostata, viene utilizzato il default=false");
                    isSPCoopErrore_EccezioniNonGravi = false;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.egov.spcoopErrore.ignoraNonGravi.enable' non impostata, viene utilizzato il default=false, errore:" + e.getMessage()));
                isSPCoopErrore_EccezioniNonGravi = false;
            }
        }
        return isSPCoopErrore_EccezioniNonGravi;
    }

    public boolean ignoraEccezioniNonGravi_ValidazioneSPCoop() {
        if (ignoraEccezioniNonGravi_ValidazioneSPCoop == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.egov.spcoop.validazione.ignoraEccezioniNonGravi");
                if (value != null) {
                    value = value.trim();
                    ignoraEccezioniNonGravi_ValidazioneSPCoop = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.egov.spcoop.validazione.ignoraEccezioniNonGravi' non impostata, viene utilizzato il default=false");
                    ignoraEccezioniNonGravi_ValidazioneSPCoop = false;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.egov.spcoop.validazione.ignoraEccezioniNonGravi' non impostata, viene utilizzato il default=false, errore:" + e.getMessage()));
                ignoraEccezioniNonGravi_ValidazioneSPCoop = false;
            }
        }
        return ignoraEccezioniNonGravi_ValidazioneSPCoop;
    }

    public boolean isGenerazioneListaTrasmissioni(String implementazionePdDSoggetto) {
        String tipo;
        if (this.pddReader != null && (tipo = this.pddReader.getBustaEGov_TrasmissioneEnable(implementazionePdDSoggetto)) != null && ("true".equalsIgnoreCase(tipo) || "false".equalsIgnoreCase(tipo))) {
            if ("true".equalsIgnoreCase(tipo)) {
                return true;
            }
            if ("false".equalsIgnoreCase(tipo)) {
                return false;
            }
        }
        if (isGenerazioneListaTrasmissioni == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.egov.trasmissione.enable");
                if (value != null) {
                    value = value.trim();
                    isGenerazioneListaTrasmissioni = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.egov.trasmissione.enable' non impostata, viene utilizzato il default=true");
                    isGenerazioneListaTrasmissioni = true;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.egov.trasmissione.enable' non impostata, viene utilizzato il default=true, errore:" + e.getMessage()));
                isGenerazioneListaTrasmissioni = true;
            }
        }
        return isGenerazioneListaTrasmissioni;
    }

    public boolean isGenerazioneSPCoopErroreFiltroDuplicati(String implementazionePdDSoggetto) {
        String tipo;
        if (this.pddReader != null && (tipo = this.pddReader.getBustaEGov_FiltroduplicatiGenerazioneSPCoopErrore(implementazionePdDSoggetto)) != null && ("true".equalsIgnoreCase(tipo) || "false".equalsIgnoreCase(tipo))) {
            if ("true".equalsIgnoreCase(tipo)) {
                return true;
            }
            if ("false".equalsIgnoreCase(tipo)) {
                return false;
            }
        }
        if (isGenerazioneSPCoopErroreFiltroDuplicati == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.egov.filtroduplicati.generazioneSPCoopErrore");
                if (value != null) {
                    value = value.trim();
                    isGenerazioneSPCoopErroreFiltroDuplicati = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.egov.filtroduplicati.generazioneSPCoopErrore' non impostata, viene utilizzato il default=false");
                    isGenerazioneSPCoopErroreFiltroDuplicati = false;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.egov.filtroduplicati.generazioneSPCoopErrore' non impostata, viene utilizzato il default=false, errore:" + e.getMessage()));
                isGenerazioneSPCoopErroreFiltroDuplicati = false;
            }
        }
        return isGenerazioneSPCoopErroreFiltroDuplicati;
    }

    public boolean isCheckFromRegistroFiltroDuplicatiAbilitato(String implementazionePdDSoggetto) {
        String tipo;
        if (this.pddReader != null && (tipo = this.pddReader.getValidazioneEGov_FiltroDuplicatiLetturaRegistro(implementazionePdDSoggetto)) != null && ("true".equalsIgnoreCase(tipo) || "false".equalsIgnoreCase(tipo))) {
            if ("true".equalsIgnoreCase(tipo)) {
                return true;
            }
            if ("false".equalsIgnoreCase(tipo)) {
                return false;
            }
        }
        if (isCheckFromRegistroFiltroDuplicatiAbilitato == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.egov.filtroDuplicati.letturaRegistro");
                if (value != null) {
                    value = value.trim();
                    isCheckFromRegistroFiltroDuplicatiAbilitato = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.egov.filtroDuplicati.letturaRegistro' non impostata, viene utilizzato il default=true");
                    isCheckFromRegistroFiltroDuplicatiAbilitato = true;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.egov.filtroDuplicati.letturaRegistro' non impostata, viene utilizzato il default=true, errore:" + e.getMessage()));
                isCheckFromRegistroFiltroDuplicatiAbilitato = true;
            }
        }
        return isCheckFromRegistroFiltroDuplicatiAbilitato;
    }

    public boolean isCheckFromRegistroConfermaRicezioneAbilitato(String implementazionePdDSoggetto) {
        String tipo;
        if (this.pddReader != null && (tipo = this.pddReader.getValidazioneEGov_ConfermaRicezioneLetturaRegistro(implementazionePdDSoggetto)) != null && ("true".equalsIgnoreCase(tipo) || "false".equalsIgnoreCase(tipo))) {
            if ("true".equalsIgnoreCase(tipo)) {
                return true;
            }
            if ("false".equalsIgnoreCase(tipo)) {
                return false;
            }
        }
        if (isCheckFromRegistroConfermaRicezioneAbilitato == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.egov.confermaRicezione.letturaRegistro");
                if (value != null) {
                    value = value.trim();
                    isCheckFromRegistroConfermaRicezioneAbilitato = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.egov.confermaRicezione.letturaRegistro' non impostata, viene utilizzato il default=true");
                    isCheckFromRegistroConfermaRicezioneAbilitato = true;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.egov.confermaRicezione.letturaRegistro' non impostata, viene utilizzato il default=true, errore:" + e.getMessage()));
                isCheckFromRegistroConfermaRicezioneAbilitato = true;
            }
        }
        return isCheckFromRegistroConfermaRicezioneAbilitato;
    }

    public boolean isCheckFromRegistroConsegnaInOrdineAbilitato(String implementazionePdDSoggetto) {
        String tipo;
        if (this.pddReader != null && (tipo = this.pddReader.getValidazioneEGov_ConsegnaInOrdineLetturaRegistro(implementazionePdDSoggetto)) != null && ("true".equalsIgnoreCase(tipo) || "false".equalsIgnoreCase(tipo))) {
            if ("true".equalsIgnoreCase(tipo)) {
                return true;
            }
            if ("false".equalsIgnoreCase(tipo)) {
                return false;
            }
        }
        if (isCheckFromRegistroConsegnaInOrdineAbilitato == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.egov.consegnaInOrdine.letturaRegistro");
                if (value != null) {
                    value = value.trim();
                    isCheckFromRegistroConsegnaInOrdineAbilitato = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.egov.consegnaInOrdine.letturaRegistro' non impostata, viene utilizzato il default=true");
                    isCheckFromRegistroConsegnaInOrdineAbilitato = true;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.egov.consegnaInOrdine.letturaRegistro' non impostata, viene utilizzato il default=true, errore:" + e.getMessage()));
                isCheckFromRegistroConsegnaInOrdineAbilitato = true;
            }
        }
        return isCheckFromRegistroConsegnaInOrdineAbilitato;
    }

    public boolean isGestioneElementoCollaborazione(String implementazionePdDSoggetto) {
        String tipo;
        if (this.pddReader != null && (tipo = this.pddReader.getBustaEGov_CollaborazioneEnable(implementazionePdDSoggetto)) != null && ("true".equalsIgnoreCase(tipo) || "false".equalsIgnoreCase(tipo))) {
            return "true".equalsIgnoreCase(tipo);
        }
        if (isGestioneElementoCollaborazione == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.egov.collaborazione.enable");
                if (value != null) {
                    value = value.trim();
                    isGestioneElementoCollaborazione = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.egov.collaborazione.enable' non impostata, viene utilizzato il default=true");
                    isGestioneElementoCollaborazione = true;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.egov.collaborazione.enable' non impostata, viene utilizzato il default=true, errore:" + e.getMessage()));
                isGestioneElementoCollaborazione = true;
            }
        }
        return isGestioneElementoCollaborazione;
    }

    public boolean isGestioneConsegnaInOrdine(String implementazionePdDSoggetto) {
        String tipo;
        if (this.pddReader != null && (tipo = this.pddReader.getBustaEGov_ConsegnaInOrdineEnable(implementazionePdDSoggetto)) != null && ("true".equalsIgnoreCase(tipo) || "false".equalsIgnoreCase(tipo))) {
            return "true".equalsIgnoreCase(tipo);
        }
        if (isGestioneConsegnaInOrdine == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.egov.consegnaInOrdine.enable");
                if (value != null) {
                    value = value.trim();
                    isGestioneConsegnaInOrdine = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.egov.consegnaInOrdine.enable' non impostata, viene utilizzato il default=true");
                    isGestioneConsegnaInOrdine = true;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.egov.consegnaInOrdine.enable' non impostata, viene utilizzato il default=true, errore:" + e.getMessage()));
                isGestioneConsegnaInOrdine = true;
            }
        }
        return isGestioneConsegnaInOrdine;
    }

    public boolean isGestioneRiscontri(String implementazionePdDSoggetto) {
        String tipo;
        if (this.pddReader != null && (tipo = this.pddReader.getBustaEGov_RiscontriEnable(implementazionePdDSoggetto)) != null && ("true".equalsIgnoreCase(tipo) || "false".equalsIgnoreCase(tipo))) {
            if ("true".equalsIgnoreCase(tipo)) {
                return true;
            }
            if ("false".equalsIgnoreCase(tipo)) {
                return false;
            }
        }
        if (isGestioneRiscontri == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.egov.riscontri.enable");
                if (value != null) {
                    value = value.trim();
                    isGestioneRiscontri = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.egov.riscontri.enable' non impostata, viene utilizzato il default=true");
                    isGestioneRiscontri = true;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.egov.riscontri.enable' non impostata, viene utilizzato il default=true, errore:" + e.getMessage()));
                isGestioneRiscontri = true;
            }
        }
        return isGestioneRiscontri;
    }

    public boolean isGenerazioneSPCoopErrore_strutturaMalformataHeaderEGov() {
        if (isGenerazioneSPCoopErrore_strutturaMalformataHeaderEGov == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.egov.strutturaHeaderNonCorretta.generazioneRispostaSPCoop");
                if (value != null) {
                    value = value.trim();
                    isGenerazioneSPCoopErrore_strutturaMalformataHeaderEGov = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.egov.strutturaHeaderNonCorretta.generazioneRispostaSPCoop' non impostata, viene utilizzato il default=false");
                    isGenerazioneSPCoopErrore_strutturaMalformataHeaderEGov = false;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.egov.strutturaHeaderNonCorretta.generazioneRispostaSPCoop' non impostata, viene utilizzato il default=false, errore:" + e.getMessage()));
                isGenerazioneSPCoopErrore_strutturaMalformataHeaderEGov = false;
            }
        }
        return isGenerazioneSPCoopErrore_strutturaMalformataHeaderEGov;
    }

    public String getRoleRichiestaManifest(String implementazionePdDSoggetto) {
        String valore;
        if (this.pddReader != null && (valore = this.pddReader.getBustaEGov_ManifestAttachments_roleRichiesta(implementazionePdDSoggetto)) != null) {
            return valore;
        }
        if (roleRichiestaManifest == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.egov.manifestAttachments.role.richiesta");
                if (value != null) {
                    roleRichiestaManifest = value = value.trim();
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.egov.manifestAttachments.role.richiesta' non impostata, viene utilizzato il default=Richiesta");
                    roleRichiestaManifest = "Richiesta";
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.egov.manifestAttachments.role.richiesta' non impostata, viene utilizzato il default=Richiesta, errore:" + e.getMessage()));
                roleRichiestaManifest = "Richiesta";
            }
        }
        return roleRichiestaManifest;
    }

    public String getRoleRispostaManifest(String implementazionePdDSoggetto) {
        String valore;
        if (this.pddReader != null && (valore = this.pddReader.getBustaEGov_ManifestAttachments_roleRisposta(implementazionePdDSoggetto)) != null) {
            return valore;
        }
        if (roleRispostaManifest == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.egov.manifestAttachments.role.risposta");
                if (value != null) {
                    roleRispostaManifest = value = value.trim();
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.egov.manifestAttachments.role.risposta' non impostata, viene utilizzato il default=Risposta");
                    roleRispostaManifest = "Risposta";
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.egov.manifestAttachments.role.risposta' non impostata, viene utilizzato il default=Risposta, errore:" + e.getMessage()));
                roleRispostaManifest = "Risposta";
            }
        }
        return roleRispostaManifest;
    }

    public String getRoleAllegatoManifest(String implementazionePdDSoggetto) {
        String valore;
        if (this.pddReader != null && (valore = this.pddReader.getBustaEGov_ManifestAttachments_roleAllegato(implementazionePdDSoggetto)) != null) {
            return valore;
        }
        if (roleAllegatoManifest == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.egov.manifestAttachments.role.allegato");
                if (value != null) {
                    roleAllegatoManifest = value = value.trim();
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.egov.manifestAttachments.role.richiesta' non impostata, viene utilizzato il default=Allegato");
                    roleAllegatoManifest = "Allegato";
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.egov.manifestAttachments.role.richiesta' non impostata, viene utilizzato il default=Allegato, errore:" + e.getMessage()));
                roleAllegatoManifest = "Allegato";
            }
        }
        return roleAllegatoManifest;
    }

    public boolean isReadQualifiedAttribute(String implementazionePdDSoggetto) {
        String tipo;
        if (this.pddReader != null && (tipo = this.pddReader.getValidazioneEGov_readQualifiedAttribute(implementazionePdDSoggetto)) != null && ("true".equalsIgnoreCase(tipo) || "false".equalsIgnoreCase(tipo))) {
            if ("true".equalsIgnoreCase(tipo)) {
                return true;
            }
            if ("false".equalsIgnoreCase(tipo)) {
                return false;
            }
        }
        if (isReadQualifiedAttribute == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.egov.validazione.readQualifiedAttribute");
                if (value != null) {
                    value = value.trim();
                    isReadQualifiedAttribute = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.egov.validazione.readQualifiedAttribute' non impostata, viene utilizzato il default=false");
                    isReadQualifiedAttribute = false;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.egov.validazione.readQualifiedAttribute' non impostata, viene utilizzato il default=false, errore:" + e.getMessage()));
                isReadQualifiedAttribute = false;
            }
        }
        return isReadQualifiedAttribute;
    }

    public ProprietaManifestAttachments getProprietaManifestAttachments(String implementazionePdDSoggetto) {
        ProprietaManifestAttachments properties = new ProprietaManifestAttachments();
        properties.setRoleRichiesta(this.getRoleRichiestaManifest(implementazionePdDSoggetto));
        properties.setRoleRisposta(this.getRoleRispostaManifest(implementazionePdDSoggetto));
        properties.setRoleAllegato(this.getRoleAllegatoManifest(implementazionePdDSoggetto));
        properties.setReadQualifiedAttribute(this.isReadQualifiedAttribute(implementazionePdDSoggetto));
        return properties;
    }

    public String getLocationPddProperties() {
        if (!filePddPropertiesLetto) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.egov.pddProperties");
                if (name != null) {
                    filePddProperties = name = name.trim();
                }
                filePddPropertiesLetto = true;
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.egov.pddProperties': " + e.getMessage()));
                filePddProperties = null;
            }
        }
        return filePddProperties;
    }

    public String[] getTipoIntegrazionePD() {
        if (!tipoIntegrazionePDRead) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.integrazione.tipo.pd");
                if (value == null) {
                    throw new Exception("non definita");
                }
                value = value.trim();
                String[] r = value.split(",");
                tipoIntegrazionePD = r;
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.integrazione.tipo.pd': " + e.getMessage()));
                tipoIntegrazionePD = null;
            }
            tipoIntegrazionePDRead = true;
        }
        return tipoIntegrazionePD;
    }

    public String[] getTipoIntegrazionePA() {
        if (!tipoIntegrazionePARead) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.integrazione.tipo.pa");
                if (value == null) {
                    throw new Exception("non definita");
                }
                value = value.trim();
                String[] r = value.split(",");
                tipoIntegrazionePA = r;
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura dei tipi di integrazione tra porta di dominio e servizio applicativo 'org.openspcoop.pdd.integrazione.tipo.pa': " + e.getMessage()));
                tipoIntegrazionePA = null;
            }
            tipoIntegrazionePARead = true;
        }
        return tipoIntegrazionePA;
    }

    public Properties getKeyValue_HeaderIntegrazione() {
        if (keyValue_HeaderIntegrazione == null) {
            Properties prop = new Properties();
            try {
                keyValue_HeaderIntegrazione = prop = this.reader.readProperties_convertEnvProperties("org.openspcoop.pdd.integrazione.keyword.");
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura delle propriete' 'org.openspcoop.pdd.integrazione.keyword.*': " + e.getMessage()));
                keyValue_HeaderIntegrazione = null;
            }
        }
        return keyValue_HeaderIntegrazione;
    }

    public boolean deleteHeaderIntegrazionePD() {
        if (deleteHeaderIntegrazionePD == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.integrazione.pd.readAndDelete");
                if (value != null) {
                    value = value.trim();
                    deleteHeaderIntegrazionePD = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.integrazione.pd.readAndDelete' non impostata, viene utilizzato il default=true");
                    deleteHeaderIntegrazionePD = true;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.integrazione.pd.readAndDelete' non impostata, viene utilizzato il default=true, errore:" + e.getMessage()));
                deleteHeaderIntegrazionePD = true;
            }
        }
        return deleteHeaderIntegrazionePD;
    }

    public boolean processHeaderIntegrazionePA() {
        if (processHeaderIntegrazionePA == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.integrazione.pa.process");
                if (value != null) {
                    value = value.trim();
                    processHeaderIntegrazionePA = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.integrazione.pa.process' non impostata, viene utilizzato il default=false");
                    processHeaderIntegrazionePA = false;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.integrazione.pa.process' non impostata, viene utilizzato il default=false, errore:" + e.getMessage()));
                processHeaderIntegrazionePA = false;
            }
        }
        return processHeaderIntegrazionePA;
    }

    public boolean deleteHeaderIntegrazionePA(boolean functionAsRouter) {
        if (functionAsRouter) {
            return false;
        }
        return !this.processHeaderIntegrazionePA();
    }

    public String getHeaderSoapNameIntegrazione() {
        if (headerSoapNameIntegrazione == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.integrazione.soap.headerName");
                if (name == null) {
                    throw new Exception("non definita");
                }
                headerSoapNameIntegrazione = name = name.trim();
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.integrazione.soap.headerName': " + e.getMessage()));
                headerSoapNameIntegrazione = null;
            }
        }
        return headerSoapNameIntegrazione;
    }

    public String getHeaderSoapActorIntegrazione() {
        if (headerSoapActorIntegrazione == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.integrazione.soap.headerActor");
                if (name == null) {
                    throw new Exception("non definita");
                }
                headerSoapActorIntegrazione = name = name.trim();
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.integrazione.soap.headerActor': " + e.getMessage()));
                headerSoapActorIntegrazione = null;
            }
        }
        return headerSoapActorIntegrazione;
    }

    public String getHeaderSoapPrefixIntegrazione() {
        if (headerSoapPrefixIntegrazione == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.integrazione.soap.headerPrefix");
                if (name == null) {
                    throw new Exception("non definita");
                }
                headerSoapPrefixIntegrazione = name = name.trim();
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.integrazione.soap.headerPrefix': " + e.getMessage()));
                headerSoapPrefixIntegrazione = null;
            }
        }
        return headerSoapPrefixIntegrazione;
    }

    public boolean isRitardoConsegnaAbilitato() throws Exception {
        if (isRitardoConsegnaAbilitato == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.connettore.ritardo.stato");
                if (name == null) {
                    throw new Exception("non definita");
                }
                name = name.trim();
                isRitardoConsegnaAbilitato = "abilitato".equals(name);
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.connettore.ritardo.stato': " + e.getMessage()));
                throw new Exception(e);
            }
        }
        return isRitardoConsegnaAbilitato;
    }

    public long getRitardoConsegnaEsponenziale() {
        if (ritardoConsegnaEsponenziale == null) {
            try {
                long r = -1L;
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.connettore.ritardo.fattore");
                if (name != null) {
                    name = name.trim();
                    r = Long.parseLong(name);
                }
                if (r < 0L) {
                    throw new Exception("Il ritardo deve essere > 0");
                }
                ritardoConsegnaEsponenziale = r;
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.connettore.ritardo.fattore': " + e.getMessage()));
                ritardoConsegnaEsponenziale = -1L;
            }
        }
        return ritardoConsegnaEsponenziale;
    }

    public boolean isRitardoConsegnaEsponenzialeConMoltiplicazione() throws Exception {
        block6: {
            if (isRitardoConsegnaEsponenzialeConMoltiplicazione == null) {
                try {
                    String name = null;
                    name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.connettore.ritardo.operazione");
                    if (name != null) {
                        if ((name = name.trim()).equals("+")) {
                            isRitardoConsegnaEsponenzialeConMoltiplicazione = false;
                            break block6;
                        }
                        if (name.equals("*")) {
                            isRitardoConsegnaEsponenzialeConMoltiplicazione = true;
                            break block6;
                        }
                        throw new Exception("Tipo di operazione non conosciuta: " + name);
                    }
                    throw new Exception("Tipo di operazione non definita");
                }
                catch (Exception e) {
                    this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.connettore.ritardo.operazione': " + e.getMessage()));
                    throw new Exception(e);
                }
            }
        }
        return isRitardoConsegnaEsponenzialeConMoltiplicazione;
    }

    public long getRitardoConsegnaEsponenzialeLimite() {
        if (ritardoConsegnaEsponenzialeLimite == null) {
            try {
                long r = 0L;
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.connettore.ritardo.limite");
                if (name != null) {
                    name = name.trim();
                    r = Long.parseLong(name);
                }
                if (r <= 0L) {
                    throw new Exception("Il limite deve essere > 0");
                }
                ritardoConsegnaEsponenzialeLimite = r;
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.connettore.ritardo.limite': " + e.getMessage()));
                ritardoConsegnaEsponenzialeLimite = -1L;
            }
        }
        return ritardoConsegnaEsponenzialeLimite;
    }

    public boolean isAbilitataCacheGestoreMessaggi() {
        if (isAbilitataCacheGestoreMessaggi_value == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.repository.gestoreMessaggi.cache.enable");
                if (value != null) {
                    value = value.trim();
                    isAbilitataCacheGestoreMessaggi_value = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.repository.gestoreMessaggi.cache.enable' non impostata, viene utilizzato il default=false");
                    isAbilitataCacheGestoreMessaggi_value = false;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.repository.gestoreMessaggi.cache.enable' non impostata, viene utilizzato il default=false, errore:" + e.getMessage()));
                isAbilitataCacheGestoreMessaggi_value = false;
            }
        }
        return isAbilitataCacheGestoreMessaggi_value;
    }

    public int getDimensioneCacheGestoreMessaggi() throws OpenSPCoopConfigurationException {
        if (dimensioneCacheGestoreMessaggi_value == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.repository.gestoreMessaggi.cache.dimensione");
                if (value != null) {
                    value = value.trim();
                    dimensioneCacheGestoreMessaggi_value = Integer.parseInt(value);
                } else {
                    dimensioneCacheGestoreMessaggi_value = -1;
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.repository.gestoreMessaggi.cache.dimensione': " + e.getMessage()));
                throw new OpenSPCoopConfigurationException("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.repository.gestoreMessaggi.cache.dimensione'", e);
            }
        }
        return dimensioneCacheGestoreMessaggi_value;
    }

    public String getAlgoritmoCacheGestoreMessaggi() throws OpenSPCoopConfigurationException {
        if (algoritmoCacheGestoreMessaggi_value == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.repository.gestoreMessaggi.cache.algoritmo");
                algoritmoCacheGestoreMessaggi_value = value != null ? (value = value.trim()) : null;
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.repository.gestoreMessaggi.cache.algoritmo': " + e.getMessage()));
                throw new OpenSPCoopConfigurationException("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.repository.gestoreMessaggi.cache.algoritmo'", e);
            }
        }
        return algoritmoCacheGestoreMessaggi_value;
    }

    public int getItemIdleTimeCacheGestoreMessaggi() throws OpenSPCoopConfigurationException {
        if (itemIdleTimeCacheGestoreMessaggi_value == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.repository.gestoreMessaggi.cache.itemIdleTime");
                if (value != null) {
                    value = value.trim();
                    itemIdleTimeCacheGestoreMessaggi_value = Integer.parseInt(value);
                } else {
                    itemIdleTimeCacheGestoreMessaggi_value = -1;
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.repository.gestoreMessaggi.cache.itemIdleTime': " + e.getMessage()));
                throw new OpenSPCoopConfigurationException("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.repository.gestoreMessaggi.cache.itemIdleTime'", e);
            }
        }
        return itemIdleTimeCacheGestoreMessaggi_value;
    }

    public int getItemLifeSecondCacheGestoreMessaggi() throws OpenSPCoopConfigurationException {
        if (itemLifeSecondCacheGestoreMessaggi_value == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.repository.gestoreMessaggi.cache.itemLifeSecond");
                if (value != null) {
                    value = value.trim();
                    itemLifeSecondCacheGestoreMessaggi_value = Integer.parseInt(value);
                } else {
                    itemLifeSecondCacheGestoreMessaggi_value = -1;
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.repository.gestoreMessaggi.cache.itemLifeSecond': " + e.getMessage()));
                throw new OpenSPCoopConfigurationException("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.repository.gestoreMessaggi.cache.itemLifeSecond'", e);
            }
        }
        return itemLifeSecondCacheGestoreMessaggi_value;
    }

    public boolean isRisorseJMXAbilitate() {
        if (isRisorseJMXAbilitate == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.core.jmx.enable");
                if (value != null) {
                    value = value.trim();
                    isRisorseJMXAbilitate = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.core.jmx.enable' non impostata, viene utilizzato il default=false");
                    isRisorseJMXAbilitate = false;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.core.jmx.enable' non impostata, viene utilizzato il default=false, errore:" + e.getMessage()));
                isRisorseJMXAbilitate = false;
            }
        }
        return isRisorseJMXAbilitate;
    }

    public String getJNDIName_MBeanServer() {
        if (jndiNameMBeanServer == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.core.jmx.jndi.mbeanServer");
                if (name != null) {
                    name = name.trim();
                }
                jndiNameMBeanServer = name;
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.core.jmx.jndi.mbeanServer': " + e.getMessage()));
                jndiNameMBeanServer = null;
            }
        }
        return jndiNameMBeanServer;
    }

    public Properties getJNDIContext_MBeanServer() {
        if (jndiContextMBeanServer == null) {
            Properties prop = new Properties();
            try {
                jndiContextMBeanServer = prop = this.reader.readProperties_convertEnvProperties("org.openspcoop.pdd.core.jmx.jndi.property.");
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura delle propriete' JNDI 'org.openspcoop.pdd.core.jmx.jndi.property.*': " + e.getMessage()));
                jndiContextMBeanServer = null;
            }
        }
        return jndiContextMBeanServer;
    }

    public String getContextRisorseJMX() throws OpenSPCoopConfigurationException {
        if (contextRisorseJMX_value == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.core.jmx.context");
                contextRisorseJMX_value = value != null ? (value = value.trim()) : null;
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.core.jmx.context': " + e.getMessage()));
                throw new OpenSPCoopConfigurationException("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.core.jmx.context'", e);
            }
        }
        return contextRisorseJMX_value;
    }

    public int getConnectionTimeout_inoltroBusteEGov() {
        if (connectionTimeout_inoltroBusteEGov == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.connettori.inoltroBusteEGov.connection.timeout");
                if (name != null) {
                    name = name.trim();
                    connectionTimeout_inoltroBusteEGov = Integer.parseInt(name);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.connettori.inoltroBusteEGov.connection.timeout' non impostata, viene utilizzato il default=10000");
                    connectionTimeout_inoltroBusteEGov = 10000;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.connettori.inoltroBusteEGov.connection.timeout' non impostata, viene utilizzato il default=10000, errore:" + e.getMessage()));
                connectionTimeout_inoltroBusteEGov = 10000;
            }
        }
        return connectionTimeout_inoltroBusteEGov;
    }

    public int getConnectionTimeout_consegnaContenutiApplicativi() {
        if (connectionTimeout_consegnaContenutiApplicativi == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.connettori.consegnaContenutiApplicativi.connection.timeout");
                if (name != null) {
                    name = name.trim();
                    connectionTimeout_consegnaContenutiApplicativi = Integer.parseInt(name);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.connettori.consegnaContenutiApplicativi.connection.timeout' non impostata, viene utilizzato il default=10000");
                    connectionTimeout_consegnaContenutiApplicativi = 10000;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.connettori.consegnaContenutiApplicativi.connection.timeout' non impostata, viene utilizzato il default=10000, errore:" + e.getMessage()));
                connectionTimeout_consegnaContenutiApplicativi = 10000;
            }
        }
        return connectionTimeout_consegnaContenutiApplicativi;
    }

    public int getReadConnectionTimeout_inoltroBusteEGov() {
        if (readConnectionTimeout_inoltroBusteEGov == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.connettori.inoltroBusteEGov.readConnection.timeout");
                if (name != null) {
                    name = name.trim();
                    readConnectionTimeout_inoltroBusteEGov = Integer.parseInt(name);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.connettori.inoltroBusteEGov.readConnection.timeout' non impostata, viene utilizzato il default=180000");
                    readConnectionTimeout_inoltroBusteEGov = 180000;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.connettori.inoltroBusteEGov.readConnection.timeout' non impostata, viene utilizzato il default=180000, errore:" + e.getMessage()));
                readConnectionTimeout_inoltroBusteEGov = 180000;
            }
        }
        return readConnectionTimeout_inoltroBusteEGov;
    }

    public int getReadConnectionTimeout_consegnaContenutiApplicativi() {
        if (readConnectionTimeout_consegnaContenutiApplicativi == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.connettori.consegnaContenutiApplicativi.readConnection.timeout");
                if (name != null) {
                    name = name.trim();
                    readConnectionTimeout_consegnaContenutiApplicativi = Integer.parseInt(name);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.connettori.consegnaContenutiApplicativi.readConnection.timeout' non impostata, viene utilizzato il default=120000");
                    readConnectionTimeout_consegnaContenutiApplicativi = 120000;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.connettori.consegnaContenutiApplicativi.readConnection.timeout' non impostata, viene utilizzato il default=120000, errore:" + e.getMessage()));
                readConnectionTimeout_consegnaContenutiApplicativi = 120000;
            }
        }
        return readConnectionTimeout_consegnaContenutiApplicativi;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getTipoTempoEGov(String implementazionePdDSoggetto) {
        String tipo;
        if (this.pddReader != null && (tipo = this.pddReader.getBustaEGov_TempoTipo(implementazionePdDSoggetto)) != null && ("locale".equalsIgnoreCase(tipo) || "spc".equalsIgnoreCase(tipo))) {
            if (!"locale".equalsIgnoreCase(tipo)) return "EGOV_IT_SPC";
            return "EGOV_IT_Locale";
        }
        if (tipoTempoEGov != null) return tipoTempoEGov;
        try {
            String name = null;
            name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.tempo.tipo");
            if (name != null) {
                if ("locale".equals(name = name.trim())) {
                    tipoTempoEGov = "EGOV_IT_Locale";
                    return tipoTempoEGov;
                } else {
                    if (!"spc".equals(name)) throw new Exception("Tipo " + name + " non conosciuto");
                    tipoTempoEGov = "EGOV_IT_SPC";
                }
                return tipoTempoEGov;
            } else {
                this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.tempo.tipo' non impostata, viene utilizzato il default=locale");
                tipoTempoEGov = "EGOV_IT_Locale";
            }
            return tipoTempoEGov;
        }
        catch (Exception e) {
            this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.tempo.tipo' non impostata, viene utilizzato il default=locale, errore:" + e.getMessage()));
            tipoTempoEGov = "EGOV_IT_Locale";
        }
        return tipoTempoEGov;
    }

    public String getTipoDateManager() {
        if (tipoDateManager == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.date.tipo");
                if (name == null) {
                    throw new Exception("non definita");
                }
                name = name.trim();
                tipoDateManager = name;
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.date.tipo': " + e.getMessage()));
                tipoDateManager = null;
            }
        }
        return tipoDateManager;
    }

    public Properties getDateManagerProperties() {
        if (dateManagerProperties == null) {
            Properties prop = new Properties();
            try {
                dateManagerProperties = prop = this.reader.readProperties_convertEnvProperties("org.openspcoop.pdd.date.property.");
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura delle propriete' 'org.openspcoop.pdd.date.property.*': " + e.getMessage()));
                dateManagerProperties = null;
            }
        }
        return dateManagerProperties;
    }

    public boolean integrationManager_isNomePortaDelegataUrlBased() {
        if (integrationManager_isNomePortaDelegataUrlBasedValue == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.service.IntegrationManager.nomePortaDelegataUrlBased");
                if (value != null) {
                    value = value.trim();
                    integrationManager_isNomePortaDelegataUrlBasedValue = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.service.IntegrationManager.nomePortaDelegataUrlBased' non impostata, viene utilizzato il default=false");
                    integrationManager_isNomePortaDelegataUrlBasedValue = false;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.service.IntegrationManager.nomePortaDelegataUrlBased' non impostata, viene utilizzato il default=false, errore:" + e.getMessage()));
                integrationManager_isNomePortaDelegataUrlBasedValue = false;
            }
        }
        return integrationManager_isNomePortaDelegataUrlBasedValue;
    }

    public boolean integrationManager_readInformazioniTrasporto() {
        if (integrationManager_readInformazioniTrasportoValue == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.service.IntegrationManager.infoTrasporto");
                if (value != null) {
                    value = value.trim();
                    integrationManager_readInformazioniTrasportoValue = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.service.IntegrationManager.infoTrasporto' non impostata, viene utilizzato il default=false");
                    integrationManager_readInformazioniTrasportoValue = false;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.service.IntegrationManager.infoTrasporto' non impostata, viene utilizzato il default=false, errore:" + e.getMessage()));
                integrationManager_readInformazioniTrasportoValue = false;
            }
        }
        return integrationManager_readInformazioniTrasportoValue;
    }

    public boolean isDeleteInstructionTargetMachineXml() {
        if (isDeleteInstructionTargetMachineXml == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.core.soap.deleteInstructionTargetMachineXml");
                if (value != null) {
                    value = value.trim();
                    isDeleteInstructionTargetMachineXml = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.core.soap.deleteInstructionTargetMachineXml' non impostata, viene utilizzato il default=false");
                    isDeleteInstructionTargetMachineXml = false;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.core.soap.deleteInstructionTargetMachineXml' non impostata, viene utilizzato il default=false, errore:" + e.getMessage()));
                isDeleteInstructionTargetMachineXml = false;
            }
        }
        return isDeleteInstructionTargetMachineXml;
    }

    public String getTunnelSOAPKeyWord() {
        if (tunnelSOAPKeyWord == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.core.soap.tunnelSOAP");
                if (name != null) {
                    tunnelSOAPKeyWord = name = name.trim();
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.core.soap.tunnelSOAP' non impostata, viene utilizzato il default=attach");
                    tunnelSOAPKeyWord = "attach";
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.core.soap.tunnelSOAP' non impostata, viene utilizzato il default=attach, errore:" + e.getMessage()));
                tunnelSOAPKeyWord = "attach";
            }
        }
        return tunnelSOAPKeyWord;
    }

    public String getTunnelSOAPKeyWordMimeType() {
        if (tunnelSOAPKeyWordMimeType == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.core.soap.tunnelSOAP.mimeType");
                if (name != null) {
                    tunnelSOAPKeyWordMimeType = name = name.trim();
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.core.soap.tunnelSOAP.mimeType' non impostata, viene utilizzato il default=mime-type");
                    tunnelSOAPKeyWordMimeType = "mime-type";
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.core.soap.tunnelSOAP.mimeType' non impostata, viene utilizzato il default=mime-type, errore:" + e.getMessage()));
                tunnelSOAPKeyWordMimeType = "mime-type";
            }
        }
        return tunnelSOAPKeyWordMimeType;
    }

    public long getTimeoutBustaRispostaAsincrona() {
        if (timeoutBustaRispostaAsincrona == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.repository.messaggioAsincronoInProcessamento.attesaAttiva");
                if (name != null) {
                    name = name.trim();
                    timeoutBustaRispostaAsincrona = Long.parseLong(name) * 1000L;
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.repository.messaggioAsincronoInProcessamento.attesaAttiva' non impostata, viene utilizzato il default=90");
                    timeoutBustaRispostaAsincrona = 90000L;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.repository.messaggioAsincronoInProcessamento.attesaAttiva' non impostata, viene utilizzato il default=90, errore:" + e.getMessage()));
                timeoutBustaRispostaAsincrona = 90000L;
            }
        }
        return timeoutBustaRispostaAsincrona;
    }

    public int getCheckIntervalBustaRispostaAsincrona() {
        if (checkIntervalBustaRispostaAsincrona == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.repository.messaggioAsincronoInProcessamento.check");
                if (name != null) {
                    name = name.trim();
                    checkIntervalBustaRispostaAsincrona = Integer.parseInt(name);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.repository.messaggioAsincronoInProcessamento.check' non impostata, viene utilizzato il default=500");
                    checkIntervalBustaRispostaAsincrona = 500;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.repository.messaggioAsincronoInProcessamento.check' non impostata, viene utilizzato il default=500, errore:" + e.getMessage()));
                checkIntervalBustaRispostaAsincrona = 500;
            }
        }
        return checkIntervalBustaRispostaAsincrona;
    }

    public String getClusterId() {
        if (cluster_id == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.cluster_id");
                if (name == null) {
                    throw new Exception("non definita");
                }
                cluster_id = name = name.trim();
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.cluster_id': " + e.getMessage()));
                cluster_id = null;
            }
        }
        return cluster_id;
    }

    public String getStatelessOneWay() {
        if (statelessOneWay == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.stateless.default.oneway");
                if (name != null) {
                    if (!"abilitato".equals(name = name.trim()) && !"disabilitato".equals(name)) {
                        throw new Exception("Valori ammessi sono abilitato/disabilito");
                    }
                } else {
                    throw new Exception("non definita");
                }
                statelessOneWay = name;
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.stateless.default.oneway': " + e.getMessage()));
                statelessOneWay = null;
            }
        }
        return statelessOneWay;
    }

    public String getStatelessSincrono() {
        if (statelessSincrono == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.stateless.default.sincrono");
                if (name != null) {
                    if (!"abilitato".equals(name = name.trim()) && !"disabilitato".equals(name)) {
                        throw new Exception("Valori ammessi sono abilitato/disabilito");
                    }
                } else {
                    throw new Exception("non definita");
                }
                statelessSincrono = name;
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.stateless.default.sincrono': " + e.getMessage()));
                statelessSincrono = null;
            }
        }
        return statelessSincrono;
    }

    public String getStatelessAsincrono() {
        if (statelessAsincrono == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.stateless.default.asincrono");
                if (name != null) {
                    if (!"abilitato".equals(name = name.trim()) && !"disabilitato".equals(name)) {
                        throw new Exception("Valori ammessi sono abilitato/disabilito");
                    }
                } else {
                    throw new Exception("non definita");
                }
                statelessAsincrono = name;
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.stateless.default.asincrono': " + e.getMessage()));
                statelessAsincrono = null;
            }
        }
        return statelessAsincrono;
    }

    public boolean isGestioneOnewayStateful_1_1() {
        if (isGestioneOnewayStateful_1_1 == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.stateful.oneway");
                if (value != null) {
                    if (!"1.0".equals(value = value.trim()) && !"1.1".equals(value)) {
                        throw new Exception("Valori ammessi sono 1.0/1.1");
                    }
                    isGestioneOnewayStateful_1_1 = "1.1".equals(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.stateful.oneway' non impostata, viene utilizzato il default=true");
                    isGestioneOnewayStateful_1_1 = true;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.stateful.oneway' non impostata, viene utilizzato il default=true, errore:" + e.getMessage()));
                isGestioneOnewayStateful_1_1 = true;
            }
        }
        return isGestioneOnewayStateful_1_1;
    }

    public String getStatelessRouting() {
        if (statelessRouting == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.stateless.router");
                if (name != null) {
                    if (!"abilitato".equals(name = name.trim()) && !"disabilitato".equals(name)) {
                        throw new Exception("Valori ammessi sono abilitato/disabilito");
                    }
                } else {
                    throw new Exception("non definita");
                }
                statelessRouting = name;
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.stateless.router': " + e.getMessage()));
                statelessRouting = null;
            }
        }
        return statelessRouting;
    }

    public String getNegoziamentoConnessioneDatasource() {
        if (statelessNegoziamentoConnessioneDatasource == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.stateless.datasource");
                if (name != null) {
                    if (!"abilitato".equals(name = name.trim()) && !"disabilitato".equals(name)) {
                        throw new Exception("Valori ammessi sono abilitato/disabilito");
                    }
                } else {
                    throw new Exception("non definita");
                }
                statelessNegoziamentoConnessioneDatasource = name;
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.stateless.datasource': " + e.getMessage()));
                statelessNegoziamentoConnessioneDatasource = null;
            }
        }
        return statelessNegoziamentoConnessioneDatasource;
    }

    public boolean isGestioneStateful_RinegoziamentoConnessione() {
        if (isGestioneStateful_RinegoziamentoConnessione == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.stateless.dataSource.rinegoziamentoConnessione");
                if (value != null) {
                    if (!"abilitato".equals(value = value.trim()) && !"disabilitato".equals(value)) {
                        throw new Exception("Valori ammessi sono abilitato/disabilitato");
                    }
                    isGestioneStateful_RinegoziamentoConnessione = "disabilitato".equals(value) ? Boolean.valueOf(false) : Boolean.valueOf(true);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.stateless.dataSource.rinegoziamentoConnessione' non impostata, viene utilizzato il default=true");
                    isGestioneStateful_RinegoziamentoConnessione = true;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.stateless.dataSource.rinegoziamentoConnessione' non impostata, viene utilizzato il default=true, errore:" + e.getMessage()));
                isGestioneStateful_RinegoziamentoConnessione = true;
            }
        }
        return isGestioneStateful_RinegoziamentoConnessione;
    }

    public int getConnectionNumberPoolStateless() {
        block5: {
            if (connectionNumberPoolStateless == null) {
                try {
                    String name = null;
                    name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.stateless.connectionPool.dimensione");
                    if (name != null) {
                        connectionNumberPoolStateless = Integer.parseInt(name = name.trim());
                        if (connectionNumberPoolStateless <= 0) {
                            throw new Exception("valore presente non valido [" + connectionNumberPoolStateless + "], deve essere maggiore di zero");
                        }
                        break block5;
                    }
                    throw new Exception("non presente");
                }
                catch (Exception e) {
                    this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop.pdd.stateless.connectionPool.dimensione': " + e.getMessage()));
                    connectionNumberPoolStateless = null;
                    return -1;
                }
            }
        }
        return connectionNumberPoolStateless;
    }

    public String getValidationConnectionPoolStateless() {
        if (!read_validationConnectionPoolStateless) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.stateless.connectionPool.validazione");
                if (name != null) {
                    validationConnectionPoolStateless = name.trim();
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.stateless.connectionPool.validazione' non impostata, non verra effettuata la validazione");
                    validationConnectionPoolStateless = null;
                    read_validationConnectionPoolStateless = true;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.stateless.connectionPool.validazione' non impostata, non verra effettuata la validazione, errore:" + e.getMessage()));
                validationConnectionPoolStateless = null;
                read_validationConnectionPoolStateless = true;
            }
        }
        return validationConnectionPoolStateless;
    }

    public String[] getTipiMisurazioneTempiAttraversamentoPdD() {
        if (!tipiMisurazioneTempiAttraversamentoPdDRead) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.integrazione.misurazioneTempi");
                if (value != null) {
                    value = value.trim();
                    String[] r = value.split(",");
                    tipiMisurazioneTempiAttraversamentoPdD = r;
                } else {
                    tipiMisurazioneTempiAttraversamentoPdD = null;
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura dei tipi di misurazione tempi attraversamento PdD 'org.openspcoop.pdd.integrazione.misurazioneTempi': " + e.getMessage()));
                tipiMisurazioneTempiAttraversamentoPdD = null;
            }
            tipiMisurazioneTempiAttraversamentoPdDRead = true;
        }
        return tipiMisurazioneTempiAttraversamentoPdD;
    }

    public boolean isGenerazioneActorDefault(String implementazionePdDSoggetto) {
        String tipo;
        if (this.pddReader != null && (tipo = this.pddReader.getWSSecurity_ActorDefaultEnable(implementazionePdDSoggetto)) != null && ("true".equalsIgnoreCase(tipo) || "false".equalsIgnoreCase(tipo))) {
            if ("true".equalsIgnoreCase(tipo)) {
                return true;
            }
            if ("false".equalsIgnoreCase(tipo)) {
                return false;
            }
        }
        if (isGenerazioneActorDefault == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.wssecurity.actorDefault.enable");
                if (value != null) {
                    value = value.trim();
                    isGenerazioneActorDefault = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.wssecurity.actorDefault.enable' non impostata, viene utilizzato il default=true");
                    isGenerazioneActorDefault = true;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.wssecurity.actorDefault.enable' non impostata, viene utilizzato il default=true, errore:" + e.getMessage()));
                isGenerazioneActorDefault = true;
            }
        }
        return isGenerazioneActorDefault;
    }

    public String getActorDefault(String implementazionePdDSoggetto) {
        String valore;
        if (this.pddReader != null && (valore = this.pddReader.getWSSecurity_ActorDefaultValue(implementazionePdDSoggetto)) != null) {
            return valore;
        }
        if (actorDefault == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.wssecurity.actorDefault.valore");
                if (value != null) {
                    actorDefault = value = value.trim();
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.pdd.wssecurity.actorDefault.valore' non impostata, viene utilizzato il default=openspcoop");
                    actorDefault = "openspcoop";
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.pdd.wssecurity.actorDefault.valore' non impostata, viene utilizzato il default=openspcoop, errore:" + e.getMessage()));
                actorDefault = "openspcoop";
            }
        }
        return actorDefault;
    }

    public boolean isReadObjectStatoBozza() {
        if (isReadObjectStatoBozza == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("org.openspcoop.registroServizi.readObjectStatoBozza");
                if (value != null) {
                    value = value.trim();
                    isReadObjectStatoBozza = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'org.openspcoop.registroServizi.readObjectStatoBozza' non impostata, viene utilizzato il default=false");
                    isReadObjectStatoBozza = false;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'org.openspcoop.registroServizi.readObjectStatoBozza' non impostata, viene utilizzato il default=false, errore:" + e.getMessage()));
                isReadObjectStatoBozza = false;
            }
        }
        return isReadObjectStatoBozza;
    }

    public boolean isICARHttp200ResponseCodeEnabled() {
        if (isIcarHttp200ResponseCodeEnabled == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("icar.http200.response.code.enabled");
                if (value != null) {
                    value = value.trim();
                    isIcarHttp200ResponseCodeEnabled = Boolean.parseBoolean(value);
                } else {
                    this.log.warn((Object)"Proprieta' di openspcoop 'icar.http200.response.code.enabled' non impostata, viene utilizzato il default=false");
                    isIcarHttp200ResponseCodeEnabled = false;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Proprieta' di openspcoop 'icar.http200.response.code.enabled' non impostata, viene utilizzato il default=false, errore:" + e.getMessage()));
                isIcarHttp200ResponseCodeEnabled = false;
            }
        }
        return isIcarHttp200ResponseCodeEnabled;
    }

    public boolean isPdDLight() {
        block6: {
            if (isPdDLight == null) {
                try {
                    String pddType = this.reader.getValue_convertEnvProperties("org.openspcoop.pdd.type");
                    if (pddType == null) {
                        throw new Exception("PddType non definita!");
                    }
                    if ("pddLight".equalsIgnoreCase(pddType.trim())) {
                        isPdDLight = true;
                        break block6;
                    }
                    if ("pddJEE".equalsIgnoreCase(pddType.trim())) {
                        isPdDLight = false;
                        break block6;
                    }
                    throw new Exception("Valore [" + pddType + "] non conosciuto");
                }
                catch (Exception e) {
                    this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' di openspcoop, 'org.openspcoop.pdd.type': " + e.getMessage()));
                    isPdDLight = null;
                }
            }
        }
        return isPdDLight;
    }

    public boolean checkDBConnectionByProfilo(String profilo) {
        if ("EGOV_IT_ServizioAsincronoAsimmetrico".equals(profilo) || "EGOV_IT_ServizioAsincronoSimmetrico".equals(profilo)) {
            return true;
        }
        return this.isGestioneStateful_RinegoziamentoConnessione();
    }
}

