/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.config;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.DriverException;
import org.openspcoop.dao.commons.IMonitoraggioRisorsa;
import org.openspcoop.pdd.config.Resource;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.utils.GestoreJNDI;
import org.openspcoop.utils.date.DateManager;

public class DBManager
implements IMonitoraggioRisorsa {
    private static DBManager manager = null;
    private static int transactionIsolationLevel = -1;
    private DataSource dataSource = null;
    private MsgDiagnostico msgDiag = new MsgDiagnostico("DBManager");
    private static Hashtable<String, Resource> risorseInGestione = new Hashtable();
    private static Logger logger = OpenSPCoopLogger.getLoggerOpenSPCoopCore();

    public static String[] getStatoRisorse() throws Exception {
        Resource[] o = risorseInGestione.values().toArray(new Resource[0]);
        if (o == null) {
            return null;
        }
        Resource[] resources = o;
        if (resources == null || resources.length <= 0) {
            return null;
        }
        String[] r = new String[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            Resource rr = resources[i];
            r[i] = rr.getIdentificativoPorta() + "." + rr.getModuloFunzionale() + " (" + rr.getDate().toString() + ")";
        }
        return r;
    }

    public DBManager(String jndiName, Properties context) throws Exception {
        try {
            GestoreJNDI jndi = new GestoreJNDI(context);
            this.dataSource = (DataSource)jndi.lookup(jndiName);
        }
        catch (Exception e) {
            this.msgDiag.fatalOpenSPCoop("Riscontrato errore durante la ricerca della risorsa JNDI [" + jndiName + "] : " + e.getMessage());
            throw e;
        }
        try {
            Connection connectionTest = this.dataSource.getConnection();
            transactionIsolationLevel = connectionTest.getTransactionIsolation();
            connectionTest.close();
        }
        catch (Exception e) {
            this.msgDiag.fatalOpenSPCoop("Riscontrato errore durante la lettura del TransactionIsolation level [" + jndiName + "] : " + e.getMessage());
            throw e;
        }
    }

    public static boolean initialize(String jndiName, Properties context) {
        try {
            manager = new DBManager(jndiName, context);
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"Inizializzazione DBManager non riuscita", (Throwable)e);
            return false;
        }
    }

    public static DBManager getInstance() {
        return manager;
    }

    public static int getTransactionIsolationLevel() {
        return transactionIsolationLevel;
    }

    public Resource getResource(String idPDD, String modulo) {
        if (this.dataSource == null) {
            return null;
        }
        Resource risorsa = new Resource();
        try {
            Connection connectionDB = this.dataSource.getConnection();
            if (connectionDB == null) {
                throw new Exception("is null");
            }
            String idUnivoco = Resource.generaIdentificatoreUnivoco(idPDD, modulo);
            risorsa.setId(idUnivoco);
            risorsa.setDate(DateManager.getDate());
            risorsa.setIdentificativoPorta(idPDD);
            risorsa.setModuloFunzionale(modulo);
            risorsa.setResource(connectionDB);
            risorsa.setResourceType(Connection.class.getName());
            risorseInGestione.put(idUnivoco, risorsa);
        }
        catch (Exception e) {
            this.msgDiag.aggiornaFiltri();
            this.msgDiag.setDominioSPCoop(idPDD);
            this.msgDiag.setFunzione("DBManager." + modulo);
            this.msgDiag.fatalOpenSPCoop("Riscontrato errore durante la richiesta di una connessione: " + e.getMessage());
            logger.error((Object)"Riscontrato errore durante la richiesta di una connessione al Database", (Throwable)e);
            return null;
        }
        return risorsa;
    }

    public void releaseResource(String idPDD, String modulo, Resource resource) {
        try {
            if (resource != null) {
                Connection connectionDB;
                if (resource.getResource() != null && (connectionDB = (Connection)resource.getResource()) != null && !connectionDB.isClosed()) {
                    connectionDB.close();
                }
                if (risorseInGestione.containsKey(resource.getId())) {
                    risorseInGestione.remove(resource.getId());
                }
            }
        }
        catch (SQLException e) {
            this.msgDiag.aggiornaFiltri();
            this.msgDiag.setDominioSPCoop(idPDD);
            this.msgDiag.setFunzione("DBManager." + modulo);
            this.msgDiag.fatalOpenSPCoop("Rilasciata Connessione al Database con errore[" + e.getMessage() + "].");
            logger.error((Object)"Rilasciata Connessione al Database con errore", (Throwable)e);
        }
    }

    public void isAlive() throws DriverException {
        Resource resource = null;
        Statement stmtTest = null;
        try {
            resource = this.getResource("DBManager", "CheckIsAlive");
            if (resource == null) {
                throw new Exception("Resource is null");
            }
            if (resource.getResource() == null) {
                throw new Exception("Connessione is null");
            }
            Connection con = (Connection)resource.getResource();
            stmtTest = con.createStatement();
            stmtTest.execute("SELECT * from DB_INFO");
        }
        catch (Exception e) {
            throw new DriverException("Connessione al database OpenSPCoop non disponibile: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (stmtTest != null) {
                    stmtTest.close();
                }
            }
            catch (Exception e) {}
            try {
                this.releaseResource("DBManager", "CheckIsAlive", resource);
            }
            catch (Exception e) {}
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }
}

