/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.config;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.DriverException;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.commons.IMonitoraggioRisorsa;
import org.openspcoop.dao.config.AccessoConfigurazionePdD;
import org.openspcoop.dao.config.AccessoRegistro;
import org.openspcoop.dao.config.Configurazione;
import org.openspcoop.dao.config.Connettore;
import org.openspcoop.dao.config.CorrelazioneApplicativa;
import org.openspcoop.dao.config.GestioneErrore;
import org.openspcoop.dao.config.InvocazionePortaGestioneErrore;
import org.openspcoop.dao.config.InvocazioneServizio;
import org.openspcoop.dao.config.MessaggiDiagnostici;
import org.openspcoop.dao.config.PortaApplicativa;
import org.openspcoop.dao.config.PortaDelegata;
import org.openspcoop.dao.config.RispostaAsincrona;
import org.openspcoop.dao.config.Route;
import org.openspcoop.dao.config.RoutingTable;
import org.openspcoop.dao.config.RoutingTableDestinazione;
import org.openspcoop.dao.config.ServizioApplicativo;
import org.openspcoop.dao.config.SoggettoSpcoop;
import org.openspcoop.dao.config.Tracciamento;
import org.openspcoop.dao.config.ValidazioneContenutiApplicativi;
import org.openspcoop.dao.config.WsSecurity;
import org.openspcoop.dao.config.driver.DriverConfigurazioneException;
import org.openspcoop.dao.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop.dao.config.driver.IDPortaApplicativa;
import org.openspcoop.dao.config.driver.IDPortaDelegata;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.egov.ProprietaErroreApplicativo;
import org.openspcoop.pdd.config.ConfigurazionePdD;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.config.PddProperties;
import org.openspcoop.pdd.config.RichiestaApplicativa;
import org.openspcoop.pdd.config.RichiestaDelegata;
import org.openspcoop.pdd.config.SoggettoVirtuale;
import org.openspcoop.pdd.core.ParametriPortaDelegata;
import org.openspcoop.pdd.core.autenticazione.Credenziali;
import org.openspcoop.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop.pdd.core.connettori.GestoreErroreConnettore;
import org.openspcoop.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop.pdd.logger.LogLevels;
import org.openspcoop.registry.RegistroServiziReader;
import org.openspcoop.utils.DynamicNamespaceContext;
import org.openspcoop.utils.regexp.RegularExpressionEngine;
import org.openspcoop.utils.regexp.RegularExpressionNotFoundException;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurazionePdDReader {
    private static ConfigurazionePdDReader configurazionePdDReader;
    private static boolean initialize;
    private ConfigurazionePdD configurazionePdD;
    private boolean configurazioneDinamica = false;
    private RegistroServiziReader registroServiziReader;
    private Logger log = null;
    private OpenSPCoopProperties openspcoopProperties = null;
    private PddProperties pddProperties = null;
    private boolean isPdDLight;
    private static AccessoRegistro accessoRegistroServizi;
    private static Boolean accessoRegistroServiziLetto;
    private static String tipoValidazione;
    private static Boolean isLivelloValidazioneNormale;
    private static Boolean isLivelloValidazioneRigido;
    private static Boolean validazioneProfiloCollaborazione;
    private static Boolean validazioneManifestAttachments;
    private static Boolean newConnectionForResponseSPCoop;
    private static Boolean utilizzoIndirizzoTelematico;
    private static Boolean gestioneManifestAttachments;
    private static Long timeoutRiscontro;
    private static Level livelloSPCoop_msgDiagnostici;
    public static Level livelloSPCoop_msgDiagnosticiJMX;
    private static Level livelloOpenSPCoop_msgDiagnostici;
    public static Level livelloOpenSPCoop_msgDiagnosticiJMX;
    private static Integer severitaSPCoop_msgDiagnostici;
    public static Integer severitaSPCoop_msgDiagnosticiJMX;
    private static Integer severitaOpenSPCoop_msgDiagnostici;
    public static Integer severitaOpenSPCoop_msgDiagnosticiJMX;
    private static MessaggiDiagnostici openSPCoopAppender_MsgDiagnostici;
    private static Boolean openSPCoopAppender_MsgDiagnosticiLetto;
    private static Boolean dumpMessaggi;
    public static Boolean dumpMessaggiJMX;
    public static Boolean tracciamentoBusteEGovJMX;
    private static Boolean tracciamentoBusteEGov;
    private static Tracciamento openSPCoopAppender_Tracciamento;
    private static Boolean openSPCoopAppender_TracciamentoLetto;
    private static GestioneErrore gestioneErroreConnettoreComponenteCooperazione;
    private static GestioneErrore gestioneErroreConnettoreComponenteIntegrazione;
    private static String integrationManagerAuthentication;
    private static ValidazioneContenutiApplicativi validazioneContenutiApplicativi;

    public static void resetCache() throws DriverConfigurazioneException {
        try {
            ConfigurazionePdDReader configurazionePdDReader = ConfigurazionePdDReader.getInstance();
            if (configurazionePdDReader != null && configurazionePdDReader.configurazionePdD != null) {
                configurazionePdDReader.configurazionePdD.resetCache();
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Reset della cache della Configurazione della Porta di Dominio non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void abilitaCache() throws DriverConfigurazioneException {
        try {
            ConfigurazionePdDReader configurazionePdDReader = ConfigurazionePdDReader.getInstance();
            if (configurazionePdDReader != null && configurazionePdDReader.configurazionePdD != null) {
                configurazionePdDReader.configurazionePdD.abilitaCache();
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Abilitazione cache della Configurazione della Porta di Dominio non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void abilitaCache(long dimensioneCache, boolean algoritmoCacheLRU, long itemIdleTime, long itemLifeSecond) throws DriverConfigurazioneException {
        try {
            ConfigurazionePdDReader configurazionePdDReader = ConfigurazionePdDReader.getInstance();
            if (configurazionePdDReader != null && configurazionePdDReader.configurazionePdD != null) {
                configurazionePdDReader.configurazionePdD.abilitaCache(dimensioneCache, algoritmoCacheLRU, itemIdleTime, itemLifeSecond);
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Abilitazione cache della Configurazione della Porta di Dominio non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void disabilitaCache() throws DriverConfigurazioneException {
        try {
            ConfigurazionePdDReader configurazionePdDReader = ConfigurazionePdDReader.getInstance();
            if (configurazionePdDReader != null && configurazionePdDReader.configurazionePdD != null) {
                configurazionePdDReader.configurazionePdD.disabilitaCache();
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Disabilitazione cache della Configurazione della Porta di Dominio non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public static boolean initialize(AccessoConfigurazionePdD accessoConfigurazione, Logger aLog, Logger aLogconsole) {
        try {
            configurazionePdDReader = new ConfigurazionePdDReader(accessoConfigurazione, aLog, aLogconsole);
            return initialize;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isInitialize() {
        return initialize;
    }

    public static ConfigurazionePdDReader getInstance() {
        return configurazionePdDReader;
    }

    public ConfigurazionePdDReader(AccessoConfigurazionePdD accessoConfigurazione, Logger aLog, Logger aLogconsole) throws DriverConfigurazioneException {
        try {
            this.log = aLog != null ? aLog : Logger.getLogger((String)"Configurazione della PdD OpenSPCoop");
            this.configurazionePdD = new ConfigurazionePdD(accessoConfigurazione, this.log, aLogconsole);
            this.openspcoopProperties = OpenSPCoopProperties.getInstance();
            this.pddProperties = PddProperties.getInstance();
            this.configurazioneDinamica = this.openspcoopProperties.isConfigurazioneDinamica();
            this.isPdDLight = this.openspcoopProperties.isPdDLight();
            initialize = true;
        }
        catch (Exception e) {
            if (this.log != null) {
                this.log.error((Object)"Configurazione non inizializzata", (Throwable)e);
            } else {
                System.err.println("Configurazione non inizializzata:" + e.getMessage());
            }
            initialize = false;
        }
    }

    public void initializeRegistroServiziReader() throws DriverConfigurazioneException {
        if (!RegistroServiziReader.isInitialize()) {
            throw new DriverConfigurazioneException("Registro dei Servizi non risulta inizializzato");
        }
        this.registroServiziReader = RegistroServiziReader.getInstance();
    }

    public void isAlive() throws DriverException {
        ((IMonitoraggioRisorsa)this.configurazionePdD.getDriverConfigurazionePdD()).isAlive();
    }

    public IDSoggetto getSoggettoSPCoop(String location) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        SoggettoSpcoop soggetto = this.configurazionePdD.getSoggetto(location);
        if (soggetto == null) {
            throw new DriverConfigurazioneNotFound("Soggetto che possiede la porta delegata [" + location + "] non esistente");
        }
        IDSoggetto soggettoSPCoop = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
        if (soggetto.getIdentificativoPorta() != null) {
            soggettoSPCoop.setCodicePorta(soggetto.getIdentificativoPorta());
        } else {
            soggettoSPCoop.setCodicePorta(soggetto.getNome() + "SPCoopIT");
        }
        return soggettoSPCoop;
    }

    public String getDominio(IDSoggetto idSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        SoggettoSpcoop soggetto = this.configurazionePdD.getSoggetto(idSoggetto);
        if (soggetto == null) {
            throw new DriverConfigurazioneNotFound("Soggetto[" + idSoggetto.toString() + "] per lettura Dominio non trovato");
        }
        if (soggetto.getIdentificativoPorta() != null) {
            return soggetto.getIdentificativoPorta();
        }
        if (soggetto.getNome() != null) {
            return soggetto.getNome() + "SPCoopIT";
        }
        OpenSPCoopProperties properties = OpenSPCoopProperties.getInstance();
        return properties.getIdentificativoPortaDefault();
    }

    public boolean isSoggettoVirtuale(IDSoggetto idSoggetto) throws DriverConfigurazioneException {
        if (idSoggetto == null || idSoggetto.getTipo() == null || idSoggetto.getNome() == null) {
            return false;
        }
        HashSet<String> listaSoggettiVirtuali = null;
        try {
            listaSoggettiVirtuali = this.configurazionePdD.getSoggettiVirtuali();
        }
        catch (DriverConfigurazioneNotFound de) {
            this.log.info((Object)"Soggetti virtuali non presenti.");
            return false;
        }
        String keySoggetto = idSoggetto.getTipo() + idSoggetto.getNome();
        return listaSoggettiVirtuali.contains(keySoggetto);
    }

    public boolean existsSoggetto(IDSoggetto idSoggetto) throws DriverConfigurazioneException {
        SoggettoSpcoop soggetto = null;
        try {
            soggetto = this.configurazionePdD.getSoggetto(idSoggetto);
        }
        catch (DriverConfigurazioneNotFound e) {
            return false;
        }
        return soggetto != null;
    }

    public HashSet<IDServizio> getServizi_SoggettiVirtuali() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.configurazionePdD.getServizi_SoggettiVirtuali();
    }

    public Connettore getForwardRoute(IDSoggetto idSoggettoDestinatario) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getForwardRoute(null, new IDServizio(idSoggettoDestinatario));
    }

    public Connettore getForwardRoute(IDSoggetto idSoggettoMittente, IDServizio idServizio) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        int i;
        if (idServizio == null) {
            throw new DriverConfigurazioneException("getForwardRoute error: Identificativo servizio non definito");
        }
        if (idServizio.getSoggettoErogatore() == null) {
            throw new DriverConfigurazioneException("getForwardRoute error: Soggetto Erogatore non definito");
        }
        String nome = idServizio.getSoggettoErogatore().getNome();
        String tipo = idServizio.getSoggettoErogatore().getTipo();
        if (nome == null || tipo == null) {
            throw new DriverConfigurazioneException("getForwardRoute error: Soggetto Erogatore con tipo/nome non definito");
        }
        RoutingTable routingTable = this.configurazionePdD.getRoutingTable();
        if (!routingTable.getAbilitata().booleanValue() || routingTable.sizeDefaultList() == 0 && routingTable.sizeDestinazioneList() == 0) {
            if (!routingTable.getAbilitata().booleanValue()) {
                this.log.debug((Object)"getForwardRoute: routing table disabilitata");
            } else {
                this.log.debug((Object)"getForwardRoute: routing table senza rotte");
            }
            Connettore connettoreDominio = null;
            try {
                connettoreDominio = idSoggettoMittente != null && idServizio.getServizio() != null ? this.registroServiziReader.getConnettore(idSoggettoMittente, idServizio, null) : this.registroServiziReader.getConnettore(idServizio.getSoggettoErogatore(), null);
            }
            catch (DriverRegistroServiziNotFound e) {
                throw new DriverConfigurazioneNotFound("getForwardRoute[RoutingTable Non Abilitata], ricerca nel RegistroServizi effettuata: " + e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("getForwardRoute[RoutingTable Non Abilitata], errore durante la lettura dal Registro dei Servizi: " + e.getMessage(), (Throwable)e);
            }
            if (connettoreDominio != null && !"none".equals(connettoreDominio.getTipo()) && !"disabilitato".equals(connettoreDominio.getTipo())) {
                return connettoreDominio;
            }
            throw new DriverConfigurazioneException("getForwardRoute[RoutingTable Non Abilitata], connettore per la busta non trovato.");
        }
        StringBuffer bf = new StringBuffer();
        bf.append("Ricerca connettore del servizio...");
        this.log.debug((Object)"getForwardRoute: routing table abilitata");
        for (i = 0; i < routingTable.sizeDestinazioneList(); ++i) {
            if (!nome.equals(routingTable.getDestinazione(i).getNome()) || !tipo.equals(routingTable.getDestinazione(i).getTipo())) continue;
            bf.append("\nRotta di destinazione [" + routingTable.getDestinazione(i).getTipo() + "/" + routingTable.getDestinazione(i).getNome() + "]...\n");
            this.log.debug((Object)("getForwardRoute: esamino routing table, destinazione [" + routingTable.getDestinazione(i).getTipo() + "/" + routingTable.getDestinazione(i).getNome() + "]"));
            RoutingTableDestinazione routingTableDest = routingTable.getDestinazione(i);
            for (int j = 0; j < routingTableDest.sizeRouteList(); ++j) {
                Route route = routingTableDest.getRoute(j);
                Connettore connettoreDominio = null;
                boolean error = false;
                try {
                    if (route.getRegistro() != null) {
                        this.log.debug((Object)("getForwardRoute: esamino routing table, destinazione [" + routingTable.getDestinazione(i).getTipo() + "/" + routingTable.getDestinazione(i).getNome() + "] RegistroNome[" + route.getRegistro().getNome() + "]"));
                        bf.append("\tRegistro nomeRegistro[" + route.getRegistro().getNome() + "]: ");
                        connettoreDominio = idSoggettoMittente != null && idServizio.getServizio() != null ? this.registroServiziReader.getConnettore(idSoggettoMittente, idServizio, route.getRegistro().getNome()) : this.registroServiziReader.getConnettore(idServizio.getSoggettoErogatore(), route.getRegistro().getNome());
                        if (connettoreDominio != null && !"none".equals(connettoreDominio.getTipo()) && !"disabilitato".equals(connettoreDominio.getTipo())) {
                            connettoreDominio.setNomeRegistro(route.getRegistro().getNome());
                        }
                    } else if (route.getGateway() != null) {
                        this.log.debug((Object)("getForwardRoute: esamino routing table, destinazione [" + routingTable.getDestinazione(i).getTipo() + "/" + routingTable.getDestinazione(i).getNome() + "] GateWay[" + route.getGateway().getTipo() + "/" + route.getGateway().getNome() + "]"));
                        bf.append("\tGateWay[" + route.getGateway().getTipo() + "/" + route.getGateway().getNome() + "]: ");
                        IDSoggetto gateway = new IDSoggetto(route.getGateway().getTipo(), route.getGateway().getNome());
                        connettoreDominio = this.registroServiziReader.getConnettore(gateway, null);
                        if (connettoreDominio != null && !"none".equals(connettoreDominio.getTipo()) && !"disabilitato".equals(connettoreDominio.getTipo())) {
                            connettoreDominio.setNomeDestinatarioTrasmissioneBusta(gateway.getNome());
                            connettoreDominio.setTipoDestinatarioTrasmissioneBusta(gateway.getTipo());
                        }
                    }
                }
                catch (DriverRegistroServiziNotFound e) {
                    error = true;
                    bf.append(" non trovata: " + e.getMessage());
                }
                catch (Exception e) {
                    throw new DriverConfigurazioneException("getForwardRoute: esamino routing table, destinazione [" + routingTable.getDestinazione(i).getTipo() + "/" + routingTable.getDestinazione(i).getNome() + "]: Accesso al registro non riuscito: " + e.getMessage(), (Throwable)e);
                }
                if (connettoreDominio != null && !"none".equals(connettoreDominio.getTipo()) && !"disabilitato".equals(connettoreDominio.getTipo())) {
                    return connettoreDominio;
                }
                if (error) continue;
                bf.append(" non trovata: connettore non definito");
            }
        }
        for (i = 0; i < routingTable.sizeDefaultList(); ++i) {
            this.log.debug((Object)"getForwardRoute: esamino routing table, rotta di default");
            bf.append("\nRotta di default");
            Route route = routingTable.getDefault(i);
            Connettore connettoreDominio = null;
            boolean error = false;
            try {
                if (route.getRegistro() != null) {
                    this.log.debug((Object)("getForwardRoute: esamino routing table, rotta di default, Registro nomeRegistro[" + route.getRegistro().getNome() + "]"));
                    bf.append(" Registro nomeRegistro[" + route.getRegistro().getNome() + "]: ");
                    connettoreDominio = idSoggettoMittente != null && idServizio.getServizio() != null ? this.registroServiziReader.getConnettore(idSoggettoMittente, idServizio, route.getRegistro().getNome()) : this.registroServiziReader.getConnettore(idServizio.getSoggettoErogatore(), route.getRegistro().getNome());
                    if (connettoreDominio != null && !"none".equals(connettoreDominio.getTipo()) && !"disabilitato".equals(connettoreDominio.getTipo())) {
                        connettoreDominio.setNomeRegistro(route.getRegistro().getNome());
                    }
                } else if (route.getGateway() != null) {
                    this.log.debug((Object)("getForwardRoute: esamino routing table, rotta di default, GateWay[" + route.getGateway().getTipo() + "/" + route.getGateway().getNome() + "]"));
                    bf.append(" GateWay[" + route.getGateway().getTipo() + "/" + route.getGateway().getNome() + "]: ");
                    IDSoggetto gateway = new IDSoggetto(route.getGateway().getTipo(), route.getGateway().getNome());
                    connettoreDominio = this.registroServiziReader.getConnettore(gateway, null);
                    if (connettoreDominio != null && !"none".equals(connettoreDominio.getTipo()) && !"disabilitato".equals(connettoreDominio.getTipo())) {
                        connettoreDominio.setNomeDestinatarioTrasmissioneBusta(gateway.getNome());
                        connettoreDominio.setTipoDestinatarioTrasmissioneBusta(gateway.getTipo());
                    }
                }
            }
            catch (DriverRegistroServiziNotFound e) {
                error = true;
                bf.append(" non trovata: " + e.getMessage());
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("getForwardRoute: esamino routing table, rotta di default: Accesso al registro non riuscito: " + e.getMessage(), (Throwable)e);
            }
            if (connettoreDominio != null && !"none".equals(connettoreDominio.getTipo()) && !"disabilitato".equals(connettoreDominio.getTipo())) {
                return connettoreDominio;
            }
            if (error) continue;
            bf.append(" non trovata: connettore non definito");
        }
        throw new DriverConfigurazioneNotFound("getForwardRoute [Routing Table] error: connettore per la busta non trovato: \n" + bf.toString());
    }

    public String getRegistroForImbustamento(IDSoggetto idSoggettoMittente, IDServizio idServizio) throws DriverConfigurazioneException {
        Connettore conn = null;
        try {
            conn = this.getForwardRoute(idSoggettoMittente, idServizio);
        }
        catch (DriverConfigurazioneNotFound e) {
            // empty catch block
        }
        if (conn != null) {
            return conn.getNomeRegistro();
        }
        return null;
    }

    public boolean routerFunctionActive() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        RoutingTable routingTable = null;
        try {
            routingTable = this.configurazionePdD.getRoutingTable();
        }
        catch (Exception e) {
            this.log.debug((Object)"routerFunctionActive[getRoutingTable]", (Throwable)e);
        }
        if (routingTable == null || !routingTable.getAbilitata().booleanValue() || routingTable.sizeDefaultList() == 0 && routingTable.sizeDestinazioneList() == 0) {
            return false;
        }
        SoggettoSpcoop router = null;
        try {
            router = this.configurazionePdD.getRouter();
        }
        catch (DriverConfigurazioneNotFound e) {
            return false;
        }
        return router != null;
    }

    public IDSoggetto getRouterIdentity() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        RoutingTable routingTable = null;
        try {
            routingTable = this.configurazionePdD.getRoutingTable();
        }
        catch (Exception e) {
            this.log.debug((Object)"getRouterIdentity[routingTable]", (Throwable)e);
        }
        if (routingTable == null || !routingTable.getAbilitata().booleanValue() || routingTable.sizeDefaultList() == 0 && routingTable.sizeDestinazioneList() == 0) {
            throw new DriverConfigurazioneException("getRouterIdentity error: RoutingTable non definita");
        }
        SoggettoSpcoop router = this.configurazionePdD.getRouter();
        if (router == null) {
            throw new DriverConfigurazioneNotFound("Router non trovato");
        }
        String codicePorta = router.getIdentificativoPorta();
        if (codicePorta == null) {
            if (router.getNome() != null) {
                codicePorta = router.getNome() + "SPCoopIT";
            } else {
                OpenSPCoopProperties properties = OpenSPCoopProperties.getInstance();
                codicePorta = properties.getIdentificativoPortaDefault();
            }
        }
        return new IDSoggetto(router.getTipo(), router.getNome(), codicePorta);
    }

    public PortaDelegata getPortaDelegata(IDPortaDelegata idPD) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.configurazionePdD.getPortaDelegata(idPD);
    }

    public PortaDelegata getPortaDelegata_SafeMethod(IDPortaDelegata idPD) throws DriverConfigurazioneException {
        try {
            if (idPD.getLocationPD() != null) {
                return this.getPortaDelegata(idPD);
            }
            return null;
        }
        catch (DriverConfigurazioneNotFound e) {
            return null;
        }
    }

    public boolean identificazioneContentBased(PortaDelegata pd) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if ("contentBased".equals(pd.getSoggettoSpcoopErogatore().getIdentificazione())) {
            return true;
        }
        if ("contentBased".equals(pd.getServizio().getIdentificazione())) {
            return true;
        }
        if (pd.getAzione() != null) {
            return "contentBased".equals(pd.getAzione().getIdentificazione());
        }
        return false;
    }

    public IDServizio getIDServizio(PortaDelegata pd, ParametriPortaDelegata parPD, SOAPEnvelope envelope, HeaderIntegrazione headerIntegrazione, boolean readFirstHeaderIntegrazione) throws DriverConfigurazioneException, DriverConfigurazioneNotFound, Exception {
        try {
            String sog;
            String urlInvocazionePD = null;
            boolean urlBased = false;
            if ("urlBased".equals(pd.getSoggettoSpcoopErogatore().getIdentificazione())) {
                urlBased = true;
            } else if ("urlBased".equals(pd.getServizio().getIdentificazione())) {
                urlBased = true;
            } else if (pd.getAzione() != null && "urlBased".equals(pd.getAzione().getIdentificazione())) {
                urlBased = true;
            }
            if (urlBased) {
                urlInvocazionePD = parPD.getUrlInvocazionePD_formBased();
            }
            DynamicNamespaceContext dnc = null;
            if ("contentBased".equals(pd.getSoggettoSpcoopErogatore().getIdentificazione())) {
                dnc = DynamicNamespaceContext.getNamespaceContext((Node)envelope);
            } else if ("contentBased".equals(pd.getServizio().getIdentificazione())) {
                dnc = DynamicNamespaceContext.getNamespaceContext((Node)envelope);
            } else if (pd.getAzione() != null && "contentBased".equals(pd.getAzione().getIdentificazione())) {
                dnc = DynamicNamespaceContext.getNamespaceContext((Node)envelope);
            }
            IDSoggetto soggettoErogatore = new IDSoggetto();
            soggettoErogatore.setTipo(pd.getSoggettoSpcoopErogatore().getTipo());
            if ("static".equals(pd.getSoggettoSpcoopErogatore().getIdentificazione()) || pd.getSoggettoSpcoopErogatore().getIdentificazione() == null) {
                soggettoErogatore.setNome(pd.getSoggettoSpcoopErogatore().getNome());
            } else if (readFirstHeaderIntegrazione && headerIntegrazione.getEgov() != null && headerIntegrazione.getEgov().getDestinatario() != null) {
                soggettoErogatore.setNome(headerIntegrazione.getEgov().getDestinatario());
                if (headerIntegrazione.getEgov().getTipoDestinatario() != null) {
                    soggettoErogatore.setTipo(headerIntegrazione.getEgov().getTipoDestinatario());
                }
            } else if ("urlBased".equals(pd.getSoggettoSpcoopErogatore().getIdentificazione())) {
                sog = RegularExpressionEngine.getStringMatchPatternURLBased((String)urlInvocazionePD, (String)pd.getSoggettoSpcoopErogatore().getPattern());
                if (sog != null) {
                    sog = sog.replaceAll("_", "");
                }
                soggettoErogatore.setNome(sog);
            } else if ("contentBased".equals(pd.getSoggettoSpcoopErogatore().getIdentificazione())) {
                sog = RegularExpressionEngine.getStringMatchPatternContentBased((MessageElement)envelope, (DynamicNamespaceContext)dnc, (String)pd.getSoggettoSpcoopErogatore().getPattern());
                soggettoErogatore.setNome(sog);
            } else if ("inputBased".equals(pd.getSoggettoSpcoopErogatore().getIdentificazione()) && headerIntegrazione.getEgov() != null) {
                soggettoErogatore.setNome(headerIntegrazione.getEgov().getDestinatario());
                if (headerIntegrazione.getEgov().getTipoDestinatario() != null) {
                    soggettoErogatore.setTipo(headerIntegrazione.getEgov().getTipoDestinatario());
                }
            }
            String servizio = null;
            String tipoServizio = pd.getServizio().getTipo();
            if ("static".equals(pd.getServizio().getIdentificazione()) || pd.getServizio().getIdentificazione() == null) {
                servizio = pd.getServizio().getNome();
            } else if (readFirstHeaderIntegrazione && headerIntegrazione.getEgov() != null && headerIntegrazione.getEgov().getServizio() != null) {
                servizio = headerIntegrazione.getEgov().getServizio();
                if (headerIntegrazione.getEgov().getTipoServizio() != null) {
                    tipoServizio = headerIntegrazione.getEgov().getTipoServizio();
                }
            } else if ("urlBased".equals(pd.getServizio().getIdentificazione())) {
                servizio = RegularExpressionEngine.getStringMatchPatternURLBased((String)urlInvocazionePD, (String)pd.getServizio().getPattern());
            } else if ("contentBased".equals(pd.getServizio().getIdentificazione())) {
                servizio = RegularExpressionEngine.getStringMatchPatternContentBased((MessageElement)envelope, (DynamicNamespaceContext)dnc, (String)pd.getServizio().getPattern());
            } else if ("inputBased".equals(pd.getServizio().getIdentificazione()) && headerIntegrazione.getEgov() != null) {
                servizio = headerIntegrazione.getEgov().getServizio();
                if (headerIntegrazione.getEgov().getTipoServizio() != null) {
                    tipoServizio = headerIntegrazione.getEgov().getTipoServizio();
                }
            }
            String azione = null;
            if (pd.getAzione() != null) {
                if ("static".equals(pd.getAzione().getIdentificazione()) || pd.getAzione().getIdentificazione() == null) {
                    azione = pd.getAzione().getNome();
                } else if (readFirstHeaderIntegrazione && headerIntegrazione.getEgov() != null && headerIntegrazione.getEgov().getAzione() != null) {
                    azione = headerIntegrazione.getEgov().getAzione();
                } else if ("urlBased".equals(pd.getAzione().getIdentificazione())) {
                    try {
                        azione = RegularExpressionEngine.getStringMatchPatternURLBased((String)urlInvocazionePD, (String)pd.getAzione().getPattern());
                    }
                    catch (Exception e) {}
                } else if ("contentBased".equals(pd.getAzione().getIdentificazione())) {
                    try {
                        azione = RegularExpressionEngine.getStringMatchPatternContentBased((MessageElement)envelope, (DynamicNamespaceContext)dnc, (String)pd.getAzione().getPattern());
                    }
                    catch (Exception e) {}
                } else if ("inputBased".equals(pd.getAzione().getIdentificazione()) && headerIntegrazione.getEgov() != null) {
                    azione = headerIntegrazione.getEgov().getAzione();
                }
            }
            IDServizio service = new IDServizio(soggettoErogatore, tipoServizio, servizio, azione);
            return service;
        }
        catch (RegularExpressionNotFoundException re) {
            throw new DriverConfigurazioneNotFound(re.getMessage(), (Throwable)re);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public Hashtable<String, String> getPD_WSSForSender(PortaDelegata pd) throws DriverConfigurazioneException {
        Hashtable<String, String> table = new Hashtable<String, String>();
        if (pd == null) {
            return table;
        }
        WsSecurity wss = pd.getWsSecurity();
        if (wss == null) {
            return table;
        }
        int sizeParameter = wss.sizeRequestFlowList();
        for (int i = 0; i < sizeParameter; ++i) {
            String nome = wss.getRequestFlow(i).getNome();
            if (nome == null) continue;
            String valore = wss.getRequestFlow(i).getValore();
            if ("actor".equals(nome)) {
                if (valore == null) {
                    valore = "";
                } else if ("notDefined".equals(valore)) {
                    valore = "";
                }
            }
            table.put(nome, valore);
        }
        return table;
    }

    public Hashtable<String, String> getPD_WSSForReceiver(PortaDelegata pd) throws DriverConfigurazioneException {
        Hashtable<String, String> table = new Hashtable<String, String>();
        if (pd == null) {
            return table;
        }
        WsSecurity wss = pd.getWsSecurity();
        if (wss == null) {
            return table;
        }
        int sizeParameter = wss.sizeResponseFlowList();
        for (int i = 0; i < sizeParameter; ++i) {
            String nome = wss.getResponseFlow(i).getNome();
            if (nome == null) continue;
            String valore = wss.getResponseFlow(i).getValore();
            if ("actor".equals(nome)) {
                if (valore == null) {
                    valore = "";
                } else if ("notDefined".equals(valore)) {
                    valore = "";
                }
            }
            table.put(nome, valore);
        }
        return table;
    }

    public String getAutenticazione(PortaDelegata pd) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (pd.getAutenticazione() == null) {
            return "ssl";
        }
        return pd.getAutenticazione();
    }

    public String getAutorizzazione(PortaDelegata pd) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (pd.getAutorizzazione() == null) {
            return "openspcoop";
        }
        return pd.getAutorizzazione();
    }

    public boolean ricevutaAsincronaSimmetricaAbilitata(PortaDelegata pd) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return !"disabilitato".equals(pd.getRicevutaAsincronaSimmetrica());
    }

    public boolean ricevutaAsincronaAsimmetricaAbilitata(PortaDelegata pd) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return !"disabilitato".equals(pd.getRicevutaAsincronaAsimmetrica());
    }

    public ValidazioneContenutiApplicativi getTipoValidazioneContenutoApplicativo(PortaDelegata pd, String implementazionePdDSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        ValidazioneContenutiApplicativi val = this.getTipoValidazioneContenutoApplicativo(implementazionePdDSoggetto);
        if (pd == null || pd.getValidazioneContenutiApplicativi() == null) {
            return val;
        }
        if ("abilitato".equalsIgnoreCase(pd.getValidazioneContenutiApplicativi().getStato())) {
            val.setStato("abilitato");
        } else if ("warningOnly".equalsIgnoreCase(pd.getValidazioneContenutiApplicativi().getStato())) {
            val.setStato("warningOnly");
        } else if ("disabilitato".equalsIgnoreCase(pd.getValidazioneContenutiApplicativi().getStato())) {
            val.setStato("disabilitato");
        }
        if ("openspcoop".equalsIgnoreCase(pd.getValidazioneContenutiApplicativi().getTipo())) {
            val.setTipo("openspcoop");
        } else if ("wsdl".equalsIgnoreCase(pd.getValidazioneContenutiApplicativi().getTipo())) {
            val.setTipo("wsdl");
        } else if ("xsd".equalsIgnoreCase(pd.getValidazioneContenutiApplicativi().getTipo())) {
            val.setTipo("xsd");
        }
        return val;
    }

    public CorrelazioneApplicativa getCorrelazioneApplicativa(PortaDelegata pd) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return pd.getCorrelazioneApplicativa();
    }

    public String[] getTipiIntegrazione(PortaDelegata pd) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        String[] tipi = null;
        if (pd != null && pd.getIntegrazione() != null && !"".equals(pd.getIntegrazione())) {
            tipi = pd.getIntegrazione().trim().split(",");
        }
        return tipi;
    }

    public boolean isGestioneManifestAttachments(PortaDelegata pd) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if ("abilitato".equalsIgnoreCase(pd.getGestioneManifest())) {
            return true;
        }
        if ("disabilitato".equalsIgnoreCase(pd.getGestioneManifest())) {
            return false;
        }
        return this.isGestioneManifestAttachments();
    }

    public boolean isAllegaBody(PortaDelegata pd) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if ("abilitato".equalsIgnoreCase(pd.getAllegaBody())) {
            return true;
        }
        if ("disabilitato".equalsIgnoreCase(pd.getAllegaBody())) {
            return false;
        }
        return false;
    }

    public boolean isScartaBody(PortaDelegata pd) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if ("abilitato".equalsIgnoreCase(pd.getScartaBody())) {
            return true;
        }
        if ("disabilitato".equalsIgnoreCase(pd.getScartaBody())) {
            return false;
        }
        return false;
    }

    public boolean isModalitaStatelessByProfiloServizio(PortaDelegata pd, String profiloServizio) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (this.isPdDLight) {
            return true;
        }
        if (pd == null) {
            if ("EGOV_IT_MessaggioSingoloOneWay".equals(profiloServizio)) {
                return "abilitato".equals(this.openspcoopProperties.getStatelessOneWay());
            }
            if ("EGOV_IT_ServizioSincrono".equals(profiloServizio)) {
                return "abilitato".equals(this.openspcoopProperties.getStatelessSincrono());
            }
            return "abilitato".equals(this.openspcoopProperties.getStatelessAsincrono());
        }
        return "abilitato".equalsIgnoreCase(pd.getStateless());
    }

    public Hashtable<IDSoggetto, PortaApplicativa> getPorteApplicative_SoggettiVirtuali(IDPortaApplicativa idPA) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.configurazionePdD.getPorteApplicative_SoggettiVirtuali(idPA, null, false);
    }

    public boolean existsPA(RichiestaApplicativa idPA) throws DriverConfigurazioneException {
        if (idPA.getIDServizio() == null) {
            return false;
        }
        if (idPA.getIDServizio().getServizio() == null || idPA.getIDServizio().getTipoServizio() == null) {
            return false;
        }
        if (this.isSoggettoVirtuale(idPA.getIDServizio().getSoggettoErogatore())) {
            Hashtable<IDSoggetto, PortaApplicativa> paConSoggetti = null;
            try {
                paConSoggetti = this.configurazionePdD.getPorteApplicative_SoggettiVirtuali(idPA.getIdPortaApplicativa(), idPA.getFiltroProprietaPorteApplicative(), true);
            }
            catch (DriverConfigurazioneNotFound e) {
                return false;
            }
            return paConSoggetti != null && paConSoggetti.size() > 0;
        }
        PortaApplicativa pa = null;
        try {
            pa = this.configurazionePdD.getPortaApplicativa(idPA.getIdPortaApplicativa(), idPA.getFiltroProprietaPorteApplicative());
        }
        catch (DriverConfigurazioneNotFound e) {
            return false;
        }
        return pa != null;
    }

    public PortaApplicativa getPortaApplicativa(IDPortaApplicativa idPA, Hashtable<String, String> proprietaPresentiBustaRicevuta) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.configurazionePdD.getPortaApplicativa(idPA, proprietaPresentiBustaRicevuta);
    }

    public PortaApplicativa getPortaApplicativa_SafeMethod(IDPortaApplicativa idPA, Hashtable<String, String> proprietaPresentiBustaRicevuta) throws DriverConfigurazioneException {
        try {
            if (idPA != null && idPA.getIDServizio() != null && idPA.getIDServizio().getServizio() != null && idPA.getIDServizio().getTipoServizio() != null && idPA.getIDServizio().getSoggettoErogatore() != null && idPA.getIDServizio().getSoggettoErogatore().getTipo() != null && idPA.getIDServizio().getSoggettoErogatore().getNome() != null) {
                return this.getPortaApplicativa(idPA, proprietaPresentiBustaRicevuta);
            }
            return null;
        }
        catch (DriverConfigurazioneNotFound e) {
            return null;
        }
    }

    public String[] getServiziApplicativi(PortaApplicativa pa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        String[] sa = new String[pa.sizeServizioApplicativoList()];
        for (int i = 0; i < pa.sizeServizioApplicativoList(); ++i) {
            sa[i] = pa.getServizioApplicativo(i).getNome();
        }
        return sa;
    }

    public SoggettoVirtuale getServiziApplicativi_SoggettiVirtuali(RichiestaApplicativa idPA) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Hashtable<IDSoggetto, PortaApplicativa> paConSoggetti = this.configurazionePdD.getPorteApplicative_SoggettiVirtuali(idPA.getIdPortaApplicativa(), idPA.getFiltroProprietaPorteApplicative(), true);
        if (paConSoggetti == null) {
            throw new DriverConfigurazioneNotFound("PorteApplicative contenenti SoggettiVirtuali di [" + idPA.getIdPortaApplicativa() + "] non trovate");
        }
        if (paConSoggetti.size() == 0) {
            throw new DriverConfigurazioneNotFound("PorteApplicative contenenti SoggettiVirtuali di [" + idPA.getIdPortaApplicativa() + "] non trovate");
        }
        Vector<IDSoggetto> soggettiRealiTrovati = new Vector<IDSoggetto>();
        Vector<String> serviziApplicativiTrovati = new Vector<String>();
        Enumeration<IDSoggetto> e = paConSoggetti.keys();
        while (e.hasMoreElements()) {
            IDSoggetto soggReale = e.nextElement();
            PortaApplicativa pa = paConSoggetti.get(soggReale);
            for (int k = 0; k < pa.sizeServizioApplicativoList(); ++k) {
                serviziApplicativiTrovati.add(pa.getServizioApplicativo(k).getNome());
                soggettiRealiTrovati.add(soggReale);
            }
        }
        if (soggettiRealiTrovati.size() == 0) {
            throw new DriverConfigurazioneNotFound("PorteApplicative contenenti SoggettiVirtuali di [" + idPA.getIdPortaApplicativa() + "] non trovati soggetti virtuali");
        }
        IDSoggetto[] soggettiReali = new IDSoggetto[soggettiRealiTrovati.size()];
        String[] serviziApplicativi = new String[serviziApplicativiTrovati.size()];
        soggettiReali = soggettiRealiTrovati.toArray(soggettiReali);
        serviziApplicativi = serviziApplicativiTrovati.toArray(serviziApplicativi);
        SoggettoVirtuale soggVirtuale = new SoggettoVirtuale();
        soggVirtuale.setSoggettiReali(soggettiReali);
        soggVirtuale.setServiziApplicativi(serviziApplicativi);
        return soggVirtuale;
    }

    public Hashtable<String, String> getPA_WSSForSender(PortaApplicativa pa) throws DriverConfigurazioneException {
        Hashtable<String, String> table = new Hashtable<String, String>();
        if (pa == null) {
            return table;
        }
        WsSecurity wss = pa.getWsSecurity();
        if (wss == null) {
            return table;
        }
        int sizeParameter = wss.sizeResponseFlowList();
        for (int i = 0; i < sizeParameter; ++i) {
            String nome = wss.getResponseFlow(i).getNome();
            if (nome == null) continue;
            String valore = wss.getResponseFlow(i).getValore();
            if ("actor".equals(nome)) {
                if (valore == null) {
                    valore = "";
                } else if ("notDefined".equals(valore)) {
                    valore = "";
                }
            }
            table.put(nome, valore);
        }
        return table;
    }

    public Hashtable<String, String> getPA_WSSForReceiver(PortaApplicativa pa) throws DriverConfigurazioneException {
        Hashtable<String, String> table = new Hashtable<String, String>();
        if (pa == null) {
            return table;
        }
        WsSecurity wss = pa.getWsSecurity();
        if (wss == null) {
            return table;
        }
        int sizeParameter = wss.sizeRequestFlowList();
        for (int i = 0; i < sizeParameter; ++i) {
            String nome = wss.getRequestFlow(i).getNome();
            if (nome == null) continue;
            String valore = wss.getRequestFlow(i).getValore();
            if ("actor".equals(nome)) {
                if (valore == null) {
                    valore = "";
                } else if ("notDefined".equals(valore)) {
                    valore = "";
                }
            }
            table.put(nome, valore);
        }
        return table;
    }

    public boolean ricevutaAsincronaSimmetricaAbilitata(PortaApplicativa pa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return !"disabilitato".equals(pa.getRicevutaAsincronaSimmetrica());
    }

    public boolean ricevutaAsincronaAsimmetricaAbilitata(PortaApplicativa pa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return !"disabilitato".equals(pa.getRicevutaAsincronaAsimmetrica());
    }

    public ValidazioneContenutiApplicativi getTipoValidazioneContenutoApplicativo(PortaApplicativa pa, String implementazionePdDSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        ValidazioneContenutiApplicativi val = this.getTipoValidazioneContenutoApplicativo(implementazionePdDSoggetto);
        if (pa == null || pa.getValidazioneContenutiApplicativi() == null) {
            return val;
        }
        if ("abilitato".equalsIgnoreCase(pa.getValidazioneContenutiApplicativi().getStato())) {
            val.setStato("abilitato");
        } else if ("warningOnly".equalsIgnoreCase(pa.getValidazioneContenutiApplicativi().getStato())) {
            val.setStato("warningOnly");
        } else if ("disabilitato".equalsIgnoreCase(pa.getValidazioneContenutiApplicativi().getStato())) {
            val.setStato("disabilitato");
        }
        if ("openspcoop".equalsIgnoreCase(pa.getValidazioneContenutiApplicativi().getTipo())) {
            val.setTipo("openspcoop");
        } else if ("wsdl".equalsIgnoreCase(pa.getValidazioneContenutiApplicativi().getTipo())) {
            val.setTipo("wsdl");
        } else if ("xsd".equalsIgnoreCase(pa.getValidazioneContenutiApplicativi().getTipo())) {
            val.setTipo("xsd");
        }
        return val;
    }

    public String[] getTipiIntegrazione(PortaApplicativa pa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        String[] tipi = null;
        if (pa.getIntegrazione() != null && !"".equals(pa.getIntegrazione())) {
            tipi = pa.getIntegrazione().trim().split(",");
        }
        return tipi;
    }

    public boolean isGestioneManifestAttachments(PortaApplicativa pa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (pa == null) {
            return this.isGestioneManifestAttachments();
        }
        if ("abilitato".equalsIgnoreCase(pa.getGestioneManifest())) {
            return true;
        }
        if ("disabilitato".equalsIgnoreCase(pa.getGestioneManifest())) {
            return false;
        }
        return this.isGestioneManifestAttachments();
    }

    public boolean isAllegaBody(PortaApplicativa pa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (pa == null) {
            return false;
        }
        if ("abilitato".equalsIgnoreCase(pa.getAllegaBody())) {
            return true;
        }
        if ("disabilitato".equalsIgnoreCase(pa.getAllegaBody())) {
            return false;
        }
        return false;
    }

    public boolean isScartaBody(PortaApplicativa pa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (pa == null) {
            return false;
        }
        if ("abilitato".equalsIgnoreCase(pa.getScartaBody())) {
            return true;
        }
        if ("disabilitato".equalsIgnoreCase(pa.getScartaBody())) {
            return false;
        }
        return false;
    }

    public boolean isModalitaStatelessByProfiloServizio(PortaApplicativa pa, String profiloServizio) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (this.isPdDLight) {
            return true;
        }
        if (pa == null) {
            if ("EGOV_IT_MessaggioSingoloOneWay".equals(profiloServizio)) {
                return "abilitato".equals(this.openspcoopProperties.getStatelessOneWay());
            }
            if ("EGOV_IT_ServizioSincrono".equals(profiloServizio)) {
                return "abilitato".equals(this.openspcoopProperties.getStatelessSincrono());
            }
            return "abilitato".equals(this.openspcoopProperties.getStatelessAsincrono());
        }
        return "abilitato".equalsIgnoreCase(pa.getStateless());
    }

    public boolean existsServizioApplicativo(IDPortaDelegata idPD, String serv) throws DriverConfigurazioneException {
        ServizioApplicativo servizioApplicativo = null;
        try {
            servizioApplicativo = this.configurazionePdD.getServizioApplicativo(idPD, serv);
        }
        catch (DriverConfigurazioneNotFound e) {
            return false;
        }
        return servizioApplicativo != null;
    }

    public ServizioApplicativo getServizioApplicativo(IDPortaDelegata idPD, String serv) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        return this.configurazionePdD.getServizioApplicativo(idPD, serv);
    }

    public ServizioApplicativo getServizioApplicativo(IDPortaApplicativa idPA, String serv) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        return this.configurazionePdD.getServizioApplicativo(idPA, serv);
    }

    public String autenticazioneHTTP(IDSoggetto aSoggetto, String location, String aUser, String aPassword) throws DriverConfigurazioneException {
        ServizioApplicativo servizioApplicativo = null;
        try {
            IDPortaDelegata idPD = new IDPortaDelegata();
            idPD.setSoggettoFruitore(aSoggetto);
            idPD.setLocationPD(location);
            servizioApplicativo = this.configurazionePdD.getServizioApplicativoAutenticato(idPD, aUser, aPassword);
        }
        catch (DriverConfigurazioneNotFound e) {
            // empty catch block
        }
        if (servizioApplicativo != null) {
            return servizioApplicativo.getNome();
        }
        return null;
    }

    public String autenticazioneHTTP(String aUser, String aPassword) throws DriverConfigurazioneException {
        ServizioApplicativo servizioApplicativo = null;
        try {
            servizioApplicativo = this.configurazionePdD.getServizioApplicativoAutenticato(aUser, aPassword);
        }
        catch (DriverConfigurazioneNotFound e) {
            // empty catch block
        }
        if (servizioApplicativo != null) {
            return servizioApplicativo.getNome();
        }
        return null;
    }

    public String autenticazioneHTTPS(IDSoggetto aSoggetto, String location, String aSubject) throws DriverConfigurazioneException {
        ServizioApplicativo servizioApplicativo = null;
        try {
            IDPortaDelegata idPD = new IDPortaDelegata();
            idPD.setSoggettoFruitore(aSoggetto);
            idPD.setLocationPD(location);
            servizioApplicativo = this.configurazionePdD.getServizioApplicativoAutenticato(idPD, aSubject);
        }
        catch (DriverConfigurazioneNotFound e) {
            // empty catch block
        }
        if (servizioApplicativo != null) {
            return servizioApplicativo.getNome();
        }
        return null;
    }

    public String autenticazioneHTTPS(String aSubject) throws DriverConfigurazioneException {
        ServizioApplicativo servizioApplicativo = null;
        try {
            servizioApplicativo = this.configurazionePdD.getServizioApplicativoAutenticato(aSubject);
        }
        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
            // empty catch block
        }
        if (servizioApplicativo != null) {
            return servizioApplicativo.getNome();
        }
        return null;
    }

    public boolean autorizzazione(PortaDelegata pd, String servizio) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (pd == null || servizio == null) {
            return false;
        }
        for (int j = 0; j < pd.sizeServizioApplicativoList(); ++j) {
            ServizioApplicativo sa = pd.getServizioApplicativo(j);
            if (!servizio.equals(sa.getNome())) continue;
            return true;
        }
        return false;
    }

    public void aggiornaProprietaGestioneErrorePD(ProprietaErroreApplicativo gestioneErrore, ServizioApplicativo sa) throws DriverConfigurazioneException {
        if (sa == null) {
            return;
        }
        if (sa.getInvocazionePorta() == null) {
            return;
        }
        if (sa.getInvocazionePorta().getGestioneErrore() == null) {
            return;
        }
        InvocazionePortaGestioneErrore proprietaSA = sa.getInvocazionePorta().getGestioneErrore();
        if ("soap".equals(proprietaSA.getFault())) {
            gestioneErrore.setFaultAsXML(false);
        } else if ("xml".equals(proprietaSA.getFault())) {
            gestioneErrore.setFaultAsXML(true);
        }
        if (proprietaSA.getFaultActor() != null) {
            gestioneErrore.setFaultActor(proprietaSA.getFaultActor());
        }
        if ("abilitato".equals(proprietaSA.getGenericFaultCode())) {
            gestioneErrore.setFaultAsGenericCode(true);
        } else if ("disabilitato".equals(proprietaSA.getGenericFaultCode())) {
            gestioneErrore.setFaultAsGenericCode(false);
        }
        if (proprietaSA.getPrefixFaultCode() != null) {
            gestioneErrore.setFaultPrefixCode(proprietaSA.getPrefixFaultCode());
        }
    }

    public boolean invocazionePortaDelegataPerRiferimento(ServizioApplicativo sa) throws DriverConfigurazioneException {
        if (sa == null) {
            return false;
        }
        if (sa.getInvocazionePorta() == null) {
            return false;
        }
        return "abilitato".equals(sa.getInvocazionePorta().getInvioPerRiferimento());
    }

    public boolean invocazioneServizioConGetMessage(ServizioApplicativo sa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (sa == null) {
            return false;
        }
        if (sa.getInvocazioneServizio() == null) {
            return false;
        }
        InvocazioneServizio serv = sa.getInvocazioneServizio();
        return "abilitato".equalsIgnoreCase(serv.getGetMessage());
    }

    public boolean invocazioneServizioConSbustamento(ServizioApplicativo sa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (sa == null) {
            return false;
        }
        if (sa.getInvocazioneServizio() == null) {
            return false;
        }
        InvocazioneServizio serv = sa.getInvocazioneServizio();
        return serv.getSbustamentoSoap();
    }

    public boolean invocazioneServizioConConnettore(ServizioApplicativo sa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (sa == null) {
            return false;
        }
        if (sa.getInvocazioneServizio() == null) {
            return false;
        }
        InvocazioneServizio serv = sa.getInvocazioneServizio();
        Connettore connettore = serv.getConnettore();
        return connettore != null && !"none".equals(connettore.getTipo()) && !"disabilitato".equals(connettore.getTipo());
    }

    public ConnettoreMsg getInvocazioneServizio(ServizioApplicativo sa, RichiestaApplicativa idPA) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        int i;
        if (sa.getInvocazioneServizio() == null) {
            throw new DriverConfigurazioneNotFound("Servizio applicativo [" + idPA.getServizioApplicativo() + "] del soggetto[" + idPA.getIDServizio().getSoggettoErogatore() + "] non possieder l'elemento invocazione servizio");
        }
        InvocazioneServizio serv = sa.getInvocazioneServizio();
        IDSoggetto aSoggetto = idPA.getIDServizio().getSoggettoErogatore();
        SoggettoSpcoop soggetto = this.configurazionePdD.getSoggetto(aSoggetto);
        if (soggetto == null) {
            throw new DriverConfigurazioneNotFound("[getInvocazioneServizio] Soggetto erogatore non trovato");
        }
        PortaApplicativa pa = this.configurazionePdD.getPortaApplicativa(idPA.getIdPortaApplicativa(), idPA.getFiltroProprietaPorteApplicative());
        Connettore connettore = serv.getConnettore();
        Hashtable<String, String> properties = null;
        if (connettore != null && !"disabilitato".equals(connettore.getTipo())) {
            String nome = connettore.getNome();
            if (connettore.getTipo() == null) {
                for (i = 0; i < soggetto.sizeConnettoreList(); ++i) {
                    if (!nome.equals(soggetto.getConnettore(i).getNome())) continue;
                    connettore = soggetto.getConnettore(i);
                    break;
                }
            }
            properties = new Hashtable<String, String>();
            for (i = 0; i < connettore.sizePropertyList(); ++i) {
                properties.put(connettore.getProperty(i).getNome(), connettore.getProperty(i).getValore());
            }
        }
        Properties spcoop_properties = new Properties();
        for (i = 0; i < pa.sizeSetSpcoopPropertyList(); ++i) {
            spcoop_properties.put(pa.getSetSpcoopProperty(i).getNome(), pa.getSetSpcoopProperty(i).getValore());
        }
        String autenticazione = "none";
        if ("ssl".equalsIgnoreCase(serv.getAutenticazione())) {
            autenticazione = "ssl";
        }
        if ("basic".equalsIgnoreCase(serv.getAutenticazione())) {
            autenticazione = "basic";
        }
        Credenziali credenziali = null;
        if (serv.getCredenziali() != null && autenticazione.equals(serv.getCredenziali().getTipo())) {
            credenziali = new Credenziali();
            credenziali.setUsername(serv.getCredenziali().getUser());
            credenziali.setPassword(serv.getCredenziali().getPassword());
            credenziali.setSubject(serv.getCredenziali().getSubject());
        }
        ConnettoreMsg connettoreMsg = null;
        if (connettore != null) {
            connettoreMsg = new ConnettoreMsg();
            connettoreMsg.setTipoConnettore(connettore.getTipo());
            connettoreMsg.setConnectorProperties(properties);
            connettoreMsg.setSbustamentoSOAP(serv.getSbustamentoSoap());
            connettoreMsg.setPropertiesTrasporto(spcoop_properties);
            connettoreMsg.setAutenticazione(autenticazione);
            connettoreMsg.setCredenziali(credenziali);
        }
        return connettoreMsg;
    }

    public GestioneErrore getGestioneErroreConnettore_InvocazioneServizio(ServizioApplicativo sa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (sa.getInvocazioneServizio() == null || sa.getInvocazioneServizio().getGestioneErrore() == null) {
            return GestoreErroreConnettore.getGestioneErroreDefaultComponenteIntegrazione();
        }
        InvocazioneServizio invocazione = sa.getInvocazioneServizio();
        return invocazione.getGestioneErrore();
    }

    public boolean invocazioneServizioPerRiferimento(ServizioApplicativo sa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (sa == null) {
            return false;
        }
        if (sa.getInvocazioneServizio() == null) {
            return false;
        }
        return "abilitato".equals(sa.getInvocazioneServizio().getInvioPerRiferimento());
    }

    public boolean invocazioneServizioRispostaPerRiferimento(ServizioApplicativo sa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (sa == null) {
            return false;
        }
        if (sa.getInvocazioneServizio() == null) {
            return false;
        }
        return "abilitato".equals(sa.getInvocazioneServizio().getRispostaPerRiferimento());
    }

    public boolean existsConsegnaRispostaAsincrona(ServizioApplicativo sa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (sa == null) {
            return false;
        }
        if (sa.getRispostaAsincrona() == null) {
            return false;
        }
        if ("abilitato".equals(sa.getRispostaAsincrona().getGetMessage())) {
            return true;
        }
        return sa.getRispostaAsincrona().getConnettore() != null && !"disabilitato".equals(sa.getRispostaAsincrona().getConnettore().getTipo());
    }

    public boolean consegnaRispostaAsincronaConGetMessage(ServizioApplicativo sa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (sa == null) {
            return false;
        }
        if (sa.getRispostaAsincrona() == null) {
            return false;
        }
        RispostaAsincrona serv = sa.getRispostaAsincrona();
        return "abilitato".equalsIgnoreCase(serv.getGetMessage());
    }

    public boolean consegnaRispostaAsincronaConSbustamento(ServizioApplicativo sa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (sa == null) {
            return false;
        }
        if (sa.getRispostaAsincrona() == null) {
            return false;
        }
        RispostaAsincrona serv = sa.getRispostaAsincrona();
        return serv.getSbustamentoSoap();
    }

    public boolean consegnaRispostaAsincronaConConnettore(ServizioApplicativo sa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (sa == null) {
            return false;
        }
        if (sa.getRispostaAsincrona() == null) {
            return false;
        }
        RispostaAsincrona serv = sa.getRispostaAsincrona();
        Connettore connettore = serv.getConnettore();
        return connettore != null && !"none".equals(connettore.getTipo()) && !"disabilitato".equals(connettore.getTipo());
    }

    public ConnettoreMsg getConsegnaRispostaAsincrona(ServizioApplicativo sa, RichiestaDelegata idPD) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (sa.getRispostaAsincrona() == null) {
            throw new DriverConfigurazioneNotFound("Servizio applicativo [" + idPD.getServizioApplicativo() + "] del soggetto[" + idPD.getSoggettoFruitore() + "] non possiede una risposta Asincrona");
        }
        RispostaAsincrona serv = sa.getRispostaAsincrona();
        IDSoggetto aSoggetto = idPD.getSoggettoFruitore();
        SoggettoSpcoop soggetto = this.configurazionePdD.getSoggetto(aSoggetto);
        if (soggetto == null) {
            throw new DriverConfigurazioneNotFound("[getConsegnaRispostaAsincrona] Soggetto non trovato");
        }
        Connettore connettore = serv.getConnettore();
        Hashtable<String, String> properties = null;
        if (connettore != null && !"disabilitato".equals(connettore.getTipo())) {
            int i;
            String nome = connettore.getNome();
            if (connettore.getTipo() == null) {
                for (i = 0; i < soggetto.sizeConnettoreList(); ++i) {
                    if (!nome.equals(soggetto.getConnettore(i).getNome())) continue;
                    connettore = soggetto.getConnettore(i);
                    break;
                }
            }
            properties = new Hashtable<String, String>();
            for (i = 0; i < connettore.sizePropertyList(); ++i) {
                properties.put(connettore.getProperty(i).getNome(), connettore.getProperty(i).getValore());
            }
        }
        String autenticazione = "none";
        if ("ssl".equalsIgnoreCase(serv.getAutenticazione())) {
            autenticazione = "ssl";
        }
        if ("basic".equalsIgnoreCase(serv.getAutenticazione())) {
            autenticazione = "basic";
        }
        Credenziali credenziali = null;
        if (serv.getCredenziali() != null && autenticazione.equals(serv.getCredenziali().getTipo())) {
            credenziali = new Credenziali();
            credenziali.setUsername(serv.getCredenziali().getUser());
            credenziali.setPassword(serv.getCredenziali().getPassword());
            credenziali.setSubject(serv.getCredenziali().getSubject());
        }
        ConnettoreMsg connettoreMsg = null;
        if (connettore != null) {
            connettoreMsg = new ConnettoreMsg();
            connettoreMsg.setTipoConnettore(connettore.getTipo());
            connettoreMsg.setConnectorProperties(properties);
            connettoreMsg.setSbustamentoSOAP(serv.getSbustamentoSoap());
            connettoreMsg.setAutenticazione(autenticazione);
            connettoreMsg.setCredenziali(credenziali);
        }
        return connettoreMsg;
    }

    public ConnettoreMsg getConsegnaRispostaAsincrona(ServizioApplicativo sa, RichiestaApplicativa idPA) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        int i;
        if (sa.getRispostaAsincrona() == null) {
            throw new DriverConfigurazioneNotFound("Servizio applicativo [" + idPA.getServizioApplicativo() + "] del soggetto[" + idPA.getSoggettoFruitore() + "] non possiede l'elemento invocazione servizio");
        }
        RispostaAsincrona serv = sa.getRispostaAsincrona();
        IDSoggetto aSoggetto = idPA.getIDServizio().getSoggettoErogatore();
        SoggettoSpcoop soggetto = this.configurazionePdD.getSoggetto(aSoggetto);
        if (soggetto == null) {
            throw new DriverConfigurazioneNotFound("[getConsegnaRispostaAsincrona] Soggetto non trovato");
        }
        PortaApplicativa pa = this.configurazionePdD.getPortaApplicativa(idPA.getIdPortaApplicativa(), idPA.getFiltroProprietaPorteApplicative());
        Connettore connettore = serv.getConnettore();
        Hashtable<String, String> properties = null;
        if (connettore != null && !"disabilitato".equals(connettore.getTipo())) {
            String nome = connettore.getNome();
            if (connettore.getTipo() == null) {
                for (i = 0; i < soggetto.sizeConnettoreList(); ++i) {
                    if (!nome.equals(soggetto.getConnettore(i).getNome())) continue;
                    connettore = soggetto.getConnettore(i);
                    break;
                }
            }
            properties = new Hashtable<String, String>();
            for (i = 0; i < connettore.sizePropertyList(); ++i) {
                properties.put(connettore.getProperty(i).getNome(), connettore.getProperty(i).getValore());
            }
        }
        Properties spcoop_properties = new Properties();
        for (i = 0; i < pa.sizeSetSpcoopPropertyList(); ++i) {
            spcoop_properties.put(pa.getSetSpcoopProperty(i).getNome(), pa.getSetSpcoopProperty(i).getValore());
        }
        String autenticazione = "none";
        if ("ssl".equalsIgnoreCase(serv.getAutenticazione())) {
            autenticazione = "ssl";
        }
        if ("basic".equalsIgnoreCase(serv.getAutenticazione())) {
            autenticazione = "basic";
        }
        Credenziali credenziali = null;
        if (serv.getCredenziali() != null && autenticazione.equals(serv.getCredenziali().getTipo())) {
            credenziali = new Credenziali();
            credenziali.setUsername(serv.getCredenziali().getUser());
            credenziali.setPassword(serv.getCredenziali().getPassword());
            credenziali.setSubject(serv.getCredenziali().getSubject());
        }
        ConnettoreMsg connettoreMsg = null;
        if (connettore != null) {
            connettoreMsg = new ConnettoreMsg();
            connettoreMsg.setTipoConnettore(connettore.getTipo());
            connettoreMsg.setConnectorProperties(properties);
            connettoreMsg.setSbustamentoSOAP(serv.getSbustamentoSoap());
            connettoreMsg.setPropertiesTrasporto(spcoop_properties);
            connettoreMsg.setAutenticazione(autenticazione);
            connettoreMsg.setCredenziali(credenziali);
        }
        return connettoreMsg;
    }

    public GestioneErrore getGestioneErroreConnettore_RispostaAsincrona(ServizioApplicativo sa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (sa.getRispostaAsincrona() == null || sa.getRispostaAsincrona().getGestioneErrore() == null) {
            return GestoreErroreConnettore.getGestioneErroreDefaultComponenteIntegrazione();
        }
        RispostaAsincrona asincrona = sa.getRispostaAsincrona();
        return asincrona.getGestioneErrore();
    }

    public boolean consegnaRispostaAsincronaPerRiferimento(ServizioApplicativo sa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (sa == null) {
            return false;
        }
        if (sa.getRispostaAsincrona() == null) {
            return false;
        }
        return "abilitato".equals(sa.getRispostaAsincrona().getInvioPerRiferimento());
    }

    public boolean consegnaRispostaAsincronaRispostaPerRiferimento(ServizioApplicativo sa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (sa == null) {
            return false;
        }
        if (sa.getRispostaAsincrona() == null) {
            return false;
        }
        return "abilitato".equals(sa.getRispostaAsincrona().getRispostaPerRiferimento());
    }

    public AccessoRegistro getAccessoRegistroServizi() {
        if (this.configurazioneDinamica || !accessoRegistroServiziLetto.booleanValue()) {
            AccessoRegistro configRegistro = null;
            try {
                configRegistro = this.configurazionePdD.getAccessoRegistro();
            }
            catch (DriverConfigurazioneNotFound e) {
                this.log.debug((Object)("getAccessoRegistroServizi (not found): " + e.getMessage()));
            }
            catch (Exception e) {
                this.log.debug((Object)"getAccessoRegistroServizi", (Throwable)e);
            }
            accessoRegistroServizi = configRegistro;
            accessoRegistroServiziLetto = true;
        }
        return accessoRegistroServizi;
    }

    public String getTipoValidazione(String implementazionePdDSoggetto) {
        String tipo = this.pddProperties.getValidazioneEGov_Stato(implementazionePdDSoggetto);
        if (tipo != null && ("abilitato".equalsIgnoreCase(tipo) || "disabilitato".equalsIgnoreCase(tipo) || "warningOnly".equalsIgnoreCase(tipo))) {
            if ("abilitato".equalsIgnoreCase(tipo)) {
                return "abilitato";
            }
            if ("disabilitato".equalsIgnoreCase(tipo)) {
                return "disabilitato";
            }
            return "warningOnly";
        }
        if (this.configurazioneDinamica || tipoValidazione == null) {
            Configurazione configurazione = null;
            try {
                configurazione = this.configurazionePdD.getConfigurazioneGenerale();
            }
            catch (DriverConfigurazioneNotFound e) {
                this.log.debug((Object)("getTipoValidazione (not found): " + e.getMessage()));
            }
            catch (Exception e) {
                this.log.debug((Object)"getTipoValidazione", (Throwable)e);
            }
            tipoValidazione = configurazione == null || configurazione.getValidazioneBusteEgov() == null ? "abilitato" : ("abilitato".equalsIgnoreCase(configurazione.getValidazioneBusteEgov().getStato()) ? "abilitato" : ("disabilitato".equalsIgnoreCase(configurazione.getValidazioneBusteEgov().getStato()) ? "disabilitato" : ("warningOnly".equalsIgnoreCase(configurazione.getValidazioneBusteEgov().getStato()) ? "warningOnly" : "abilitato")));
        }
        return tipoValidazione;
    }

    public boolean isLivelloValidazioneNormale(String implementazionePdDSoggetto) {
        String value = this.pddProperties.getValidazioneEGov_Controllo(implementazionePdDSoggetto);
        if (value != null && ("normale".equalsIgnoreCase(value) || "rigido".equalsIgnoreCase(value))) {
            return "normale".equalsIgnoreCase(value);
        }
        if (this.configurazioneDinamica || isLivelloValidazioneNormale == null) {
            Configurazione configurazione = null;
            try {
                configurazione = this.configurazionePdD.getConfigurazioneGenerale();
            }
            catch (DriverConfigurazioneNotFound e) {
                this.log.debug((Object)("isLivelloValidazioneNormale (not found): " + e.getMessage()));
            }
            catch (Exception e) {
                this.log.debug((Object)"isLivelloValidazioneNormale", (Throwable)e);
            }
            isLivelloValidazioneNormale = configurazione == null || configurazione.getValidazioneBusteEgov() == null ? Boolean.valueOf(true) : ("normale".equalsIgnoreCase(configurazione.getValidazioneBusteEgov().getControllo()) ? Boolean.valueOf(true) : Boolean.valueOf(false));
        }
        return isLivelloValidazioneNormale;
    }

    public boolean isLivelloValidazioneRigido(String implementazionePdDSoggetto) {
        String value = this.pddProperties.getValidazioneEGov_Controllo(implementazionePdDSoggetto);
        if (value != null && ("normale".equalsIgnoreCase(value) || "rigido".equalsIgnoreCase(value))) {
            return "rigido".equalsIgnoreCase(value);
        }
        if (this.configurazioneDinamica || isLivelloValidazioneRigido == null) {
            Configurazione configurazione = null;
            try {
                configurazione = this.configurazionePdD.getConfigurazioneGenerale();
            }
            catch (DriverConfigurazioneNotFound e) {
                this.log.debug((Object)("isLivelloValidazioneRigido (not found): " + e.getMessage()));
            }
            catch (Exception e) {
                this.log.debug((Object)"isLivelloValidazioneRigido", (Throwable)e);
            }
            isLivelloValidazioneRigido = configurazione == null || configurazione.getValidazioneBusteEgov() == null ? Boolean.valueOf(false) : ("rigido".equalsIgnoreCase(configurazione.getValidazioneBusteEgov().getControllo()) ? Boolean.valueOf(true) : Boolean.valueOf(false));
        }
        return isLivelloValidazioneRigido;
    }

    public boolean isValidazioneProfiloCollaborazione(String implementazionePdDSoggetto) {
        String value = this.pddProperties.getValidazioneEGov_ProfiloCollaborazione(implementazionePdDSoggetto);
        if (value != null && ("abilitato".equalsIgnoreCase(value) || "disabilitato".equalsIgnoreCase(value))) {
            return "abilitato".equalsIgnoreCase(value);
        }
        if (this.configurazioneDinamica || validazioneProfiloCollaborazione == null) {
            Configurazione configurazione = null;
            try {
                configurazione = this.configurazionePdD.getConfigurazioneGenerale();
            }
            catch (DriverConfigurazioneNotFound e) {
                this.log.debug((Object)("isValidazioneProfiloCollaborazione (not found): " + e.getMessage()));
            }
            catch (Exception e) {
                this.log.debug((Object)"isValidazioneProfiloCollaborazione", (Throwable)e);
            }
            validazioneProfiloCollaborazione = configurazione == null || configurazione.getValidazioneBusteEgov() == null ? Boolean.valueOf(false) : ("abilitato".equals(configurazione.getValidazioneBusteEgov().getProfiloCollaborazione()) ? Boolean.valueOf(true) : Boolean.valueOf(false));
        }
        return validazioneProfiloCollaborazione;
    }

    public boolean isValidazioneManifestAttachments(String implementazionePdDSoggetto) {
        String value = this.pddProperties.getValidazioneEGov_ManifestAttachments(implementazionePdDSoggetto);
        if (value != null && ("abilitato".equalsIgnoreCase(value) || "disabilitato".equalsIgnoreCase(value))) {
            return "abilitato".equalsIgnoreCase(value);
        }
        if (this.configurazioneDinamica || validazioneManifestAttachments == null) {
            Configurazione configurazione = null;
            try {
                configurazione = this.configurazionePdD.getConfigurazioneGenerale();
            }
            catch (DriverConfigurazioneNotFound e) {
                this.log.debug((Object)("isValidazioneManifestAttachments (not found): " + e.getMessage()));
            }
            catch (Exception e) {
                this.log.debug((Object)"isValidazioneManifestAttachments", (Throwable)e);
            }
            validazioneManifestAttachments = configurazione == null || configurazione.getValidazioneBusteEgov() == null ? Boolean.valueOf(true) : ("disabilitato".equals(configurazione.getValidazioneBusteEgov().getManifestAttachments()) ? Boolean.valueOf(false) : Boolean.valueOf(true));
        }
        return validazioneManifestAttachments;
    }

    public boolean newConnectionForResponseSPCoop() {
        if (this.configurazioneDinamica || newConnectionForResponseSPCoop == null) {
            Configurazione configurazione = null;
            try {
                configurazione = this.configurazionePdD.getConfigurazioneGenerale();
            }
            catch (DriverConfigurazioneNotFound e) {
                this.log.debug((Object)("newConnectionForResponseSPCoop (not found): " + e.getMessage()));
            }
            catch (Exception e) {
                this.log.debug((Object)"newConnectionForResponseSPCoop", (Throwable)e);
            }
            newConnectionForResponseSPCoop = configurazione == null || configurazione.getRisposteSpcoop() == null ? Boolean.valueOf(false) : ("new".equals(configurazione.getRisposteSpcoop().getConnessione()) ? Boolean.valueOf(true) : Boolean.valueOf(false));
        }
        return newConnectionForResponseSPCoop;
    }

    public boolean isUtilizzoIndirizzoTelematico() {
        if (this.configurazioneDinamica || utilizzoIndirizzoTelematico == null) {
            Configurazione configurazione = null;
            try {
                configurazione = this.configurazionePdD.getConfigurazioneGenerale();
            }
            catch (DriverConfigurazioneNotFound e) {
                this.log.debug((Object)("isUtilizzoIndirizzoTelematico (not found): " + e.getMessage()));
            }
            catch (Exception e) {
                this.log.debug((Object)"isUtilizzoIndirizzoTelematico", (Throwable)e);
            }
            utilizzoIndirizzoTelematico = configurazione == null || configurazione.getIndirizzoTelematico() == null ? Boolean.valueOf(false) : ("abilitato".equals(configurazione.getIndirizzoTelematico().getUtilizzo()) ? Boolean.valueOf(true) : Boolean.valueOf(false));
        }
        return utilizzoIndirizzoTelematico;
    }

    public boolean isGestioneManifestAttachments() {
        if (this.configurazioneDinamica || gestioneManifestAttachments == null) {
            Configurazione configurazione = null;
            try {
                configurazione = this.configurazionePdD.getConfigurazioneGenerale();
            }
            catch (DriverConfigurazioneNotFound e) {
                this.log.debug((Object)("isGestioneManifestAttachments (not found): " + e.getMessage()));
            }
            catch (Exception e) {
                this.log.debug((Object)"isGestioneManifestAttachments", (Throwable)e);
            }
            gestioneManifestAttachments = configurazione == null || configurazione.getAttachments() == null ? Boolean.valueOf(true) : ("disabilitato".equals(configurazione.getAttachments().getGestioneManifest()) ? Boolean.valueOf(false) : Boolean.valueOf(true));
        }
        return gestioneManifestAttachments;
    }

    public long getTimeoutRiscontro() {
        if (this.configurazioneDinamica || timeoutRiscontro == null) {
            Configurazione configurazione = null;
            try {
                configurazione = this.configurazionePdD.getConfigurazioneGenerale();
            }
            catch (DriverConfigurazioneNotFound e) {
                this.log.debug((Object)("getTimeoutRiscontro (not found): " + e.getMessage()));
            }
            catch (Exception e) {
                this.log.debug((Object)"getTimeoutRiscontro", (Throwable)e);
            }
            if (configurazione == null || configurazione.getInoltroBusteNonRiscontrate() == null) {
                timeoutRiscontro = -1L;
            } else if (configurazione.getInoltroBusteNonRiscontrate().getCadenza() == null) {
                timeoutRiscontro = -1L;
            } else {
                Long longValue = null;
                try {
                    longValue = new Long(configurazione.getInoltroBusteNonRiscontrate().getCadenza());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                timeoutRiscontro = longValue == null ? Long.valueOf(-1L) : longValue;
            }
        }
        return timeoutRiscontro;
    }

    public Level getLivelloSPCoop_msgDiagnostici() {
        if (livelloSPCoop_msgDiagnosticiJMX != null) {
            return livelloSPCoop_msgDiagnosticiJMX;
        }
        if (this.configurazioneDinamica || livelloSPCoop_msgDiagnostici == null) {
            try {
                Configurazione configurazione = null;
                try {
                    configurazione = this.configurazionePdD.getConfigurazioneGenerale();
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("getLivelloSPCoop_msgDiagnostici (not found): " + e.getMessage()));
                }
                catch (Exception e) {
                    this.log.debug((Object)"getLivelloSPCoop_msgDiagnostici", (Throwable)e);
                }
                if (configurazione != null && configurazione.getMessaggiDiagnostici() != null) {
                    String readLevel = configurazione.getMessaggiDiagnostici().getSpcoop();
                    livelloSPCoop_msgDiagnostici = LogLevels.toOpenSPCoop(readLevel);
                } else {
                    livelloSPCoop_msgDiagnostici = LogLevels.LOG_LEVEL_INFO_SPCOOP;
                }
            }
            catch (Exception e) {
                livelloSPCoop_msgDiagnostici = LogLevels.LOG_LEVEL_INFO_SPCOOP;
            }
        }
        return livelloSPCoop_msgDiagnostici;
    }

    public Level getLivelloOpenSPCoop_msgDiagnostici() {
        if (livelloOpenSPCoop_msgDiagnosticiJMX != null) {
            return livelloOpenSPCoop_msgDiagnosticiJMX;
        }
        if (this.configurazioneDinamica || livelloOpenSPCoop_msgDiagnostici == null) {
            try {
                Configurazione configurazione = null;
                try {
                    configurazione = this.configurazionePdD.getConfigurazioneGenerale();
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("getLivelloOpenSPCoop_msgDiagnostici (not found): " + e.getMessage()));
                }
                catch (Exception e) {
                    this.log.debug((Object)"getLivelloOpenSPCoop_msgDiagnostici", (Throwable)e);
                }
                if (configurazione != null && configurazione.getMessaggiDiagnostici() != null) {
                    String readLevel = configurazione.getMessaggiDiagnostici().getOpenspcoop();
                    livelloOpenSPCoop_msgDiagnostici = LogLevels.toOpenSPCoop(readLevel);
                } else {
                    livelloOpenSPCoop_msgDiagnostici = LogLevels.LOG_LEVEL_INFO_SPCOOP;
                }
            }
            catch (Exception e) {
                livelloOpenSPCoop_msgDiagnostici = LogLevels.LOG_LEVEL_INFO_SPCOOP;
            }
        }
        return livelloOpenSPCoop_msgDiagnostici;
    }

    public int getSeveritaSPCoop_msgDiagnostici() {
        if (severitaSPCoop_msgDiagnosticiJMX != null) {
            return severitaSPCoop_msgDiagnosticiJMX;
        }
        if (this.configurazioneDinamica || severitaSPCoop_msgDiagnostici == null) {
            try {
                Configurazione configurazione = null;
                try {
                    configurazione = this.configurazionePdD.getConfigurazioneGenerale();
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("getSeveritaSPCoop_msgDiagnostici (not found): " + e.getMessage()));
                }
                catch (Exception e) {
                    this.log.debug((Object)"getSeveritaSPCoop_msgDiagnostici", (Throwable)e);
                }
                if (configurazione != null && configurazione.getMessaggiDiagnostici() != null) {
                    String readLevel = configurazione.getMessaggiDiagnostici().getSpcoop();
                    severitaSPCoop_msgDiagnostici = LogLevels.toSPCoop(readLevel);
                } else {
                    severitaSPCoop_msgDiagnostici = 3;
                }
            }
            catch (Exception e) {
                severitaSPCoop_msgDiagnostici = 3;
            }
        }
        return severitaSPCoop_msgDiagnostici;
    }

    public int getSeveritaOpenSPCoop_msgDiagnostici() {
        if (severitaOpenSPCoop_msgDiagnosticiJMX != null) {
            return severitaOpenSPCoop_msgDiagnosticiJMX;
        }
        if (this.configurazioneDinamica || severitaOpenSPCoop_msgDiagnostici == null) {
            try {
                Configurazione configurazione = null;
                try {
                    configurazione = this.configurazionePdD.getConfigurazioneGenerale();
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("getSeveritaOpenSPCoop_msgDiagnostici (not found): " + e.getMessage()));
                }
                catch (Exception e) {
                    this.log.debug((Object)"getSeveritaOpenSPCoop_msgDiagnostici", (Throwable)e);
                }
                if (configurazione != null && configurazione.getMessaggiDiagnostici() != null) {
                    String readLevel = configurazione.getMessaggiDiagnostici().getOpenspcoop();
                    severitaOpenSPCoop_msgDiagnostici = LogLevels.toSPCoop(readLevel);
                } else {
                    severitaOpenSPCoop_msgDiagnostici = 3;
                }
            }
            catch (Exception e) {
                severitaOpenSPCoop_msgDiagnostici = 3;
            }
        }
        return severitaOpenSPCoop_msgDiagnostici;
    }

    public MessaggiDiagnostici getOpenSPCoopAppender_MsgDiagnostici() {
        if (this.configurazioneDinamica || !openSPCoopAppender_MsgDiagnosticiLetto.booleanValue()) {
            try {
                Configurazione configurazione = null;
                try {
                    configurazione = this.configurazionePdD.getConfigurazioneGenerale();
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("getOpenSPCoopAppender_MsgDiagnostici (not found): " + e.getMessage()));
                }
                catch (Exception e) {
                    this.log.debug((Object)"getOpenSPCoopAppender_MsgDiagnostici", (Throwable)e);
                }
                openSPCoopAppender_MsgDiagnostici = configurazione != null ? configurazione.getMessaggiDiagnostici() : null;
            }
            catch (Exception e) {
                openSPCoopAppender_MsgDiagnostici = null;
            }
            openSPCoopAppender_MsgDiagnosticiLetto = true;
        }
        return openSPCoopAppender_MsgDiagnostici;
    }

    public boolean dumpMessaggi() {
        if (dumpMessaggiJMX != null) {
            return dumpMessaggiJMX;
        }
        if (this.configurazioneDinamica || dumpMessaggi == null) {
            try {
                String read;
                Configurazione configurazione = null;
                try {
                    configurazione = this.configurazionePdD.getConfigurazioneGenerale();
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("dumpMessaggi (not found): " + e.getMessage()));
                }
                catch (Exception e) {
                    this.log.debug((Object)"dumpMessaggi", (Throwable)e);
                }
                dumpMessaggi = configurazione != null && configurazione.getTracciamento() != null ? ("abilitato".equals(read = configurazione.getTracciamento().getDump()) ? Boolean.valueOf(true) : Boolean.valueOf(false)) : Boolean.valueOf(false);
            }
            catch (Exception e) {
                dumpMessaggi = false;
            }
        }
        return dumpMessaggi;
    }

    public boolean tracciamentoBusteEGov() {
        if (tracciamentoBusteEGovJMX != null) {
            return tracciamentoBusteEGovJMX;
        }
        if (this.configurazioneDinamica || tracciamentoBusteEGov == null) {
            try {
                String read;
                Configurazione configurazione = null;
                try {
                    configurazione = this.configurazionePdD.getConfigurazioneGenerale();
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("tracciamentoBusteEGov (not found): " + e.getMessage()));
                }
                catch (Exception e) {
                    this.log.debug((Object)"tracciamentoBusteEGov", (Throwable)e);
                }
                tracciamentoBusteEGov = configurazione != null && configurazione.getTracciamento() != null ? ("disabilitato".equals(read = configurazione.getTracciamento().getBusteEgov()) ? Boolean.valueOf(false) : Boolean.valueOf(true)) : Boolean.valueOf(true);
            }
            catch (Exception e) {
                tracciamentoBusteEGov = true;
            }
        }
        return tracciamentoBusteEGov;
    }

    public Tracciamento getOpenSPCoopAppender_Tracciamento() {
        if (this.configurazioneDinamica || !openSPCoopAppender_TracciamentoLetto.booleanValue()) {
            try {
                Configurazione configurazione = null;
                try {
                    configurazione = this.configurazionePdD.getConfigurazioneGenerale();
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("getOpenSPCoopAppender_Tracciamento (not found): " + e.getMessage()));
                }
                catch (Exception e) {
                    this.log.debug((Object)"getOpenSPCoopAppender_Tracciamento", (Throwable)e);
                }
                if (configurazione != null) {
                    openSPCoopAppender_Tracciamento = configurazione.getTracciamento();
                }
            }
            catch (Exception e) {
                openSPCoopAppender_Tracciamento = null;
            }
            openSPCoopAppender_TracciamentoLetto = true;
        }
        return openSPCoopAppender_Tracciamento;
    }

    public GestioneErrore getGestioneErroreConnettoreComponenteCooperazione() {
        if (this.configurazioneDinamica || gestioneErroreConnettoreComponenteCooperazione == null) {
            try {
                GestioneErrore gestione = null;
                try {
                    gestione = this.configurazionePdD.getGestioneErroreComponenteCooperazione();
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("getGestioneErroreConnettoreComponenteCooperazione (not found): " + e.getMessage()));
                }
                catch (Exception e) {
                    this.log.debug((Object)"getGestioneErroreConnettoreComponenteCooperazione", (Throwable)e);
                }
                gestioneErroreConnettoreComponenteCooperazione = gestione == null ? GestoreErroreConnettore.getGestioneErroreDefaultComponenteCooperazione() : gestione;
            }
            catch (Exception e) {
                gestioneErroreConnettoreComponenteCooperazione = GestoreErroreConnettore.getGestioneErroreDefaultComponenteCooperazione();
            }
        }
        return gestioneErroreConnettoreComponenteCooperazione;
    }

    public GestioneErrore getGestioneErroreConnettoreComponenteIntegrazione() {
        if (this.configurazioneDinamica || gestioneErroreConnettoreComponenteIntegrazione == null) {
            try {
                GestioneErrore gestione = null;
                try {
                    gestione = this.configurazionePdD.getGestioneErroreComponenteIntegrazione();
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("getGestioneErroreConnettoreComponenteIntegrazione (not found): " + e.getMessage()));
                }
                catch (Exception e) {
                    this.log.debug((Object)"getGestioneErroreConnettoreComponenteIntegrazione", (Throwable)e);
                }
                gestioneErroreConnettoreComponenteIntegrazione = gestione == null ? GestoreErroreConnettore.getGestioneErroreDefaultComponenteIntegrazione() : gestione;
            }
            catch (Exception e) {
                gestioneErroreConnettoreComponenteIntegrazione = GestoreErroreConnettore.getGestioneErroreDefaultComponenteIntegrazione();
            }
        }
        return gestioneErroreConnettoreComponenteIntegrazione;
    }

    public String getIntegrationManagerAuthentication() {
        if (this.configurazioneDinamica || integrationManagerAuthentication == null) {
            try {
                Configurazione configurazione = null;
                try {
                    configurazione = this.configurazionePdD.getConfigurazioneGenerale();
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("getIntegrationManagerAuthentication (not found): " + e.getMessage()));
                }
                catch (Exception e) {
                    this.log.debug((Object)"getIntegrationManagerAuthentication", (Throwable)e);
                }
                integrationManagerAuthentication = configurazione == null || configurazione.getIntegrationManager() == null ? "ssl" : (configurazione.getIntegrationManager().getAutenticazione() == null ? "ssl" : configurazione.getIntegrationManager().getAutenticazione());
            }
            catch (Exception e) {
                integrationManagerAuthentication = "ssl";
            }
        }
        return integrationManagerAuthentication;
    }

    public ValidazioneContenutiApplicativi getTipoValidazioneContenutoApplicativo(String implementazionePdDSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        ValidazioneContenutiApplicativi valDefault = new ValidazioneContenutiApplicativi();
        valDefault.setStato("disabilitato");
        valDefault.setTipo("xsd");
        String stato = this.pddProperties.getValidazioneContenutiApplicativi_Stato(implementazionePdDSoggetto);
        String tipo = this.pddProperties.getValidazioneContenutiApplicativi_Tipo(implementazionePdDSoggetto);
        boolean pddPropertiesPresente = false;
        if (stato != null && ("abilitato".equalsIgnoreCase(stato) || "disabilitato".equalsIgnoreCase(stato) || "warningOnly".equalsIgnoreCase(stato))) {
            if ("abilitato".equalsIgnoreCase(stato)) {
                valDefault.setStato("abilitato");
            } else if ("disabilitato".equalsIgnoreCase(stato)) {
                valDefault.setStato("disabilitato");
            } else {
                valDefault.setStato("warningOnly");
            }
            pddPropertiesPresente = true;
        }
        if (tipo != null && ("wsdl".equalsIgnoreCase(stato) || "xsd".equalsIgnoreCase(stato) || "openspcoop".equalsIgnoreCase(stato))) {
            if ("wsdl".equalsIgnoreCase(stato)) {
                valDefault.setTipo("wsdl");
            } else if ("xsd".equalsIgnoreCase(stato)) {
                valDefault.setTipo("xsd");
            } else {
                valDefault.setTipo("openspcoop");
            }
            pddPropertiesPresente = true;
        }
        if (pddPropertiesPresente) {
            return valDefault;
        }
        if (this.configurazioneDinamica || validazioneContenutiApplicativi == null) {
            try {
                Configurazione configurazione = null;
                try {
                    configurazione = this.configurazionePdD.getConfigurazioneGenerale();
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("getTipoValidazioneContenutoApplicativo (not found): " + e.getMessage()));
                }
                catch (Exception e) {
                    this.log.debug((Object)"getTipoValidazioneContenutoApplicativo", (Throwable)e);
                }
                if (configurazione == null || configurazione.getValidazioneContenutiApplicativi() == null) {
                    validazioneContenutiApplicativi = valDefault;
                } else {
                    ValidazioneContenutiApplicativi val = new ValidazioneContenutiApplicativi();
                    if (configurazione.getValidazioneContenutiApplicativi().getStato() == null) {
                        val.setStato("disabilitato");
                    } else if ("abilitato".equals(configurazione.getValidazioneContenutiApplicativi().getStato())) {
                        val.setStato("abilitato");
                    } else if ("warningOnly".equals(configurazione.getValidazioneContenutiApplicativi().getStato())) {
                        val.setStato("warningOnly");
                    } else {
                        val.setStato("disabilitato");
                    }
                    if (configurazione.getValidazioneContenutiApplicativi().getTipo() == null) {
                        val.setTipo("xsd");
                    } else if ("wsdl".equals(configurazione.getValidazioneContenutiApplicativi().getTipo())) {
                        val.setTipo("wsdl");
                    } else if ("openspcoop".equals(configurazione.getValidazioneContenutiApplicativi().getTipo())) {
                        val.setTipo("openspcoop");
                    } else {
                        val.setTipo("xsd");
                    }
                    validazioneContenutiApplicativi = val;
                }
            }
            catch (Exception e) {
                validazioneContenutiApplicativi = valDefault;
            }
        }
        return validazioneContenutiApplicativi;
    }

    static {
        initialize = false;
        accessoRegistroServizi = null;
        accessoRegistroServiziLetto = false;
        tipoValidazione = null;
        isLivelloValidazioneNormale = null;
        isLivelloValidazioneRigido = null;
        validazioneProfiloCollaborazione = null;
        validazioneManifestAttachments = null;
        newConnectionForResponseSPCoop = null;
        utilizzoIndirizzoTelematico = null;
        gestioneManifestAttachments = null;
        timeoutRiscontro = null;
        livelloSPCoop_msgDiagnostici = null;
        livelloSPCoop_msgDiagnosticiJMX = null;
        livelloOpenSPCoop_msgDiagnostici = null;
        livelloOpenSPCoop_msgDiagnosticiJMX = null;
        severitaSPCoop_msgDiagnostici = null;
        severitaSPCoop_msgDiagnosticiJMX = null;
        severitaOpenSPCoop_msgDiagnostici = null;
        severitaOpenSPCoop_msgDiagnosticiJMX = null;
        openSPCoopAppender_MsgDiagnostici = null;
        openSPCoopAppender_MsgDiagnosticiLetto = false;
        dumpMessaggi = null;
        dumpMessaggiJMX = null;
        tracciamentoBusteEGovJMX = null;
        tracciamentoBusteEGov = null;
        openSPCoopAppender_Tracciamento = null;
        openSPCoopAppender_TracciamentoLetto = false;
        gestioneErroreConnettoreComponenteCooperazione = null;
        gestioneErroreConnettoreComponenteIntegrazione = null;
        integrationManagerAuthentication = null;
        validazioneContenutiApplicativi = null;
    }
}

