/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.services.OpenSPCoopStartup;

public class ClassNameProperties {
    private Logger log = OpenSPCoopStartup.initialize ? OpenSPCoopLogger.getLoggerOpenSPCoopCore() : Logger.getLogger((String)"ClassNameProperties");
    private Properties reader = new Properties();
    private static ClassNameProperties classNameProperties = null;

    public ClassNameProperties() throws Exception {
        InputStream properties = null;
        try {
            properties = ClassNameProperties.class.getResourceAsStream("/className.properties");
            this.reader.load(properties);
            properties.close();
        }
        catch (IOException e) {
            this.log.error((Object)("Riscontrato errore durante la lettura del file 'className.properties': \n\n" + e.getMessage()));
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception("ClassName initialize error: " + e.getMessage());
        }
    }

    public static boolean initialize() {
        try {
            classNameProperties = new ClassNameProperties();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static ClassNameProperties getInstance() {
        if (classNameProperties == null) {
            ClassNameProperties.initialize();
        }
        return classNameProperties;
    }

    public String getConnettore(String nome) {
        return this.reader.getProperty("org.openspcoop.connettore." + nome);
    }

    public String getAutenticazione(String nome) {
        return this.reader.getProperty("org.openspcoop.autenticazione." + nome);
    }

    public String getAutorizzazione(String nome) {
        return this.reader.getProperty("org.openspcoop.autorizzazione." + nome);
    }

    public String getAutorizzazioneSPCoop(String nome) {
        return this.reader.getProperty("org.openspcoop.autorizzazioneSPCoop." + nome);
    }

    public String getIntegrazionePortaDelegata(String nome) {
        return this.reader.getProperty("org.openspcoop.integrazione.pd." + nome);
    }

    public String getIntegrazionePortaApplicativa(String nome) {
        return this.reader.getProperty("org.openspcoop.integrazione.pa." + nome);
    }

    public String getJDBCAdapter(String nome) {
        return this.reader.getProperty("org.openspcoop.jdbcAdapter." + nome);
    }

    public String getThreshold(String nome) {
        return this.reader.getProperty("org.openspcoop.threshold." + nome);
    }

    public String getMsgDiagnosticoOpenSPCoopAppender(String nome) {
        return this.reader.getProperty("org.openspcoop.msgdiagnosticoAppender." + nome);
    }

    public String getTracciamentoOpenSPCoopAppender(String nome) {
        return this.reader.getProperty("org.openspcoop.tracciamentoAppender." + nome);
    }

    public String getNodeReceiver(String nome) {
        return this.reader.getProperty("org.openspcoop.nodeReceiver." + nome);
    }

    public String getNodeSender(String nome) {
        return this.reader.getProperty("org.openspcoop.nodeSender." + nome);
    }

    public String getRepositoryEGov(String nome) {
        return this.reader.getProperty("org.openspcoop.repositoryEGov." + nome);
    }

    public String getSQLQueryObject(String nome) {
        return this.reader.getProperty("org.openspcoop.sqlQueryObject." + nome);
    }

    public String getDateManager(String nome) {
        return this.reader.getProperty("org.openspcoop.date." + nome);
    }

    public String getNotificaTempiAttraversamentoPdD(String nome) {
        return this.reader.getProperty("org.openspcoop.monitor.misurazioneTempi." + nome);
    }
}

