/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.lib.mvc.properties.test;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.openspcoop2.core.mvc.properties.Config;
import org.openspcoop2.core.mvc.properties.provider.ExternalResources;
import org.openspcoop2.core.mvc.properties.utils.DBPropertiesUtils;
import org.openspcoop2.core.mvc.properties.utils.XSDValidator;
import org.openspcoop2.core.mvc.properties.utils.serializer.JaxbDeserializer;
import org.openspcoop2.pdd.core.byok.DriverBYOKUtilities;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.xml.AbstractValidatoreXSD;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.byok.LockUtilities;
import org.openspcoop2.web.lib.mvc.properties.beans.BaseItemBean;
import org.openspcoop2.web.lib.mvc.properties.beans.ConfigBean;
import org.openspcoop2.web.lib.mvc.properties.utils.ReadPropertiesUtilities;
import org.slf4j.Logger;

public class Test {
    public static void main(String[] args) {
        try {
            System.out.println("TEST CONFIG 1");
            DriverBYOKUtilities driverBYOKUtilities = new DriverBYOKUtilities(false, null, null);
            LockUtilities lockUtilities = new LockUtilities(driverBYOKUtilities, false, null, null, null, null, false);
            File f = new File(Test.class.getResource("Test.xml").toURI());
            System.out.println("Validazione XSD del file in corso...");
            AbstractValidatoreXSD validator = XSDValidator.getXSDValidator((Logger)LoggerWrapperFactory.getLogger(Test.class));
            validator.valida(f);
            System.out.println("Validazione XSD della configurazione completata con successo");
            JaxbDeserializer xmlReader = new JaxbDeserializer();
            Config configDaFile = xmlReader.readConfig(f);
            System.out.println("Check Config JAVA Exists [" + (configDaFile != null) + "]");
            Map mapDB = null;
            Map mappaDB = DBPropertiesUtils.toMultiMap(mapDB, ReadPropertiesUtilities.getListaNomiProperties(configDaFile));
            ExternalResources externalResources = null;
            ConfigBean configurazioneAdd = ReadPropertiesUtilities.leggiConfigurazione(configDaFile, mappaDB, externalResources);
            System.out.println("ConfigurazioneAdd Resolve Conditions");
            configurazioneAdd.updateConfigurazione(configDaFile);
            System.out.println("ConfigurazioneAdd IN Pagina: ");
            HashMap<String, String> mapNameValue = new HashMap<String, String>();
            for (BaseItemBean<?> baseItemBean : configurazioneAdd.getListaItem()) {
                DataElement dataElement = baseItemBean.toDataElement(configurazioneAdd, mapNameValue, externalResources, lockUtilities);
                System.out.println("Item [" + dataElement.getName() + "] Type [" + dataElement.getType() + "] Label [" + dataElement.getLabel() + "] Value [" + dataElement.getValue() + "]");
            }
            System.out.println("----------------------");
            System.out.println("Simulazione POSTBACK");
            configurazioneAdd.setValueFromRequest("usernameAction", "abilitato", externalResources, lockUtilities);
            configurazioneAdd.setValueFromRequest("keystoreType", "pkcs12", externalResources, lockUtilities);
            System.out.println("ConfigurazioneAdd Resolve Conditions POSTBACK");
            configurazioneAdd.updateConfigurazione(configDaFile);
            System.out.println("ConfigurazioneAdd IN Pagina: ");
            mapNameValue = new HashMap();
            for (BaseItemBean<?> baseItemBean : configurazioneAdd.getListaItem()) {
                DataElement dataElement = baseItemBean.toDataElement(configurazioneAdd, mapNameValue, externalResources, lockUtilities);
                if (dataElement.getType().equals(DataElementType.CHECKBOX.toString()) || dataElement.getType().equals(DataElementType.SELECT.toString())) {
                    System.out.println("Item [" + dataElement.getName() + "] Type [" + dataElement.getType() + "] Label [" + dataElement.getLabel() + "] SelectedValue [" + dataElement.getSelected() + "]");
                    continue;
                }
                System.out.println("Item [" + dataElement.getName() + "] Type [" + dataElement.getType() + "] Label [" + dataElement.getLabel() + "] Value [" + dataElement.getValue() + "]");
            }
            System.out.println("----------------------");
            System.out.println("Simulazione EDIT FINALE ADD ---> Clicco SALVA....");
            configurazioneAdd.setValueFromRequest("usernameAction", "abilitato", externalResources, lockUtilities);
            configurazioneAdd.setValueFromRequest("keystoreType", "pkcs12", externalResources, lockUtilities);
            configurazioneAdd.setValueFromRequest("keystore", "/tmp/keystoreAdd.jks", externalResources, lockUtilities);
            configurazioneAdd.setValueFromRequest("encryptAction", "abilitato", externalResources, lockUtilities);
            configurazioneAdd.setValueFromRequest("encryptSignatureAction", "abilitato", externalResources, lockUtilities);
            System.out.println("Simulazione EDIT FINALE ADD ---> Validazione Input utente");
            configurazioneAdd.validazioneInputUtente("nome", "descrizione", configDaFile, externalResources);
            System.out.println("----------------------");
            mappaDB = configurazioneAdd.getPropertiesMap();
            System.out.println("Values --> MAP Parziale:");
            for (String string : mappaDB.keySet()) {
                System.out.println("Contenuto Mappa [" + string + "]:  ");
                Properties properties = mappaDB.get(string);
                for (Object propKey : properties.keySet()) {
                    System.out.println("Item [" + propKey + "] Value [" + properties.get(propKey) + "]");
                }
                System.out.println("----------------------");
            }
            System.out.println("MAP Parziale --> MAP DB:");
            mapDB = DBPropertiesUtils.toMap(mappaDB);
            for (String string : mapDB.keySet()) {
                System.out.println("Item [" + string + "] Value [" + (String)mapDB.get(string) + "]");
            }
            System.out.println("----------------------\n\n\n\n\n\n\n\n\n\n\n");
            System.out.println("Ricarico configurazione da DB ");
            System.out.println("MAP DB --> MAP Parziale:");
            mappaDB = DBPropertiesUtils.toMultiMap((Map)mapDB);
            for (String string : mappaDB.keySet()) {
                System.out.println("Contenuto Mappa [" + string + "]:  ");
                Properties properties = (Properties)mappaDB.get(string);
                for (Object propKey : properties.keySet()) {
                    System.out.println("Item [" + propKey + "] Value [" + properties.get(propKey) + "]");
                }
                System.out.println("----------------------");
            }
            System.out.println("Ricarico configurazione da DB ");
            ConfigBean configurazioneChange = ReadPropertiesUtilities.leggiConfigurazione(configDaFile, mappaDB, externalResources);
            System.out.println("----------------------");
            System.out.println("configurazioneChange Resolve Conditions");
            configurazioneChange.setValueFromRequest("keystoreType", "jks", externalResources, lockUtilities);
            configurazioneChange.setValueFromRequest("keystore", "/tmp/keystore.jks", externalResources, lockUtilities);
            configurazioneChange.setValueFromRequest("timeToLive", "120", externalResources, lockUtilities);
            configurazioneChange.updateConfigurazione(configDaFile);
            System.out.println("configurazioneChange IN Pagina: ");
            mapNameValue = new HashMap();
            for (BaseItemBean<?> baseItemBean : configurazioneChange.getListaItem()) {
                DataElement de2 = baseItemBean.toDataElement(configurazioneAdd, mapNameValue, externalResources, lockUtilities);
                if (de2.getType().equals(DataElementType.CHECKBOX.toString()) || de2.getType().equals(DataElementType.SELECT.toString())) {
                    System.out.println("Item [" + de2.getName() + "] Type [" + de2.getType() + "] Label [" + de2.getLabel() + "] SelectedValue [" + de2.getSelected() + "]");
                    continue;
                }
                System.out.println("Item [" + de2.getName() + "] Type [" + de2.getType() + "] Label [" + de2.getLabel() + "] Value [" + de2.getValue() + "]");
            }
            System.out.println("Simulazione EDIT FINALE CHANGE ---> Validazione Input utente");
            configurazioneChange.validazioneInputUtente("nome", "descrizione", configDaFile, externalResources);
            System.out.println("----------------------");
            Map<String, Properties> map = configurazioneChange.getPropertiesMap();
            System.out.println("Values --> MAP Parziale:");
            for (String mapKey : map.keySet()) {
                System.out.println("Contenuto Mappa [" + mapKey + "]:  ");
                Properties properties2 = map.get(mapKey);
                for (Object propKey : properties2.keySet()) {
                    System.out.println("Item [" + propKey + "] Value [" + properties2.get(propKey) + "]");
                }
                System.out.println("----------------------");
            }
            System.out.println("MAP Parziale --> MAP DB:");
            mapDB = DBPropertiesUtils.toMap(map);
            for (String propKey : mapDB.keySet()) {
                System.out.println("Item [" + propKey + "] Value [" + (String)mapDB.get(propKey) + "]");
            }
            System.out.println("----------------------");
            System.out.println("TEST CONFIG 1 FINE ");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

