/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.lib.mvc;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class Parameter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String value;

    public Parameter() {
    }

    public Parameter(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public Parameter(String name, String baseUrl, Parameter ... parameter) {
        this.name = name;
        StringBuilder sb = new StringBuilder();
        sb.append(baseUrl);
        if (parameter != null && parameter.length > 0) {
            sb.append("?");
            for (int i = 0; i < parameter.length; ++i) {
                sb.append(parameter[i].toString());
                if (i >= parameter.length - 1) continue;
                sb.append("&");
            }
        }
        this.value = sb.toString().replaceAll(" ", "%20");
    }

    public Parameter(String name, String baseUrl, List<Parameter> parameterList) {
        this(name, baseUrl, parameterList.toArray(new Parameter[parameterList.size()]));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String val = null;
        if (this.value != null) {
            try {
                val = URLEncoder.encode(this.value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                val = this.value;
            }
        } else {
            val = "";
        }
        sb.append(this.name).append("=").append(val);
        return sb.toString();
    }

    public static String estraiPathDaUrl(String url) {
        if (url.contains("?")) {
            return url.substring(0, url.indexOf("?"));
        }
        return url;
    }

    public static List<Parameter> estraiParametriDaUrl(String url) {
        String queryString;
        String[] pair;
        ArrayList<Parameter> lista = new ArrayList<Parameter>();
        if (url.contains("?") && (pair = (queryString = url.substring(url.indexOf("?") + 1)).split("&")) != null && pair.length > 0) {
            for (String pairTmp : pair) {
                String[] coppia = pairTmp.split("=");
                if (coppia == null || coppia.length <= 0) continue;
                String key = coppia[0];
                String val = "";
                if (coppia.length == 2) {
                    val = coppia[1];
                }
                lista.add(new Parameter(key, val));
            }
        }
        return lista;
    }
}

