/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime.logic;

import org.tp23.antinstaller.input.ResultContainer;
import org.tp23.antinstaller.runtime.ConfigurationException;
import org.tp23.antinstaller.runtime.logic.Expression;
import org.tp23.antinstaller.runtime.logic.LiteralValue;
import org.tp23.antinstaller.runtime.logic.Value;
import org.tp23.antinstaller.runtime.logic.ValuesTest;
import org.tp23.antinstaller.runtime.logic.VariableValue;

public class SimpleExpression
implements Expression {
    private final Value value1;
    private final ValuesTest testCondition;
    private final Value value2;
    private final String literalValue1;
    private final String literalValue2;

    public SimpleExpression(ResultContainer resultContainer, String value1, ValuesTest test, String value2) throws ConfigurationException {
        this.literalValue1 = value1;
        this.value1 = this.getValue(resultContainer, value1);
        this.testCondition = test;
        this.literalValue2 = value2;
        this.value2 = this.getValue(resultContainer, value2);
    }

    public boolean evaluate() {
        return this.testCondition.getTestResult(this.value1, this.value2);
    }

    private Value getValue(ResultContainer container, String valueStr) throws ConfigurationException {
        if (valueStr.length() > 0 && valueStr.charAt(0) == '$') {
            if (valueStr.startsWith("${") && valueStr.endsWith("}")) {
                return new VariableValue(container, valueStr);
            }
            throw new ConfigurationException("Badly formed variable: '" + valueStr + "'");
        }
        return new LiteralValue(valueStr);
    }

    public String toString() {
        return "[" + this.literalValue1 + "==" + this.literalValue2 + "]";
    }
}

