/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.utils;

import java.util.Properties;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.utils.LoaderProperties;
import org.openspcoop2.utils.Utilities;

public class ServerProperties {
    private LoaderProperties loader = null;

    public ServerProperties(String filePropertiesName) throws ServiceException {
        this.loader = new LoaderProperties(filePropertiesName);
    }

    public ServerProperties(Properties properties) throws ServiceException {
        this.loader = new LoaderProperties(properties);
    }

    public String getProperty(String name, boolean required) throws ServiceException {
        String tmp = this.loader.getProperties().getProperty(name);
        if (tmp == null) {
            if (required) {
                throw new ServiceException("Property [" + name + "] not found");
            }
            return null;
        }
        return tmp.trim();
    }

    public Properties readProperties(String prefix) throws ServiceException {
        try {
            return Utilities.readProperties((String)prefix, (Properties)this.loader.getProperties());
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    public boolean getBooleanProperty(String name, boolean required) throws ServiceException {
        String p = this.getProperty(name, required);
        return "true".equalsIgnoreCase(p);
    }
}

