/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.expression.impl.sql;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.openspcoop2.generic_project.beans.FunctionField;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.beans.IModel;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.expression.LikeMode;
import org.openspcoop2.generic_project.expression.impl.BetweenExpressionImpl;
import org.openspcoop2.generic_project.expression.impl.Comparator;
import org.openspcoop2.generic_project.expression.impl.ComparatorExpressionImpl;
import org.openspcoop2.generic_project.expression.impl.ConjunctionExpressionImpl;
import org.openspcoop2.generic_project.expression.impl.InExpressionImpl;
import org.openspcoop2.generic_project.expression.impl.LikeExpressionImpl;
import org.openspcoop2.generic_project.expression.impl.PaginatedExpressionImpl;
import org.openspcoop2.generic_project.expression.impl.formatter.IObjectFormatter;
import org.openspcoop2.generic_project.expression.impl.sql.BetweenExpressionSQL;
import org.openspcoop2.generic_project.expression.impl.sql.ComparatorExpressionSQL;
import org.openspcoop2.generic_project.expression.impl.sql.ConjunctionExpressionSQL;
import org.openspcoop2.generic_project.expression.impl.sql.ExpressionSQL;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLExpression;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLFieldConverter;
import org.openspcoop2.generic_project.expression.impl.sql.InExpressionSQL;
import org.openspcoop2.generic_project.expression.impl.sql.LikeExpressionSQL;
import org.openspcoop2.generic_project.expression.impl.sql.SQLMode;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.sql.ISQLQueryObject;

public class PaginatedExpressionSQL
extends PaginatedExpressionImpl {
    private boolean throwExpressionNotInitialized = false;
    private TipiDatabase databaseType;
    private ISQLFieldConverter sqlFieldConverter;
    private boolean usedForCountExpression = false;
    private List<Object> fieldsManuallyAdd = new ArrayList<Object>();
    private boolean checkFieldManuallyAdd = true;

    public TipiDatabase getDatabaseType() {
        return this.databaseType;
    }

    public ISQLFieldConverter getSqlFieldConverter() {
        return this.sqlFieldConverter;
    }

    public void setSqlFieldConverter(ISQLFieldConverter sqlFieldConverter) {
        this.sqlFieldConverter = sqlFieldConverter;
    }

    public boolean isUsedForCountExpression() {
        return this.usedForCountExpression;
    }

    public void setUsedForCountExpression(boolean usedForCountExpression) {
        this.usedForCountExpression = usedForCountExpression;
    }

    public PaginatedExpressionSQL(ISQLFieldConverter sqlFieldConverter) throws ExpressionException {
        this.sqlFieldConverter = sqlFieldConverter;
        if (this.sqlFieldConverter != null) {
            this.databaseType = this.sqlFieldConverter.getDatabaseType();
        }
    }

    public PaginatedExpressionSQL(ISQLFieldConverter sqlFieldConverter, IObjectFormatter objectFormatter) throws ExpressionException {
        super(objectFormatter);
        this.sqlFieldConverter = sqlFieldConverter;
        if (this.sqlFieldConverter != null) {
            this.databaseType = this.sqlFieldConverter.getDatabaseType();
        }
    }

    public PaginatedExpressionSQL(ExpressionSQL expression) throws ExpressionException {
        super(expression);
        this.sqlFieldConverter = expression.getSqlFieldConverter();
        this.fieldsManuallyAdd = expression.getFieldsManuallyAdd();
        if (this.sqlFieldConverter != null) {
            this.databaseType = this.sqlFieldConverter.getDatabaseType();
        }
    }

    public List<Object> getFieldsManuallyAdd() {
        return this.fieldsManuallyAdd;
    }

    public void removeFieldManuallyAdd(Object o) {
        if (this.fieldsManuallyAdd.contains(o)) {
            this.fieldsManuallyAdd.remove(o);
        }
    }

    public void setCheckFieldManuallyAdd(boolean checkFieldManuallyAdd) {
        this.checkFieldManuallyAdd = checkFieldManuallyAdd;
    }

    @Override
    public boolean inUseField(IField field, boolean checkOnlyWhereCondition) throws ExpressionNotImplementedException, ExpressionException {
        return ExpressionSQL.inUse(field, checkOnlyWhereCondition, super.inUseField(field, checkOnlyWhereCondition), this.getFieldsManuallyAdd(), this.checkFieldManuallyAdd);
    }

    @Override
    public boolean inUseModel(IModel<?> model, boolean checkOnlyWhereCondition) throws ExpressionNotImplementedException, ExpressionException {
        return ExpressionSQL.inUse(model, checkOnlyWhereCondition, super.inUseModel(model, checkOnlyWhereCondition), this.getFieldsManuallyAdd(), this.checkFieldManuallyAdd);
    }

    @Override
    public List<IField> getFields(boolean onlyWhereCondition) throws ExpressionNotImplementedException, ExpressionException {
        return ExpressionSQL.getFields(onlyWhereCondition, super.getFields(onlyWhereCondition), this.getFieldsManuallyAdd(), this.checkFieldManuallyAdd);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String toSql_engine(SQLMode mode, List<Object> oggettiPreparedStatement, Hashtable<String, Object> oggettiJPA) throws ExpressionException {
        ISQLExpression sqlExpression = null;
        if (this.expressionEngine != null) {
            if (!(this.expressionEngine instanceof ISQLExpression)) throw new ExpressionException("ExpressioneEngine (type:" + this.expressionEngine.getClass().getName() + ") is not as cast with " + ISQLExpression.class.getName());
            sqlExpression = (ISQLExpression)((Object)this.expressionEngine);
        } else if (this.throwExpressionNotInitialized) {
            throw new ExpressionException("Expression is not initialized");
        }
        String s = null;
        if (this.expressionEngine != null) {
            switch (mode) {
                case STANDARD: {
                    s = sqlExpression.toSql();
                    break;
                }
                case PREPARED_STATEMENT: {
                    s = sqlExpression.toSqlPreparedStatement(oggettiPreparedStatement);
                    break;
                }
                case JPA: {
                    s = sqlExpression.toSqlJPA(oggettiJPA);
                }
            }
        } else {
            s = "";
        }
        StringBuffer bf = new StringBuffer();
        bf.append(s);
        bf.append(ExpressionSQL.sqlGroupBy(this.sqlFieldConverter, this.getGroupByFields()));
        bf.append(ExpressionSQL.sqlOrder(this.sqlFieldConverter, this.getSortOrder(), this.getOrderedFields()));
        if (SQLMode.JPA.equals((Object)mode)) return bf.toString();
        if (this.getLimit() != null && this.getLimit() >= 0) {
            bf.append(" LIMIT " + this.getLimit());
        }
        if (this.getOffset() == null || this.getOffset() < 0) return bf.toString();
        bf.append(" OFFSET " + this.getOffset());
        return bf.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void toSql_engine(ISQLQueryObject sqlQueryObject, SQLMode mode, List<Object> oggettiPreparedStatement, Hashtable<String, Object> oggettiJPA) throws ExpressionException {
        ISQLExpression sqlExpression = null;
        if (this.expressionEngine != null) {
            if (!(this.expressionEngine instanceof ISQLExpression)) throw new ExpressionException("ExpressioneEngine (type:" + this.expressionEngine.getClass().getName() + ") is not as cast with " + ISQLExpression.class.getName());
            sqlExpression = (ISQLExpression)((Object)this.expressionEngine);
        } else if (this.throwExpressionNotInitialized) {
            throw new ExpressionException("Expression is not initialized");
        }
        if (this.expressionEngine != null) {
            switch (mode) {
                case STANDARD: {
                    sqlExpression.toSql(sqlQueryObject);
                    break;
                }
                case PREPARED_STATEMENT: {
                    sqlExpression.toSqlPreparedStatement(sqlQueryObject, oggettiPreparedStatement);
                    break;
                }
                case JPA: {
                    sqlExpression.toSqlJPA(sqlQueryObject, oggettiJPA);
                }
            }
        }
        try {
            ExpressionSQL.sqlGroupBy(this.sqlFieldConverter, sqlQueryObject, this.getGroupByFields());
            ExpressionSQL.sqlOrder(this.sqlFieldConverter, sqlQueryObject, this.getSortOrder(), this.getOrderedFields(), this.getGroupByFields());
            ExpressionSQL.sqlGroupBySelectField(this.sqlFieldConverter, sqlQueryObject, this.getFieldsManuallyAdd(), this.getGroupByFields(), this.usedForCountExpression);
            if (SQLMode.JPA.equals((Object)mode)) return;
            if (this.getLimit() != null && this.getLimit() >= 0) {
                sqlQueryObject.setLimit(this.getLimit().intValue());
            }
            if (this.getOffset() == null || this.getOffset() < 0) return;
            sqlQueryObject.setOffset(this.getOffset().intValue());
            return;
        }
        catch (Exception e) {
            throw new ExpressionException(e);
        }
    }

    public String toSql() throws ExpressionException {
        return this.toSql_engine(SQLMode.STANDARD, null, null);
    }

    protected String toSqlPreparedStatement(List<Object> oggetti) throws ExpressionException {
        return this.toSql_engine(SQLMode.PREPARED_STATEMENT, oggetti, null);
    }

    protected String toSqlJPA(Hashtable<String, Object> oggetti) throws ExpressionException {
        return this.toSql_engine(SQLMode.JPA, null, oggetti);
    }

    public void toSql(ISQLQueryObject sqlQueryObject) throws ExpressionException {
        this.toSql_engine(sqlQueryObject, SQLMode.STANDARD, null, null);
    }

    public void toSqlWithFromCondition(ISQLQueryObject sqlQueryObject, String tableNamePrincipale) throws ExpressionException, ExpressionNotImplementedException {
        this.toSql(sqlQueryObject);
        ExpressionSQL.sqlFrom(sqlQueryObject, this.getFields(false), this.getSqlFieldConverter(), tableNamePrincipale, this.getFieldsManuallyAdd(), this.getOrderedFields(), this.getGroupByFields());
    }

    protected void toSqlPreparedStatement(ISQLQueryObject sqlQueryObject, List<Object> oggetti) throws ExpressionException {
        this.toSql_engine(sqlQueryObject, SQLMode.PREPARED_STATEMENT, oggetti, null);
    }

    protected void toSqlPreparedStatementWithFromCondition(ISQLQueryObject sqlQueryObject, List<Object> oggetti, String tableNamePrincipale) throws ExpressionException, ExpressionNotImplementedException {
        this.toSqlPreparedStatement(sqlQueryObject, oggetti);
        ExpressionSQL.sqlFrom(sqlQueryObject, this.getFields(false), this.getSqlFieldConverter(), tableNamePrincipale, this.getFieldsManuallyAdd(), this.getOrderedFields(), this.getGroupByFields());
    }

    protected void toSqlJPA(ISQLQueryObject sqlQueryObject, Hashtable<String, Object> oggetti) throws ExpressionException {
        this.toSql_engine(sqlQueryObject, SQLMode.JPA, null, oggetti);
    }

    protected void toSqlJPAWithFromCondition(ISQLQueryObject sqlQueryObject, Hashtable<String, Object> oggetti, String tableNamePrincipale) throws ExpressionException, ExpressionNotImplementedException {
        this.toSqlJPA(sqlQueryObject, oggetti);
        ExpressionSQL.sqlFrom(sqlQueryObject, this.getFields(false), this.getSqlFieldConverter(), tableNamePrincipale, this.getFieldsManuallyAdd(), this.getOrderedFields(), this.getGroupByFields());
    }

    public void addField(ISQLQueryObject sqlQueryObject, IField field, boolean appendTablePrefix) throws ExpressionException {
        ExpressionSQL.addField_engine(sqlQueryObject, this.getSqlFieldConverter(), field, null, appendTablePrefix);
        this.getFieldsManuallyAdd().add(field);
    }

    public void addField(ISQLQueryObject sqlQueryObject, IField field, String aliasField, boolean appendTablePrefix) throws ExpressionException {
        ExpressionSQL.addField_engine(sqlQueryObject, this.getSqlFieldConverter(), field, aliasField, appendTablePrefix);
        this.getFieldsManuallyAdd().add(field);
    }

    public void addAliasField(ISQLQueryObject sqlQueryObject, IField field, boolean appendTablePrefix) throws ExpressionException {
        ExpressionSQL.addAliasField_engine(sqlQueryObject, this.getSqlFieldConverter(), field, null, appendTablePrefix);
        this.getFieldsManuallyAdd().add(field);
    }

    public void addField(ISQLQueryObject sqlQueryObject, FunctionField field, boolean appendTablePrefix) throws ExpressionException {
        ExpressionSQL.addField_engine(sqlQueryObject, this.getSqlFieldConverter(), field, null, appendTablePrefix);
        this.getFieldsManuallyAdd().add(field);
    }

    @Override
    protected ComparatorExpressionImpl getComparatorExpression(IField field, Object value, Comparator c) throws ExpressionException {
        return new ComparatorExpressionSQL(this.sqlFieldConverter, this.objectFormatter, field, value, c);
    }

    @Override
    protected BetweenExpressionImpl getBetweenExpression(IField field, Object lower, Object high) throws ExpressionException {
        return new BetweenExpressionSQL(this.sqlFieldConverter, this.objectFormatter, field, lower, high);
    }

    @Override
    protected InExpressionImpl getInExpression(IField field, Object ... values) throws ExpressionException {
        ArrayList<Object> lista = new ArrayList<Object>();
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                lista.add(values[i]);
            }
        }
        return new InExpressionSQL(this.sqlFieldConverter, this.objectFormatter, field, lista);
    }

    @Override
    protected LikeExpressionImpl getLikeExpression(IField field, String value, LikeMode mode, boolean caseInsensitive) throws ExpressionException {
        return new LikeExpressionSQL(this.sqlFieldConverter, this.objectFormatter, field, value, mode, caseInsensitive);
    }

    @Override
    protected ConjunctionExpressionImpl getConjunctionExpression() throws ExpressionException {
        return new ConjunctionExpressionSQL(this.sqlFieldConverter, this.objectFormatter);
    }
}

