/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.expression.impl.sql;

import java.util.Hashtable;
import java.util.List;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.expression.impl.InExpressionImpl;
import org.openspcoop2.generic_project.expression.impl.formatter.IObjectFormatter;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLExpression;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLFieldConverter;
import org.openspcoop2.generic_project.expression.impl.sql.SQLMode;
import org.openspcoop2.generic_project.utils.IDGenerator;
import org.openspcoop2.utils.sql.ISQLQueryObject;

public class InExpressionSQL
extends InExpressionImpl
implements ISQLExpression {
    private ISQLFieldConverter sqlFieldConverter;

    public InExpressionSQL(ISQLFieldConverter sqlFieldConverter, IObjectFormatter objectFormatter, IField field, List<Object> objects) {
        super(objectFormatter, field, objects);
        this.sqlFieldConverter = sqlFieldConverter;
    }

    public String toSql_engine(SQLMode mode, List<Object> oggettiPreparedStatement, Hashtable<String, Object> oggettiJPA) throws ExpressionException {
        StringBuffer bf = new StringBuffer();
        if (this.isNot()) {
            bf.append("( NOT ");
        }
        bf.append("( ");
        bf.append(this.sqlFieldConverter.toColumn(this.getField(), true));
        bf.append(" IN (");
        block7: for (int i = 0; i < this.getObjects().size(); ++i) {
            bf.append(" ");
            if (i > 0) {
                bf.append(", ");
            }
            switch (mode) {
                case STANDARD: {
                    try {
                        bf.append(super.getObjectFormatter().toSQLString(this.getObjects().get(i)));
                        continue block7;
                    }
                    catch (Exception e) {
                        return "ERROR[" + i + "]: " + e.getMessage();
                    }
                }
                case PREPARED_STATEMENT: {
                    bf.append("?");
                    oggettiPreparedStatement.add(this.getObjects().get(i));
                    continue block7;
                }
                case JPA: {
                    String id = "o" + i + "_" + IDGenerator.getUniqueID(this.getField());
                    bf.append(":" + id);
                    oggettiJPA.put(id, this.getObjects().get(i));
                }
            }
        }
        bf.append(" )");
        bf.append(" )");
        if (this.isNot()) {
            bf.append(" )");
        }
        return bf.toString();
    }

    public void toSql_engine(ISQLQueryObject sqlQueryObject, SQLMode mode, List<Object> oggettiPreparedStatement, Hashtable<String, Object> oggettiJPA) throws ExpressionException {
        try {
            String s = this.toSql_engine(mode, oggettiPreparedStatement, oggettiJPA);
            s = s.substring(1, s.length() - 2);
            sqlQueryObject.addWhereCondition(s);
        }
        catch (Exception e) {
            throw new ExpressionException(e);
        }
    }

    @Override
    public String toSql() throws ExpressionException {
        return this.toSql_engine(SQLMode.STANDARD, null, null);
    }

    @Override
    public String toSqlPreparedStatement(List<Object> oggetti) throws ExpressionException {
        return this.toSql_engine(SQLMode.PREPARED_STATEMENT, oggetti, null);
    }

    @Override
    public String toSqlJPA(Hashtable<String, Object> oggetti) throws ExpressionException {
        return this.toSql_engine(SQLMode.JPA, null, oggetti);
    }

    @Override
    public void toSql(ISQLQueryObject sqlQueryObject) throws ExpressionException {
        this.toSql_engine(sqlQueryObject, SQLMode.STANDARD, null, null);
    }

    @Override
    public void toSqlPreparedStatement(ISQLQueryObject sqlQueryObject, List<Object> oggetti) throws ExpressionException {
        this.toSql_engine(sqlQueryObject, SQLMode.PREPARED_STATEMENT, oggetti, null);
    }

    @Override
    public void toSqlJPA(ISQLQueryObject sqlQueryObject, Hashtable<String, Object> oggetti) throws ExpressionException {
        this.toSql_engine(sqlQueryObject, SQLMode.JPA, null, oggetti);
    }
}

