/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.expression.impl.formatter;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.expression.impl.formatter.BooleanTypeFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.ByteArrayTypeFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.ByteTypeFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.CalendarTypeFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.CharacterTypeFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.DateTypeFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.DoubleTypeFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.EnumTypeFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.FloatTypeFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.IObjectFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.ITypeFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.IntegerTypeFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.LongTypeFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.ShortTypeFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.StringTypeFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.TimestampTypeFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.URITypeFormatter;
import org.openspcoop2.utils.TipiDatabase;

public class ObjectFormatter
implements IObjectFormatter {
    private List<ITypeFormatter<?>> typesFormatter = new ArrayList();

    public ObjectFormatter() throws ExpressionException {
        try {
            this.typesFormatter.add(new BooleanTypeFormatter());
            this.typesFormatter.add(new CalendarTypeFormatter());
            this.typesFormatter.add(new DateTypeFormatter());
            this.typesFormatter.add(new TimestampTypeFormatter());
            this.typesFormatter.add(new CharacterTypeFormatter());
            this.typesFormatter.add(new StringTypeFormatter());
            this.typesFormatter.add(new ByteTypeFormatter());
            this.typesFormatter.add(new ShortTypeFormatter());
            this.typesFormatter.add(new IntegerTypeFormatter());
            this.typesFormatter.add(new LongTypeFormatter());
            this.typesFormatter.add(new DoubleTypeFormatter());
            this.typesFormatter.add(new FloatTypeFormatter());
            this.typesFormatter.add(new EnumTypeFormatter());
            this.typesFormatter.add(new URITypeFormatter());
            this.typesFormatter.add(new ByteArrayTypeFormatter());
        }
        catch (Exception e) {
            throw new ExpressionException(e);
        }
    }

    public ObjectFormatter(ITypeFormatter<?> ... types) {
        for (int i = 0; i < types.length; ++i) {
            this.typesFormatter.add(types[i]);
        }
    }

    @Override
    public void isSupported(Object o) throws ExpressionException {
        boolean supported = false;
        for (ITypeFormatter<?> type : this.typesFormatter) {
            try {
                o.getClass().asSubclass(type.getTypeSupported());
                supported = true;
                break;
            }
            catch (Exception e) {
            }
        }
        if (!supported) {
            this.throwTypeUnsupported(o);
        }
    }

    @Override
    public String toString(Object o) throws ExpressionException {
        for (ITypeFormatter<?> type : this.typesFormatter) {
            boolean isType = false;
            try {
                o.getClass().asSubclass(type.getTypeSupported());
                isType = true;
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!isType) continue;
            return type.toString(o);
        }
        this.throwTypeUnsupported(o);
        return null;
    }

    @Override
    public String toSQLString(Object o) throws ExpressionException {
        return this.toSQLString(o, TipiDatabase.DEFAULT);
    }

    @Override
    public String toSQLString(Object o, TipiDatabase databaseType) throws ExpressionException {
        for (ITypeFormatter<?> type : this.typesFormatter) {
            boolean isType = false;
            try {
                o.getClass().asSubclass(type.getTypeSupported());
                isType = true;
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!isType) continue;
            return type.toSQLString(o, databaseType);
        }
        this.throwTypeUnsupported(o);
        return null;
    }

    @Override
    public Object toObject(String o, Class<?> c) throws ExpressionException {
        for (ITypeFormatter<?> type : this.typesFormatter) {
            boolean isType = false;
            try {
                c.asSubclass(type.getTypeSupported());
                isType = true;
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!isType) continue;
            type.toObject(o, c);
        }
        this.throwTypeUnsupported(c);
        return null;
    }

    private void throwTypeUnsupported(Object o) throws ExpressionException {
        StringBuffer bf = new StringBuffer();
        for (ITypeFormatter<?> type : this.typesFormatter) {
            if (bf.length() > 0) {
                bf.append(" , ");
            }
            bf.append(type.getTypeSupported());
        }
        throw new ExpressionException("Unsupported [" + o.getClass().getName() + "] type. Supported types are: " + bf.toString());
    }
}

